(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    985197,      15244]
NotebookOptionsPosition[    983681,      15194]
NotebookOutlinePosition[    984208,      15213]
CellTagsIndexPosition[    984165,      15210]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 StyleBox["Radio-Sky Spectrograph Color File Generator",
  FontFamily->"Arial",
  FontSize->16,
  FontColor->RGBColor[0., 0., 0.5019607843137255]],
 StyleBox["\n",
  FontFamily->"Arial",
  FontColor->RGBColor[0., 0., 0.5019607843137255]],
 StyleBox["Dave Typinski, AJ4CO\nAugust, 2010\nModified 11 May 2018 for use \
with Autoplot",
  FontFamily->"Arial",
  FontSize->12,
  FontColor->RGBColor[0., 0., 0.]]
}], "Section",
 CellChangeTimes->{{3.415142998108*^9, 3.415143001967375*^9}, 
   3.4351591269907503`*^9, {3.4351592552720003`*^9, 3.4351592598032503`*^9}, {
   3.4351617626001253`*^9, 3.4351617667251253`*^9}, {3.4351660682876253`*^9, 
   3.4351660685688753`*^9}, {3.435713360234375*^9, 3.43571336696875*^9}, {
   3.43571339990625*^9, 3.43571341384375*^9}, {3.4699089678346252`*^9, 
   3.4699090149752502`*^9}, {3.4700022492043753`*^9, 
   3.4700023042825003`*^9}, {3.4700035004387503`*^9, 
   3.4700035059231253`*^9}, {3.4700959250508747`*^9, 
   3.4700959335352497`*^9}, {3.490325934848625*^9, 3.4903259797705*^9}, {
   3.490326017129875*^9, 3.490326040879875*^9}, {3.735067447293322*^9, 
   3.73506748193439*^9}},
 FontSize->24,
 Magnification->1.25],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{"Color", " ", "File", " ", "Generator"}],
   FontSize->18], TraditionalForm]], "None",
 FontColor->RGBColor[0., 0., 0.6274509803921569]]], "Section",
 CellChangeTimes->{{3.4904802794934998`*^9, 3.4904803114622498`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "domain", " ", "for", " ", "low", " ", "end", " ", "fade", 
    " ", "up", " ", "from", " ", "black"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lo1", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hi1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"width1", "=", 
     RowBox[{"hi1", "-", "lo1"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Define", " ", "low", " ", "end", " ", "domain", " ", "functions", " ", 
      "for", " ", "red"}], ",", " ", "green", ",", " ", "blue"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"fnred1", "[", "x_", "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{"1", "/", "width1"}]}], "-", "0.75"}], "/;", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"width1", "/", "4"}]}], "\[LessEqual]", "x", "\[LessEqual]", 
        "width1"}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"fnred1", "[", "x_", "]"}], ":=", 
      RowBox[{"0", "/;", 
       RowBox[{"0", "\[LessEqual]", "x", "<", 
        RowBox[{"3", " ", 
         RowBox[{"width1", "/", "4"}]}]}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred1", "[", "x_", "]"}], ":=", "0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"fngrn1", "[", "x_", "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{"1", "/", "width1"}]}], "-", "0.5"}], "/;", 
       RowBox[{
        RowBox[{"width1", "/", "2"}], "\[LessEqual]", "x", "\[LessEqual]", 
        "width1"}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"fngrn1", "[", "x_", "]"}], ":=", 
      RowBox[{"0", "/;", 
       RowBox[{"0", "\[LessEqual]", "x", "<", 
        RowBox[{"width1", "/", "2"}]}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fngrn1", "[", "x_", "]"}], ":=", 
     RowBox[{"x", "*", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "width1"}], ")"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"fnblu1", "[", "x_", "]"}], ":=", 
      RowBox[{"x", "*", 
       RowBox[{"1", "/", "width1"}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnblu1", "[", "x_", "]"}], ":=", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"width1", "-", "x"}], "width1"], ")"}], "2"]}], ")"}], 
      FractionBox["1", "2"]]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "low", " ", "end", " ", "domain", " ", 
     "saturation", " ", "function", " ", "for", " ", "reference", " ", 
     "use"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnsat1", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fnred1", "[", "x", "]"}], "+", 
        RowBox[{"fngrn1", "[", "x", "]"}], "+", 
        RowBox[{"fnblu1", "[", "x", "]"}]}], ")"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "low", " ", "end", " ", "domain", " ", "red"}], ",",
      " ", 
     RowBox[{
     "green", " ", "and", " ", "blue", " ", "functions", " ", "along", " ", 
      "with", " ", "saturation"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fnred1", "[", "x", "]"}], ",", 
       RowBox[{"fngrn1", "[", "x", "]"}], ",", 
       RowBox[{"fnblu1", "[", "x", "]"}], ",", 
       RowBox[{"fnsat1", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "width1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{".6", ",", ".6", ",", ".6"}], "]"}], ",", "Thin"}], 
         "}"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "create", " ", "a", " ", "table", " ", "of", " ", "\"\<width1\>\"", " ", 
      "number", " ", "of", " ", "RGB", " ", "value", " ", "triplets"}], ",", 
     " ", 
     RowBox[{
     "each", " ", "value", " ", "ranging", " ", "from", " ", "0", " ", "to", 
      " ", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Colors1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"fnred1", "[", "i", "]"}], ",", 
         RowBox[{"fngrn1", "[", "i", "]"}], ",", 
         RowBox[{"fnblu1", "[", "i", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "lo1", ",", "hi1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "the", " ", "color", " ", "table", " ", "ceated", " ", 
     "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Raster", "[", 
      RowBox[{"{", "Colors1", "}"}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", ".2"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.490320387036125*^9, 3.49032044805175*^9}, {
   3.49032055380175*^9, 3.490320554223625*^9}, {3.490322318098625*^9, 
   3.49032232236425*^9}, 3.490322558583*^9, {3.490323069942375*^9, 
   3.49032306998925*^9}, {3.4904859398841248`*^9, 3.4904859399153748`*^9}, 
   3.4905704406341248`*^9, {3.4905704821184998`*^9, 3.4905704947747498`*^9}, {
   3.4905706667591248`*^9, 3.4905707653059998`*^9}, {3.4905708027903748`*^9, 
   3.4905708244778748`*^9}, {3.4905708702747498`*^9, 
   3.4905708716653748`*^9}, {3.4905712426966248`*^9, 
   3.4905712677278748`*^9}, {3.4905713543841248`*^9, 
   3.4905713768372498`*^9}, {3.4905714139778748`*^9, 
   3.4905714343684998`*^9}, {3.4905715310559998`*^9, 3.4905715315091248`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJxN0H0s1AEYB/BjctW6KVZiNy/X61nN3TJJ6W6Wl+K83FReIu6c+3k53J3z
UpKXRqKIpdrlOkPEhq4k2XkrRBld/gkb2oTVevHShc5VW56nZ3v23ee/5/vY
8hK4AkMSicT5s3+TVqSrVFhNHSf9m5aNdGsR0cFad1dqQ9V+YgjcyxALjYkJ
8KtCjeeS8Cu43zmn9bNQDx64OSaeFZqw131KTfb5KLQGD1IcNxmFMsCuRW6d
Nb5OYIH9CoVJYYM5dMH3HR4nwKqRS7J+J0/wUVO7RqPL3mDhakl5daAfOKF3
5lAjhwu+Fmy8RxcXAOb3XYxiEmfAXWQL/9igQDBzW2bZXFIw+PyCywGfuHNg
paKHqr0ehvfdcB7TcMPB0ucufuXeEeD2ger5/BAemPA4oo4O5IPltczm2JhI
cPGCOisxRQCerpMlE5Io8Av3kjvZ2UIwyXf0Q1EmAdaznxoo06LBeeZajiYv
Bv8TzO/W5sSCJ7McIlm34sBmpXdH8ytE4Oqtdml98nhwp8TabV99Alhho6S6
BCSC1ekrJGIYbetF/rXrrBj8ZIhe8H4EXdi7xrAJlYBLpXMx4ePo9O1WJrQg
KfghfcNA0iTaeNHAoissCVzDeJShmEHTeXU+OpEMPHayVXX6E1pTeeEgS5oM
/vnY/xhtHq1/JmnOjU8BezHc3dKX0H2h9tGx0lSwKZ9oK5ehw4gKynAK+ofE
TOWQjt59Vbuiu4LOVHUUFpehncl+Tc2t6Nwt+Yazbei327oDLNvRBNVhOaMb
fZu509XzNXoxZPLd6DiaHWGxlzKBLojiprKm0DTxS2rVNNo/t1Yg+oK+VzDV
cv8berbYcrNm/r8+8sIGRy36jbKHFL2MNn+wxpWvonn1h6sHdeiGpkStXo/+
DTeRHsY=
     "]]}, 
   {RGBColor[0, 1, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJwVz3k41AkcgHHTRbXjasuOHBHV2FqjnXTq++0QCWXSIpFcMwaZceSn1TGF
EmLTue4cKU8zNUytM1eUcg3l9sOqWEqKZmmZ2j/e5/P3q+cewPKao6CgYPO9
/9WPn8lM1enfbuU11Fw+bL79sRJd15/zBObv0uSRNAOoIIRZaziNwEy7mZxP
Y0INg89ewCHBur5NnELbDc9ipZaT7DFw8JSVXqHZw/Mt5wtH2XLoMb6wK47m
CXV/dPGH2CqYvnR/1CVaMFiVKtq+ZeuiQCl/dTQtAuqppgvnuTDQ0SlD9HH8
KuyMNy+/s38TUuWCIxY6aeBlPE01oSIa2n0YqorJAhu61/gyi90Y2rAZbk7c
BXHrqZDnmyxRo0Ctl0IRwVZ1I9G8M9YoGdj1snGbGNhfr6RkOx7ACm7KcqfR
AgioeferyIaFk6vMVO77P4ZLhxcYzvjZ49ypPNXlhkXgUfu7twnnN9wod3t0
UFgCFYo0O18nR2yIYDbUGD0BE7Wz14eDD6NuwsjU3Q/lcPSz2VpbvyM4IiN7
XzEqIT31qZYszhWz/imuU75cBeLLW7qkLDekat8ZGxyshqAiswMp1scw2kfi
nW5QA2V12Z+ind3xM+YNcs7UAsdic6mPowfy11cXLKt6Bkm5JhJfrid2Catj
mvXqIOFzqYAX6oVfuK1J9JMv4M29kBOcQG803KE46138Eqr2XLl57hwbd9zW
Yz/UaACF/Z0D8Wc5yNc+qt9/pBHk+IiSHuaDa0YPLW6zaYILGjIb6QUuqqh8
VKqeboKAwx6VsvO+KC9LEq1MboY+AdMTrvkhm1ncsXCfFJYk3uqMzvDHnL3u
6WVfpJCtahRWm3Qcx0Y0Vd9eb4HyQF3z1XkBKDxoMffq7lZIXZGuZWbPQ8Iy
Mq3gbSuUhk8rcJp4uLzHqj0z8hXo7VP8b6UDHzdsjLhKW/8aChrpMR2tfHTQ
aZyitLyG2JpZxgqXQByvixvgCdogMWiY69YdiInzXINZBu0QvlRHRd8pCFV7
JbfnVLfDXfr8uuC+IKScEthv5nfAggkKrcI1GGdzXUUD6p1wh/HwdOq7YOT9
KYpTr+wEuvs92xn/ECz6+aKS2vEu6NpbKD40EoLKVoFrzyl3gzTz5DoIOoGd
65pawkq64d98u236n06gMBUMBl17QP5XoCTqeCg6i0zVtGd7YB9jj3n4ZCie
icwQdN/rhVoXYx/fIALvD2knKVuToO7BKU4JIfBiSqRbry0JrpwMalMogZ6s
94ZCOxK+BC4RM8MJ1CopeWDjQILBRdn0TASBl+Kda2LdSTgrfhKbcJ1Atumt
8UVhJGxRPPBAUkigXsSPloo5JET9ED1nqJjA2U3h1LZcEprVKu01ywjseP+3
NCePBI4Wc+p0JYEJDvkuex6ScMPkp52WLwiUG7GCIktImHDua+nsJrC7OT51
bgsJeIy2ikoSWBgl82h5RUKMN4uAfgITtx6lZ7aToM+v1sp6Q6BV9i8FO3tJ
sIvK9fL/QGARUf9cMExCckz/47SPBF5btyHebpSEoQTNRdJPBPIHku31xr7/
JMUKTWUE0q39yPIJEl6mP1XwmSJwPqU1K0FGgkbOLCvpK4F9kq1ct2kS3PM2
ZtfPEFjMzTRmzJAgfMCTyeUE3tBdPCmXk/ANwvFXnA==
     "]]}, 
   {RGBColor[0, 0, 1], Thickness[Tiny], LineBox[CompressedData["
1:eJwV1Hk41NsfB/DRzXJvFFosyVpCi1GSpM6nUty0yFK2FuuMCDHme8QtpRsq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     "]]}, 
   {RGBColor[0.6, 0.6, 0.6], Thickness[Tiny], LineBox[CompressedData["
1:eJwVlHk41Isexi2VUnMrJZEOcZsT93QbJ81xJN/vrUaKLHPpIhQ1ZkQZY/uJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 400}, {0., 0.9999999999999998}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.490320352973625*^9, 3.490321787083*^9, 3.4903223230205*^9, 
   3.490322559567375*^9, 3.490322816379875*^9, 3.490323074786125*^9, 
   3.49032312723925*^9, 3.49032581536425*^9, 3.4904778610716248`*^9, 
   3.4904786119778748`*^9, 3.4904852320559998`*^9, 3.4904859426028748`*^9, 
   3.4905704464622498`*^9, {3.4905704955716248`*^9, 3.4905705100247498`*^9}, 
   3.4905707676966248`*^9, {3.4905708044309998`*^9, 3.4905708251966248`*^9}, 
   3.4905708740716248`*^9, {3.4905712690716248`*^9, 3.4905712828997498`*^9}, {
   3.4905714384622498`*^9, 3.4905714507278748`*^9}, 3.4905715324153748`*^9, 
   3.4905721339466248`*^9, 3.576522480545125*^9, 3.7350656034722896`*^9}],

Cell[BoxData[
 GraphicsBox[
  RasterBox[
   NCache[{{{0, 0, 0}, {
      0, Rational[1, 800], Rational[1, 400] 799^Rational[1, 2]}, {
      0, Rational[1, 400], Rational[1, 200] 399^Rational[1, 2]}, {
      0, Rational[3, 800], Rational[1, 400] 2391^Rational[1, 2]}, {
      0, Rational[1, 200], Rational[1, 100] 199^Rational[1, 2]}, {
      0, Rational[1, 160], Rational[1, 80] 159^Rational[1, 2]}, {
      0, Rational[3, 400], Rational[1, 200] 1191^Rational[1, 2]}, {
      0, Rational[7, 800], Rational[1, 400] 5551^Rational[1, 2]}, {
      0, Rational[1, 100], Rational[3, 50] 11^Rational[1, 2]}, {
      0, Rational[9, 800], Rational[3, 400] 791^Rational[1, 2]}, {
      0, Rational[1, 80], Rational[1, 40] 79^Rational[1, 2]}, {
      0, Rational[11, 800], Rational[1, 400] 8679^Rational[1, 2]}, {
      0, Rational[3, 200], Rational[1, 100] 591^Rational[1, 2]}, {
      0, Rational[13, 800], Rational[1, 400] 10231^Rational[1, 2]}, {
      0, Rational[7, 400], Rational[1, 200] 2751^Rational[1, 2]}, {
      0, Rational[3, 160], Rational[1, 80] 471^Rational[1, 2]}, {
      0, Rational[1, 50], Rational[7, 25]}, {
      0, Rational[17, 800], Rational[3, 400] 1479^Rational[1, 2]}, {
      0, Rational[9, 400], Rational[3, 200] 391^Rational[1, 2]}, {
      0, Rational[19, 800], Rational[1, 400] 14839^Rational[1, 2]}, {
      0, Rational[1, 40], Rational[1, 20] 39^Rational[1, 2]}, {
      0, Rational[21, 800], Rational[1, 400] 16359^Rational[1, 2]}, {
      0, Rational[11, 400], Rational[1, 200] 4279^Rational[1, 2]}, {
      0, Rational[23, 800], Rational[1, 400] 17871^Rational[1, 2]}, {
      0, Rational[3, 100], Rational[1, 50] 291^Rational[1, 2]}, {
      0, Rational[1, 32], Rational[1, 16] 31^Rational[1, 2]}, {
      0, Rational[13, 400], Rational[3, 200] 559^Rational[1, 2]}, {
      0, Rational[27, 800], Rational[3, 400] 2319^Rational[1, 2]}, {
      0, Rational[7, 200], Rational[1, 100] 1351^Rational[1, 2]}, {
      0, Rational[29, 800], Rational[1, 400] 22359^Rational[1, 2]}, {
      0, Rational[3, 80], Rational[1, 40] 231^Rational[1, 2]}, {
      0, Rational[31, 800], Rational[1, 400] 23839^Rational[1, 2]}, {
      0, Rational[1, 25], Rational[4, 25] 6^Rational[1, 2]}, {
      0, Rational[33, 800], Rational[1, 400] 25311^Rational[1, 2]}, {
      0, Rational[17, 400], Rational[1, 200] 6511^Rational[1, 2]}, {
      0, Rational[7, 160], Rational[3, 80] 119^Rational[1, 2]}, {
      0, Rational[9, 200], Rational[3, 100] 191^Rational[1, 2]}, {
      0, Rational[37, 800], Rational[1, 400] 28231^Rational[1, 2]}, {
      0, Rational[19, 400], Rational[1, 200] 7239^Rational[1, 2]}, {
      0, Rational[39, 800], Rational[1, 400] 29679^Rational[1, 2]}, {
      0, Rational[1, 20], Rational[1, 10] 19^Rational[1, 2]}, {
      0, Rational[41, 800], Rational[1, 400] 31119^Rational[1, 2]}, {
      0, Rational[21, 400], Rational[1, 200] 7959^Rational[1, 2]}, {
      0, Rational[43, 800], Rational[1, 400] 32551^Rational[1, 2]}, {
      0, Rational[11, 200], Rational[3, 100] 231^Rational[1, 2]}, {
      0, Rational[9, 160], Rational[3, 80] 151^Rational[1, 2]}, {
      0, Rational[23, 400], Rational[1, 200] 8671^Rational[1, 2]}, {
      0, Rational[47, 800], Rational[1, 400] 35391^Rational[1, 2]}, {
      0, Rational[3, 50], Rational[1, 25] 141^Rational[1, 2]}, {
      0, Rational[49, 800], Rational[7, 400] 751^Rational[1, 2]}, {
      0, Rational[1, 16], Rational[1, 8] 15^Rational[1, 2]}, {
      0, Rational[51, 800], Rational[1, 400] 38199^Rational[1, 2]}, {
      0, Rational[13, 200], Rational[1, 100] 2431^Rational[1, 2]}, {
      0, Rational[53, 800], Rational[3, 400] 4399^Rational[1, 2]}, {
      0, Rational[27, 400], Rational[3, 200] 1119^Rational[1, 2]}, {
      0, Rational[11, 160], Rational[1, 80] 1639^Rational[1, 2]}, {
      0, Rational[7, 100], Rational[1, 50] 651^Rational[1, 2]}, {
      0, Rational[57, 800], Rational[1, 400] 42351^Rational[1, 2]}, {
      0, Rational[29, 400], Rational[1, 200] 10759^Rational[1, 2]}, {
      0, Rational[59, 800], Rational[1, 400] 43719^Rational[1, 2]}, {
      0, Rational[3, 40], Rational[1, 20] 111^Rational[1, 2]}, {
      0, Rational[61, 800], Rational[1, 400] 45079^Rational[1, 2]}, {
      0, Rational[31, 400], Rational[3, 200] 1271^Rational[1, 2]}, {
      0, Rational[63, 800], Rational[3, 400] 5159^Rational[1, 2]}, {
      0, Rational[2, 25], Rational[2, 25] 46^Rational[1, 2]}, {
      0, Rational[13, 160], Rational[7, 80] 39^Rational[1, 2]}, {
      0, Rational[33, 400], Rational[1, 200] 12111^Rational[1, 2]}, {
      0, Rational[67, 800], Rational[1, 400] 49111^Rational[1, 2]}, {
      0, Rational[17, 200], Rational[1, 100] 3111^Rational[1, 2]}, {
      0, Rational[69, 800], Rational[1, 400] 50439^Rational[1, 2]}, {
      0, Rational[7, 80], Rational[1, 40] 511^Rational[1, 2]}, {
      0, Rational[71, 800], Rational[27, 400] 71^Rational[1, 2]}, {
      0, Rational[9, 100], Rational[3, 50] 91^Rational[1, 2]}, {
      0, Rational[73, 800], Rational[1, 400] 53071^Rational[1, 2]}, {
      0, Rational[37, 400], Rational[11, 200] 111^Rational[1, 2]}, {
      0, Rational[3, 32], Rational[1, 16] 87^Rational[1, 2]}, {
      0, Rational[19, 200], Rational[1, 100] 3439^Rational[1, 2]}, {
      0, Rational[77, 800], Rational[1, 400] 55671^Rational[1, 2]}, {
      0, Rational[39, 400], Rational[19, 200] 39^Rational[1, 2]}, {
      0, Rational[79, 800], Rational[1, 400] 56959^Rational[1, 2]}, {
      0, Rational[1, 10], Rational[3, 5]}, {
      0, Rational[81, 800], Rational[9, 400] 719^Rational[1, 2]}, {
      0, Rational[41, 400], Rational[1, 200] 14719^Rational[1, 2]}, {
      0, Rational[83, 800], Rational[1, 400] 59511^Rational[1, 2]}, {
      0, Rational[21, 200], Rational[1, 100] 3759^Rational[1, 2]}, {
      0, Rational[17, 160], Rational[1, 80] 2431^Rational[1, 2]}, {
      0, Rational[43, 400], Rational[1, 200] 15351^Rational[1, 2]}, {
      0, Rational[87, 800], Rational[1, 400] 62031^Rational[1, 2]}, {
      0, Rational[11, 100], Rational[1, 50] 979^Rational[1, 2]}, {
      0, Rational[89, 800], Rational[3, 400] 7031^Rational[1, 2]}, {
      0, Rational[9, 80], Rational[3, 40] 71^Rational[1, 2]}, {
      0, Rational[91, 800], Rational[1, 400] 64519^Rational[1, 2]}, {
      0, Rational[23, 200], Rational[1, 100] 4071^Rational[1, 2]}, {
      0, Rational[93, 800], Rational[1, 400] 65751^Rational[1, 2]}, {
      0, Rational[47, 400], Rational[1, 200] 16591^Rational[1, 2]}, {
      0, Rational[19, 160], Rational[1, 80] 2679^Rational[1, 2]}, {
      0, Rational[3, 25], Rational[2, 25] 66^Rational[1, 2]}, {
      0, Rational[97, 800], Rational[1, 400] 68191^Rational[1, 2]}, {
      0, Rational[49, 400], Rational[21, 200] 39^Rational[1, 2]}, {
      0, Rational[99, 800], Rational[3, 400] 7711^Rational[1, 2]}, {
      0, Rational[1, 8], Rational[1, 4] 7^Rational[1, 2]}, {
      0, Rational[101, 800], Rational[1, 400] 70599^Rational[1, 2]}, {
      0, Rational[51, 400], Rational[1, 200] 17799^Rational[1, 2]}, {
      0, Rational[103, 800], Rational[1, 400] 71791^Rational[1, 2]}, {
      0, Rational[13, 100], Rational[1, 50] 1131^Rational[1, 2]}, {
      0, Rational[21, 160], Rational[1, 80] 2919^Rational[1, 2]}, {
      0, Rational[53, 400], Rational[1, 200] 18391^Rational[1, 2]}, {
      0, Rational[107, 800], Rational[3, 400] 8239^Rational[1, 2]}, {
      0, Rational[27, 200], Rational[3, 100] 519^Rational[1, 2]}, {
      0, Rational[109, 800], Rational[1, 400] 75319^Rational[1, 2]}, {
      0, Rational[11, 80], Rational[1, 40] 759^Rational[1, 2]}, {
      0, Rational[111, 800], Rational[1, 400] 76479^Rational[1, 2]}, {
      0, Rational[7, 50], Rational[1, 25] 301^Rational[1, 2]}, {
      0, Rational[113, 800], Rational[1, 400] 77631^Rational[1, 2]}, {
      0, Rational[57, 400], Rational[7, 200] 399^Rational[1, 2]}, {
      0, Rational[23, 160], Rational[1, 80] 3151^Rational[1, 2]}, {
      0, Rational[29, 200], Rational[3, 100] 551^Rational[1, 2]}, {
      0, Rational[117, 800], Rational[3, 400] 8879^Rational[1, 2]}, {
      0, Rational[59, 400], Rational[1, 200] 20119^Rational[1, 2]}, {
      0, Rational[119, 800], Rational[1, 400] 81039^Rational[1, 2]}, {
      0, Rational[3, 20], Rational[1, 10] 51^Rational[1, 2]}, {
      0, Rational[121, 800], Rational[11, 400] 679^Rational[1, 2]}, {
      0, Rational[61, 400], Rational[1, 200] 20679^Rational[1, 2]}, {
      0, Rational[123, 800], Rational[1, 400] 83271^Rational[1, 2]}, {
      0, Rational[31, 200], Rational[13, 100] 31^Rational[1, 2]}, {
      0, Rational[5, 32], Rational[3, 16] 15^Rational[1, 2]}, {
      0, Rational[63, 400], Rational[3, 200] 2359^Rational[1, 2]}, {
      0, Rational[127, 800], Rational[1, 400] 85471^Rational[1, 2]}, {
      0, Rational[4, 25], Rational[4, 25] 21^Rational[1, 2]}, {
      0, Rational[129, 800], Rational[1, 400] 86559^Rational[1, 2]}, {
      0, Rational[13, 80], Rational[1, 40] 871^Rational[1, 2]}, {
      0, Rational[131, 800], Rational[1, 400] 87639^Rational[1, 2]}, {
      0, Rational[33, 200], Rational[1, 100] 5511^Rational[1, 2]}, {
      0, Rational[133, 800], Rational[1, 400] 88711^Rational[1, 2]}, {
      0, Rational[67, 400], Rational[3, 200] 2479^Rational[1, 2]}, {
      0, Rational[27, 160], Rational[3, 80] 399^Rational[1, 2]}, {
      0, Rational[17, 100], Rational[1, 50] 1411^Rational[1, 2]}, {
      0, Rational[137, 800], Rational[1, 400] 90831^Rational[1, 2]}, {
      0, Rational[69, 400], Rational[1, 200] 22839^Rational[1, 2]}, {
      0, Rational[139, 800], Rational[1, 400] 91879^Rational[1, 2]}, {
      0, Rational[7, 40], Rational[1, 20] 231^Rational[1, 2]}, {
      0, Rational[141, 800], Rational[1, 400] 92919^Rational[1, 2]}, {
      0, Rational[71, 400], Rational[1, 200] 23359^Rational[1, 2]}, {
      0, Rational[143, 800], Rational[3, 400] 10439^Rational[1, 2]}, {
      0, Rational[9, 50], Rational[3, 25] 41^Rational[1, 2]}, {
      0, Rational[29, 160], Rational[1, 80] 3799^Rational[1, 2]}, {
      0, Rational[73, 400], Rational[1, 200] 23871^Rational[1, 2]}, {
      0, Rational[147, 800], Rational[7, 400] 1959^Rational[1, 2]}, {
      0, Rational[37, 200], Rational[1, 100] 6031^Rational[1, 2]}, {
      0, Rational[149, 800], Rational[1, 400] 96999^Rational[1, 2]}, {
      0, Rational[3, 16], Rational[1, 8] 39^Rational[1, 2]}, {
      0, Rational[151, 800], Rational[1, 400] 97999^Rational[1, 2]}, {
      0, Rational[19, 100], Rational[9, 50] 19^Rational[1, 2]}, {
      0, Rational[153, 800], Rational[3, 400] 10999^Rational[1, 2]}, {
      0, Rational[77, 400], Rational[1, 200] 24871^Rational[1, 2]}, {
      0, Rational[31, 160], Rational[1, 80] 3999^Rational[1, 2]}, {
      0, Rational[39, 200], Rational[1, 100] 6279^Rational[1, 2]}, {
      0, Rational[157, 800], Rational[1, 400] 100951^Rational[1, 2]}, {
      0, Rational[79, 400], Rational[1, 200] 25359^Rational[1, 2]}, {
      0, Rational[159, 800], Rational[1, 400] 101919^Rational[1, 2]}, {
      0, Rational[1, 5], Rational[4, 5]}, {
      0, Rational[161, 800], Rational[3, 400] 11431^Rational[1, 2]}, {
      0, Rational[81, 400], Rational[9, 200] 319^Rational[1, 2]}, {
      0, Rational[163, 800], Rational[7, 400] 2119^Rational[1, 2]}, {
      0, Rational[41, 200], Rational[1, 100] 6519^Rational[1, 2]}, {
      0, Rational[33, 160], Rational[1, 80] 4191^Rational[1, 2]}, {
      0, Rational[83, 400], Rational[1, 200] 26311^Rational[1, 2]}, {
      0, Rational[167, 800], Rational[1, 400] 105711^Rational[1, 2]}, {
      0, Rational[21, 100], Rational[1, 50] 1659^Rational[1, 2]}, {
      0, Rational[169, 800], Rational[13, 400] 631^Rational[1, 2]}, {
      0, Rational[17, 80], Rational[3, 40] 119^Rational[1, 2]}, {
      0, Rational[171, 800], Rational[3, 400] 11951^Rational[1, 2]}, {
      0, Rational[43, 200], Rational[1, 100] 6751^Rational[1, 2]}, {
      0, Rational[173, 800], Rational[1, 400] 108471^Rational[1, 2]}, {
      0, Rational[87, 400], Rational[1, 200] 27231^Rational[1, 2]}, {
      0, Rational[7, 32], Rational[5, 16] 7^Rational[1, 2]}, {
      0, Rational[11, 50], Rational[1, 25] 429^Rational[1, 2]}, {
      0, Rational[177, 800], Rational[1, 400] 110271^Rational[1, 2]}, {
      0, Rational[89, 400], Rational[1, 200] 27679^Rational[1, 2]}, {
      0, Rational[179, 800], Rational[3, 400] 12351^Rational[1, 2]}, {
      0, Rational[9, 40], Rational[3, 20] 31^Rational[1, 2]}, {
      0, Rational[181, 800], Rational[1, 400] 112039^Rational[1, 2]}, {
      0, Rational[91, 400], Rational[1, 200] 28119^Rational[1, 2]}, {
      0, Rational[183, 800], Rational[1, 400] 112911^Rational[1, 2]}, {
      0, Rational[23, 100], Rational[1, 50] 1771^Rational[1, 2]}, {
      0, Rational[37, 160], Rational[1, 80] 4551^Rational[1, 2]}, {
      0, Rational[93, 400], Rational[1, 200] 28551^Rational[1, 2]}, {
      0, Rational[187, 800], Rational[1, 400] 114631^Rational[1, 2]}, {
      0, Rational[47, 200], Rational[3, 100] 799^Rational[1, 2]}, {
      0, Rational[189, 800], Rational[3, 400] 12831^Rational[1, 2]}, {
      0, Rational[19, 80], Rational[1, 40] 1159^Rational[1, 2]}, {
      0, Rational[191, 800], Rational[1, 400] 116319^Rational[1, 2]}, {
      0, Rational[6, 25], Rational[2, 25] 114^Rational[1, 2]}, {
      0, Rational[193, 800], Rational[1, 400] 117151^Rational[1, 2]}, {
      0, Rational[97, 400], Rational[1, 200] 29391^Rational[1, 2]}, {
      0, Rational[39, 160], Rational[11, 80] 39^Rational[1, 2]}, {
      0, Rational[49, 200], Rational[7, 100] 151^Rational[1, 2]}, {
      0, Rational[197, 800], Rational[3, 400] 13199^Rational[1, 2]}, {
      0, Rational[99, 400], Rational[3, 200] 3311^Rational[1, 2]}, {
      0, Rational[199, 800], Rational[1, 400] 119599^Rational[1, 2]}, {
      0, Rational[1, 4], Rational[1, 2] 3^Rational[1, 2]}, {
      0, Rational[201, 800], Rational[1, 400] 120399^Rational[1, 2]}, {
      0, Rational[101, 400], Rational[1, 200] 30199^Rational[1, 2]}, {
      0, Rational[203, 800], Rational[1, 400] 121191^Rational[1, 2]}, {
      0, Rational[51, 200], Rational[1, 100] 7599^Rational[1, 2]}, {
      0, Rational[41, 160], Rational[1, 80] 4879^Rational[1, 2]}, {
      0, Rational[103, 400], Rational[3, 200] 3399^Rational[1, 2]}, {
      0, Rational[207, 800], Rational[3, 400] 13639^Rational[1, 2]}, {
      0, Rational[13, 50], Rational[1, 25] 481^Rational[1, 2]}, {
      0, Rational[209, 800], Rational[1, 400] 123519^Rational[1, 2]}, {
      0, Rational[21, 80], Rational[1, 40] 1239^Rational[1, 2]}, {
      0, Rational[211, 800], Rational[1, 400] 124279^Rational[1, 2]}, {
      0, Rational[53, 200], Rational[7, 100] 159^Rational[1, 2]}, {
      0, Rational[213, 800], Rational[1, 400] 125031^Rational[1, 2]}, {
      0, Rational[107, 400], Rational[1, 200] 31351^Rational[1, 2]}, {
      0, Rational[43, 160], Rational[3, 80] 559^Rational[1, 2]}, {
      0, Rational[27, 100], Rational[3, 50] 219^Rational[1, 2]}, {
      0, Rational[217, 800], Rational[1, 400] 126511^Rational[1, 2]}, {
      0, Rational[109, 400], Rational[1, 200] 31719^Rational[1, 2]}, {
      0, Rational[219, 800], Rational[1, 400] 127239^Rational[1, 2]}, {
      0, Rational[11, 40], Rational[1, 20] 319^Rational[1, 2]}, {
      0, Rational[221, 800], Rational[1, 400] 127959^Rational[1, 2]}, {
      0, Rational[111, 400], Rational[17, 200] 111^Rational[1, 2]}, {
      0, Rational[223, 800], Rational[1, 400] 128671^Rational[1, 2]}, {
      0, Rational[7, 25], Rational[6, 25] 14^Rational[1, 2]}, {
      0, Rational[9, 32], Rational[3, 16] 23^Rational[1, 2]}, {
      0, Rational[113, 400], Rational[1, 200] 32431^Rational[1, 2]}, {
      0, Rational[227, 800], Rational[1, 400] 130071^Rational[1, 2]}, {
      0, Rational[57, 200], Rational[1, 100] 8151^Rational[1, 2]}, {
      0, Rational[229, 800], Rational[1, 400] 130759^Rational[1, 2]}, {
      0, Rational[23, 80], Rational[1, 40] 1311^Rational[1, 2]}, {
      0, Rational[231, 800], Rational[1, 400] 131439^Rational[1, 2]}, {
      0, Rational[29, 100], Rational[1, 50] 2059^Rational[1, 2]}, {
      0, Rational[233, 800], Rational[9, 400] 1631^Rational[1, 2]}, {
      0, Rational[117, 400], Rational[3, 200] 3679^Rational[1, 2]}, {
      0, Rational[47, 160], Rational[1, 80] 5311^Rational[1, 2]}, {
      0, Rational[59, 200], Rational[1, 100] 8319^Rational[1, 2]}, {
      0, Rational[237, 800], Rational[1, 400] 133431^Rational[1, 2]}, {
      0, Rational[119, 400], Rational[1, 200] 33439^Rational[1, 2]}, {
      0, Rational[239, 800], Rational[1, 400] 134079^Rational[1, 2]}, {
      0, Rational[3, 10], Rational[1, 5] 21^Rational[1, 2]}, {
      0, Rational[241, 800], Rational[1, 400] 134719^Rational[1, 2]}, {
      0, Rational[121, 400], Rational[33, 200] 31^Rational[1, 2]}, {
      0, Rational[243, 800], Rational[9, 400] 1671^Rational[1, 2]}, {
      0, Rational[61, 200], Rational[1, 100] 8479^Rational[1, 2]}, {
      0, Rational[49, 160], Rational[7, 80] 111^Rational[1, 2]}, {
      0, Rational[123, 400], Rational[1, 200] 34071^Rational[1, 2]}, {
      0, Rational[247, 800], Rational[1, 400] 136591^Rational[1, 2]}, {
      0, Rational[31, 100], Rational[1, 50] 2139^Rational[1, 2]}, {
      0, Rational[249, 800], Rational[1, 400] 137199^Rational[1, 2]}, {
      0, Rational[5, 16], Rational[1, 8] 55^Rational[1, 2]}, {
      0, Rational[251, 800], Rational[3, 400] 15311^Rational[1, 2]}, {
      0, Rational[63, 200], Rational[3, 100] 959^Rational[1, 2]}, {
      0, Rational[253, 800], Rational[1, 400] 138391^Rational[1, 2]}, {
      0, Rational[127, 400], Rational[1, 200] 34671^Rational[1, 2]}, {
      0, Rational[51, 160], Rational[1, 80] 5559^Rational[1, 2]}, {
      0, Rational[8, 25], Rational[4, 25] 34^Rational[1, 2]}, {
      0, Rational[257, 800], Rational[1, 400] 139551^Rational[1, 2]}, {
      0, Rational[129, 400], Rational[1, 200] 34959^Rational[1, 2]}, {
      0, Rational[259, 800], Rational[1, 400] 140119^Rational[1, 2]}, {
      0, Rational[13, 40], Rational[3, 20] 39^Rational[1, 2]}, {
      0, Rational[261, 800], Rational[21, 400] 319^Rational[1, 2]}, {
      0, Rational[131, 400], Rational[1, 200] 35239^Rational[1, 2]}, {
      0, Rational[263, 800], Rational[1, 400] 141231^Rational[1, 2]}, {
      0, Rational[33, 100], Rational[1, 50] 2211^Rational[1, 2]}, {
      0, Rational[53, 160], Rational[1, 80] 5671^Rational[1, 2]}, {
      0, Rational[133, 400], Rational[1, 200] 35511^Rational[1, 2]}, {
      0, Rational[267, 800], Rational[1, 400] 142311^Rational[1, 2]}, {
      0, Rational[67, 200], Rational[1, 100] 8911^Rational[1, 2]}, {
      0, Rational[269, 800], Rational[3, 400] 15871^Rational[1, 2]}, {
      0, Rational[27, 80], Rational[3, 40] 159^Rational[1, 2]}, {
      0, Rational[271, 800], Rational[23, 400] 271^Rational[1, 2]}, {
      0, Rational[17, 50], Rational[1, 25] 561^Rational[1, 2]}, {
      0, Rational[273, 800], Rational[1, 400] 143871^Rational[1, 2]}, {
      0, Rational[137, 400], Rational[1, 200] 36031^Rational[1, 2]}, {
      0, Rational[11, 32], Rational[1, 16] 231^Rational[1, 2]}, {
      0, Rational[69, 200], Rational[1, 100] 9039^Rational[1, 2]}, {
      0, Rational[277, 800], Rational[1, 400] 144871^Rational[1, 2]}, {
      0, Rational[139, 400], Rational[3, 200] 4031^Rational[1, 2]}, {
      0, Rational[279, 800], Rational[3, 400] 16151^Rational[1, 2]}, {
      0, Rational[7, 20], Rational[1, 10] 91^Rational[1, 2]}, {
      0, Rational[281, 800], Rational[1, 400] 145839^Rational[1, 2]}, {
      0, Rational[141, 400], Rational[1, 200] 36519^Rational[1, 2]}, {
      0, Rational[283, 800], Rational[1, 400] 146311^Rational[1, 2]}, {
      0, Rational[71, 200], Rational[1, 100] 9159^Rational[1, 2]}, {
      0, Rational[57, 160], Rational[1, 80] 5871^Rational[1, 2]}, {
      0, Rational[143, 400], Rational[1, 200] 36751^Rational[1, 2]}, {
      0, Rational[287, 800], Rational[3, 400] 16359^Rational[1, 2]}, {
      0, Rational[9, 25], Rational[24, 25]}, {
      0, Rational[289, 800], Rational[17, 400] 511^Rational[1, 2]}, {
      0, Rational[29, 80], Rational[1, 40] 1479^Rational[1, 2]}, {
      0, Rational[291, 800], Rational[1, 400] 148119^Rational[1, 2]}, {
      0, Rational[73, 200], Rational[1, 100] 9271^Rational[1, 2]}, {
      0, Rational[293, 800], Rational[13, 400] 879^Rational[1, 2]}, {
      0, Rational[147, 400], Rational[7, 200] 759^Rational[1, 2]}, {
      0, Rational[59, 160], Rational[1, 80] 5959^Rational[1, 2]}, {
      0, Rational[37, 100], Rational[3, 50] 259^Rational[1, 2]}, {
      0, Rational[297, 800], Rational[3, 400] 16599^Rational[1, 2]}, {
      0, Rational[149, 400], Rational[1, 200] 37399^Rational[1, 2]}, {
      0, Rational[299, 800], Rational[1, 400] 149799^Rational[1, 2]}, {
      0, Rational[3, 8], Rational[1, 4] 15^Rational[1, 2]}, {
      0, Rational[301, 800], Rational[1, 400] 150199^Rational[1, 2]}, {
      0, Rational[151, 400], Rational[1, 200] 37599^Rational[1, 2]}, {
      0, Rational[303, 800], Rational[1, 400] 150591^Rational[1, 2]}, {
      0, Rational[19, 50], Rational[1, 25] 589^Rational[1, 2]}, {
      0, Rational[61, 160], Rational[3, 80] 671^Rational[1, 2]}, {
      0, Rational[153, 400], Rational[3, 200] 4199^Rational[1, 2]}, {
      0, Rational[307, 800], Rational[1, 400] 151351^Rational[1, 2]}, {
      0, Rational[77, 200], Rational[1, 100] 9471^Rational[1, 2]}, {
      0, Rational[309, 800], Rational[1, 400] 151719^Rational[1, 2]}, {
      0, Rational[31, 80], Rational[7, 40] 31^Rational[1, 2]}, {
      0, Rational[311, 800], Rational[1, 400] 152079^Rational[1, 2]}, {
      0, Rational[39, 100], Rational[1, 50] 2379^Rational[1, 2]}, {
      0, Rational[313, 800], Rational[1, 400] 152431^Rational[1, 2]}, {
      0, Rational[157, 400], Rational[9, 200] 471^Rational[1, 2]}, {
      0, Rational[63, 160], Rational[3, 80] 679^Rational[1, 2]}, {
      0, Rational[79, 200], Rational[11, 100] 79^Rational[1, 2]}, {
      0, Rational[317, 800], Rational[1, 400] 153111^Rational[1, 2]}, {
      0, Rational[159, 400], Rational[1, 200] 38319^Rational[1, 2]}, {
      0, Rational[319, 800], Rational[1, 400] 153439^Rational[1, 2]}, {
      0, Rational[2, 5], Rational[2, 5] 6^Rational[1, 2]}, {
      0, Rational[321, 800], Rational[1, 400] 153759^Rational[1, 2]}, {
      0, Rational[161, 400], Rational[1, 200] 38479^Rational[1, 2]}, {
      0, Rational[323, 800], Rational[3, 400] 17119^Rational[1, 2]}, {
      0, Rational[81, 200], Rational[9, 100] 119^Rational[1, 2]}, {
      0, Rational[13, 32], Rational[1, 16] 247^Rational[1, 2]}, {
      0, Rational[163, 400], Rational[1, 200] 38631^Rational[1, 2]}, {
      0, Rational[327, 800], Rational[1, 400] 154671^Rational[1, 2]}, {
      0, Rational[41, 100], Rational[1, 50] 2419^Rational[1, 2]}, {
      0, Rational[329, 800], Rational[1, 400] 154959^Rational[1, 2]}, {
      0, Rational[33, 80], Rational[1, 40] 1551^Rational[1, 2]}, {
      0, Rational[331, 800], Rational[1, 400] 155239^Rational[1, 2]}, {
      0, Rational[83, 200], Rational[3, 100] 1079^Rational[1, 2]}, {
      0, Rational[333, 800], Rational[3, 400] 17279^Rational[1, 2]}, {
      0, Rational[167, 400], Rational[1, 200] 38911^Rational[1, 2]}, {
      0, Rational[67, 160], Rational[1, 80] 6231^Rational[1, 2]}, {
      0, Rational[21, 50], Rational[1, 25] 609^Rational[1, 2]}, {
      0, Rational[337, 800], Rational[1, 400] 156031^Rational[1, 2]}, {
      0, Rational[169, 400], Rational[13, 200] 231^Rational[1, 2]}, {
      0, Rational[339, 800], Rational[1, 400] 156279^Rational[1, 2]}, {
      0, Rational[17, 40], Rational[1, 20] 391^Rational[1, 2]}, {
      0, Rational[341, 800], Rational[3, 400] 17391^Rational[1, 2]}, {
      0, Rational[171, 400], Rational[3, 200] 4351^Rational[1, 2]}, {
      0, Rational[343, 800], Rational[7, 400] 3199^Rational[1, 2]}, {
      0, Rational[43, 100], Rational[1, 50] 2451^Rational[1, 2]}, {
      0, Rational[69, 160], Rational[1, 80] 6279^Rational[1, 2]}, {
      0, Rational[173, 400], Rational[1, 200] 39271^Rational[1, 2]}, {
      0, Rational[347, 800], Rational[1, 400] 157191^Rational[1, 2]}, {
      0, Rational[87, 200], Rational[1, 100] 9831^Rational[1, 2]}, {
      0, Rational[349, 800], Rational[1, 400] 157399^Rational[1, 2]}, {
      0, Rational[7, 16], Rational[3, 8] 7^Rational[1, 2]}, {
      0, Rational[351, 800], Rational[3, 400] 17511^Rational[1, 2]}, {
      0, Rational[11, 25], Rational[2, 25] 154^Rational[1, 2]}, {
      0, Rational[353, 800], Rational[1, 400] 157791^Rational[1, 2]}, {
      0, Rational[177, 400], Rational[1, 200] 39471^Rational[1, 2]}, {
      0, Rational[71, 160], Rational[1, 80] 6319^Rational[1, 2]}, {
      0, Rational[89, 200], Rational[1, 100] 9879^Rational[1, 2]}, {
      0, Rational[357, 800], Rational[1, 400] 158151^Rational[1, 2]}, {
      0, Rational[179, 400], Rational[1, 200] 39559^Rational[1, 2]}, {
      0, Rational[359, 800], Rational[21, 400] 359^Rational[1, 2]}, {
      0, Rational[9, 20], Rational[3, 10] 11^Rational[1, 2]}, {
      0, Rational[361, 800], Rational[19, 400] 439^Rational[1, 2]}, {
      0, Rational[181, 400], Rational[1, 200] 39639^Rational[1, 2]}, {
      0, Rational[363, 800], Rational[11, 400] 1311^Rational[1, 2]}, {
      0, Rational[91, 200], Rational[1, 100] 9919^Rational[1, 2]}, {
      0, Rational[73, 160], Rational[1, 80] 6351^Rational[1, 2]}, {
      0, Rational[183, 400], Rational[1, 200] 39711^Rational[1, 2]}, {
      0, Rational[367, 800], Rational[1, 400] 158911^Rational[1, 2]}, {
      0, Rational[23, 50], Rational[3, 25] 69^Rational[1, 2]}, {
      0, Rational[369, 800], Rational[3, 400] 17671^Rational[1, 2]}, {
      0, Rational[37, 80], Rational[1, 40] 1591^Rational[1, 2]}, {
      0, Rational[371, 800], Rational[1, 400] 159159^Rational[1, 2]}, {
      0, Rational[93, 200], Rational[1, 100] 9951^Rational[1, 2]}, {
      0, Rational[373, 800], Rational[1, 400] 159271^Rational[1, 2]}, {
      0, Rational[187, 400], Rational[1, 200] 39831^Rational[1, 2]}, {
      0, Rational[15, 32], Rational[1, 16] 255^Rational[1, 2]}, {
      0, Rational[47, 100], Rational[1, 50] 2491^Rational[1, 2]}, {
      0, Rational[377, 800], Rational[3, 400] 17719^Rational[1, 2]}, {
      0, Rational[189, 400], Rational[3, 200] 4431^Rational[1, 2]}, {
      0, Rational[379, 800], Rational[1, 400] 159559^Rational[1, 2]}, {
      0, Rational[19, 40], Rational[1, 20] 399^Rational[1, 2]}, {
      0, Rational[381, 800], Rational[1, 400] 159639^Rational[1, 2]}, {
      0, Rational[191, 400], Rational[1, 200] 39919^Rational[1, 2]}, {
      0, Rational[383, 800], Rational[1, 400] 159711^Rational[1, 2]}, {
      0, Rational[12, 25], Rational[4, 25] 39^Rational[1, 2]}, {
      0, Rational[77, 160], Rational[1, 80] 6391^Rational[1, 2]}, {
      0, Rational[193, 400], Rational[3, 200] 4439^Rational[1, 2]}, {
      0, Rational[387, 800], Rational[3, 400] 17759^Rational[1, 2]}, {
      0, Rational[97, 200], Rational[1, 100] 9991^Rational[1, 2]}, {
      0, Rational[389, 800], Rational[1, 400] 159879^Rational[1, 2]}, {
      0, Rational[39, 80], Rational[1, 40] 1599^Rational[1, 2]}, {
      0, Rational[391, 800], Rational[1, 400] 159919^Rational[1, 2]}, {
      0, Rational[49, 100], Rational[7, 50] 51^Rational[1, 2]}, {
      0, Rational[393, 800], Rational[1, 400] 159951^Rational[1, 2]}, {
      0, Rational[197, 400], Rational[1, 200] 39991^Rational[1, 2]}, {
      0, Rational[79, 160], Rational[9, 80] 79^Rational[1, 2]}, {
      0, Rational[99, 200], Rational[3, 100] 1111^Rational[1, 2]}, {
      0, Rational[397, 800], Rational[1, 400] 159991^Rational[1, 2]}, {
      0, Rational[199, 400], Rational[1, 200] 39999^Rational[1, 2]}, {
      0, Rational[399, 800], Rational[1, 400] 159999^Rational[1, 2]}, {
      0, Rational[1, 2], 1}}}, {{{0, 0, 0}, {
      0, 0.00125, 0.07066647012551285}, {0, 0.0025, 0.09987492177719089}, {
      0, 0.00375, 0.1222446317839765}, {0, 0.005, 0.14106735979665885`}, {
      0, 0.00625, 0.15761900266148116`}, {0, 0.0075, 0.17255433926737396`}, {
      0, 0.00875, 0.18626258346753383`}, {0, 0.01, 0.19899748742132398`}, {
      0, 0.01125, 0.2109354166563785}, {0, 0.0125, 0.22220486043288973`}, {
      0, 0.01375, 0.23290287675337976`}, {0, 0.015, 0.24310491562286438`}, {
      0, 0.01625, 0.2528710145508971}, {0, 0.0175, 0.26224988083886713`}, {
      0, 0.01875, 0.2712816801776338}, {0, 0.02, 0.28}, {
      0, 0.02125, 0.28843326784544115`}, {0, 0.0225, 0.2966057989992778}, {
      0, 0.02375, 0.3045385854042144}, {0, 0.025, 0.3122498999199199}, {
      0, 0.02625, 0.31975576617162044`}, {0, 0.0275, 0.3270703288285258}, {
      0, 0.02875, 0.3342061489559999}, {0, 0.03, 0.3411744421846396}, {
      0, 0.03125, 0.34798527267687634`}, {0, 0.0325, 0.35464771252610666`}, {
      0, 0.03375, 0.3611699738350352}, {0, 0.035, 0.3675595189897821}, {
      0, 0.03625, 0.37382315337603156`}, {0, 0.0375, 0.37996710383926663`}, {
      0, 0.03875, 0.38599708548122486`}, {0, 0.04, 0.39191835884530846`}, {
      0, 0.04125, 0.3977357791298137}, {0, 0.0425, 0.40345383874738383`}, {
      0, 0.04375, 0.40907670429883924`}, {0, 0.045, 0.4146082488325576}, {
      0, 0.04625, 0.42005208010436046`}, {0, 0.0475, 0.4254115654281157}, {
      0, 0.04875, 0.4306898536069778}, {0, 0.05, 0.43588989435406744`}, {
      0, 0.05125, 0.4410144555453937}, {0, 0.0525, 0.4460661385938189}, {
      0, 0.05375, 0.4510473921884484}, {0, 0.055, 0.4559605246071199}, {
      0, 0.05625, 0.46080771477916904`}, {0, 0.0575, 0.46559102225021476`}, {
      0, 0.05875, 0.4703123961793905}, {0, 0.06, 0.4749736834815167}, {
      0, 0.06125, 0.47957663621156527`}, {0, 0.0625, 0.4841229182759271}, {
      0, 0.06375, 0.4886141115440691}, {0, 0.065, 0.49305172142484205`}, {
      0, 0.06625, 0.4974371819637129}, {0, 0.0675, 0.5017718605103318}, {
      0, 0.06875, 0.5060570619999291}, {0, 0.07, 0.510294032886923}, {
      0, 0.07125, 0.514483964764695}, {0, 0.0725, 0.5186279977016282}, {
      0, 0.07375, 0.5227272233201558}, {0, 0.075, 0.5267826876426369}, {
      0, 0.07625, 0.5307953937253036}, {0, 0.0775, 0.5347663040992766}, {
      0, 0.07875, 0.538696343035666}, {0, 0.08, 0.5425863986500215}, {
      0, 0.08125, 0.5464373248598599}, {0, 0.0825, 0.55024994320763}, {
      0, 0.08375, 0.5540250445602617}, {0, 0.085, 0.5577633906953736}, {
      0, 0.08625, 0.5614657157832524}, {0, 0.0875, 0.5651327277728657}, {
      0, 0.08875, 0.5687651096894043}, {0, 0.09, 0.5723635208501674}, {
      0, 0.09125, 0.5759285980049957}, {0, 0.0925, 0.5794609564069007}, {
      0, 0.09375, 0.582961190818051}, {0, 0.095, 0.58642987645583}, {
      0, 0.09625, 0.5898675698832747}, {0, 0.0975, 0.5932748098478479}, {
      0, 0.09875, 0.5966521180721643}, {0, 0.1, 0.6}, {
      0, 0.10125, 0.6033189455006365}, {0, 0.1025, 0.6066094295343587}, {
      0, 0.10375, 0.6098719127816922}, {0, 0.105, 0.6131068422387732}, {
      0, 0.10625, 0.6163146517810526}, {0, 0.1075, 0.619495762697373}, {
      0, 0.10875, 0.622650584196305}, {0, 0.11, 0.6257795138864806}, {
      0, 0.11125, 0.6288829382325458}, {0, 0.1125, 0.6319612329882269}, {
      0, 0.11375, 0.6350147636079023}, {0, 0.115, 0.6380438856379709}, {
      0, 0.11625, 0.6410489450892186}, {0, 0.1175, 0.6440302787913004}, {
      0, 0.11875, 0.6469882147303767}, {0, 0.12, 0.6499230723708769}, {
      0, 0.12125, 0.6528351629622903}, {0, 0.1225, 0.6557247898318318}, {
      0, 0.12375, 0.6585922486637692}, {0, 0.125, 0.6614378277661477}, {
      0, 0.12625, 0.6642618083256029}, {0, 0.1275, 0.6670644646509061}, {
      0, 0.12875, 0.6698460644058455}, {0, 0.13, 0.6726068688320095}, {
      0, 0.13125, 0.675347132962005}, {0, 0.1325, 0.6780671058236051}, {
      0, 0.13375, 0.6807670306352974}, {0, 0.135, 0.683447144993671}, {
      0, 0.13625, 0.6861076810530545}, {0, 0.1375, 0.6887488656977956}, {
      0, 0.13875, 0.691370920707546}, {0, 0.14, 0.6939740629158989}, {
      0, 0.14125, 0.6965585043626988}, {0, 0.1425, 0.6991244524403363}, {
      0, 0.14375, 0.7016721100343095}, {0, 0.145, 0.7042016756583301}, {
      0, 0.14625, 0.7067133435842287}, {0, 0.1475, 0.7092073039669008}, {
      0, 0.14875, 0.7116837429645277}, {0, 0.15, 0.7141428428542851}, {
      0, 0.15125, 0.716584782143746}, {0, 0.1525, 0.7190097356781756}, {
      0, 0.15375, 0.7214178747438963}, {0, 0.155, 0.7238093671679028}, {
      0, 0.15625, 0.7261843774138907}, {0, 0.1575, 0.7285430666748535}, {
      0, 0.15875, 0.7308855929624006}, {0, 0.16, 0.7332121111929344}, {
      0, 0.16125, 0.7355227732708213}, {0, 0.1625, 0.7378177281686854}, {
      0, 0.16375, 0.7400971220049434}, {0, 0.165, 0.7423610981186985}, {
      0, 0.16625, 0.7446097971421004}, {0, 0.1675, 0.7468433570702762}, {
      0, 0.16875, 0.7490619133289317}, {0, 0.17, 0.751265598839718}, {
      0, 0.17125, 0.7534545440834504}, {0, 0.1725, 0.7556288771612689}, {
      0, 0.17375, 0.7577887238538193}, {0, 0.175, 0.7599342076785333}, {
      0, 0.17625, 0.7620654499450819}, {0, 0.1775, 0.7641825698090738}, {
      0, 0.17875, 0.7662856843240646}, {0, 0.18, 0.7683749084919418}, {
      0, 0.18125, 0.7704503553117489}, {0, 0.1825, 0.7725121358270043}, {
      0, 0.18375, 0.7745603591715756}, {0, 0.185, 0.776595132614157}, {
      0, 0.18625, 0.7786165616014086}, {0, 0.1875, 0.7806247497997998}, {
      0, 0.18875, 0.7826197991362089}, {0, 0.19, 0.7846018098373213}, {
      0, 0.19125, 0.7865708804678698}, {0, 0.1925, 0.7885271079677604}, {
      0, 0.19375, 0.790470587688119}, {0, 0.195, 0.7924014134263012}, {
      0, 0.19625, 0.7943196774599003}, {0, 0.1975, 0.796225470579785}, {
      0, 0.19875, 0.798118882122206}, {0, 0.2, 0.8}, {
      0, 0.20125, 0.8018689107329202}, {0, 0.2025, 0.8037256994771287}, {
      0, 0.20375, 0.8055704500538734}, {0, 0.205, 0.807403244977378}, {
      0, 0.20625, 0.8092241654819757}, {0, 0.2075, 0.8110332915485036}, {
      0, 0.20875, 0.81283070192999}, {0, 0.21, 0.8146164741766521}, {
      0, 0.21125, 0.8163906846602306}, {0, 0.2125, 0.8181534085976785}, {
      0, 0.21375, 0.8199047200742291}, {0, 0.215, 0.8216446920658588}, {
      0, 0.21625, 0.8233733964611681}, {0, 0.2175, 0.8250909040826956}, {
      0, 0.21875, 0.8267972847076845}, {0, 0.22, 0.8284926070883192}, {
      0, 0.22125, 0.830176938971446}, {0, 0.2225, 0.8318503471177974}, {
      0, 0.22375, 0.8335128973207313}, {0, 0.225, 0.8351646544245032}, {
      0, 0.22625, 0.8368056823420835}, {0, 0.2275, 0.8384360440725339}, {
      0, 0.22875, 0.8400558017179574}, {0, 0.23, 0.8416650165000326}, {
      0, 0.23125, 0.8432637487761465}, {0, 0.2325, 0.8448520580551367}, {
      0, 0.23375, 0.8464300030126531}, {0, 0.235, 0.8479976415061542}, {
      0, 0.23625, 0.8495550305895434}, {0, 0.2375, 0.8511022265274601}, {
      0, 0.23875, 0.8526392848092329}, {0, 0.24, 0.854166260162505}, {
      0, 0.24125, 0.8556832065665424}, {0, 0.2425, 0.8571901772652321}, {
      0, 0.24375, 0.8586872247797799}, {0, 0.245, 0.8601744009211156}, {
      0, 0.24625, 0.8616517568020157}, {0, 0.2475, 0.8631193428489481}, {
      0, 0.24875, 0.864577208813649}, {0, 0.25, 0.8660254037844386}, {
      0, 0.25125, 0.8674639761972829}, {0, 0.2525, 0.8688929738466068}, {
      0, 0.25375, 0.8703124438958689}, {0, 0.255, 0.8717224328879004}, {
      0, 0.25625, 0.8731229867550161}, {0, 0.2575, 0.8745141508289045}, {
      0, 0.25875, 0.8758959698503013}, {0, 0.26, 0.8772684879784524}, {
      0, 0.26125, 0.8786317488003721}, {0, 0.2625, 0.8799857953399022}, {
      0, 0.26375, 0.8813306700665762}, {0, 0.265, 0.8826664149042945}, {
      0, 0.26625, 0.8839930712398146}, {0, 0.2675, 0.8853106799310624}, {
      0, 0.26875, 0.8866192813152667}, {0, 0.27, 0.8879189152169245}, {
      0, 0.27125, 0.8892096209555991}, {0, 0.2725, 0.8904914373535548}, {
      0, 0.27375, 0.8917644027432359}, {0, 0.275, 0.8930285549745876}, {
      0, 0.27625, 0.8942839314222302}, {0, 0.2775, 0.8955305689924828}, {
      0, 0.27875, 0.8967685041302466}, {0, 0.28, 0.8979977728257459}, {
      0, 0.28125, 0.8992184106211348}, {0, 0.2825, 0.9004304526169692}, {
      0, 0.28375, 0.9016339334785487}, {0, 0.285, 0.9028288874421333}, {
      0, 0.28625, 0.9040153483210338}, {0, 0.2875, 0.9051933495115837}, {
      0, 0.28875, 0.9063629239989907}, {0, 0.29, 0.9075241043630742}, {
      0, 0.29125, 0.9086769227838901}, {0, 0.2925, 0.9098214110472449}, {
      0, 0.29375, 0.9109576005501024}, {0, 0.295, 0.9120855223058856}, {
      0, 0.29625, 0.9132052069496757}, {0, 0.2975, 0.9143166847433115}, {
      0, 0.29875, 0.9154199855803893}, {0, 0.3, 0.916515138991168}, {
      0, 0.30125, 0.9176021741473807}, {0, 0.3025, 0.9186811198669536}, {
      0, 0.30375, 0.9197520046186363}, {0, 0.305, 0.920814856526544}, {
      0, 0.30625, 0.9218697033746145}, {0, 0.3075, 0.9229165726109809}, {
      0, 0.30875, 0.9239554913522621}, {0, 0.31, 0.9249864863877743}, {
      0, 0.31125, 0.9260095841836627}, {0, 0.3125, 0.9270248108869579}, {
      0, 0.31375, 0.9280321923295549}, {0, 0.315, 0.9290317540321213}, {
      0, 0.31625, 0.9300235212079316}, {0, 0.3175, 0.9310075187666317}, {
      0, 0.31875, 0.9319837713179345}, {0, 0.32, 0.9329523031752481}, {
      0, 0.32125, 0.9339131383592374}, {0, 0.3225, 0.9348663006013213}, {
      0, 0.32375, 0.9358118133471066}, {0, 0.325, 0.9367496997597597}, {
      0, 0.32625, 0.9376799827233169}, {0, 0.3275, 0.9386026848459363}, {
      0, 0.32875, 0.9395178284630898}, {0, 0.33, 0.9404254356406998}, {
      0, 0.33125, 0.9413255281782175}, {0, 0.3325, 0.9422181276116481}, {
      0, 0.33375, 0.9431032552165219}, {0, 0.335, 0.9439809320108115}, {
      0, 0.33625, 0.9448511787577978}, {0, 0.3375, 0.9457140159688868}, {
      0, 0.33875, 0.946569463906374}, {0, 0.34, 0.9474175425861608}, {
      0, 0.34125, 0.9482582717804259}, {0, 0.3425, 0.9490916710202446}, {
      0, 0.34375, 0.9499177595981665}, {0, 0.345, 0.9507365565707464}, {
      0, 0.34625, 0.9515480807610303}, {0, 0.3475, 0.9523523507609986}, {
      0, 0.34875, 0.9531493849339672}, {0, 0.35, 0.9539392014169457}, {
      0, 0.35125, 0.9547218181229546}, {0, 0.3525, 0.9554972527433033}, {
      0, 0.35375, 0.956265522749827}, {0, 0.355, 0.957026645397086}, {
      0, 0.35625, 0.9577806377245262}, {0, 0.3575, 0.9585275165586015}, {
      0, 0.35875, 0.9592672985148613}, {0, 0.36, 0.96}, {
      0, 0.36125, 0.9607256372138718}, {0, 0.3625, 0.9614442261514706}, {
      0, 0.36375, 0.9621557826048753}, {0, 0.365, 0.9628603221651623}, {
      0, 0.36625, 0.9635578602242836}, {0, 0.3675, 0.9642484119769138}, {
      0, 0.36875, 0.964931992422264}, {0, 0.37, 0.9656086163658648}, {
      0, 0.37125, 0.9662782984213192}, {0, 0.3725, 0.9669410530120232}, {
      0, 0.37375, 0.9675968943728581}, {0, 0.375, 0.9682458365518543}, {
      0, 0.37625, 0.9688878934118229}, {0, 0.3775, 0.9695230786319633}, {
      0, 0.37875, 0.9701514057094387}, {0, 0.38, 0.9707728879609278}, {
      0, 0.38125, 0.9713875385241464}, {0, 0.3825, 0.9719953703593449}, {
      0, 0.38375, 0.9725963962507779}, {0, 0.385, 0.9731906288081489}, {
      0, 0.38625, 0.9737780804680294}, {0, 0.3875, 0.9743587634952537}, {
      0, 0.38875, 0.9749326899842881}, {0, 0.39, 0.975499871860576}, {
      0, 0.39125, 0.9760603208818602}, {0, 0.3925, 0.9766140486394818}, {
      0, 0.39375, 0.9771610665596536}, {0, 0.395, 0.9777013859047148}, {
      0, 0.39625, 0.9782350177743588}, {0, 0.3975, 0.9787619731068428}, {
      0, 0.39875, 0.9792822626801733}, {0, 0.4, 0.9797958971132712}, {
      0, 0.40125, 0.9803028868671152}, {0, 0.4025, 0.9808032422458645}, {
      0, 0.40375, 0.9812969733979617}, {0, 0.405, 0.9817840903172143}, {
      0, 0.40625, 0.982264602843857}, {0, 0.4075, 0.982738520665594}, {
      0, 0.40875, 0.9832058533186222}, {0, 0.41, 0.983666610188635}, {
      0, 0.41125, 0.9841208005118071}, {0, 0.4125, 0.9845684333757609}, {
      0, 0.41375, 0.9850095177205143}, {0, 0.415, 0.9854440623394105}, {
      0, 0.41625, 0.9858720758800301}, {0, 0.4175, 0.986293566845085}, {
      0, 0.41875, 0.9867085435932943}, {0, 0.42, 0.9871170143402453}, {
      0, 0.42125, 0.9875189871592344}, {0, 0.4225, 0.9879144699820932}, {
      0, 0.42375, 0.9883034705999975}, {0, 0.425, 0.9886859966642595}, {
      0, 0.42625, 0.9890620556871039}, {0, 0.4275, 0.9894316550424289}, {
      0, 0.42875, 0.9897948019665491}, {0, 0.43, 0.990151503558925}, {
      0, 0.43125, 0.9905017667828766}, {0, 0.4325, 0.9908455984662797}, {
      0, 0.43375, 0.9911830053022499}, {0, 0.435, 0.9915139938498095}, {
      0, 0.43625, 0.9918385705345402}, {0, 0.4375, 0.9921567416492215}, {
      0, 0.43875, 0.9924685133544541}, {0, 0.44, 0.9927738916792685}, {
      0, 0.44125, 0.993072882521721}, {0, 0.4425, 0.9933654916494734}, {
      0, 0.44375, 0.99365172470036}, {0, 0.445, 0.993931587182941}, {
      0, 0.44625, 0.9942050844770409}, {0, 0.4475, 0.9944722218342753}, {
      0, 0.44875, 0.9947330043785618}, {0, 0.45, 0.9949874371066199}, {
      0, 0.45125, 0.9952355248884558}, {0, 0.4525, 0.995477272467835}, {
      0, 0.45375, 0.995712684462742}, {0, 0.455, 0.995941765365827}, {
      0, 0.45625, 0.9961645195448391}, {0, 0.4575, 0.9963809512430474}, {
      0, 0.45875, 0.99659106457965}, {0, 0.46, 0.996794863550169}, {
      0, 0.46125, 0.9969923520268347}, {0, 0.4625, 0.9971835337589566}, {
      0, 0.46375, 0.9973684123732816}, {0, 0.465, 0.9975469913743412}, {
      0, 0.46625, 0.9977192741447867}, {0, 0.4675, 0.9978852639457104}, {
      0, 0.46875, 0.998044963916957}, {0, 0.47, 0.9981983770774224}, {
      0, 0.47125, 0.9983455063253401}, {0, 0.4725, 0.998486354438557}, {
      0, 0.47375, 0.9986209240747962}, {0, 0.475, 0.998749217771909}, {
      0, 0.47625, 0.9988712379481152}, {0, 0.4775, 0.9989869869022319}, {
      0, 0.47875, 0.9990964668138907}, {0, 0.48, 0.9991996797437438}, {
      0, 0.48125, 0.9992966276336571}, {0, 0.4825, 0.9993873123068954}, {
      0, 0.48375, 0.9994717354682923}, {0, 0.485, 0.9995498987044118}, {
      0, 0.48625, 0.9996218034836976}, {0, 0.4875, 0.9996874511566104}, {
      0, 0.48875, 0.9997468429557554}, {0, 0.49, 0.9997999799959991}, {
      0, 0.49125, 0.9998468632745717}, {0, 0.4925, 0.999887493671163}, {
      0, 0.49375, 0.9999218719480037}, {0, 0.495, 0.9999499987499374}, {
      0, 0.49625, 0.999971874604481}, {0, 0.4975, 0.999987499921874}, {
      0, 0.49875, 0.9999968749951172}, {0, 0.5, 1}}}]],
  AspectRatio->0.2]], "Output",
 CellChangeTimes->{
  3.490320352973625*^9, 3.490321787083*^9, 3.4903223230205*^9, 
   3.490322559567375*^9, 3.490322816379875*^9, 3.490323074786125*^9, 
   3.49032312723925*^9, 3.49032581536425*^9, 3.4904778610716248`*^9, 
   3.4904786119778748`*^9, 3.4904852320559998`*^9, 3.4904859426028748`*^9, 
   3.4905704464622498`*^9, {3.4905704955716248`*^9, 3.4905705100247498`*^9}, 
   3.4905707676966248`*^9, {3.4905708044309998`*^9, 3.4905708251966248`*^9}, 
   3.4905708740716248`*^9, {3.4905712690716248`*^9, 3.4905712828997498`*^9}, {
   3.4905714384622498`*^9, 3.4905714507278748`*^9}, 3.4905715324153748`*^9, 
   3.4905721339466248`*^9, 3.576522480545125*^9, 3.7350656035347905`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "domain", " ", "for", " ", "bulk", " ", "of", " ", "color", 
    " ", "scheme"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lo2", "=", "400"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hi2", "=", "3795"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"width2", "=", 
     RowBox[{"hi2", "-", "lo2"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Define", " ", "squishing", " ", "function"}], ";", " ", 
      RowBox[{
      "color", " ", "changes", " ", "rapidly", " ", "at", " ", "low", " ", 
       "end"}]}], ",", " ", 
     RowBox[{"slowly", " ", "at", " ", "high", " ", "end"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"squishfactor", "=", "1.2"}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"squish", "[", "x_", "]"}], ":=", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["width2", "squishfactor"], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"width2", "-", "x"}], ")"}], "squishfactor"]}], ")"}], 
      FractionBox["1", "squishfactor"]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "shishing", " ", "function", " ", "for", " ", "reference"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"squish", "[", "x", "]"}], ",", "width2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "hi2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", ".9"}], "]"}], ",", "Thin"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Define", " ", "middle", " ", "domain", " ", "functions", " ", "for", 
      " ", "red"}], ",", " ", "green", ",", " ", "blue"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred2", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"squish", "[", 
              RowBox[{"x", "-", "lo2"}], "]"}], "*", 
             RowBox[{"5", "/", "6"}]}], "-", 
            RowBox[{"width2", "/", "6"}]}], ")"}], " ", 
          FractionBox["\[Pi]", "width2"]}], "]"}], "]"}], "]"}], "/;", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"squish", "[", 
           RowBox[{"x", "-", "lo2"}], "]"}], "*", 
          RowBox[{"5", "/", "6"}]}], "-", 
         RowBox[{"width2", "/", "6"}]}], ")"}], "\[GreaterEqual]", "0"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred2", "[", "x_", "]"}], ":=", 
     RowBox[{"0", "/;", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"squish", "[", 
           RowBox[{"x", "-", "lo2"}], "]"}], "*", 
          RowBox[{"5", "/", "6"}]}], "-", 
         RowBox[{"width2", "/", "6"}]}], ")"}], "<", "0"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fngrn2", "[", "x_", "]"}], ":=", 
     RowBox[{"N", "[", 
      RowBox[{"Abs", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"squish", "[", 
             RowBox[{"x", "-", "lo2"}], "]"}], "*", 
            RowBox[{"5", "/", "6"}]}], "+", 
           RowBox[{"width2", "/", "3"}], "-", 
           RowBox[{"width2", "/", "6"}]}], ")"}], " ", 
         FractionBox["\[Pi]", "width2"]}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnblu2", "[", "x_", "]"}], ":=", 
     RowBox[{"N", "[", 
      RowBox[{"Abs", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"squish", "[", 
             RowBox[{"x", "-", "lo2"}], "]"}], "*", 
            RowBox[{"5", "/", "6"}]}], "-", 
           RowBox[{"width2", "/", "3"}], "-", 
           RowBox[{"width2", "/", "6"}]}], ")"}], " ", 
         FractionBox["\[Pi]", "width2"]}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "middle", " ", "domain", " ", "saturation", " ", 
     "function", " ", "for", " ", "reference", " ", "use"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnsat2", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fnred2", "[", "x", "]"}], "+", 
        RowBox[{"fngrn2", "[", "x", "]"}], "+", 
        RowBox[{"fnblu2", "[", "x", "]"}]}], ")"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "middle", " ", "domain", " ", "red"}], ",", " ", 
     RowBox[{
     "green", " ", "and", " ", "blue", " ", "functions", " ", "along", " ", 
      "with", " ", "saturation"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fnred2", "[", "x", "]"}], ",", 
       RowBox[{"fngrn2", "[", "x", "]"}], ",", 
       RowBox[{"fnblu2", "[", "x", "]"}], ",", 
       RowBox[{"fnsat2", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "lo2", ",", "hi2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{".6", ",", ".6", ",", ".6"}], "]"}], ",", "Thin"}], 
         "}"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "create", " ", "a", " ", "table", " ", "of", " ", "\"\<width2\>\"", " ", 
      "number", " ", "of", " ", "RGB", " ", "value", " ", "triplets"}], ",", 
     " ", 
     RowBox[{
     "each", " ", "value", " ", "ranging", " ", "from", " ", "0", " ", "to", 
      " ", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Colors2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"fnred2", "[", "i", "]"}], ",", 
         RowBox[{"fngrn2", "[", "i", "]"}], ",", 
         RowBox[{"fnblu2", "[", "i", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "lo2", ",", "hi2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "the", " ", "color", " ", "table", " ", "ceated", " ", 
     "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Raster", "[", 
      RowBox[{"{", "Colors2", "}"}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", ".2"}]}], "]"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Red(\>\"", ",", "lo2", ",", "\"\<) = \>\"", ",", 
     RowBox[{"fnred2", "[", "lo2", "]"}], ",", "\"\<     Red(\>\"", ",", 
     "hi2", ",", "\"\<) = \>\"", ",", 
     RowBox[{"fnred2", "[", "hi2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Grn(\>\"", ",", "lo2", ",", "\"\<) = \>\"", ",", 
     RowBox[{"fngrn2", "[", "lo2", "]"}], ",", "\"\<     Grn(\>\"", ",", 
     "hi2", ",", "\"\<) = \>\"", ",", 
     RowBox[{"fngrn2", "[", "hi2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Blu(\>\"", ",", "lo2", ",", "\"\<) = \>\"", ",", 
     RowBox[{"fnblu2", "[", "lo2", "]"}], ",", "\"\<     Blu(\>\"", ",", 
     "hi2", ",", "\"\<) = \>\"", ",", 
     RowBox[{"fnblu2", "[", "hi2", "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4902362850636253`*^9, 3.4902362884386253`*^9}, {
   3.4902363217198753`*^9, 3.4902364514698753`*^9}, {3.4902364889855003`*^9, 
   3.4902364900480003`*^9}, {3.4902365774386253`*^9, 
   3.4902366339698753`*^9}, {3.4902366729698753`*^9, 
   3.4902369819073753`*^9}, {3.4902370545323753`*^9, 
   3.4902371571573753`*^9}, {3.4902372186417503`*^9, 
   3.4902372555167503`*^9}, {3.4902373312823753`*^9, 
   3.4902375299386253`*^9}, {3.4902375616261253`*^9, 
   3.4902375686730003`*^9}, {3.4902376108448753`*^9, 
   3.4902377162042503`*^9}, {3.4902377563292503`*^9, 
   3.4902378638292503`*^9}, {3.4902380751886253`*^9, 
   3.4902380801730003`*^9}, {3.4902381863761253`*^9, 
   3.4902381890792503`*^9}, {3.4902382699698753`*^9, 
   3.4902382717667503`*^9}, {3.4902384042042503`*^9, 
   3.4902384406261253`*^9}, {3.4902386617511253`*^9, 
   3.4902388240636253`*^9}, {3.4902390222198753`*^9, 
   3.4902390548448753`*^9}, {3.4902391098292503`*^9, 
   3.4902391167355003`*^9}, {3.4902392318136253`*^9, 
   3.4902392352042503`*^9}, {3.4902392683605003`*^9, 
   3.4902393056573753`*^9}, {3.4902397420167503`*^9, 
   3.4902398082198753`*^9}, {3.4902399033605003`*^9, 
   3.4902399870948753`*^9}, {3.4902400220792503`*^9, 
   3.4902400381417503`*^9}, {3.4902400712355003`*^9, 
   3.4902400943292503`*^9}, {3.4902405332042503`*^9, 
   3.4902406634386253`*^9}, {3.4902779302667503`*^9, 
   3.4902779306886253`*^9}, {3.4902779744855003`*^9, 3.4902779745323753`*^9}, 
   3.4902780110792503`*^9, {3.4902780702823753`*^9, 3.4902780709230003`*^9}, {
   3.4902781127511253`*^9, 3.4902781260636253`*^9}, {3.4902785179855003`*^9, 
   3.4902787955011253`*^9}, {3.4902789040948753`*^9, 
   3.4902789757511253`*^9}, {3.4902791052667503`*^9, 
   3.4902791182355003`*^9}, {3.4903031266261253`*^9, 
   3.4903031360480003`*^9}, {3.4903031886417503`*^9, 
   3.4903033618761253`*^9}, {3.4903033989855003`*^9, 
   3.4903035153292503`*^9}, {3.4903043746105003`*^9, 
   3.4903043756105003`*^9}, {3.4903044876730003`*^9, 
   3.4903044966105003`*^9}, {3.4903045343605003`*^9, 
   3.4903046802980003`*^9}, {3.4903047168292503`*^9, 
   3.4903047517823753`*^9}, {3.4903047902667503`*^9, 
   3.4903048602355003`*^9}, {3.4903049212355003`*^9, 
   3.4903049650167503`*^9}, {3.4903050052511253`*^9, 
   3.4903050192355003`*^9}, {3.4903050980636253`*^9, 
   3.4903050980948753`*^9}, {3.4903056200323753`*^9, 
   3.4903056479542503`*^9}, {3.4903056974386253`*^9, 
   3.4903058029230003`*^9}, {3.4903068346105003`*^9, 
   3.4903068815323753`*^9}, {3.4903070070480003`*^9, 
   3.4903070151261253`*^9}, {3.490319151629875*^9, 3.49031940342675*^9}, {
   3.49031944961425*^9, 3.490319449661125*^9}, {3.490319554833*^9, 
   3.490319578161125*^9}, {3.49031962898925*^9, 3.490319706629875*^9}, {
   3.490319750879875*^9, 3.490319798458*^9}, {3.490319833504875*^9, 
   3.49031988680175*^9}, {3.490319949583*^9, 3.490320102848625*^9}, {
   3.49032015936425*^9, 3.490320230536125*^9}, {3.490320264379875*^9, 
   3.490320348692375*^9}, {3.490320528473625*^9, 3.490320611754875*^9}, {
   3.490320645567375*^9, 3.49032067686425*^9}, {3.490320747473625*^9, 
   3.49032079355175*^9}, {3.490320920598625*^9, 3.4903209241455*^9}, {
   3.490322306504875*^9, 3.490322308161125*^9}, {3.490322567208*^9, 
   3.490322569473625*^9}, {3.490323136598625*^9, 3.490323137208*^9}, {
   3.4904852512747498`*^9, 3.4904852689466248`*^9}, {3.4904859501966248`*^9, 
   3.4904859619934998`*^9}, {3.4904863310247498`*^9, 
   3.4904863313372498`*^9}, {3.4904863913059998`*^9, 3.4904863913528748`*^9}, 
   3.4905710964153748`*^9, {3.4905711310091248`*^9, 3.4905711645716248`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJxNxW0w03EcAPBt6VCYPFx1LmnLU4ctJ8eVUVdHunUjS9nNU4k8nJaHG6bz
GErMhsLxn9ZmYud2uTPd4To0T4dS5GHZnDhONbqlo6N64fvrxec+J6KTg2MI
OByO/te/b+ZmXc+nW/nu/StE3q7ENmC8THqUjxH89i4MIo9kYRawvzRKwsFI
sGwcJ0jE3OHpGIZRPHYB5lC5vXFYMLxJ76SsxN6CsxX7u9UfEuFReqSQZpwC
b4dbjV014cImhrrV7k4eXG9/SNXxJQcOW7k09jo6Hy7hlqm+thfCKmbevvPe
xXD6TgmlT/AIHglwtbivKYWp2iwvv8hyOI+U7IjN8OHU7bQQN1sB7C0ZmnvP
EsIdHs5sYkElfC6Bvcvqr4Izi+pq/Nar4Z7ANuYZz2fw1GfzJN+0Glh2g8fT
NtTCuRldcqG2DrbMMZpSm9XD3NBGlo9nA7z4kUiQp2OwwbGLjBmGCK4lJVCX
Nv7b3Lv7d0UjnL5+MCDC4Tk8KRlcuKxCW9BLM3LYYlg5p+96o0NrfQMtH/Nf
wMtV4tsiewnM6Vl+66NCT81S7R3DpXCTxu60zQZ6S7lNfypogk8VzN6JcJLB
apKU3zaE3mo+HHcgvhn+QS47q9hB3+N8P67BXsKDCiaO5dkCl85El2kG0ROT
Ya7f7rbCP/tDB/x30Z+GTZsX8HK4811vSbYBmqemXHlljCboDUdtrdBmJ5UT
eie0Q96ReXEw2qh4tIfGRK88KRBNh6Jba3RRRDbaXTGwmBmLpmm4q0E8tN2S
2/DaAzR+bbGlKBfdt8lI6nqIDiQ665wq0C7W8+O9QrSpTZUivBo97oBPqaxD
K1w6rlEa0AL3JI8hETrVi2wdI0YzadP6XQn6D1KYVok=
     "]]}, 
   {RGBColor[0, 0, 0.9], Thickness[Tiny], LineBox[CompressedData["
1:eJwVj3k01Xkfxy2VJUOWM6MsmTvJMoWsST33bZfm2rKOuSiuQSj7dj2W20VI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     "]]}, 
   {RGBColor[0, 0, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQHdlYHdbsK2LPAAJtqxxupgZwZM13coDxCw0qDmfM
D4Lzv/vu1H+Zngzn125k3Xf3Sg6cf843YbIdZzGc/ztO5LwfTwWcz8P+4dW+
nTVw/lxVwePbnzbA+VEvXc/vSmqG8zsr+o6/3dIK5x8PbWJ2tOyA88v+deof
mdQF55/x0BUqetAD5xs8rLZwSOiH85uU8tXn35oA55f8Lg3Rk5sE51suPXXn
UvRkOH+7iWYsf8sUON8mO/Z/9NGpcH5V++yZDh+nwfn7vdaHmprNgPOv3xPI
tS+dCeeviKipeThvFpzfWLl37eSHs+F84QaO63f55sL5FeELo23N5sH5T67y
M60tmw/ns8i6BNwKWADnz1LKNnj2CYkvYLnvz8SFiPD6yO0Rr7YIzr+29OQj
z+MIvpBvT2VD7GI4f8edr3sPfkDwH9p7CXdPWALnP5+6OGWB6lI4v3D/82O2
xxH867cNVNXjlsH5yx8oGEp/QvB/7fjtO33Scjhfq+V2WrzGCjj/rtKyCetP
Ifi/VopncGWthPM/K/dZb/yH4BcUvpd/MH8VnH9yYyhDtNlqOL/nVlLfg5MI
/uVrUbrvMtfA+d+Ohp9w/4/gqzVJ3F8ctBbOD7W7+fX/UgQfADb8F4Q=
     "]]}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 3795}, {0., 3794.9999225510205`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4902363707980003`*^9, 3.4902363786886253`*^9}, {
   3.4902364095792503`*^9, 3.4902364522667503`*^9}, 3.4902364910011253`*^9, 
   3.4902367856886253`*^9, 3.4902368615323753`*^9, 3.4902368972667503`*^9, 
   3.4902369530011253`*^9, {3.4902370908448753`*^9, 3.4902371206886253`*^9}, 
   3.4902371582355003`*^9, 3.4902372193605003`*^9, 3.4902372571730003`*^9, {
   3.4902373903917503`*^9, 3.4902374407198753`*^9}, {3.4902374817198753`*^9, 
   3.4902375307823753`*^9}, 3.4902375694855003`*^9, {3.4902376142823753`*^9, 
   3.4902376512355003`*^9}, 3.4902377219386253`*^9, 3.4902378006417503`*^9, 
   3.4902378653761253`*^9, 3.4902381911261253`*^9, 3.4902382729698753`*^9, {
   3.4902384087198753`*^9, 3.4902384413761253`*^9}, {3.4902387647823753`*^9, 
   3.4902387806886253`*^9}, {3.4902388128448753`*^9, 
   3.4902388251105003`*^9}, {3.4902390388292503`*^9, 3.4902390561573753`*^9}, 
   3.4902391179386253`*^9, {3.4902392833292503`*^9, 3.4902393062823753`*^9}, {
   3.4902397821417503`*^9, 3.4902398094542503`*^9}, {3.4902399467355003`*^9, 
   3.4902399884542503`*^9}, {3.4902400331730003`*^9, 
   3.4902400390167503`*^9}, {3.4902400727823753`*^9, 3.4902400950948753`*^9}, 
   3.4902405983917503`*^9, {3.4902406452355003`*^9, 3.4902406693761253`*^9}, 
   3.4902779321261253`*^9, 3.4902779758917503`*^9, 3.4902780721261253`*^9, {
   3.4902781145323753`*^9, 3.4902781270011253`*^9}, {3.4902789548136253`*^9, 
   3.4902789768292503`*^9}, 3.4902791782823753`*^9, 3.4903032492198753`*^9, 
   3.4903032834542503`*^9, 3.4903033194230003`*^9, {3.4903033505480003`*^9, 
   3.4903033632980003`*^9}, {3.4903034645636253`*^9, 3.4903035172511253`*^9}, 
   3.4903043780011253`*^9, 3.4903045769386253`*^9, {3.4903046113448753`*^9, 
   3.4903046359230003`*^9}, 3.4903048670948753`*^9, 3.4903048981886253`*^9, {
   3.4903049366573753`*^9, 3.4903049662511253`*^9}, 3.4903050202355003`*^9, 
   3.4903056490948753`*^9, 3.4903056984542503`*^9, 3.4903057340636253`*^9, 
   3.4903058041886253`*^9, 3.4903068360167503`*^9, {3.4903068825480003`*^9, 
   3.4903069092980003`*^9}, 3.490319452692375*^9, {3.490319555567375*^9, 
   3.490319578942375*^9}, {3.490319633129875*^9, 3.49031967580175*^9}, {
   3.490319754458*^9, 3.49031980030175*^9}, {3.490319870208*^9, 
   3.490319887067375*^9}, {3.490319967129875*^9, 3.490320031629875*^9}, 
   3.490320071942375*^9, 3.490320103379875*^9, 3.49032046505175*^9, {
   3.490320625473625*^9, 3.490320648129875*^9}, 3.4903207570205*^9, 
   3.490320794348625*^9, 3.490321783379875*^9, 3.4903223088955*^9, 
   3.490322570536125*^9, 3.490322820098625*^9, 3.490323084973625*^9, 
   3.490323139567375*^9, 3.4903258181455*^9, 3.4904778635559998`*^9, 
   3.4904786142591248`*^9, {3.4904852353528748`*^9, 3.4904852692747498`*^9}, 
   3.4904859631966248`*^9, 3.4904863323841248`*^9, 3.4904863921341248`*^9, 
   3.4905708941966248`*^9, 3.4905711668216248`*^9, 3.4905712885716248`*^9, 
   3.4905715378372498`*^9, 3.4905721378841248`*^9, 3.57652249256075*^9, 
   3.7350656104567604`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJxF13s0VO33AHChviKXEhUSUklKUhJvnl0UqRRJIqVCIRIpl+QeihSSyG1m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     "]]}, 
   {RGBColor[0, 1, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJwV13k4lO0XB3BFaLMkEoUoifpJipLc58UbkYoWW0mypAVR9r1kyT7zjBlL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     "]]}, 
   {RGBColor[0, 0, 1], Thickness[Tiny], LineBox[CompressedData["
1:eJwVkXk4lekbx1GZ0mYZbUpoBlPZShJx32iURJFIUcguS4uOY8mWUkPWlO28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     "]]}, 
   {RGBColor[0.6, 0.6, 0.6], Thickness[Tiny], LineBox[CompressedData["
1:eJwd2nk4VN8fB3B72hRFhYRkiyRrlPMJUdaIkqQUlTURsmTJNmRn7FvMjHUk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{500., 0},
  Method->{},
  PlotRange->{{400, 3795}, {0., 0.9999999999992922}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4902363707980003`*^9, 3.4902363786886253`*^9}, {
   3.4902364095792503`*^9, 3.4902364522667503`*^9}, 3.4902364910011253`*^9, 
   3.4902367856886253`*^9, 3.4902368615323753`*^9, 3.4902368972667503`*^9, 
   3.4902369530011253`*^9, {3.4902370908448753`*^9, 3.4902371206886253`*^9}, 
   3.4902371582355003`*^9, 3.4902372193605003`*^9, 3.4902372571730003`*^9, {
   3.4902373903917503`*^9, 3.4902374407198753`*^9}, {3.4902374817198753`*^9, 
   3.4902375307823753`*^9}, 3.4902375694855003`*^9, {3.4902376142823753`*^9, 
   3.4902376512355003`*^9}, 3.4902377219386253`*^9, 3.4902378006417503`*^9, 
   3.4902378653761253`*^9, 3.4902381911261253`*^9, 3.4902382729698753`*^9, {
   3.4902384087198753`*^9, 3.4902384413761253`*^9}, {3.4902387647823753`*^9, 
   3.4902387806886253`*^9}, {3.4902388128448753`*^9, 
   3.4902388251105003`*^9}, {3.4902390388292503`*^9, 3.4902390561573753`*^9}, 
   3.4902391179386253`*^9, {3.4902392833292503`*^9, 3.4902393062823753`*^9}, {
   3.4902397821417503`*^9, 3.4902398094542503`*^9}, {3.4902399467355003`*^9, 
   3.4902399884542503`*^9}, {3.4902400331730003`*^9, 
   3.4902400390167503`*^9}, {3.4902400727823753`*^9, 3.4902400950948753`*^9}, 
   3.4902405983917503`*^9, {3.4902406452355003`*^9, 3.4902406693761253`*^9}, 
   3.4902779321261253`*^9, 3.4902779758917503`*^9, 3.4902780721261253`*^9, {
   3.4902781145323753`*^9, 3.4902781270011253`*^9}, {3.4902789548136253`*^9, 
   3.4902789768292503`*^9}, 3.4902791782823753`*^9, 3.4903032492198753`*^9, 
   3.4903032834542503`*^9, 3.4903033194230003`*^9, {3.4903033505480003`*^9, 
   3.4903033632980003`*^9}, {3.4903034645636253`*^9, 3.4903035172511253`*^9}, 
   3.4903043780011253`*^9, 3.4903045769386253`*^9, {3.4903046113448753`*^9, 
   3.4903046359230003`*^9}, 3.4903048670948753`*^9, 3.4903048981886253`*^9, {
   3.4903049366573753`*^9, 3.4903049662511253`*^9}, 3.4903050202355003`*^9, 
   3.4903056490948753`*^9, 3.4903056984542503`*^9, 3.4903057340636253`*^9, 
   3.4903058041886253`*^9, 3.4903068360167503`*^9, {3.4903068825480003`*^9, 
   3.4903069092980003`*^9}, 3.490319452692375*^9, {3.490319555567375*^9, 
   3.490319578942375*^9}, {3.490319633129875*^9, 3.49031967580175*^9}, {
   3.490319754458*^9, 3.49031980030175*^9}, {3.490319870208*^9, 
   3.490319887067375*^9}, {3.490319967129875*^9, 3.490320031629875*^9}, 
   3.490320071942375*^9, 3.490320103379875*^9, 3.49032046505175*^9, {
   3.490320625473625*^9, 3.490320648129875*^9}, 3.4903207570205*^9, 
   3.490320794348625*^9, 3.490321783379875*^9, 3.4903223088955*^9, 
   3.490322570536125*^9, 3.490322820098625*^9, 3.490323084973625*^9, 
   3.490323139567375*^9, 3.4903258181455*^9, 3.4904778635559998`*^9, 
   3.4904786142591248`*^9, {3.4904852353528748`*^9, 3.4904852692747498`*^9}, 
   3.4904859631966248`*^9, 3.4904863323841248`*^9, 3.4904863921341248`*^9, 
   3.4905708941966248`*^9, 3.4905711668216248`*^9, 3.4905712885716248`*^9, 
   3.4905715378372498`*^9, 3.4905721378841248`*^9, 3.57652249256075*^9, 
   3.735065610644263*^9}],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{{0, 0.49999999999999994`, 1.}, {
     0, 0.5030107112554686, 0.9999939449006108}, {
     0, 0.5053601052859211, 0.9999807772438751}, {
     0, 0.5075091287703752, 0.9999622185680237}, {
     0, 0.5095366331194746, 0.9999389779735858}, {
     0, 0.5114776969638323, 0.9999114925178486}, {
     0, 0.5133520853953788, 0.9998800707513334}, {
     0, 0.5151724228995019, 0.9998449473450536}, {
     0, 0.5169474383326078, 0.9998063095068447}, {
     0, 0.5186835084938362, 0.9997643116507248}, {
     0, 0.5203854847967883, 0.9997190843292335}, {
     0, 0.5220571751337896, 0.9996707400456819}, {
     0, 0.5237016432811604, 0.9996193772313285}, {
     0, 0.5253214044819132, 0.9995650830766676}, {
     0, 0.5269185584678272, 0.9995079356124442}, {
     0, 0.5284948829913498, 0.9994480052801225}, {
     0, 0.5300519014518561, 0.999385356143639}, {
     0, 0.5315909329672844, 0.999320046842221}, {
     0, 0.5331131302155144, 0.9992521313519253}, {
     0, 0.534619508547993, 0.9991816596030143}, {
     0, 0.5361109687429949, 0.9991086779867676}, {
     0, 0.5375883150372486, 0.9990332297761686}, {
     0, 0.5390522695943267, 0.9989553554785835}, {
     0, 0.540503484244191, 0.9988750931340687}, {
     0, 0.5419425501050132, 0.9987924785697279}, {
     0, 0.5433700055417787, 0.9987075456181834}, {
     0, 0.5447863428042896, 0.99862032630648}, {
     0, 0.546192013606148, 0.9985308510204207}, {
     0, 0.547587433846693, 0.9984391486483352}, {
     0, 0.5489729876335138, 0.9983452467075059}, {
     0, 0.5503490307297004, 0.9982491714558789}, {
     0, 0.5517158935245917, 0.9981509479912092}, {
     0, 0.5530738836071235, 0.998050600339421}, {
     0, 0.5544232880057427, 0.9979481515336582}, {
     0, 0.5557643751468796, 0.997843623685263}, {
     0, 0.5570973965746097, 0.9977370380477212}, {
     0, 0.5584225884666104, 0.9976284150744555}, {
     0, 0.5597401729755543, 0.997517774471214}, {
     0, 0.5610503594202167, 0.997405135243693}, {
     0, 0.5623533453466495, 0.9972905157409434}, {
     0, 0.5636493174765815, 0.9971739336950337}, {
     0, 0.5649384525575399, 0.9970554062573778}, {
     0, 0.5662209181270422, 0.9969349500320833}, {
     0, 0.5674968732013819, 0.9968125811066331}, {
     0, 0.568766468898031, 0.9966883150801653}, {
     0, 0.5700298489994294, 0.9965621670895977}, {
     0, 0.5712871504648581, 0.9964341518337982}, {
     0, 0.572538503896203, 0.9963042835959935}, {
     0, 0.5737840339626679, 0.9961725762645741}, {
     0, 0.5750238597888176, 0.9960390433524455}, {
     0, 0.576258095309825, 0.9959036980150533}, {
     0, 0.5774868495972767, 0.9957665530671973}, {
     0, 0.5787102271585189, 0.9956276209987409}, {
     0, 0.5799283282121569, 0.9954869139893048}, {
     0, 0.581141248942029, 0.995344443922031}, {
     0, 0.5823490817316908, 0.9952002223964926}, {
     0, 0.5835519153812517, 0.9950542607408154}, {
     0, 0.5847498353081731, 0.9949065700230729}, {
     0, 0.5859429237334736, 0.9947571610620122}, {
     0, 0.5871312598546455, 0.9946060444371586}, {
     0, 0.5883149200064349, 0.9944532304983466}, {
     0, 0.5894939778105217, 0.9942987293747175}, {
     0, 0.5906685043150443, 0.994142550983224}, {
     0, 0.5918385681248077, 0.9939847050366726}, {
     0, 0.5930042355229321, 0.9938252010513405}, {
     0, 0.5941655705846323, 0.9936640483541923}, {
     0, 0.595322635283757, 0.9935012560897245}, {
     0, 0.5964754895926375, 0.993336833226463}, {
     0, 0.5976241915757732, 0.9931707885631357}, {
     0, 0.5987687974778148, 0.9930031307345396}, {
     0, 0.599909361806267, 0.9928338682171256}, {
     0, 0.6010459374093023, 0.9926630093343128}, {
     0, 0.6021785755490422, 0.9924905622615551}, {
     0, 0.6033073259706228, 0.9923165350311689}, {
     0, 0.6044322369673453, 0.9921409355369427}, {
     0, 0.605553355442186, 0.9919637715385354}, {
     0, 0.6066707269659115, 0.9917850506656789}, {
     0, 0.6077843958320296, 0.991604780422196}, {
     0, 0.6088944051087886, 0.9914229681898429}, {
     0, 0.6100007966884143, 0.9912396212319876}, {
     0, 0.6111036113337772, 0.9910547466971309}, {
     0, 0.6122028887226381, 0.990868351622281}, {
     0, 0.6132986674896362, 0.9906804429361892}, {
     0, 0.614390985266163, 0.9904910274624518}, {
     0, 0.6154798787182444, 0.9903001119224878}, {
     0, 0.6165653835825587, 0.9901077029383986}, {
     0, 0.617647534700705, 0.9899138070357131}, {
     0, 0.6187263660518166, 0.9897184306460285}, {
     0, 0.6198019107836347, 0.9895215801095465}, {
     0, 0.6208742012421081, 0.9893232616775162}, {
     0, 0.6219432689996323, 0.9891234815145818}, {
     0, 0.6230091448819781, 0.9889222457010464}, {
     0, 0.624071858994007, 0.9887195602350487}, {
     0, 0.6251314407442218, 0.9885154310346647}, {
     0, 0.626187918868233, 0.9883098639399297}, {
     0, 0.6272413214511889, 0.9881028647147914}, {
     0, 0.6282916759492315, 0.9878944390489923}, {
     0, 0.6293390092100261, 0.9876845925598873}, {
     0, 0.6303833474924172, 0.9874733307941983}, {
     0, 0.6314247164852583, 0.9872606592297088}, {
     0, 0.6324631413254498, 0.9870465832769016}, {
     0, 0.6334986466152337, 0.9868311082805412}, {
     0, 0.6345312564387838, 0.9866142395212035}, {
     0, 0.6355609943781174, 0.9863959822167568}, {
     0, 0.636587883528373, 0.9861763415237923}, {
     0, 0.6376119465124815, 0.9859553225390106}, {
     0, 0.6386332054952527, 0.9857329303005635}, {
     0, 0.6396516821969236, 0.9855091697893524}, {
     0, 0.6406673979061734, 0.9852840459302874}, {
     0, 0.6416803734926485, 0.9850575635935063}, {
     0, 0.6426906294190053, 0.9848297275955569}, {
     0, 0.6436981857525059, 0.9846005427005436}, {
     0, 0.6447030621761795, 0.9843700136212384}, {
     0, 0.6457052779995751, 0.9841381450201588}, {
     0, 0.646704852169116, 0.983904941510615}, {
     0, 0.6477018032780834, 0.983670407657725}, {
     0, 0.648696149576239, 0.9834345479794007}, {
     0, 0.6496879089791071, 0.9831973669473053}, {
     0, 0.6506770990769258, 0.9829588689877842}, {
     0, 0.6516637371432863, 0.9827190584827682}, {
     0, 0.6526478401434738, 0.9824779397706518}, {
     0, 0.6536294247425196, 0.9822355171471474}, {
     0, 0.654608507312978, 0.9819917948661153}, {
     0, 0.6555851039424394, 0.9817467771403714}, {
     0, 0.6565592304407954, 0.9815004681424725}, {
     0, 0.6575309023472551, 0.9812528720054803}, {
     0, 0.6585001349371362, 0.9810039928237054}, {
     0, 0.6594669432284272, 0.980753834653432}, {
     0, 0.6604313419881415, 0.9805024015136216}, {
     0, 0.6613933457384648, 0.9802496973865998}, {
     0, 0.662352968762703, 0.979995726218726}, {
     0, 0.6633102251110441, 0.9797404919210436}, {
     0, 0.6642651286061404, 0.9794839983699152}, {
     0, 0.6652176928485083, 0.9792262494076418}, {
     0, 0.6661679312217701, 0.978967248843065}, {
     0, 0.6671158568977272, 0.9787070004521552}, {
     0, 0.6680614828412808, 0.9784455079785862}, {
     0, 0.669004821815204, 0.9781827751342929}, {
     0, 0.6699458863847677, 0.9779188056000175}, {
     0, 0.6708846889222305, 0.9776536030258429}, {
     0, 0.6718212416111929, 0.9773871710317106}, {
     0, 0.6727555564508254, 0.977119513207929}, {
     0, 0.6736876452599717, 0.976850633115668}, {
     0, 0.674617519681131, 0.9765805342874427}, {
     0, 0.6755451911843294, 0.9763092202275852}, {
     0, 0.6764706710708753, 0.9760366944127057}, {
     0, 0.6773939704770116, 0.9757629602921435}, {
     0, 0.6783151003774636, 0.9754880212884062}, {
     0, 0.6792340715888872, 0.9752118807976004}, {
     0, 0.6801508947732188, 0.9749345421898519}, {
     0, 0.681065580440937, 0.9746560088097165}, {
     0, 0.6819781389542305, 0.9743762839765817}, {
     0, 0.6828885805300802, 0.9740953709850599}, {
     0, 0.6837969152432595, 0.9738132731053719}, {
     0, 0.684703153029252, 0.9735299935837226}, {
     0, 0.6856073036870899, 0.9732455356426695}, {
     0, 0.6865093768821199, 0.9729599024814811}, {
     0, 0.687409382148694, 0.9726730972764893}, {
     0, 0.6883073288927882, 0.9723851231814341}, {
     0, 0.6892032263945567, 0.9720959833278}, {
     0, 0.6900970838108155, 0.9718056808251461}, {
     0, 0.6909889101774646, 0.9715142187614296}, {
     0, 0.6918787144118481, 0.9712216002033214}, {
     0, 0.6927665053150518, 0.9709278281965164}, {
     0, 0.693652291574146, 0.9706329057660364}, {
     0, 0.6945360817643688, 0.9703368359165278}, {
     0, 0.6954178843512564, 0.9700396216325524}, {
     0, 0.696297707692721, 0.9697412658788728}, {
     0, 0.6971755600410757, 0.9694417716007316}, {
     0, 0.6980514495450105, 0.9691411417241258}, {
     0, 0.6989253842515195, 0.9688393791560752}, {
     0, 0.6997973721077829, 0.9685364867848854}, {
     0, 0.7006674209630018, 0.9682324674804057}, {
     0, 0.70153553857019, 0.967927324094283}, {
     0, 0.7024017325879219, 0.9676210594602086}, {
     0, 0.7032660105820403, 0.9673136763941629}, {
     0, 0.7041283800273239, 0.9670051776946526}, {
     0, 0.7049888483091143, 0.9666955661429464}, {
     0, 0.7058474227249062, 0.9663848445033031}, {
     0, 0.7067041104859002, 0.9660730155231981}, {
     0, 0.7075589187185208, 0.9657600819335443}, {
     0, 0.7084118544658985, 0.9654460464489083}, {
     0, 0.7092629246893183, 0.9651309117677244}, {
     0, 0.7101121362696349, 0.9648146805725031}, {
     0, 0.7109594960086582, 0.9644973555300361}, {
     0, 0.7118050106305044, 0.9641789392915987}, {
     0, 0.7126486867829205, 0.9638594344931465}, {
     0, 0.7134905310385757, 0.9635388437555101}, {
     0, 0.7143305498963282, 0.9632171696845861}, {
     0, 0.7151687497824595, 0.9628944148715239}, {
     0, 0.7160051370518876, 0.9625705818929103}, {
     0, 0.7168397179893483, 0.96224567331095}, {
     0, 0.7176724988105551, 0.9619196916736424}, {
     0, 0.7185034856633304, 0.961592639514958}, {
     0, 0.7193326846287167, 0.9612645193550077}, {
     0, 0.7201601017220606, 0.9609353337002123}, {
     0, 0.7209857428940761, 0.9606050850434686}, {
     0, 0.721809614031884, 0.9602737758643108}, {
     0, 0.722631720960031, 0.9599414086290716}, {
     0, 0.7234520694414859, 0.9596079857910388}, {
     0, 0.7242706651786166, 0.95927350979061}, {
     0, 0.7250875138141463, 0.9589379830554449}, {
     0, 0.7259026209320899, 0.9586014080006142}, {
     0, 0.7267159920586722, 0.958263787028747}, {
     0, 0.7275276326632255, 0.9579251225301754}, {
     0, 0.7283375481590711, 0.957585416883076}, {
     0, 0.7291457439043826, 0.9572446724536099}, {
     0, 0.7299522252030304, 0.9569028915960613}, {
     0, 0.7307569973054117, 0.9565600766529713}, {
     0, 0.7315600654092618, 0.9562162299552716}, {
     0, 0.732361434660451, 0.9558713538224157}, {
     0, 0.7331611101537656, 0.9555254505625076}, {
     0, 0.733959096933672, 0.9551785224724283}, {
     0, 0.7347553999950683, 0.9548305718379613}, {
     0, 0.7355500242840206, 0.9544816009339145}, {
     0, 0.7363429746984834, 0.9541316120242417}, {
     0, 0.7371342560890082, 0.9537806073621615}, {
     0, 0.7379238732594382, 0.9534285891902748}, {
     0, 0.738711830967589, 0.9530755597406794}, {
     0, 0.7394981339259165, 0.9527215212350837}, {
     0, 0.7402827868021737, 0.9523664758849194}, {
     0, 0.7410657942200536, 0.95201042589145}, {
     0, 0.7418471607598198, 0.951653373445881}, {
     0, 0.7426268909589273, 0.951295320729465}, {
     0, 0.7434049893126293, 0.9509362699136084}, {
     0, 0.7441814602745757, 0.9505762231599738}, {
     0, 0.7449563082573979, 0.9502151826205826}, {
     0, 0.7457295376332846, 0.9498531504379152}, {
     0, 0.746501152734547, 0.9494901287450103}, {
     0, 0.7472711578541718, 0.9491261196655624}, {
     0, 0.7480395572463682, 0.9487611253140178}, {
     0, 0.7488063551271007, 0.9483951477956694}, {
     0, 0.7495715556746158, 0.9480281892067497}, {
     0, 0.7503351630299563, 0.9476602516345236}, {
     0, 0.7510971812974705, 0.9472913371573779}, {
     0, 0.7518576145453075, 0.9469214478449117}, {
     0, 0.7526164668059078, 0.946550585758024}, {
     0, 0.7533737420764837, 0.946178752949}, {
     0, 0.7541294443194914, 0.9458059514615973}, {
     0, 0.7548835774630939, 0.9454321833311308}, {
     0, 0.7556361454016189, 0.9450574505845539}, {
     0, 0.7563871519960066, 0.9446817552405427}, {
     0, 0.7571366010742472, 0.9443050993095758}, {
     0, 0.7578844964318188, 0.9439274847940136}, {
     0, 0.7586308418321087, 0.9435489136881775}, {
     0, 0.7593756410068335, 0.943169387978428}, {
     0, 0.7601188976564512, 0.9427889096432392}, {
     0, 0.7608606154505642, 0.942407480653277}, {
     0, 0.7616007980283181, 0.9420251029714704}, {
     0, 0.7623394489987909, 0.9416417785530876}, {
     0, 0.7630765719413801, 0.9412575093458067}, {
     0, 0.7638121704061797, 0.9408722972897873}, {
     0, 0.7645462479143511, 0.9404861443177416}, {
     0, 0.7652788079584907, 0.9400990523550032}, {
     0, 0.7660098540029893, 0.9397110233195961}, {
     0, 0.7667393894843857, 0.9393220591223018}, {
     0, 0.7674674178117153, 0.9389321616667272}, {
     0, 0.7681939423668531, 0.9385413328493686}, {
     0, 0.7689189665048505, 0.9381495745596784}, {
     0, 0.7696424935542673, 0.9377568886801289}, {
     0, 0.770364526817498, 0.9373632770862742}, {
     0, 0.7710850695710935, 0.9369687416468152}, {
     0, 0.771804125066077, 0.936573284223659}, {
     0, 0.7725216965282554, 0.9361769066719811}, {
     0, 0.7732377871585256, 0.9357796108402847}, {
     0, 0.7739524001331765, 0.9353813985704605}, {
     0, 0.7746655386041851, 0.9349822716978455}, {
     0, 0.7753772056995091, 0.9345822320512802}, {
     0, 0.7760874045233748, 0.9341812814531663}, {
     0, 0.7767961381565605, 0.9337794217195218}, {
     0, 0.7775034096566747, 0.9333766546600392}, {
     0, 0.778209222058432, 0.9329729820781377}, {
     0, 0.7789135783739224, 0.932568405771019}, {
     0, 0.7796164815928784, 0.9321629275297205}, {
     0, 0.7803179346829373, 0.9317565491391687}, {
     0, 0.7810179405898986, 0.9313492723782307}, {
     0, 0.781716502237981, 0.9309410990197663}, {
     0, 0.7824136225300693, 0.9305320308306791}, {
     0, 0.7831093043479656, 0.9301220695719665}, {
     0, 0.7838035505526287, 0.9297112169987701}, {
     0, 0.784496363984417, 0.9292994748604241}, {
     0, 0.7851877474633225, 0.9288868449005041}, {
     0, 0.7858777037892044, 0.9284733288568754}, {
     0, 0.786566235742018, 0.9280589284617408}, {
     0, 0.7872533460820409, 0.9276436454416855}, {
     0, 0.7879390375500952, 0.9272274815177264}, {
     0, 0.7886233128677679, 0.9268104384053546}, {
     0, 0.7893061747376258, 0.9263925178145833}, {
     0, 0.7899876258434294, 0.9259737214499907}, {
     0, 0.7906676688503427, 0.9255540510107648}, {
     0, 0.7913463064051407, 0.9251335081907469}, {
     0, 0.7920235411364122, 0.9247120946784751}, {
     0, 0.7926993756547631, 0.924289812157226}, {
     0, 0.7933738125530123, 0.9238666623050578}, {
     0, 0.7940468544063899, 0.923442646794851}, {
     0, 0.7947185037727269, 0.9230177672943503}, {
     0, 0.7953887631926486, 0.9225920254662044}, {
     0, 0.7960576351897592, 0.9221654229680077}, {
     0, 0.7967251222708284, 0.9217379614523379}, {
     0, 0.7973912269259728, 0.9213096425667973}, {
     0, 0.798055951628836, 0.92088046795405}, {
     0, 0.7987192988367662, 0.9204504392518617}, {
     0, 0.7993812709909894, 0.9200195580931365}, {
     0, 0.8000418705167847, 0.9195878261059552}, {
     0, 0.8007010998236509, 0.9191552449136121}, {
     0, 0.8013589613054771, 0.9187218161346518}, {
     0, 0.8020154573407071, 0.9182875413829049}, {
     0, 0.8026705902925023, 0.9178524222675253}, {
     0, 0.8033243625089032, 0.9174164603930238}, {
     0, 0.803976776322988, 0.9169796573593049}, {
     0, 0.80462783405303, 0.9165420147617002}, {
     0, 0.8052775380026509, 0.9161035341910041}, {
     0, 0.8059258904609755, 0.9156642172335059}, {
     0, 0.8065728937027798, 0.9152240654710251}, {
     0, 0.8072185499886416, 0.914783080480944}, {
     0, 0.8078628615650861, 0.91434126383624}, {
     0, 0.8085058306647308, 0.913898617105519}, {
     0, 0.8091474595064284, 0.9134551418530469}, {
     0, 0.8097877502954075, 0.9130108396387813}, {
     0, 0.8104267052234119, 0.9125657120184043}, {
     0, 0.8110643264688382, 0.9121197605433519}, {
     0, 0.8117006161968705, 0.9116729867608451}, {
     0, 0.812335576559615, 0.9112253922139216}, {
     0, 0.8129692096962313, 0.9107769784414647}, {
     0, 0.8136015177330636, 0.9103277469782333}, {
     0, 0.8142325027837681, 0.9098776993548924}, {
     0, 0.814862166949442, 0.9094268370980406}, {
     0, 0.8154905123187471, 0.9089751617302408}, {
     0, 0.8161175409680343, 0.9085226747700471}, {
     0, 0.8167432549614663, 0.9080693777320344}, {
     0, 0.8173676563511373, 0.9076152721268261}, {
     0, 0.8179907471771936, 0.9071603594611213}, {
     0, 0.8186125294679496, 0.9067046412377225}, {
     0, 0.8192330052400065, 0.9062481189555629}, {
     0, 0.8198521764983644, 0.9057907941097334}, {
     0, 0.8204700452365375, 0.9053326681915086}, {
     0, 0.8210866134366656, 0.9048737426883736}, {
     0, 0.8217018830696242, 0.9044140190840502}, {
     0, 0.8223158560951344, 0.9039534988585219}, {
     0, 0.8229285344618709, 0.9034921834880599}, {
     0, 0.8235399201075675, 0.9030300744452495}, {
     0, 0.8241500149591234, 0.9025671731990127}, {
     0, 0.8247588209327076, 0.9021034812146348}, {
     0, 0.8253663399338601, 0.9016389999537886}, {
     0, 0.8259725738575949, 0.9011737308745579}, {
     0, 0.8265775245884988, 0.9007076754314627}, {
     0, 0.8271811940008319, 0.900240835075482}, {
     0, 0.8277835839586254, 0.8997732112540777}, {
     0, 0.8283846963157762, 0.8993048054112187}, {
     0, 0.8289845329161455, 0.8988356189874019}, {
     0, 0.829583095593651, 0.8983656534196779}, {
     0, 0.8301803861723615, 0.8978949101416707}, {
     0, 0.8307764064665876, 0.8974233905836027}, {
     0, 0.8313711582809746, 0.8969510961723156}, {
     0, 0.8319646434105915, 0.896478028331292}, {
     0, 0.8325568636410201, 0.8960041884806782}, {
     0, 0.8331478207484427, 0.8955295780373053}, {
     0, 0.8337375164997299, 0.8950541984147103}, {
     0, 0.8343259526525254, 0.8945780510231578}, {
     0, 0.8349131309553315, 0.8941011372696606}, {
     0, 0.8354990531475933, 0.8936234585580001}, {
     0, 0.8360837209597807, 0.893145016288748}, {
     0, 0.8366671361134714, 0.8926658118592852}, {
     0, 0.8372493003214321, 0.8921858466638231}, {
     0, 0.8378302152876969, 0.8917051220934227}, {
     0, 0.8384098827076482, 0.8912236395360154}, {
     0, 0.8389883042680952, 0.8907414003764215}, {
     0, 0.8395654816473493, 0.8902584059963707}, {
     0, 0.8401414165153034, 0.8897746577745197}, {
     0, 0.8407161105335054, 0.8892901570864736}, {
     0, 0.8412895653552332, 0.8888049053048028}, {
     0, 0.8418617826255712, 0.888318903799062}, {
     0, 0.8424327639814796, 0.8878321539358097}, {
     0, 0.8430025110518695, 0.887344657078626}, {
     0, 0.8435710254576745, 0.8868564145881297}, {
     0, 0.8441383088119183, 0.8863674278219991}, {
     0, 0.8447043627197894, 0.8858776981349863}, {
     0, 0.8452691887787067, 0.8853872268789376}, {
     0, 0.8458327885783886, 0.8848960154028103}, {
     0, 0.8463951637009218, 0.8844040650526891}, {
     0, 0.8469563157208277, 0.8839113771718046}, {
     0, 0.8475162462051274, 0.8834179531005497}, {
     0, 0.8480749567134094, 0.8829237941764964}, {
     0, 0.8486324487978921, 0.8824289017344131}, {
     0, 0.8491887240034895, 0.8819332771062807}, {
     0, 0.8497437838678742, 0.8814369216213088}, {
     0, 0.8502976299215388, 0.8809398366059532}, {
     0, 0.8508502636878594, 0.8804420233839306}, {
     0, 0.8514016866831573, 0.8799434832762352}, {
     0, 0.8519519004167573, 0.8794442176011553}, {
     0, 0.85250090639105, 0.8789442276742873}, {
     0, 0.853048706101551, 0.8784435148085529}, {
     0, 0.8535953010369574, 0.8779420803142145}, {
     0, 0.8541406926792092, 0.8774399254988885}, {
     0, 0.8546848825035442, 0.8769370516675633}, {
     0, 0.8552278719785561, 0.8764334601226125}, {
     0, 0.8557696625662506, 0.8759291521638101}, {
     0, 0.8563102557221014, 0.8754241290883457}, {
     0, 0.8568496528951044, 0.8749183921908384}, {
     0, 0.8573878555278326, 0.8744119427633532}, {
     0, 0.8579248650564913, 0.8739047820954124}, {
     0, 0.8584606829109696, 0.8733969114740127}, {
     0, 0.8589953105148945, 0.8728883321836372}, {
     0, 0.8595287492856828, 0.8723790455062713}, {
     0, 0.8600610006345929, 0.8718690527214151}, {
     0, 0.860592065966776, 0.8713583551060978}, {
     0, 0.8611219466813268, 0.8708469539348922}, {
     0, 0.8616506441713337, 0.8703348504799261}, {
     0, 0.862178159823929, 0.8698220460108977}, {
     0, 0.8627044950203361, 0.8693085417950888}, {
     0, 0.8632296511359214, 0.8687943390973764}, {
     0, 0.8637536295402396, 0.8682794391802472}, {
     0, 0.8642764315970825, 0.8677638433038112}, {
     0, 0.8647980586645261, 0.8672475527258122}, {
     0, 0.8653185120949772, 0.8667305687016433}, {
     0, 0.8658377932352206, 0.8662128924843572}, {0.0006613781017822207, 
     0.8663559034264627, 0.8656945253246806}, {0.001697375533353692, 
     0.866872844004379, 0.8651754684710254}, {0.0027328931296558704`, 
     0.8673886162991578, 0.8646557231695019}, {0.0037679309716143064`, 
     0.8679032216355447, 0.8641352906639306}, {0.00480248913703323, 
     0.8684166613328873, 0.8636141721958539}, {0.005836567700627997, 
     0.8689289367051775, 0.8630923690045496}, {0.006870166734054723, 
     0.8694400490610957, 0.862569882327041}, {0.007903286305942768, 
     0.8699499997040532, 0.8620467133981105}, {0.008935926481924305, 
     0.8704587899322339, 0.8615228634503096}, {0.009968087324664306, 
     0.8709664210386363, 0.8609983337139722}, {0.010999768893890888`, 
     0.8714728943111159, 0.8604731254172251}, {0.012030971246425532`, 
     0.871978211032425, 0.8599472397859994}, {0.013061694436210507`, 
     0.8724823724802535, 0.8594206780440431}, {0.014091938514339328`, 
     0.8729853799272701, 0.8588934414129309}, {0.015121703529084618`, 
     0.8734872346411605, 0.858365531112076}, {0.01615098952592712, 
     0.8739879378846684, 0.8578369483587414}, {0.017179796547583028`, 
     0.8744874909156337, 0.8573076943680507}, {0.018208124634032614`, 
     0.8749858949870312, 0.8567777703529986}, {0.019235973822545892`, 
     0.8754831513470086, 0.8562471775244628}, {0.020263344147712466`, 
     0.875979261238926, 0.8557159170912136}, {0.02129023564146631, 
     0.8764742259013915, 0.855183990259925}, {0.0223166483331132, 
     0.876968046568299, 0.8546513982351858}, {0.023342582249357435`, 
     0.8774607244688659, 0.8541181422195087}, {0.024368037414326586`, 
     0.877952260827669, 0.8535842234133423}, {0.02539301384959916, 
     0.8784426568646797, 0.8530496430150807}, {0.026417511574228794`, 
     0.878931913795302, 0.852514402221073}, {0.02744153060476972, 
     0.879420032830405, 0.8519785022256353}, {0.02846507095530239, 
     0.8799070151763612, 0.8514419442210588}, {0.029488132637458673`, 
     0.8803928620350792, 0.8509047293976205}, {0.030510715660443957`, 
     0.880877574604038, 0.8503668589435942}, {0.03153282003106483, 
     0.8813611540763233, 0.8498283340452587}, {0.032554445753750806`, 
     0.881843601640659, 0.8492891558869081}, {0.03357559283057836, 
     0.8823249184814408, 0.8487493256508626}, {0.034596261261296536`, 
     0.8828051057787721, 0.8482088445174756}, {0.03561645104334613, 
     0.8832841647084927, 0.8476677136651467}, {0.03663616217188825, 
     0.8837620964422156, 0.8471259342703275}, {0.0376553946398219, 
     0.8842389021473556, 0.8465835075075339}, {0.03867414843781088, 
     0.8847145829871641, 0.8460404345493532}, {0.039692423554302914`, 
     0.8851891401207588, 0.8454967165664556}, {0.04071021997555425, 
     0.8856625747031559, 0.8449523547276017}, {0.04172753768565037, 
     0.8861348878853016, 0.8444073501996513}, {0.042744376666528125`, 
     0.8866060808141022, 0.843861704147574}, {0.04376073689799726, 
     0.8870761546324544, 0.8433154177344572}, {0.04477661835776158, 
     0.8875451104792766, 0.842768492121515}, {0.04579202102144067, 
     0.8880129494895377, 0.8422209284680972}, {0.04680694486259015, 
     0.8884796727942879, 0.8416727279316978}, {0.0478213898527224, 
     0.8889452815206865, 0.8411238916679642}, {0.04883535596132806, 
     0.8894097767920334, 0.8405744208307053}, {0.04984884315589501, 
     0.8898731597277953, 0.8400243165719005}, {0.05086185140192914, 
     0.8903354314436368, 0.8394735800417076}, {0.051874380662974215`, 
     0.8907965930514463, 0.8389222123884721}, {0.052886430900632, 
     0.8912566456593666, 0.8383702147587345}, {0.053898002074581536`, 
     0.8917155903718211, 0.8378175882972395}, {0.0549090941425979, 
     0.8921734282895418, 0.8372643341469438}, {0.05591970706057207, 
     0.8926301605095963, 0.8367104534490244}, {0.056929840782529696`, 
     0.8930857881254163, 0.8361559473428863}, {0.057939495260650425`, 
     0.8935403122268224, 0.8356008169661719}, {0.05894867044528562, 
     0.8939937339000523, 0.8350450634547667}, {0.059957366284976985`, 
     0.8944460542277868, 0.8344886879428098}, {0.0609655827264753, 
     0.8948972742891752, 0.8339316915626999}, {0.061973319714758966`, 
     0.8953473951598625, 0.8333740754451036}, {0.06298057719305036, 
     0.895796417912014, 0.8328158407189638}, {0.06398735510283494, 
     0.8962443436143415, 0.8322569885115065}, {0.06499365338387848, 
     0.8966911733321277, 0.8316975199482491}, {0.06599947197424366, 
     0.8971369081272519, 0.8311374361530082}, {0.06700481081030937, 
     0.897581549058215, 0.8305767382479056}, {0.06800966982678576, 
     0.8980250971801633, 0.8300154273533775}, {0.0690140489567315, 
     0.8984675535449131, 0.8294535045881816}, {0.07001794813157212, 
     0.8989089192009755, 0.8288909710694035}, {0.07102136728111474, 
     0.8993491951935794, 0.8283278279124648}, {0.0720243063335653, 
     0.899788382564696, 0.8277640762311306}, {0.07302676521554517, 
     0.9002264823530614, 0.8271997171375163}, {0.07402874385210696, 
     0.9006634955942011, 0.8266347517420942}, {0.07503024216675029, 
     0.9010994233204521, 0.8260691811537019}, {0.07603126008143851, 
     0.9015342665609867, 0.825503006479548}, {0.07703179751661335, 
     0.9019680263418337, 0.8249362288252204}, {0.07803185439121131, 
     0.9024007036859034, 0.8243688492946922}, {0.07903143062267869, 
     0.9028322996130077, 0.8238008689903289}, {0.08003052612698645, 
     0.9032628151398824, 0.823232289012896}, {0.08102914081864718, 
     0.9036922512802111, 0.822663110461564}, {0.08202727461072729, 
     0.9041206090446449, 0.8220933344339174}, {0.08302492741486411, 
     0.9045478894408241, 0.8215229620259601}, {0.08402209914128017, 
     0.9049740934734015, 0.8209519943321215}, {0.08501878969879681, 
     0.9053992221440617, 0.8203804324452648}, {0.08601499899484992, 
     0.9058232764515421, 0.8198082774566923}, {0.08701072693550323, 
     0.9062462573916552, 0.8192355304561522}, {0.08800597342546351, 
     0.9066681659573083, 0.8186621925318448}, {0.0890007383680937, 
     0.9070890031385237, 0.8180882647704301}, {0.0899950216654277, 
     0.90750876992246, 0.8175137482570325}, {0.09098882321818282, 
     0.9079274672934312, 0.8169386440752485}, {0.09198214292577571, 
     0.9083450962329278, 0.816362953307152}, {0.0929749806863337, 
     0.9087616577196352, 0.8157866770333017}, {0.09396733639670989, 
     0.9091771527294552, 0.8152098163327454}, {0.0949592099524949, 
     0.9095915822355235, 0.8146323722830286}, {0.09595060124803151, 
     0.9100049472082303, 0.8140543459601988}, {0.09694151017642787, 
     0.9104172486152398, 0.8134757384388119}, {0.09793193662956824, 
     0.9108284874215072, 0.8128965507919389}, {0.09892188049812833, 
     0.9112386645892999, 0.8123167840911717}, {0.09991134167158769, 
     0.9116477810782154, 0.8117364394066277}, {0.10090032003824077`, 
     0.9120558378451984, 0.8111555178069577}, {0.10188881548521057`, 
     0.9124628358445614, 0.8105740203593509}, {0.10287682789846159`, 
     0.9128687760280019, 0.8099919481295403}, {0.10386435716281119`, 
     0.9132736593446201, 0.8094093021818088}, {0.10485140316194126`, 
     0.9136774867409372, 0.8088260835789958}, {0.10583796577841251`, 
     0.9140802591609135, 0.808242293382501}, {0.10682404489367359`, 
     0.9144819775459657, 0.807657932652292}, {0.10780964038807557`, 
     0.9148826428349844, 0.8070730024469088}, {0.10879475214088219`, 
     0.9152822559643518, 0.8064875038234696}, {0.10977938003028125`, 
     0.915680817867958, 0.8059014378376766}, {0.11076352393339735`, 
     0.916078329477219, 0.8053148055438217}, {0.11174718372630305`, 
     0.9164747917210937, 0.8047276079947907}, {0.11273035928402925`, 
     0.9168702055260998, 0.8041398462420706}, {0.11371305048057799`, 
     0.9172645718163314, 0.8035515213357534}, {0.11469525718893193`, 
     0.9176578915134744, 0.8029626343245425}, {0.11567697928106699`, 
     0.9180501655368245, 0.8023731862557575}, {0.116658216627962, 
     0.9184413948033019, 0.8017831781753398}, {0.11763896909961055`, 
     0.9188315802274682, 0.8011926111278577}, {0.11861923656503173`, 
     0.9192207227215426, 0.8006014861565108}, {0.11959901889227961`, 
     0.919608823195417, 0.8000098043031375}, {0.12057831594845587`, 
     0.919995882556673, 0.799417566608217}, {0.12155712759971762`, 
     0.9203819017105951, 0.7988247741108774}, {0.12253545371129078`, 
     0.9207668815601896, 0.7982314278488988}, {0.12351329414747807`, 
     0.9211508230061972, 0.7976375288587192}, {0.124490648771671, 
     0.9215337269471097, 0.7970430781754386}, {0.1254675174463576, 
     0.9219155942791838, 0.7964480768328261}, {0.12644390003313621`, 
     0.922296425896458, 0.7958525258633219}, {0.12741979639272158`, 
     0.9226762226907662, 0.7952564262980445}, {0.12839520638495705`, 
     0.923054985551752, 0.7946597791667948}, {0.12937012986882368`, 
     0.9234327153668849, 0.7940625854980611}, {0.13034456670245054`, 
     0.9238094130214736, 0.793464846319023}, {0.13131851674312311`, 
     0.924185079398681, 0.7928665626555579}, {0.13229197984729396`, 
     0.9245597153795383, 0.7922677355322443}, {0.13326495587059203`, 
     0.9249333218429593, 0.7916683659723672}, {0.1342374446678319, 
     0.9253058996657543, 0.7910684549979223}, {0.1352094460930228, 
     0.9256774497226442, 0.7904680036296216}, {0.13618095999937851`, 
     0.9260479728862748, 0.7898670128868964}, {0.1371519862393256, 
     0.9264174700272299, 0.7892654837879042}, {0.1381225246645133, 
     0.9267859420140445, 0.7886634173495312}, {0.13909257512582285`, 
     0.9271533897132203, 0.7880608145873975}, {0.14006213747337493`, 
     0.9275198139892371, 0.7874576765158623}, {0.1410312115565402, 
     0.9278852157045672, 0.786854004148027}, {0.14199979722394662`, 
     0.9282495957196879, 0.7862497984957414}, {0.14296789432348947`, 
     0.9286129548930959, 0.7856450605696064}, {0.1439355027023396, 
     0.928975294081319, 0.7850397913789794}, {0.14490262220695133`, 
     0.9293366141389299, 0.7844339919319785}, {0.14586925268307094`, 
     0.929696915918558, 0.7838276632354871}, {0.14683539397574666`, 
     0.9300562002709036, 0.7832208062951571}, {0.14780104592933513`, 
     0.9304144680447497, 0.7826134221154146}, {0.148766208387511, 
     0.9307717200869742, 0.7820055116994631}, {0.14973088119327438`, 
     0.9311279572425629, 0.7813970760492884}, {0.15069506418895917`, 
     0.9314831803546219, 0.7807881161656627}, {0.15165875721624147`, 
     0.9318373902643895, 0.780178633048148}, {0.1526219601161471, 
     0.9321905878112486, 0.7795686276951016}, {0.1535846727290603, 
     0.9325427738327388, 0.7789581011036786}, {0.1545468948947304, 
     0.932893949164568, 0.7783470542698376}, {0.15550862645228108`, 
     0.9332441146406247, 0.7777354881883437}, {0.15646986724021672`, 
     0.9335932710929897, 0.777123403852773}, {0.15743061709643186`, 
     0.933941419351948, 0.7765108022555162}, {0.15839087585821604`, 
     0.9342885602459995, 0.7758976843877835}, {0.15935064336226495`, 
     0.9346346946018719, 0.775284051239607}, {0.16030991944468514`, 
     0.9349798232445315, 0.7746699037998462}, {0.16126870394100248`, 
     0.935323946997194, 0.7740552430561914}, {0.16222699668616927`, 
     0.9356670666813365, 0.7734400699951671}, {0.16318479751457232`, 
     0.9360091831167087, 0.7728243856021364}, {0.16414210626003925`, 
     0.9363502971213439, 0.7722081908613045}, {0.1650989227558463, 
     0.9366904095115695, 0.7715914867557231}, {0.16605524683472556`, 
     0.9370295211020189, 0.7709742742672933}, {0.16701107832887105`, 
     0.9373676327056413, 0.7703565543767702}, {0.16796641706994703`, 
     0.9377047451337134, 0.7697383280637663}, {0.16892126288909462`, 
     0.9380408591958496, 0.7691195963067549}, {0.16987561561693823`, 
     0.9383759757000127, 0.7685003600830745}, {0.1708294750835927, 
     0.9387100954525248, 0.767880620368932}, {0.1717828411186706, 
     0.9390432192580769, 0.7672603781394063}, {0.1727357135512884, 
     0.9393753479197404, 0.7666396343684521}, {0.17368809221007278`, 
     0.9397064822389765, 0.7660183900289036}, {0.17463997692316885`, 
     0.9400366230156468, 0.7653966460924779}, {0.17559136751824464`, 
     0.9403657710480235, 0.7647744035297788}, {0.17654226382249963`, 
     0.9406939271327995, 0.7641516633102999}, {0.17749266566266964`, 
     0.9410210920650985, 0.7635284264024289}, {0.17844257286503468`, 
     0.9413472666384843, 0.7629046937734496}, {0.17939198525542424`, 
     0.9416724516449717, 0.7622804663895475}, {0.18034090265922384`, 
     0.9419966478750352, 0.7616557452158115}, {0.18128932490138236`, 
     0.94231985611762, 0.7610305312162376}, {0.18223725180641595`, 
     0.94264207716015, 0.7604048253537341}, {0.18318468319841724`, 
     0.942963311788539, 0.7597786285901217}, {0.18413161890105895`, 
     0.9432835607871991, 0.7591519418861402}, {0.18507805873760125`, 
     0.9436028249390508, 0.7585247662014497}, {0.18602400253089812`, 
     0.9439211050255324, 0.7578971024946343}, {0.18696945010340152`, 
     0.9442384018266082, 0.7572689517232066}, {0.18791440127716974`, 
     0.9445547161207795, 0.7566403148436096}, {0.1888588558738715, 
     0.9448700486850918, 0.7560111928112204}, {0.18980281371479255`, 
     0.9451844002951463, 0.7553815865803537}, {0.1907462746208416, 
     0.9454977717251064, 0.7547514971042648}, {0.1916892384125557, 
     0.9458101637477084, 0.7541209253351527}, {0.19263170491010617`, 
     0.9461215771342703, 0.753489872224164}, {0.19357367393330405`, 
     0.9464320126546989, 0.752858338721395}, {0.19451514530160618`, 
     0.9467414710775015, 0.7522263257758954}, {0.19545611883412067`, 
     0.9470499531697921, 0.7515938343356714}, {0.1963965943496118, 
     0.9473574596973011, 0.7509608653476892}, {0.1973365716665061, 
     0.9476639914243841, 0.750327419757878}, {0.19827605060289816`, 
     0.9479695491140296, 0.7496934985111315}, {0.1992150309765557, 
     0.9482741335278692, 0.7490591025513134}, {0.20015351260492373`, 
     0.9485777454261828, 0.7484242328212592}, {0.2010914953051327, 
     0.9488803855679112, 0.7477888902627786}, {0.20202897889400076`, 
     0.9491820547106606, 0.7471530758166599}, {0.20296596318804075`, 
     0.9494827536107133, 0.7465167904226725}, {0.20390244800346538`, 
     0.9497824830230344, 0.745880035019569}, {0.20483843315619205`, 
     0.950081243701281, 0.745242810545089}, {0.20577391846184676`, 
     0.9503790363978093, 0.7446051179359625}, {0.20670890373577244`, 
     0.9506758618636837, 0.7439669581279112}, {0.2076433887930301, 
     0.9509717208486836, 0.7433283320556535}, {0.20857737344840718`, 
     0.9512666141013122, 0.7426892406529051}, {0.20951085751641987`, 
     0.9515605423688038, 0.742049684852384}, {0.2104438408113201, 
     0.9518535063971318, 0.7414096655858117}, {0.21137632314709942`, 
     0.9521455069310164, 0.7407691837839171}, {0.21230830433749337`, 
     0.9524365447139324, 0.7401282403764389}, {0.21323978419598827`, 
     0.9527266204881164, 0.7394868362921282}, {0.2141707625358233, 
     0.9530157349945751, 0.7388449724587518}, {0.215101239169998, 
     0.953303888973092, 0.7382026498030941}, {0.21603121391127417`, 
     0.9535910831622357, 0.7375598692509615}, {0.21696068657218318`, 
     0.9538773182993662, 0.7369166317271829}, {0.21788965696502888`, 
     0.9541625951206434, 0.7362729381556143}, {0.21881812490189337`, 
     0.954446914361034, 0.7356287894591406}, {0.2197460901946405, 
     0.9547302767543184, 0.7349841865596779}, {0.22067355265492075`, 
     0.9550126830330985, 0.7343391303781778}, {0.22160051209417655`, 
     0.9552941339288045, 0.7336936218346279}, {0.2225269683236455, 
     0.9555746301717019, 0.7330476618480565}, {0.2234529211543656, 
     0.9558541724908988, 0.7324012513365333}, {0.22437837039717953`, 
     0.9561327616143532, 0.7317543912171737}, {0.22530331586273886`, 
     0.9564103982688791, 0.7311070824061402}, {0.22622775736150882`, 
     0.9566870831801545, 0.7304593258186457}, {0.2271516947037713, 
     0.956962817072727, 0.7298111223689558}, {0.22807512769963115`, 
     0.9572376006700221, 0.7291624729703909}, {0.228998056159019, 
     0.9575114346943487, 0.7285133785353298}, {0.22992047989169578`, 
     0.9577843198669066, 0.7278638399752109}, {0.23084239870725692`, 
     0.9580562569077928, 0.727213858200536}, {0.23176381241513633`, 
     0.9583272465360082, 0.7265634341208719}, {0.232684720824611, 
     0.9585972894694643, 0.7259125686448532}, {0.2336051237448049, 
     0.9588663864249899, 0.725261262680185}, {0.23452502098469274`, 
     0.9591345381183372, 0.7246095171336444}, {0.23544441235310432`, 
     0.9594017452641886, 0.7239573329110842}, {0.236363297658728, 
     0.9596680085761626, 0.7233047109174346}, {0.23728167671011535`, 
     0.9599333287668211, 0.7226516520567058}, {0.23819954931568518`, 
     0.9601977065476751, 0.7219981572319899}, {0.23911691528372617`, 
     0.9604611426291906, 0.7213442273454643}, {0.24003377442240262`, 
     0.9607236377207957, 0.720689863298393}, {0.24095012653975642`, 
     0.9609851925308863, 0.7200350659911299}, {0.2418659714437125, 
     0.9612458077668324, 0.71937983632312}, {0.2427813089420813, 
     0.9615054841349844, 0.7187241751929031}, {0.24369613884256355`, 
     0.9617642223406786, 0.718068083498115}, {0.24461046095275363`, 
     0.9620220230882437, 0.7174115621354901}, {0.2455242750801427, 
     0.9622788870810068, 0.7167546120008641}, {0.24643758103212327`, 
     0.9625348150212992, 0.716097233989176}, {0.24735037861599263`, 
     0.9627898076104626, 0.71543942899447}, {0.24826266763895607`, 
     0.9630438655488543, 0.7147811979098982}, {0.24917444790813068`, 
     0.9632969895358539, 0.7141225416277233}, {0.2500857192305498, 
     0.9635491802698684, 0.7134634610393186}, {0.2509964814131644, 
     0.9638004384483382, 0.712803957035174}, {0.2519067342628493, 
     0.9640507647677433, 0.7121440305048939}, {0.25281647758640435`, 
     0.964300159923608, 0.7114836823372036}, {0.25372571119055964`, 
     0.9645486246105075, 0.710822913419948}, {0.2546344348819776, 
     0.9647961595220729, 0.7101617246400954}, {0.25554264846725744`, 
     0.965042765350997, 0.7095001168837396}, {0.25645035175293746`, 
     0.9652884427890397, 0.7088380910361022}, {0.25735754454549997`, 
     0.9655331925270337, 0.7081756479815338}, {0.25826422665137316`, 
     0.9657770152548898, 0.7075127886035166}, {0.25917039787693547`, 
     0.9660199116616026, 0.7068495137846672}, {0.2600760580285175, 
     0.9662618824352553, 0.7061858244067378}, {0.26098120691240734`, 
     0.9665029282630259, 0.7055217213506184}, {0.26188584433485224`, 
     0.9667430498311913, 0.704857205496339}, {0.2627899701020616, 
     0.966982247825134, 0.7041922777230724}, {0.26369358402021176`, 
     0.9672205229293463, 0.7035269389091346}, {0.26459668589544794`, 
     0.9674578758274363, 0.7028611899319882}, {0.2654992755338879, 
     0.967694307202132, 0.7021950316682442}, {0.2664013527416248, 
     0.9679298177352877, 0.701528464993663}, {0.2673029173247297, 
     0.9681644081078882, 0.7008614907831584}, {0.2682039690892569, 
     0.9683980790000541, 0.7001941099107972}, {0.2691045078412439, 
     0.9686308310910474, 0.6995263232498036}, {0.27000453338671715`, 
     0.9688626650592757, 0.6988581316725584}, {0.270904045531693, 
     0.9690935815822971, 0.6981895360506042}, {0.2718030440821824, 
     0.9693235813368267, 0.6975205372546442}, {0.2727015288441928, 
     0.9695526649987393, 0.6968511361545464}, {0.2735994996237312, 
     0.969780833243076, 0.6961813336193448}, {0.27449695622680786`, 
     0.9700080867440479, 0.6955111305172401}, {0.27539389845943796`, 
     0.9702344261750421, 0.6948405277156042}, {0.27629032612764576`, 
     0.9704598522086254, 0.6941695260809797}, {0.2771862390374666, 
     0.9706843655165496, 0.6934981264790829}, {0.27808163699494987`, 
     0.9709079667697557, 0.6928263297748058}, {0.2789765198061626, 
     0.9711306566383796, 0.692154136832217}, {0.27987088727719134`, 
     0.971352435791756, 0.6914815485145647}, {0.28076473921414496`, 
     0.9715733048984229, 0.690808565684278}, {0.28165807542315874`, 
     0.9717932646261269, 0.6901351892029682}, {0.28255089571039477`, 
     0.972012315641827, 0.6894614199314322}, {0.2834431998820478, 
     0.9722304586117, 0.6887872587296522}, {0.2843349877443444, 
     0.972447694201144, 0.6881127064567997}, {0.28522625910354865`, 
     0.9726640230747838, 0.6874377639712352}, {0.2861170137659634, 
     0.9728794458964749, 0.6867624321305115}, {0.28700725153793255`, 
     0.9730939633293079, 0.6860867117913753}, {0.28789697222584526`, 
     0.9733075760356129, 0.6854106038097677}, {0.2887861756361367, 
     0.9735202846769645, 0.6847341090408279}, {0.28967486157529204`, 
     0.9737320899141851, 0.6840572283388932}, {0.29056302984984866`, 
     0.9739429924073502, 0.6833799625575014}, {0.29145068026639803`, 
     0.9741529928157917, 0.6827023125493936}, {0.2923378126315893, 
     0.9743620917981031, 0.6820242791665138}, {0.2932244267521312, 
     0.9745702900121432, 0.681345863260012}, {0.2941105224347943, 
     0.9747775881150406, 0.6806670656802463}, {0.29499609948641453`, 
     0.9749839867631973, 0.6799878872767828}, {0.2958811577138943, 
     0.9751894866122939, 0.6793083288983995}, {0.29676569692420623`, 
     0.9753940883172925, 0.6786283913930863}, {0.2976497169243947, 
     0.9755977925324418, 0.677948075608047}, {0.29853321752157863`, 
     0.9758005999112807, 0.6772673823897019}, {0.29941619852295387`, 
     0.9760025111066419, 0.6765863125836881}, {0.30029865973579556`, 
     0.9762035267706577, 0.6759048670348622}, {0.3011806009674601, 
     0.9764036475547614, 0.6752230465873013}, {0.3020620220253885, 
     0.9766028741096934, 0.6745408520843048}, {0.3029429227171078, 
     0.9768012070855041, 0.6738582843683963}, {0.3038233028502338, 
     0.9769986471315584, 0.6731753442813244}, {0.30470316223247274`, 
     0.9771951948965387, 0.672492032664066}, {0.3055825006716249, 
     0.9773908510284499, 0.6718083503568251}, {0.3064613179755853, 
     0.9775856161746227, 0.6711242981990373}, {0.30733961395234705`, 
     0.977779490981717, 0.6704398770293699}, {0.30821738841000335`, 
     0.9779724760957265, 0.6697550876857232}, {0.30909464115674956`, 
     0.978164572161982, 0.6690699310052325}, {0.3099713720008854, 
     0.9783557798251556, 0.6683844078242702}, {0.3108475807508172, 
     0.9785460997292634, 0.6676985189784462}, {0.3117232672150599, 
     0.9787355325176705, 0.6670122653026106}, {0.3125984312022399, 
     0.9789240788330938, 0.6663256476308541}, {0.3134730725210959, 
     0.9791117393176062, 0.6656386667965103}, {0.3143471909804827, 
     0.9792985146126396, 0.6649513236321569}, {0.3152207863893717, 
     0.9794844053589893, 0.6642636189696175}, {0.316093858556854, 
     0.9796694121968168, 0.6635755536399628}, {0.3169664072921428, 
     0.979853535765654, 0.6628871284735113}, {0.3178384324045737, 
     0.9800367767044067, 0.6621983442998329}, {0.3187099337036091, 
     0.9802191356513574, 0.6615092019477483}, {0.31958091099883795`, 
     0.9804006132441696, 0.6608197022453317}, {0.3204513640999801, 
     0.9805812101198913, 0.6601298460199111}, {0.3213212928168862, 
     0.9807609269149575, 0.6594396340980713}, {0.32219069695954095`, 
     0.9809397642651949, 0.658749067305654}, {0.32305957633806515`, 
     0.9811177228058245, 0.6580581464677594}, {0.32392793076271664`, 
     0.9812948031714652, 0.6573668724087486}, {0.3247957600438935, 
     0.9814710059961372, 0.6566752459522438}, {0.3256630639921345, 
     0.9816463319132653, 0.6559832679211308}, {0.326529842418123, 
     0.9818207815556825, 0.6552909391375594}, {0.3273960951326871, 
     0.9819943555556325, 0.6545982604229454}, {0.3282618219468023, 
     0.9821670545447744, 0.6539052325979721}, {0.3291270226715937, 
     0.9823388791541845, 0.6532118564825907}, {0.32999169711833704`, 
     0.9825098300143603, 0.6525181328960233}, {0.33085584509846117`, 
     0.982679907755224, 0.6518240626567628}, {0.3317194664235498, 
     0.9828491130061249, 0.651129646582575}, {0.33258256090534344`, 
     0.983017446395843, 0.6504348854904995}, {0.3334451283557406, 
     0.9831849085525927, 0.6497397801968521}, {0.33430716858680054`, 
     0.9833515001040247, 0.6490443315172243}, {0.33516868141074435`, 
     0.9835172216772308, 0.6483485402664865}, {0.33602966663995754`, 
     0.9836820738987452, 0.6476524072587877}, {0.3368901240869902, 
     0.9838460573945488, 0.6469559333075587}, {0.33775005356456056`, 
     0.9840091727900723, 0.6462591192255117}, {0.33860945488555616`, 
     0.9841714207101983, 0.6455619658246421}, {0.33946832786303477`, 
     0.9843328017792653, 0.6448644739162305}, {0.34032667231022773`, 
     0.9844933166210704, 0.6441666443108427}, {0.34118448804053914`, 
     0.984652965858872, 0.6434684778183327}, {0.342041774867551, 
     0.9848117501153932, 0.6427699752478423}, {0.3428985326050222, 
     0.9849696700128249, 0.6420711374078026}, {0.3437547610668906, 
     0.9851267261728277, 0.6413719651059371}, {0.3446104600672755, 
     0.9852829192165362, 0.6406724591492606}, {0.3454656294204788, 
     0.9854382497645611, 0.6399726203440823}, {0.34632026894098744`, 
     0.9855927184369921, 0.6392724494960047}, {0.34717437844347376`, 
     0.9857463258534014, 0.6385719474099276}, {0.34802795774279716`, 
     0.9858990726328454, 0.6378711148900483}, {0.34888100665400723`, 
     0.9860509593938688, 0.6371699527398614}, {0.34973352499234406`, 
     0.9862019867545067, 0.6364684617621625}, {0.3505855125732401, 
     0.9863521553322873, 0.635766642759047}, {0.3514369692123217, 
     0.9865014657442354, 0.6350644965319135}, {0.3522878947254112, 
     0.9866499186068742, 0.634362023881463}, {0.35313828892852717`, 
     0.9867975145362292, 0.633659225607702}, {0.3539881516378878, 
     0.9869442541478296, 0.6329561025099417}, {0.3548374826699107, 
     0.9870901380567122, 0.6322526553868015}, {0.3556862818412156, 
     0.9872351668774234, 0.6315488850362079}, {0.3565345489686253, 
     0.9873793412240223, 0.6308447922553969}, {0.35738228386916726`, 
     0.9875226617100826, 0.6301403778409154}, {0.35822948636007546`, 
     0.9876651289486967, 0.6294356425886213}, {0.35907615625879113`, 
     0.987806743552477, 0.6287305872936858}, {0.3599222933829648, 
     0.9879475061335588, 0.628025212750594}, {0.3607678975504575, 
     0.9880874173036033, 0.6273195197531457}, {0.36161296857934266`, 
     0.9882264776738001, 0.6266135090944573}, {0.36245750628790696`, 
     0.9883646878548693, 0.6259071815669625}, {0.3633015104946519, 
     0.988502048457065, 0.625200537962413}, {0.3641449810182959, 
     0.9886385600901766, 0.6244935790718806}, {0.36498791767777383`, 
     0.9887742233635322, 0.6237863056857583}, {0.3658303202922417, 
     0.9889090388860011, 0.6230787185937594}, {0.36667218868107404`, 
     0.989043007265996, 0.6223708185849219}, {0.36751352266386866`, 
     0.9891761291114753, 0.6216626064476067}, {0.3683543220604457, 
     0.9893084050299462, 0.6209540829695005}, {0.3691945866908511, 
     0.9894398356284666, 0.6202452489376155}, {0.37003431637535594`, 
     0.9895704215136477, 0.6195361051382918}, {0.3708735109344583, 
     0.9897001632916566, 0.6188266523571981}, {0.37171217018888614`, 
     0.9898290615682183, 0.618116891379332}, {0.37255029395959677`, 
     0.9899571169486185, 0.6174068229890217}, {0.3733878820677784, 
     0.990084330037706, 0.6166964479699276}, {0.37422493433485243`, 
     0.9902107014398946, 0.6159857671050422}, {0.37506145058247403`, 
     0.9903362317591659, 0.6152747811766918}, {0.375897430632534, 
     0.9904609215990714, 0.6145634909665374}, {0.3767328743071585, 
     0.990584771562735, 0.6138518972555764}, {0.37756778142871245`, 
     0.990707782252855, 0.6131400008241426}, {0.3784021518197994, 
     0.990829954271707, 0.6124278024519075}, {0.3792359853032634, 
     0.9909512882211452, 0.6117153029178818}, {0.3800692817021897, 
     0.9910717847026057, 0.6110025030004161}, {0.380902040839906, 
     0.9911914443171083, 0.6102894034772023}, {0.38173426253998466`, 
     0.9913102676652584, 0.6095760051252737}, {0.3825659466262434, 
     0.99142825534725, 0.6088623087210066}, {0.3833970929227454, 
     0.991545407962867, 0.6081483150401217}, {0.3842277012538017, 
     0.9916617261114865, 0.6074340248576848}, {0.38505777144397246`, 
     0.9917772103920797, 0.6067194389481072}, {0.3858873033180679, 
     0.9918918614032151, 0.6060045580851472}, {0.38671629670114877`, 
     0.9920056797430603, 0.6052893830419115}, {0.3875447514185289, 
     0.9921186660093841, 0.6045739145908551}, {0.38837266729577463`, 
     0.9922308207995586, 0.603858153503784}, {0.3892000441587077, 
     0.9923421447105616, 0.6031421005518539}, {0.39002688183340517`, 
     0.9924526383389782, 0.6024257565055732}, {0.3908531801462015, 
     0.9925623022810037, 0.6017091221348022}, {0.3916789389236889, 
     0.9926711371324447, 0.6009921982087558}, {0.39250415799271804`, 
     0.9927791434887218, 0.6002749854960037}, {0.393328837180401, 
     0.9928863219448716, 0.5995574847644706}, {0.3941529763141106, 
     0.9929926730955487, 0.5988396967814381}, {0.39497657522148166`, 
     0.9930981975350277, 0.598121622313546}, {0.3957996337304134, 
     0.9932028958572051, 0.5974032621267917}, {0.3966221516690698, 
     0.9933067686556017, 0.596684616986532}, {0.39744412886587915`, 
     0.9934098165233639, 0.5959656876574848}, {0.3982655651495374, 
     0.9935120400532667, 0.5952464749037292}, {0.3990864603490088, 
     0.9936134398377144, 0.5945269794887055}, {0.39990681429352565`, 
     0.9937140164687439, 0.5938072021752182}, {0.4007266268125906, 
     0.9938137705380258, 0.5930871437254351}, {0.4015458977359767, 
     0.9939127026368664, 0.5923668049008897}, {0.40236462689372954`, 
     0.9940108133562099, 0.5916461864624802}, {0.4031828141161674, 
     0.9941081032866401, 0.5909252891704726}, {0.4040004592338826, 
     0.9942045730183827, 0.5902041137845001}, {0.4048175620777425, 
     0.9943002231413066, 0.5894826610635642}, {0.4056341224788904, 
     0.9943950542449262, 0.5887609317660358}, {0.406450140268747, 
     0.9944890669184031, 0.5880389266496562}, {0.40726561527901, 
     0.9945822617505481, 0.587316646471538}, {0.4080805473416574, 
     0.9946746393298228, 0.5865940919881654}, {0.40889493628894585`, 
     0.9947662002443417, 0.5858712639553959}, {0.4097087819534141, 
     0.9948569450818741, 0.58514816312846}, {0.4105220841678811, 
     0.9949468744298453, 0.5844247902619641}, {0.41133484276545074`, 
     0.9950359888753394, 0.5837011461098887}, {0.412147057579509, 
     0.9951242890051, 0.582977231425591}, {0.4129587284437271, 
     0.995211775405533, 0.5822530469618059}, {0.413769855192062, 
     0.9952984486627077, 0.5815285934706457}, {0.4145804376587572, 
     0.9953843093623587, 0.5808038717036015}, {0.41539047567834314`, 
     0.9954693580898878, 0.5800788824115446}, {0.41619996908563944`, 
     0.9955535954303657, 0.5793536263447262}, {0.41700891771575443`, 
     0.9956370219685335, 0.5786281042527792}, {0.417817321404087, 
     0.995719638288805, 0.577902316884718}, {0.4186251799863262, 
     0.9958014449752677, 0.5771762649889415}, {0.41943249329845467`, 
     0.9958824426116849, 0.5764499493132302}, {0.4202392611767462, 
     0.9959626317814975, 0.5757233706047512}, {0.4210454834577694, 
     0.9960420130678251, 0.5749965296100558}, {0.4218511599783871, 
     0.9961205870534686, 0.5742694270750814}, {0.4226562905757575, 
     0.996198354320911, 0.5735420637451535}, {0.42346087508733504`, 
     0.9962753154523193, 0.5728144403649842}, {0.4242649133508715, 
     0.9963514710295466, 0.5720865576786751}, {0.4250684052044164, 
     0.9964268216341331, 0.5713584164297166}, {0.42587135048631813`, 
     0.996501367847308, 0.57063001736099}, {0.426673749035225, 
     0.9965751102499912, 0.5699013612147663}, {0.42747560069008556`, 
     0.996648049422795, 0.5691724487327093}, {0.4282769052901499, 
     0.9967201859460247, 0.5684432806558748}, {0.42907766267496933`, 
     0.9967915203996821, 0.5677138577247126}, {0.42987787268439986`, 
     0.9968620533634651, 0.5669841806790652}, {0.4306775351585989, 
     0.9969317854167705, 0.5662542502581716}, {0.4314766499380304, 
     0.9970007171386951, 0.5655240672006646}, {0.4322752168634624, 
     0.9970688491080374, 0.564793632244575}, {0.43307323577596957`, 
     0.997136181903299, 0.5640629461273293}, {0.43387070651693277`, 
     0.9972027161026861, 0.5633320095857532}, {0.4346676289280417, 
     0.9972684522841113, 0.5626008233560696}, {0.43546400285129333`, 
     0.9973333910251949, 0.5618693881739015}, {0.43625982812899416`, 
     0.9973975329032664, 0.5611377047742722}, {0.4370551046037608, 
     0.9974608784953658, 0.560405773891605}, {0.43784983211852024`, 
     0.9975234283782458, 0.5596735962597255}, {0.438644010516511, 
     0.9975851831283724, 0.5589411726118614}, {0.4394376396412843, 
     0.9976461433219269, 0.5582085036806427}, {0.4402307193367028, 
     0.9977063095348071, 0.5574755901981043}, {0.44102324944694404`, 
     0.9977656823426291, 0.556742432895685}, {0.4418152298164999, 
     0.9978242623207282, 0.5560090325042283}, {0.44260666029017653`, 
     0.9978820500441609, 0.5552753897539843}, {0.4433975407130966, 
     0.9979390460877058, 0.5545415053746091}, {0.4441878709306989, 
     0.9979952510258655, 0.5538073800951666}, {0.44497765078873874`, 
     0.9980506654328678, 0.5530730146441291}, {0.44576688013329097`, 
     0.9981052898826669, 0.552338409749376}, {0.4465555588107472, 
     0.9981591249489452, 0.5516035661381979}, {0.4473436866678199, 
     0.9982121712051142, 0.5508684845372943}, {0.44813126355154, 
     0.9982644292243162, 0.5501331656727763}, {0.4489182893092605, 
     0.9983158995794259, 0.5493976102701655}, {0.44970476378865415`, 
     0.9983665828430511, 0.5486618190543969}, {0.4504906868377172, 
     0.9984164795875345, 0.5479257927498175}, {0.4512760583047673, 
     0.9984655903849552, 0.547189532080188}, {0.452060878038446, 
     0.9985139158071294, 0.5464530377686835}, {0.4528451458877186, 
     0.9985614564256123, 0.5457163105378937}, {0.453628861701875, 
     0.9986082128116992, 0.5449793511098242}, {0.4544120253305303, 
     0.998654185536427, 0.5442421602058967}, {0.4551946366236255, 
     0.9986993751705753, 0.5435047385469496}, {0.4559766954314282, 
     0.9987437822846673, 0.542767086853239}, {0.456758201604533, 
     0.9987874074489722, 0.5420292058444393}, {0.4575391549938622, 
     0.9988302512335056, 0.5412910962396432}, {0.45831955545066627`, 
     0.9988723142080305, 0.5405527587573641}, {0.4590994028265249, 
     0.9989135969420597, 0.5398141941155348}, {0.459878696973348, 
     0.9989541000048563, 0.5390754030315084}, {0.46065743774337414`, 
     0.9989938239654347, 0.5383363862220605}, {0.4614356249891742, 
     0.9990327693925624, 0.5375971444033882}, {0.46221325856364964`, 
     0.9990709368547611, 0.5368576782911115}, {0.46299033832003417`, 
     0.9991083269203079, 0.5361179886002737}, {0.46376686411189394`, 
     0.9991449401572364, 0.5353780760453425}, {0.46454283579312805`, 
     0.999180777133338, 0.5346379413402098}, {0.46531825321797016`, 
     0.9992158384161629, 0.5338975851981927}, {0.46609311624098726`, 
     0.9992501245730221, 0.5331570083320347}, {0.4668674247170817, 
     0.9992836361709873, 0.5324162114539055}, {0.4676411785014913, 
     0.9993163737768933, 0.531675195275402}, {0.4684143774497897, 
     0.9993483379573385, 0.5309339605075486}, {0.4691870214178872, 
     0.999379529278686, 0.5301925078607986}, {0.4699591102620314, 
     0.9994099483070653, 0.5294508380450339}, {0.4707306438388072, 
     0.9994395956083733, 0.528708951769566}, {0.4715016220051376, 
     0.9994684717482748, 0.5279668497431371}, {0.4722720446182851, 
     0.9994965772922045, 0.5272245326739194}, {0.47304191153585085`, 
     0.9995239128053678, 0.5264820012695169}, {0.47381122261577585`, 
     0.9995504788527418, 0.5257392562369658}, {0.4745799777163417, 
     0.9995762759990766, 0.524996298282735}, {0.47534817669617063`, 
     0.9996013048088964, 0.5242531281127256}, {0.47611581941422665`, 
     0.9996255658465003, 0.5235097464322738}, {0.47688290572981507`, 
     0.9996490596759642, 0.522766153946149}, {0.47764943550258354`, 
     0.9996717868611409, 0.5220223513585573}, {0.47841540859252396`, 
     0.9996937479656618, 0.5212783393731377}, {0.47918082485997016`, 
     0.999714943552938, 0.5205341186929677}, {0.47994568416560063`, 
     0.999735374186161, 0.5197896900205604}, {0.4807099863704377, 
     0.9997550404283042, 0.5190450540578663}, {0.4814737313358495, 
     0.9997739428421236, 0.5183002115062741}, {0.48223691892354875`, 
     0.9997920819901591, 0.5175551630666103}, {0.4829995489955946, 
     0.9998094584347356, 0.5168099094391408}, {0.48376162141439233`, 
     0.9998260727379635, 0.5160644513235713}, {0.48452313604269404`, 
     0.9998419254617408, 0.5153187894190467}, {0.48528409274359885`, 
     0.9998570171677529, 0.5145729244241539}, {0.4860444913805542, 
     0.9998713484174745, 0.5138268570369202}, {0.48680433181735605`, 
     0.9998849197721703, 0.5130805879548143}, {0.48756361391814823`, 
     0.9998977317928962, 0.5123341178747479}, {0.4883223375474237, 
     0.9999097850405, 0.5115874474930763}, {0.4890805025700261, 
     0.9999210800756225, 0.5108405775055964}, {0.4898381088511482, 
     0.9999316174586987, 0.5100935086075505}, {0.4905951562563334, 
     0.9999413977499588, 0.5093462414936254}, {0.4913516446514766, 
     0.9999504215094287, 0.5085987768579521}, {0.49210757390282356`, 
     0.9999586892969317, 0.5078511153941081}, {0.4928629438769722, 
     0.9999662016720886, 0.5071032577951163}, {0.4936177544408723, 
     0.9999729591943198, 0.5063552047534475}, {0.494372005461827, 
     0.9999789624228453, 0.5056069569610183}, {0.4951256968074918, 
     0.9999842119166859, 0.504858515109194}, {0.4958788283458768, 
     0.9999887082346643, 0.5041098798887875}, {0.49663139994534455`, 
     0.9999924519354062, 0.5033610519900616}, {0.4973834114746135, 
     0.9999954435773407, 0.5026120321027272}, {0.49813486280275604`, 
     0.9999976837187018, 0.5018628209159457}, {0.4988857537992, 
     0.9999991729175289, 0.5011134191183289}, {0.49963608433372864`, 
     0.9999999117316681, 0.5003638273979395}, {0.500385854276482, 
     0.9999999007187729, 0.499614046442291}, {0.5011350634979549, 
     0.9999991404363049, 0.49886407693835005`}, {0.5018837118690008, 
     0.9999976314415352, 0.49811391957253437`}, {0.5026317992608291, 
     0.999995374291545, 0.49736357503071577`}, {0.5033793255450079, 
     0.9999923695432263, 0.49661304399821843`}, {0.5041262905934618, 
     0.9999886177532835, 0.4958623271598216}, {0.5048726942784751, 
     0.9999841194782333, 0.49511142519975815`}, {0.50561853647269, 
     0.9999788752744065, 0.49436033880171654`}, {0.506363817049108, 
     0.9999728856979483, 0.4936090686488402}, {0.5071085358810906, 
     0.9999661513048193, 0.4928576154237287}, {0.5078526928423586, 
     0.9999586726507963, 0.49210597980843773`}, {0.508596287806993, 
     0.9999504502914737, 0.49135416248448066`}, {0.5093393206494355, 
     0.9999414847822633, 0.49060216413282776`}, {0.5100817912444892, 
     0.9999317766783964, 0.4898499854339071}, {0.5108236994673175, 
     0.9999213265349234, 0.4890976270676058}, {0.5115650451934466, 
     0.9999101349067157, 0.48834508971326895`}, {0.5123058282987636, 
     0.9998982023484657, 0.4875923740497019}, {0.5130460486595187, 
     0.9998855294146883, 0.48683948075516953`}, {0.5137857061523249, 
     0.9998721166597214, 0.48608641050739654`}, {0.5145248006541573, 
     0.9998579646377267, 0.4853331639835693}, {0.5152633320423555, 
     0.9998430739026903, 0.48457974186033476`}, {0.5160013001946218, 
     0.9998274450084241, 0.4838261448138023}, {0.5167387049890236, 
     0.9998110785085662, 0.48307237351954246`}, {0.5174755463039918, 
     0.9997939749565816, 0.48231842865258984`}, {0.5182118240183223, 
     0.9997761349057634, 0.481564310887441}, {0.5189475380111759, 
     0.9997575589092332, 0.4808100208980573}, {0.5196826881620793, 
     0.9997382475199419, 0.48005555935786254`}, {0.520417274350924, 
     0.9997182012906709, 0.4793009269397469}, {0.5211512964579683, 
     0.9996974207740325, 0.47854612431606414`}, {0.5218847543638363, 
     0.9996759065224705, 0.4777911521586342}, {0.5226176479495184, 
     0.9996536590882615, 0.47703601113874305`}, {0.5233499770963731, 
     0.9996306790235154, 0.4762807019271423}, {0.5240817416861249, 
     0.9996069668801759, 0.47552522519405105`}, {0.524812941600866, 
     0.9995825232100216, 0.4747695816091556}, {0.5255435767230568, 
     0.9995573485646667, 0.4740137718416098}, {0.5262736469355263, 
     0.9995314434955617, 0.4732577965600354}, {0.5270031521214705, 
     0.9995048085539938, 0.4725016564325233}, {0.5277320921644553, 
     0.9994774442910884, 0.4717453521266332}, {0.5284604669484146, 
     0.9994493512578091, 0.4709888843093945}, {0.5291882763576528, 
     0.9994205300049586, 0.47023225364730586`}, {0.529915520276843, 
     0.9993909810831798, 0.4694754608063369}, {0.5306421985910276, 
     0.9993607050429559, 0.4687185064519284}, {0.5313683111856204, 
     0.9993297024346119, 0.4679613912489914}, {0.5320938579464051, 
     0.9992979738083144, 0.46720411586190924`}, {0.5328188387595356, 
     0.9992655197140728, 0.46644668095453723`}, {0.5335432535115371, 
     0.9992323407017404, 0.4656890871902033}, {0.534267102089306, 
     0.999198437321014, 0.46493133523170793`}, {0.5349903843801097, 
     0.9991638101214356, 0.46417342574132586`}, {0.5357131002715884, 
     0.9991284596523927, 0.4634153593808044}, {0.5364352496517527, 
     0.999092386463119, 0.46265713681136633`}, {0.537156832408987, 
     0.9990555911026949, 0.461898758693708}, {0.5378778484320469, 
     0.9990180741200486, 0.4611402256880017}, {0.5385982976100616, 
     0.9989798360639561, 0.4603815384538945}, {0.5393181798325329, 
     0.9989408774830428, 0.4596226976505098}, {0.540037494989336, 
     0.9989011989257833, 0.4588637039364473}, {0.5407562429707192, 
     0.9988608009405024, 0.4581045579697832}, {0.5414744236673049, 
     0.9988196840753759, 0.457345260408071}, {0.5421920369700896, 
     0.9987778488784309, 0.45658581190834135`}, {0.5429090827704431, 
     0.9987352958975468, 0.4558262131271037}, {0.5436255609601109, 
     0.9986920256804557, 0.4550664647203447}, {0.5443414714312123, 
     0.9986480387747431, 0.4543065673435307}, {0.5450568140762416, 
     0.9986033357278484, 0.4535465216516067}, {0.5457715887880685, 
     0.9985579170870661, 0.4527863282989975}, {0.5464857954599374, 
     0.9985117833995455, 0.45202598793960813`}, {0.5471994339854691, 
     0.9984649352122921, 0.45126550122682285`}, {0.5479125042586598, 
     0.9984173730721677, 0.4505048688135079}, {0.5486250061738814, 
     0.9983690975258916, 0.44974409135201016`}, {0.5493369396258827, 
     0.9983201091200405, 0.44898316949415784`}, {0.5500483045097881, 
     0.9982704084010497, 0.4482221038912614}, {0.5507591007210992, 
     0.9982199959152132, 0.44746089519411386`}, {0.5514693281556947, 
     0.9981688722086847, 0.44669954405298995`}, {0.5521789867098293, 
     0.9981170378274782, 0.44593805111764884`}, {0.5528880762801361, 
     0.9980644933174679, 0.44517641703733185`}, {0.553596596763625, 
     0.9980112392243901, 0.444414642460765}, {0.554304548057684, 
     0.9979572760938423, 0.4436527280361582}, {0.5550119300600783, 
     0.9979026044712848, 0.44289067441120644`}, {0.5557187426689519, 
     0.9978472249020409, 0.44212848223308904`}, {0.5564249857828265, 
     0.9977911379312977, 0.44136615214847114`}, {0.5571306593006029, 
     0.9977343441041061, 0.4406036848035031}, {0.5578357631215594, 
     0.997676843965382, 0.4398410808438227}, {0.5585402971453542, 
     0.9976186380599068, 0.43907834091455256`}, {0.5592442612720241, 
     0.9975597269323274, 0.43831546566030327`}, {0.5599476554019849, 
     0.9975001111271573, 0.4375524557251723}, {0.5606504794360325, 
     0.9974397911887769, 0.4367893117527442}, {0.5613527332753409, 
     0.9973787676614343, 0.43602603438609333`}, {0.5620544168214654, 
     0.9973170410892455, 0.4352626242677801}, {0.5627555299763402, 
     0.9972546120161951, 0.434499082039855}, {0.56345607264228, 
     0.9971914809861371, 0.433735408343857}, {0.5641560447219794, 
     0.9971276485427947, 0.43297160382081523`}, {0.564855446118514, 
     0.9970631152297617, 0.4322076691112475}, {0.565554276735339, 
     0.9969978815905023, 0.4314436048551633}, {0.5662525364762916, 
     0.9969319481683524, 0.43067941169206087`}, {0.5669502252455886, 
     0.9968653155065192, 0.42991509026093055`}, {0.567647342947829, 
     0.9967979841480825, 0.42915064120025354`}, {0.5683438894879921, 
     0.9967299546359948, 0.42838606514800265`}, {0.5690398647714392, 
     0.9966612275130817, 0.42762136274164253`}, {0.5697352687039126, 
     0.9965918033220429, 0.4268565346181304}, {0.5704301011915365, 
     0.9965216826054523, 0.42609158141391573`}, {0.5711243621408179, 
     0.9964508659057585, 0.42532650376494063`}, {0.5718180514586436, 
     0.9963793537652856, 0.42456130230664196`}, {0.5725111690522846, 
     0.9963071467262334, 0.4237959776739488}, {0.5732037148293931, 
     0.996234245330678, 0.4230305305012847}, {0.5738956886980043, 
     0.9961606501205721, 0.42226496142256764`}, {0.5745870905665355, 
     0.9960863616377459, 0.42149927107121044`}, {0.5752779203437862, 
     0.9960113804239074, 0.42073346008012114`}, {0.57596817793894, 
     0.9959357070206425, 0.4199675290817025}, {0.5766578632615628, 
     0.995859341969416, 0.4192014787078532}, {0.5773469762216034, 
     0.9957822858115717, 0.4184353095899684}, {0.578035516729394, 
     0.9957045390883333, 0.41766902235893927`}, {0.5787234846956506, 
     0.9956261023408044, 0.41690261764515385`}, {0.5794108800314716, 
     0.995546976109969, 0.4161360960784975}, {0.5800977026483405, 
     0.9954671609366924, 0.415369458288352}, {0.580783952458123, 
     0.9953866573617213, 0.4146027049035982}, {0.5814696293730701, 
     0.9953054659256839, 0.41383583655261363`}, {0.5821547333058157, 
     0.9952235871690915, 0.4130688538632759}, {0.5828392641693781, 
     0.9951410216323376, 0.4123017574629595}, {0.5835232218771601, 
     0.9950577698556994, 0.4115345479785392}, {0.5842066063429487, 
     0.9949738323793372, 0.4107672260363885}, {0.5848894174809149, 
     0.9948892097432961, 0.4099997922623813}, {0.585571655205615, 
     0.9948039024875054, 0.4092322472818904}, {0.5862533194319897, 
     0.9947179111517793, 0.40846459171978966`}, {0.5869344100753641, 
     0.9946312362758177, 0.40769682620045367`}, {0.5876149270514482, 
     0.9945438783992063, 0.40692895134775803`}, {0.5882948702763381, 
     0.9944558380614168, 0.40616096778507865`}, {0.5889742396665137, 
     0.9943671158018079, 0.4053928761352942}, {0.5896530351388405, 
     0.9942777121596253, 0.4046246770207848}, {0.5903312566105695, 
     0.9941876276740024, 0.4038563710634329}, {0.5910089039993368, 
     0.9940968628839602, 0.40308795888462323`}, {0.5916859772231641, 
     0.994005418328408, 0.4023194411052438}, {0.5923624762004591, 
     0.9939132945461445, 0.4015508183456853}, {0.5930384008500145, 
     0.9938204920758568, 0.40078209122584246`}, {0.5937137510910092, 
     0.9937270114561221, 0.4000132603651128}, {0.5943885268430077, 
     0.9936328532254071, 0.3992443263823993}, {0.5950627280259606, 
     0.9935380179220693, 0.39847528989610864`}, {0.5957363545602049, 
     0.9934425060843564, 0.39770615152415156`}, {0.5964094063664628, 
     0.9933463182504079, 0.3969369118839451}, {0.5970818833658436, 
     0.9932494549582543, 0.3961675715924106}, {0.5977537854798426, 
     0.9931519167458182, 0.39539813126597567`}, {0.5984251126303415, 
     0.9930537041509144, 0.3946285915205729}, {0.599095864739608, 
     0.9929548177112505, 0.3938589529716426}, {0.599766041730297, 
     0.9928552579644271, 0.39308921623412996`}, {0.6004356435254498, 
     0.9927550254479379, 0.3923193819224881}, {0.601104670048494, 
     0.992654120699171, 0.3915494506506769}, {0.6017731212232446, 
     0.9925525442554081, 0.39077942303216345`}, {0.6024409969739029, 
     0.9924502966538256, 0.39000929967992265`}, {0.6031082972250569, 
     0.9923473784314949, 0.389239081206438}, {0.6037750219016826, 
     0.9922437901253826, 0.3884687682236998}, {0.6044411709291423, 
     0.9921395322723505, 0.38769836134320823`}, {0.6051067442331847, 
     0.9920346054091573, 0.3869278611759725}, {0.6057717417399474, 
     0.991929010072457, 0.3861572683325096}, {0.6064361633759534, 
     0.991822746798801, 0.3853865834228476}, {0.6071000090681145, 
     0.9917158161246371, 0.3846158070565226}, {0.6077632787437292, 
     0.991608218586311, 0.3838449398425817}, {0.6084259723304828, 
     0.9914999547200656, 0.3830739823895828}, {0.609088089756449, 
     0.9913910250620424, 0.3823029353055933}, {0.6097496309500885, 
     0.9912814301482809, 0.3815317991981924}, {0.6104105958402498, 
     0.9911711705147194, 0.3807605746744695}, {0.6110709843561689, 
     0.9910602466971952, 0.37998926234102626`}, {0.6117307964274697, 
     0.9909486592314452, 0.3792178628039754}, {0.6123900319841636, 
     0.9908364086531057, 0.37844637666894204`}, {0.6130486909566498, 
     0.9907234954977133, 0.3776748045410634}, {0.613706773275715, 
     0.9906099203007049, 0.37690314702498984`}, {0.6143642788725344, 
     0.9904956835974181, 0.3761314047248837}, {0.6150212076786711, 
     0.9903807859230913, 0.3753595782444202}, {0.6156775596260752, 
     0.9902652278128645, 0.37458766818678935`}, {0.6163333346470856, 
     0.9901490098017793, 0.37381567515469366`}, {0.6169885326744294, 
     0.9900321324247792, 0.37304359975034956`}, {0.6176431536412215, 
     0.9899145962167097, 0.37227144257548833`}, {0.6182971974809645, 
     0.9897964017123195, 0.37149920423135496`}, {0.6189506641275496, 
     0.9896775494462595, 0.3707268853187099}, {0.6196035535152562, 
     0.9895580399530843, 0.3699544864378281}, {0.6202558655787517, 
     0.9894378737672517, 0.36918200818849994`}, {0.620907600253092, 
     0.9893170514231233, 0.3684094511700313}, {0.6215587574737208, 
     0.989195573454965, 0.3676368159812442}, {0.6222093371764708, 
     0.9890734403969469, 0.3668641032204761}, {0.6228593392975627, 
     0.9889506527831436, 0.36609131348558094`}, {0.6235087637736049, 
     0.9888272111475351, 0.36531844737393016`}, {0.6241576105415957, 
     0.9887031160240063, 0.36454550548241066`}, {0.6248058795389202, 
     0.9885783679463477, 0.36377248840742743`}, {0.625453570703353, 
     0.9884529674482557, 0.3629993967449027}, {0.6261006839730568, 
     0.9883269150633328, 0.362226231090276}, {0.6267472192865827, 
     0.988200211325088, 0.3614529920385053}, {0.6273931765828707, 
     0.9880728567669365, 0.3606796801840657}, {0.6280385558012486, 
     0.9879448519222009, 0.35990629612095226`}, {0.6286833568814334, 
     0.9878161973241109, 0.3591328404426775}, {0.6293275797635302, 
     0.9876868935058035, 0.35835931374227326`}, {0.629971224388033, 
     0.9875569410003238, 0.3575857166122907}, {0.6306142906958243, 
     0.9874263403406246, 0.3568120496448001}, {0.6312567786281749, 
     0.9872950920595671, 0.35603831343139214`}, {0.6318986881267449, 
     0.987163196689921, 0.3552645085631762}, {0.6325400191335817, 
     0.987030654764365, 0.3544906356307833}, {0.6331807715911228, 
     0.9868974668154867, 0.35371669522436383`}, {0.6338209454421938, 
     0.986763633375783, 0.3529426879335892}, {0.6344605406300082, 
     0.9866291549776605, 0.35216861434765206`}, {0.6350995570981692, 
     0.9864940321534355, 0.35139447505526616`}, {0.6357379947906682, 
     0.9863582654353343, 0.3506202706446661}, {0.6363758536518849, 
     0.9862218553554941, 0.34984600170360913`}, {0.6370131336265882, 
     0.986084802445962, 0.34907166881937374`}, {0.6376498346599354, 
     0.9859471072386964, 0.34829727257876075`}, {0.6382859566974723, 
     0.9858087702655663, 0.347522813568094}, {0.6389214996851338, 
     0.9856697920583527, 0.3467482923732188}, {0.6395564635692429, 
     0.9855301731487476, 0.3459737095795046}, {0.6401908482965117, 
     0.9853899140683547, 0.3451990657718429}, {0.6408246538140405, 
     0.9852490153486904, 0.34442436153464984`}, {0.6414578800693183, 
     0.9851074775211828, 0.34364959745186446`}, {0.6420905270102232, 
     0.9849653011171725, 0.3428747741069493}, {0.6427225945850213, 
     0.9848224866679132, 0.34209989208289177`}, {0.6433540827423682, 
     0.9846790347045711, 0.34132495196220297`}, {0.643984991431306, 
     0.9845349457582262, 0.3405499543269201}, {0.6446153206012684, 
     0.984390220359871, 0.3397748997586027}, {0.645245070202075, 
     0.9842448590404127, 0.33899978883833753`}, {0.6458742401839358, 
     0.9840988623306713, 0.33822462214673554`}, {0.6465028304974481, 
     0.9839522307613817, 0.3374494002639338}, {0.6471308410935981, 
     0.9838049648631928, 0.33667412376959466`}, {0.6477582719237608, 
     0.9836570651666677, 0.33589879324290695`}, {0.6483851229396993, 
     0.9835085322022848, 0.33512340926258544`}, {0.6490113940935657, 
     0.9833593665004369, 0.3343479724068712}, {0.6496370853378994, 
     0.9832095685914323, 0.3335724832535327}, {0.6502621966256299, 
     0.9830591390054944, 0.3327969423798645}, {0.6508867279100737, 
     0.9829080782727623, 0.33202135036268854`}, {0.6515106791449361, 
     0.9827563869232909, 0.33124570777835477`}, {0.6521340502843107, 
     0.9826040654870509, 0.3304700152027401}, {0.6527568412826801, 
     0.9824511144939294, 0.3296942732112492}, {0.653379052094914, 
     0.9822975344737298, 0.32891848237881566`}, {0.6540006826762714, 
     0.9821433259561717, 0.32814264327990017`}, {0.6546217329823993, 
     0.981988489470892, 0.3273667564884926}, {0.6552422029693321, 
     0.9818330255474444, 0.3265908225781122}, {0.6558620925934935, 
     0.9816769347152995, 0.32581484212180595`}, {0.6564814018116949, 
     0.9815202175038455, 0.32503881569215065`}, {0.6571001305811355, 
     0.9813628744423881, 0.3242627438612525}, {0.6577182788594035, 
     0.9812049060601505, 0.3234866272007471}, {0.6583358466044738, 
     0.9810463128862743, 0.32271046628180056`}, {0.6589528337747104, 
     0.9808870954498188, 0.32193426167510836`}, {0.659569240328865, 
     0.9807272542797614, 0.3211580139508964}, {0.6601850662260771, 
     0.9805667899049986, 0.3203817236789213}, {0.6608003114258744, 
     0.9804057028543448, 0.31960539142847044`}, {0.6614149758881718, 
     0.9802439936565338, 0.3188290177683619}, {0.6620290595732728, 
     0.9800816628402181, 0.3180526032669454}, {0.6626425624418683, 
     0.9799187109339695, 0.3172761484921014}, {0.663255484455037, 
     0.9797551384662794, 0.3164996540112423}, {0.6638678255742453, 
     0.9795909459655577, 0.31572312039131245`}, {0.6644795857613471, 
     0.9794261339601354, 0.31494654819878815`}, {0.6650907649785842, 
     0.9792607029782623, 0.31416993799967785`}, {0.665701363188586, 
     0.9790946535481084, 0.3133932903595224}, {0.6663113803543691, 
     0.9789279861977644, 0.31261660584339535`}, {0.6669208164393372, 
     0.9787607014552412, 0.31183988501590393`}, {0.6675296714072828, 
     0.9785927998484696, 0.3110631284411867}, {0.6681379452223842, 
     0.9784242819053018, 0.3102863366829175}, {0.6687456378492083, 
     0.9782551481535104, 0.3095095103043021}, {0.6693527492527082, 
     0.9780853991207895, 0.3087326498680813}, {0.6699592793982251, 
     0.9779150353347535, 0.30795575593652846`}, {0.6705652282514869, 
     0.9777440573229391, 0.3071788290714523}, {0.671170595778608, 
     0.977572465612804, 0.3064018698341958}, {0.6717753819460919, 
     0.9774002607317271, 0.3056248787856352}, {0.6723795867208266, 
     0.9772274432070099, 0.3048478564861832}, {0.6729832100700889, 
     0.9770540135658753, 0.3040708034957863}, {0.6735862519615413, 
     0.9768799723354683, 0.3032937203739269}, {0.6741887123632341, 
     0.9767053200428562, 0.30251660767962196`}, {0.6747905912436034, 
     0.9765300572150287, 0.30173946597142526`}, {0.6753918885714728, 
     0.976354184378898, 0.30096229580742506`}, {0.6759926043160521, 
     0.9761777020612988, 0.30018509774524665`}, {0.6765927384469382, 
     0.9760006107889888, 0.2994078723420506}, {0.6771922909341139, 
     0.9758229110886486, 0.2986306201545347}, {0.6777912617479488, 
     0.9756446034868814, 0.29785334173893263`}, {0.6783896508591988, 
     0.9754656885102144, 0.29707603765101565`}, {0.6789874582390063, 
     0.9752861666850976, 0.2962987084460912}, {0.6795846838588997, 
     0.9751060385379045, 0.2955213546790047}, {0.680181327690794, 
     0.9749253045949323, 0.2947439769041384}, {0.6807773897069896, 
     0.974743965382402, 0.2939665756754124}, {0.6813728698801741, 
     0.9745620214264588, 0.29318915154628444`}, {0.6819677681834203, 
     0.9743794732531706, 0.29241170506975017`}, {0.6825620845901869, 
     0.9741963213885311, 0.29163423679834405`}, {0.6831558190743187, 
     0.974012566358457, 0.29085674728413824`}, {0.6837489716100466, 
     0.9738282086887902, 0.2900792370787435}, {0.6843415421719864, 
     0.9736432489052965, 0.28930170673331007`}, {0.6849335307351404, 
     0.9734576875336667, 0.2885241567985262}, {0.685524937274896, 
     0.9732715250995162, 0.28774658782462004`}, {0.6861157617670259, 
     0.9730847621283852, 0.28696900036135925`}, {0.6867060041876891, 
     0.9728973991457388, 0.2861913949580497}, {0.6872956645134289, 
     0.9727094366769677, 0.2854137721635387}, {0.6878847427211746, 
     0.9725208752473872, 0.2846361325262125}, {0.6884732387882404, 
     0.9723317153822381, 0.2838584765939976}, {0.6890611526923254, 
     0.9721419576066868, 0.2830808049143613}, {0.6896484844115142, 
     0.9719516024458253, 0.2823031180343109}, {0.6902352339242763, 
     0.9717606504246706, 0.28152541650039437`}, {0.6908214012094656, 
     0.9715691020681668, 0.2807477008587011}, {0.6914069862463216, 
     0.9713769579011824, 0.27996997165486076`}, {0.6919919890144678, 
     0.9711842184485127, 0.27919222943404487`}, {0.6925764094939123, 
     0.9709908842348791, 0.2784144747409667}, {0.6931602476650485, 
     0.9707969557849289, 0.27763670811988034`}, {0.6937435035086535, 
     0.9706024336232357, 0.2768589301145821}, {0.6943261770058892, 
     0.9704073182743, 0.27608114126841077`}, {0.6949082681383015, 
     0.9702116102625481, 0.2753033421242465}, {0.695489776887821, 
     0.9700153101123334, 0.2745255332245123}, {0.696070703236762, 
     0.9698184183479355, 0.27374771511117346`}, {0.6966510471678229, 
     0.9696209354935615, 0.27296988832573865`}, {0.6972308086640863, 
     0.9694228620733449, 0.27219205340925867`}, {0.697809987709018, 
     0.9692241986113465, 0.2714142109023283}, {0.6983885842864684, 
     0.9690249456315534, 0.270636361345085}, {0.698966598380671, 
     0.968825103657881, 0.26985850527720984`}, {0.6995440299762434, 
     0.9686246732141711, 0.2690806432379277}, {0.7001208790581862, 
     0.9684236548241933, 0.26830277576600703`}, {0.7006971456118838, 
     0.9682220490116445, 0.26752490339976076`}, {0.7012728296231034, 
     0.9680198563001491, 0.26674702667704553`}, {0.7018479310779959, 
     0.9678170772132592, 0.2659691461352632}, {0.7024224499630951, 
     0.9676137122744546, 0.26519126231135937`}, {0.7029963862653184, 
     0.9674097620071427, 0.26441337574182416`}, {0.7035697399719648, 
     0.9672052269346588, 0.263635486962694}, {0.7041425110707178, 
     0.9670001075802668, 0.2628575965095489}, {0.7047146995496422, 
     0.9667944044671575, 0.2620797049175153}, {0.705286305397186, 
     0.9665881181184508, 0.26130181272126485`}, {0.7058573286021802, 
     0.9663812490571944, 0.2605239204550142}, {0.7064277691538378, 
     0.9661737978063643, 0.25974602865252633`}, {0.7069976270417542, 
     0.9659657648888643, 0.2589681378471101}, {0.7075669022559069, 
     0.965757150827528, 0.258190248571621}, {0.7081355947866559, 
     0.965547956145116, 0.25741236135846013`}, {0.7087037046247426, 
     0.9653381813643185, 0.2566344767395758}, {0.7092712317612914, 
     0.9651278270077538, 0.25585659524646237`}, {0.7098381761878075, 
     0.9649168935979691, 0.25507871741016147`}, {0.7104045378961783, 
     0.9647053816574405, 0.25430084376126194`}, {0.7109703168786732, 
     0.9644932917085725, 0.2535229748298992}, {0.711535513127942, 
     0.9642806242736993, 0.2527451111457571}, {0.7121001266370176, 
     0.9640673798750833, 0.25196725323806557`}, {0.7126641573993123, 
     0.9638535590349165, 0.2511894016356042}, {0.7132276054086212, 
     0.96363916227532, 0.2504115568666987}, {0.7137904706591197, 
     0.9634241901183436, 0.24963371945922364`}, {0.7143527531453646, 
     0.9632086430859665, 0.24885588994060187`}, {0.714914452862293, 
     0.962992521700098, 0.24807806883780484`}, {0.7154755698052235, 
     0.9627758264825756, 0.24730025667735198`}, {0.7160361039698551, 
     0.9625585579551671, 0.2465224539853119}, {0.7165960553522668, 
     0.9623407166395694, 0.2457446612873025}, {0.7171554239489188, 
     0.962122303057409, 0.24496687910849008`}, {0.7177142097566518, 
     0.9619033177302422, 0.2441891079735903}, {0.7182724127726858, 
     0.9616837611795547, 0.24341134840686862`}, {0.7188300329946214, 
     0.9614636339267619, 0.24263360093214045`}, {0.7193870704204397, 
     0.9612429364932094, 0.2418558660727695}, {0.7199435250485009, 
     0.9610216694001721, 0.24107814435167113`}, {0.7204993968775453, 
     0.9607998331688551, 0.24030043629130976`}, {0.7210546859066929, 
     0.9605774283203934, 0.23952274241370047`}, {0.7216093921354434, 
     0.9603544553758521, 0.2387450632404085}, {0.7221635155636756, 
     0.9601309148562258, 0.23796739929255015`}, {0.7227170561916475, 
     0.9599068072824399, 0.23718975109079218`}, {0.723270014019997, 
     0.9596821331753493, 0.23641211915535223`}, {0.7238223890497406, 
     0.9594568930557396, 0.235634504005999}, {0.7243741812822734, 
     0.9592310874443265, 0.23485690616205288`}, {0.7249253907193702, 
     0.9590047168617554, 0.23407932614238502`}, {0.7254760173631839, 
     0.9587777818286026, 0.2333017644654187}, {0.7260260612162464, 
     0.9585502828653749, 0.2325242216491287}, {0.7265755222814673, 
     0.9583222204925091, 0.23174669821104182`}, {0.7271244005621356, 
     0.9580935952303726, 0.23096919466823704`}, {0.7276726960619178, 
     0.9578644075992632, 0.23019171153734533`}, {0.728220408784859, 
     0.9576346581194092, 0.22941424933455007`}, {0.7287675387353822, 
     0.9574043473109695, 0.22863680857558707`}, {0.7293140859182882, 
     0.9571734756940337, 0.22785938977574546`}, {0.7298600503387552, 
     0.9569420437886218, 0.22708199344986657`}, {0.7304054320023395, 
     0.9567100521146849, 0.2263046201123451}, {0.7309502309149749, 
     0.9564775011921042, 0.22552727027712927`}, {0.7314944470829724, 
     0.9562443915406921, 0.22474994445771962`}, {0.7320380805130202, 
     0.9560107236801917, 0.22397264316717141`}, {0.7325811312121842, 
     0.9557764981302768, 0.2231953669180924}, {0.7331235991879061, 
     0.9555417154105518, 0.2224181162226457}, {0.7336654844480058, 
     0.9553063760405527, 0.2216408915925469}, {0.734206787000679, 
     0.9550704805397457, 0.22086369353906657`}, {0.7347475068544987, 
     0.9548340294275283, 0.22008652257302924`}, {0.7352876440184145, 
     0.9545970232232284, 0.21930937920481386`}, {0.7358271985017512, 
     0.9543594624461056, 0.21853226394435432`}, {0.7363661703142107, 
     0.9541213476153504, 0.21775517730113955`}, {0.7369045594658713, 
     0.9538826792500837, 0.21697811978421247`}, {0.7374423659671864, 
     0.9536434578693586, 0.21620109190217213`}, {0.7379795898289863, 
     0.9534036839921577, 0.2154240941631715}, {0.7385162310624761, 
     0.9531633581373964, 0.21464712707492023`}, {0.7390522896792368, 
     0.9529224808239201, 0.21387019114468317`}, {0.7395877656912249, 
     0.9526810525705056, 0.21309328687928064`}, {0.7401226591107725, 
     0.9524390738958611, 0.2123164147850885}, {0.7406569699505864, 
     0.9521965453186259, 0.2115395753680394}, {0.7411906982237486, 
     0.9519534673573703, 0.2107627691336217}, {0.7417238439437159, 
     0.9517098405305963, 0.20998599658688033`}, {0.7422564071243204, 
     0.9514656653567365, 0.20920925823241612`}, {0.7427883877797679, 
     0.9512209423541557, 0.20843255457438775`}, {0.7433197859246401, 
     0.950975672041149, 0.20765588611650873`}, {0.7438506015738918, 
     0.9507298549359432, 0.20687925336205126`}, {0.7443808347428524, 
     0.9504834915566966, 0.20610265681384407`}, {0.744910485447226, 
     0.9502365824214988, 0.20532609697427257`}, {0.7454395537030896, 
     0.9499891280483705, 0.2045495743452807}, {0.7459680395268953, 
     0.9497411289552636, 0.2037730894283682}, {0.7464959429354676, 
     0.9494925856600622, 0.20299664272459447`}, {0.7470232639460054, 
     0.9492434986805809, 0.20222023473457543`}, {0.747550002576081, 
     0.9489938685345661, 0.2014438659584852}, {0.7480761588436392, 
     0.9487436957396957, 0.20066753689605646`}, {0.7486017327669988, 
     0.9484929808135788, 0.19989124804657987`}, {0.7491267243648516, 
     0.9482417242737554, 0.199114999908904}, {0.7496511336562613, 
     0.9479899266376985, 0.19833879298143703`}, {0.7501749606606654, 
     0.9477375884228109, 0.19756262776214542`}, {0.7506982053978734, 
     0.9474847101464274, 0.19678650474855403`}, {0.7512208678880673, 
     0.9472312923258148, 0.19601042443774738`}, {0.7517429481518014, 
     0.9469773354781704, 0.1952343873263689}, {0.7522644462100023, 
     0.9467228401206238, 0.1944583939106214}, {0.7527853620839683, 
     0.9464678067702356, 0.19368244468626722`}, {0.7533056957953699, 
     0.9462122359439976, 0.19290654014862782`}, {0.7538254473662489, 
     0.945956128158834, 0.19213068079258525`}, {0.754344616819019, 
     0.9456994839315996, 0.19135486711258062`}, {0.7548632041764655, 
     0.9454423037790811, 0.1905790996026155}, {0.7553812094617444, 
     0.9451845882179962, 0.18980337875625192`}, {0.755898632698383, 
     0.9449263377649947, 0.18902770506661168`}, {0.7564154739102801, 
     0.9446675529366577, 0.1882520790263775}, {0.7569317331217048, 
     0.9444082342494973, 0.1874765011277924}, {0.7574474103572967, 
     0.9441483822199576, 0.1867009718626607}, {0.7579625056420671, 
     0.9438879973644135, 0.18592549172234632`}, {0.7584770190013962, 
     0.9436270801991725, 0.18515006119777636`}, {0.7589909504610352, 
     0.9433656312404725, 0.18437468077943725`}, {0.7595043000471057, 
     0.9431036510044831, 0.18359935095737742`}, {0.7600170677860985, 
     0.9428411400073058, 0.18282407222120733`}, {0.7605292537048748, 
     0.9425780987649728, 0.18204884506009802`}, {0.761040857830665, 
     0.9423145277934483, 0.1812736699627832}, {0.7615518801910698, 
     0.9420504276086278, 0.18049854741755791`}, {0.7620623208140581, 
     0.9417857987263378, 0.17972347791227963`}, {0.7625721797279686, 
     0.941520641662337, 0.1789484619343682}, {0.7630814569615099, 
     0.9412549569323145, 0.1781734999708046}, {0.7635901525437576, 
     0.9409887450518917, 0.17739859250813414`}, {0.7640982665041575, 
     0.9407220065366211, 0.17662374003246362`}, {0.7646057988725233, 
     0.9404547419019861, 0.1758489430294626}, {0.7651127496790381, 
     0.9401869516634018, 0.17507420198436374`}, {0.7656191189542522, 
     0.9399186363362148, 0.17429951738196267`}, {0.7661249067290841, 
     0.9396497964357031, 0.17352488970661883`}, {0.7666301130348212, 
     0.9393804324770753, 0.17275031944225386`}, {0.7671347379031178, 
     0.9391105449754715, 0.17197580707235377`}, {0.7676387813659963, 
     0.9388401344459644, 0.17120135307996803`}, {0.7681422434558466, 
     0.938569201403556, 0.17042695794770923`}, {0.7686451242054257, 
     0.9382977463631808, 0.16965262215775476`}, {0.7691474236478584, 
     0.938025769839704, 0.1688783461918454}, {0.769649141816636, 
     0.937753272347922, 0.16810413053128603`}, {0.7701502787456165, 
     0.9374802544025633, 0.16732997565694674`}, {0.7706508344690252, 
     0.9372067165182864, 0.1665558820492612}, {0.7711508090214538, 
     0.9369326592096815, 0.1657818501882276}, {0.7716502024378605, 
     0.93665808299127, 0.16500788055340926`}, {0.7721490147535697, 
     0.936382988377504, 0.16423397362393422`}, {0.7726472460042715, 
     0.9361073758827672, 0.16346012987849554`}, {0.7731448962260227, 
     0.9358312460213739, 0.16268634979535126`}, {0.7736419654552453, 
     0.9355545993075702, 0.16191263385232482`}, {0.774138453728727, 
     0.9352774362555324, 0.1611389825268054}, {0.7746343610836214, 
     0.9349997573793685, 0.16036539629574695`}, {0.7751296875574469, 
     0.9347215631931166, 0.15959187563566973`}, {0.7756244331880873, 
     0.934442854210747, 0.1588184210226596}, {0.7761185980137915, 
     0.93416363094616, 0.1580450329323684}, {0.7766121820731732, 
     0.9338838939131868, 0.15727171184001365`}, {0.77710518540521, 
     0.9336036436255903, 0.1564984582203801}, {0.7775976080492455, 
     0.9333228805970631, 0.1557252725478176}, {0.7780894500449864, 
     0.9330416053412299, 0.15495215529624343`}, {0.7785807114325041, 
     0.9327598183716455, 0.15417910693914114`}, {0.7790713922522341, 
     0.932477520201795, 0.1534061279495608}, {0.779561492544975, 
     0.9321947113450952, 0.15263321880012024`}, {0.7800510123518902, 
     0.9319113923148935, 0.15186037996300322`}, {0.7805399517145062, 
     0.9316275636244675, 0.1510876119099612}, {0.7810283106747127, 
     0.9313432257870257, 0.15031491511231299`}, {0.7815160892747626, 
     0.9310583793157073, 0.14954229004094466`}, {0.7820032875572718, 
     0.9307730247235821, 0.14876973716631026`}, {0.7824899055652195, 
     0.9304871625236504, 0.14799725695843094`}, {0.7829759433419472, 
     0.930200793228843, 0.14722484988689588`}, {0.7834614009311593, 
     0.9299139173520216, 0.1464525164208622}, {0.7839462783769222, 
     0.9296265354059778, 0.14568025702905535`}, {0.7844305757236649, 
     0.9293386479034339, 0.14490807217976887`}, {0.7849142930161779, 
     0.929050255357043, 0.1441359623408649}, {0.7853974302996143, 
     0.9287613582793875, 0.1433639279797732}, {0.7858799876194882, 
     0.9284719571829819, 0.1425919695634935}, {0.7863619650216761, 
     0.9281820525802691, 0.141820087558593}, {0.7868433625524148, 
     0.9278916449836236, 0.14104828243120865`}, {0.7873241802583036, 
     0.9276007349053497, 0.14027655464704586`}, {0.7878044181863018, 
     0.9273093228576816, 0.13950490467137974`}, {0.7882840763837299, 
     0.9270174093527842, 0.13873333296905416`}, {0.7887631548982693, 
     0.9267249949027523, 0.1379618400044829}, {0.789241653777962, 
     0.9264320800196107, 0.1371904262416487}, {0.7897195730712097, 
     0.9261386652153146, 0.1364190921441049}, {0.7901969128267751, 
     0.9258447510017487, 0.1356478381749737}, {0.7906736730937809, 
     0.925550337890728, 0.13487666479694713`}, {0.7911498539217091, 
     0.9252554263939977, 0.13410557247228838`}, {0.7916254553604017, 
     0.9249600170232319, 0.13333456166283017`}, {0.7921004774600607, 
     0.9246641102900359, 0.132563632829975}, {0.7925749202712465, 
     0.9243677067059437, 0.13179278643469716`}, {0.7930487838448794, 
     0.9240708067824199, 0.1310220229375404}, {0.7935220682322388, 
     0.9237734110308582, 0.13025134279861925`}, {0.7939947734849621, 
     0.9234755199625826, 0.12948074647762034`}, {0.7944668996550466, 
     0.9231771340888458, 0.1287102344337992}, {0.7949384467948469, 
     0.9228782539208313, 0.12793980712598427`}, {0.795409414957077, 
     0.9225788799696514, 0.12716946501257417`}, {0.7958798041948081, 
     0.9222790127463479, 0.12639920855153977`}, {0.7963496145614702, 
     0.9219786527618926, 0.12562903820042226`}, {0.7968188461108505, 
     0.9216778005271864, 0.12485895441633582`}, {0.7972874988970945, 
     0.9213764565530596, 0.12408895765596487`}, {0.7977555729747045, 
     0.9210746213502714, 0.12331904837556693`}, {0.7982230683985401, 
     0.9207722954295113, 0.12254922703097122`}, {0.7986899852238187, 
     0.9204694793013971, 0.12177949407757829`}, {0.7991563235061141, 
     0.9201661734764767, 0.12100984997036249`}, {0.7996220833013571, 
     0.9198623784652262, 0.12024029516386903`}, {0.800087264665835, 
     0.9195580947780517, 0.11947083011221647`}, {0.8005518676561914, 
     0.9192533229252875, 0.11870145526909595`}, {0.8010158923294266, 
     0.9189480634171973, 0.1179321710877707}, {0.8014793387428966, 
     0.9186423167639743, 0.11716297802107754`}, {0.8019422069543131, 
     0.9183360834757397, 0.1163938765214266}, {0.8024044970217439, 
     0.9180293640625443, 0.11562486704080033`}, {0.8028662090036125, 
     0.9177221590343673, 0.1148559500307547}, {0.8033273429586972, 
     0.9174144689011168, 0.11408712594241958`}, {0.8037878989461322, 
     0.9171062941726297, 0.11331839522649736`}, {0.8042478770254058, 
     0.9167976353586712, 0.1125497583332654}, {0.8047072772563624, 
     0.916488492968936, 0.11178121571257336`}, {0.8051660996991997, 
     0.9161788675130461, 0.11101276781384625`}, {0.805624344414471, 
     0.915868759500553, 0.11024441508608192`}, {0.8060820114630831, 
     0.9155581694409364, 0.10947615797785316`}, {0.8065391009062974, 
     0.9152470978436043, 0.10870799693730662`}, {0.8069956128057293, 
     0.914935545217893, 0.10793993241216362`}, {0.8074515472233478, 
     0.9146235120730674, 0.10717196484971954`}, {0.8079069042214752, 
     0.9143109989183206, 0.1064040946968452}, {0.808361683862788, 
     0.9139980062627732, 0.10563632239998517`}, {0.8088158862103152, 
     0.9136845346154752, 0.10486864840515997`}, {0.8092695113274392, 
     0.9133705844854038, 0.10410107315796435`}, {0.8097225592778955, 
     0.9130561563814641, 0.10333359710356853`}, {0.8101750301257714, 
     0.9127412508124899, 0.10256622068671847`}, {0.8106269239355083, 
     0.9124258682872424, 0.10179894435173416`}, {0.811078240771898, 
     0.9121100093144111, 0.10103176854251303`}, {0.8115289807000863, 
     0.9117936744026127, 0.10026469370252632`}, {0.8119791437855696, 
     0.9114768640603922, 0.09949772027482257}, {0.8124287300941971, 
     0.9111595787962219, 0.09873084870202468}, {0.8128777396921687, 
     0.9108418191185019, 0.09796407942633312}, {0.8133261726460369, 
     0.9105235855355603, 0.09719741288952337}, {0.8137740290227043, 
     0.9102048785556519, 0.0964308495329474}, {0.8142213088894253, 
     0.9098856986869596, 0.0956643897975343}, {0.8146680123138048, 
     0.9095660464375934, 0.09489803412378861}, {0.8151141393637987, 
     0.9092459223155912, 0.09413178295179243}, {0.8155596901077136, 
     0.9089253268289172, 0.09336563672120365}, {0.8160046646142058, 
     0.9086042604854642, 0.09259959587125823}, {0.8164490629522825, 
     0.9082827237930506, 0.09183366084076787}, {0.8168928851913002, 
     0.9079607172594228, 0.09106783206812251}, {0.8173361314009658, 
     0.9076382413922546, 0.09030210999128853}, {0.8177788016513357, 
     0.9073152966991459, 0.08953649504781026}, {0.8182208960128153, 
     0.9069918836876243, 0.08877098767480894}, {0.8186624145561596, 
     0.9066680028651437, 0.08800558830898389}, {0.8191033573524733, 
     0.9063436547390853, 0.08724029738661196}, {0.8195437244732084, 
     0.9060188398167566, 0.08647511534354814}, {0.8199835159901675, 
     0.9056935586053921, 0.08571004261522462}, {0.8204227319755003, 
     0.9053678116121532, 0.08494507963665283}, {0.8208613725017052, 
     0.9050415993441271, 0.08418022684242178}, {0.8212994376416292, 
     0.9047149223083277, 0.08341548466669844}, {0.8217369274684667, 
     0.9043877810116959, 0.0826508535432292}, {0.8221738420557606, 
     0.9040601759610988, 0.08188633390533817}, {0.8226101814774004, 
     0.9037321076633292, 0.08112192618592846}, {0.823045945807624, 
     0.9034035766251066, 0.08035763081748258}, {0.8234811351210157, 
     0.9030745833530771, 0.07959344823206109}, {0.8239157494925079, 
     0.9027451283538118, 0.07882937886130392}, {0.8243497889973784, 
     0.9024152121338089, 0.07806542313643063}, {0.824783253711253, 
     0.9020848351994927, 0.0773015814882395}, {0.8252161437101034, 
     0.9017539980572122, 0.07653785434710891}, {0.8256484590702475, 
     0.9014227012132436, 0.07577424214299575}, {0.8260801998683498, 
     0.9010909451737876, 0.07501074530543772}, {0.8265113661814203, 
     0.900758730444972, 0.07424736426355148}, {0.8269419580868148, 
     0.9004260575328493, 0.07348409944603443}, {0.827371975662235, 
     0.9000929269433979, 0.07272095128116289}, {0.8278014189857271, 
     0.8997593391825217, 0.07195792019679469}, {0.8282302881356838, 
     0.8994252947560506, 0.07119500662036653}, {0.8286585831908417, 
     0.8990907941697384, 0.07043221097889642}, {0.829086304230283, 
     0.898755837929266, 0.06966953369898304}, {0.8295134513334336, 
     0.8984204265402387, 0.06890697520680503}, {0.8299400245800647, 
     0.8980845605081866, 0.06814453592812213}, {0.830366024050291, 
     0.8977482403385659, 0.06738221628827475}, {0.8307914498245724, 
     0.8974114665367573, 0.06662001671218462}, {0.8312163019837117, 
     0.8970742396080659, 0.06585793762435431}, {0.8316405806088553, 
     0.8967365600577233, 0.06509597944886795}, {0.8320642857814937, 
     0.8963984283908843, 0.06433414260939058}, {0.8324874175834605, 
     0.8960598451126296, 0.0635724275291691}, {0.8329099760969318, 
     0.8957208107279642, 0.06281083463103226}, {0.8333319614044283, 
     0.8953813257418173, 0.06204936433738899}, {0.8337533735888112, 
     0.895041390659044, 0.06128801707023231}, {0.8341742127332863, 
     0.8947010059844216, 0.060526793251135344`}, {0.8345944789214004, 
     0.894360172222655, 0.05976569330125434}, {0.8350141722370429, 
     0.8940188898783702, 0.059004717641327115`}, {0.8354332927644451, 
     0.8936771594561201, 0.05824386669167473}, {0.8358518405881808, 
     0.8933349814603799, 0.057483140872198885`}, {0.8362698157931643, 
     0.8929923563955504, 0.05672254060238613}, {0.8366872184646521, 
     0.8926492847659557, 0.05596206630130359}, {0.8371040486882413, 
     0.8923057670758441, 0.05520171838760274}, {0.8375203065498706, 
     0.8919618038293878, 0.054441497279517005`}, {0.8379359921358196, 
     0.8916173955306828, 0.05368140339486303}, {0.8383511055327082, 
     0.8912725426837487, 0.05292143715104059}, {0.8387656468274965, 
     0.8909272457925297, 0.052161598965033036`}, {0.8391796161074857, 
     0.8905815053608928, 0.05140188925340693}, {0.8395930134603165, 
     0.8902353218926284, 0.05064230843231195}, {0.8400058389739694, 
     0.8898886958914515, 0.04988285691748191}, {0.8404180927367652, 
     0.8895416278609992, 0.04912353512423385}, {0.8408297748373635, 
     0.8891941183048327, 0.04836434346746934}, {0.8412408853647639, 
     0.8888461677264372, 0.04760528236167323}, {0.8416514244083045, 
     0.8884977766292195, 0.046846352220914815`}, {0.842061392057663, 
     0.8881489455165101, 0.04608755345884722}, {0.8424707884028548, 
     0.8877996748915638, 0.045328886488708746`}, {0.8428796135342352, 
     0.8874499652575564, 0.044570351723321036`}, {0.8432878675424968, 
     0.8870998171175879, 0.043811949575090985`}, {0.8436955505186711, 
     0.8867492309746812, 0.04305368045600997}, {0.844102662554127, 
     0.8863982073317811, 0.042295544777654154`}, {0.8445092037405714, 
     0.886046746691756, 0.04153754295118447}, {0.844915174170049, 
     0.885694849557396, 0.040779675387346934`}, {0.8453205739349418, 
     0.8853425164314147, 0.040021942496472895`}, {0.8457254031279685, 
     0.8849897478164473, 0.03926434468847885}, {0.8461296618421859, 
     0.8846365442150524, 0.03850688237286654}, {0.8465333501709864, 
     0.88428290612971, 0.03774955595872359}, {0.8469364682081, 
     0.8839288340628222, 0.03699236585472232}, {0.8473390160475924, 
     0.8835743285167147, 0.03623531246912208}, {0.8477409937838664, 
     0.8832193899936331, 0.035478396209766803`}, {0.8481424015116599, 
     0.8828640189957474, 0.03472161748408736}, {0.8485432393260472, 
     0.8825082160251473, 0.0339649766990999}, {0.8489435073224385, 
     0.8821519815838461, 0.033208474261407606`}, {0.8493432055965787, 
     0.8817953161737782, 0.03245211057719905}, {0.8497423342445489, 
     0.8814382202967986, 0.0316958860522497}, {0.8501408933627645, 
     0.8810806944546866, 0.03093980109192217}, {0.8505388830479764, 
     0.8807227391491406, 0.030183856101164187`}, {0.8509363033972696, 
     0.8803643548817816, 0.029428051484511965`}, {0.8513331545080638, 
     0.8800055421541512, 0.02867238764608733}, {0.8517294364781136, 
     0.8796463014677136, 0.02791686498959985}, {0.8521251494055069, 
     0.8792866333238529, 0.02716148391834623}, {0.8525202933886663, 
     0.8789265382238755, 0.026406244835209133`}, {0.852914868526347, 
     0.878566016669008, 0.025651148142660955`}, {0.853308874917639, 
     0.8782050691603984, 0.024896194242759278`}, {0.8537023126619648, 
     0.8778436961991153, 0.024141383537150448`}, {0.854095181859081, 
     0.8774818982861492, 0.02338671642706818}, {0.8544874826090753, 
     0.8771196759224097, 0.022632193313334385`}, {0.8548792150123702, 
     0.8767570296087286, 0.021877814596358416`}, {0.8552703791697194, 
     0.8763939598458578, 0.02112358067613812}, {0.85566097518221, 
     0.876030467134469, 0.020369491952259053`}, {0.8560510031512604, 
     0.8756665519751559, 0.019615548823895337`}, {0.8564404631786214, 
     0.8753022148684307, 0.01886175168980929}, {0.8568293553663752, 
     0.8749374563147277, 0.0181081009483527}, {0.8572176798169362, 
     0.8745722768144005, 0.01735459699746437}, {0.8576054366330498, 
     0.8742066768677227, 0.01660124023467284}, {0.8579926259177926, 
     0.8738406569748883, 0.015848031057095605`}, {0.8583792477745724, 
     0.873474217636011, 0.015094969861438517`}, {0.8587653023071274, 
     0.8731073593511252, 0.01434205704399768}, {0.8591507896195271, 
     0.872740082620184, 0.01358929300065678}, {0.8595357098161708, 
     0.8723723879430609, 0.012836678126890246`}, {0.8599200630017877, 
     0.8720042758195493, 0.012084212817761389`}, {0.8603038492814385, 
     0.8716357467493612, 0.01133189746792265}, {0.8606870687605122, 
     0.8712668012321291, 0.01057973247161709}, {0.8610697215447279, 
     0.8708974397674046, 0.009827718222676736}, {0.8614518077401347, 
     0.8705276628546587, 0.00907585511452408}, {0.86183332745311, 
     0.8701574709932813, 0.00832414354017105}, {0.8622142807903609, 
     0.8697868646825819, 0.007572583892220934}, {0.8625946678589232, 
     0.8694158444217888, 0.006821176562865454}, {0.8629744887661617, 
     0.8690444107100497, 0.006069921943887947}, {0.8633537436197682, 
     0.8686725640464308, 0.005318820426662546}, {0.8637324325277649, 
     0.8683003049299176, 0.004567872402152729}, {0.8641105555985004, 
     0.8679276338594138, 0.003817078260913448}, {0.864488112940652, 
     0.8675545513337428, 0.0030664383930907274`}, {0.8648651046632243, 
     0.8671810578516456, 0.0023159531884210517`}, {0.8652415308755498, 
     0.866807153911782, 0.0015656230362322296`}, {0.8656173916872877, 
     0.8664328400127302, 0.000815448325442574}, {0.8659926872084242, 
     0.8660581166529879, 0.00006542944456344141}, {0.8663674175492735, 
     0.8656829843309687, 0.0006844332183047444}, {0.8667415828204754, 
     0.8653074435450073, 0.0014341392754682668`}, {0.8671151831329963, 
     0.8649314947933541, 0.0021836883396424136`}, {0.8674882185981293, 
     0.8645551385741788, 0.002933080023950408}, {0.8678606893274932, 
     0.8641783753855689, 0.0036823139419242335`}, {0.8682325954330332, 
     0.8638012057255297, 0.004431389707503567}, {0.8686039370270198, 
     0.8634236300919844, 0.005180306935035554}, {0.8689747142220491, 
     0.8630456489827735, 0.00592906523927563}, {0.8693449271310424, 
     0.8626672628956555, 0.006677664235386886}, {0.8697145758672463, 
     0.8622884723283069, 0.007426103538939624}, {0.8700836605442321, 
     0.8619092777783205, 0.008174382765911975}, {0.8704521812758962, 
     0.8615296797432076, 0.008922501532688846}, {0.8708201381764591, 
     0.8611496787203962, 0.009670459456063157}, {0.8711875313604658, 
     0.8607692752072317, 0.010418256153234155`}, {0.8715543609427855, 
     0.8603884697009767, 0.011165891241808874`}, {0.8719206270386111, 
     0.8600072626988114, 0.011913364339799804`}, {0.8722863297634593, 
     0.8596256546978317, 0.012660675065627628`}, {0.8726514692331707, 
     0.8592436461950518, 0.01340782303811931}, {0.8730160455639088, 
     0.8588612376874012, 0.014154807876507882`}, {0.8733800588721602, 
     0.8584784296717275, 0.014901629200432849`}, {0.8737435092747344, 
     0.8580952226447945, 0.01564828662994018}, {0.8741063968887647, 
     0.857711617103282, 0.01639477978548275}, {0.8744687218317053, 
     0.8573276135437874, 0.017141108287917966`}, {0.8748304842213334, 
     0.8569432124628239, 0.017887271758509713`}, {0.8751916841757494, 
     0.8565584143568206, 0.01863326981892893}, {0.8755523218133737, 
     0.8561732197221236, 0.01937910209125027}, {0.8759123972529501, 
     0.8557876290549943, 0.02012476819795567}, {0.876271910613543, 
     0.8554016428516118, 0.02087026776193137}, {0.8766308620145387, 
     0.8550152616080691, 0.021615600406469856`}, {0.8769892515756444, 
     0.8546284858203763, 0.022360765755268124`}, {0.8773470794168885, 
     0.8542413159844594, 0.023105763432429385`}, {0.8777043456586194, 
     0.8538537525961596, 0.0238505930624597}, {0.8780610504215073, 
     0.8534657961512343, 0.02459525427027302}, {0.8784171938265414, 
     0.8530774471453563, 0.025339746681185497`}, {0.8787727759950323, 
     0.8526887060741132, 0.02608406992091908}, {0.8791277970486097, 
     0.8522995734330093, 0.02682822361560023}, {0.8794822571092239, 
     0.8519100497174633, 0.027572207391760573`}, {0.8798361562991436, 
     0.8515201354228097, 0.028316020876334155`}, {0.880189494740958, 
     0.8511298310442974, 0.029059663696660593`}, {0.8805422725575748, 
     0.850739137077091, 0.02980313548048383}, {0.8808944898722211, 
     0.8503480540162702, 0.03054643585595088}, {0.8812461468084424, 
     0.8499565823568294, 0.03128956445161325}, {0.8815972434901033, 
     0.8495647225936772, 0.032032520896426206`}, {0.8819477800413859, 
     0.8491724752216381, 0.03277530481974781}, {0.8822977565867915, 
     0.8487798407354508, 0.03351791585134092}, {0.8826471732511391, 
     0.848386819629768, 0.034260353621371045`}, {0.8829960301595647, 
     0.8479934123991574, 0.0350026177604072}, {0.8833443274375229, 
     0.8475996195381021, 0.03574470789942084}, {0.8836920652107854, 
     0.8472054415409975, 0.03648662366978782}, {0.8840392436054406, 
     0.8468108789021547, 0.037228364703286}, {0.8843858627478948, 
     0.8464159321157985, 0.037969930632096194`}, {0.88473192276487, 
     0.8460206016760676, 0.038711321088802285`}, {0.8850774237834057, 
     0.8456248880770161, 0.039452535706389846`}, {0.8854223659308578, 
     0.8452287918126093, 0.04019357411824862}, {0.8857667493348976, 
     0.8448323133767287, 0.04093443595816921}, {0.8861105741235135, 
     0.8444354532631688, 0.041675120860344694`}, {0.8864538404250084, 
     0.8440382119656377, 0.042415628459370754`}, {0.8867965483680015, 
     0.8436405899777573, 0.043155958390244505`}, {0.8871386980814282, 
     0.8432425877930623, 0.04389611028836629}, {0.887480289694538, 
     0.8428442059050014, 0.0446360837895367}, {0.8878213233368957, 
     0.8424454448069372, 0.04537587852995869}, {0.8881617991383807, 
     0.8420463049921443, 0.046115494146236335`}, {0.8885017172291877, 
     0.8416467869538115, 0.046854930275376544`}, {0.8888410777398252, 
     0.8412468911850399, 0.04759418655478528}, {0.889179880801116, 
     0.8408466181788443, 0.04833326262227152}, {0.8895181265441975, 
     0.8404459684281526, 0.04907215811604483}, {0.8898558151005199, 
     0.840044942425804, 0.04981087267471597}, {0.890192946601848, 
     0.8396435406645526, 0.050549405937295615`}, {0.8905295211802595, 
     0.8392417636370633, 0.05128775754319633}, {0.8908655389681454, 
     0.8388396118359146, 0.05202592713223086}, {0.8912010000982098, 
     0.8384370857535973, 0.05276391434461255}, {0.8915359047034698, 
     0.8380341858825147, 0.05350171882095523}, {0.8918702529172545, 
     0.8376309127149827, 0.05423934020227212}, {0.8922040448732066, 
     0.8372272667432282, 0.054976778129978324`}, {0.8925372807052796, 
     0.8368232484593919, 0.05571403224588763}, {0.8928699605477399, 
     0.8364188583555261, 0.05645110219221387}, {0.8932020845351659, 
     0.8360140969235943, 0.05718798761157182}, {0.8935336528024472, 
     0.8356089646554733, 0.0579246881469743}, {0.8938646654847849, 
     0.8352034620429496, 0.058661203441835105`}, {0.8941951227176913, 
     0.834797589577725, 0.059397533139966756`}, {0.8945250246369906, 
     0.8343913477514086, 0.06013367688558215}, {0.8948543713788162, 
     0.8339847370555247, 0.06086963432329147}, {0.8951831630796137, 
     0.8335777579815072, 0.06160540509810659}, {0.8955113998761381, 
     0.8331704110207021, 0.06234098885543607}, {0.8958390819054552, 
     0.8327626966643672, 0.06307638524108816}, {0.8961662093049413, 
     0.8323546154036701, 0.06381159390127115}, {0.8964927822122811, 
     0.8319461677296913, 0.06454661448259015}, {0.8968188007654703, 
     0.8315373541334211, 0.06528144663204949}, {0.8971442651028139, 
     0.8311281751057613, 0.0660160899970527}, {0.8974691753629257, 
     0.8307186311375249, 0.06675054422540096}, {0.8977935316847283, 
     0.8303087227194356, 0.0674848089652929}, {0.8981173342074542, 
     0.8298984503421278, 0.0682188838653266}, {0.898440583070644, 
     0.8294878144961463, 0.06895276857449786}, {0.8987632784141464, 
     0.8290768156719468, 0.06968646274219967}, {0.899085420378119, 
     0.8286654543598965, 0.07041996601822302}, {0.8994070091030271, 
     0.8282537310502711, 0.07115327805275629}, {0.8997280447296444, 
     0.8278416462332572, 0.07188639849638699}, {0.9000485273990514, 
     0.827429200398954, 0.07261932700009743}, {0.9003684572526368, 
     0.8270163940373675, 0.07335206321526944}, {0.9006878344320961, 
     0.8266032276384161, 0.07408460679368013}, {0.9010066590794326, 
     0.826189701691927, 0.0748169573875056}, {0.9013249313369555, 
     0.825775816687639, 0.07554911464931684}, {0.9016426513472818, 
     0.8253615731151984, 0.07628107823208372}, {0.9019598192533342, 
     0.8249469714641632, 0.07701284778917125}, {0.902276435198342, 
     0.8245320122240003, 0.07774442297434168}, {0.9025924993258403, 
     0.8241166958840868, 0.07847580344175355}, {0.9029080117796705, 
     0.823701022933709, 0.07920698884596183}, {0.9032229727039796, 
     0.823284993862062, 0.07993797884191767}, {0.9035373822432201, 
     0.8228686091582514, 0.08066877308496852}, {0.9038512405421494, 
     0.8224518693112924, 0.08139937123085739}, {0.9041645477458307, 
     0.8220347748101072, 0.08212977293572349}, {0.9044773039996317, 
     0.8216173261435302, 0.08285997785610165}, {0.9047895094492252, 
     0.8211995238003027, 0.08358998564892274}, {0.905101164240588, 
     0.820781368269075, 0.08431979597151316}, {0.9054122685200012, 
     0.8203628600384077, 0.08504940848159351}, {0.9057228224340507, 
     0.8199439995967699, 0.08577882283728121}, {0.9060328261296259, 
     0.8195247874325378, 0.08650803869708819}, {0.9063422797539199, 
     0.8191052240339984, 0.08723705571992144}, {0.9066511834544292, 
     0.8186853098893461, 0.08796587356508313}, {0.906959537378954, 
     0.8182650454866848, 0.08869449189226943}, {0.9072673416755976, 
     0.8178444313140247, 0.08942291036157293}, {0.9075745964927661, 
     0.8174234678592873, 0.09015112863347902}, {0.9078813019791682, 
     0.8170021556102998, 0.0908791463688687}, {0.9081874582838155, 
     0.8165804950547989, 0.09160696322901653}, {0.9084930655560217, 
     0.8161584866804296, 0.0923345788755921}, {0.908798123945403, 
     0.8157361309747444, 0.09306199297065881}, {0.9091026336018768, 
     0.8153134284252036, 0.09378920517667341}, {0.9094065946756633, 
     0.814890379519176, 0.0945162151564879}, {0.9097100073172839, 
     0.8144669847439368, 0.09524302257334731}, {0.9100128716775608, 
     0.8140432445866712, 0.09596962709088973}, {0.9103151879076178, 
     0.8136191595344704, 0.09669602837314757}, {0.91061695615888, 
     0.8131947300743335, 0.0974222260845469}, {0.9109181765830731, 
     0.8127699566931668, 0.09814821988990624}, {0.9112188493322225, 
     0.8123448398777854, 0.09887400945443758}, {0.9115189745586557, 
     0.811919380114909, 0.09959959444374707}, {0.9118185524149992, 
     0.8114935778911674, 0.10032497452383185`}, {0.9121175830541794, 
     0.8110674336930963, 0.10105014936108318`}, {0.9124160666294232, 
     0.8106409480071383, 0.10177511862228504`}, {0.9127140032942568, 
     0.8102141213196434, 0.10249988197461325`}, {0.9130113932025057, 
     0.8097869541168684, 0.10322443908563728`}, {0.913308236508295, 
     0.8093594468849772, 0.10394878962331787`}, {0.9136045333660482, 
     0.8089316001100394, 0.1046729332560089}, {0.9139002839304878, 
     0.8085034142780334, 0.10539686965245464`}, {0.9141954883566359, 
     0.8080748898748421, 0.10612059848179416`}, {0.9144901467998118, 
     0.8076460273862559, 0.10684411941355595`}, {0.9147842594156333, 
     0.8072168272979717, 0.10756743211766169`}, {0.9150778263600169, 
     0.8067872900955931, 0.10829053626442388`}, {0.9153708477891759, 
     0.8063574162646292, 0.10901343152454701`}, {0.9156633238596225, 
     0.8059272062904955, 0.10973611756912692`}, {0.9159552547281652, 
     0.8054966606585148, 0.11045859406965071`}, {0.9162466405519107, 
     0.8050657798539136, 0.11118086069799721`}, {0.9165374814882623, 
     0.8046345643618273, 0.11190291712643495`}, {0.9168277776949199, 
     0.8042030146672954, 0.11262476302762467`}, {0.9171175293298807, 
     0.8037711312552634, 0.11334639807461734`}, {0.9174067365514381, 
     0.8033389146105832, 0.11406782194085502`}, {0.9176953995181816, 
     0.802906365218012, 0.11478903430016947`}, {0.917983518388997, 
     0.802473483562213, 0.11551003482678425`}, {0.9182710933230662, 
     0.802040270127754, 0.11623082319531255`}, {0.9185581244798671, 
     0.801606725399109, 0.11695139908075813`}, {0.9188446120191716, 
     0.8011728498606581, 0.11767176215851372`}, {0.9191305561010485, 
     0.8007386439966853, 0.11839191210436337`}, {0.9194159568858613, 
     0.8003041082913803, 0.1191118485944808}, {0.9197008145342679, 
     0.7998692432288392, 0.11983157130542865`}, {0.9199851292072219, 
     0.7994340492930617, 0.12055107991416038`}, {0.9202689010659703, 
     0.798998526967953, 0.12127037409801743`}, {0.9205521302720555, 
     0.7985626767373226, 0.12198945353473288`}, {0.9208348169873135, 
     0.7981264990848865, 0.12270831790242698`}, {0.9211169613738746, 
     0.7976899944942647, 0.12342696687961022`}, {0.9213985635941622, 
     0.7972531634489811, 0.12414540014518134`}, {0.9216796238108941, 
     0.7968160064324653, 0.12486361737842917`}, {0.921960142187081, 
     0.7963785239280508, 0.1255816182590305}, {0.9222401188860267, 
     0.7959407164189762, 0.1262994024670506}, {0.9225195540713287, 
     0.7955025843883845, 0.12701696968294426`}, {0.9227984479068763, 
     0.7950641283193228, 0.12773431958755338`}, {0.9230768005568524, 
     0.7946253486947426, 0.1284514518621097}, {0.9233546121857316, 
     0.7941862459974992, 0.12916836618823244`}, {0.9236318829582808, 
     0.7937468207103525, 0.12988506224792826`}, {0.9239086130395593, 
     0.7933070733159666, 0.13060153972359262`}, {0.9241848025949182, 
     0.7928670042969095, 0.13131779829800883`}, {0.9244604517900001, 
     0.7924266141356525, 0.13203383765434776`}, {0.9247355607907389, 
     0.7919859033145713, 0.13274965747616754`}, {0.92501012976336, 
     0.7915448723159464, 0.13346525744741378`}, {0.9252841588743799, 
     0.7911035216219592, 0.13418063725242052`}, {0.9255576482906055, 
     0.790661851714698, 0.13489579657590756`}, {0.9258305981791353, 
     0.7902198630761526, 0.13561073510298297`}, {0.9261030087073574, 
     0.7897775561882168, 0.13632545251914094`}, {0.926374880042951, 
     0.7893349315326877, 0.13703994851026333`}, {0.9266462123538844, 
     0.7888919895912664, 0.13775422276261814`}, {0.9269170058084171, 
     0.7884487308455567, 0.13846827496286054`}, {0.927187260575097, 
     0.7880051557770654, 0.13918210479803197`}, {0.9274569768227628, 
     0.7875612648672028, 0.1398957119555602}, {0.9277261547205413, 
     0.7871170585972829, 0.14060909612325867`}, {0.9279947944378497, 
     0.7866725374485214, 0.1413222569893284}, {0.9282628961443935, 
     0.7862277019020378, 0.14203519424235583`}, {0.9285304600101665, 
     0.7857825524388542, 0.14274790757131242`}, {0.9287974862054522, 
     0.7853370895398957, 0.1434603966655566}, {0.9290639749008217, 
     0.7848913136859894, 0.14417266121483222`}, {0.9293299262671347, 
     0.7844452253578666, 0.1448847009092682}, {0.9295953404755385, 
     0.7839988250361595, 0.1455965154393792}, {0.9298602176974685, 
     0.7835521132014034, 0.1463081044960651}, {0.9301245581046479, 
     0.7831050903340365, 0.1470194677706113}, {0.930388361869087, 
     0.7826577569143993, 0.14773060495468807`}, {0.9306516291630835, 
     0.7822101134227334, 0.14844151574035}, {0.9309143601592224, 
     0.7817621603391851, 0.14915219982003747`}, {0.931176555030375, 
     0.7813138981437999, 0.1498626568865753}, {0.9314382139496998, 
     0.780865327316527, 0.15057288663317267`}, {0.9316993370906416, 
     0.7804164483372187, 0.15128288875342286`}, {0.9319599246269316, 
     0.7799672616856269, 0.15199266294130465`}, {0.9322199767325866, 
     0.7795177678414074, 0.15270220889117944`}, {0.9324794935819105, 
     0.7790679672841165, 0.15341152629779425`}, {0.9327384753494918, 
     0.7786178604932127, 0.15412061485627912`}, {0.9329969222102049, 
     0.7781674479480568, 0.1548294742621482}, {0.93325483433921, 
     0.7777167301279104, 0.15553810421129988`}, {0.9335122119119516, 
     0.7772657075119369, 0.1562465044000145}, {0.9337690551041599, 
     0.7768143805792018, 0.15695467452495812`}, {0.9340253640918497, 
     0.776362749808671, 0.15766261428317854`}, {0.9342811390513204, 
     0.7759108156792129, 0.15837032337210757`}, {0.9345363801591557, 
     0.7754585786695962, 0.1590778014895597}, {0.9347910875922238, 
     0.7750060392584915, 0.1597850483337326}, {0.9350452615276765, 
     0.7745531979244697, 0.16049206360320656`}, {0.9352989021429501, 
     0.7741000551460049, 0.16119884699694545`}, {0.9355520096157639, 
     0.7736466114014695, 0.1619053982142947}, {0.935804584124121, 
     0.7731928671691389, 0.1626117169549823}, {0.9360566258463081, 
     0.7727388229271881, 0.16331780291912015`}, {0.9363081349608942, 
     0.7722844791536942, 0.16402365580719988`}, {0.9365591116467321, 
     0.7718298363266346, 0.1647292753200976}, {0.9368095560829568, 
     0.7713748949238869, 0.16543466115907018`}, {0.9370594684489858, 
     0.7709196554232294, 0.16613981302575642`}, {0.9373088489245194, 
     0.7704641183023424, 0.16684473062217697`}, {0.9375576976895397, 
     0.7700082840388051, 0.16754941365073478`}, {0.9378060149243109, 
     0.7695521531100976, 0.16825386181421356`}, {0.9380538008093791, 
     0.7690957259936008, 0.1689580748157783}, {0.9383010555255716, 
     0.7686390031665962, 0.16966205235897547`}, {0.9385477792539978, 
     0.7681819851062649, 0.17036579414773298`}, {0.9387939721760478, 
     0.7677246722896882, 0.1710692998863594}, {0.9390396344733929, 
     0.7672670651938484, 0.17177256927954487`}, {0.9392847663279854, 
     0.7668091642956265, 0.17247560203235918`}, {0.9395293679220583, 
     0.7663509700718051, 0.1731783978502532}, {0.9397734394381251, 
     0.7658924829990664, 0.1738809564390589}, {0.940016981058979, 
     0.7654337035539915, 0.17458327750498762`}, {0.9402599929676942, 
     0.7649746322130625, 0.17528536075463186`}, {0.9405024753476247, 
     0.7645152694526607, 0.17598720589496408`}, {0.9407444283824036, 
     0.7640556157490674, 0.17668881263333638`}, {0.9409858522559443, 
     0.7635956715784636, 0.17739018067748089`}, {0.9412267471524393, 
     0.7631354374169302, 0.1780913097355094}, {0.9414671132563601, 
     0.7626749137404469, 0.1787921995159137}, {0.9417069507524579, 
     0.762214101024893, 0.17949284972756532`}, {0.9419462598257622, 
     0.7617529997460479, 0.1801932600797145}, {0.9421850406615808, 
     0.7612916103795901, 0.18089343028199056`}, {0.942423293445501, 
     0.7608299334010975, 0.18159336004440355`}, {0.9426610183633877, 
     0.7603679692860474, 0.18229304907734012`}, {0.9428982156013836, 
     0.7599057185098158, 0.182992497091568}, {0.9431348853459103, 
     0.7594431815476778, 0.18369170379823263`}, {0.9433710277836663, 
     0.7589803588748084, 0.18439066890885794`}, {0.9436066431016281, 
     0.7585172509662811, 0.18508939213534695`}, {0.9438417314870494, 
     0.7580538582970685, 0.18578787318998086`}, {0.944076293127461, 
     0.7575901813420427, 0.18648611178541857`}, {0.9443103282106711, 
     0.7571262205759728, 0.1871841076346986}, {0.944543836924764, 
     0.7566619764735291, 0.18788186045123506`}, {0.9447768194581018, 
     0.7561974495092789, 0.18857936994882274`}, {0.9450092759993218, 
     0.7557326401576893, 0.18927663584163246`}, {0.9452412067373382, 
     0.7552675488931261, 0.1899736578442123}, {0.9454726118613418, 
     0.7548021761898522, 0.19067043567148964`}, {0.9457034915607982, 
     0.7543365225220313, 0.19136696903876735`}, {0.9459338460254498, 
     0.7538705883637228, 0.19206325766172708`}, {0.946163675445314, 
     0.7534043741888872, 0.1927593012564269}, {0.9463929800106832, 
     0.7529378804713823, 0.19345509953930068`}, {0.946621759912126, 
     0.7524711076849643, 0.19415065222716182`}, {0.9468500153404853, 
     0.7520040563032869, 0.19484595903719837`}, {0.9470777464868789, 
     0.7515367267999038, 0.19554101968697538`}, {0.9473049535426998, 
     0.7510691196482644, 0.19623583389443547`}, {0.9475316366996146, 
     0.750601235321719, 0.1969304013778956}, {0.9477577961495649, 
     0.7501330742935136, 0.19762472185605118`}, {0.9479834320847662, 
     0.7496646370367939, 0.19831879504797256`}, {0.9482085446977079, 
     0.7491959240246022, 0.19901262067310563`}, {0.948433134181153, 
     0.7487269357298796, 0.19970619845127358`}, {0.9486572007281385, 
     0.7482576726254652, 0.20039952810267328`}, {0.9488807445319746, 
     0.7477881351840956, 0.2010926093478791}, {0.9491037657862446, 
     0.7473183238784039, 0.2017854419078406}, {0.9493262646848047, 
     0.7468482391809235, 0.2024780255038814}, {0.9495482414217846, 
     0.7463778815640831, 0.20317035985770163`}, {0.949769696191586, 
     0.7459072515002105, 0.2038624446913756}, {0.9499906291888837, 
     0.7454363494615305, 0.20455427972735335`}, {0.9502110406086243, 
     0.7449651759201646, 0.2052458646884599}, {0.9504309306460269, 
     0.744493731348134, 0.20593719929789317`}, {0.9506502994965824, 
     0.7440220162173545, 0.20662828327922786`}, {0.9508691473560538, 
     0.7435500309996415, 0.20731911635641243`}, {0.9510874744204751, 
     0.7430777761667067, 0.20800969825376878`}, {0.9513052808861526, 
     0.7426052521901592, 0.20870002869599377`}, {0.9515225669496633, 
     0.7421324595415052, 0.2093901074081584}, {0.9517393328078553, 
     0.741659398692148, 0.21007993411570727`}, {0.9519555786578476, 
     0.7411860701133889, 0.21076950854445856`}, {0.9521713046970306, 
     0.7407124742764256, 0.21145883042060512`}, {0.9523865111230644, 
     0.7402386116523522, 0.2121478994707122}, {0.9526011981338796, 
     0.7397644827121617, 0.21283671542171845`}, {0.9528153659276778, 
     0.7392900879267403, 0.21352527800093743`}, {0.95302901470293, 
     0.7388154277668764, 0.21421358693605363`}, {0.9532421446583768, 
     0.738340502703251, 0.21490164195512587`}, {0.9534547559930292, 
     0.7378653132064433, 0.21558944278658573`}, {0.953666848906167, 
     0.7373898597469302, 0.21627698915923724`}, {0.9538784235973404, 
     0.7369141427950833, 0.21696428080225752`}, {0.9540894802663676, 
     0.7364381628211724, 0.2176513174451953}, {0.9543000191133362, 
     0.7359619202953639, 0.2183380988179724}, {0.9545100403386032, 
     0.7354854156877199, 0.2190246246508835}, {0.9547195441427934, 
     0.7350086494681995, 0.2197108946745938}, {0.9549285307268002, 
     0.7345316221066591, 0.2203969086201414}, {0.955137000291786, 
     0.7340543340728503, 0.22108266621893627`}, {0.9553449530391809, 
     0.7335767858364206, 0.22176816720276013`}, {0.9555523891706824, 
     0.7330989778669168, 0.2224534113037655}, {0.9557593088882568, 
     0.7326209106337792, 0.22313839825447765`}, {0.9559657123941372, 
     0.7321425846063457, 0.22382312778779173`}, {0.9561715998908248, 
     0.7316640002538487, 0.22450759963697609`}, {0.9563769715810873, 
     0.7311851580454196, 0.2251918135356674}, {0.9565818276679601, 
     0.7307060584500846, 0.22587576921787553`}, {0.9567861683547452, 
     0.7302267019367652, 0.22655946641798003`}, {0.9569899938450117, 
     0.7297470889742801, 0.22724290487073157`}, {0.9571933043425951, 
     0.7292672200313441, 0.2279260843112512}, {0.9573961000515971, 
     0.7287870955765667, 0.22860900447503046`}, {0.9575983811763858, 
     0.7283067160784557, 0.22929166509793056`}, {0.9578001479215955, 
     0.727826082005412, 0.2299740659161835}, {0.9580014004921263, 
     0.727345193825735, 0.2306562066663917}, {0.9582021390931439, 
     0.7268640520076174, 0.23133808708552622`}, {0.9584023639300798, 
     0.7263826570191513, 0.23201970691092885`}, {0.9586020752086307, 
     0.7259010093283205, 0.23270106588031042`}, {0.9588012731347585, 
     0.7254191094030072, 0.23338216373175144`}, {0.9589999579146905, 
     0.7249369577109889, 0.234063000203702}, {0.9591981297549185, 
     0.7244545547199377, 0.23474357503498092`}, {0.9593957888621988, 
     0.7239719008974228, 0.235423887964776}, {0.9595929354435531, 
     0.7234889967109084, 0.23610393873264507`}, {0.9597895697062667, 
     0.7230058426277537, 0.23678372707851342`}, {0.9599856918578894, 
     0.7225224391152137, 0.23746325274267582`}, {0.9601813021062351, 
     0.7220387866404399, 0.23814251546579532`}, {0.9603764006593811, 
     0.721554885670478, 0.23882151498890303`}, {0.9605709877256695, 
     0.7210707366722704, 0.2395002510533994}, {0.9607650635137046, 
     0.7205863401126531, 0.24017872340105142`}, {0.960958628232355, 
     0.7201016964583598, 0.2408569317739955}, {0.9611516820907522, 
     0.7196168061760169, 0.24153487591473544`}, {0.9613442252982909, 
     0.7191316697321479, 0.2422125555661431}, {0.9615362580646282, 
     0.718646287593172, 0.24288997047145636`}, {0.9617277805996844, 
     0.7181606602254019, 0.24356712037428258`}, {0.9619187931136423, 
     0.7176747880950467, 0.24424400501859553`}, {0.9621092958169467, 
     0.7171886716682104, 0.2449206241487362}, {0.9622992889203053, 
     0.7167023114108928, 0.24559697750941265`}, {0.962488772634687, 
     0.7162157077889868, 0.2462730648457002}, {0.9626777471713232, 
     0.7157288612682828, 0.24694888590304012`}, {0.962866212741707, 
     0.7152417723144655, 0.24762444042724174`}, {0.9630541695575926, 
     0.7147544413931134, 0.2482997281644791}, {0.9632416178309958, 
     0.7142668689697015, 0.2489747488612942}, {0.9634285577741943, 
     0.7137790555095997, 0.2496495022645945}, {0.9636149895997258, 
     0.7132910014780719, 0.250323988121654}, {0.9638009135203893, 
     0.7128027073402774, 0.2509982061801122}, {0.9639863297492449, 
     0.7123141735612706, 0.25167215618797434`}, {0.9641712384996131, 
     0.7118254006060006, 0.25234583789361253`}, {0.9643556399850741, 
     0.7113363889393115, 0.2530192510457627}, {0.9645395344194695, 
     0.7108471390259425, 0.2536923953935273}, {0.9647229220169005, 
     0.7103576513305262, 0.25436527068637443`}, {0.9649058029917278, 
     0.7098679263175913, 0.25503787667413674`}, {0.9650881775585723, 
     0.7093779644515614, 0.255710213107011}, {0.9652700459323147, 
     0.7088877661967538, 0.256382279735561}, {0.965451408328095, 
     0.7083973320173814, 0.25705407631071375`}, {0.9656322649613119, 
     0.7079066623775508, 0.2577256025837611}, {0.9658126160476241, 
     0.7074157577412651, 0.2583968583063592}, {0.9659924618029487, 
     0.7069246185724193, 0.2590678432305295}, {0.9661718024434619, 
     0.7064332453348052, 0.2597385571086566}, {0.9663506381855983, 
     0.7059416384921088, 0.2604089996934897}, {0.9665289692460511, 
     0.7054497985079098, 0.26107917073814135`}, {0.9667067958417721, 
     0.7049577258456832, 0.26174906999608943`}, {0.9668841181899706, 
     0.7044654209687976, 0.26241869722117284`}, {0.9670609365081145, 
     0.7039728843405182, 0.2630880521675965}, {0.9672372510139295, 
     0.7034801164240021, 0.26375713458992756`}, {0.9674130619253989, 
     0.7029871176823024, 0.26442594424309657`}, {0.9675883694607631, 
     0.7024938885783666, 0.26509448088239657`}, {0.9677631738385206, 
     0.702000429575036, 0.2657627442634848}, {0.9679374752774268, 
     0.7015067411350464, 0.26643073414238033`}, {0.9681112739964941, 
     0.7010128237210288, 0.26709845027546575`}, {0.9682845702149918, 
     0.7005186777955072, 0.2677658924194847}, {0.9684573641524462, 
     0.7000243038209011, 0.2684330603315453}, {0.9686296560286398, 
     0.6995297022595242, 0.2690999537691155}, {0.9688014460636121, 
     0.6990348735735841, 0.2697665724900281}, {0.9689727344776582, 
     0.6985398182251829, 0.27043291625247534`}, {0.9691435214913299, 
     0.6980445366763165, 0.2710989848150133}, {0.9693138073254346, 
     0.6975490293888762, 0.27176477793655823`}, {0.9694835922010359, 
     0.6970532968246469, 0.272430295376389}, {0.9696528763394526, 
     0.6965573394453071, 0.2730955368941456}, {0.9698216599622593, 
     0.6960611577124312, 0.27376050224982834`}, {0.9699899432912861, 
     0.6955647520874852, 0.2744251912038008}, {0.970157726548618, 
     0.6950681230318329, 0.27508960351678535`}, {0.9703250099565951, 
     0.6945712710067289, 0.27575373894986643`}, {0.9704917937378127, 
     0.6940741964733234, 0.2764175972644895}, {0.9706580781151205, 
     0.6935768998926608, 0.2770811782224596}, {0.9708238633116228, 
     0.6930793817256807, 0.27774448158594234`}, {0.9709891495506785, 
     0.6925816424332149, 0.278407507117464}, {0.971153937055901, 
     0.6920836824759896, 0.27907025457991164`}, {0.9713182260511575, 
     0.6915855023146267, 0.2797327237365309}, {0.971482016760569, 
     0.6910871024096407, 0.2803949143509285}, {0.971645309408511, 
     0.6905884832214406, 0.2810568261870707}, {0.9718081042196121, 
     0.6900896452103303, 0.281718459009282}, {0.9719704014187545, 
     0.6895905888365066, 0.28237981258224815`}, {0.9721322012310744, 
     0.6890913145600607, 0.28304088667101357`}, {0.9722935038819602, 
     0.6885918228409789, 0.2837016810409815}, {0.9724543095970545, 
     0.6880921141391398, 0.2843621954579148}, {0.9726146186022518, 
     0.6875921889143177, 0.28502242968793423`}, {0.9727744311237003, 
     0.6870920476261797, 0.2856823834975204}, {0.9729337473878005, 
     0.686591690734288, 0.2863420566535122}, {0.9730925676212049, 
     0.6860911186980991, 0.28700144892310603`}, {0.9732508920508189, 
     0.6855903319769608, 0.28766056007385826`}, {0.9734087209038003, 
     0.6850893310301186, 0.28831938987368194`}, {0.9735660544075583, 
     0.6845881163167098, 0.2889779380908487}, {0.9737228927897544, 
     0.6840866882957666, 0.28963620449398825`}, {0.9738792362783021, 
     0.6835850474262142, 0.29029418885208813`}, {0.9740350851013658, 
     0.6830831941668731, 0.290951890934493}, {0.974190439487362, 
     0.6825811289764573, 0.29160931051090455`}, {0.9743452996649583, 
     0.682078852313575, 0.29226644735138335`}, {0.9744996658630735, 
     0.6815763646367282, 0.2929233012263454}, {0.9746535383108772, 
     0.6810736664043122, 0.29357987190656515`}, {0.9748069172377902, 
     0.680570758074618, 0.29423615916317214`}, {0.9749598028734842, 
     0.68006764010583, 0.29489216276765456`}, {0.9751121954478809, 
     0.6795643129560247, 0.29554788249185643`}, {0.975264095191153, 
     0.6790607770831756, 0.2962033181079776}, {0.9754155023337232, 
     0.678557032945148, 0.296858469388575}, {0.9755664171062646, 
     0.6780530809997031, 0.2975133361065615}, {0.9757168397397001, 
     0.6775489217044943, 0.2981679180352057}, {0.9758667704652028, 
     0.6770445555170704, 0.29882221494813227`}, {0.9760162095141949, 
     0.6765399828948738, 0.29947622661932105`}, {0.9761651571183491, 
     0.6760352042952403, 0.3001299528231087}, {0.9763136135095869, 
     0.6755302201754005, 0.30078339333418647`}, {0.9764615789200795, 
     0.675025030992479, 0.3014365479276009}, {0.9766090535822467, 
     0.674519637203494, 0.30208941637875286`}, {0.976756037728758, 
     0.6740140392653587, 0.3027419984633994}, {0.9769025315925315, 
     0.673508237634879, 0.3033942939576525}, {0.9770485354067342, 
     0.673002232768756, 0.3040463026379782}, {0.9771940494047814, 
     0.6724960251235846, 0.30469802428119697`}, {0.9773390738203371, 
     0.6719896151558535, 0.30534945866448354`}, {0.977483608887314, 
     0.671483003321946, 0.30600060556536784`}, {0.9776276548398722, 
     0.6709761900781395, 0.3066514647617331}, {0.9777712119124207, 
     0.6704691758806041, 0.30730203603181677`}, {0.9779142803396157, 
     0.669961961185406, 0.30795231915420973`}, {0.9780568603563616, 
     0.6694545464485047, 0.308602313907857}, {0.9781989521978105, 
     0.6689469321257541, 0.3092520200720566}, {0.9783405560993618, 
     0.6684391186729015, 0.30990143742646026`}, {0.9784816722966623, 
     0.6679311065455896, 0.31055056575107276`}, {0.9786223010256063, 
     0.6674228961993539, 0.31119940482625247`}, {0.9787624425223352, 
     0.6669144880896255, 0.31184795443271}, {0.9789020970232368, 
     0.6664058826717283, 0.3124962143515086}, {0.9790412647649465, 
     0.6658970804008824, 0.31314418436406427`}, {0.9791799459843458, 
     0.6653880817321998, 0.3137918642521462}, {0.9793181409185632, 
     0.6648788871206881, 0.3144392537978753}, {0.9794558498049736, 
     0.6643694970212489, 0.3150863527837245}, {0.9795930728811977, 
     0.6638599118886794, 0.3157331609925183}, {0.979729810385103, 
     0.6633501321776686, 0.31637967820743446`}, {0.9798660625548028, 
     0.6628401583428017, 0.3170259042120014}, {0.9800018296286563, 
     0.6623299908385575, 0.3176718387900993}, {0.9801371118452686, 
     0.6618196301193089, 0.3183174817259598}, {0.9802719094434901, 
     0.661309076639324, 0.3189628328041659}, {0.980406222662417, 
     0.6607983308527664, 0.319607891809651}, {0.9805400517413909, 
     0.6602873932136906, 0.32025265852770085`}, {0.9806733969199986, 
     0.659776264176048, 0.32089713274395076`}, {0.980806258438072, 
     0.6592649441936846, 0.32154131424438737`}, {0.9809386365356879, 
     0.6587534337203405, 0.32218520281534774`}, {0.9810705314531681, 
     0.6582417332096497, 0.32282879824351846`}, {0.9812019434310794, 
     0.6577298431151416, 0.3234721003159376}, {0.9813328727102324, 
     0.6572177638902401, 0.32411510881999234`}, {0.981463319531683, 
     0.6567054959882624, 0.3247578235434203}, {0.981593284136731, 
     0.6561930398624233, 0.325400244274308}, {0.9817227667669208, 
     0.6556803959658275, 0.32604237080109333`}, {0.9818517676640405, 
     0.6551675647514792, 0.32668420291256156`}, {0.9819802870701222, 
     0.6546545466722741, 0.32732574039784795`}, {0.9821083252274424, 
     0.6541413421810044, 0.3279669830464383}, {0.9822358823785204, 
     0.6536279517303556, 0.3286079306481649}, {0.9823629587661201, 
     0.6531143757729093, 0.32924858299321097`}, {0.982489554633248, 
     0.6526006147611412, 0.3298889398721069}, {0.9826156702231545, 
     0.6520866691474213, 0.3305290010757331}, {0.982741305779333, 
     0.6515725393840166, 0.3311687663953167}, {0.98286646154552, 
     0.6510582259230862, 0.3318082356224341}, {0.982991137765695, 
     0.6505437292166856, 0.3324474085490097}, {0.9831153346840806, 
     0.6500290497167645, 0.333086284967316}, {0.9832390525451415, 
     0.6495141878751703, 0.3337248646699716}, {0.9833622915935857, 
     0.6489991441436411, 0.334363147449945}, {0.9834850520743632, 
     0.6484839189738122, 0.3350011331005507}, {0.9836073342326668, 
     0.6479685128172151, 0.3356388214154516}, {0.9837291383139309, 
     0.6474529261252757, 0.33627621218865567`}, {0.9838504645638328, 
     0.6469371593493127, 0.3369133052145202}, {0.9839713132282912, 
     0.6464212129405434, 0.337550100287748}, {0.9840916845534671, 
     0.6459050873500785, 0.33818659720338856`}, {0.9842115787857628, 
     0.6453887830289241, 0.3388227957568385}, {0.9843309961718227, 
     0.6448723004279823, 0.33945869574384047`}, {0.9844499369585324, 
     0.6443556399980496, 0.34009429696048266`}, {0.9845684013930195, 
     0.6438388021898186, 0.34072959920320117`}, {0.9846863897226517, 
     0.6433217874538774, 0.34136460226877463`}, {0.9848039021950392, 
     0.6428045962407076, 0.3419993059543316}, {0.9849209390580325, 
     0.6422872290006892, 0.3426337100573431}, {0.9850375005597231, 
     0.6417696861840971, 0.3432678143756265}, {0.9851535869484437, 
     0.6412519682410993, 0.34390161870734465`}, {0.9852691984727672, 
     0.6407340756217617, 0.34453512285100557`}, {0.9853843353815074, 
     0.6402160087760466, 0.34516832660546104`}, {0.9854989979237185, 
     0.6396977681538093, 0.3458012297699092}, {0.9856131863486953, 
     0.6391793542048037, 0.346433832143892}, {0.9857269009059726, 
     0.6386607673786768, 0.3470661335272963}, {0.9858401418453252, 
     0.638142008124973, 0.34769813372035246`}, {0.9859529094167683, 
     0.6376230768931329, 0.3483298325236356}, {0.9860652038705566, 
     0.637103974132492, 0.34896122973806465`}, {0.9861770254571851, 
     0.636584700292283, 0.34959232516490246`}, {0.9862883744273881, 
     0.6360652558216331, 0.35022311860575556`}, {0.9863992510321397, 
     0.6355456411695656, 0.3508536098625739}, {0.9865096555226532, 
     0.6350258567850028, 0.35148379873765034`}, {0.9866195881503816, 
     0.6345059031167593, 0.3521136850336224}, {0.9867290491670169, 
     0.6339857806135483, 0.3527432685534685}, {0.9868380388244903, 
     0.633465489723979, 0.35337254910051125`}, {0.986946557374972, 
     0.632945030896556, 0.3540015264784163}, {0.9870546050708715, 
     0.6324244045796809, 0.3546302004911909}, {0.9871621821648365, 
     0.6319036112216514, 0.3552585709431854}, {0.9872692889097539, 
     0.631382651270663, 0.35588663763909123`}, {0.9873759255587488, 
     0.6308615251748056, 0.35651440038394355`}, {0.987482092365185, 
     0.6303402333820668, 0.3571418589831183}, {0.987587789582665, 
     0.6298187763403321, 0.35776901324233296`}, {0.987693017465029, 
     0.6292971544973818, 0.3583958629676477}, {0.9877977762663557, 
     0.6287753683008926, 0.3590224079654631}, {0.9879020662409619, 
     0.6282534181984406, 0.3596486480425213}, {0.9880058876434022, 
     0.627731304637497, 0.3602745830059057}, {0.9881092407284694, 
     0.6272090280654293, 0.3609002126630405}, {0.9882121257511934, 
     0.6266865889295034, 0.36152553682169053`}, {0.9883145429668427, 
     0.6261639876768813, 0.36215055528996154`}, {0.9884164926309223, 
     0.6256412247546238, 0.3627752678762991}, {0.9885179749991758, 
     0.625118300609686, 0.36339967438948995`}, {0.988618990327583, 
     0.6245952156889234, 0.36402377463866}, {0.988719538872362, 
     0.6240719704390862, 0.3646475684332761}, {0.9888196208899671, 
     0.623548565306823, 0.36527105558314404`}, {0.9889192366370905, 
     0.6230250007386811, 0.3658942358984095}, {0.9890183863706606, 
     0.6225012771811035, 0.36651710918955754`}, {0.9891170703478434, 
     0.6219773950804309, 0.3671396752674123}, {0.989215288826041, 
     0.6214533548829025, 0.3677619339431387}, {0.9893130420628927, 
     0.6209291570346545, 0.36838388502823816`}, {0.9894103303162739, 
     0.6204048019817224, 0.36900552833455147`}, {0.9895071538442968, 
     0.619880290170037, 0.36962686367425984`}, {0.9896035129053098, 
     0.6193556220454284, 0.3702478908598812}, {0.9896994077578976, 
     0.6188307980536254, 0.3708686097042722}, {0.989794838660881, 
     0.6183058186402539, 0.37148902002062695`}, {0.9898898058733172, 
     0.6177806842508378, 0.3721091216224795}, {0.9899843096544989, 
     0.6172553953307992, 0.3727289143236996}, {0.9900783502639551, 
     0.6167299523254602, 0.37334839793849545`}, {0.9901719279614505, 
     0.616204355680038, 0.37396757228141286`}, {0.9902650430069854, 
     0.61567860583965, 0.37458643716733536`}, {0.9903576956607958, 
     0.6151527032493137, 0.3752049924114823}, {0.9904498861833532, 
     0.6146266483539427, 0.3758232378294106}, {0.9905416148353645, 
     0.6141004415983504, 0.3764411732370147}, {0.990632881877772, 
     0.6135740834272477, 0.3770587984505245}, {0.9907236875717532, 
     0.6130475742852465, 0.3776761132865067}, {0.9908140321787209, 
     0.6125209146168554, 0.37829311756186546`}, {0.9909039159603228, 
     0.6119941048664841, 0.37890981109383887`}, {0.9909933391784416, 
     0.6114671454784388, 0.37952619370000273`}, {0.991082302095195, 
     0.610940036896927, 0.3801422651982682}, {0.9911708049729354, 
     0.6104127795660542, 0.38075802540688164`}, {0.99125884807425, 
     0.6098853739298252, 0.38137347414442496`}, {0.9913464316619607, 
     0.6093578204321453, 0.3819886112298159}, {0.9914335559991238, 
     0.6088301195168174, 0.38260343648230644`}, {0.99152022134903, 
     0.6083022716275461, 0.3832179497214839}, {0.9916064279752046, 
     0.6077742772079342, 0.38383215076727073`}, {0.9916921761414071, 
     0.6072461367014841, 0.38444603943992334`}, {0.9917774661116312, 
     0.6067178505515985, 0.3850596155600326}, {0.9918622981501048, 
     0.6061894192015806, 0.3856728789485245}, {0.9919466725212895, 
     0.6056608430946325, 0.38628582942665696`}, {0.9920305894898814, 
     0.6051321226738569, 0.38689846681602474`}, {0.9921140493208102, 
     0.6046032583822559, 0.3875107909385539}, {0.9921970522792393, 
     0.6040742506627343, 0.38812280161650536`}, {0.9922795986305658, 
     0.6035450999580929, 0.3887344986724734}, {0.992361688640421, 
     0.6030158067110366, 0.3893458819293845}, {0.9924433225746688, 
     0.6024863713641703, 0.38995695121049895`}, {0.9925245006994075, 
     0.6019567943599977, 0.39056770633940985`}, {0.9926052232809681, 
     0.6014270761409257, 0.39117814714004234`}, {0.9926854905859154, 
     0.6008972171492598, 0.3917882734366555}, {0.9927653028810474, 
     0.6003672178272079, 0.39239808505383983`}, {0.9928446604333949, 
     0.5998370786168781, 0.3930075818165172}, {0.9929235635102222, 
     0.5993067999602795, 0.3936167635499429}, {0.9930020123790262, 
     0.5987763822993234, 0.39422563007970274`}, {0.9930800073075373, 
     0.5982458260758218, 0.39483418123171565`}, {0.9931575485637184, 
     0.5977151317314873, 0.39544241683223097`}, {0.9932346364157651, 
     0.5971842997079357, 0.3960503367078296}, {0.9933112711321062, 
     0.596653330446683, 0.39665794068542304`}, {0.9933874529814025, 
     0.5961222243891476, 0.3972652285922549}, {0.9934631822325478, 
     0.5955909819766498, 0.39787220025589787`}, {0.9935384591546684, 
     0.5950596036504113, 0.3984788555042573}, {0.993613284017123, 
     0.5945280898515557, 0.3990851941655676}, {0.9936876570895025, 
     0.5939964410211095, 0.399691216068393}, {0.9937615786416303, 
     0.5934646576000018, 0.4002969210416289}, {0.9938350489435618, 
     0.592932740029062, 0.4009023089144998}, {0.9939080682655848, 
     0.5924006887490243, 0.40150737951656057`}, {0.993980636878219, 
     0.591868504200524, 0.4021121326776951}, {0.9940527550522165, 
     0.5913361868241004, 0.4027165682281164}, {0.9941244230585606, 
     0.590803737060194, 0.403320685998367}, {0.9941956411684675, 
     0.5902711553491483, 0.40392448581931895`}, {0.9942664096533842, 
     0.5897384421312128, 0.4045279675221716}, {0.9943367287849902, 
     0.5892055978465359, 0.4051311309384545}, {0.9944065988351964, 
     0.588672622935172, 0.4057339759000248}, {0.9944760200761454, 
     0.5881395178370779, 0.4063365022390679}, {0.9945449927802112, 
     0.5876062829921141, 0.4069387097880976}, {0.9946135172199997, 
     0.5870729188400443, 0.40754059837995565`}, {0.9946815936683477, 
     0.5865394258205373, 0.4081421678478107}, {0.994749222398324, 
     0.5860058043731642, 0.4087434180251599}, {0.9948164036832282, 
     0.5854720549374006, 0.4093443487458278}, {0.9948831377965914, 
     0.584938177952626, 0.4099449598439652}, {0.9949494250121759, 
     0.5844041738581254, 0.4105452511540504}, {0.9950152656039751, 
     0.5838700430930863, 0.4111452225108891}, {0.9950806598462136, 
     0.5833357860966017, 0.4117448737496122}, {0.995145608013347, 
     0.5828014033076682, 0.4123442047056786}, {0.9952101103800615, 
     0.5822668951651893, 0.41294321521487226`}, {0.9952741672212748, 
     0.5817322621079711, 0.41354190511330396`}, {0.9953377788121351, 
     0.5811975045747256, 0.41414027423740973`}, {0.9954009454280218, 
     0.5806626230040689, 0.4147383224239528}, {0.9954636673445445, 
     0.5801276178345252, 0.4153360495100193}, {0.9955259448375438, 
     0.5795924895045205, 0.4159334553330232}, {0.995587778183091, 
     0.5790572384523888, 0.4165305397307026}, {0.9956491676574878, 
     0.578521865116368, 0.41712730254112007`}, {0.9957101135372667, 
     0.5779863699346025, 0.4177237436026642}, {0.9957706160991905, 
     0.577450753345144, 0.41831986275404665`}, {0.9958306756202526, 
     0.5769150157859473, 0.41891565983430545`}, {0.9958902923776767, 
     0.5763791576948758, 0.4195111346828007}, {0.9959494666489167, 
     0.5758431795096992, 0.42010628713921766`}, {0.9960081987116571, 
     0.5753070816680914, 0.4207011170435659}, {0.9960664888438127, 
     0.574770864607635, 0.42129562423617795`}, {0.9961243373235279, 
     0.5742345287658184, 0.4218898085577096}, {0.9961817444291781, 
     0.5736980745800371, 0.42248366984914093`}, {0.9962387104393681, 
     0.5731615024875946, 0.42307720795177356`}, {0.9962952356329332, 
     0.5726248129256991, 0.4236704227072343}, {0.9963513202889385, 
     0.5720880063314687, 0.4242633139574701}, {0.9964069646866793, 
     0.5715510831419274, 0.42485588154475207`}, {0.9964621691056806, 
     0.5710140437940076, 0.4254481253116736}, {0.9965169338256977, 
     0.5704768887245483, 0.4260400451011499}, {0.9965712591267153, 
     0.5699396183702972, 0.42663164075641824`}, {0.996625145288948, 
     0.5694022331679113, 0.42722291212103664`}, {0.9966785925928403, 
     0.5688647335539534, 0.4278138590388871}, {0.9967316013190667, 
     0.5683271199648963, 0.42840448135417075`}, {0.9967841717485307, 
     0.5677893928371203, 0.4289947789114105}, {0.9968363041623662, 
     0.5672515526069154, 0.4295847515554513}, {0.9968879988419364, 
     0.5667135997104789, 0.4301743991314576}, {0.996939256068834, 
     0.5661755345839182, 0.43076372148491543`}, {0.9969900761248814, 
     0.5656373576632511, 0.4313527184616309}, {0.9970404592921306, 
     0.5650990693844008, 0.43194138990772996`}, {0.9970904058528628, 
     0.5645606701832039, 0.43252973566965897`}, {0.997139916089589, 
     0.5640221604954042, 0.4331177555941845}, {0.9971889902850493, 
     0.563483540756657, 0.43370544952839246`}, {0.9972376287222133, 
     0.562944811402526, 0.4342928173196876}, {0.9972858316842804, 
     0.5624059728684847, 0.4348798588157958}, {0.9973335994546786, 
     0.561867025589919, 0.4354665738647596}, {0.9973809323170656, 
     0.5613279700021235, 0.4360529623149422}, {0.9974278305553282, 
     0.5607888065403034, 0.43663902401502486`}, {0.9974742944535829, 
     0.560249535639576, 0.43722475881400713`}, {0.9975203242961748, 
     0.559710157734967, 0.43781016656120764`}, {0.9975659203676785, 
     0.5591706732614165, 0.43839524710626226`}, {0.9976110829528979, 
     0.5586310826537728, 0.4389800002991255}, {0.9976558123368657, 
     0.5580913863467976, 0.4395644259900681}, {0.9977001088048439, 
     0.5575515847751634, 0.4401485240296805}, {0.9977439726423237, 
     0.5570116783734546, 0.4407322942688691}, {0.9977874041350252, 
     0.5564716675761681, 0.44131573655885736`}, {0.9978304035688976, 
     0.5559315528177111, 0.44189885075118696`}, {0.9978729712301192, 
     0.5553913345324053, 0.4424816366977141}, {0.9979151074050971, 
     0.5548510131544836, 0.4430640942506141}, {0.9979568123804677, 
     0.5543105891180917, 0.44364622326237585`}, {0.9979980864430962, 
     0.5537700628572897, 0.44422802358580615`}, {0.9980389298800766, 
     0.5532294348060478, 0.44480949507402867`}, {0.9980793429787321, 
     0.5526887053982528, 0.4453906375804796}, {0.9981193260266147, 
     0.5521478750677017, 0.4459714509589133}, {0.9981588793115054, 
     0.5516069442481064, 0.44655193506339896`}, {0.9981980031214138, 
     0.5510659133730939, 0.44713208974832025`}, {0.9982366977445789, 
     0.5505247828762025, 0.44771191486837614`}, {0.998274963469468, 
     0.5499835531908872, 0.4482914102785806}, {0.9983128005847776, 
     0.5494422247505157, 0.44887057583426165`}, {0.9983502093794329, 
     0.5489007979883715, 0.4494494113910617}, {0.998387190142588, 
     0.5483592733376503, 0.4500279168049374}, {0.9984237431636258, 
     0.5478176512314664, 0.45060609193215917`}, {0.998459868732158, 
     0.5472759321028463, 0.45118393662931167`}, {0.998495567138025, 
     0.5467341163847333, 0.45176145075329205`}, {0.9985308386712962, 
     0.5461922045099845, 0.45233863416131204`}, {0.9985656836222698, 
     0.5456501969113752, 0.45291548671089515`}, {0.9986001022814724, 
     0.5451080940215943, 0.4534920082598779}, {0.9986340949396599, 
     0.5445658962732486, 0.45406819866641146`}, {0.9986676618878167, 
     0.5440236040988597, 0.4546440577889568}, {0.998700803417156, 
     0.5434812179308679, 0.45521958548628855`}, {0.9987335198191195, 
     0.5429387382016266, 0.45579478161749304`}, {0.9987658113853782, 
     0.5423961653434094, 0.45636964604196933`}, {0.9987976784078317, 
     0.541853499788405, 0.4569441786194264}, {0.9988291211786081, 
     0.5413107419687211, 0.4575183792098868}, {0.9988601399900645, 
     0.5407678923163827, 0.4580922476736819}, {0.9988907351347868, 
     0.5402249512633306, 0.45866578387145596`}, {0.9989209069055894, 
     0.5396819192414258, 0.4592389876641636}, {0.998950655595516, 
     0.5391387966824461, 0.4598118589130698}, {0.9989799814978385, 
     0.5385955840180893, 0.4603843974797498}, {0.999008884906058, 
     0.5380522816799688, 0.4609566032260891}, {0.9990373661139041, 
     0.5375088900996208, 0.4615284760142837}, {0.9990654254153356, 
     0.536965409708496, 0.46210001570683934`}, {0.9990930631045397, 
     0.5364218409379705, 0.4626712221665697}, {0.9991202794759327, 
     0.535878184219333, 0.46324209525660004`}, {0.9991470748241597, 
     0.5353344399837959, 0.463812634840364}, {0.9991734494440944, 
     0.5347906086624926, 0.46438284078160225`}, {0.9991994036308396, 
     0.5342466906864723, 0.4649527129443673}, {0.999224937679727, 
     0.5337026864867087, 0.46552225119301854`}, {0.999250051886317, 
     0.5331585964940941, 0.4660914553922232}, {0.999274746546399, 
     0.5326144211394424, 0.4666603254069571}, {0.9992990219559914, 
     0.5320701608534881, 0.4672288611025035}, {0.9993228784113414, 
     0.5315258160668872, 0.4677970623444547}, {0.999346316208925, 
     0.5309813872102164, 0.46836492899870863`}, {0.9993693356454477, 
     0.5304368747139758, 0.4689324609314717}, {0.9993919370178435, 
     0.5298922790085868, 0.46949965800925664`}, {0.9994141206232753, 
     0.5293476005243928, 0.47006652009888256`}, {0.9994358867591356, 
     0.528802839691659, 0.4706330470674764}, {0.9994572357230456, 
     0.5282579969405762, 0.47119923878246933`}, {0.9994781678128555, 
     0.5277130727012539, 0.47176509511160164`}, {0.9994986833266448, 
     0.5271680674037282, 0.4723306159229168}, {0.999518782562722, 
     0.5266229814779566, 0.47289580108476503`}, {0.9995384658196247, 
     0.5260778153538225, 0.4734606504658026}, {0.9995577333961199, 
     0.5255325694611296, 0.47402516393499017`}, {0.9995765855912035, 
     0.5249872442296105, 0.474589341361593}, {0.999595022704101, 
     0.5244418400889191, 0.47515318261518225`}, {0.9996130450342668, 
     0.5238963574686347, 0.4757166875656327}, {0.999630652881385, 
     0.5233507967982601, 0.4762798560831248}, {0.9996478465453686, 
     0.5228051585072269, 0.47684268803814195`}, {0.9996646263263602, 
     0.5222594430248895, 0.47740518330147125`}, {0.9996809925247317, 
     0.521713650780527, 0.4779673417442048}, {0.9996969454410848, 
     0.521167782203348, 0.47852916323773687`}, {0.9997124853762499, 
     0.5206218377224844, 0.4790906476537657}, {0.9997276126312876, 
     0.5200758177669952, 0.4796517948642922}, {0.9997423275074878, 
     0.519529722765868, 0.4802126047416202}, {0.9997566303063701, 
     0.5189835531480143, 0.48077307715835627`}, {0.9997705213296834, 
     0.5184373093422739, 0.481333211987409}, {0.9997840008794066, 
     0.517890991777418, 0.4818930091019886}, {0.999797069257748, 
     0.5173446008821387, 0.48245246837560957`}, {0.9998097267671462, 
     0.5167981370850622, 0.48301158968208413`}, {0.9998219737102688, 
     0.5162516008147392, 0.4835703728955295}, {0.9998338103900141, 
     0.5157049924996516, 0.48412881789036255`}, {0.9998452371095095, 
     0.515158312568209, 0.4846869245413008}, {0.9998562541721128, 
     0.5146115614487492, 0.48524469272336335`}, {0.9998668618814117, 
     0.5140647395695426, 0.4858021223118697}, {0.9998770605412239, 
     0.5135178473587854, 0.48635921318243885`}, {0.9998868504555972, 
     0.5129708852446073, 0.48691596521099006`}, {0.9998962319288096, 
     0.5124238536550663, 0.4874723782737436}, {0.999905205265369, 
     0.5118767530181503, 0.48802845224721897`}, {0.9999137707700139, 
     0.5113295837617807, 0.48858418700823336`}, {0.9999219287477129, 
     0.5107823463138087, 0.4891395824339045}, {0.9999296795036651, 
     0.510235041102016, 0.48969463840164956`}, {0.9999370233432997, 
     0.5096876685541168, 0.4902493547891828}, {0.9999439605722767, 
     0.5091402290977586, 0.4908037314745183}, {0.9999504914964866, 
     0.5085927231605187, 0.49135776833596806`}, {0.9999566164220504, 
     0.5080451511699094, 0.4919114652521408}, {0.9999623356553196, 
     0.5074975135533749, 0.4924648221019446}, {0.9999676495028766, 
     0.5069498107382925, 0.4930178387645846}, {0.9999725582715346, 
     0.5064020431519726, 0.4935705151195622}, {0.9999770622683377, 
     0.5058542112216606, 0.4941228510466772}, {0.9999811618005606, 
     0.5053063153745347, 0.4946748464260259}, {0.9999848571757093, 
     0.5047583560377096, 0.495226501138}, {0.9999881487015205, 
     0.5042103336382322, 0.49577781506328855`}, {0.9999910366859626, 
     0.5036622486030862, 0.49632878808287634`}, {0.9999935214372345, 
     0.5031141013591894, 0.496879420078045}, {0.9999956032637669, 
     0.5025658923333972, 0.49742971093037003`}, {0.9999972824742215, 
     0.5020176219524988, 0.49797966052172327`}, {0.9999985593774915, 
     0.5014692906432198, 0.49852926873427167`}, {0.9999994342827015, 
     0.5009208988322253, 0.49907853545047653`}, {0.9999999074992081, 
     0.5003724469461136, 0.49962746055309426`}, {0.9999999793365989, 
     0.49982393541142356`, 0.5001760439251758}, {0.9999996501046935, 
     0.4992753646546278, 0.5007242854500655}, {0.9999989201135435, 
     0.4987267351021409, 0.5012721850114027}, {0.999997789673432, 
     0.4981780471803135, 0.501819742493119}, {0.9999962590948743, 
     0.49762930131543426`, 0.5023669577794405}, {0.9999943286886177, 
     0.49708049793373155`, 0.5029138307548864}, {0.9999919987656416, 
     0.4965316374613739, 0.503460361304268}, {0.9999892696371576, 
     0.49598272032446694`, 0.5040065493126906}, {0.9999861416146096, 
     0.49543374694906017`, 0.5045523946655501}, {0.9999826150096741, 
     0.49488471776113807`, 0.5050978972485364}, {0.9999786901342597, 
     0.49433563318662993`, 0.5056430569476297}, {0.9999743673005078, 
     0.49378649365140415`, 0.5061878736491039}, {0.9999696468207925, 
     0.49323729958126966`, 0.5067323472395227}, {0.9999645290077206, 
     0.4926880514019796, 0.5072764776057409}, {0.9999590141741317, 
     0.4921387495392273, 0.5078202646349046}, {0.9999531026330984, 
     0.4915893944186462, 0.5083637082144522}, {0.9999467946979265, 
     0.49103998646581715`, 0.5089068082321098}, {0.9999400906821546, 
     0.4904905261062601, 0.5094495645758946}, {0.9999329908995549, 
     0.4899410137654399, 0.5099919771341153}, {0.9999254956641327, 
     0.4893914498687646, 0.5105340457953687}, {0.9999176052901269, 
     0.48884183484158583`, 0.511075770448541}, {0.9999093200920098, 
     0.4882921691092018, 0.5116171509828079}, {0.9999006403844876, 
     0.48774245309685366`, 0.5121581872876338}, {0.9998915664825001, 
     0.48719268722972703`, 0.5126988792527732}, {0.9998820987012209, 
     0.486642871932955, 0.5132392267682662}, {0.9998722373560578, 
     0.48609300763161434`, 0.5137792297244437}, {0.9998619827626526, 
     0.4855430947507301, 0.5143188880119227}, {0.9998513352368813, 
     0.4849931337152715, 0.5148582015216095}, {0.9998402950948541, 
     0.48444312495015873`, 0.5153971701446958}, {0.9998288626529158, 
     0.48389306888025474`, 0.5159357937726613}, {0.9998170382276458, 
     0.4833429659303721, 0.5164740722972735}, {0.999804822135858, 
     0.48279281652527267`, 0.5170120056105852}, {0.9997922146946011, 
     0.4822426210896658, 0.5175495936049357}, {0.9997792162211588, 
     0.48169238004820863`, 0.5180868361729505}, {0.99976582703305, 
     0.48114209382550893`, 0.5186237332075415}, {0.9997520474480283, 
     0.4805917628461228, 0.5191602846019058}, {0.9997378777840829, 
     0.4800413875345582, 0.5196964902495248}, {0.9997233183594383, 
     0.4794909683152725, 0.5202323500441661}, {0.9997083694925547, 
     0.47894050561267315`, 0.5207678638798818}, {0.9996930315021276, 
     0.4783899998511198, 0.5213030316510081}, {0.9996773047070887, 
     0.47783945145492257`, 0.5218378532521663}, {0.9996611894266053, 
     0.47728886084834604`, 0.5223723285782598}, {0.9996446859800809, 
     0.4767382284556032, 0.5229064575244781}, {0.9996277946871552, 
     0.47618755470086327`, 0.5234402399862919}, {0.9996105158677042, 
     0.47563684000824785`, 0.5239736758594562}, {0.9995928498418403, 
     0.4750860848018316, 0.5245067650400093}, {0.9995747969299126, 
     0.47453528950564233`, 0.5250395074242706}, {0.9995563574525067, 
     0.47398445454366384`, 0.5255719029088434}, {0.9995375317304453, 
     0.4734335803398333, 0.5261039513906121}, {0.9995183200847884, 
     0.4728826673180453, 0.526635652766743}, {0.9994987228368324, 
     0.47233171590214795`, 0.5271670069346843}, {0.9994787403081116, 
     0.47178072651594705`, 0.527698013792165}, {0.9994583728203977, 
     0.47122969958320204`, 0.5282286732371956}, {0.9994376206956999, 
     0.4706786355276341, 0.5287589851680661}, {0.9994164842562652, 
     0.4701275347729165, 0.5292889494833487}, {0.9993949638245783, 
     0.4695763977426847, 0.5298185660818938}, {0.9993730597233623, 
     0.4690252248605284, 0.5303478348628338}, {0.9993507722755783, 
     0.4684740165500005, 0.5308767557255781}, {0.9993281018044261, 
     0.46792277323460824`, 0.5314053285698183}, {0.9993050486333434, 
     0.46737149533782096`, 0.5319335532955225}, {0.9992816130860072, 
     0.4668201832830687, 0.5324614298029386}, {0.999257795486333, 
     0.46626883749373965`, 0.5329889579925933}, {0.9992335961584755, 
     0.4657174583931844, 0.5335161377652912}, {0.9992090154268286, 
     0.4651660464047153, 0.5340429690221139}, {0.9991840536160254, 
     0.4646146019516032, 0.5345694516644222}, {0.9991587110509386, 
     0.46406312545708517`, 0.5350955855938532}, {0.9991329880566804, 
     0.46351161734435997`, 0.535621370712321}, {0.9991068849586031, 
     0.46296007803658673`, 0.5361468069220168}, {0.9990804020822992, 
     0.4624085079568911, 0.5366718941254085}, {0.9990535397536008, 
     0.4618569075283611, 0.5371966322252396}, {0.9990262982985808, 
     0.4613052771740506, 0.5377210211245299}, {0.9989986780435527, 
     0.4607536173169787, 0.5382450607265741}, {0.9989706793150704, 
     0.4602019283801276, 0.5387687509349433}, {0.9989423024399291, 
     0.4596502107864459, 0.5392920916534835}, {0.9989135477451648, 
     0.45909846495885065`, 0.5398150827863142}, {0.998884415558055, 
     0.4585466913202246, 0.5403377242378304}, {0.9988549062061183, 
     0.45799489029341695`, 0.5408600159127015}, {0.9988250200171154, 
     0.4574430623012462, 0.5413819577158694}, {0.9987947573190485, 
     0.45689120776649716`, 0.5419035495525516}, {0.9987641184401621, 
     0.45633932711192554`, 0.5424247913282367}, {0.9987331037089426, 
     0.4557874207602551, 0.5429456829486876}, {0.9987017134541192, 
     0.45523548913418016`, 0.5434662243199395}, {0.9986699480046632, 
     0.4546835326563627, 0.5439864153483005}, {0.9986378076897893, 
     0.4541315517494396, 0.5445062559403497}, {0.9986052928389547, 
     0.4535795468360151, 0.5450257460029394}, {0.9985724037818602, 
     0.45302751833866844`, 0.5455448854431916}, {0.9985391408484496, 
     0.4524754666799491, 0.5460636741685008}, {0.9985055043689108, 
     0.45192339228237877`, 0.5465821120865318}, {0.9984714946736751, 
     0.45137129556845385`, 0.547100199105221}, {0.998437112093418, 
     0.450819176960645, 0.5476179351327735}, {0.9984023569590593, 
     0.45026703688139463`, 0.5481353200776652}, {0.998367229601763, 
     0.44971487575312097`, 0.5486523538486422}, {0.9983317303529381, 
     0.4491626939982199, 0.5491690363547185}, {0.9982958595442383, 
     0.44861049203905984`, 0.5496853675051785}, {0.9982596175075623, 
     0.4480582702979876, 0.5502013472095748}, {0.9982230045750542, 
     0.44750602919732624`, 0.5507169753777279}, {0.9981860210791038, 
     0.4469537691593762, 0.551232251919728}, {0.9981486673523463, 
     0.44640149060641476`, 0.5517471767459315}, {0.9981109437276632, 
     0.4458491939607, 0.552261749766963}, {0.998072850538182, 
     0.4452968796444674, 0.5527759708937142}, {0.9980343881172766, 
     0.4447445480799329, 0.5532898400373435}, {0.997995556798568, 
     0.4441921996892918, 0.5538033571092765}, {0.9979563569159235, 
     0.4436398348947192, 0.554316522021204}, {0.9979167888034578, 
     0.4430874541183744, 0.5548293346850838}, {0.9978768527955332, 
     0.44253505778239494`, 0.555341795013138}, {0.9978365492267589, 
     0.44198264630890366`, 0.5558539029178555}, {0.9977958784319928, 
     0.4414302201200039, 0.5563656583119891}, {0.9977548407463402, 
     0.4408777796377827, 0.5568770611085574}, {0.9977134365051551, 
     0.44032532528431356`, 0.5573881112208415}, {0.99767166604404, 
     0.4397728574816517, 0.5578988085623883}, {0.9976295296988461, 
     0.43922037665183855`, 0.5584091530470073}, {0.9975870278056737, 
     0.4386678832169017, 0.5589191445887723}, {0.9975441607008726, 
     0.43811537759885344`, 0.5594287831020188}, {0.9975009287210418, 
     0.43756286021969554`, 0.5599380685013464}, {0.9974573322030305, 
     0.4370103315014141, 0.5604470007016166}, {0.9974133714839376, 
     0.43645779186598554`, 0.5609555796179524}, {0.9973690469011129, 
     0.4359052417353744, 0.5614638051657389}, {0.9973243587921562, 
     0.43535268153153334`, 0.5619716772606228}, {0.9972793074949186, 
     0.43480011167640603`, 0.5624791958185124}, {0.9972338933475019, 
     0.43424753259192655`, 0.5629863607555754}, {0.9971881166882598, 
     0.4336949447000191, 0.5634931719882408}, {0.9971419778557972, 
     0.4331423484225993, 0.5639996294331977}, {0.9970954771889713, 
     0.43258974418157664`, 0.5645057330073945}, {0.9970486150268911, 
     0.43203713239885255`, 0.5650114826280392}, {0.9970013917089187, 
     0.4314845134963191, 0.5655168782125995}, {0.9969538075746683, 
     0.4309318878958678, 0.5660219196788007}, {0.9969058629640075, 
     0.43037925601938115`, 0.5665266069446269}, {0.9968575582170573, 
     0.42982661828873625`, 0.5670309399283209}, {0.996808893674192, 
     0.42927397512580934`, 0.5675349185483826}, {0.9967598696760401, 
     0.4287213269524717, 0.5680385427235689}, {0.996710486563484, 
     0.4281686741905898, 0.5685418123728947}, {0.9966607446776609, 
     0.4276160172620301, 0.5690447274156313}, {0.9966106443599624, 
     0.42706335658865713`, 0.5695472877713056}, {0.9965601859520354, 
     0.42651069259233476`, 0.5700494933597007}, {0.9965093697957822, 
     0.4259580256949249, 0.5705513441008571}, {0.9964581962333605, 
     0.4254053563182934, 0.5710528399150674}, {0.9964066656071843, 
     0.42485268488430233`, 0.5715539807228823}, {0.9963547782599235, 
     0.42430001181481863`, 0.5720547664451051}, {0.9963025345345048, 
     0.4237473375317111, 0.5725551970027938}, {0.9962499347741117, 
     0.4231946624568508, 0.573055272317261}, {0.9961969793221852, 
     0.4226419870121138, 0.5735549923100713}, {0.9961436685224231, 
     0.4220893116193791, 0.5740543569030444}, {0.9960900027187817, 
     0.42153663670053076`, 0.5745533660182514}, {0.996035982255475, 
     0.4209839626774589, 0.5750520195780165}, {0.9959816074769756, 
     0.4204312899720602, 0.5755503175049157}, {0.9959268787280151, 
     0.4198786190062382, 0.576048259721777}, {0.9958717963535838, 
     0.419325950201904, 0.5765458461516796}, {0.9958163606989318, 
     0.4187732839809784, 0.5770430767179535}, {0.9957605721095686, 
     0.4182206207653885, 0.5775399513441802}, {0.9957044309312639, 
     0.4176679609770732, 0.5780364699541907}, {0.9956479375100481, 
     0.4171153050379823, 0.5785326324720661}, {0.995591092192212, 
     0.41656265337007486`, 0.5790284388221373}, {0.9955338953243076, 
     0.41601000639532404`, 0.5795238889289839}, {0.9954763472531485, 
     0.4154573645357135, 0.5800189827174349}, {0.99541844832581, 
     0.4149047282132431, 0.5805137201125672}, {0.9953601988896292, 
     0.41435209784992266`, 0.5810081010397065}, {0.9953015992922063, 
     0.4137994738677805, 0.5815021254244254}, {0.9952426498814038, 
     0.41324685668885924`, 0.5819957931925445}, {0.9951833510053476, 
     0.41269424673521693`, 0.5824891042701305}, {0.995123703012427, 
     0.4121416444289294, 0.5829820585834979}, {0.9950637062512956, 
     0.4115890501920893, 0.5834746560592063}, {0.9950033610708707, 
     0.4110364644468093, 0.5839668966240614}, {0.9949426678203347, 
     0.4104838876152201, 0.5844587802051147}, {0.9948816268491345, 
     0.40993132011947164`, 0.584950306729663}, {0.9948202385069829, 
     0.4093787623817366, 0.5854414761252462}, {0.994758503143858, 
     0.40882621482420783`, 0.5859322883196506}, {0.9946964211100041, 
     0.40827367786909946`, 0.5864227432409049}, {0.9946339927559323, 
     0.40772115193865155`, 0.5869128408172813}, {0.9945712184324201, 
     0.4071686374551234, 0.5874025809772966}, {0.9945080984905126, 
     0.40661613484080417`, 0.5878919636497082}, {0.9944446332815221, 
     0.4060636445180047, 0.5883809887635177}, {0.9943808231570295, 
     0.40551116690906247`, 0.5888696562479677}, {0.9943166684688834, 
     0.4049587024363406, 0.589357966032543}, {0.994252169569202, 
     0.4044062515222339, 0.5898459180469678}, {0.994187326810372, 
     0.4038538145891623, 0.5903335122212097}, {0.9941221405450501, 
     0.40330139205957577`, 0.5908207484854745}, {0.9940566111261627, 
     0.40274898435595347`, 0.5913076267702092}, {0.9939907389069068, 
     0.4021965919008076, 0.5917941470060991}, {0.9939245242407503, 
     0.40164421511667964`, 0.5922803091240705}, {0.993857967481432, 
     0.40109185442614514`, 0.5927661130552865}, {0.9937910689829624, 
     0.4005395102518126, 0.5932515587311501}, {0.9937238290996243, 
     0.39998718301632336`, 0.5937366460833008}, {0.9936562481859728, 
     0.39943487314235615`, 0.5942213750436168}, {0.9935883265968355, 
     0.39888258105262203`, 0.5947057455442132}, {0.993520064687314, 
     0.3983303071698735, 0.595189757517441}, {0.9934514628127831, 
     0.39777805191689464`, 0.5956734108958883}, {0.9933825213288919, 
     0.3972258157165133, 0.5961567056123789}, {0.9933132405915642, 
     0.3966735989915933, 0.5966396415999714}, {0.9932436209569987, 
     0.39612140216503827`, 0.5971222187919604}, {0.9931736627816695, 
     0.395569225659795, 0.5976044371218752}, {0.9931033664223269, 
     0.3950170698988492, 0.5980862965234778}, {0.9930327322359971, 
     0.39446493530523163`, 0.5985677969307651}, {0.9929617605799834, 
     0.39391282230201563`, 0.5990489382779678}, {0.9928904518118662, 
     0.39336073131231764`, 0.5995297204995487}, {0.9928188062895038, 
     0.39280866275930093`, 0.6000101435302027}, {0.9927468243710323, 
     0.3922566170661749, 0.6004902073048578}, {0.9926745064148669, 
     0.391704594656194, 0.600969911758673}, {0.9926018527797014, 
     0.39115259595266283`, 0.6014492568270388}, {0.9925288638245092, 
     0.39060062137893364`, 0.6019282424455761}, {0.9924555399085441, 
     0.3900486713584079, 0.6024068685501361}, {0.9923818813913399, 
     0.3894967463145393, 0.6028851350768005}, {0.9923078886327116, 
     0.38894484667083157`, 0.6033630419618802}, {0.9922335619927556, 
     0.38839297285084107`, 0.6038405891419144}, {0.9921589018318501, 
     0.3878411252781788, 0.6043177765536717}, {0.992083908510656, 
     0.38728930437650755`, 0.604794604134149}, {0.9920085823901166, 
     0.3867375105695477, 0.6052710718205688}, {0.9919329238314589, 
     0.3861857442810747, 0.6057471795503843}, {0.9918569331961938, 
     0.38563400593492086`, 0.6062229272612727}, {0.9917806108461165, 
     0.38508229595497834`, 0.6066983148911381}, {0.9917039571433068, 
     0.38453061476519534`, 0.6071733423781112}, {0.9916269724501302, 
     0.3839789627895824, 0.6076480096605481}, {0.991549657129238, 
     0.38342734045221044`, 0.6081223166770281}, {0.9914720115435678, 
     0.3828757481772104, 0.6085962633663574}, {0.9913940360563441, 
     0.38232418638877874`, 0.6090698496675652}, {0.991315731031079, 
     0.38177265551117573`, 0.6095430755199038}, {0.9912370968315721, 
     0.3812211559687234, 0.6100159408628488}, {0.9911581338219121, 
     0.3806696881858128, 0.6104884456360994}, {0.991078842366476, 
     0.3801182525869003, 0.6109605897795759}, {0.9909992228299309, 
     0.3795668495965104, 0.6114323732334207}, {0.9909192755772336, 
     0.37901547963923604`, 0.6119037959379974}, {0.9908390009736315, 
     0.37846414313974125`, 0.6123748578338901}, {0.9907583993846634, 
     0.3779128405227599, 0.6128455588619038}, {0.9906774711761593, 
     0.37736157221309613`, 0.6133158989630632}, {0.990596216714242, 
     0.3768103386356305, 0.6137858780786113}, {0.9905146363653267, 
     0.376259140215316, 0.6142554961500112}, {0.9904327304961218, 
     0.3757079773771781, 0.6147247531189438}, {0.9903504994736301, 
     0.37515685054632125`, 0.6151936489273085}, {0.9902679436651484, 
     0.3746057601479284, 0.6156621835172206}, {0.9901850634382686, 
     0.3740547066072547, 0.616130356831014}, {0.9901018591608783, 
     0.37350369034964065`, 0.6165981688112383}, {0.9900183312011615, 
     0.3729527118005031, 0.6170656194006586}, {0.9899344799275982, 
     0.37240177138534236`, 0.6175327085422562}, {0.9898503057089665, 
     0.37185086952973945`, 0.6179994361792266}, {0.989765808914342, 
     0.3713000066593612, 0.6184658022549805}, {0.9896809899130987, 
     0.37074918319995687`, 0.6189318067131417}, {0.98959584907491, 
     0.37019839957736206`, 0.6193974494975483}, {0.9895103867697489, 
     0.3696476562174987, 0.6198627305522506}, {0.9894246033678886, 
     0.3690969535463771, 0.6203276498215116}, {0.9893384992399031, 
     0.36854629199009736`, 0.6207922072498064}, {0.9892520747566682, 
     0.3679956719748478, 0.6212564027818209}, {0.9891653302893614, 
     0.36744509392690927`, 0.6217202363624524}, {0.9890782662094632, 
     0.3668945582726544, 0.6221837079368087}, {0.9889908828887574, 
     0.36634406543855075`, 0.6226468174502069}, {0.9889031806993318, 
     0.3657936158511586, 0.6231095648481734}, {0.9888151600135786, 
     0.36524320993713427`, 0.6235719500764442}, {0.9887268212041954, 
     0.3646928481232329, 0.6240339730809628}, {0.9886381646441857, 
     0.3641425308363055, 0.6244956338078805}, {0.9885491907068594, 
     0.36359225850330296`, 0.6249569322035566}, {0.9884598997658334, 
     0.36304203155127723`, 0.6254178682145564}, {0.9883702921950329, 
     0.36249185040738297`, 0.6258784417876504}, {0.9882803683686908, 
     0.361941715498874, 0.626338652869817}, {0.9881901286613498, 
     0.3613916272531115, 0.626798501408238}, {0.9880995734478618, 
     0.36084158609756145`, 0.6272579873503005}, {0.9880087031033898, 
     0.3602915924597959, 0.6277171106435944}, {0.9879175180034071, 
     0.3597416467674928, 0.6281758712359146}, {0.9878260185236994, 
     0.3591917494484411, 0.6286342690752582}, {0.9877342050403644, 
     0.3586419009305395, 0.6290923041098251}, {0.9876420779298134, 
     0.35809210164179844`, 0.6295499762880155}, {0.9875496375687709, 
     0.3575423520103384, 0.6300072855584327}, {0.9874568843342767, 
     0.3569926524643972, 0.6304642318698793}, {0.9873638186036849, 
     0.35644300343232543`, 0.6309208151713595}, {0.9872704407546664, 
     0.3558934053425914, 0.631377035412075}, {0.987176751165208, 
     0.3553438586237796, 0.6318328925414286}, {0.9870827502136141, 
     0.35479436370459416`, 0.6322883865090203}, {0.9869884382785072, 
     0.3542449210138591, 0.6327435172646483}, {0.9868938157388284, 
     0.3536955309805209, 0.6331982847583078}, {0.9867988829738383, 
     0.35314619403364755`, 0.6336526889401912}, {0.9867036403631178, 
     0.35259691060243126`, 0.6341067297606866}, {0.9866080882865684, 
     0.35204768111619084`, 0.6345604071703779}, {0.9865122271244139, 
     0.35149850600437044`, 0.6350137211200436}, {0.9864160572571997, 
     0.350949385696543, 0.6354666715606573}, {0.986319579065795, 
     0.35040032062240917`, 0.6359192584433859}, {0.9862227929313926, 
     0.34985131121180413`, 0.636371481719589}, {0.98612569923551, 
     0.34930235789469, 0.6368233413408199}, {0.98602829835999, 
     0.3487534611011673, 0.6372748372588232}, {0.9859305906870018, 
     0.348204621261467, 0.6377259694255346}, {0.9858325765990413, 
     0.34765583880595935`, 0.6381767377930823}, {0.9857342564789324, 
     0.34710711416515044`, 0.6386271423137818}, {0.9856356307098273, 
     0.3465584477696862, 0.6390771829401412}, {0.9855366996752075, 
     0.3460098400503519, 0.6395268596248558}, {0.9854374637588845, 
     0.3454612914380747, 0.6399761723208097}, {0.9853379233450009, 
     0.344912802363926, 0.6404251209810748}, {0.9852380788180308, 
     0.3443643732591209, 0.6408737055589101}, {0.9851379305627809, 
     0.34381600455501954`, 0.6413219260077612}, {0.9850374789643909, 
     0.34326769668313156`, 0.6417697822812594}, {0.9849367244083348, 
     0.34271945007511395`, 0.642217274333221}, {0.9848356672804215, 
     0.3421712651627739, 0.6426644021176479}, {0.9847343079667957, 
     0.34162314237807073`, 0.6431111655887248}, {0.9846326468539385, 
     0.34107508215311794`, 0.6435575647008209}, {0.9845306843286685, 
     0.3405270849201812, 0.6440035994084874}, {0.9844284207781425, 
     0.3399791511116847, 0.6444492696664575}, {0.9843258565898565, 
     0.3394312811602103, 0.6448945754296463}, {0.9842229921516462, 
     0.33888347549849696`, 0.6453395166531491}, {0.9841198278516884, 
     0.33833573455944677`, 0.6457840932922421}, {0.9840163640785012, 
     0.3377880587761207, 0.6462283053023803}, {0.9839126012209458, 
     0.3372404485817488, 0.6466721526391972}, {0.9838085396682261, 
     0.3366929044097202, 0.6471156352585058}, {0.9837041798098906, 
     0.33614542669359543`, 0.6475587531162955}, {0.9835995220358331, 
     0.33559801586710025`, 0.6480015061687326}, {0.9834945667362933, 
     0.3350506723641339, 0.6484438943721598}, {0.9833893143018578, 
     0.3345033966187628, 0.6488859176830953}, {0.9832837651234612, 
     0.3339561890652296, 0.6493275760582319}, {0.9831779195923867, 
     0.3334090501379499, 0.6497688694544365}, {0.983071778100267, 
     0.3328619802715178, 0.6502097978287497}, {0.9829653410390858, 
     0.332314979900701, 0.6506503611383846}, {0.9828586088011783, 
     0.33176804946045246`, 0.6510905593407261}, {0.9827515817792315, 
     0.3312211893859006, 0.6515303923933312}, {0.9826442603662865, 
     0.33067440011235955`, 0.6519698602539269}, {0.9825366449557383, 
     0.3301276820753283, 0.6524089628804103}, {0.9824287359413375, 
     0.32958103571049036`, 0.6528477002308475}, {0.9823205337171904, 
     0.3290344614537166, 0.653286072263474}, {0.982212038677761, 
     0.3284879597410693, 0.653724078936692}, {0.982103251217871, 
     0.3279415310087992, 0.6541617202090722}, {0.9819941717327016, 
     0.32739517569335214`, 0.6545989960393499}, {0.9818848006177938, 
     0.3268488942313668, 0.6550359063864274}, {0.9817751382690497, 
     0.3263026870596778, 0.6554724512093718}, {0.9816651850827338, 
     0.3257565546153206, 0.6559086304674133}, {0.9815549414554732, 
     0.3252104973355267, 0.6563444441199472}, {0.9814444077842593, 
     0.32466451565772914`, 0.6567798921265301}, {0.9813335844664486, 
     0.32411861001956654`, 0.6572149744468818}, {0.9812224718997635, 
     0.32357278085888064`, 0.6576496910408829}, {0.9811110704822937, 
     0.32302702861371985`, 0.6580840418685736}, {0.980999380612497, 
     0.3224813537223422, 0.6585180268901549}, {0.9808874026892003, 
     0.3219357566232131, 0.6589516460659871}, {0.9807751371116007, 
     0.32139023775501346`, 0.6593848993565876}, {0.9806625842792667, 
     0.3208447975566351, 0.6598177867226316}, {0.980549744592139, 
     0.3202994364671876, 0.6602503081249514}, {0.9804366184505316, 
     0.3197541549259974, 0.6606824635245346}, {0.9803232062551333, 
     0.31920895337260813`, 0.6611142528825252}, {0.980209508407008, 
     0.31866383224678835`, 0.6615456761602201}, {0.9800955253075965, 
     0.3181187919885262, 0.6619767333190701}, {0.979981257358717, 
     0.31757383303803755`, 0.6624074243206794}, {0.9798667049625669, 
     0.31702895583576307`, 0.6628377491268037}, {0.9797518685217231, 
     0.3164841608223736, 0.66326770769935}, {0.9796367484391438, 
     0.31593944843876853`, 0.6636973000003756}, {0.9795213451181691, 
     0.31539481912608175`, 0.6641265259920875}, {0.9794056589625223, 
     0.31485027332568, 0.6645553856368422}, {0.9792896903763115, 
     0.3143058114791694, 0.6649838788971421}, {0.9791734397640298, 
     0.31376143402839174`, 0.6654120057356384}, {0.9790569075305573, 
     0.3132171414154285, 0.6658397661151287}, {0.9789400940811616, 
     0.3126729340826063, 0.6662671599985557}, {0.9788229998214996, 
     0.3121288124724935, 0.6666941873490063}, {0.9787056251576182, 
     0.3115847770279068, 0.6671208481297115}, {0.9785879704959556, 
     0.31104082819191, 0.6675471423040457}, {0.9784700362433424, 
     0.3104969664078178, 0.667973069835525}, {0.9783518228070031, 
     0.30995319211919614`, 0.6683986306878069}, {0.9782333305945569, 
     0.3094095057698678, 0.6688238248246893}, {0.9781145600140193, 
     0.3088659078039102, 0.6692486522101097}, {0.9779955114738029, 
     0.30832239866565914`, 0.6696731128081438}, {0.9778761853827188, 
     0.3077789787997124, 0.6700972065830066}, {0.9777565821499783, 
     0.3072356486509305, 0.6705209334990481}, {0.9776367021851929, 
     0.3066924086644375, 0.6709442935207559}, {0.9775165458983772, 
     0.30614925928562536`, 0.6713672866127518}, {0.9773961136999485, 
     0.305606200960156, 0.6717899127397926}, {0.9772754060007295, 
     0.30506323413396164`, 0.672212171866768}, {0.9771544232119483, 
     0.30452035925324744`, 0.6726340639587008}, {0.977033165745241, 
     0.3039775767644961, 0.6730555889807448}, {0.9769116340126516, 
     0.30343488711446653`, 0.673476746898185}, {0.9767898284266345, 
     0.3028922907501992, 0.6738975376764353}, {0.976667749400055, 
     0.30234978811901525`, 0.6743179612810397}, {0.976545397346191, 
     0.30180737966852117`, 0.6747380176776696}, {0.976422772678734, 
     0.30126506584661206`, 0.6751577068321224}, {0.9762998758117908, 
     0.3007228471014671, 0.6755770287103238}, {0.9761767071598846, 
     0.3001807238815623, 0.6759959832783228}, {0.9760532671379567, 
     0.2996386966356638, 0.6764145705022928}, {0.9759295561613671, 
     0.2990967658128361, 0.6768327903485309}, {0.9758055746458965, 
     0.29855493186243903`, 0.6772506427834573}, {0.9756813230077477, 
     0.29801319523413616`, 0.6776681277736116}, {0.9755568016635464, 
     0.2974715563778916, 0.678085245285655}, {0.9754320110303434, 
     0.2969300157439752, 0.678501995286368}, {0.9753069515256151, 
     0.29638857378296557`, 0.6789183777426496}, {0.9751816235672658, 
     0.29584723094575044`, 0.6793343926215156}, {0.9750560275736283, 
     0.295305987683529, 0.679750039890099}, {0.9749301639634659, 
     0.29476484444781836`, 0.6801653195156477}, {0.9748040331559739, 
     0.29422380169045037`, 0.6805802314655237}, {0.97467763557078, 
     0.2936828598635764, 0.6809947757072037}, {0.9745509716279475, 
     0.29314201941967166`, 0.681408952208276}, {0.974424041747975, 
     0.2926012808115347, 0.6818227609364401}, {0.9742968463517994, 
     0.29206064449229363`, 0.6822362018595061}, {0.9741693858607958, 
     0.2915201109154026, 0.6826492749453937}, {0.9740416606967806, 
     0.29097968053465006`, 0.6830619801621307}, {0.9739136712820117, 
     0.2904393538041598, 0.6834743174778523}, {0.973785418039191, 
     0.289899131178392, 0.6838862868607994}, {0.9736569013914653, 
     0.28935901311214596`, 0.684297888279319}, {0.9735281217624276, 
     0.28881900006056643`, 0.6847091217018613}, {0.9733990795761198, 
     0.2882790924791393, 0.6851199870969803}, {0.973269775257033, 
     0.2877392908237016, 0.6855304844333313}, {0.9731402092301095, 
     0.28719959555043895`, 0.6859406136796709}, {0.9730103819207445, 
     0.2866600071158899, 0.6863503748048551}, {0.972880293754788, 
     0.2861205259769485, 0.6867597677778394}, {0.9727499451585453, 
     0.2855811525908688, 0.6871687925676763}, {0.9726193365587799, 
     0.28504188741526554`, 0.6875774491435146}, {0.9724884683827141, 
     0.28450273090811523`, 0.6879857374745987}, {0.9723573410580313, 
     0.2839636835277635, 0.6883936575302677}, {0.9722259550128773, 
     0.2834247457329238, 0.6888012092799534}, {0.9720943106758619, 
     0.28288591798268287`, 0.6892083926931795}, {0.9719624084760609, 
     0.2823472007365004, 0.6896152077395611}, {0.9718302488430169, 
     0.2818085944542141, 0.6900216543888027}, {0.9716978322067424, 
     0.28127009959604565`, 0.6904277326106971}, {0.9715651589977204, 
     0.2807317166225958, 0.6908334423751248}, {0.9714322296469063, 
     0.28019344599485413`, 0.6912387836520527}, {0.9712990445857298, 
     0.27965528817419755`, 0.6916437564115323}, {0.9711656042460963, 
     0.279117243622397, 0.6920483606236997}, {0.9710319090603893, 
     0.2785793128016169, 0.6924525962587728}, {0.9708979594614713, 
     0.2780414961744197, 0.6928564632870516}, {0.9707637558826862, 
     0.2775037942037703, 0.6932599616789162}, {0.9706292987578605, 
     0.2769662073530342, 0.6936630914048261}, {0.9704945885213059, 
     0.27642873608598834`, 0.6940658524353178}, {0.9703596256078203, 
     0.2758913808668148, 0.6944682447410054}, {0.9702244104526899, 
     0.2753541421601116, 0.6948702682925781}, {0.9700889434916911, 
     0.27481702043089207`, 0.6952719230607989}, {0.9699532251610922, 
     0.27428001614458875`, 0.6956732090165036}, {0.9698172558976554, 
     0.2737431297670556, 0.6960741261306002}, {0.9696810361386383, 
     0.27320636176457114`, 0.6964746743740674}, {0.9695445663217965, 
     0.2726697126038452, 0.6968748537179515}, {0.9694078468853841, 
     0.27213318275201576`, 0.6972746641333687}, {0.9692708782681574, 
     0.2715967726766582, 0.6976741055914993}, {0.9691336609093752, 
     0.27106048284578393`, 0.6980731780635914}, {0.9689961952488021, 
     0.27052431372784713`, 0.6984718815209549}, {0.968858481726709, 
     0.2699882657917457, 0.6988702159349631}, {0.9687205207838762, 
     0.2694523395068257, 0.6992681812770507}, {0.9685823128615946, 
     0.2689165353428817, 0.6996657775187127}, {0.9684438584016681, 
     0.2683808537701664, 0.7000630046315022}, {0.9683051578464158, 
     0.267845295259387, 0.7004598625870292}, {0.9681662116386732, 
     0.2673098602817133, 0.7008563513569601}, {0.9680270202217951, 
     0.26677454930877875`, 0.701252470913016}, {0.9678875840396564, 
     0.2662393628126855, 0.7016482212269711}, {0.9677479035366559, 
     0.2657043012660053, 0.7020436022706507}, {0.9676079791577166, 
     0.2651693651417854, 0.7024386140159312}, {0.9674678113482892, 
     0.264634554913552, 0.7028332564347378}, {0.9673274005543531, 
     0.26409987105531085`, 0.7032275294990424}, {0.9671867472224187, 
     0.26356531404155387`, 0.7036214331808649}, {0.9670458517995302, 
     0.26303088434726196`, 0.7040149674522685}, {0.966904714733267, 
     0.2624965824479077, 0.7044081322853597}, {0.9667633364717461, 
     0.2619624088194588, 0.7048009276522869}, {0.966621717463624, 
     0.2614283639383845, 0.7051933535252395}, {0.9664798581580994, 
     0.2608944482816546, 0.7055854098764454}, {0.9663377590049149, 
     0.2603606623267452, 0.7059770966781695}, {0.9661954204543595, 
     0.25982700655164687`, 0.7063684139027128}, {0.9660528429572702, 
     0.25929348143485936`, 0.7067593615224111}, {0.9659100269650353, 
     0.2587600874554029, 0.7071499395096329}, {0.9657669729295956, 
     0.2582268250928186, 0.7075401478367774}, {0.9656236813034471, 
     0.2576936948271721, 0.7079299864762754}, {0.9654801525396434, 
     0.2571606971390596, 0.7083194554005842}, {0.9653363870917978, 
     0.25662783250960997`, 0.7087085545821883}, {0.9651923854140856, 
     0.2560951014204873, 0.7090972839935983}, {0.9650481479612463, 
     0.25556250435389877`, 0.7094856436073476}, {0.9649036751885863, 
     0.25503004179259486`, 0.7098736333959914}, {0.9647589675519811, 
     0.25449771421987516`, 0.7102612533321063}, {0.9646140255078772, 
     0.25396552211959034`, 0.7106485033882873}, {0.9644688495132955, 
     0.25343346597614924`, 0.711035383537146}, {0.9643234400258323, 
     0.25290154627452155`, 0.7114218937513109}, {0.9641777975036632, 
     0.2523697635002401, 0.711808034003423}, {0.9640319224055444, 
     0.2518381181394078, 0.7121938042661371}, {0.9638858151908157, 
     0.25130661067869814`, 0.7125792045121174}, {0.963739476319403, 
     0.25077524160536546`, 0.7129642347140377}, {0.9635929062518205, 
     0.25024401140724145`, 0.7133488948445795}, {0.9634461054491733, 
     0.24971292057274402`, 0.7137331848764291}, {0.96329907437316, 
     0.24918196959088293`, 0.7141171047822771}, {0.9631518134860749, 
     0.2486511589512589, 0.7145006545348165}, {0.9630043232508118, 
     0.2481204891440714, 0.7148838341067401}, {0.9628566041308642, 
     0.24758996066012431`, 0.7152666434707401}, {0.9627086565903304, 
     0.24705957399082543`, 0.7156490825995049}, {0.962560481093915, 
     0.24652932962819626`, 0.7160311514657189}, {0.9624120781069306, 
     0.24599922806487098`, 0.7164128500420599}, {0.9622634480953025, 
     0.2454692697941058, 0.7167941783011966}, {0.9621145915255696, 
     0.2449394553097814, 0.7171751362157882}, {0.9619655088648877, 
     0.24440978510640712`, 0.7175557237584812}, {0.961816200581033, 
     0.24388025967912416`, 0.7179359409019089}, {0.9616666671424032, 
     0.24335087952371434`, 0.7183157876186888}, {0.9615169090180214, 
     0.2428216451366013, 0.7186952638814205}, {0.961366926677539, 
     0.24229255701485444`, 0.7190743696626845}, {0.9612167205912373, 
     0.2417636156561972, 0.7194531049350402}, {0.9610662912300317, 
     0.2412348215590086, 0.7198314696710232}, {0.9609156390654738, 
     0.2407061752223299, 0.7202094638431443}, {0.9607647645697538, 
     0.24017767714586577`, 0.720587087423888}, {0.9606136682157045, 
     0.23964932782999684`, 0.7209643403857083}, {0.9604623504768034, 
     0.2391211277757746, 0.7213412227010293}, {0.9603108118271756, 
     0.23859307748493339`, 0.7217177343422426}, {0.9601590527415969, 
     0.23806517745989303`, 0.722093875281704}, {0.960007073695497, 
     0.23753742820376444`, 0.7224696454917329}, {0.9598548751649623, 
     0.23700983022035313`, 0.7228450449446093}, {0.9597024576267382, 
     0.23648238401416474`, 0.7232200736125731}, {0.9595498215582334, 
     0.23595509009041296`, 0.7235947314678209}, {0.9593969674375216, 
     0.23542794895501715`, 0.7239690184825046}, {0.959243895743346, 
     0.23490096111461853`, 0.7243429346287278}, {0.9590906069551207, 
     0.23437412707657448`, 0.7247164798785469}, {0.9589371015529355, 
     0.23384744734897073`, 0.7250896542039651}, {0.9587833800175578, 
     0.23332092244062508`, 0.7254624575769332}, {0.9586294428304357, 
     0.23279455286108885`, 0.7258348899693472}, {0.9584752904737027, 
     0.2322683391206594, 0.7262069513530436}, {0.9583209234301788, 
     0.2317422817303783, 0.7265786416998007}, {0.9581663421833754, 
     0.2312163812020415, 0.7269499609813341}, {0.9580115472174972, 
     0.23069063804820125`, 0.7273209091692958}, {0.957856539017447, 
     0.23016505278217747`, 0.7276914862352696}, {0.9577013180688274, 
     0.22963962591805473`, 0.7280616921507729}, {0.9575458848579449, 
     0.2291143579706944, 0.728431526887251}, {0.9573902398718138, 
     0.22858924945573755`, 0.728800990416076}, {0.957234383598158, 
     0.2280643008896129, 0.7291700827085452}, {0.957078316525416, 
     0.22753951278953843`, 0.7295388037358774}, {0.9569220391427433, 
     0.22701488567353145`, 0.7299071534692119}, {0.9567655519400163, 
     0.22649042006041112`, 0.730275131879605}, {0.9566088554078355, 
     0.22596611646980627`, 0.7306427389380291}, {0.9564519500375291, 
     0.2254419754221606, 0.7310099746153687}, {0.9562948363211569, 
     0.22491799743873794`, 0.731376838882419}, {0.9561375147515129, 
     0.2243941830416295, 0.7317433317098833}, {0.9559799858221296, 
     0.22387053275375876`, 0.7321094530683709}, {0.9558222500272818, 
     0.22334704709888786`, 0.7324752029283937}, {0.9556643078619893, 
     0.22282372660162467`, 0.7328405812603649}, {0.9555061598220217, 
     0.22230057178742654`, 0.7332055880345951}, {0.9553478064039008, 
     0.22177758318260912`, 0.7335702232212916}, {0.9551892481049056, 
     0.221254761314351, 0.7339344867905547}, {0.9550304854230748, 
     0.2207321067106999, 0.7342983787123749}, {0.9548715188572119, 
     0.22020961990058088`, 0.7346618989566309}, {0.9547123489068875, 
     0.21968730141380013`, 0.7350250474930876}, {0.9545529760724445, 
     0.2191651517810521, 0.7353878242913925}, {0.954393400855001, 
     0.21864317153392848`, 0.7357502293210725}, {0.9542336237564544, 
     0.2181213612049209, 0.7361122625515337}, {0.9540736452794857, 
     0.2175997213274295, 0.7364739239520564}, {0.9539134659275631, 
     0.21707825243576995`, 0.7368352134917929}, {0.9537530862049459, 
     0.2165569550651804, 0.7371961311397658}, {0.9535925066166888, 
     0.2160358297518254, 0.7375566768648636}, {0.9534317276686453, 
     0.21551487703280492`, 0.7379168506358404}, {0.9532707498674728, 
     0.2149940974461627, 0.7382766524213101}, {0.9531095737206358, 
     0.21447349153088938`, 0.7386360821897463}, {0.9529481997364101, 
     0.21395305982693305`, 0.7389951399094775}, {0.9527866284238875, 
     0.21343280287520222`, 0.7393538255486857}, {0.9526248602929798, 
     0.21291272121757773`, 0.7397121390754021}, {0.9524628958544223, 
     0.21239281539691593`, 0.7400700804575061}, {0.9523007356197792, 
     0.21187308595705862`, 0.7404276496627206}, {0.952138380101447, 
     0.21135353344283694`, 0.7407848466586098}, {0.9519758298126593, 
     0.21083415840008277`, 0.7411416714125767}, {0.9518130852674909, 
     0.21031496137563208`, 0.7414981238918589}, {0.9516501469808624, 
     0.20979594291733547`, 0.7418542040635272}, {0.9514870154685443, 
     0.20927710357406337`, 0.7422099118944808}, {0.9513236912471619, 
     0.2087584438957164, 0.742565247351446}, {0.9511601748341993, 
     0.20823996443322762`, 0.7429202104009713}, {0.9509964667480045, 
     0.2077216657385791, 0.7432748010094258}, {0.9508325675077937, 
     0.20720354836479826`, 0.7436290191429958}, {0.9506684776336551, 
     0.20668561286597423`, 0.7439828647676807}, {0.9505041976465552, 
     0.20616785979726454`, 0.7443363378492909}, {0.9503397280683423, 
     0.20565028971489846`, 0.7446894383534437}, {0.9501750694217511, 
     0.20513290317619015`, 0.7450421662455611}, {0.9500102222304083, 
     0.20461570073954288`, 0.7453945214908655}, {0.9498451870188367, 
     0.20409868296446063`, 0.7457465040543761}, {0.9496799643124603, 
     0.2035818504115525, 0.7460981139009082}, {0.9495145546376089, 
     0.20306520364254263`, 0.7464493509950665}, {0.9493489585215236, 
     0.20254874322028038`, 0.7468002153012435}, {0.9491831764923608, 
     0.2020324697087454, 0.7471507067836157}, {0.9490172090791987, 
     0.20151638367305813`, 0.7475008254061406}, {0.9488510568120404, 
     0.20100048567948864`, 0.7478505711325517}, {0.9486847202218202, 
     0.20048477629546246`, 0.748199943926358}, {0.9485181998404085, 
     0.19996925608957133`, 0.7485489437508375}, {0.9483514962006172, 
     0.19945392563158298`, 0.7488975705690344}, {0.9481846098362042, 
     0.19893878549244828`, 0.7492458243437564}, {0.948017541281879, 
     0.19842383624430812`, 0.749593705037571}, {0.9478502910733082, 
     0.19790907846050776`, 0.7499412126128004}, {0.9476828597471204, 
     0.1973945127156009, 0.7502883470315198}, {0.9475152478409119, 
     0.19688013958535996`, 0.7506351082555521}, {0.9473474558932522, 
     0.1963659596467876, 0.7509814962464646}, {0.9471794844436888, 
     0.19585197347812258`, 0.7513275109655659}, {0.9470113340327533, 
     0.19533818165885228`, 0.7516731523739015}, {0.9468430052019667, 
     0.19482458476971765`, 0.7520184204322495}, {0.9466744984938457, 
     0.19431118339272824`, 0.7523633151011175}, {0.9465058144519064, 
     0.1937979781111673, 0.7527078363407393}, {0.9463369536206723, 
     0.19328496950960364`, 0.7530519841110688}, {0.9461679165456791, 
     0.19277215817390203`, 0.7533957583717769}, {0.9459987037734797, 
     0.19225954469122986`, 0.7537391590822498}, {0.9458293158516511, 
     0.19174712965006963`, 0.7540821862015816}, {0.9456597533288001, 
     0.19123491364022788`, 0.7544248396885721}, {0.9454900167545687, 
     0.19072289725284805`, 0.7547671195017212}, {0.9453201066796402, 
     0.1902110810804133, 0.7551090255992271}, {0.945150023655746, 
     0.1896994657167665, 0.75545055793898}, {0.9449797682356708, 
     0.18918805175711192`, 0.755791716478559}, {0.9448093409732589, 
     0.18867683979803243`, 0.7561325011752267}, {0.9446387424234208, 
     0.188165830437495, 0.7564729119859257}, {0.9444679731421389, 
     0.18765502427486427`, 0.7568129488672748}, {0.9442970336864743, 
     0.18714442191091096`, 0.7571526117755633}, {0.9441259246145726, 
     0.18663402394782533`, 0.7574919006667471}, {0.9439546464856708, 
     0.18612383098922672`, 0.7578308154964444}, {0.9437831998601034, 
     0.18561384364017108`, 0.7581693562199321}, {0.943611585299309, 
     0.18510406250717107`, 0.7585075227921383}, {0.9434398033658372, 
     0.1845944881981964, 0.758845315167641}, {0.9432678546233545, 
     0.18408512132269272`, 0.7591827333006619}, {0.9430957396366515, 
     0.18357596249159072`, 0.7595197771450614}, {0.9429234589716499, 
     0.18306701231731584`, 0.7598564466543345}, {0.9427510131954083, 
     0.1825582714138021, 0.7601927417816062}, {0.9425784028761305, 
     0.18204974039650496`, 0.7605286624796257}, {0.9424056285831706, 
     0.1815414198824073, 0.7608642087007633}, {0.9422326908870418, 
     0.18103331049003824`, 0.7611993803970033}, {0.9420595903594223, 
     0.18052541283948242`, 0.7615341775199403}, {0.9418863275731627, 
     0.18001772755238865`, 0.7618686000207746}, {0.941712903102293, 
     0.17951025525198738`, 0.7622026478503061}, {0.9415393175220306, 
     0.1790029965631013, 0.7625363209589293}, {0.9413655714087861, 
     0.1784959521121562, 0.7628696192966296}, {0.9411916653401724, 
     0.1779891225271971, 0.7632025428129756}, {0.9410175998950104, 
     0.17748250843789412`, 0.7635350914571164}, {0.9408433756533381, 
     0.17697611047556325`, 0.7638672651777749}, {0.9406689931964171, 
     0.17646992927317487`, 0.7641990639232423}, {0.9404944531067403, 
     0.17596396546536672`, 0.7645304876413738}, {0.94031975596804, 
     0.1754582196884575, 0.7648615362795824}, {0.9401449023652955, 
     0.17495269258046278`, 0.7651922097848326}, {0.9399698928847408, 
     0.1744473847811039, 0.7655225081036368}, {0.9397947281138724, 
     0.17394229693182436`, 0.7658524311820479}, {0.9396194086414582, 
     0.17343742967580392`, 0.7661819789656549}, {0.9394439350575438, 
     0.17293278365796794`, 0.7665111513995764}, {0.9392683079534622, 
     0.17242835952500732`, 0.7668399484284547}, {0.9390925279218413, 
     0.17192415792539023`, 0.767168369996451}, {0.938916595556612, 
     0.17142017950937394`, 0.7674964160472385}, {0.9387405114530172, 
     0.17091642492902015`, 0.7678240865239969}, {0.93856427620762, 
     0.17041289483821423`, 0.7681513813694058}, {0.9383878904183112, 
     0.16990958989267146`, 0.76847830052564}, {0.9382113546843194, 
     0.1694065107499579, 0.7688048439343621}, {0.9380346696062188, 
     0.16890365806950275`, 0.7691310115367163}, {0.9378578357859382, 
     0.16840103251261454`, 0.7694568032733233}, {0.937680853826769, 
     0.16789863474249606`, 0.7697822190842728}, {0.9375037243333758, 
     0.1673964654242578, 0.7701072589091178}, {0.9373264479118035, 
     0.16689452522493523`, 0.7704319226868681}, {0.9371490251694881, 
     0.16639281481350493`, 0.7707562103559834}, {0.9369714567152644, 
     0.16589133486089724`, 0.7710801218543668}, {0.9367937431593756, 
     0.16539008604001698`, 0.7714036571193592}, {0.9366158851134837, 
     0.16488906902575295`, 0.7717268160877306}, {0.9364378831906772, 
     0.1643882844950017, 0.772049598695676}, {0.936259738005482, 
     0.16388773312667676`, 0.7723720048788053}, {0.9360814501738703, 
     0.16338741560173048`, 0.7726940345721399}, {0.9359030203132708, 
     0.16288733260316893`, 0.7730156877101022}, {0.9357244490425768, 
     0.16238748481606424`, 0.7733369642265128}, {0.9355457369821594, 
     0.16188787292758133`, 0.7736578640545779}, {0.9353668847538735, 
     0.16138849762698626`, 0.7739783871268877}, {0.9351878929810714, 
     0.16088935960566633`, 0.7742985333754049}, {0.93500876228861, 
     0.1603904595571499, 0.7746183027314603}, {0.9348294933028635, 
     0.1598917981771208, 0.7749376951257427}, {0.934650086651732, 
     0.15939337616343763`, 0.7752567104882944}, {0.9344705429646527, 
     0.15889519421615234`, 0.7755753487485009}, {0.934290862872611, 
     0.15839725303752708`, 0.7758936098350843}, {0.9341110470081495, 
     0.15789955333205286`, 0.7762114936760967}, {0.9339310960053808, 
     0.1574020958064704, 0.7765290001989101}, {0.9337510104999965, 
     0.1569048811697862, 0.7768461293302109}, {0.93357079112928, 
     0.15640791013329067`, 0.7771628809959897}, {0.933390438532116, 
     0.15591118341058158`, 0.7774792551215346}, {0.933209953349002, 
     0.1554147017175781, 0.7777952516314236}, {0.933029336222061, 
     0.15491846577254706`, 0.7781108704495143}, {0.932848587795051, 
     0.1544224762961148, 0.7784261114989367}, {0.9326677087133776, 
     0.15392673401129142`, 0.7787409747020865}, {0.9324866996241055, 
     0.1534312396434922, 0.7790554599806132}, {0.9323055611759703, 
     0.1529359939205565, 0.7793695672554137}, {0.93212429401939, 
     0.1524409975727662, 0.7796832964466237}, {0.9319428988064774, 
     0.15194625133286943`, 0.7799966474736084}, {0.9317613761910525, 
     0.15145175593610027`, 0.7803096202549524}, {0.9315797268286536, 
     0.15095751212020045`, 0.7806222147084533}, {0.9313979513765512, 
     0.15046352062544058`, 0.7809344307511106}, {0.9312160504937594, 
     0.14996978219464238`, 0.7812462682991169}, {0.9310340248410484, 
     0.1494762975731983, 0.7815577272678499}, {0.9308518750809586, 
     0.14898306750909796`, 0.7818688075718605}, {0.9306696018778118, 
     0.1484900927529456, 0.7821795091248667}, {0.9304872058977252, 
     0.14799737405798488`, 0.7824898318397404}, {0.9303046878086249, 
     0.14750491218012415`, 0.7827997756285006}, {0.9301220482802581, 
     0.1470127078779568, 0.7831093404023016}, {0.929939287984207, 
     0.1465207619127819, 0.7834185260714249}, {0.9297564075939029, 
     0.14602907504863538`, 0.7837273325452677}, {0.9295734077846388, 
     0.1455376480523058, 0.7840357597323331}, {0.9293902892335847, 
     0.14504648169336434`, 0.7843438075402205}, {0.9292070526198001, 
     0.1445555767441854, 0.7846514758756145}, {0.929023698624249, 
     0.1440649339799743, 0.784958764644275}, {0.9288402279298144, 
     0.14357455417878842`, 0.7852656737510259}, {0.928656641221312, 
     0.143084438121567, 0.785572203099745}, {0.928472939185505, 
     0.14259458659215232`, 0.7858783525933533}, {0.9282891225111195, 
     0.14210500037731702`, 0.7861841221338032}, {0.9281051918888588, 
     0.14161568026679078`, 0.7864895116220678}, {0.9279211480114182, 
     0.14112662705328813`, 0.7867945209581306}, {0.927736991573501, 
     0.14063784153252862`, 0.7870991500409725}, {0.9275527232718334, 
     0.14014932450327205`, 0.7874033987685616}, {0.9273683438051804, 
     0.13966107676734002`, 0.7877072670378407}, {0.9271838538743609, 
     0.13917309912964404`, 0.7880107547447168}, {0.9269992541822643, 
     0.13868539239821726`, 0.7883138617840476}, {0.9268145454338663, 
     0.1381979573842355, 0.7886165880496306}, {0.9266297283362448, 
     0.13771079490205387`, 0.7889189334341912}, {0.926444803598597, 
     0.13722390576922874`, 0.789220897829369}, {0.9262597719322556, 
     0.13673729080654934`, 0.7895224811257062}, {0.9260746340507057, 
     0.13625095083806996`, 0.7898236832126355}, {0.9258893906696014, 
     0.1357648866911355, 0.7901245039784662}, {0.9257040425067834, 
     0.13527909919640999`, 0.7904249433103735}, {0.9255185902822967, 
     0.13479358918791493`, 0.7907250010943816}, {0.9253330347184071, 
     0.13430835750305303`, 0.7910246772153542}, {0.92514737653962, 
     0.1338234049826413, 0.7913239715569792}, {0.924961616472697, 
     0.13333873247094044`, 0.7916228840017564}, {0.9247757552466762, 
     0.13285434081569494`, 0.7919214144309817}, {0.9245897935928885, 
     0.13237023086815294`, 0.792219562724736}, {0.9244037322449765, 
     0.13188640348310793`, 0.7925173287618691}, {0.924217571938915, 
     0.13140285951892883`, 0.7928147124199861}, {0.9240313134130269, 
     0.1309195998375934, 0.7931117135754339}, {0.9238449574080059, 
     0.13043662530472167`, 0.7934083321032844}, {0.9236585046669328, 
     0.12995393678961034`, 0.7937045678773227}, {0.9234719559352974, 
     0.12947153516526713`, 0.7940004207700302}, {0.923285311961017, 
     0.12898942130844682`, 0.7942958906525701}, {0.9230985734944572, 
     0.12850759609968523`, 0.7945909773947717}, {0.9229117412884519, 
     0.12802606042333672`, 0.7948856808651154}, {0.9227248160983238, 
     0.12754481516760663`, 0.7951800009307175}, {0.9225377986819056, 
     0.12706386122459282`, 0.7954739374573132}, {0.9223506897995608, 
     0.12658319949031957`, 0.7957674903092413}, {0.9221634902142045, 
     0.12610283086477628`, 0.796060659349428}, {0.9219762006913265, 
     0.1256227562519563, 0.7963534444393698}, {0.9217888219990111, 
     0.12514297655989393`, 0.796645845439117}, {0.9216013549079598, 
     0.12466349270070147`, 0.7969378622072583}, {0.9214138001915153, 
     0.12418430559061457`, 0.7972294946009006}, {0.9212261586256816, 
     0.12370541615002745`, 0.7975207424756546}, {0.9210384309891477, 
     0.12322682530353087`, 0.7978116056856167}, {0.9208506180633125, 
     0.12274853397996323`, 0.7981020840833493}, {0.9206627206323049, 
     0.12227054311244011`, 0.7983921775198648}, {0.9204747394830105, 
     0.12179285363840317`, 0.7986818858446075}, {0.9202866754050935, 
     0.12131546649966027`, 0.7989712089054336}, {0.9200985291910226, 
     0.12083838264242959`, 0.7992601465485933}, {0.9199103016360943, 
     0.12036160301738237`, 0.7995486986187123}, {0.9197219935384584, 
     0.11988512857968697`, 0.7998368649587714}, {0.9195336056991428, 
     0.11940896028905389`, 0.800124645410089}, {0.9193451389220798, 
     0.11893309910978117`, 0.8004120398122987}, {0.9191565940141303, 
     0.11845754601079847`, 0.8006990480033324}, {0.9189679717851122, 
     0.11798230196571513`, 0.8009856698193971}, {0.918779273047824, 
     0.11750736795286741`, 0.8012719050949567}, {0.9185904986180746, 
     0.11703274495536474`, 0.80155775366271}, {0.9184016493147082, 
     0.11655843396113913`, 0.8018432153535693}, {0.9182127259596323, 
     0.11608443596299194`, 0.802128289996641}, {0.918023729377846, 
     0.11561075195864459`, 0.8024129774192017}, {0.917834660397468, 
     0.11513738295079064`, 0.8026972774466772}, {0.9176455198497642, 
     0.11466432994714339`, 0.8029811899026208}, {0.9174563085691776, 
     0.11419159396048706`, 0.8032647146086906}, {0.9172670273933576, 
     0.11371917600873199`, 0.8035478513846257}, {0.9170776771631889, 
     0.1132470771149653, 0.8038306000482236}, {0.9168882587228218, 
     0.1127752983075048, 0.8041129604153171}, {0.916698772919702, 
     0.11230384061995095`, 0.8043949322997511}, {0.9165092206046033, 
     0.11183270509124701`, 0.8046765155133564}, {0.9163196026316559, 
     0.11136189276572837`, 0.8049577098659275}, {0.9161299198583808, 
     0.11089140469318476`, 0.8052385151651958}, {0.9159401731457194, 
     0.11042124192891285`, 0.8055189312168064}, {0.9157503633580675, 
     0.1099514055337762, 0.8057989578242916}, {0.9155604913633081, 
     0.10948189657426402`, 0.8060785947890441}, {0.9153705580328432, 
     0.10901271612254983`, 0.8063578419102936}, {0.915180564241629, 
     0.10854386525655282`, 0.8066366989850765}, {0.9149905108682103, 
     0.10807534505999793`, 0.8069151658082119}, {0.9148003987947527, 
     0.10760715662247937`, 0.8071932421722735}, {0.9146102289070812, 
     0.10713930103952025`, 0.8074709278675608}, {0.9144200020947132, 
     0.10667177941264144`, 0.8077482226820717}, {0.9142297192508945, 
     0.10620459284941985`, 0.8080251264014751}, {0.9140393812726382, 
     0.1057377424635591, 0.8083016388090789}, {0.9138489890607593, 
     0.10527122937495571`, 0.8085777596858043}, {0.9136585435199126, 
     0.10480505470976009`, 0.808853488810153}, {0.9134680455586328, 
     0.10433921960045464`, 0.8091288259581783}, {0.9132774960893697, 
     0.10387372518591523`, 0.8094037709034548}, {0.9130868960285305, 
     0.10340857261148396`, 0.8096783234170464}, {0.9128962462965176, 
     0.10294376302904346`, 0.8099524832674743}, {0.9127055478177694, 
     0.10247929759708303`, 0.8102262502206863}, {0.9125148015208006, 
     0.102015177480777, 0.8104996240400235}, {0.9123240083382447, 
     0.10155140385205827`, 0.8107726044861868}, {0.9121331692068945, 
     0.10108797788969005`, 0.8110451913172042}, {0.9119422850677452, 
     0.10062490077934885`, 0.8113173842883965}, {0.9117513568660384, 
     0.10016217371369648`, 0.8115891831523417}, {0.9115603855513039, 
     0.09969979789246178, 0.8118605876588421}, {0.9113693720774064, 
     0.0992377745225202, 0.8121315975548862}, {0.9111783174025885, 
     0.09877610481797412, 0.8124022125846142}, {0.9109872224895171, 
     0.09831479000023648, 0.8126724324892808}, {0.9107960883053303, 
     0.09785383129811287, 0.812942257007218}, {0.9106049158216836, 
     0.09739322994788731, 0.8132116858737968}, {0.910413706014798, 
     0.09693298719340927, 0.813480718821389}, {0.9102224598655073, 
     0.09647310428617903, 0.8137493555793288}, {0.91003117835931, 
     0.0960135824854382, 0.8140175958738716}, {0.9098398624864152, 
     0.09555442305825995, 0.8142854394281556}, {0.9096485132417965, 
     0.0950956272796378, 0.8145528859621587}, {0.9094571316252418, 
     0.09463719643258332, 0.8148199351926588}, {0.9092657186414046, 
     0.09417913180821325, 0.8150865868331915}, {0.9090742752998586, 
     0.09372143470585328, 0.8153528405940051}, {0.908882802615151, 
     0.09326410643313147, 0.81561869618202}, {0.9086913016068556, 
     0.09280714830607405, 0.8158841533007816}, {0.9084997732996294, 
     0.09235056164921249, 0.8161492116504171}, {0.9083082187232686, 
     0.09189434779567981, 0.8164138709275888}, {0.9081166389127648, 
     0.09143850808731635, 0.8166781308254489}, {0.9079250349083643, 
     0.09098304387477449, 0.8169419910335901}, {0.9077334077556253, 
     0.09052795651762564, 0.8172054512379996}, {0.9075417585054788, 
     0.09007324738446953, 0.8174685111210094}, {0.9073500882142878, 
     0.0896189178530416, 0.8177311703612467}, {0.9071583979439114, 
     0.08916496931032893, 0.8179934286335829}, {0.9069666887617639, 
     0.08871140315267982, 0.8182552856090846}, {0.9067749617408819, 
     0.08825822078592419, 0.8185167409549579}, {0.9065832179599858, 
     0.08780542362548806, 0.8187777943344982}, {0.9063914585035477, 
     0.08735301309651301, 0.8190384454070347}, {0.9061996844618561, 
     0.08690099063397866, 0.8192986938278775}, {0.9060078969310849, 
     0.0864493576828261, 0.8195585392482587}, {0.9058160970133616, 
     0.08599811569808179, 0.8198179813152796}, {0.9056242858168378, 
     0.08554726614498928, 0.8200770196718483}, {0.905432464455759, 
     0.08509681049913319, 0.8203356539566261}, {0.9052406340505385, 
     0.08464675024657449, 0.820593883803964}, {0.9050487957278288, 
     0.08419708688398593, 0.8208517088438434}, {0.9048569506205979, 
     0.0837478219187839, 0.8211091287018144}, {0.9046650998682052, 
     0.08329895686927391, 0.8213661429989317}, {0.9044732446164763, 
     0.08285049326478257, 0.8216227513516934}, {0.9042813860177834, 
     0.08240243264581054, 0.8218789533719729}, {0.9040895252311257, 
     0.0819547765641725, 0.8221347486669536}, {0.9038976634222081, 
     0.08150752658314658, 0.8223901368390615}, {0.9037058017635258, 
     0.08106068427762896, 0.8226451174858973}, {0.9035139414344462, 
     0.08061425123428018, 0.8228996902001657}, {0.9033220836212958, 
     0.0801682290516921, 0.8231538545696037}, {0.903130229517446, 
     0.07972261934053661, 0.8234076101769094}, {0.9029383803234021, 
     0.07927742372373503, 0.8236609565996672}, {0.9027465372468924, 
     0.07883264383661977, 0.8239138934102728}, {0.9025547015029586, 
     0.0783882813271007, 0.8241664201758578}, {0.9023628743140523, 
     0.07794433785584313, 0.8244185364582096}, {0.9021710569101248, 
     0.07750081509643021, 0.8246702418136946}, {0.9019792505287273, 
     0.07705771473555288, 0.8249215357931745}, {0.9017874564151062, 
     0.07661503847317937, 0.8251724179419272}, {0.9015956758223047, 
     0.07617278802274516, 0.8254228877995592}, {0.901403910011263, 
     0.07573096511133932, 0.8256729448999235}, {0.9012121602509224, 
     0.07528957147989226, 0.82592258877103}, {0.9010204278183307, 
     0.07484860888337319, 0.8261718189349575}, {0.9008287139987482, 
     0.07440807909098444, 0.8264206349077639}, {0.9006370200857575, 
     0.07396798388636432, 0.8266690361993931}, {0.9004453473813753, 
     0.07352832506779426, 0.826917022313581}, {0.9002536971961647, 
     0.07308910444840566, 0.8271645927477594}, {0.9000620708493503, 
     0.07265032385639113, 0.827411746992959}, {0.8998704696689365, 
     0.07221198513522621, 0.8276584845337102}, {0.8996788949918263, 
     0.07177409014388789, 0.8279048048479388}, {0.8994873481639439, 
     0.07133664075707849, 0.8281507074068652}, {0.8992958305403587, 
     0.07089963886546101, 0.8283961916748975}, {0.8991043434854115, 
     0.07046308637588793, 0.8286412571095234}, {0.8989128883728436, 
     0.07002698521164229, 0.8288859031612013}, {0.8987214665859289, 
     0.06959133731268337, 0.8291301292732459}, {0.8985300795176081, 
     0.06915614463589217, 0.829373934881716}, {0.8983387285706235, 
     0.06872140915532654, 0.8296173194152966}, {0.8981474151576606, 
     0.0682871328624811, 0.8298602822951794}, {0.89795614070149, 
     0.0678533177665491, 0.830102822934941}, {0.8977649066351101, 
     0.06741996589469085, 0.8303449407404198}, {0.8975737144018974, 
     0.06698707929230972, 0.8305866351095875}, {0.8973825654557563, 
     0.06655466002333607, 0.8308279054324207}, {0.8971914612612732, 
     0.06612271017050592, 0.8310687510907679}, {0.8970004032938727, 
     0.06569123183565821, 0.831309171458215}, {0.8968093930399779, 
     0.06526022714003035, 0.8315491658999475}, {0.8966184319971744, 
     0.06482969822456565, 0.831788733772609}, {0.8964275216743771, 
     0.06439964725021995, 0.8320278744241575}, {0.8962366635919999, 
     0.06397007639828192, 0.8322665871937178}, {0.8960458592821291, 
     0.06354098787069615, 0.8325048714114333}, {0.895855110288702, 
     0.06311238389039275, 0.8327427263983093}, {0.8956644181676872, 
     0.0626842667016286, 0.8329801514660586}, {0.8954737844872689, 
     0.06225663857032853, 0.8332171459169404}, {0.8952832108280376, 
     0.06182950178444202, 0.8334537090435962}, {0.8950926987831823, 
     0.06140285865430178, 0.8336898401288811}, {0.8949022499586871, 
     0.06097671151299284, 0.8339255384456943}, {0.8947118659735321, 
     0.06055106271672885, 0.8341608032568033}, {0.8945215484599015, 
     0.06012591464523808, 0.8343956338146633}, {0.8943312990633918, 
     0.05970126970215653, 0.8346300293612353}, {0.8941411194432278, 
     0.05927713031543082, 0.8348639891277975}, {0.8939510112724814, 
     0.05885349893772728, 0.8350975123347543}, {0.8937609762382973, 
     0.05843037804685881, 0.835330598191439}, {0.8935710160421222, 
     0.058007770146208996`, 0.8355632458959132}, {0.893381132399939, 
     0.05758567776517768, 0.8357954546347617}, {0.8931913270425096, 
     0.05716410345962991, 0.8360272235828794}, {0.8930016017156167, 
     0.056743049812357886`, 0.8362585519032588}, {0.892811958180319, 
     0.056322519433552154`, 0.8364894387467674}, {0.8926223982132059, 
     0.05590251496128525, 0.8367198832519209}, {0.8924329236066619, 
     0.05548303906200735, 0.8369498845446541}, {0.8922435361691361, 
     0.055064094431055595`, 0.8371794417380801}, {0.8920542377254166, 
     0.054645683793166214`, 0.837408553932251}, {0.8918650301169151, 
     0.05422780990301091, 0.8376372202139044}, {0.891675915201955, 
     0.053810475545743544`, 0.837865439656212}, {0.891486894856066, 
     0.0533936835375508, 0.8380932113185152}, {0.8912979709722901, 
     0.05297743672623122, 0.8383205342460586}, {0.8911091454614904, 
     0.052561737991777824`, 0.8385474074697125}, {0.8909204202526699, 
     0.05214659024697626, 0.8387738300056936}, {0.890731797293298, 
     0.05173199643802556, 0.8389998008552728}, {0.8905432785496447, 
     0.051317959545165145`, 0.8392253190044798}, {0.890354866007123, 
     0.050904482583324875`, 0.8394503834237986}, {0.8901665616706402, 
     0.050491568602785794`, 0.8396749930678541}, {0.8899783675649594, 
     0.050079220689868344`, 0.839899146875091}, {0.8897902857350678, 
     0.04966744196762238, 0.8401228437674454}, {0.8896023182465562, 
     0.04925623559655048, 0.8403460826500058}, {0.8894144671860078, 
     0.04884560477534191, 0.8405688624106659}, {0.8892267346613981, 
     0.04843555274163049, 0.8407911819197681}, {0.8890391228025029, 
     0.04802608277276547, 0.841013040029737}, {0.8888516337613203, 
     0.047617198186618186`, 0.8412344355747027}, {0.8886642697125017, 
     0.047208902342387525`, 0.8414553673701138}, {0.8884770328537958, 
     0.04680119864145638, 0.8416758342123398}, {0.8882899254065029, 
     0.04639409052824055, 0.8418958348782629}, {0.8881029496159434, 
     0.04598758149108734, 0.8421153681248561}, {0.887916107751939, 
     0.0455816750631871, 0.8423344326887519}, {0.8877294021093052, 
     0.045176374823507795`, 0.8425530272857975}, {0.8875428350083612, 
     0.04477168439776506, 0.8427711506105962}, {0.8873564087954496, 
     0.04436760745941142, 0.8429888013360384}, {0.8871701258434762, 
     0.04396414773066182, 0.8432059781128142}, {0.8869839885524586, 
     0.04356130898354143, 0.8434226795689173}, {0.8867979993500985, 
     0.043159095040970236`, 0.8436389043091287}, {0.8866121606923635, 
     0.04275750977787474, 0.8438546509144887}, {0.8864264750640897, 
     0.04235655712233872, 0.8440699179417515}, {0.8862409449796012, 
     0.04195624105677748, 0.8442847039228233}, {0.8860555729833488, 
     0.041556565619166756`, 0.8444990073641826}, {0.8858703616505663, 
     0.04115753490428226, 0.8447128267462841}, {0.8856853135879474, 
     0.040759153065004, 0.8449261605229434}, {0.8855004314343441, 
     0.04036142431364328, 0.8451390071207011}, {0.8853157178614852, 
     0.03996435292331717, 0.8453513649381682}, {0.8851311755747172, 
     0.03956794322936697, 0.8455632323453505}, {0.8849468073137694, 
     0.039172199630818354`, 0.8457746076829512}, {0.8847626158535419, 
     0.038777126591891246`, 0.8459854892616507}, {0.8845786040049206, 
     0.03838272864355945, 0.8461958753613615}, {0.8843947746156151, 
     0.037989010385153274`, 0.8464057642304618}, {0.8842111305710263, 
     0.03759597648602529, 0.8466151540850009}, {0.8840276747951415, 
     0.037203631687263504`, 0.8468240431078783}, {0.8838444102514599, 
     0.03681198080346361, 0.8470324294479961}, {0.8836613399439454, 
     0.036421028724562966`, 0.8472403112193824}, {0.8834784669180166, 
     0.03603078041773492, 0.8474476865002821}, {0.8832957942615656, 
     0.03564124092934487, 0.8476545533322205}, {0.8831133251060153, 
     0.035252415386985314`, 0.84786090971903}, {0.8829310626274086, 
     0.03486430900156468, 0.8480667536258445}, {0.8827490100475403, 
     0.03447692706948266, 0.8482720829780581}, {0.882567170635126, 
     0.03409027497488149, 0.8484768956602445}, {0.8823855477070129, 
     0.03370435819197406, 0.8486811895150392}, {0.8822041446294335, 
     0.033319182287453245`, 0.8488849623419804}, {0.8820229648193045, 
     0.03293475292299935, 0.8490882118963053}, {0.881842011745576, 
     0.032551075857873236`, 0.8492909358877032}, {0.8816612889306243, 
     0.03216815695160276, 0.8494931319790217}, {0.881480799951704, 
     0.031786002166783164`, 0.8496947977849206}, {0.8813005484424479, 
     0.03140461757196821, 0.8498959308704797}, {0.8811205380944275, 
     0.031024009344681497`, 0.8500965287497461}, {0.8809407726587735, 
     0.030644183774544642`, 0.8502965888842289}, {0.8807612559478561, 
     0.030265147266523042`, 0.8504961086813336}, {0.8805819918370358, 
     0.029886906344304912`, 0.8506950854927313}, {0.8804029842664782, 
     0.029509467653812998`, 0.8508935166126653}, {0.8802242372430457, 
     0.029132837966860663`, 0.8510913992761855}, {0.8800457548422624, 
     0.028757024184949544`, 0.8512887306573129}, {0.8798675412103631, 
     0.028382033343239542`, 0.8514855078671236}, {0.8796896005664219, 
     0.028007872614665717`, 0.8516817279517566}, {0.8795119372045744, 
     0.027634549314242172`, 0.8518773878903322}, {0.8793345554963314, 
     0.02726207090354836, 0.8520724845927836}, {0.8791574598929919, 
     0.026890444995400175`, 0.8522670148975918}, {0.8789806549281602, 
     0.026519679358737627`, 0.852460975569423}, {0.8788041452203751, 
     0.026149781923717752`, 0.8526543632966576}, {0.8786279354758509, 
     0.025780760787040998`, 0.85284717468881}, {0.8784520304913469, 
     0.025412624217516534`, 0.8530394062738306}, {0.8782764351571627, 
     0.02504538066188241, 0.8532310544952801}, {0.878101154460273, 
     0.02467903875089702, 0.8534221157093761}, {0.8779261934876073, 
     0.024313607305712078`, 0.8536125861818955}, {0.8777515574294847, 
     0.023949095344552866`, 0.8538024620849318}, {0.8775772515832109, 
     0.023585512089716827`, 0.853991739493494}, {0.8774032813568502, 
     0.023222866974913204`, 0.8541804143819369}, {0.8772296522731825, 
     0.022861169652966765`, 0.8543684826202158}, {0.877056369973853, 
     0.02250043000390162, 0.8545559399699517}, {0.8768834402237354, 
     0.022140658143441117`, 0.8547427820802946}, {0.876710868915513, 
     0.02178186443193888, 0.8549290044835741}, {0.8765386620744972, 
     0.021424059483776965`, 0.8551146025907208}, {0.8763668258637, 
     0.02106725417725562, 0.855299571686444}, {0.8761953665891725, 
     0.02071145966502072, 0.8554839069241514}, {0.8760242907056339, 
     0.020356687385046274`, 0.8556676033205879}, {0.8758536048224054, 
     0.020002949072226186`, 0.8558506557501793}, {0.8756833157096748, 
     0.01965025677061785, 0.856033058939057}, {0.8755134303051121, 
     0.019298622846370468`, 0.8562148074587412}, {0.8753439557208644, 
     0.018948060001406936`, 0.856395895719458}, {0.8751748992509545, 
     0.018598581287891235`, 0.8565763179630637}, {0.8750062683791174, 
     0.0182502001235715, 0.8567560682555457}, {0.8748380707871041, 
     0.017902930308034304`, 0.85693514047907}, {0.8746703143634917, 
     0.01755678603995803, 0.8571135283235342}, {0.8745030072130376, 
     0.01721178193544222, 0.8572912252775955}, {0.8743361576666208, 
     0.016867933047495447`, 0.8574682246191259}, {0.8741697742918206, 
     0.016525254886772787`, 0.8576445194050475}, {0.874003865904182, 
     0.016183763443681876`, 0.8578201024605006}, {0.8738384415792264, 
     0.015843475211941915`, 0.8579949663672846}, {0.8736735106652733, 
     0.015504407213763971`, 0.8581691034515091}, {0.8735090827971379, 
     0.015166577026746236`, 0.8583425057703917}, {0.8733451679107905, 
     0.014830002812672098`, 0.8585151650981182}, {0.8731817762590574, 
     0.014494703348372683`, 0.8586870729106851}, {0.8730189184284586, 
     0.014160698058827024`, 0.8588582203696318}, {0.8728566053572985, 
     0.013828007052746814`, 0.8590285983045516}, {0.8726948483551134, 
     0.01349665116084108, 0.8591981971942728}, {0.8725336591236258, 
     0.013166651977057037`, 0.8593670071465692}, {0.8723730497793409, 
     0.012838031903078615`, 0.8595350178762627}, {0.8722130328779611, 
     0.012510814196415313`, 0.8597022186815455}, {0.8720536214408032, 
     0.012185023022462382`, 0.8598685984183413}, {0.8718948289834331, 
     0.011860683510938686`, 0.8600341454724945}, {0.8717366695467578, 
     0.011537821817210234`, 0.8601988477295477}, {0.8715791577308476, 
     0.011216465189004364`, 0.860362692541843}, {0.8714223087318035, 
     0.01089664203916865, 0.860525666692635}, {0.8712661383820128, 
     0.010578382025141584`, 0.8606877563568714}, {0.8711106631942175, 
     0.010261716135980545`, 0.860848947058237}, {0.8709559004098408, 
     0.009946676787839238, 0.8610092236220016}, {0.870801868052126, 
     0.009633297928982583, 0.8611685701231435}, {0.8706485849846972, 
     0.009321615155564298, 0.8613269698291329}, {0.8704960709762679, 
     0.009011665839602013, 0.8614844051366661}, {0.8703443467723374, 
     0.008703489270821875, 0.8616408575015151}, {0.8701934341748507, 
     0.008397126814321315, 0.8617963073605295}, {0.870043356130988, 
     0.008092622086347194, 0.8619507340446406}, {0.8698941368324359, 
     0.007790021150912939, 0.8621041156815226}, {0.8697458018267622, 
     0.007489372740450283, 0.8622564290863116}, {0.8695983781428259, 
     0.0071907285043596135`, 0.8624076496384662}, {0.8694518944325305, 
     0.00689414329004588, 0.8625577511424846}, {0.8693063811317154, 
     0.006599675462009809, 0.8627067056697061}, {0.8691618706435771, 
     0.006307387265738311, 0.8628544833778392}, {0.8690183975487538, 
     0.00601734524464255, 0.8630010523041111}, {0.8688759988471857, 
     0.005729620720215039, 0.863146378126971}, {0.8687347142380748, 
     0.005444290348004528, 0.8632904238900703}, {0.8685945864458662, 
     0.005161436765213282, 0.8634331496806534}, {0.8684556616022533, 
     0.004881149349826549, 0.8635745122524271}, {0.868317989696969, 
     0.004603525116739077, 0.8637144645802303}, {0.8681816251138063, 
     0.004328669783644371, 0.863852955330162}, {0.8680466272733193, 
     0.004056699049478559, 0.8639899282238408}, {0.8679130614105532, 
     0.0037877401419432926`, 0.86412532126861}, {0.8677809995257941, 
     0.0035219337099028796`, 0.8642590658158911}, {0.8676505215600527, 
     0.0032594361638284696`, 0.8643910853962243}, {0.8675217168669641, 
     0.0030004226073186407`, 0.8645212942596455}, {0.8673946860823909, 
     0.0027450905618481587`, 0.8646495955205428}, {0.8672695435381301, 
     0.002493664776965896, 0.8647758787611641}, {0.8671464204367443, 
     0.0022464035591922096`, 0.8649000168775525}, {0.8670254691188409, 
     0.0020036072811668868`, 0.8650218618376745}, {0.8669068689461715, 
     0.0017656301162112748`, 0.8651412388299603}, {0.86679083466135, 
     0.0015328967175634043`, 0.8652579379437866}, {0.8666776287102181, 
     0.0013059268107403752`, 0.8653717018994778}, {0.8665675802491154, 
     0.0010853731377590099`, 0.8654822071113565}, {0.866461116210531, 
     0.0008720834902763397, 0.8655890327202551}, {0.866358816117157, 
     0.0006672101935256958, 0.8656916059236313}, {0.8662615196974638, 
     0.00047242511036060065`, 0.8657890945871032}, {0.8661705752345571, 
     0.0002904159420505451, 0.865880159292507}, {0.86608860191034, 
     0.00012641009046551434`, 0.8659621918198749}, {0.8660254037844387, 
     1.2246467991473532`*^-16, 0.8660254037844388}}}],
  AspectRatio->0.2]], "Output",
 CellChangeTimes->{{3.4902363707980003`*^9, 3.4902363786886253`*^9}, {
   3.4902364095792503`*^9, 3.4902364522667503`*^9}, 3.4902364910011253`*^9, 
   3.4902367856886253`*^9, 3.4902368615323753`*^9, 3.4902368972667503`*^9, 
   3.4902369530011253`*^9, {3.4902370908448753`*^9, 3.4902371206886253`*^9}, 
   3.4902371582355003`*^9, 3.4902372193605003`*^9, 3.4902372571730003`*^9, {
   3.4902373903917503`*^9, 3.4902374407198753`*^9}, {3.4902374817198753`*^9, 
   3.4902375307823753`*^9}, 3.4902375694855003`*^9, {3.4902376142823753`*^9, 
   3.4902376512355003`*^9}, 3.4902377219386253`*^9, 3.4902378006417503`*^9, 
   3.4902378653761253`*^9, 3.4902381911261253`*^9, 3.4902382729698753`*^9, {
   3.4902384087198753`*^9, 3.4902384413761253`*^9}, {3.4902387647823753`*^9, 
   3.4902387806886253`*^9}, {3.4902388128448753`*^9, 
   3.4902388251105003`*^9}, {3.4902390388292503`*^9, 3.4902390561573753`*^9}, 
   3.4902391179386253`*^9, {3.4902392833292503`*^9, 3.4902393062823753`*^9}, {
   3.4902397821417503`*^9, 3.4902398094542503`*^9}, {3.4902399467355003`*^9, 
   3.4902399884542503`*^9}, {3.4902400331730003`*^9, 
   3.4902400390167503`*^9}, {3.4902400727823753`*^9, 3.4902400950948753`*^9}, 
   3.4902405983917503`*^9, {3.4902406452355003`*^9, 3.4902406693761253`*^9}, 
   3.4902779321261253`*^9, 3.4902779758917503`*^9, 3.4902780721261253`*^9, {
   3.4902781145323753`*^9, 3.4902781270011253`*^9}, {3.4902789548136253`*^9, 
   3.4902789768292503`*^9}, 3.4902791782823753`*^9, 3.4903032492198753`*^9, 
   3.4903032834542503`*^9, 3.4903033194230003`*^9, {3.4903033505480003`*^9, 
   3.4903033632980003`*^9}, {3.4903034645636253`*^9, 3.4903035172511253`*^9}, 
   3.4903043780011253`*^9, 3.4903045769386253`*^9, {3.4903046113448753`*^9, 
   3.4903046359230003`*^9}, 3.4903048670948753`*^9, 3.4903048981886253`*^9, {
   3.4903049366573753`*^9, 3.4903049662511253`*^9}, 3.4903050202355003`*^9, 
   3.4903056490948753`*^9, 3.4903056984542503`*^9, 3.4903057340636253`*^9, 
   3.4903058041886253`*^9, 3.4903068360167503`*^9, {3.4903068825480003`*^9, 
   3.4903069092980003`*^9}, 3.490319452692375*^9, {3.490319555567375*^9, 
   3.490319578942375*^9}, {3.490319633129875*^9, 3.49031967580175*^9}, {
   3.490319754458*^9, 3.49031980030175*^9}, {3.490319870208*^9, 
   3.490319887067375*^9}, {3.490319967129875*^9, 3.490320031629875*^9}, 
   3.490320071942375*^9, 3.490320103379875*^9, 3.49032046505175*^9, {
   3.490320625473625*^9, 3.490320648129875*^9}, 3.4903207570205*^9, 
   3.490320794348625*^9, 3.490321783379875*^9, 3.4903223088955*^9, 
   3.490322570536125*^9, 3.490322820098625*^9, 3.490323084973625*^9, 
   3.490323139567375*^9, 3.4903258181455*^9, 3.4904778635559998`*^9, 
   3.4904786142591248`*^9, {3.4904852353528748`*^9, 3.4904852692747498`*^9}, 
   3.4904859631966248`*^9, 3.4904863323841248`*^9, 3.4904863921341248`*^9, 
   3.4905708941966248`*^9, 3.4905711668216248`*^9, 3.4905712885716248`*^9, 
   3.4905715378372498`*^9, 3.4905721378841248`*^9, 3.57652249256075*^9, 
   3.73506561117552*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Red(\"\>", "\[InvisibleSpace]", "400", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"     Red(\"\>", "\[InvisibleSpace]", "3795", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   "0.8660254037844387`"}],
  SequenceForm[
  "Red(", 400, ") = ", 0, "     Red(", 3795, ") = ", 0.8660254037844387],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4903056496573753`*^9, 3.4903056990011253`*^9, 3.4903057346261253`*^9, 
   3.4903058047511253`*^9, 3.4903068363605003`*^9, {3.4903068829073753`*^9, 
   3.4903069098292503`*^9}, 3.49031945305175*^9, {3.490319555942375*^9, 
   3.490319579333*^9}, {3.49031963367675*^9, 3.490319676348625*^9}, {
   3.490319755004875*^9, 3.490319800833*^9}, {3.49031987073925*^9, 
   3.490319887598625*^9}, {3.49031996767675*^9, 3.490320032161125*^9}, 
   3.490320072473625*^9, 3.490320103942375*^9, 3.49032046561425*^9, {
   3.4903206260205*^9, 3.490320648661125*^9}, 3.49032075755175*^9, 
   3.4903207948955*^9, 3.490321783911125*^9, 3.490322309458*^9, 
   3.490322571067375*^9, 3.490322820629875*^9, 3.490323085504875*^9, 
   3.49032314011425*^9, 3.490325818692375*^9, 3.4904778641184998`*^9, 
   3.4904786148059998`*^9, {3.4904852359153748`*^9, 3.4904852698372498`*^9}, 
   3.4904859637278748`*^9, 3.4904863328997498`*^9, 3.4904863926497498`*^9, 
   3.4905708947122498`*^9, 3.4905711673997498`*^9, 3.4905712891341248`*^9, 
   3.4905715383997498`*^9, 3.4905721384309998`*^9, 3.57652249324825*^9, 
   3.73506561117552*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Grn(\"\>", "\[InvisibleSpace]", "400", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   "0.49999999999999994`", "\[InvisibleSpace]", "\<\"     Grn(\"\>", 
   "\[InvisibleSpace]", "3795", "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", "1.2246467991473532`*^-16"}],
  SequenceForm[
  "Grn(", 400, ") = ", 0.49999999999999994`, "     Grn(", 3795, ") = ", 
   1.2246467991473532`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4903056496573753`*^9, 3.4903056990011253`*^9, 3.4903057346261253`*^9, 
   3.4903058047511253`*^9, 3.4903068363605003`*^9, {3.4903068829073753`*^9, 
   3.4903069098292503`*^9}, 3.49031945305175*^9, {3.490319555942375*^9, 
   3.490319579333*^9}, {3.49031963367675*^9, 3.490319676348625*^9}, {
   3.490319755004875*^9, 3.490319800833*^9}, {3.49031987073925*^9, 
   3.490319887598625*^9}, {3.49031996767675*^9, 3.490320032161125*^9}, 
   3.490320072473625*^9, 3.490320103942375*^9, 3.49032046561425*^9, {
   3.4903206260205*^9, 3.490320648661125*^9}, 3.49032075755175*^9, 
   3.4903207948955*^9, 3.490321783911125*^9, 3.490322309458*^9, 
   3.490322571067375*^9, 3.490322820629875*^9, 3.490323085504875*^9, 
   3.49032314011425*^9, 3.490325818692375*^9, 3.4904778641184998`*^9, 
   3.4904786148059998`*^9, {3.4904852359153748`*^9, 3.4904852698372498`*^9}, 
   3.4904859637278748`*^9, 3.4904863328997498`*^9, 3.4904863926497498`*^9, 
   3.4905708947122498`*^9, 3.4905711673997498`*^9, 3.4905712891341248`*^9, 
   3.4905715383997498`*^9, 3.4905721384309998`*^9, 3.57652249324825*^9, 
   3.73506561117552*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Blu(\"\>", "\[InvisibleSpace]", "400", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\"     Blu(\"\>", "\[InvisibleSpace]", "3795", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   "0.8660254037844388`"}],
  SequenceForm[
  "Blu(", 400, ") = ", 1., "     Blu(", 3795, ") = ", 0.8660254037844388],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4903056496573753`*^9, 3.4903056990011253`*^9, 3.4903057346261253`*^9, 
   3.4903058047511253`*^9, 3.4903068363605003`*^9, {3.4903068829073753`*^9, 
   3.4903069098292503`*^9}, 3.49031945305175*^9, {3.490319555942375*^9, 
   3.490319579333*^9}, {3.49031963367675*^9, 3.490319676348625*^9}, {
   3.490319755004875*^9, 3.490319800833*^9}, {3.49031987073925*^9, 
   3.490319887598625*^9}, {3.49031996767675*^9, 3.490320032161125*^9}, 
   3.490320072473625*^9, 3.490320103942375*^9, 3.49032046561425*^9, {
   3.4903206260205*^9, 3.490320648661125*^9}, 3.49032075755175*^9, 
   3.4903207948955*^9, 3.490321783911125*^9, 3.490322309458*^9, 
   3.490322571067375*^9, 3.490322820629875*^9, 3.490323085504875*^9, 
   3.49032314011425*^9, 3.490325818692375*^9, 3.4904778641184998`*^9, 
   3.4904786148059998`*^9, {3.4904852359153748`*^9, 3.4904852698372498`*^9}, 
   3.4904859637278748`*^9, 3.4904863328997498`*^9, 3.4904863926497498`*^9, 
   3.4905708947122498`*^9, 3.4905711673997498`*^9, 3.4905712891341248`*^9, 
   3.4905715383997498`*^9, 3.4905721384309998`*^9, 3.57652249324825*^9, 
   3.73506561117552*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "domain", " ", "for", " ", "high", " ", "end", " ", "fade", 
    " ", "to", " ", "white"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lo3", "=", "3795"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hi3", "=", "4095"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"width3", "=", 
     RowBox[{"hi3", "-", "lo3"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Define", " ", "high", " ", "end", " ", "domain", " ", "functions", " ", 
      "for", " ", "red"}], ",", " ", "green", ",", " ", "blue"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred3", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "lo3"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "0.866025"}], ")"}], "/", "width3"}]}], "+", 
      "0.866025"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fngrn3", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "lo3"}], ")"}], "*", 
      RowBox[{"1", "/", "width3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnblu3", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "lo3"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "0.866025"}], ")"}], "/", "width3"}]}], "+", 
      "0.866025"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "high", " ", "end", " ", "domain", " ", 
     "saturation", " ", "function", " ", "for", " ", "reference", " ", 
     "use"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnsat3", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fnred3", "[", "x", "]"}], "+", 
        RowBox[{"fngrn3", "[", "x", "]"}], "+", 
        RowBox[{"fnblu3", "[", "x", "]"}]}], ")"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "high", " ", "end", " ", "domain", " ", "red"}], 
     ",", " ", 
     RowBox[{
     "green", " ", "and", " ", "blue", " ", "functions", " ", "along", " ", 
      "with", " ", "saturation"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fnred3", "[", "x", "]"}], ",", 
       RowBox[{"fngrn3", "[", "x", "]"}], ",", 
       RowBox[{"fnblu3", "[", "x", "]"}], ",", 
       RowBox[{"fnsat3", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "lo3", ",", "hi3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{".6", ",", ".6", ",", ".6"}], "]"}], ",", "Thin"}], 
         "}"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "create", " ", "a", " ", "table", " ", "of", " ", "\"\<width3\>\"", " ", 
      "number", " ", "of", " ", "RGB", " ", "value", " ", "triplets"}], ",", 
     " ", 
     RowBox[{
     "each", " ", "value", " ", "ranging", " ", "from", " ", "0", " ", "to", 
      " ", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Colors3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"fnred3", "[", "i", "]"}], ",", 
         RowBox[{"fngrn3", "[", "i", "]"}], ",", 
         RowBox[{"fnblu3", "[", "i", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "lo3", ",", "hi3"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "the", " ", "color", " ", "table", " ", "ceated", " ", 
     "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Raster", "[", 
      RowBox[{"{", "Colors3", "}"}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", ".2"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.490320874411125*^9, 3.490320984192375*^9}, {
  3.490321055317375*^9, 3.4903212032705*^9}, {3.490321269317375*^9, 
  3.49032127205175*^9}, {3.490321304161125*^9, 3.49032130555175*^9}, {
  3.4903213356455*^9, 3.49032143742675*^9}, {3.4903215456455*^9, 
  3.49032158286425*^9}, {3.490321700848625*^9, 3.490321700879875*^9}, {
  3.490321745458*^9, 3.490321749629875*^9}, {3.49032228680175*^9, 
  3.490322294379875*^9}, {3.49032257742675*^9, 3.490322577458*^9}, {
  3.49032269830175*^9, 3.490322730411125*^9}, {3.49032276780175*^9, 
  3.490322781817375*^9}, {3.4903230193955*^9, 3.490323025567375*^9}, {
  3.4904859695559998`*^9, 3.4904859695872498`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJwV0Xs0lHkYB/A5Li25RCq7i7BbU53SHNO0tKrnWc2hy7a6nGMpmrA56ILT
RnLL2hptS4ooZdNWjOp9fzSppGZHSUinzEZ2iXVrysz7vm5Zk9u++8dzvufz
3/d8H9fQ6G17jAQCwWb+/s+Y6OcCQTGFPjIz2yN3dKCirziKeEt2D69+yduS
TfDcxds1pCNCeFcHin3CmAe8J0NvqzW8OyNTOw+XUKgM3x2ztFIH3/3grhpU
UOh84N6L9iodLAs8m9hzg0JDUkQWVOtA6x08WltO4Y2COgvTRh3MbbI6flJF
4YKu6H5Zjw6+jyhKjG+gsOJZTM5ygw6y2CU5i1ooLEv6WHnKWg9JolfS5m4K
1Z57a9QL9ZCSsDvoOkuh9tzK83u89OCRYmWdPE7hlybarX9v00NfbHmXnRmN
DStdM7oi9VBywMNBY0ej3KIiIyhVDy7CDjbThcZAvWh/SZ4eqLfhi2OX0egd
a+IYflMPory36Z960pj3IGT93Wo9RAjkCQ+lNE7PLg5obdVDxUHz5hNbaEyx
kq7Yz+rh3uWbDduDabS1qx9sMmWgXOXT3RVJo01ni1u9IwOq3key/EM0Cv3W
SiRiBtKeyOI3/kSjX8Ov86M3MBBIOkYWZNGY/V7yp5OMAe32FMvJAhp77Wr2
XoxjIEo7x+d8CY1XTdrTqEwGjH7O7AtS0ph0fnOo+AoDW9qEzvPVNIavKhbK
7zOg9PpdNaORxqjkgAq/lwxYnJxzVPmaxlZ5TvX1PgY+O1vSFtxL447CivLm
CQZWKxwLRQM0Dvu77/txNgtz426NTU3QWOSQO7NnCQs9Yog7Y07wXnGqsBdZ
qB2jAjfPJfiuucYy0J8FWcKa16ZfEFxmM9hSuJ8FK2Nyv8+NYAYbt9c/nYWy
RHv1iVUE/XKOJV8+x4I5KZIt9SG4eF3iwQeEhXidxZ6RrQQd8htWbHrCwoXu
fJOqXQRdRgWtpe0svOo2nVkaRXCtIdsnaYgFI02U+844gk8flYq7PuHgbeLA
0Mx0gqH5pUbznDnoXB7weXcWQXsb40KVhIOsi/+03blAsCNnnYPHtxyIDbI/
/BQEbTos7b3DONDtqjazuU1wZ6PojfowBztS1+mfqwlWPlkln5XNwRtFyUpl
I0G3sMLxpmsc+FcbXQ5qJTjr6QlGWMXBsdyUYuM+gsZfBT/epOGgLqbdVjNA
0HrDL2G9Wg5860/XzxgkWIejTdJ3HNS6+qZ58U7zDMVrvGs05QNXeY8s+top
/D0H1RL5i/ghgm0z+lu0/RzcH3PPdBohqKjZsFHHcHDzqNws8l+C3mjuPjTM
wdK/VqsLeU94HLq0bYSD6+5D8RreFaIuKyVvRXeQ1muM39u5sv/gBw6uScW1
1ga+/1TE1Q+jHPxm9ib99keC7VV19gYDB04hZ7ze885TSo4HfuTgYqXvsNM4
/78bRSOVvAuiboXKeT8qONx0ZJyD/Eb5NzsmCJYmLD45McHBvIVrDFm8w2Jz
DUGTHOQlD5U95j0/UhDxkHfu8mAXt0mCpwNapSlTHNjJZ7eG8N64Rars4H2m
8+mpPN4m68tcYZoDW89k32e8H4Jj9iXe2dni6WnecR4ZU9O8/wMpToqa
     "]]}, 
   {RGBColor[0, 1, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJwVz3tUjHkYB/BumKRZ5ToYRLIuSW2UE54HncIKlctGNWmxmmPJirQRpZpt
M9UmoYstUUPm/amZnKWMqB2rjTRNijSjaZoaXd4prS6kff3xnOd8zvec52IT
fNTngImRkZEXU1976NHnRkb5YhRZhr0p1+9cK6PyZjkwZofNCFVznGFCT4Rr
IGO7R1eyJBx3EB22Cy1jXKxtKM7m7AB1yFn1qQIx1oYMPEzl7Iet+x1lvSIx
On8n2CDkhMFSv0uRrYVibJu2Lf53Tiy0rw/4KC8SYwJLsjCBkwZTai3jE2Vi
zPDLJYbeG7D7UE5keBWzbzTa33M2gaSeRRcXvhKjlXdPR0WiFE47KN3rNWKM
ebEKrvTfh6iIIP/bPcy9UiuVsfEjcImyZJ/5JEa5ZkN1zeon0HasqGUSi0IN
P3umX1clFBxxmamYRKHFwjXfiH9+CnPtVD3CuRTaDxVOnLmgCsS6g98eW0ph
wGjQPV+qGhzSdeenu1Koj3V+IV9cA4eMBBEP3Sl0SekcutXzEkqOm9cnbKfQ
aFCtql+ugL9y71T5BlBY+L60ip1UB0UyD01LCIVzuAW0VqsEmfYJ7/IJCjNC
Sg7m2L6C6L954ZtjKPyIhdpDZxvAj6j6bZMoPOFUKZ1a0QjtvlETRjIoVFKV
ibU2b4DfPtnjasHXf5SZi35tApNYYZu/hELrdeO+HCx9C9ub7ObMLqdw/nWb
n4qmqUDidl02tprCXVzevBZ/NVgkTj4naaBwVtdOiwavd8C5VNAUoKVwhG1g
VQ6/g9WiWdkOBgppWSaZn9UCU04WD375TKGPc+lr8+810OoEJ1PNCV7YFJwj
+6gB+aDYz2sKwYbOGRN16a3Ai1jTMGYewYu+nqZp7lqwNCUP2uwJBm2M+1Oq
08LdyGnlCasImjVvbsyLawNzksNb4kFwuktsGsdJB+GdFgf6vQmunV0zZFyn
g0zNZbPSQILKKqEmNLodlJox42/xCUaaBYb52HaAiYLvuPckweHmkusmlR2g
izT0jT9PUH86eseqY3pQL/thhiaJsSiQaKzfQ1LWu6Z7mQT9MojQ+sl7cBri
PdomIpi75DeW1ZFO6Ax8zJooZeZt+mVpDLsL9pzd0PW8nGCF/cu6iLIuaBYV
rJBUE0y5BrbawG7Y9dgk17+R4Dqy0or7pRvi0qLyTdsI7o/LjX57uwf+CX1r
pTAQTOjgZrK30OD57I9nY3uZPDsuSLWVBrmNZ7Qb47U+3QsobxoqFUWGG4w/
lJbd9dpNw2NnQU14H0F+8l75hWAaHgw6Crn9BLesvNo7PoKGO+cErJABguzY
yRvH5dOw5PXq8mzGetfTlg0iGm479oUrGFd0tyryC2kQafzb3QYJntotCfAo
ouGmu5OcPUTQsNjneFwZDddYzeelwwRra5OvmdbRwN2X6qZnXBg/8GNdPQ1Z
9z0/cD8RjHfjLcprpCGDXxwsYOx2c5l0vYqGy9WCdXs+Eyw+9fxZtJ6GqQvW
DCUxFtqvSPbuoiH9TN/dCsYnNFk7bGga0pYFzLUfIbh4y2F1eT8NkwTWjfsY
mxkrb6QM0JCqfpqczlhV4sYPGqbByvWM57+M7/PzHJaP0JCS4jQ6yvjiHIv/
Rkdp+B8olH4v
     "]]}, 
   {RGBColor[0, 0, 1], Thickness[Tiny], LineBox[CompressedData["
1:eJwV0Xs0lHkYB/A5Li25RCq7i7BbU53SHNO0tKrnWc2hy7a6nGMpmrA56ILT
RnLL2hptS4ooZdNWjOp9fzSppGZHSUinzEZ2iXVrysz7vm5Zk9u++8dzvufz
3/d8H9fQ6G17jAQCwWb+/s+Y6OcCQTGFPjIz2yN3dKCirziKeEt2D69+yduS
TfDcxds1pCNCeFcHin3CmAe8J0NvqzW8OyNTOw+XUKgM3x2ztFIH3/3grhpU
UOh84N6L9iodLAs8m9hzg0JDUkQWVOtA6x08WltO4Y2COgvTRh3MbbI6flJF
4YKu6H5Zjw6+jyhKjG+gsOJZTM5ygw6y2CU5i1ooLEv6WHnKWg9JolfS5m4K
1Z57a9QL9ZCSsDvoOkuh9tzK83u89OCRYmWdPE7hlybarX9v00NfbHmXnRmN
DStdM7oi9VBywMNBY0ej3KIiIyhVDy7CDjbThcZAvWh/SZ4eqLfhi2OX0egd
a+IYflMPory36Z960pj3IGT93Wo9RAjkCQ+lNE7PLg5obdVDxUHz5hNbaEyx
kq7Yz+rh3uWbDduDabS1qx9sMmWgXOXT3RVJo01ni1u9IwOq3key/EM0Cv3W
SiRiBtKeyOI3/kSjX8Ov86M3MBBIOkYWZNGY/V7yp5OMAe32FMvJAhp77Wr2
XoxjIEo7x+d8CY1XTdrTqEwGjH7O7AtS0ph0fnOo+AoDW9qEzvPVNIavKhbK
7zOg9PpdNaORxqjkgAq/lwxYnJxzVPmaxlZ5TvX1PgY+O1vSFtxL447CivLm
CQZWKxwLRQM0Dvu77/txNgtz426NTU3QWOSQO7NnCQs9Yog7Y07wXnGqsBdZ
qB2jAjfPJfiuucYy0J8FWcKa16ZfEFxmM9hSuJ8FK2Nyv8+NYAYbt9c/nYWy
RHv1iVUE/XKOJV8+x4I5KZIt9SG4eF3iwQeEhXidxZ6RrQQd8htWbHrCwoXu
fJOqXQRdRgWtpe0svOo2nVkaRXCtIdsnaYgFI02U+844gk8flYq7PuHgbeLA
0Mx0gqH5pUbznDnoXB7weXcWQXsb40KVhIOsi/+03blAsCNnnYPHtxyIDbI/
/BQEbTos7b3DONDtqjazuU1wZ6PojfowBztS1+mfqwlWPlkln5XNwRtFyUpl
I0G3sMLxpmsc+FcbXQ5qJTjr6QlGWMXBsdyUYuM+gsZfBT/epOGgLqbdVjNA
0HrDL2G9Wg5860/XzxgkWIejTdJ3HNS6+qZ58U7zDMVrvGs05QNXeY8s+top
/D0H1RL5i/ghgm0z+lu0/RzcH3PPdBohqKjZsFHHcHDzqNws8l+C3mjuPjTM
wdK/VqsLeU94HLq0bYSD6+5D8RreFaIuKyVvRXeQ1muM39u5sv/gBw6uScW1
1ga+/1TE1Q+jHPxm9ib99keC7VV19gYDB04hZ7ze885TSo4HfuTgYqXvsNM4
/78bRSOVvAuiboXKeT8qONx0ZJyD/Eb5NzsmCJYmLD45McHBvIVrDFm8w2Jz
DUGTHOQlD5U95j0/UhDxkHfu8mAXt0mCpwNapSlTHNjJZ7eG8N64Rars4H2m
8+mpPN4m68tcYZoDW89k32e8H4Jj9iXe2dni6WnecR4ZU9O8/wMpToqa
     "]]}, 
   {RGBColor[0.6, 0.6, 0.6], Thickness[Tiny], LineBox[CompressedData["
1:eJwV0Hs0lHkcBnCrsog9qXQRoq1pu8qclHU535+2aG2NUtpYQ9p0YluX3Y0k
ki6zlKFZsZGSxKiZ9xcTIURJNYncNq0a9c4tZpqf0W2E7Lt/POc5n/M95/vH
47g72j/c2MjIaDOT/zsm+rGRUYkY+aeLakoSaGigLts6MRbk6M9UHaLBQpfg
GsL4SdGayJZEGoT7WTF1jDm3Gm1USTT0RxzpP1gqRhu03YmLUmng7HFu0AvF
aA1n3LM4nYblgWcT5dfEaN50zp1L+TSo13E/tJSLkewckZ6vp8G6w/LkqQYx
Khwu8PX9Ug4/7itMjJeKkb2nXGa9SQ583ZK/Fv8jRsu8TEZ5mXI47NS9vocW
oxh+9onyXjkkJ+wKvqpj/Lhm4YitAtYmW36VNCpGwgBftmGvApSx5a9mmFIo
Krf6fgFWQGnU2nmdMyg0JK2PDXurAAeWTJfhQKEyn5Xpzz2UIFbt/SZ2OYXs
q1xuHjiqBKcc1bE5rhRaILPZX9mshH1GvIT69RTi+v2SKbJUQeXvZj1pWyi0
vcL/ftNWFVRfEkm3cSmUFHLlV36+CsobvOlXERRya+7J/0KhggbFndDcAxSq
mFcgEyxWw9F7ofG+qcy/uvbMvhg1BGLZu4V8Cj3gnAtYV6kG9bZki/E8CoUv
bUvbNaGGSPVM73OlFBLcfrlh0cbXYHw8QxksoVCKd/os09OvYUsfa759I4UK
Z10MKOp5DRL3ogaTVube61sWZDMAU0/NTJE8pZBuW/fxGu4AzD1b2sdVUChr
zsO29pIB8BDaFjgNUUjftn3FZM0AWMdVGD6PUehE2w+fyOpBkLMhTmCGURnP
wS81aRBaDOLAzdYYZbBPV7ObBiE0wfPplAUYFbN+zsoz14DlJFyrXIHRIYuO
ww5+GrieOLsx7VuMXl2z1W8SaMAMF4Yu88boYHZX16o+DcRrpoa/24pRR5Tj
I/Z8LeTTuZNvhWAULPh3lXafFrrpKeZlkRgJS5deuyvWgnFnpPNPcRilxu0U
e+m1oEocGjY/hlEWX28X7/YG+lfutKH5GHH/drwsTX4D/PMv+6ryGWvqcnoe
vAH2SOhtPyFGgx9dpvOsdKAJaTKddgMjtw8binYE6CDoyHfax40Y1Xk2Fb64
oIMXwlIXSStGhrguSapcBzuajC8F92IkjbjLaWMROJGdXDJJiVHbFfudHdEE
HsQ8t+ocYvbpmhY3LCHg8/DMQxM9RlvNWaIFlQRaHH2OujO29nKn/asINHeW
DxUzvkCFcyTVBJpW89rjhzGqTKtl/VFPoNbgnGH3DiMZ7Hn6voWAKIVnGvER
o1Wim64jzwgse+bRWMD4Pd0ataSPwFXn4fhOxjVz6eLA5wSEdLDa3YDROp6F
Va2MwJX17JavRjAK2h02cEhO4ILpi2M3PjF7zpmaN6YlYBcmcB9gvNHP4cly
HYHzNT5v7UYxsjjpYsIlBPIiK3bzGJ99G/pbvZ5AbivPK2gMI1HbDd/kDwRm
LfIc4TOOnSJNoT4SyEkavn6XsZtHf5XMQCB7JddhxThGzWVmX8MogRm86b1h
jP98aR8YPUZA0H8/M4fx5tmrMy+OE7ByTfJ5xNiK8/299s8EsrLYExOMe46H
jE5MEPgPX6KP2Q==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{3800., 0},
  Method->{},
  PlotRange->{{3795, 4095}, {0., 0.9999999972658162}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.490321204661125*^9, 3.490321276661125*^9, {3.49032135617675*^9, 
   3.490321407536125*^9}, 3.490321438473625*^9, {3.49032155436425*^9, 
   3.4903215836455*^9}, 3.490321701708*^9, {3.490321734536125*^9, 
   3.490321750333*^9}, 3.490321791833*^9, {3.49032228842675*^9, 
   3.4903222952705*^9}, 3.490322583379875*^9, 3.490322785083*^9, 
   3.490322828708*^9, 3.49032308830175*^9, 3.490323146567375*^9, 
   3.490325820879875*^9, 3.4904778662591248`*^9, 3.4904786179778748`*^9, 
   3.4904852808997498`*^9, {3.4904859710559998`*^9, 3.4904859928059998`*^9}, 
   3.4905708979153748`*^9, 3.4905712935872498`*^9, 3.4905715407747498`*^9, 
   3.4905721441184998`*^9, 3.57652250099825*^9, 3.735065616128708*^9}],

Cell[BoxData[
 GraphicsBox[
  RasterBox[
   NCache[{{{0.866025, 0, 0.866025}, {
      0.8664715833333334, Rational[1, 300], 0.8664715833333334}, {
      0.8669181666666667, Rational[1, 150], 0.8669181666666667}, {
      0.86736475, Rational[1, 100], 0.86736475}, {
      0.8678113333333334, Rational[1, 75], 0.8678113333333334}, {
      0.8682579166666667, Rational[1, 60], 0.8682579166666667}, {
      0.8687045, Rational[1, 50], 0.8687045}, {
      0.8691510833333334, Rational[7, 300], 0.8691510833333334}, {
      0.8695976666666667, Rational[2, 75], 0.8695976666666667}, {
      0.8700442500000001, Rational[3, 100], 0.8700442500000001}, {
      0.8704908333333333, Rational[1, 30], 0.8704908333333333}, {
      0.8709374166666667, Rational[11, 300], 0.8709374166666667}, {
      0.871384, Rational[1, 25], 0.871384}, {
      0.8718305833333334, Rational[13, 300], 0.8718305833333334}, {
      0.8722771666666667, Rational[7, 150], 0.8722771666666667}, {
      0.87272375, Rational[1, 20], 0.87272375}, {
      0.8731703333333334, Rational[4, 75], 0.8731703333333334}, {
      0.8736169166666667, Rational[17, 300], 0.8736169166666667}, {
      0.8740635, Rational[3, 50], 0.8740635}, {
      0.8745100833333334, Rational[19, 300], 0.8745100833333334}, {
      0.8749566666666667, Rational[1, 15], 0.8749566666666667}, {
      0.8754032500000001, Rational[7, 100], 0.8754032500000001}, {
      0.8758498333333333, Rational[11, 150], 0.8758498333333333}, {
      0.8762964166666667, Rational[23, 300], 0.8762964166666667}, {
      0.876743, Rational[2, 25], 0.876743}, {
      0.8771895833333334, Rational[1, 12], 0.8771895833333334}, {
      0.8776361666666667, Rational[13, 150], 0.8776361666666667}, {
      0.87808275, Rational[9, 100], 0.87808275}, {
      0.8785293333333334, Rational[7, 75], 0.8785293333333334}, {
      0.8789759166666667, Rational[29, 300], 0.8789759166666667}, {
      0.8794225, Rational[1, 10], 0.8794225}, {
      0.8798690833333334, Rational[31, 300], 0.8798690833333334}, {
      0.8803156666666667, Rational[8, 75], 0.8803156666666667}, {
      0.8807622500000001, Rational[11, 100], 0.8807622500000001}, {
      0.8812088333333333, Rational[17, 150], 0.8812088333333333}, {
      0.8816554166666667, Rational[7, 60], 0.8816554166666667}, {
      0.882102, Rational[3, 25], 0.882102}, {
      0.8825485833333334, Rational[37, 300], 0.8825485833333334}, {
      0.8829951666666667, Rational[19, 150], 0.8829951666666667}, {
      0.88344175, Rational[13, 100], 0.88344175}, {
      0.8838883333333334, Rational[2, 15], 0.8838883333333334}, {
      0.8843349166666667, Rational[41, 300], 0.8843349166666667}, {
      0.8847815, Rational[7, 50], 0.8847815}, {
      0.8852280833333334, Rational[43, 300], 0.8852280833333334}, {
      0.8856746666666667, Rational[11, 75], 0.8856746666666667}, {
      0.8861212500000001, Rational[3, 20], 0.8861212500000001}, {
      0.8865678333333333, Rational[23, 150], 0.8865678333333333}, {
      0.8870144166666667, Rational[47, 300], 0.8870144166666667}, {
      0.887461, Rational[4, 25], 0.887461}, {
      0.8879075833333334, Rational[49, 300], 0.8879075833333334}, {
      0.8883541666666667, Rational[1, 6], 0.8883541666666667}, {
      0.88880075, Rational[17, 100], 0.88880075}, {
      0.8892473333333334, Rational[13, 75], 0.8892473333333334}, {
      0.8896939166666668, Rational[53, 300], 0.8896939166666668}, {
      0.8901405, Rational[9, 50], 0.8901405}, {
      0.8905870833333334, Rational[11, 60], 0.8905870833333334}, {
      0.8910336666666667, Rational[14, 75], 0.8910336666666667}, {
      0.8914802500000001, Rational[19, 100], 0.8914802500000001}, {
      0.8919268333333333, Rational[29, 150], 0.8919268333333333}, {
      0.8923734166666667, Rational[59, 300], 0.8923734166666667}, {
      0.8928200000000001, Rational[1, 5], 0.8928200000000001}, {
      0.8932665833333334, Rational[61, 300], 0.8932665833333334}, {
      0.8937131666666667, Rational[31, 150], 0.8937131666666667}, {
      0.89415975, Rational[21, 100], 0.89415975}, {
      0.8946063333333334, Rational[16, 75], 0.8946063333333334}, {
      0.8950529166666668, Rational[13, 60], 0.8950529166666668}, {
      0.8954995, Rational[11, 50], 0.8954995}, {
      0.8959460833333334, Rational[67, 300], 0.8959460833333334}, {
      0.8963926666666667, Rational[17, 75], 0.8963926666666667}, {
      0.8968392500000001, Rational[23, 100], 0.8968392500000001}, {
      0.8972858333333333, Rational[7, 30], 0.8972858333333333}, {
      0.8977324166666667, Rational[71, 300], 0.8977324166666667}, {
      0.8981790000000001, Rational[6, 25], 0.8981790000000001}, {
      0.8986255833333334, Rational[73, 300], 0.8986255833333334}, {
      0.8990721666666667, Rational[37, 150], 0.8990721666666667}, {
      0.89951875, Rational[1, 4], 0.89951875}, {
      0.8999653333333334, Rational[19, 75], 0.8999653333333334}, {
      0.9004119166666666, Rational[77, 300], 0.9004119166666666}, {
      0.9008585, Rational[13, 50], 0.9008585}, {
      0.9013050833333334, Rational[79, 300], 0.9013050833333334}, {
      0.9017516666666667, Rational[4, 15], 0.9017516666666667}, {
      0.9021982500000001, Rational[27, 100], 0.9021982500000001}, {
      0.9026448333333333, Rational[41, 150], 0.9026448333333333}, {
      0.9030914166666667, Rational[83, 300], 0.9030914166666667}, {
      0.9035380000000001, Rational[7, 25], 0.9035380000000001}, {
      0.9039845833333333, Rational[17, 60], 0.9039845833333333}, {
      0.9044311666666667, Rational[43, 150], 0.9044311666666667}, {
      0.90487775, Rational[29, 100], 0.90487775}, {
      0.9053243333333334, Rational[22, 75], 0.9053243333333334}, {
      0.9057709166666668, Rational[89, 300], 0.9057709166666668}, {
      0.9062175, Rational[3, 10], 0.9062175}, {
      0.9066640833333334, Rational[91, 300], 0.9066640833333334}, {
      0.9071106666666667, Rational[23, 75], 0.9071106666666667}, {
      0.90755725, Rational[31, 100], 0.90755725}, {
      0.9080038333333333, Rational[47, 150], 0.9080038333333333}, {
      0.9084504166666667, Rational[19, 60], 0.9084504166666667}, {
      0.9088970000000001, Rational[8, 25], 0.9088970000000001}, {
      0.9093435833333333, Rational[97, 300], 0.9093435833333333}, {
      0.9097901666666667, Rational[49, 150], 0.9097901666666667}, {
      0.91023675, Rational[33, 100], 0.91023675}, {
      0.9106833333333334, Rational[1, 3], 0.9106833333333334}, {
      0.9111299166666667, Rational[101, 300], 0.9111299166666667}, {
      0.9115765, Rational[17, 50], 0.9115765}, {
      0.9120230833333334, Rational[103, 300], 0.9120230833333334}, {
      0.9124696666666667, Rational[26, 75], 0.9124696666666667}, {
      0.91291625, Rational[7, 20], 0.91291625}, {
      0.9133628333333333, Rational[53, 150], 0.9133628333333333}, {
      0.9138094166666667, Rational[107, 300], 0.9138094166666667}, {
      0.9142560000000001, Rational[9, 25], 0.9142560000000001}, {
      0.9147025833333333, Rational[109, 300], 0.9147025833333333}, {
      0.9151491666666667, Rational[11, 30], 0.9151491666666667}, {
      0.91559575, Rational[37, 100], 0.91559575}, {
      0.9160423333333334, Rational[28, 75], 0.9160423333333334}, {
      0.9164889166666667, Rational[113, 300], 0.9164889166666667}, {
      0.9169355, Rational[19, 50], 0.9169355}, {
      0.9173820833333334, Rational[23, 60], 0.9173820833333334}, {
      0.9178286666666667, Rational[29, 75], 0.9178286666666667}, {
      0.91827525, Rational[39, 100], 0.91827525}, {
      0.9187218333333333, Rational[59, 150], 0.9187218333333333}, {
      0.9191684166666667, Rational[119, 300], 0.9191684166666667}, {
      0.9196150000000001, Rational[2, 5], 0.9196150000000001}, {
      0.9200615833333333, Rational[121, 300], 0.9200615833333333}, {
      0.9205081666666667, Rational[61, 150], 0.9205081666666667}, {
      0.92095475, Rational[41, 100], 0.92095475}, {
      0.9214013333333334, Rational[31, 75], 0.9214013333333334}, {
      0.9218479166666667, Rational[5, 12], 0.9218479166666667}, {
      0.9222945, Rational[21, 50], 0.9222945}, {
      0.9227410833333334, Rational[127, 300], 0.9227410833333334}, {
      0.9231876666666667, Rational[32, 75], 0.9231876666666667}, {
      0.92363425, Rational[43, 100], 0.92363425}, {
      0.9240808333333334, Rational[13, 30], 0.9240808333333334}, {
      0.9245274166666667, Rational[131, 300], 0.9245274166666667}, {
      0.9249740000000001, Rational[11, 25], 0.9249740000000001}, {
      0.9254205833333333, Rational[133, 300], 0.9254205833333333}, {
      0.9258671666666667, Rational[67, 150], 0.9258671666666667}, {
      0.92631375, Rational[9, 20], 0.92631375}, {
      0.9267603333333334, Rational[34, 75], 0.9267603333333334}, {
      0.9272069166666667, Rational[137, 300], 0.9272069166666667}, {
      0.9276535, Rational[23, 50], 0.9276535}, {
      0.9281000833333334, Rational[139, 300], 0.9281000833333334}, {
      0.9285466666666667, Rational[7, 15], 0.9285466666666667}, {
      0.92899325, Rational[47, 100], 0.92899325}, {
      0.9294398333333334, Rational[71, 150], 0.9294398333333334}, {
      0.9298864166666667, Rational[143, 300], 0.9298864166666667}, {
      0.9303330000000001, Rational[12, 25], 0.9303330000000001}, {
      0.9307795833333333, Rational[29, 60], 0.9307795833333333}, {
      0.9312261666666667, Rational[73, 150], 0.9312261666666667}, {
      0.93167275, Rational[49, 100], 0.93167275}, {
      0.9321193333333334, Rational[37, 75], 0.9321193333333334}, {
      0.9325659166666667, Rational[149, 300], 0.9325659166666667}, {
      0.9330125, Rational[1, 2], 0.9330125}, {
      0.9334590833333334, Rational[151, 300], 0.9334590833333334}, {
      0.9339056666666667, Rational[38, 75], 0.9339056666666667}, {
      0.93435225, Rational[51, 100], 0.93435225}, {
      0.9347988333333334, Rational[77, 150], 0.9347988333333334}, {
      0.9352454166666667, Rational[31, 60], 0.9352454166666667}, {
      0.935692, Rational[13, 25], 0.935692}, {
      0.9361385833333333, Rational[157, 300], 0.9361385833333333}, {
      0.9365851666666667, Rational[79, 150], 0.9365851666666667}, {
      0.93703175, Rational[53, 100], 0.93703175}, {
      0.9374783333333334, Rational[8, 15], 0.9374783333333334}, {
      0.9379249166666667, Rational[161, 300], 0.9379249166666667}, {
      0.9383715, Rational[27, 50], 0.9383715}, {
      0.9388180833333334, Rational[163, 300], 0.9388180833333334}, {
      0.9392646666666666, Rational[41, 75], 0.9392646666666666}, {
      0.93971125, Rational[11, 20], 0.93971125}, {
      0.9401578333333334, Rational[83, 150], 0.9401578333333334}, {
      0.9406044166666667, Rational[167, 300], 0.9406044166666667}, {
      0.9410510000000001, Rational[14, 25], 0.9410510000000001}, {
      0.9414975833333333, Rational[169, 300], 0.9414975833333333}, {
      0.9419441666666667, Rational[17, 30], 0.9419441666666667}, {
      0.94239075, Rational[57, 100], 0.94239075}, {
      0.9428373333333333, Rational[43, 75], 0.9428373333333333}, {
      0.9432839166666667, Rational[173, 300], 0.9432839166666667}, {
      0.9437305, Rational[29, 50], 0.9437305}, {
      0.9441770833333334, Rational[7, 12], 0.9441770833333334}, {
      0.9446236666666668, Rational[44, 75], 0.9446236666666668}, {
      0.94507025, Rational[59, 100], 0.94507025}, {
      0.9455168333333334, Rational[89, 150], 0.9455168333333334}, {
      0.9459634166666667, Rational[179, 300], 0.9459634166666667}, {
      0.94641, Rational[3, 5], 0.94641}, {
      0.9468565833333333, Rational[181, 300], 0.9468565833333333}, {
      0.9473031666666667, Rational[91, 150], 0.9473031666666667}, {
      0.9477497500000001, Rational[61, 100], 0.9477497500000001}, {
      0.9481963333333334, Rational[46, 75], 0.9481963333333334}, {
      0.9486429166666667, Rational[37, 60], 0.9486429166666667}, {
      0.9490895, Rational[31, 50], 0.9490895}, {
      0.9495360833333334, Rational[187, 300], 0.9495360833333334}, {
      0.9499826666666666, Rational[47, 75], 0.9499826666666666}, {
      0.95042925, Rational[63, 100], 0.95042925}, {
      0.9508758333333334, Rational[19, 30], 0.9508758333333334}, {
      0.9513224166666667, Rational[191, 300], 0.9513224166666667}, {
      0.9517690000000001, Rational[16, 25], 0.9517690000000001}, {
      0.9522155833333333, Rational[193, 300], 0.9522155833333333}, {
      0.9526621666666667, Rational[97, 150], 0.9526621666666667}, {
      0.9531087500000001, Rational[13, 20], 0.9531087500000001}, {
      0.9535553333333333, Rational[49, 75], 0.9535553333333333}, {
      0.9540019166666667, Rational[197, 300], 0.9540019166666667}, {
      0.9544485, Rational[33, 50], 0.9544485}, {
      0.9548950833333334, Rational[199, 300], 0.9548950833333334}, {
      0.9553416666666666, Rational[2, 3], 0.9553416666666666}, {
      0.95578825, Rational[67, 100], 0.95578825}, {
      0.9562348333333334, Rational[101, 150], 0.9562348333333334}, {
      0.9566814166666667, Rational[203, 300], 0.9566814166666667}, {
      0.957128, Rational[17, 25], 0.957128}, {
      0.9575745833333333, Rational[41, 60], 0.9575745833333333}, {
      0.9580211666666667, Rational[103, 150], 0.9580211666666667}, {
      0.9584677500000001, Rational[69, 100], 0.9584677500000001}, {
      0.9589143333333333, Rational[52, 75], 0.9589143333333333}, {
      0.9593609166666667, Rational[209, 300], 0.9593609166666667}, {
      0.9598075, Rational[7, 10], 0.9598075}, {
      0.9602540833333334, Rational[211, 300], 0.9602540833333334}, {
      0.9607006666666666, Rational[53, 75], 0.9607006666666666}, {
      0.96114725, Rational[71, 100], 0.96114725}, {
      0.9615938333333334, Rational[107, 150], 0.9615938333333334}, {
      0.9620404166666667, Rational[43, 60], 0.9620404166666667}, {
      0.962487, Rational[18, 25], 0.962487}, {
      0.9629335833333333, Rational[217, 300], 0.9629335833333333}, {
      0.9633801666666667, Rational[109, 150], 0.9633801666666667}, {
      0.9638267500000001, Rational[73, 100], 0.9638267500000001}, {
      0.9642733333333333, Rational[11, 15], 0.9642733333333333}, {
      0.9647199166666667, Rational[221, 300], 0.9647199166666667}, {
      0.9651665, Rational[37, 50], 0.9651665}, {
      0.9656130833333334, Rational[223, 300], 0.9656130833333334}, {
      0.9660596666666666, Rational[56, 75], 0.9660596666666666}, {
      0.96650625, Rational[3, 4], 0.96650625}, {
      0.9669528333333334, Rational[113, 150], 0.9669528333333334}, {
      0.9673994166666667, Rational[227, 300], 0.9673994166666667}, {
      0.967846, Rational[19, 25], 0.967846}, {
      0.9682925833333333, Rational[229, 300], 0.9682925833333333}, {
      0.9687391666666667, Rational[23, 30], 0.9687391666666667}, {
      0.9691857500000001, Rational[77, 100], 0.9691857500000001}, {
      0.9696323333333333, Rational[58, 75], 0.9696323333333333}, {
      0.9700789166666667, Rational[233, 300], 0.9700789166666667}, {
      0.9705255, Rational[39, 50], 0.9705255}, {
      0.9709720833333333, Rational[47, 60], 0.9709720833333333}, {
      0.9714186666666667, Rational[59, 75], 0.9714186666666667}, {
      0.97186525, Rational[79, 100], 0.97186525}, {
      0.9723118333333334, Rational[119, 150], 0.9723118333333334}, {
      0.9727584166666667, Rational[239, 300], 0.9727584166666667}, {
      0.973205, Rational[4, 5], 0.973205}, {
      0.9736515833333333, Rational[241, 300], 0.9736515833333333}, {
      0.9740981666666667, Rational[121, 150], 0.9740981666666667}, {
      0.97454475, Rational[81, 100], 0.97454475}, {
      0.9749913333333333, Rational[61, 75], 0.9749913333333333}, {
      0.9754379166666667, Rational[49, 60], 0.9754379166666667}, {
      0.9758845, Rational[41, 50], 0.9758845}, {
      0.9763310833333334, Rational[247, 300], 0.9763310833333334}, {
      0.9767776666666667, Rational[62, 75], 0.9767776666666667}, {
      0.97722425, Rational[83, 100], 0.97722425}, {
      0.9776708333333334, Rational[5, 6], 0.9776708333333334}, {
      0.9781174166666666, Rational[251, 300], 0.9781174166666666}, {
      0.978564, Rational[21, 25], 0.978564}, {
      0.9790105833333334, Rational[253, 300], 0.9790105833333334}, {
      0.9794571666666667, Rational[127, 150], 0.9794571666666667}, {
      0.9799037500000001, Rational[17, 20], 0.9799037500000001}, {
      0.9803503333333333, Rational[64, 75], 0.9803503333333333}, {
      0.9807969166666667, Rational[257, 300], 0.9807969166666667}, {
      0.9812435, Rational[43, 50], 0.9812435}, {
      0.9816900833333333, Rational[259, 300], 0.9816900833333333}, {
      0.9821366666666667, Rational[13, 15], 0.9821366666666667}, {
      0.98258325, Rational[87, 100], 0.98258325}, {
      0.9830298333333334, Rational[131, 150], 0.9830298333333334}, {
      0.9834764166666667, Rational[263, 300], 0.9834764166666667}, {
      0.983923, Rational[22, 25], 0.983923}, {
      0.9843695833333334, Rational[53, 60], 0.9843695833333334}, {
      0.9848161666666667, Rational[133, 150], 0.9848161666666667}, {
      0.98526275, Rational[89, 100], 0.98526275}, {
      0.9857093333333333, Rational[67, 75], 0.9857093333333333}, {
      0.9861559166666667, Rational[269, 300], 0.9861559166666667}, {
      0.9866025, Rational[9, 10], 0.9866025}, {
      0.9870490833333334, Rational[271, 300], 0.9870490833333334}, {
      0.9874956666666667, Rational[68, 75], 0.9874956666666667}, {
      0.98794225, Rational[91, 100], 0.98794225}, {
      0.9883888333333334, Rational[137, 150], 0.9883888333333334}, {
      0.9888354166666666, Rational[11, 12], 0.9888354166666666}, {
      0.989282, Rational[23, 25], 0.989282}, {
      0.9897285833333334, Rational[277, 300], 0.9897285833333334}, {
      0.9901751666666667, Rational[139, 150], 0.9901751666666667}, {
      0.99062175, Rational[93, 100], 0.99062175}, {
      0.9910683333333333, Rational[14, 15], 0.9910683333333333}, {
      0.9915149166666667, Rational[281, 300], 0.9915149166666667}, {
      0.9919615, Rational[47, 50], 0.9919615}, {
      0.9924080833333333, Rational[283, 300], 0.9924080833333333}, {
      0.9928546666666667, Rational[71, 75], 0.9928546666666667}, {
      0.99330125, Rational[19, 20], 0.99330125}, {
      0.9937478333333334, Rational[143, 150], 0.9937478333333334}, {
      0.9941944166666667, Rational[287, 300], 0.9941944166666667}, {
      0.994641, Rational[24, 25], 0.994641}, {
      0.9950875833333334, Rational[289, 300], 0.9950875833333334}, {
      0.9955341666666667, Rational[29, 30], 0.9955341666666667}, {
      0.99598075, Rational[97, 100], 0.99598075}, {
      0.9964273333333333, Rational[73, 75], 0.9964273333333333}, {
      0.9968739166666667, Rational[293, 300], 0.9968739166666667}, {
      0.9973205, Rational[49, 50], 0.9973205}, {
      0.9977670833333334, Rational[59, 60], 0.9977670833333334}, {
      0.9982136666666667, Rational[74, 75], 0.9982136666666667}, {
      0.99866025, Rational[99, 100], 0.99866025}, {
      0.9991068333333334, Rational[149, 150], 0.9991068333333334}, {
      0.9995534166666666, Rational[299, 300], 0.9995534166666666}, {
      1., 1, 1.}}}, {{{0.866025, 0, 0.866025}, {0.8664715833333334, 
      0.0033333333333333335`, 0.8664715833333334}, {0.8669181666666667, 
      0.006666666666666667, 0.8669181666666667}, {0.86736475, 0.01, 
      0.86736475}, {0.8678113333333334, 0.013333333333333334`, 
      0.8678113333333334}, {0.8682579166666667, 0.016666666666666666`, 
      0.8682579166666667}, {0.8687045, 0.02, 0.8687045}, {0.8691510833333334, 
      0.023333333333333334`, 0.8691510833333334}, {0.8695976666666667, 
      0.02666666666666667, 0.8695976666666667}, {0.8700442500000001, 0.03, 
      0.8700442500000001}, {0.8704908333333333, 0.03333333333333333, 
      0.8704908333333333}, {0.8709374166666667, 0.03666666666666667, 
      0.8709374166666667}, {0.871384, 0.04, 0.871384}, {0.8718305833333334, 
      0.043333333333333335`, 0.8718305833333334}, {0.8722771666666667, 
      0.04666666666666667, 0.8722771666666667}, {0.87272375, 0.05, 
      0.87272375}, {0.8731703333333334, 0.05333333333333334, 
      0.8731703333333334}, {0.8736169166666667, 0.056666666666666664`, 
      0.8736169166666667}, {0.8740635, 0.06, 0.8740635}, {0.8745100833333334, 
      0.06333333333333334, 0.8745100833333334}, {0.8749566666666667, 
      0.06666666666666667, 0.8749566666666667}, {0.8754032500000001, 0.07, 
      0.8754032500000001}, {0.8758498333333333, 0.07333333333333333, 
      0.8758498333333333}, {0.8762964166666667, 0.07666666666666666, 
      0.8762964166666667}, {0.876743, 0.08, 0.876743}, {0.8771895833333334, 
      0.08333333333333333, 0.8771895833333334}, {0.8776361666666667, 
      0.08666666666666667, 0.8776361666666667}, {0.87808275, 0.09, 
      0.87808275}, {0.8785293333333334, 0.09333333333333334, 
      0.8785293333333334}, {0.8789759166666667, 0.09666666666666666, 
      0.8789759166666667}, {0.8794225, 0.1, 0.8794225}, {0.8798690833333334, 
      0.10333333333333333`, 0.8798690833333334}, {0.8803156666666667, 
      0.10666666666666667`, 0.8803156666666667}, {0.8807622500000001, 0.11, 
      0.8807622500000001}, {0.8812088333333333, 0.11333333333333333`, 
      0.8812088333333333}, {0.8816554166666667, 0.11666666666666667`, 
      0.8816554166666667}, {0.882102, 0.12, 0.882102}, {0.8825485833333334, 
      0.12333333333333334`, 0.8825485833333334}, {0.8829951666666667, 
      0.12666666666666668`, 0.8829951666666667}, {0.88344175, 0.13, 
      0.88344175}, {0.8838883333333334, 0.13333333333333333`, 
      0.8838883333333334}, {0.8843349166666667, 0.13666666666666666`, 
      0.8843349166666667}, {0.8847815, 0.14, 0.8847815}, {0.8852280833333334, 
      0.14333333333333334`, 0.8852280833333334}, {0.8856746666666667, 
      0.14666666666666667`, 0.8856746666666667}, {0.8861212500000001, 0.15, 
      0.8861212500000001}, {0.8865678333333333, 0.15333333333333332`, 
      0.8865678333333333}, {0.8870144166666667, 0.15666666666666668`, 
      0.8870144166666667}, {0.887461, 0.16, 0.887461}, {0.8879075833333334, 
      0.16333333333333333`, 0.8879075833333334}, {0.8883541666666667, 
      0.16666666666666666`, 0.8883541666666667}, {0.88880075, 0.17, 
      0.88880075}, {0.8892473333333334, 0.17333333333333334`, 
      0.8892473333333334}, {0.8896939166666668, 0.17666666666666667`, 
      0.8896939166666668}, {0.8901405, 0.18, 0.8901405}, {0.8905870833333334, 
      0.18333333333333332`, 0.8905870833333334}, {0.8910336666666667, 
      0.18666666666666668`, 0.8910336666666667}, {0.8914802500000001, 0.19, 
      0.8914802500000001}, {0.8919268333333333, 0.19333333333333333`, 
      0.8919268333333333}, {0.8923734166666667, 0.19666666666666666`, 
      0.8923734166666667}, {0.8928200000000001, 0.2, 0.8928200000000001}, {
      0.8932665833333334, 0.20333333333333334`, 0.8932665833333334}, {
      0.8937131666666667, 0.20666666666666667`, 0.8937131666666667}, {
      0.89415975, 0.21, 0.89415975}, {0.8946063333333334, 
      0.21333333333333335`, 0.8946063333333334}, {0.8950529166666668, 
      0.21666666666666667`, 0.8950529166666668}, {0.8954995, 0.22, 
      0.8954995}, {0.8959460833333334, 0.22333333333333333`, 
      0.8959460833333334}, {0.8963926666666667, 0.22666666666666666`, 
      0.8963926666666667}, {0.8968392500000001, 0.23, 0.8968392500000001}, {
      0.8972858333333333, 0.23333333333333334`, 0.8972858333333333}, {
      0.8977324166666667, 0.23666666666666666`, 0.8977324166666667}, {
      0.8981790000000001, 0.24, 0.8981790000000001}, {0.8986255833333334, 
      0.24333333333333335`, 0.8986255833333334}, {0.8990721666666667, 
      0.24666666666666667`, 0.8990721666666667}, {0.89951875, 0.25, 
      0.89951875}, {0.8999653333333334, 0.25333333333333335`, 
      0.8999653333333334}, {0.9004119166666666, 0.25666666666666665`, 
      0.9004119166666666}, {0.9008585, 0.26, 0.9008585}, {0.9013050833333334, 
      0.2633333333333333, 0.9013050833333334}, {0.9017516666666667, 
      0.26666666666666666`, 0.9017516666666667}, {0.9021982500000001, 0.27, 
      0.9021982500000001}, {0.9026448333333333, 0.2733333333333333, 
      0.9026448333333333}, {0.9030914166666667, 0.27666666666666667`, 
      0.9030914166666667}, {0.9035380000000001, 0.28, 0.9035380000000001}, {
      0.9039845833333333, 0.2833333333333333, 0.9039845833333333}, {
      0.9044311666666667, 0.2866666666666667, 0.9044311666666667}, {
      0.90487775, 0.29, 0.90487775}, {0.9053243333333334, 
      0.29333333333333333`, 0.9053243333333334}, {0.9057709166666668, 
      0.2966666666666667, 0.9057709166666668}, {0.9062175, 0.3, 0.9062175}, {
      0.9066640833333334, 0.30333333333333334`, 0.9066640833333334}, {
      0.9071106666666667, 0.30666666666666664`, 0.9071106666666667}, {
      0.90755725, 0.31, 0.90755725}, {0.9080038333333333, 
      0.31333333333333335`, 0.9080038333333333}, {0.9084504166666667, 
      0.31666666666666665`, 0.9084504166666667}, {0.9088970000000001, 0.32, 
      0.9088970000000001}, {0.9093435833333333, 0.3233333333333333, 
      0.9093435833333333}, {0.9097901666666667, 0.32666666666666666`, 
      0.9097901666666667}, {0.91023675, 0.33, 0.91023675}, {
      0.9106833333333334, 0.3333333333333333, 0.9106833333333334}, {
      0.9111299166666667, 0.33666666666666667`, 0.9111299166666667}, {
      0.9115765, 0.34, 0.9115765}, {0.9120230833333334, 0.3433333333333333, 
      0.9120230833333334}, {0.9124696666666667, 0.3466666666666667, 
      0.9124696666666667}, {0.91291625, 0.35, 0.91291625}, {
      0.9133628333333333, 0.35333333333333333`, 0.9133628333333333}, {
      0.9138094166666667, 0.3566666666666667, 0.9138094166666667}, {
      0.9142560000000001, 0.36, 0.9142560000000001}, {0.9147025833333333, 
      0.36333333333333334`, 0.9147025833333333}, {0.9151491666666667, 
      0.36666666666666664`, 0.9151491666666667}, {0.91559575, 0.37, 
      0.91559575}, {0.9160423333333334, 0.37333333333333335`, 
      0.9160423333333334}, {0.9164889166666667, 0.37666666666666665`, 
      0.9164889166666667}, {0.9169355, 0.38, 0.9169355}, {0.9173820833333334, 
      0.38333333333333336`, 0.9173820833333334}, {0.9178286666666667, 
      0.38666666666666666`, 0.9178286666666667}, {0.91827525, 0.39, 
      0.91827525}, {0.9187218333333333, 0.3933333333333333, 
      0.9187218333333333}, {0.9191684166666667, 0.39666666666666667`, 
      0.9191684166666667}, {0.9196150000000001, 0.4, 0.9196150000000001}, {
      0.9200615833333333, 0.4033333333333333, 0.9200615833333333}, {
      0.9205081666666667, 0.4066666666666667, 0.9205081666666667}, {
      0.92095475, 0.41, 0.92095475}, {0.9214013333333334, 
      0.41333333333333333`, 0.9214013333333334}, {0.9218479166666667, 
      0.4166666666666667, 0.9218479166666667}, {0.9222945, 0.42, 0.9222945}, {
      0.9227410833333334, 0.42333333333333334`, 0.9227410833333334}, {
      0.9231876666666667, 0.4266666666666667, 0.9231876666666667}, {
      0.92363425, 0.43, 0.92363425}, {0.9240808333333334, 
      0.43333333333333335`, 0.9240808333333334}, {0.9245274166666667, 
      0.43666666666666665`, 0.9245274166666667}, {0.9249740000000001, 0.44, 
      0.9249740000000001}, {0.9254205833333333, 0.44333333333333336`, 
      0.9254205833333333}, {0.9258671666666667, 0.44666666666666666`, 
      0.9258671666666667}, {0.92631375, 0.45, 0.92631375}, {
      0.9267603333333334, 0.4533333333333333, 0.9267603333333334}, {
      0.9272069166666667, 0.45666666666666667`, 0.9272069166666667}, {
      0.9276535, 0.46, 0.9276535}, {0.9281000833333334, 0.4633333333333333, 
      0.9281000833333334}, {0.9285466666666667, 0.4666666666666667, 
      0.9285466666666667}, {0.92899325, 0.47, 0.92899325}, {
      0.9294398333333334, 0.47333333333333333`, 0.9294398333333334}, {
      0.9298864166666667, 0.4766666666666667, 0.9298864166666667}, {
      0.9303330000000001, 0.48, 0.9303330000000001}, {0.9307795833333333, 
      0.48333333333333334`, 0.9307795833333333}, {0.9312261666666667, 
      0.4866666666666667, 0.9312261666666667}, {0.93167275, 0.49, 
      0.93167275}, {0.9321193333333334, 0.49333333333333335`, 
      0.9321193333333334}, {0.9325659166666667, 0.49666666666666665`, 
      0.9325659166666667}, {0.9330125, 0.5, 0.9330125}, {0.9334590833333334, 
      0.5033333333333333, 0.9334590833333334}, {0.9339056666666667, 
      0.5066666666666667, 0.9339056666666667}, {0.93435225, 0.51, 
      0.93435225}, {0.9347988333333334, 0.5133333333333333, 
      0.9347988333333334}, {0.9352454166666667, 0.5166666666666667, 
      0.9352454166666667}, {0.935692, 0.52, 0.935692}, {0.9361385833333333, 
      0.5233333333333333, 0.9361385833333333}, {0.9365851666666667, 
      0.5266666666666666, 0.9365851666666667}, {0.93703175, 0.53, 
      0.93703175}, {0.9374783333333334, 0.5333333333333333, 
      0.9374783333333334}, {0.9379249166666667, 0.5366666666666666, 
      0.9379249166666667}, {0.9383715, 0.54, 0.9383715}, {0.9388180833333334, 
      0.5433333333333333, 0.9388180833333334}, {0.9392646666666666, 
      0.5466666666666666, 0.9392646666666666}, {0.93971125, 0.55, 
      0.93971125}, {0.9401578333333334, 0.5533333333333333, 
      0.9401578333333334}, {0.9406044166666667, 0.5566666666666666, 
      0.9406044166666667}, {0.9410510000000001, 0.56, 0.9410510000000001}, {
      0.9414975833333333, 0.5633333333333334, 0.9414975833333333}, {
      0.9419441666666667, 0.5666666666666667, 0.9419441666666667}, {
      0.94239075, 0.57, 0.94239075}, {0.9428373333333333, 0.5733333333333334, 
      0.9428373333333333}, {0.9432839166666667, 0.5766666666666667, 
      0.9432839166666667}, {0.9437305, 0.58, 0.9437305}, {0.9441770833333334, 
      0.5833333333333334, 0.9441770833333334}, {0.9446236666666668, 
      0.5866666666666667, 0.9446236666666668}, {0.94507025, 0.59, 
      0.94507025}, {0.9455168333333334, 0.5933333333333334, 
      0.9455168333333334}, {0.9459634166666667, 0.5966666666666667, 
      0.9459634166666667}, {0.94641, 0.6, 0.94641}, {0.9468565833333333, 
      0.6033333333333334, 0.9468565833333333}, {0.9473031666666667, 
      0.6066666666666667, 0.9473031666666667}, {0.9477497500000001, 0.61, 
      0.9477497500000001}, {0.9481963333333334, 0.6133333333333333, 
      0.9481963333333334}, {0.9486429166666667, 0.6166666666666667, 
      0.9486429166666667}, {0.9490895, 0.62, 0.9490895}, {0.9495360833333334, 
      0.6233333333333333, 0.9495360833333334}, {0.9499826666666666, 
      0.6266666666666667, 0.9499826666666666}, {0.95042925, 0.63, 
      0.95042925}, {0.9508758333333334, 0.6333333333333333, 
      0.9508758333333334}, {0.9513224166666667, 0.6366666666666667, 
      0.9513224166666667}, {0.9517690000000001, 0.64, 0.9517690000000001}, {
      0.9522155833333333, 0.6433333333333333, 0.9522155833333333}, {
      0.9526621666666667, 0.6466666666666666, 0.9526621666666667}, {
      0.9531087500000001, 0.65, 0.9531087500000001}, {0.9535553333333333, 
      0.6533333333333333, 0.9535553333333333}, {0.9540019166666667, 
      0.6566666666666666, 0.9540019166666667}, {0.9544485, 0.66, 0.9544485}, {
      0.9548950833333334, 0.6633333333333333, 0.9548950833333334}, {
      0.9553416666666666, 0.6666666666666666, 0.9553416666666666}, {
      0.95578825, 0.67, 0.95578825}, {0.9562348333333334, 0.6733333333333333, 
      0.9562348333333334}, {0.9566814166666667, 0.6766666666666666, 
      0.9566814166666667}, {0.957128, 0.68, 0.957128}, {0.9575745833333333, 
      0.6833333333333333, 0.9575745833333333}, {0.9580211666666667, 
      0.6866666666666666, 0.9580211666666667}, {0.9584677500000001, 0.69, 
      0.9584677500000001}, {0.9589143333333333, 0.6933333333333334, 
      0.9589143333333333}, {0.9593609166666667, 0.6966666666666667, 
      0.9593609166666667}, {0.9598075, 0.7, 0.9598075}, {0.9602540833333334, 
      0.7033333333333334, 0.9602540833333334}, {0.9607006666666666, 
      0.7066666666666667, 0.9607006666666666}, {0.96114725, 0.71, 
      0.96114725}, {0.9615938333333334, 0.7133333333333334, 
      0.9615938333333334}, {0.9620404166666667, 0.7166666666666667, 
      0.9620404166666667}, {0.962487, 0.72, 0.962487}, {0.9629335833333333, 
      0.7233333333333334, 0.9629335833333333}, {0.9633801666666667, 
      0.7266666666666667, 0.9633801666666667}, {0.9638267500000001, 0.73, 
      0.9638267500000001}, {0.9642733333333333, 0.7333333333333333, 
      0.9642733333333333}, {0.9647199166666667, 0.7366666666666667, 
      0.9647199166666667}, {0.9651665, 0.74, 0.9651665}, {0.9656130833333334, 
      0.7433333333333333, 0.9656130833333334}, {0.9660596666666666, 
      0.7466666666666667, 0.9660596666666666}, {0.96650625, 0.75, 
      0.96650625}, {0.9669528333333334, 0.7533333333333333, 
      0.9669528333333334}, {0.9673994166666667, 0.7566666666666667, 
      0.9673994166666667}, {0.967846, 0.76, 0.967846}, {0.9682925833333333, 
      0.7633333333333333, 0.9682925833333333}, {0.9687391666666667, 
      0.7666666666666667, 0.9687391666666667}, {0.9691857500000001, 0.77, 
      0.9691857500000001}, {0.9696323333333333, 0.7733333333333333, 
      0.9696323333333333}, {0.9700789166666667, 0.7766666666666666, 
      0.9700789166666667}, {0.9705255, 0.78, 0.9705255}, {0.9709720833333333, 
      0.7833333333333333, 0.9709720833333333}, {0.9714186666666667, 
      0.7866666666666666, 0.9714186666666667}, {0.97186525, 0.79, 
      0.97186525}, {0.9723118333333334, 0.7933333333333333, 
      0.9723118333333334}, {0.9727584166666667, 0.7966666666666666, 
      0.9727584166666667}, {0.973205, 0.8, 0.973205}, {0.9736515833333333, 
      0.8033333333333333, 0.9736515833333333}, {0.9740981666666667, 
      0.8066666666666666, 0.9740981666666667}, {0.97454475, 0.81, 
      0.97454475}, {0.9749913333333333, 0.8133333333333334, 
      0.9749913333333333}, {0.9754379166666667, 0.8166666666666667, 
      0.9754379166666667}, {0.9758845, 0.82, 0.9758845}, {0.9763310833333334, 
      0.8233333333333334, 0.9763310833333334}, {0.9767776666666667, 
      0.8266666666666667, 0.9767776666666667}, {0.97722425, 0.83, 
      0.97722425}, {0.9776708333333334, 0.8333333333333334, 
      0.9776708333333334}, {0.9781174166666666, 0.8366666666666667, 
      0.9781174166666666}, {0.978564, 0.84, 0.978564}, {0.9790105833333334, 
      0.8433333333333334, 0.9790105833333334}, {0.9794571666666667, 
      0.8466666666666667, 0.9794571666666667}, {0.9799037500000001, 0.85, 
      0.9799037500000001}, {0.9803503333333333, 0.8533333333333334, 
      0.9803503333333333}, {0.9807969166666667, 0.8566666666666667, 
      0.9807969166666667}, {0.9812435, 0.86, 0.9812435}, {0.9816900833333333, 
      0.8633333333333333, 0.9816900833333333}, {0.9821366666666667, 
      0.8666666666666667, 0.9821366666666667}, {0.98258325, 0.87, 
      0.98258325}, {0.9830298333333334, 0.8733333333333333, 
      0.9830298333333334}, {0.9834764166666667, 0.8766666666666667, 
      0.9834764166666667}, {0.983923, 0.88, 0.983923}, {0.9843695833333334, 
      0.8833333333333333, 0.9843695833333334}, {0.9848161666666667, 
      0.8866666666666667, 0.9848161666666667}, {0.98526275, 0.89, 
      0.98526275}, {0.9857093333333333, 0.8933333333333333, 
      0.9857093333333333}, {0.9861559166666667, 0.8966666666666666, 
      0.9861559166666667}, {0.9866025, 0.9, 0.9866025}, {0.9870490833333334, 
      0.9033333333333333, 0.9870490833333334}, {0.9874956666666667, 
      0.9066666666666666, 0.9874956666666667}, {0.98794225, 0.91, 
      0.98794225}, {0.9883888333333334, 0.9133333333333333, 
      0.9883888333333334}, {0.9888354166666666, 0.9166666666666666, 
      0.9888354166666666}, {0.989282, 0.92, 0.989282}, {0.9897285833333334, 
      0.9233333333333333, 0.9897285833333334}, {0.9901751666666667, 
      0.9266666666666666, 0.9901751666666667}, {0.99062175, 0.93, 
      0.99062175}, {0.9910683333333333, 0.9333333333333333, 
      0.9910683333333333}, {0.9915149166666667, 0.9366666666666666, 
      0.9915149166666667}, {0.9919615, 0.94, 0.9919615}, {0.9924080833333333, 
      0.9433333333333334, 0.9924080833333333}, {0.9928546666666667, 
      0.9466666666666667, 0.9928546666666667}, {0.99330125, 0.95, 
      0.99330125}, {0.9937478333333334, 0.9533333333333334, 
      0.9937478333333334}, {0.9941944166666667, 0.9566666666666667, 
      0.9941944166666667}, {0.994641, 0.96, 0.994641}, {0.9950875833333334, 
      0.9633333333333334, 0.9950875833333334}, {0.9955341666666667, 
      0.9666666666666667, 0.9955341666666667}, {0.99598075, 0.97, 
      0.99598075}, {0.9964273333333333, 0.9733333333333334, 
      0.9964273333333333}, {0.9968739166666667, 0.9766666666666667, 
      0.9968739166666667}, {0.9973205, 0.98, 0.9973205}, {0.9977670833333334, 
      0.9833333333333333, 0.9977670833333334}, {0.9982136666666667, 
      0.9866666666666667, 0.9982136666666667}, {0.99866025, 0.99, 
      0.99866025}, {0.9991068333333334, 0.9933333333333333, 
      0.9991068333333334}, {0.9995534166666666, 0.9966666666666667, 
      0.9995534166666666}, {1., 1, 1.}}}]],
  AspectRatio->0.2]], "Output",
 CellChangeTimes->{
  3.490321204661125*^9, 3.490321276661125*^9, {3.49032135617675*^9, 
   3.490321407536125*^9}, 3.490321438473625*^9, {3.49032155436425*^9, 
   3.4903215836455*^9}, 3.490321701708*^9, {3.490321734536125*^9, 
   3.490321750333*^9}, 3.490321791833*^9, {3.49032228842675*^9, 
   3.4903222952705*^9}, 3.490322583379875*^9, 3.490322785083*^9, 
   3.490322828708*^9, 3.49032308830175*^9, 3.490323146567375*^9, 
   3.490325820879875*^9, 3.4904778662591248`*^9, 3.4904786179778748`*^9, 
   3.4904852808997498`*^9, {3.4904859710559998`*^9, 3.4904859928059998`*^9}, 
   3.4905708979153748`*^9, 3.4905712935872498`*^9, 3.4905715407747498`*^9, 
   3.4905721441184998`*^9, 3.57652250099825*^9, 3.735065616175584*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "domain", " ", "of", " ", "entire", " ", "color", " ", 
    "scheme"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lo", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hi", "=", "4095"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"width", "=", 
     RowBox[{"hi", "-", "lo"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Define", " ", "piecewise", " ", "domain", " ", "functions", " ", "for", 
      " ", "red"}], ",", " ", "green", ",", " ", "blue"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fnred1", "[", "x", "]"}], "/;", 
      RowBox[{"lo1", "\[LessEqual]", "x", "\[LessEqual]", "hi1"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fnred2", "[", "x", "]"}], "/;", 
      RowBox[{"lo2", "<", "x", "\[LessEqual]", "hi2"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnred", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fnred3", "[", "x", "]"}], "/;", 
      RowBox[{"lo3", "<", "x", "\[LessEqual]", "hi3"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fngrn", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fngrn1", "[", "x", "]"}], "/;", 
      RowBox[{"lo1", "\[LessEqual]", "x", "\[LessEqual]", "hi1"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fngrn", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fngrn2", "[", "x", "]"}], "/;", 
      RowBox[{"lo2", "<", "x", "\[LessEqual]", "hi2"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fngrn", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fngrn3", "[", "x", "]"}], "/;", 
      RowBox[{"lo3", "<", "x", "\[LessEqual]", "hi3"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnblu", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fnblu1", "[", "x", "]"}], "/;", 
      RowBox[{"lo1", "\[LessEqual]", "x", "\[LessEqual]", "hi1"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnblu", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fnblu2", "[", "x", "]"}], "/;", 
      RowBox[{"lo2", "<", "x", "\[LessEqual]", "hi2"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnblu", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fnblu3", "[", "x", "]"}], "/;", 
      RowBox[{"lo3", "<", "x", "\[LessEqual]", "hi3"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "saturation", " ", "function", " ", "for", " ", 
     "reference", " ", "use"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fnsat", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fnred", "[", "x", "]"}], "+", 
        RowBox[{"fngrn", "[", "x", "]"}], "+", 
        RowBox[{"fnblu", "[", "x", "]"}]}], ")"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "red"}], ",", " ", 
     RowBox[{
     "green", " ", "and", " ", "blue", " ", "functions", " ", "along", " ", 
      "with", " ", "saturation"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fnred", "[", "x", "]"}], ",", 
       RowBox[{"fngrn", "[", "x", "]"}], ",", 
       RowBox[{"fnblu", "[", "x", "]"}], ",", 
       RowBox[{"fnsat", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "lo", ",", "hi"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "Thin"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{".6", ",", ".6", ",", ".6"}], "]"}], ",", "Thin"}], 
         "}"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "create", " ", "a", " ", "table", " ", "of", " ", "\"\<width\>\"", " ", 
      "number", " ", "of", " ", "RGB", " ", "value", " ", "triplets"}], ",", 
     " ", 
     RowBox[{
     "each", " ", "value", " ", "ranging", " ", "from", " ", "0", " ", "to", 
      " ", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Colors", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"fnred", "[", "i", "]"}], ",", 
         RowBox[{"fngrn", "[", "i", "]"}], ",", 
         RowBox[{"fnblu", "[", "i", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "lo", ",", "hi"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "the", " ", "color", " ", "table", " ", "ceated", " ", 
     "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Raster", "[", 
      RowBox[{"{", "Colors", "}"}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", ".2"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4903218110205*^9, 3.49032182530175*^9}, {
   3.490321861473625*^9, 3.490322050848625*^9}, {3.490322189208*^9, 
   3.490322240129875*^9}, 3.490322335536125*^9, {3.490322422129875*^9, 
   3.490322460848625*^9}, {3.49032345955175*^9, 3.49032345961425*^9}, 
   3.4904778740716248`*^9, {3.4904787986653748`*^9, 3.4904788306497498`*^9}, 
   3.4904788679466248`*^9, {3.4904789054309998`*^9, 3.4904789474778748`*^9}, 
   3.4904801651653748`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJxF13k4lN/bAHAkWaKFUKksCUVFUijnLlSWElEShW9ICslSKBQVWpCirLM8
Yx0joUiWKEVZI4mSLGWWR8oSyu90Xe+r+Weuz/XMnOU597nvcxScvaxcBPj4
+Hbx8/H9/a7Z9WGz89cliO//Po47lFpSZH/OOqvtKL+PrCD8vxvSpmXtZaVm
3RNev9pSdvWs3ccLss1ktWedl8/g7pE1mvX+G/K3dstaz3rnsbsxlOHjs2br
zD9nI+c1a3jGUg+K8p11Z2fR6MTI+VlPt/x4s2jm4qwDVu6eydG/9K+9fLGD
ouzwWStuOqWtc+rqrCU87xpIBvzzVGblnuGwf367colDdsI/XxEtj1hZ/c9D
nxe8E1p2bdYFMQ/Pv6v959T67suFLf8cLSR8M7b7n48H21PNfvyz9Im59RUr
I2cdiA7JZfr9s2tg2JqI0EgoX96wef3n3ehAUc5G5+hI8PW747zzohOC4TY9
dDcSYpMF9Y4KnEbq6/iM5SiRsPNaYILFTl/0UTrrdMzrSJA6PzD3RWoE2smb
LD+nFAWqmQuWf9lxF/ESDWeSNaJAK9htvO9uArpneB1VbYkC+fR0zYfsRDSc
uKJSxDwKQuLznhXGJ6FUQ6i67xsFixMHtNb4pKOpxIjqsudR4OdR1j9QRqBC
w4Uv+U5EQ9uLCs2IVflI+Z5y87Xc66AyNBDfEliKLlNqFd6q3oIMq3snKLK1
yOW72YIkbgyUJXfuE81pQmyRS80FG+JA4K3MoVbdNtRv0Pit7fptqMp5EHuA
/R4lK9pS7n6JB/Xjhh5zjT+izX/y5AyU7sLAfsa+UrHPaOeYHG/4QgIYK+Uq
fJjuRZoDtpejqhJh6/ue89O5fSh+JMdzg/x9iLrzyFLl6AAqZOr9OnMuCRKs
NyW9+DKIih0TdieVJMOSDWbGbhu+IfWNYpzGJalgZBik6+Q7hMLHza3Zdmkg
4i11MuUyG73W6ddoMU+H/rhqnwovDloYyrIv/JUOcbqP56pYcJGy8UiB7nQ6
uGXcMFKz4iI90c0iFX/S4WliVoGaDRf9F19a9GoOBdwanFcoH+Gi4sznEp/E
KfDiWbqmkBsXOTR/qBRRpMDljpagMxe5KFtRWPmYKQViRrKbuDlcZPzckSuS
RAGj6NaUq/w8FPfYwu55CgV6StYM7xXkoZ4cg9rQdAqk3jddv3geDwXHyVHG
CQpcPy3gFT+fhwqOdVj351PgSvk6kVAZHpKftCirfEGBi+/SO36o89D0ehQd
MEIBqv6PXIuDPFSYuEKt34QKLHGyZ4DKQ8fmmDXfNqfC1nYB6iqCh0Q9z53f
aUGFJlMfn4MZPORk2PoqzZoKa7b67izP4SEJ3rWTdseo8Lk8kOFfyEMnDH/m
NPpSYUQzuzTqOQ8t59WtL02jQhrdb3LHAA+9sJ1oP0GlAs9vTH37Vx7yqVYO
kSGokCh9PUBniIdeJoY2+mZTIStf6qASj4d8DXW8NxRRIUohEAZGeaghkfKA
XkeFDzMckUVzSXTJ8Jz2rVEqcMfXeE8rkGiFqUb2ggkquLGfa6Uokejx/t5V
MZNUeG7cZ71NmUQ8B3Ox2Bk8vvLbj/1USWR3Tr43ToQGYd4+gm3rSaTFfHnr
7goa3IPlfcb6JOqVXspOMaZBkf03/xErEl1Y0eC4cg8NdlReohyzJpHs6svt
qaY0IFa6b6q3IdE+TW5VmgUNGDJyN1NsSVRqVpVIOUyDffnL1mw4SqK4UPdd
xGkarEx9KivkTqIdQyWU3Ds0SNso1Bh+gURSq5av/y+RBtFNYp/eXyTR1wPB
pUuTaDC/d46sRiiJYp4atF5JpwHHdaVQwyUS9cRUCzrl0GBRyp6uX1dJFLrl
jduSKhqwJ9Wf/IolUXl4j8ZFDg02SLNTk+m4/5IdpdokDfh77px9RJDIlUfd
xf5OA5NJ/uAmBokkbF2O2Y7ToNI9RO13Jokc1g3FaAnQ4YBTOd8OJommm3/8
GJChw7GTijyfIhLprZpXamFIh+Dy4a2Xakj0hyQlO4zpcKJZUtfmOYmqKjtO
O+6hg0f58IM1L0i0xzlb4cxeOjC6BBY8ryXRIWJvZNwhOkyUP7pI1pHId128
bZsHHd7XK/tPNZFo63RwgYMnHdL+k1Qubsb9v3aZP+BNh8WbvSy9Wkh02XNL
5Zgffh5EUepuxfN70KkiG0qH7UNGxYx2ErG2KIzbxdNhTqTnu+8fSOQjLGr5
5S4dqn+IhMV3kUjn/Ui2xz06vOR05W7uxu8rsOZocCod4kuOXj/7kUSvn7q9
SMmkw8oU07PdPSQaMsy701NGhyPtDatP9pMoTyqBPFFBhwVfTKRHsc/0h5h8
r6KDFLPz5sUBEk1csfzNX0uH9K4A6RuDJJpX9/O4UjMdbnC3X0v8RqLV+/W1
XfvpoCOuou/OJZFxovOrz4N0OLxKIbQT27Un8qjDEB1SpOnHTHkkyvTuuGZN
0oFddYZUJkmkEevXvfMXnn+ih93rYRx/75N9yqfo0N3JDtL6TiJvhZp5en/w
eklY6iVgFzxYrKU5h4CU0l837Ufw/FtYV1aJE9DvLZXe/gOvx7J3y5MWEKDH
N/+B5k8SnXP+ky+9mIAGaxOnaOzSEfMP4jIEDCnWpuuNkghJDm2Ylifgjc1G
+rUxvL7Wq993aBPwX//MTO8EidyTzTyttxCQf8hKTfUXiaL6fOY06RJw8kbp
mAf2a98qjVoDAto+CYSQ2JZ3jl4q2kMAShzdOzCJ16s7QkbTjICPMufS5adI
FK/MzM3dS8DtiJB7h7Hbi6baaVYEyKofDK3FtmtPXBdnT8CpD0Vqt6dJFLSy
slL8GAE5QSOPn2Enuw7aRDoRcO63yvdh7E9jm0NDXQlwFCtxMPlNIj7ksGT6
BAE6gQVxZ7EVr4ZnB3gQsDim50wy9nGZ1ree3gTomshsHMKOODbpPuRDAP1E
+YIFf0jEyFCYcfEjwFbl3X0t7K9bvNUcAgng7E0q9MMWCU0o7wgm4Gx9v+Ed
7LUvyw9Yh+D5SPaEPMQ+bSt+0SycAE0BpRk29suGHrXfVwjQmKZ5Cc/g8RgX
tuVFEhCzb5WVEnbwk6thjtcJuLptirENu13ziMbiW7g/pVRPa+yNmevfV8cS
YHTBM+skdtRKgQi/eAJefGg5FILdF9+2USWBAHuuZmActoFYVlfHPQIogSML
6diJYcHXopIJ+OYaJFeIPTJuob0tjYCd+ZtSnmGbeyr1cCkE+Hldut2Izegb
i06jEyDS0TDTic13pG6LZQYBu7eG9vZh2zWnfBHIJmD7r9/6XOzC3WduFeYS
8DSVNf8ntkS5kb4riwCX2mnrX9gntGUHZQoISFPfu+Q39rNsdtyrQgIIqvC+
GWw5hQqDoEcEXJJNmPlr/4S4IfVSApYmOq796yZx17sfywhQ3vWmYRp7bbju
zpgK3L+zMXcCO3xyPm/HMwLad2le+YH90bvn3o8aAszdf93jYG8dfGhM1OL4
Oyyk9nf8cQ5Xvx+sI6C4unLT3/lxWu1ShN8QwD4VW9qAvct0vUlpIwEROp+f
VmGnV/KPerTg8cktNXiIPanTlr6ijYCOzVR9GrY1M9O88R2Ox8L+4ljsPKXg
idBOAg72m+dfxBa+b0HX6ibgxMYdqn/Xz3mh0v6+TwTkyaqv+ru+0r9fZezu
J0DG+nr033jwPpty4NcgjgftNn4R7Lpv3jPZQwQ0v34ywcHxdLFd5pDEMB6/
u+jJfOwOc7ZA5QgBN97u6r+FrVVdnndmlICq6le9p7EHWC5CbZMEZK3Z66qM
bRH5sChpLgNmikfvX8Lxnz1zxWmvMANk0SLtg9iC/nbiM6IMaP/zykoV+7Ez
v4vzQgakR1QqvsT7TX6bhZTacgZU7I+QHcP7NbBAsbJzBQMWBewdeor9VnXM
47o8A8KPLjQOx762JKWaVGbAVbQlYT72MG/Ip3gjA4R+9ZWI4fygx7+Lo7uJ
AduKI/1f4/wRLklxebqZAQEVBBmNLbP1kG2NHgOM+Bmy87ANwqq3txgx4DQ7
yII3TqIbksnCPFsGLOt1Sw3F+axdeTzszBEGZHdqmmtgy2+1mvrpwIA33XPL
OnD+K7QX5k05M8D8/qYv67C7CN9WkdMMcC4OOVyN8+narXtTlcMYILqW1H6E
87OvaaZM1mUGTNVlaezHLrefE6t+hQEdkdK8QZzPLcNKLm+KZkDd4bO1ktjn
6pTdd9xhwNkm3QF7Dolq7f9scshiQL6uweqirzj/hLFexTczIMOzTjUU16PB
quLD+94yQOuza+fAJxKdFCj/Nu8dA1qKKGvNsb0uvxYJ6mKAA6s5czGuZ4ER
30ycBhnwdUhf7RauhzGRSnUavxnwPDSLtgvXyyexCXUvVDNgmdZEUwGuxwYt
qXah6zLgp1EL8F6RqHIxY0h3fQZY8oUdVcV+cbtQlLkpAx7VmBGJuJ433Wk2
vW2QAVVKap7u+DwwcE+s/ph1Bsi3Cdm9fkqixdSQ+omQDOjd4ymSxMLrdVFC
LfxSBoROnPhelkeicbuUKwsiMmCkfUtlNz5vdEk+2bEmKgNcz/+QlMvF+SVi
7NGB+Axg11qmRePziZ77aXpeZgboyYdRdCh4f2w8cuF4cwYMk2u2VuDzz4Ny
nQ1NipngtlJDq8ALn48WC77cp5wJkbtka+56kmi/a7PjG5VM2Oad6xR4GseX
+Km4OvVMaLLzqzLwwPnTgTJao5MJ5/bIrCpzJVH+lFhZiWkm2Hp5sSIdsLd+
3kPzyQRLzTuLzpri/VsQ7ez/LBPe68sU3MXn0X5tDlC9suD3ZBs37ikPiT/c
FLZjUTaM6Vfkcw/wkFfFlVOuldnwUs/QkdrORRtpASp2p3Jgc8hJxecHuKj3
koVR1fxcSFn1eKlSOwc1DGvNzyvNBU8zwQB/Cw7yX9Z5fcvTXHgsPqFyYy8H
rTAKE6+qyIW8hMXn6GYcdCqhUeJtTS6Un4wRaNvNQaIGpxZNNuSC1aeMFQbA
QcbRhPSuL7kgz7h/bZMmB5Upyyp8FGOC1cIx1ZeSHHTcooLiJsEEKSfffZOL
OEjsvKvi94VMUFl/K11jIQfZvS5UEpRmgoK/QV/CfA6a8LFcs1aeCTZcWkbQ
XA7Sroxa56+N///lev2VcTbKsfu9WcKBCe9zYueNdLHx++z9HnUMP880vfnf
BzYqTH7JnOfMhKmvb9PfvWej8o+3lfndmGCyz7Omtp2NWpzXLvnpzYRDFwI/
1TWx0bs5C5u9zzKhT8444UAjG3XRR69z/Ziwpv/Ms09v2GhgoFJwMJAJf4xF
l86pZ6PJk4d+vg9nwraIhVZBz9loRmx7/sGr+PcSborKNWwkyFQ81RrJhORy
/t1vn7GRBMn98vomE1wZW7WNKtlIMqY1zSQWt+cgyi9UwUaymiVHXtxmwsFs
wy2NT9lI8Wx4a0UiE+IX1HsFPWEjFamTt7YlMWHlyDLSsZSN1IsszEpSmED9
lqx+oISNNA9unqeTzgQt9/M7bR6zkc74suoCKhOirRSenXrERvqJfCEbCCbA
ojH+zGI2At0BvdwMJjgH5DpF4v8bddaPqWYz4XOQ8VLpcjYyCXpQQOQywSn0
YxMVj3+fXIKnIosJveEB1zbUspHV0+C1aQ/w88iFUIbfh/3MbmpiMW4vbier
7S0beV/+GBtdyQQXOuOG8CAbJUaLnTnzlgkeLz1NPcU4aDDJZcP2aSb4Lpyp
1rXmoNUe4/zDf5gwdITvlNphDnLWi3xL5c8Dpwx+qaVHOehjR+554Xl5YGEg
eHzCjYPal/ysbl2UB+qnRAQfBXFQza1LtidV8qC3VtJIm8ZB1MtpYQlWeWAV
olqzfoSDHDzet37PzIONPMsapRguqtHR7lxqygInF04Yt5iHVt9J8/lmzgKh
m/H1i8p4KOKHqFiJBQtyi7ct0anioV35n/VtbVgwNu9G5sV6fL9Uu5Vy15EF
0dkajQt6eOi13JCjZAALCklPOS0RXH8E0gfn01kgHPi92P8IibSdxEK7GLg9
6j2+JEcS3anwl83NYoFV/Q7TChcSHQzea2LGYkGyXFz3PG9cT0cnsyNLWaBZ
oSV4Lxznr682nkLNLDgi6Gv5BOezbburhNpbWTCjLpf0qYBEKYR6GtHOAsKm
pm/OYxIddZ7TZNTFgmGG1DnzZ/h+9yFf8/IgC8JNilK7cX4GPbk6qyEWqPk4
fOXH9xdK4lVnRS4LGu/P1VrzGec/m6O3q0ZYsJRj89yTTaLqh6/WxY6yoFLq
j8RtfD9YvXhzjeMEC1y3M2wf4foW7p1uv3GKBaKu+6gfcD3tbxAbnfnNgvyb
Y+y/56f/Aea9FL0=
     "]]}, 
   {RGBColor[0, 1, 0], Thickness[Tiny], LineBox[CompressedData["
1:eJwV13k8VF8UAHBaLEkpJUkRkqQoS2U7R7ZUKKlICpWIUNkjWVKhLLPZIkJZ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     "]]}, 
   {RGBColor[0, 0, 1], Thickness[Tiny], LineBox[CompressedData["
1:eJwVl3k8lN8Xx0mFUCRCUpY2qSS0oHMIpZRdtmx9LZVki0GRtUgk+5IZW0kz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     "]]}, 
   {RGBColor[0.6, 0.6, 0.6], Thickness[Tiny], LineBox[CompressedData["
1:eJwd2Xc8V98fB3BpKWknhIQGRZKdnLcSWdlFWUl2CAnJ3pT5Qfb6fIzsKHwl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  ImageSize->{713., Automatic},
  Method->{},
  PlotRange->{{0, 4095}, {0., 0.999999999236721}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.49032582561425*^9, 3.490325849161125*^9}, 
   3.4904778751184998`*^9, 3.4904783194153748`*^9, 3.4904784623372498`*^9, 
   3.4904786219778748`*^9, 3.4904788405091248`*^9, 3.4904789386497498`*^9, 
   3.4904801656653748`*^9, 3.4904852934778748`*^9, 3.4904860021809998`*^9, 
   3.4904863461653748`*^9, 3.4904863973059998`*^9, 3.4905709021497498`*^9, 
   3.4905711766341248`*^9, 3.4905712969778748`*^9, 3.4905715435872498`*^9, 
   3.4905721474309998`*^9, 3.576522506888875*^9, 3.735065620300643*^9}],

Cell[BoxData[
 GraphicsBox[
  RasterBox[
   NCache[{{{0, 0, 0}, {
      0, Rational[1, 800], Rational[1, 400] 799^Rational[1, 2]}, {
      0, Rational[1, 400], Rational[1, 200] 399^Rational[1, 2]}, {
      0, Rational[3, 800], Rational[1, 400] 2391^Rational[1, 2]}, {
      0, Rational[1, 200], Rational[1, 100] 199^Rational[1, 2]}, {
      0, Rational[1, 160], Rational[1, 80] 159^Rational[1, 2]}, {
      0, Rational[3, 400], Rational[1, 200] 1191^Rational[1, 2]}, {
      0, Rational[7, 800], Rational[1, 400] 5551^Rational[1, 2]}, {
      0, Rational[1, 100], Rational[3, 50] 11^Rational[1, 2]}, {
      0, Rational[9, 800], Rational[3, 400] 791^Rational[1, 2]}, {
      0, Rational[1, 80], Rational[1, 40] 79^Rational[1, 2]}, {
      0, Rational[11, 800], Rational[1, 400] 8679^Rational[1, 2]}, {
      0, Rational[3, 200], Rational[1, 100] 591^Rational[1, 2]}, {
      0, Rational[13, 800], Rational[1, 400] 10231^Rational[1, 2]}, {
      0, Rational[7, 400], Rational[1, 200] 2751^Rational[1, 2]}, {
      0, Rational[3, 160], Rational[1, 80] 471^Rational[1, 2]}, {
      0, Rational[1, 50], Rational[7, 25]}, {
      0, Rational[17, 800], Rational[3, 400] 1479^Rational[1, 2]}, {
      0, Rational[9, 400], Rational[3, 200] 391^Rational[1, 2]}, {
      0, Rational[19, 800], Rational[1, 400] 14839^Rational[1, 2]}, {
      0, Rational[1, 40], Rational[1, 20] 39^Rational[1, 2]}, {
      0, Rational[21, 800], Rational[1, 400] 16359^Rational[1, 2]}, {
      0, Rational[11, 400], Rational[1, 200] 4279^Rational[1, 2]}, {
      0, Rational[23, 800], Rational[1, 400] 17871^Rational[1, 2]}, {
      0, Rational[3, 100], Rational[1, 50] 291^Rational[1, 2]}, {
      0, Rational[1, 32], Rational[1, 16] 31^Rational[1, 2]}, {
      0, Rational[13, 400], Rational[3, 200] 559^Rational[1, 2]}, {
      0, Rational[27, 800], Rational[3, 400] 2319^Rational[1, 2]}, {
      0, Rational[7, 200], Rational[1, 100] 1351^Rational[1, 2]}, {
      0, Rational[29, 800], Rational[1, 400] 22359^Rational[1, 2]}, {
      0, Rational[3, 80], Rational[1, 40] 231^Rational[1, 2]}, {
      0, Rational[31, 800], Rational[1, 400] 23839^Rational[1, 2]}, {
      0, Rational[1, 25], Rational[4, 25] 6^Rational[1, 2]}, {
      0, Rational[33, 800], Rational[1, 400] 25311^Rational[1, 2]}, {
      0, Rational[17, 400], Rational[1, 200] 6511^Rational[1, 2]}, {
      0, Rational[7, 160], Rational[3, 80] 119^Rational[1, 2]}, {
      0, Rational[9, 200], Rational[3, 100] 191^Rational[1, 2]}, {
      0, Rational[37, 800], Rational[1, 400] 28231^Rational[1, 2]}, {
      0, Rational[19, 400], Rational[1, 200] 7239^Rational[1, 2]}, {
      0, Rational[39, 800], Rational[1, 400] 29679^Rational[1, 2]}, {
      0, Rational[1, 20], Rational[1, 10] 19^Rational[1, 2]}, {
      0, Rational[41, 800], Rational[1, 400] 31119^Rational[1, 2]}, {
      0, Rational[21, 400], Rational[1, 200] 7959^Rational[1, 2]}, {
      0, Rational[43, 800], Rational[1, 400] 32551^Rational[1, 2]}, {
      0, Rational[11, 200], Rational[3, 100] 231^Rational[1, 2]}, {
      0, Rational[9, 160], Rational[3, 80] 151^Rational[1, 2]}, {
      0, Rational[23, 400], Rational[1, 200] 8671^Rational[1, 2]}, {
      0, Rational[47, 800], Rational[1, 400] 35391^Rational[1, 2]}, {
      0, Rational[3, 50], Rational[1, 25] 141^Rational[1, 2]}, {
      0, Rational[49, 800], Rational[7, 400] 751^Rational[1, 2]}, {
      0, Rational[1, 16], Rational[1, 8] 15^Rational[1, 2]}, {
      0, Rational[51, 800], Rational[1, 400] 38199^Rational[1, 2]}, {
      0, Rational[13, 200], Rational[1, 100] 2431^Rational[1, 2]}, {
      0, Rational[53, 800], Rational[3, 400] 4399^Rational[1, 2]}, {
      0, Rational[27, 400], Rational[3, 200] 1119^Rational[1, 2]}, {
      0, Rational[11, 160], Rational[1, 80] 1639^Rational[1, 2]}, {
      0, Rational[7, 100], Rational[1, 50] 651^Rational[1, 2]}, {
      0, Rational[57, 800], Rational[1, 400] 42351^Rational[1, 2]}, {
      0, Rational[29, 400], Rational[1, 200] 10759^Rational[1, 2]}, {
      0, Rational[59, 800], Rational[1, 400] 43719^Rational[1, 2]}, {
      0, Rational[3, 40], Rational[1, 20] 111^Rational[1, 2]}, {
      0, Rational[61, 800], Rational[1, 400] 45079^Rational[1, 2]}, {
      0, Rational[31, 400], Rational[3, 200] 1271^Rational[1, 2]}, {
      0, Rational[63, 800], Rational[3, 400] 5159^Rational[1, 2]}, {
      0, Rational[2, 25], Rational[2, 25] 46^Rational[1, 2]}, {
      0, Rational[13, 160], Rational[7, 80] 39^Rational[1, 2]}, {
      0, Rational[33, 400], Rational[1, 200] 12111^Rational[1, 2]}, {
      0, Rational[67, 800], Rational[1, 400] 49111^Rational[1, 2]}, {
      0, Rational[17, 200], Rational[1, 100] 3111^Rational[1, 2]}, {
      0, Rational[69, 800], Rational[1, 400] 50439^Rational[1, 2]}, {
      0, Rational[7, 80], Rational[1, 40] 511^Rational[1, 2]}, {
      0, Rational[71, 800], Rational[27, 400] 71^Rational[1, 2]}, {
      0, Rational[9, 100], Rational[3, 50] 91^Rational[1, 2]}, {
      0, Rational[73, 800], Rational[1, 400] 53071^Rational[1, 2]}, {
      0, Rational[37, 400], Rational[11, 200] 111^Rational[1, 2]}, {
      0, Rational[3, 32], Rational[1, 16] 87^Rational[1, 2]}, {
      0, Rational[19, 200], Rational[1, 100] 3439^Rational[1, 2]}, {
      0, Rational[77, 800], Rational[1, 400] 55671^Rational[1, 2]}, {
      0, Rational[39, 400], Rational[19, 200] 39^Rational[1, 2]}, {
      0, Rational[79, 800], Rational[1, 400] 56959^Rational[1, 2]}, {
      0, Rational[1, 10], Rational[3, 5]}, {
      0, Rational[81, 800], Rational[9, 400] 719^Rational[1, 2]}, {
      0, Rational[41, 400], Rational[1, 200] 14719^Rational[1, 2]}, {
      0, Rational[83, 800], Rational[1, 400] 59511^Rational[1, 2]}, {
      0, Rational[21, 200], Rational[1, 100] 3759^Rational[1, 2]}, {
      0, Rational[17, 160], Rational[1, 80] 2431^Rational[1, 2]}, {
      0, Rational[43, 400], Rational[1, 200] 15351^Rational[1, 2]}, {
      0, Rational[87, 800], Rational[1, 400] 62031^Rational[1, 2]}, {
      0, Rational[11, 100], Rational[1, 50] 979^Rational[1, 2]}, {
      0, Rational[89, 800], Rational[3, 400] 7031^Rational[1, 2]}, {
      0, Rational[9, 80], Rational[3, 40] 71^Rational[1, 2]}, {
      0, Rational[91, 800], Rational[1, 400] 64519^Rational[1, 2]}, {
      0, Rational[23, 200], Rational[1, 100] 4071^Rational[1, 2]}, {
      0, Rational[93, 800], Rational[1, 400] 65751^Rational[1, 2]}, {
      0, Rational[47, 400], Rational[1, 200] 16591^Rational[1, 2]}, {
      0, Rational[19, 160], Rational[1, 80] 2679^Rational[1, 2]}, {
      0, Rational[3, 25], Rational[2, 25] 66^Rational[1, 2]}, {
      0, Rational[97, 800], Rational[1, 400] 68191^Rational[1, 2]}, {
      0, Rational[49, 400], Rational[21, 200] 39^Rational[1, 2]}, {
      0, Rational[99, 800], Rational[3, 400] 7711^Rational[1, 2]}, {
      0, Rational[1, 8], Rational[1, 4] 7^Rational[1, 2]}, {
      0, Rational[101, 800], Rational[1, 400] 70599^Rational[1, 2]}, {
      0, Rational[51, 400], Rational[1, 200] 17799^Rational[1, 2]}, {
      0, Rational[103, 800], Rational[1, 400] 71791^Rational[1, 2]}, {
      0, Rational[13, 100], Rational[1, 50] 1131^Rational[1, 2]}, {
      0, Rational[21, 160], Rational[1, 80] 2919^Rational[1, 2]}, {
      0, Rational[53, 400], Rational[1, 200] 18391^Rational[1, 2]}, {
      0, Rational[107, 800], Rational[3, 400] 8239^Rational[1, 2]}, {
      0, Rational[27, 200], Rational[3, 100] 519^Rational[1, 2]}, {
      0, Rational[109, 800], Rational[1, 400] 75319^Rational[1, 2]}, {
      0, Rational[11, 80], Rational[1, 40] 759^Rational[1, 2]}, {
      0, Rational[111, 800], Rational[1, 400] 76479^Rational[1, 2]}, {
      0, Rational[7, 50], Rational[1, 25] 301^Rational[1, 2]}, {
      0, Rational[113, 800], Rational[1, 400] 77631^Rational[1, 2]}, {
      0, Rational[57, 400], Rational[7, 200] 399^Rational[1, 2]}, {
      0, Rational[23, 160], Rational[1, 80] 3151^Rational[1, 2]}, {
      0, Rational[29, 200], Rational[3, 100] 551^Rational[1, 2]}, {
      0, Rational[117, 800], Rational[3, 400] 8879^Rational[1, 2]}, {
      0, Rational[59, 400], Rational[1, 200] 20119^Rational[1, 2]}, {
      0, Rational[119, 800], Rational[1, 400] 81039^Rational[1, 2]}, {
      0, Rational[3, 20], Rational[1, 10] 51^Rational[1, 2]}, {
      0, Rational[121, 800], Rational[11, 400] 679^Rational[1, 2]}, {
      0, Rational[61, 400], Rational[1, 200] 20679^Rational[1, 2]}, {
      0, Rational[123, 800], Rational[1, 400] 83271^Rational[1, 2]}, {
      0, Rational[31, 200], Rational[13, 100] 31^Rational[1, 2]}, {
      0, Rational[5, 32], Rational[3, 16] 15^Rational[1, 2]}, {
      0, Rational[63, 400], Rational[3, 200] 2359^Rational[1, 2]}, {
      0, Rational[127, 800], Rational[1, 400] 85471^Rational[1, 2]}, {
      0, Rational[4, 25], Rational[4, 25] 21^Rational[1, 2]}, {
      0, Rational[129, 800], Rational[1, 400] 86559^Rational[1, 2]}, {
      0, Rational[13, 80], Rational[1, 40] 871^Rational[1, 2]}, {
      0, Rational[131, 800], Rational[1, 400] 87639^Rational[1, 2]}, {
      0, Rational[33, 200], Rational[1, 100] 5511^Rational[1, 2]}, {
      0, Rational[133, 800], Rational[1, 400] 88711^Rational[1, 2]}, {
      0, Rational[67, 400], Rational[3, 200] 2479^Rational[1, 2]}, {
      0, Rational[27, 160], Rational[3, 80] 399^Rational[1, 2]}, {
      0, Rational[17, 100], Rational[1, 50] 1411^Rational[1, 2]}, {
      0, Rational[137, 800], Rational[1, 400] 90831^Rational[1, 2]}, {
      0, Rational[69, 400], Rational[1, 200] 22839^Rational[1, 2]}, {
      0, Rational[139, 800], Rational[1, 400] 91879^Rational[1, 2]}, {
      0, Rational[7, 40], Rational[1, 20] 231^Rational[1, 2]}, {
      0, Rational[141, 800], Rational[1, 400] 92919^Rational[1, 2]}, {
      0, Rational[71, 400], Rational[1, 200] 23359^Rational[1, 2]}, {
      0, Rational[143, 800], Rational[3, 400] 10439^Rational[1, 2]}, {
      0, Rational[9, 50], Rational[3, 25] 41^Rational[1, 2]}, {
      0, Rational[29, 160], Rational[1, 80] 3799^Rational[1, 2]}, {
      0, Rational[73, 400], Rational[1, 200] 23871^Rational[1, 2]}, {
      0, Rational[147, 800], Rational[7, 400] 1959^Rational[1, 2]}, {
      0, Rational[37, 200], Rational[1, 100] 6031^Rational[1, 2]}, {
      0, Rational[149, 800], Rational[1, 400] 96999^Rational[1, 2]}, {
      0, Rational[3, 16], Rational[1, 8] 39^Rational[1, 2]}, {
      0, Rational[151, 800], Rational[1, 400] 97999^Rational[1, 2]}, {
      0, Rational[19, 100], Rational[9, 50] 19^Rational[1, 2]}, {
      0, Rational[153, 800], Rational[3, 400] 10999^Rational[1, 2]}, {
      0, Rational[77, 400], Rational[1, 200] 24871^Rational[1, 2]}, {
      0, Rational[31, 160], Rational[1, 80] 3999^Rational[1, 2]}, {
      0, Rational[39, 200], Rational[1, 100] 6279^Rational[1, 2]}, {
      0, Rational[157, 800], Rational[1, 400] 100951^Rational[1, 2]}, {
      0, Rational[79, 400], Rational[1, 200] 25359^Rational[1, 2]}, {
      0, Rational[159, 800], Rational[1, 400] 101919^Rational[1, 2]}, {
      0, Rational[1, 5], Rational[4, 5]}, {
      0, Rational[161, 800], Rational[3, 400] 11431^Rational[1, 2]}, {
      0, Rational[81, 400], Rational[9, 200] 319^Rational[1, 2]}, {
      0, Rational[163, 800], Rational[7, 400] 2119^Rational[1, 2]}, {
      0, Rational[41, 200], Rational[1, 100] 6519^Rational[1, 2]}, {
      0, Rational[33, 160], Rational[1, 80] 4191^Rational[1, 2]}, {
      0, Rational[83, 400], Rational[1, 200] 26311^Rational[1, 2]}, {
      0, Rational[167, 800], Rational[1, 400] 105711^Rational[1, 2]}, {
      0, Rational[21, 100], Rational[1, 50] 1659^Rational[1, 2]}, {
      0, Rational[169, 800], Rational[13, 400] 631^Rational[1, 2]}, {
      0, Rational[17, 80], Rational[3, 40] 119^Rational[1, 2]}, {
      0, Rational[171, 800], Rational[3, 400] 11951^Rational[1, 2]}, {
      0, Rational[43, 200], Rational[1, 100] 6751^Rational[1, 2]}, {
      0, Rational[173, 800], Rational[1, 400] 108471^Rational[1, 2]}, {
      0, Rational[87, 400], Rational[1, 200] 27231^Rational[1, 2]}, {
      0, Rational[7, 32], Rational[5, 16] 7^Rational[1, 2]}, {
      0, Rational[11, 50], Rational[1, 25] 429^Rational[1, 2]}, {
      0, Rational[177, 800], Rational[1, 400] 110271^Rational[1, 2]}, {
      0, Rational[89, 400], Rational[1, 200] 27679^Rational[1, 2]}, {
      0, Rational[179, 800], Rational[3, 400] 12351^Rational[1, 2]}, {
      0, Rational[9, 40], Rational[3, 20] 31^Rational[1, 2]}, {
      0, Rational[181, 800], Rational[1, 400] 112039^Rational[1, 2]}, {
      0, Rational[91, 400], Rational[1, 200] 28119^Rational[1, 2]}, {
      0, Rational[183, 800], Rational[1, 400] 112911^Rational[1, 2]}, {
      0, Rational[23, 100], Rational[1, 50] 1771^Rational[1, 2]}, {
      0, Rational[37, 160], Rational[1, 80] 4551^Rational[1, 2]}, {
      0, Rational[93, 400], Rational[1, 200] 28551^Rational[1, 2]}, {
      0, Rational[187, 800], Rational[1, 400] 114631^Rational[1, 2]}, {
      0, Rational[47, 200], Rational[3, 100] 799^Rational[1, 2]}, {
      0, Rational[189, 800], Rational[3, 400] 12831^Rational[1, 2]}, {
      0, Rational[19, 80], Rational[1, 40] 1159^Rational[1, 2]}, {
      0, Rational[191, 800], Rational[1, 400] 116319^Rational[1, 2]}, {
      0, Rational[6, 25], Rational[2, 25] 114^Rational[1, 2]}, {
      0, Rational[193, 800], Rational[1, 400] 117151^Rational[1, 2]}, {
      0, Rational[97, 400], Rational[1, 200] 29391^Rational[1, 2]}, {
      0, Rational[39, 160], Rational[11, 80] 39^Rational[1, 2]}, {
      0, Rational[49, 200], Rational[7, 100] 151^Rational[1, 2]}, {
      0, Rational[197, 800], Rational[3, 400] 13199^Rational[1, 2]}, {
      0, Rational[99, 400], Rational[3, 200] 3311^Rational[1, 2]}, {
      0, Rational[199, 800], Rational[1, 400] 119599^Rational[1, 2]}, {
      0, Rational[1, 4], Rational[1, 2] 3^Rational[1, 2]}, {
      0, Rational[201, 800], Rational[1, 400] 120399^Rational[1, 2]}, {
      0, Rational[101, 400], Rational[1, 200] 30199^Rational[1, 2]}, {
      0, Rational[203, 800], Rational[1, 400] 121191^Rational[1, 2]}, {
      0, Rational[51, 200], Rational[1, 100] 7599^Rational[1, 2]}, {
      0, Rational[41, 160], Rational[1, 80] 4879^Rational[1, 2]}, {
      0, Rational[103, 400], Rational[3, 200] 3399^Rational[1, 2]}, {
      0, Rational[207, 800], Rational[3, 400] 13639^Rational[1, 2]}, {
      0, Rational[13, 50], Rational[1, 25] 481^Rational[1, 2]}, {
      0, Rational[209, 800], Rational[1, 400] 123519^Rational[1, 2]}, {
      0, Rational[21, 80], Rational[1, 40] 1239^Rational[1, 2]}, {
      0, Rational[211, 800], Rational[1, 400] 124279^Rational[1, 2]}, {
      0, Rational[53, 200], Rational[7, 100] 159^Rational[1, 2]}, {
      0, Rational[213, 800], Rational[1, 400] 125031^Rational[1, 2]}, {
      0, Rational[107, 400], Rational[1, 200] 31351^Rational[1, 2]}, {
      0, Rational[43, 160], Rational[3, 80] 559^Rational[1, 2]}, {
      0, Rational[27, 100], Rational[3, 50] 219^Rational[1, 2]}, {
      0, Rational[217, 800], Rational[1, 400] 126511^Rational[1, 2]}, {
      0, Rational[109, 400], Rational[1, 200] 31719^Rational[1, 2]}, {
      0, Rational[219, 800], Rational[1, 400] 127239^Rational[1, 2]}, {
      0, Rational[11, 40], Rational[1, 20] 319^Rational[1, 2]}, {
      0, Rational[221, 800], Rational[1, 400] 127959^Rational[1, 2]}, {
      0, Rational[111, 400], Rational[17, 200] 111^Rational[1, 2]}, {
      0, Rational[223, 800], Rational[1, 400] 128671^Rational[1, 2]}, {
      0, Rational[7, 25], Rational[6, 25] 14^Rational[1, 2]}, {
      0, Rational[9, 32], Rational[3, 16] 23^Rational[1, 2]}, {
      0, Rational[113, 400], Rational[1, 200] 32431^Rational[1, 2]}, {
      0, Rational[227, 800], Rational[1, 400] 130071^Rational[1, 2]}, {
      0, Rational[57, 200], Rational[1, 100] 8151^Rational[1, 2]}, {
      0, Rational[229, 800], Rational[1, 400] 130759^Rational[1, 2]}, {
      0, Rational[23, 80], Rational[1, 40] 1311^Rational[1, 2]}, {
      0, Rational[231, 800], Rational[1, 400] 131439^Rational[1, 2]}, {
      0, Rational[29, 100], Rational[1, 50] 2059^Rational[1, 2]}, {
      0, Rational[233, 800], Rational[9, 400] 1631^Rational[1, 2]}, {
      0, Rational[117, 400], Rational[3, 200] 3679^Rational[1, 2]}, {
      0, Rational[47, 160], Rational[1, 80] 5311^Rational[1, 2]}, {
      0, Rational[59, 200], Rational[1, 100] 8319^Rational[1, 2]}, {
      0, Rational[237, 800], Rational[1, 400] 133431^Rational[1, 2]}, {
      0, Rational[119, 400], Rational[1, 200] 33439^Rational[1, 2]}, {
      0, Rational[239, 800], Rational[1, 400] 134079^Rational[1, 2]}, {
      0, Rational[3, 10], Rational[1, 5] 21^Rational[1, 2]}, {
      0, Rational[241, 800], Rational[1, 400] 134719^Rational[1, 2]}, {
      0, Rational[121, 400], Rational[33, 200] 31^Rational[1, 2]}, {
      0, Rational[243, 800], Rational[9, 400] 1671^Rational[1, 2]}, {
      0, Rational[61, 200], Rational[1, 100] 8479^Rational[1, 2]}, {
      0, Rational[49, 160], Rational[7, 80] 111^Rational[1, 2]}, {
      0, Rational[123, 400], Rational[1, 200] 34071^Rational[1, 2]}, {
      0, Rational[247, 800], Rational[1, 400] 136591^Rational[1, 2]}, {
      0, Rational[31, 100], Rational[1, 50] 2139^Rational[1, 2]}, {
      0, Rational[249, 800], Rational[1, 400] 137199^Rational[1, 2]}, {
      0, Rational[5, 16], Rational[1, 8] 55^Rational[1, 2]}, {
      0, Rational[251, 800], Rational[3, 400] 15311^Rational[1, 2]}, {
      0, Rational[63, 200], Rational[3, 100] 959^Rational[1, 2]}, {
      0, Rational[253, 800], Rational[1, 400] 138391^Rational[1, 2]}, {
      0, Rational[127, 400], Rational[1, 200] 34671^Rational[1, 2]}, {
      0, Rational[51, 160], Rational[1, 80] 5559^Rational[1, 2]}, {
      0, Rational[8, 25], Rational[4, 25] 34^Rational[1, 2]}, {
      0, Rational[257, 800], Rational[1, 400] 139551^Rational[1, 2]}, {
      0, Rational[129, 400], Rational[1, 200] 34959^Rational[1, 2]}, {
      0, Rational[259, 800], Rational[1, 400] 140119^Rational[1, 2]}, {
      0, Rational[13, 40], Rational[3, 20] 39^Rational[1, 2]}, {
      0, Rational[261, 800], Rational[21, 400] 319^Rational[1, 2]}, {
      0, Rational[131, 400], Rational[1, 200] 35239^Rational[1, 2]}, {
      0, Rational[263, 800], Rational[1, 400] 141231^Rational[1, 2]}, {
      0, Rational[33, 100], Rational[1, 50] 2211^Rational[1, 2]}, {
      0, Rational[53, 160], Rational[1, 80] 5671^Rational[1, 2]}, {
      0, Rational[133, 400], Rational[1, 200] 35511^Rational[1, 2]}, {
      0, Rational[267, 800], Rational[1, 400] 142311^Rational[1, 2]}, {
      0, Rational[67, 200], Rational[1, 100] 8911^Rational[1, 2]}, {
      0, Rational[269, 800], Rational[3, 400] 15871^Rational[1, 2]}, {
      0, Rational[27, 80], Rational[3, 40] 159^Rational[1, 2]}, {
      0, Rational[271, 800], Rational[23, 400] 271^Rational[1, 2]}, {
      0, Rational[17, 50], Rational[1, 25] 561^Rational[1, 2]}, {
      0, Rational[273, 800], Rational[1, 400] 143871^Rational[1, 2]}, {
      0, Rational[137, 400], Rational[1, 200] 36031^Rational[1, 2]}, {
      0, Rational[11, 32], Rational[1, 16] 231^Rational[1, 2]}, {
      0, Rational[69, 200], Rational[1, 100] 9039^Rational[1, 2]}, {
      0, Rational[277, 800], Rational[1, 400] 144871^Rational[1, 2]}, {
      0, Rational[139, 400], Rational[3, 200] 4031^Rational[1, 2]}, {
      0, Rational[279, 800], Rational[3, 400] 16151^Rational[1, 2]}, {
      0, Rational[7, 20], Rational[1, 10] 91^Rational[1, 2]}, {
      0, Rational[281, 800], Rational[1, 400] 145839^Rational[1, 2]}, {
      0, Rational[141, 400], Rational[1, 200] 36519^Rational[1, 2]}, {
      0, Rational[283, 800], Rational[1, 400] 146311^Rational[1, 2]}, {
      0, Rational[71, 200], Rational[1, 100] 9159^Rational[1, 2]}, {
      0, Rational[57, 160], Rational[1, 80] 5871^Rational[1, 2]}, {
      0, Rational[143, 400], Rational[1, 200] 36751^Rational[1, 2]}, {
      0, Rational[287, 800], Rational[3, 400] 16359^Rational[1, 2]}, {
      0, Rational[9, 25], Rational[24, 25]}, {
      0, Rational[289, 800], Rational[17, 400] 511^Rational[1, 2]}, {
      0, Rational[29, 80], Rational[1, 40] 1479^Rational[1, 2]}, {
      0, Rational[291, 800], Rational[1, 400] 148119^Rational[1, 2]}, {
      0, Rational[73, 200], Rational[1, 100] 9271^Rational[1, 2]}, {
      0, Rational[293, 800], Rational[13, 400] 879^Rational[1, 2]}, {
      0, Rational[147, 400], Rational[7, 200] 759^Rational[1, 2]}, {
      0, Rational[59, 160], Rational[1, 80] 5959^Rational[1, 2]}, {
      0, Rational[37, 100], Rational[3, 50] 259^Rational[1, 2]}, {
      0, Rational[297, 800], Rational[3, 400] 16599^Rational[1, 2]}, {
      0, Rational[149, 400], Rational[1, 200] 37399^Rational[1, 2]}, {
      0, Rational[299, 800], Rational[1, 400] 149799^Rational[1, 2]}, {
      0, Rational[3, 8], Rational[1, 4] 15^Rational[1, 2]}, {
      0, Rational[301, 800], Rational[1, 400] 150199^Rational[1, 2]}, {
      0, Rational[151, 400], Rational[1, 200] 37599^Rational[1, 2]}, {
      0, Rational[303, 800], Rational[1, 400] 150591^Rational[1, 2]}, {
      0, Rational[19, 50], Rational[1, 25] 589^Rational[1, 2]}, {
      0, Rational[61, 160], Rational[3, 80] 671^Rational[1, 2]}, {
      0, Rational[153, 400], Rational[3, 200] 4199^Rational[1, 2]}, {
      0, Rational[307, 800], Rational[1, 400] 151351^Rational[1, 2]}, {
      0, Rational[77, 200], Rational[1, 100] 9471^Rational[1, 2]}, {
      0, Rational[309, 800], Rational[1, 400] 151719^Rational[1, 2]}, {
      0, Rational[31, 80], Rational[7, 40] 31^Rational[1, 2]}, {
      0, Rational[311, 800], Rational[1, 400] 152079^Rational[1, 2]}, {
      0, Rational[39, 100], Rational[1, 50] 2379^Rational[1, 2]}, {
      0, Rational[313, 800], Rational[1, 400] 152431^Rational[1, 2]}, {
      0, Rational[157, 400], Rational[9, 200] 471^Rational[1, 2]}, {
      0, Rational[63, 160], Rational[3, 80] 679^Rational[1, 2]}, {
      0, Rational[79, 200], Rational[11, 100] 79^Rational[1, 2]}, {
      0, Rational[317, 800], Rational[1, 400] 153111^Rational[1, 2]}, {
      0, Rational[159, 400], Rational[1, 200] 38319^Rational[1, 2]}, {
      0, Rational[319, 800], Rational[1, 400] 153439^Rational[1, 2]}, {
      0, Rational[2, 5], Rational[2, 5] 6^Rational[1, 2]}, {
      0, Rational[321, 800], Rational[1, 400] 153759^Rational[1, 2]}, {
      0, Rational[161, 400], Rational[1, 200] 38479^Rational[1, 2]}, {
      0, Rational[323, 800], Rational[3, 400] 17119^Rational[1, 2]}, {
      0, Rational[81, 200], Rational[9, 100] 119^Rational[1, 2]}, {
      0, Rational[13, 32], Rational[1, 16] 247^Rational[1, 2]}, {
      0, Rational[163, 400], Rational[1, 200] 38631^Rational[1, 2]}, {
      0, Rational[327, 800], Rational[1, 400] 154671^Rational[1, 2]}, {
      0, Rational[41, 100], Rational[1, 50] 2419^Rational[1, 2]}, {
      0, Rational[329, 800], Rational[1, 400] 154959^Rational[1, 2]}, {
      0, Rational[33, 80], Rational[1, 40] 1551^Rational[1, 2]}, {
      0, Rational[331, 800], Rational[1, 400] 155239^Rational[1, 2]}, {
      0, Rational[83, 200], Rational[3, 100] 1079^Rational[1, 2]}, {
      0, Rational[333, 800], Rational[3, 400] 17279^Rational[1, 2]}, {
      0, Rational[167, 400], Rational[1, 200] 38911^Rational[1, 2]}, {
      0, Rational[67, 160], Rational[1, 80] 6231^Rational[1, 2]}, {
      0, Rational[21, 50], Rational[1, 25] 609^Rational[1, 2]}, {
      0, Rational[337, 800], Rational[1, 400] 156031^Rational[1, 2]}, {
      0, Rational[169, 400], Rational[13, 200] 231^Rational[1, 2]}, {
      0, Rational[339, 800], Rational[1, 400] 156279^Rational[1, 2]}, {
      0, Rational[17, 40], Rational[1, 20] 391^Rational[1, 2]}, {
      0, Rational[341, 800], Rational[3, 400] 17391^Rational[1, 2]}, {
      0, Rational[171, 400], Rational[3, 200] 4351^Rational[1, 2]}, {
      0, Rational[343, 800], Rational[7, 400] 3199^Rational[1, 2]}, {
      0, Rational[43, 100], Rational[1, 50] 2451^Rational[1, 2]}, {
      0, Rational[69, 160], Rational[1, 80] 6279^Rational[1, 2]}, {
      0, Rational[173, 400], Rational[1, 200] 39271^Rational[1, 2]}, {
      0, Rational[347, 800], Rational[1, 400] 157191^Rational[1, 2]}, {
      0, Rational[87, 200], Rational[1, 100] 9831^Rational[1, 2]}, {
      0, Rational[349, 800], Rational[1, 400] 157399^Rational[1, 2]}, {
      0, Rational[7, 16], Rational[3, 8] 7^Rational[1, 2]}, {
      0, Rational[351, 800], Rational[3, 400] 17511^Rational[1, 2]}, {
      0, Rational[11, 25], Rational[2, 25] 154^Rational[1, 2]}, {
      0, Rational[353, 800], Rational[1, 400] 157791^Rational[1, 2]}, {
      0, Rational[177, 400], Rational[1, 200] 39471^Rational[1, 2]}, {
      0, Rational[71, 160], Rational[1, 80] 6319^Rational[1, 2]}, {
      0, Rational[89, 200], Rational[1, 100] 9879^Rational[1, 2]}, {
      0, Rational[357, 800], Rational[1, 400] 158151^Rational[1, 2]}, {
      0, Rational[179, 400], Rational[1, 200] 39559^Rational[1, 2]}, {
      0, Rational[359, 800], Rational[21, 400] 359^Rational[1, 2]}, {
      0, Rational[9, 20], Rational[3, 10] 11^Rational[1, 2]}, {
      0, Rational[361, 800], Rational[19, 400] 439^Rational[1, 2]}, {
      0, Rational[181, 400], Rational[1, 200] 39639^Rational[1, 2]}, {
      0, Rational[363, 800], Rational[11, 400] 1311^Rational[1, 2]}, {
      0, Rational[91, 200], Rational[1, 100] 9919^Rational[1, 2]}, {
      0, Rational[73, 160], Rational[1, 80] 6351^Rational[1, 2]}, {
      0, Rational[183, 400], Rational[1, 200] 39711^Rational[1, 2]}, {
      0, Rational[367, 800], Rational[1, 400] 158911^Rational[1, 2]}, {
      0, Rational[23, 50], Rational[3, 25] 69^Rational[1, 2]}, {
      0, Rational[369, 800], Rational[3, 400] 17671^Rational[1, 2]}, {
      0, Rational[37, 80], Rational[1, 40] 1591^Rational[1, 2]}, {
      0, Rational[371, 800], Rational[1, 400] 159159^Rational[1, 2]}, {
      0, Rational[93, 200], Rational[1, 100] 9951^Rational[1, 2]}, {
      0, Rational[373, 800], Rational[1, 400] 159271^Rational[1, 2]}, {
      0, Rational[187, 400], Rational[1, 200] 39831^Rational[1, 2]}, {
      0, Rational[15, 32], Rational[1, 16] 255^Rational[1, 2]}, {
      0, Rational[47, 100], Rational[1, 50] 2491^Rational[1, 2]}, {
      0, Rational[377, 800], Rational[3, 400] 17719^Rational[1, 2]}, {
      0, Rational[189, 400], Rational[3, 200] 4431^Rational[1, 2]}, {
      0, Rational[379, 800], Rational[1, 400] 159559^Rational[1, 2]}, {
      0, Rational[19, 40], Rational[1, 20] 399^Rational[1, 2]}, {
      0, Rational[381, 800], Rational[1, 400] 159639^Rational[1, 2]}, {
      0, Rational[191, 400], Rational[1, 200] 39919^Rational[1, 2]}, {
      0, Rational[383, 800], Rational[1, 400] 159711^Rational[1, 2]}, {
      0, Rational[12, 25], Rational[4, 25] 39^Rational[1, 2]}, {
      0, Rational[77, 160], Rational[1, 80] 6391^Rational[1, 2]}, {
      0, Rational[193, 400], Rational[3, 200] 4439^Rational[1, 2]}, {
      0, Rational[387, 800], Rational[3, 400] 17759^Rational[1, 2]}, {
      0, Rational[97, 200], Rational[1, 100] 9991^Rational[1, 2]}, {
      0, Rational[389, 800], Rational[1, 400] 159879^Rational[1, 2]}, {
      0, Rational[39, 80], Rational[1, 40] 1599^Rational[1, 2]}, {
      0, Rational[391, 800], Rational[1, 400] 159919^Rational[1, 2]}, {
      0, Rational[49, 100], Rational[7, 50] 51^Rational[1, 2]}, {
      0, Rational[393, 800], Rational[1, 400] 159951^Rational[1, 2]}, {
      0, Rational[197, 400], Rational[1, 200] 39991^Rational[1, 2]}, {
      0, Rational[79, 160], Rational[9, 80] 79^Rational[1, 2]}, {
      0, Rational[99, 200], Rational[3, 100] 1111^Rational[1, 2]}, {
      0, Rational[397, 800], Rational[1, 400] 159991^Rational[1, 2]}, {
      0, Rational[199, 400], Rational[1, 200] 39999^Rational[1, 2]}, {
      0, Rational[399, 800], Rational[1, 400] 159999^Rational[1, 2]}, {
      0, Rational[1, 2], 1}, {0, 0.5030107112554686, 0.9999939449006108}, {
      0, 0.5053601052859211, 0.9999807772438751}, {
      0, 0.5075091287703752, 0.9999622185680237}, {
      0, 0.5095366331194746, 0.9999389779735858}, {
      0, 0.5114776969638323, 0.9999114925178486}, {
      0, 0.5133520853953788, 0.9998800707513334}, {
      0, 0.5151724228995019, 0.9998449473450536}, {
      0, 0.5169474383326078, 0.9998063095068447}, {
      0, 0.5186835084938362, 0.9997643116507248}, {
      0, 0.5203854847967883, 0.9997190843292335}, {
      0, 0.5220571751337896, 0.9996707400456819}, {
      0, 0.5237016432811604, 0.9996193772313285}, {
      0, 0.5253214044819132, 0.9995650830766676}, {
      0, 0.5269185584678272, 0.9995079356124442}, {
      0, 0.5284948829913498, 0.9994480052801225}, {
      0, 0.5300519014518561, 0.999385356143639}, {
      0, 0.5315909329672844, 0.999320046842221}, {
      0, 0.5331131302155144, 0.9992521313519253}, {
      0, 0.534619508547993, 0.9991816596030143}, {
      0, 0.5361109687429949, 0.9991086779867676}, {
      0, 0.5375883150372486, 0.9990332297761686}, {
      0, 0.5390522695943267, 0.9989553554785835}, {
      0, 0.540503484244191, 0.9988750931340687}, {
      0, 0.5419425501050132, 0.9987924785697279}, {
      0, 0.5433700055417787, 0.9987075456181834}, {
      0, 0.5447863428042896, 0.99862032630648}, {
      0, 0.546192013606148, 0.9985308510204207}, {
      0, 0.547587433846693, 0.9984391486483352}, {
      0, 0.5489729876335138, 0.9983452467075059}, {
      0, 0.5503490307297004, 0.9982491714558789}, {
      0, 0.5517158935245917, 0.9981509479912092}, {
      0, 0.5530738836071235, 0.998050600339421}, {
      0, 0.5544232880057427, 0.9979481515336582}, {
      0, 0.5557643751468796, 0.997843623685263}, {
      0, 0.5570973965746097, 0.9977370380477212}, {
      0, 0.5584225884666104, 0.9976284150744555}, {
      0, 0.5597401729755543, 0.997517774471214}, {
      0, 0.5610503594202167, 0.997405135243693}, {
      0, 0.5623533453466495, 0.9972905157409434}, {
      0, 0.5636493174765815, 0.9971739336950337}, {
      0, 0.5649384525575399, 0.9970554062573778}, {
      0, 0.5662209181270422, 0.9969349500320833}, {
      0, 0.5674968732013819, 0.9968125811066331}, {
      0, 0.568766468898031, 0.9966883150801653}, {
      0, 0.5700298489994294, 0.9965621670895977}, {
      0, 0.5712871504648581, 0.9964341518337982}, {
      0, 0.572538503896203, 0.9963042835959935}, {
      0, 0.5737840339626679, 0.9961725762645741}, {
      0, 0.5750238597888176, 0.9960390433524455}, {
      0, 0.576258095309825, 0.9959036980150533}, {
      0, 0.5774868495972767, 0.9957665530671973}, {
      0, 0.5787102271585189, 0.9956276209987409}, {
      0, 0.5799283282121569, 0.9954869139893048}, {
      0, 0.581141248942029, 0.995344443922031}, {
      0, 0.5823490817316908, 0.9952002223964926}, {
      0, 0.5835519153812517, 0.9950542607408154}, {
      0, 0.5847498353081731, 0.9949065700230729}, {
      0, 0.5859429237334736, 0.9947571610620122}, {
      0, 0.5871312598546455, 0.9946060444371586}, {
      0, 0.5883149200064349, 0.9944532304983466}, {
      0, 0.5894939778105217, 0.9942987293747175}, {
      0, 0.5906685043150443, 0.994142550983224}, {
      0, 0.5918385681248077, 0.9939847050366726}, {
      0, 0.5930042355229321, 0.9938252010513405}, {
      0, 0.5941655705846323, 0.9936640483541923}, {
      0, 0.595322635283757, 0.9935012560897245}, {
      0, 0.5964754895926375, 0.993336833226463}, {
      0, 0.5976241915757732, 0.9931707885631357}, {
      0, 0.5987687974778148, 0.9930031307345396}, {
      0, 0.599909361806267, 0.9928338682171256}, {
      0, 0.6010459374093023, 0.9926630093343128}, {
      0, 0.6021785755490422, 0.9924905622615551}, {
      0, 0.6033073259706228, 0.9923165350311689}, {
      0, 0.6044322369673453, 0.9921409355369427}, {
      0, 0.605553355442186, 0.9919637715385354}, {
      0, 0.6066707269659115, 0.9917850506656789}, {
      0, 0.6077843958320296, 0.991604780422196}, {
      0, 0.6088944051087886, 0.9914229681898429}, {
      0, 0.6100007966884143, 0.9912396212319876}, {
      0, 0.6111036113337772, 0.9910547466971309}, {
      0, 0.6122028887226381, 0.990868351622281}, {
      0, 0.6132986674896362, 0.9906804429361892}, {
      0, 0.614390985266163, 0.9904910274624518}, {
      0, 0.6154798787182444, 0.9903001119224878}, {
      0, 0.6165653835825587, 0.9901077029383986}, {
      0, 0.617647534700705, 0.9899138070357131}, {
      0, 0.6187263660518166, 0.9897184306460285}, {
      0, 0.6198019107836347, 0.9895215801095465}, {
      0, 0.6208742012421081, 0.9893232616775162}, {
      0, 0.6219432689996323, 0.9891234815145818}, {
      0, 0.6230091448819781, 0.9889222457010464}, {
      0, 0.624071858994007, 0.9887195602350487}, {
      0, 0.6251314407442218, 0.9885154310346647}, {
      0, 0.626187918868233, 0.9883098639399297}, {
      0, 0.6272413214511889, 0.9881028647147914}, {
      0, 0.6282916759492315, 0.9878944390489923}, {
      0, 0.6293390092100261, 0.9876845925598873}, {
      0, 0.6303833474924172, 0.9874733307941983}, {
      0, 0.6314247164852583, 0.9872606592297088}, {
      0, 0.6324631413254498, 0.9870465832769016}, {
      0, 0.6334986466152337, 0.9868311082805412}, {
      0, 0.6345312564387838, 0.9866142395212035}, {
      0, 0.6355609943781174, 0.9863959822167568}, {
      0, 0.636587883528373, 0.9861763415237923}, {
      0, 0.6376119465124815, 0.9859553225390106}, {
      0, 0.6386332054952527, 0.9857329303005635}, {
      0, 0.6396516821969236, 0.9855091697893524}, {
      0, 0.6406673979061734, 0.9852840459302874}, {
      0, 0.6416803734926485, 0.9850575635935063}, {
      0, 0.6426906294190053, 0.9848297275955569}, {
      0, 0.6436981857525059, 0.9846005427005436}, {
      0, 0.6447030621761795, 0.9843700136212384}, {
      0, 0.6457052779995751, 0.9841381450201588}, {
      0, 0.646704852169116, 0.983904941510615}, {
      0, 0.6477018032780834, 0.983670407657725}, {
      0, 0.648696149576239, 0.9834345479794007}, {
      0, 0.6496879089791071, 0.9831973669473053}, {
      0, 0.6506770990769258, 0.9829588689877842}, {
      0, 0.6516637371432863, 0.9827190584827682}, {
      0, 0.6526478401434738, 0.9824779397706518}, {
      0, 0.6536294247425196, 0.9822355171471474}, {
      0, 0.654608507312978, 0.9819917948661153}, {
      0, 0.6555851039424394, 0.9817467771403714}, {
      0, 0.6565592304407954, 0.9815004681424725}, {
      0, 0.6575309023472551, 0.9812528720054803}, {
      0, 0.6585001349371362, 0.9810039928237054}, {
      0, 0.6594669432284272, 0.980753834653432}, {
      0, 0.6604313419881415, 0.9805024015136216}, {
      0, 0.6613933457384648, 0.9802496973865998}, {
      0, 0.662352968762703, 0.979995726218726}, {
      0, 0.6633102251110441, 0.9797404919210436}, {
      0, 0.6642651286061404, 0.9794839983699152}, {
      0, 0.6652176928485083, 0.9792262494076418}, {
      0, 0.6661679312217701, 0.978967248843065}, {
      0, 0.6671158568977272, 0.9787070004521552}, {
      0, 0.6680614828412808, 0.9784455079785862}, {
      0, 0.669004821815204, 0.9781827751342929}, {
      0, 0.6699458863847677, 0.9779188056000175}, {
      0, 0.6708846889222305, 0.9776536030258429}, {
      0, 0.6718212416111929, 0.9773871710317106}, {
      0, 0.6727555564508254, 0.977119513207929}, {
      0, 0.6736876452599717, 0.976850633115668}, {
      0, 0.674617519681131, 0.9765805342874427}, {
      0, 0.6755451911843294, 0.9763092202275852}, {
      0, 0.6764706710708753, 0.9760366944127057}, {
      0, 0.6773939704770116, 0.9757629602921435}, {
      0, 0.6783151003774636, 0.9754880212884062}, {
      0, 0.6792340715888872, 0.9752118807976004}, {
      0, 0.6801508947732188, 0.9749345421898519}, {
      0, 0.681065580440937, 0.9746560088097165}, {
      0, 0.6819781389542305, 0.9743762839765817}, {
      0, 0.6828885805300802, 0.9740953709850599}, {
      0, 0.6837969152432595, 0.9738132731053719}, {
      0, 0.684703153029252, 0.9735299935837226}, {
      0, 0.6856073036870899, 0.9732455356426695}, {
      0, 0.6865093768821199, 0.9729599024814811}, {
      0, 0.687409382148694, 0.9726730972764893}, {
      0, 0.6883073288927882, 0.9723851231814341}, {
      0, 0.6892032263945567, 0.9720959833278}, {
      0, 0.6900970838108155, 0.9718056808251461}, {
      0, 0.6909889101774646, 0.9715142187614296}, {
      0, 0.6918787144118481, 0.9712216002033214}, {
      0, 0.6927665053150518, 0.9709278281965164}, {
      0, 0.693652291574146, 0.9706329057660364}, {
      0, 0.6945360817643688, 0.9703368359165278}, {
      0, 0.6954178843512564, 0.9700396216325524}, {
      0, 0.696297707692721, 0.9697412658788728}, {
      0, 0.6971755600410757, 0.9694417716007316}, {
      0, 0.6980514495450105, 0.9691411417241258}, {
      0, 0.6989253842515195, 0.9688393791560752}, {
      0, 0.6997973721077829, 0.9685364867848854}, {
      0, 0.7006674209630018, 0.9682324674804057}, {
      0, 0.70153553857019, 0.967927324094283}, {
      0, 0.7024017325879219, 0.9676210594602086}, {
      0, 0.7032660105820403, 0.9673136763941629}, {
      0, 0.7041283800273239, 0.9670051776946526}, {
      0, 0.7049888483091143, 0.9666955661429464}, {
      0, 0.7058474227249062, 0.9663848445033031}, {
      0, 0.7067041104859002, 0.9660730155231981}, {
      0, 0.7075589187185208, 0.9657600819335443}, {
      0, 0.7084118544658985, 0.9654460464489083}, {
      0, 0.7092629246893183, 0.9651309117677244}, {
      0, 0.7101121362696349, 0.9648146805725031}, {
      0, 0.7109594960086582, 0.9644973555300361}, {
      0, 0.7118050106305044, 0.9641789392915987}, {
      0, 0.7126486867829205, 0.9638594344931465}, {
      0, 0.7134905310385757, 0.9635388437555101}, {
      0, 0.7143305498963282, 0.9632171696845861}, {
      0, 0.7151687497824595, 0.9628944148715239}, {
      0, 0.7160051370518876, 0.9625705818929103}, {
      0, 0.7168397179893483, 0.96224567331095}, {
      0, 0.7176724988105551, 0.9619196916736424}, {
      0, 0.7185034856633304, 0.961592639514958}, {
      0, 0.7193326846287167, 0.9612645193550077}, {
      0, 0.7201601017220606, 0.9609353337002123}, {
      0, 0.7209857428940761, 0.9606050850434686}, {
      0, 0.721809614031884, 0.9602737758643108}, {
      0, 0.722631720960031, 0.9599414086290716}, {
      0, 0.7234520694414859, 0.9596079857910388}, {
      0, 0.7242706651786166, 0.95927350979061}, {
      0, 0.7250875138141463, 0.9589379830554449}, {
      0, 0.7259026209320899, 0.9586014080006142}, {
      0, 0.7267159920586722, 0.958263787028747}, {
      0, 0.7275276326632255, 0.9579251225301754}, {
      0, 0.7283375481590711, 0.957585416883076}, {
      0, 0.7291457439043826, 0.9572446724536099}, {
      0, 0.7299522252030304, 0.9569028915960613}, {
      0, 0.7307569973054117, 0.9565600766529713}, {
      0, 0.7315600654092618, 0.9562162299552716}, {
      0, 0.732361434660451, 0.9558713538224157}, {
      0, 0.7331611101537656, 0.9555254505625076}, {
      0, 0.733959096933672, 0.9551785224724283}, {
      0, 0.7347553999950683, 0.9548305718379613}, {
      0, 0.7355500242840206, 0.9544816009339145}, {
      0, 0.7363429746984834, 0.9541316120242417}, {
      0, 0.7371342560890082, 0.9537806073621615}, {
      0, 0.7379238732594382, 0.9534285891902748}, {
      0, 0.738711830967589, 0.9530755597406794}, {
      0, 0.7394981339259165, 0.9527215212350837}, {
      0, 0.7402827868021737, 0.9523664758849194}, {
      0, 0.7410657942200536, 0.95201042589145}, {
      0, 0.7418471607598198, 0.951653373445881}, {
      0, 0.7426268909589273, 0.951295320729465}, {
      0, 0.7434049893126293, 0.9509362699136084}, {
      0, 0.7441814602745757, 0.9505762231599738}, {
      0, 0.7449563082573979, 0.9502151826205826}, {
      0, 0.7457295376332846, 0.9498531504379152}, {
      0, 0.746501152734547, 0.9494901287450103}, {
      0, 0.7472711578541718, 0.9491261196655624}, {
      0, 0.7480395572463682, 0.9487611253140178}, {
      0, 0.7488063551271007, 0.9483951477956694}, {
      0, 0.7495715556746158, 0.9480281892067497}, {
      0, 0.7503351630299563, 0.9476602516345236}, {
      0, 0.7510971812974705, 0.9472913371573779}, {
      0, 0.7518576145453075, 0.9469214478449117}, {
      0, 0.7526164668059078, 0.946550585758024}, {
      0, 0.7533737420764837, 0.946178752949}, {
      0, 0.7541294443194914, 0.9458059514615973}, {
      0, 0.7548835774630939, 0.9454321833311308}, {
      0, 0.7556361454016189, 0.9450574505845539}, {
      0, 0.7563871519960066, 0.9446817552405427}, {
      0, 0.7571366010742472, 0.9443050993095758}, {
      0, 0.7578844964318188, 0.9439274847940136}, {
      0, 0.7586308418321087, 0.9435489136881775}, {
      0, 0.7593756410068335, 0.943169387978428}, {
      0, 0.7601188976564512, 0.9427889096432392}, {
      0, 0.7608606154505642, 0.942407480653277}, {
      0, 0.7616007980283181, 0.9420251029714704}, {
      0, 0.7623394489987909, 0.9416417785530876}, {
      0, 0.7630765719413801, 0.9412575093458067}, {
      0, 0.7638121704061797, 0.9408722972897873}, {
      0, 0.7645462479143511, 0.9404861443177416}, {
      0, 0.7652788079584907, 0.9400990523550032}, {
      0, 0.7660098540029893, 0.9397110233195961}, {
      0, 0.7667393894843857, 0.9393220591223018}, {
      0, 0.7674674178117153, 0.9389321616667272}, {
      0, 0.7681939423668531, 0.9385413328493686}, {
      0, 0.7689189665048505, 0.9381495745596784}, {
      0, 0.7696424935542673, 0.9377568886801289}, {
      0, 0.770364526817498, 0.9373632770862742}, {
      0, 0.7710850695710935, 0.9369687416468152}, {
      0, 0.771804125066077, 0.936573284223659}, {
      0, 0.7725216965282554, 0.9361769066719811}, {
      0, 0.7732377871585256, 0.9357796108402847}, {
      0, 0.7739524001331765, 0.9353813985704605}, {
      0, 0.7746655386041851, 0.9349822716978455}, {
      0, 0.7753772056995091, 0.9345822320512802}, {
      0, 0.7760874045233748, 0.9341812814531663}, {
      0, 0.7767961381565605, 0.9337794217195218}, {
      0, 0.7775034096566747, 0.9333766546600392}, {
      0, 0.778209222058432, 0.9329729820781377}, {
      0, 0.7789135783739224, 0.932568405771019}, {
      0, 0.7796164815928784, 0.9321629275297205}, {
      0, 0.7803179346829373, 0.9317565491391687}, {
      0, 0.7810179405898986, 0.9313492723782307}, {
      0, 0.781716502237981, 0.9309410990197663}, {
      0, 0.7824136225300693, 0.9305320308306791}, {
      0, 0.7831093043479656, 0.9301220695719665}, {
      0, 0.7838035505526287, 0.9297112169987701}, {
      0, 0.784496363984417, 0.9292994748604241}, {
      0, 0.7851877474633225, 0.9288868449005041}, {
      0, 0.7858777037892044, 0.9284733288568754}, {
      0, 0.786566235742018, 0.9280589284617408}, {
      0, 0.7872533460820409, 0.9276436454416855}, {
      0, 0.7879390375500952, 0.9272274815177264}, {
      0, 0.7886233128677679, 0.9268104384053546}, {
      0, 0.7893061747376258, 0.9263925178145833}, {
      0, 0.7899876258434294, 0.9259737214499907}, {
      0, 0.7906676688503427, 0.9255540510107648}, {
      0, 0.7913463064051407, 0.9251335081907469}, {
      0, 0.7920235411364122, 0.9247120946784751}, {
      0, 0.7926993756547631, 0.924289812157226}, {
      0, 0.7933738125530123, 0.9238666623050578}, {
      0, 0.7940468544063899, 0.923442646794851}, {
      0, 0.7947185037727269, 0.9230177672943503}, {
      0, 0.7953887631926486, 0.9225920254662044}, {
      0, 0.7960576351897592, 0.9221654229680077}, {
      0, 0.7967251222708284, 0.9217379614523379}, {
      0, 0.7973912269259728, 0.9213096425667973}, {
      0, 0.798055951628836, 0.92088046795405}, {
      0, 0.7987192988367662, 0.9204504392518617}, {
      0, 0.7993812709909894, 0.9200195580931365}, {
      0, 0.8000418705167847, 0.9195878261059552}, {
      0, 0.8007010998236509, 0.9191552449136121}, {
      0, 0.8013589613054771, 0.9187218161346518}, {
      0, 0.8020154573407071, 0.9182875413829049}, {
      0, 0.8026705902925023, 0.9178524222675253}, {
      0, 0.8033243625089032, 0.9174164603930238}, {
      0, 0.803976776322988, 0.9169796573593049}, {
      0, 0.80462783405303, 0.9165420147617002}, {
      0, 0.8052775380026509, 0.9161035341910041}, {
      0, 0.8059258904609755, 0.9156642172335059}, {
      0, 0.8065728937027798, 0.9152240654710251}, {
      0, 0.8072185499886416, 0.914783080480944}, {
      0, 0.8078628615650861, 0.91434126383624}, {
      0, 0.8085058306647308, 0.913898617105519}, {
      0, 0.8091474595064284, 0.9134551418530469}, {
      0, 0.8097877502954075, 0.9130108396387813}, {
      0, 0.8104267052234119, 0.9125657120184043}, {
      0, 0.8110643264688382, 0.9121197605433519}, {
      0, 0.8117006161968705, 0.9116729867608451}, {
      0, 0.812335576559615, 0.9112253922139216}, {
      0, 0.8129692096962313, 0.9107769784414647}, {
      0, 0.8136015177330636, 0.9103277469782333}, {
      0, 0.8142325027837681, 0.9098776993548924}, {
      0, 0.814862166949442, 0.9094268370980406}, {
      0, 0.8154905123187471, 0.9089751617302408}, {
      0, 0.8161175409680343, 0.9085226747700471}, {
      0, 0.8167432549614663, 0.9080693777320344}, {
      0, 0.8173676563511373, 0.9076152721268261}, {
      0, 0.8179907471771936, 0.9071603594611213}, {
      0, 0.8186125294679496, 0.9067046412377225}, {
      0, 0.8192330052400065, 0.9062481189555629}, {
      0, 0.8198521764983644, 0.9057907941097334}, {
      0, 0.8204700452365375, 0.9053326681915086}, {
      0, 0.8210866134366656, 0.9048737426883736}, {
      0, 0.8217018830696242, 0.9044140190840502}, {
      0, 0.8223158560951344, 0.9039534988585219}, {
      0, 0.8229285344618709, 0.9034921834880599}, {
      0, 0.8235399201075675, 0.9030300744452495}, {
      0, 0.8241500149591234, 0.9025671731990127}, {
      0, 0.8247588209327076, 0.9021034812146348}, {
      0, 0.8253663399338601, 0.9016389999537886}, {
      0, 0.8259725738575949, 0.9011737308745579}, {
      0, 0.8265775245884988, 0.9007076754314627}, {
      0, 0.8271811940008319, 0.900240835075482}, {
      0, 0.8277835839586254, 0.8997732112540777}, {
      0, 0.8283846963157762, 0.8993048054112187}, {
      0, 0.8289845329161455, 0.8988356189874019}, {
      0, 0.829583095593651, 0.8983656534196779}, {
      0, 0.8301803861723615, 0.8978949101416707}, {
      0, 0.8307764064665876, 0.8974233905836027}, {
      0, 0.8313711582809746, 0.8969510961723156}, {
      0, 0.8319646434105915, 0.896478028331292}, {
      0, 0.8325568636410201, 0.8960041884806782}, {
      0, 0.8331478207484427, 0.8955295780373053}, {
      0, 0.8337375164997299, 0.8950541984147103}, {
      0, 0.8343259526525254, 0.8945780510231578}, {
      0, 0.8349131309553315, 0.8941011372696606}, {
      0, 0.8354990531475933, 0.8936234585580001}, {
      0, 0.8360837209597807, 0.893145016288748}, {
      0, 0.8366671361134714, 0.8926658118592852}, {
      0, 0.8372493003214321, 0.8921858466638231}, {
      0, 0.8378302152876969, 0.8917051220934227}, {
      0, 0.8384098827076482, 0.8912236395360154}, {
      0, 0.8389883042680952, 0.8907414003764215}, {
      0, 0.8395654816473493, 0.8902584059963707}, {
      0, 0.8401414165153034, 0.8897746577745197}, {
      0, 0.8407161105335054, 0.8892901570864736}, {
      0, 0.8412895653552332, 0.8888049053048028}, {
      0, 0.8418617826255712, 0.888318903799062}, {
      0, 0.8424327639814796, 0.8878321539358097}, {
      0, 0.8430025110518695, 0.887344657078626}, {
      0, 0.8435710254576745, 0.8868564145881297}, {
      0, 0.8441383088119183, 0.8863674278219991}, {
      0, 0.8447043627197894, 0.8858776981349863}, {
      0, 0.8452691887787067, 0.8853872268789376}, {
      0, 0.8458327885783886, 0.8848960154028103}, {
      0, 0.8463951637009218, 0.8844040650526891}, {
      0, 0.8469563157208277, 0.8839113771718046}, {
      0, 0.8475162462051274, 0.8834179531005497}, {
      0, 0.8480749567134094, 0.8829237941764964}, {
      0, 0.8486324487978921, 0.8824289017344131}, {
      0, 0.8491887240034895, 0.8819332771062807}, {
      0, 0.8497437838678742, 0.8814369216213088}, {
      0, 0.8502976299215388, 0.8809398366059532}, {
      0, 0.8508502636878594, 0.8804420233839306}, {
      0, 0.8514016866831573, 0.8799434832762352}, {
      0, 0.8519519004167573, 0.8794442176011553}, {
      0, 0.85250090639105, 0.8789442276742873}, {
      0, 0.853048706101551, 0.8784435148085529}, {
      0, 0.8535953010369574, 0.8779420803142145}, {
      0, 0.8541406926792092, 0.8774399254988885}, {
      0, 0.8546848825035442, 0.8769370516675633}, {
      0, 0.8552278719785561, 0.8764334601226125}, {
      0, 0.8557696625662506, 0.8759291521638101}, {
      0, 0.8563102557221014, 0.8754241290883457}, {
      0, 0.8568496528951044, 0.8749183921908384}, {
      0, 0.8573878555278326, 0.8744119427633532}, {
      0, 0.8579248650564913, 0.8739047820954124}, {
      0, 0.8584606829109696, 0.8733969114740127}, {
      0, 0.8589953105148945, 0.8728883321836372}, {
      0, 0.8595287492856828, 0.8723790455062713}, {
      0, 0.8600610006345929, 0.8718690527214151}, {
      0, 0.860592065966776, 0.8713583551060978}, {
      0, 0.8611219466813268, 0.8708469539348922}, {
      0, 0.8616506441713337, 0.8703348504799261}, {
      0, 0.862178159823929, 0.8698220460108977}, {
      0, 0.8627044950203361, 0.8693085417950888}, {
      0, 0.8632296511359214, 0.8687943390973764}, {
      0, 0.8637536295402396, 0.8682794391802472}, {
      0, 0.8642764315970825, 0.8677638433038112}, {
      0, 0.8647980586645261, 0.8672475527258122}, {
      0, 0.8653185120949772, 0.8667305687016433}, {
      0, 0.8658377932352206, 0.8662128924843572}, {0.0006613781017822207, 
      0.8663559034264627, 0.8656945253246806}, {0.001697375533353692, 
      0.866872844004379, 0.8651754684710254}, {0.0027328931296558704`, 
      0.8673886162991578, 0.8646557231695019}, {0.0037679309716143064`, 
      0.8679032216355447, 0.8641352906639306}, {0.00480248913703323, 
      0.8684166613328873, 0.8636141721958539}, {0.005836567700627997, 
      0.8689289367051775, 0.8630923690045496}, {0.006870166734054723, 
      0.8694400490610957, 0.862569882327041}, {0.007903286305942768, 
      0.8699499997040532, 0.8620467133981105}, {0.008935926481924305, 
      0.8704587899322339, 0.8615228634503096}, {0.009968087324664306, 
      0.8709664210386363, 0.8609983337139722}, {0.010999768893890888`, 
      0.8714728943111159, 0.8604731254172251}, {0.012030971246425532`, 
      0.871978211032425, 0.8599472397859994}, {0.013061694436210507`, 
      0.8724823724802535, 0.8594206780440431}, {0.014091938514339328`, 
      0.8729853799272701, 0.8588934414129309}, {0.015121703529084618`, 
      0.8734872346411605, 0.858365531112076}, {0.01615098952592712, 
      0.8739879378846684, 0.8578369483587414}, {0.017179796547583028`, 
      0.8744874909156337, 0.8573076943680507}, {0.018208124634032614`, 
      0.8749858949870312, 0.8567777703529986}, {0.019235973822545892`, 
      0.8754831513470086, 0.8562471775244628}, {0.020263344147712466`, 
      0.875979261238926, 0.8557159170912136}, {0.02129023564146631, 
      0.8764742259013915, 0.855183990259925}, {0.0223166483331132, 
      0.876968046568299, 0.8546513982351858}, {0.023342582249357435`, 
      0.8774607244688659, 0.8541181422195087}, {0.024368037414326586`, 
      0.877952260827669, 0.8535842234133423}, {0.02539301384959916, 
      0.8784426568646797, 0.8530496430150807}, {0.026417511574228794`, 
      0.878931913795302, 0.852514402221073}, {0.02744153060476972, 
      0.879420032830405, 0.8519785022256353}, {0.02846507095530239, 
      0.8799070151763612, 0.8514419442210588}, {0.029488132637458673`, 
      0.8803928620350792, 0.8509047293976205}, {0.030510715660443957`, 
      0.880877574604038, 0.8503668589435942}, {0.03153282003106483, 
      0.8813611540763233, 0.8498283340452587}, {0.032554445753750806`, 
      0.881843601640659, 0.8492891558869081}, {0.03357559283057836, 
      0.8823249184814408, 0.8487493256508626}, {0.034596261261296536`, 
      0.8828051057787721, 0.8482088445174756}, {0.03561645104334613, 
      0.8832841647084927, 0.8476677136651467}, {0.03663616217188825, 
      0.8837620964422156, 0.8471259342703275}, {0.0376553946398219, 
      0.8842389021473556, 0.8465835075075339}, {0.03867414843781088, 
      0.8847145829871641, 0.8460404345493532}, {0.039692423554302914`, 
      0.8851891401207588, 0.8454967165664556}, {0.04071021997555425, 
      0.8856625747031559, 0.8449523547276017}, {0.04172753768565037, 
      0.8861348878853016, 0.8444073501996513}, {0.042744376666528125`, 
      0.8866060808141022, 0.843861704147574}, {0.04376073689799726, 
      0.8870761546324544, 0.8433154177344572}, {0.04477661835776158, 
      0.8875451104792766, 0.842768492121515}, {0.04579202102144067, 
      0.8880129494895377, 0.8422209284680972}, {0.04680694486259015, 
      0.8884796727942879, 0.8416727279316978}, {0.0478213898527224, 
      0.8889452815206865, 0.8411238916679642}, {0.04883535596132806, 
      0.8894097767920334, 0.8405744208307053}, {0.04984884315589501, 
      0.8898731597277953, 0.8400243165719005}, {0.05086185140192914, 
      0.8903354314436368, 0.8394735800417076}, {0.051874380662974215`, 
      0.8907965930514463, 0.8389222123884721}, {0.052886430900632, 
      0.8912566456593666, 0.8383702147587345}, {0.053898002074581536`, 
      0.8917155903718211, 0.8378175882972395}, {0.0549090941425979, 
      0.8921734282895418, 0.8372643341469438}, {0.05591970706057207, 
      0.8926301605095963, 0.8367104534490244}, {0.056929840782529696`, 
      0.8930857881254163, 0.8361559473428863}, {0.057939495260650425`, 
      0.8935403122268224, 0.8356008169661719}, {0.05894867044528562, 
      0.8939937339000523, 0.8350450634547667}, {0.059957366284976985`, 
      0.8944460542277868, 0.8344886879428098}, {0.0609655827264753, 
      0.8948972742891752, 0.8339316915626999}, {0.061973319714758966`, 
      0.8953473951598625, 0.8333740754451036}, {0.06298057719305036, 
      0.895796417912014, 0.8328158407189638}, {0.06398735510283494, 
      0.8962443436143415, 0.8322569885115065}, {0.06499365338387848, 
      0.8966911733321277, 0.8316975199482491}, {0.06599947197424366, 
      0.8971369081272519, 0.8311374361530082}, {0.06700481081030937, 
      0.897581549058215, 0.8305767382479056}, {0.06800966982678576, 
      0.8980250971801633, 0.8300154273533775}, {0.0690140489567315, 
      0.8984675535449131, 0.8294535045881816}, {0.07001794813157212, 
      0.8989089192009755, 0.8288909710694035}, {0.07102136728111474, 
      0.8993491951935794, 0.8283278279124648}, {0.0720243063335653, 
      0.899788382564696, 0.8277640762311306}, {0.07302676521554517, 
      0.9002264823530614, 0.8271997171375163}, {0.07402874385210696, 
      0.9006634955942011, 0.8266347517420942}, {0.07503024216675029, 
      0.9010994233204521, 0.8260691811537019}, {0.07603126008143851, 
      0.9015342665609867, 0.825503006479548}, {0.07703179751661335, 
      0.9019680263418337, 0.8249362288252204}, {0.07803185439121131, 
      0.9024007036859034, 0.8243688492946922}, {0.07903143062267869, 
      0.9028322996130077, 0.8238008689903289}, {0.08003052612698645, 
      0.9032628151398824, 0.823232289012896}, {0.08102914081864718, 
      0.9036922512802111, 0.822663110461564}, {0.08202727461072729, 
      0.9041206090446449, 0.8220933344339174}, {0.08302492741486411, 
      0.9045478894408241, 0.8215229620259601}, {0.08402209914128017, 
      0.9049740934734015, 0.8209519943321215}, {0.08501878969879681, 
      0.9053992221440617, 0.8203804324452648}, {0.08601499899484992, 
      0.9058232764515421, 0.8198082774566923}, {0.08701072693550323, 
      0.9062462573916552, 0.8192355304561522}, {0.08800597342546351, 
      0.9066681659573083, 0.8186621925318448}, {0.0890007383680937, 
      0.9070890031385237, 0.8180882647704301}, {0.0899950216654277, 
      0.90750876992246, 0.8175137482570325}, {0.09098882321818282, 
      0.9079274672934312, 0.8169386440752485}, {0.09198214292577571, 
      0.9083450962329278, 0.816362953307152}, {0.0929749806863337, 
      0.9087616577196352, 0.8157866770333017}, {0.09396733639670989, 
      0.9091771527294552, 0.8152098163327454}, {0.0949592099524949, 
      0.9095915822355235, 0.8146323722830286}, {0.09595060124803151, 
      0.9100049472082303, 0.8140543459601988}, {0.09694151017642787, 
      0.9104172486152398, 0.8134757384388119}, {0.09793193662956824, 
      0.9108284874215072, 0.8128965507919389}, {0.09892188049812833, 
      0.9112386645892999, 0.8123167840911717}, {0.09991134167158769, 
      0.9116477810782154, 0.8117364394066277}, {0.10090032003824077`, 
      0.9120558378451984, 0.8111555178069577}, {0.10188881548521057`, 
      0.9124628358445614, 0.8105740203593509}, {0.10287682789846159`, 
      0.9128687760280019, 0.8099919481295403}, {0.10386435716281119`, 
      0.9132736593446201, 0.8094093021818088}, {0.10485140316194126`, 
      0.9136774867409372, 0.8088260835789958}, {0.10583796577841251`, 
      0.9140802591609135, 0.808242293382501}, {0.10682404489367359`, 
      0.9144819775459657, 0.807657932652292}, {0.10780964038807557`, 
      0.9148826428349844, 0.8070730024469088}, {0.10879475214088219`, 
      0.9152822559643518, 0.8064875038234696}, {0.10977938003028125`, 
      0.915680817867958, 0.8059014378376766}, {0.11076352393339735`, 
      0.916078329477219, 0.8053148055438217}, {0.11174718372630305`, 
      0.9164747917210937, 0.8047276079947907}, {0.11273035928402925`, 
      0.9168702055260998, 0.8041398462420706}, {0.11371305048057799`, 
      0.9172645718163314, 0.8035515213357534}, {0.11469525718893193`, 
      0.9176578915134744, 0.8029626343245425}, {0.11567697928106699`, 
      0.9180501655368245, 0.8023731862557575}, {0.116658216627962, 
      0.9184413948033019, 0.8017831781753398}, {0.11763896909961055`, 
      0.9188315802274682, 0.8011926111278577}, {0.11861923656503173`, 
      0.9192207227215426, 0.8006014861565108}, {0.11959901889227961`, 
      0.919608823195417, 0.8000098043031375}, {0.12057831594845587`, 
      0.919995882556673, 0.799417566608217}, {0.12155712759971762`, 
      0.9203819017105951, 0.7988247741108774}, {0.12253545371129078`, 
      0.9207668815601896, 0.7982314278488988}, {0.12351329414747807`, 
      0.9211508230061972, 0.7976375288587192}, {0.124490648771671, 
      0.9215337269471097, 0.7970430781754386}, {0.1254675174463576, 
      0.9219155942791838, 0.7964480768328261}, {0.12644390003313621`, 
      0.922296425896458, 0.7958525258633219}, {0.12741979639272158`, 
      0.9226762226907662, 0.7952564262980445}, {0.12839520638495705`, 
      0.923054985551752, 0.7946597791667948}, {0.12937012986882368`, 
      0.9234327153668849, 0.7940625854980611}, {0.13034456670245054`, 
      0.9238094130214736, 0.793464846319023}, {0.13131851674312311`, 
      0.924185079398681, 0.7928665626555579}, {0.13229197984729396`, 
      0.9245597153795383, 0.7922677355322443}, {0.13326495587059203`, 
      0.9249333218429593, 0.7916683659723672}, {0.1342374446678319, 
      0.9253058996657543, 0.7910684549979223}, {0.1352094460930228, 
      0.9256774497226442, 0.7904680036296216}, {0.13618095999937851`, 
      0.9260479728862748, 0.7898670128868964}, {0.1371519862393256, 
      0.9264174700272299, 0.7892654837879042}, {0.1381225246645133, 
      0.9267859420140445, 0.7886634173495312}, {0.13909257512582285`, 
      0.9271533897132203, 0.7880608145873975}, {0.14006213747337493`, 
      0.9275198139892371, 0.7874576765158623}, {0.1410312115565402, 
      0.9278852157045672, 0.786854004148027}, {0.14199979722394662`, 
      0.9282495957196879, 0.7862497984957414}, {0.14296789432348947`, 
      0.9286129548930959, 0.7856450605696064}, {0.1439355027023396, 
      0.928975294081319, 0.7850397913789794}, {0.14490262220695133`, 
      0.9293366141389299, 0.7844339919319785}, {0.14586925268307094`, 
      0.929696915918558, 0.7838276632354871}, {0.14683539397574666`, 
      0.9300562002709036, 0.7832208062951571}, {0.14780104592933513`, 
      0.9304144680447497, 0.7826134221154146}, {0.148766208387511, 
      0.9307717200869742, 0.7820055116994631}, {0.14973088119327438`, 
      0.9311279572425629, 0.7813970760492884}, {0.15069506418895917`, 
      0.9314831803546219, 0.7807881161656627}, {0.15165875721624147`, 
      0.9318373902643895, 0.780178633048148}, {0.1526219601161471, 
      0.9321905878112486, 0.7795686276951016}, {0.1535846727290603, 
      0.9325427738327388, 0.7789581011036786}, {0.1545468948947304, 
      0.932893949164568, 0.7783470542698376}, {0.15550862645228108`, 
      0.9332441146406247, 0.7777354881883437}, {0.15646986724021672`, 
      0.9335932710929897, 0.777123403852773}, {0.15743061709643186`, 
      0.933941419351948, 0.7765108022555162}, {0.15839087585821604`, 
      0.9342885602459995, 0.7758976843877835}, {0.15935064336226495`, 
      0.9346346946018719, 0.775284051239607}, {0.16030991944468514`, 
      0.9349798232445315, 0.7746699037998462}, {0.16126870394100248`, 
      0.935323946997194, 0.7740552430561914}, {0.16222699668616927`, 
      0.9356670666813365, 0.7734400699951671}, {0.16318479751457232`, 
      0.9360091831167087, 0.7728243856021364}, {0.16414210626003925`, 
      0.9363502971213439, 0.7722081908613045}, {0.1650989227558463, 
      0.9366904095115695, 0.7715914867557231}, {0.16605524683472556`, 
      0.9370295211020189, 0.7709742742672933}, {0.16701107832887105`, 
      0.9373676327056413, 0.7703565543767702}, {0.16796641706994703`, 
      0.9377047451337134, 0.7697383280637663}, {0.16892126288909462`, 
      0.9380408591958496, 0.7691195963067549}, {0.16987561561693823`, 
      0.9383759757000127, 0.7685003600830745}, {0.1708294750835927, 
      0.9387100954525248, 0.767880620368932}, {0.1717828411186706, 
      0.9390432192580769, 0.7672603781394063}, {0.1727357135512884, 
      0.9393753479197404, 0.7666396343684521}, {0.17368809221007278`, 
      0.9397064822389765, 0.7660183900289036}, {0.17463997692316885`, 
      0.9400366230156468, 0.7653966460924779}, {0.17559136751824464`, 
      0.9403657710480235, 0.7647744035297788}, {0.17654226382249963`, 
      0.9406939271327995, 0.7641516633102999}, {0.17749266566266964`, 
      0.9410210920650985, 0.7635284264024289}, {0.17844257286503468`, 
      0.9413472666384843, 0.7629046937734496}, {0.17939198525542424`, 
      0.9416724516449717, 0.7622804663895475}, {0.18034090265922384`, 
      0.9419966478750352, 0.7616557452158115}, {0.18128932490138236`, 
      0.94231985611762, 0.7610305312162376}, {0.18223725180641595`, 
      0.94264207716015, 0.7604048253537341}, {0.18318468319841724`, 
      0.942963311788539, 0.7597786285901217}, {0.18413161890105895`, 
      0.9432835607871991, 0.7591519418861402}, {0.18507805873760125`, 
      0.9436028249390508, 0.7585247662014497}, {0.18602400253089812`, 
      0.9439211050255324, 0.7578971024946343}, {0.18696945010340152`, 
      0.9442384018266082, 0.7572689517232066}, {0.18791440127716974`, 
      0.9445547161207795, 0.7566403148436096}, {0.1888588558738715, 
      0.9448700486850918, 0.7560111928112204}, {0.18980281371479255`, 
      0.9451844002951463, 0.7553815865803537}, {0.1907462746208416, 
      0.9454977717251064, 0.7547514971042648}, {0.1916892384125557, 
      0.9458101637477084, 0.7541209253351527}, {0.19263170491010617`, 
      0.9461215771342703, 0.753489872224164}, {0.19357367393330405`, 
      0.9464320126546989, 0.752858338721395}, {0.19451514530160618`, 
      0.9467414710775015, 0.7522263257758954}, {0.19545611883412067`, 
      0.9470499531697921, 0.7515938343356714}, {0.1963965943496118, 
      0.9473574596973011, 0.7509608653476892}, {0.1973365716665061, 
      0.9476639914243841, 0.750327419757878}, {0.19827605060289816`, 
      0.9479695491140296, 0.7496934985111315}, {0.1992150309765557, 
      0.9482741335278692, 0.7490591025513134}, {0.20015351260492373`, 
      0.9485777454261828, 0.7484242328212592}, {0.2010914953051327, 
      0.9488803855679112, 0.7477888902627786}, {0.20202897889400076`, 
      0.9491820547106606, 0.7471530758166599}, {0.20296596318804075`, 
      0.9494827536107133, 0.7465167904226725}, {0.20390244800346538`, 
      0.9497824830230344, 0.745880035019569}, {0.20483843315619205`, 
      0.950081243701281, 0.745242810545089}, {0.20577391846184676`, 
      0.9503790363978093, 0.7446051179359625}, {0.20670890373577244`, 
      0.9506758618636837, 0.7439669581279112}, {0.2076433887930301, 
      0.9509717208486836, 0.7433283320556535}, {0.20857737344840718`, 
      0.9512666141013122, 0.7426892406529051}, {0.20951085751641987`, 
      0.9515605423688038, 0.742049684852384}, {0.2104438408113201, 
      0.9518535063971318, 0.7414096655858117}, {0.21137632314709942`, 
      0.9521455069310164, 0.7407691837839171}, {0.21230830433749337`, 
      0.9524365447139324, 0.7401282403764389}, {0.21323978419598827`, 
      0.9527266204881164, 0.7394868362921282}, {0.2141707625358233, 
      0.9530157349945751, 0.7388449724587518}, {0.215101239169998, 
      0.953303888973092, 0.7382026498030941}, {0.21603121391127417`, 
      0.9535910831622357, 0.7375598692509615}, {0.21696068657218318`, 
      0.9538773182993662, 0.7369166317271829}, {0.21788965696502888`, 
      0.9541625951206434, 0.7362729381556143}, {0.21881812490189337`, 
      0.954446914361034, 0.7356287894591406}, {0.2197460901946405, 
      0.9547302767543184, 0.7349841865596779}, {0.22067355265492075`, 
      0.9550126830330985, 0.7343391303781778}, {0.22160051209417655`, 
      0.9552941339288045, 0.7336936218346279}, {0.2225269683236455, 
      0.9555746301717019, 0.7330476618480565}, {0.2234529211543656, 
      0.9558541724908988, 0.7324012513365333}, {0.22437837039717953`, 
      0.9561327616143532, 0.7317543912171737}, {0.22530331586273886`, 
      0.9564103982688791, 0.7311070824061402}, {0.22622775736150882`, 
      0.9566870831801545, 0.7304593258186457}, {0.2271516947037713, 
      0.956962817072727, 0.7298111223689558}, {0.22807512769963115`, 
      0.9572376006700221, 0.7291624729703909}, {0.228998056159019, 
      0.9575114346943487, 0.7285133785353298}, {0.22992047989169578`, 
      0.9577843198669066, 0.7278638399752109}, {0.23084239870725692`, 
      0.9580562569077928, 0.727213858200536}, {0.23176381241513633`, 
      0.9583272465360082, 0.7265634341208719}, {0.232684720824611, 
      0.9585972894694643, 0.7259125686448532}, {0.2336051237448049, 
      0.9588663864249899, 0.725261262680185}, {0.23452502098469274`, 
      0.9591345381183372, 0.7246095171336444}, {0.23544441235310432`, 
      0.9594017452641886, 0.7239573329110842}, {0.236363297658728, 
      0.9596680085761626, 0.7233047109174346}, {0.23728167671011535`, 
      0.9599333287668211, 0.7226516520567058}, {0.23819954931568518`, 
      0.9601977065476751, 0.7219981572319899}, {0.23911691528372617`, 
      0.9604611426291906, 0.7213442273454643}, {0.24003377442240262`, 
      0.9607236377207957, 0.720689863298393}, {0.24095012653975642`, 
      0.9609851925308863, 0.7200350659911299}, {0.2418659714437125, 
      0.9612458077668324, 0.71937983632312}, {0.2427813089420813, 
      0.9615054841349844, 0.7187241751929031}, {0.24369613884256355`, 
      0.9617642223406786, 0.718068083498115}, {0.24461046095275363`, 
      0.9620220230882437, 0.7174115621354901}, {0.2455242750801427, 
      0.9622788870810068, 0.7167546120008641}, {0.24643758103212327`, 
      0.9625348150212992, 0.716097233989176}, {0.24735037861599263`, 
      0.9627898076104626, 0.71543942899447}, {0.24826266763895607`, 
      0.9630438655488543, 0.7147811979098982}, {0.24917444790813068`, 
      0.9632969895358539, 0.7141225416277233}, {0.2500857192305498, 
      0.9635491802698684, 0.7134634610393186}, {0.2509964814131644, 
      0.9638004384483382, 0.712803957035174}, {0.2519067342628493, 
      0.9640507647677433, 0.7121440305048939}, {0.25281647758640435`, 
      0.964300159923608, 0.7114836823372036}, {0.25372571119055964`, 
      0.9645486246105075, 0.710822913419948}, {0.2546344348819776, 
      0.9647961595220729, 0.7101617246400954}, {0.25554264846725744`, 
      0.965042765350997, 0.7095001168837396}, {0.25645035175293746`, 
      0.9652884427890397, 0.7088380910361022}, {0.25735754454549997`, 
      0.9655331925270337, 0.7081756479815338}, {0.25826422665137316`, 
      0.9657770152548898, 0.7075127886035166}, {0.25917039787693547`, 
      0.9660199116616026, 0.7068495137846672}, {0.2600760580285175, 
      0.9662618824352553, 0.7061858244067378}, {0.26098120691240734`, 
      0.9665029282630259, 0.7055217213506184}, {0.26188584433485224`, 
      0.9667430498311913, 0.704857205496339}, {0.2627899701020616, 
      0.966982247825134, 0.7041922777230724}, {0.26369358402021176`, 
      0.9672205229293463, 0.7035269389091346}, {0.26459668589544794`, 
      0.9674578758274363, 0.7028611899319882}, {0.2654992755338879, 
      0.967694307202132, 0.7021950316682442}, {0.2664013527416248, 
      0.9679298177352877, 0.701528464993663}, {0.2673029173247297, 
      0.9681644081078882, 0.7008614907831584}, {0.2682039690892569, 
      0.9683980790000541, 0.7001941099107972}, {0.2691045078412439, 
      0.9686308310910474, 0.6995263232498036}, {0.27000453338671715`, 
      0.9688626650592757, 0.6988581316725584}, {0.270904045531693, 
      0.9690935815822971, 0.6981895360506042}, {0.2718030440821824, 
      0.9693235813368267, 0.6975205372546442}, {0.2727015288441928, 
      0.9695526649987393, 0.6968511361545464}, {0.2735994996237312, 
      0.969780833243076, 0.6961813336193448}, {0.27449695622680786`, 
      0.9700080867440479, 0.6955111305172401}, {0.27539389845943796`, 
      0.9702344261750421, 0.6948405277156042}, {0.27629032612764576`, 
      0.9704598522086254, 0.6941695260809797}, {0.2771862390374666, 
      0.9706843655165496, 0.6934981264790829}, {0.27808163699494987`, 
      0.9709079667697557, 0.6928263297748058}, {0.2789765198061626, 
      0.9711306566383796, 0.692154136832217}, {0.27987088727719134`, 
      0.971352435791756, 0.6914815485145647}, {0.28076473921414496`, 
      0.9715733048984229, 0.690808565684278}, {0.28165807542315874`, 
      0.9717932646261269, 0.6901351892029682}, {0.28255089571039477`, 
      0.972012315641827, 0.6894614199314322}, {0.2834431998820478, 
      0.9722304586117, 0.6887872587296522}, {0.2843349877443444, 
      0.972447694201144, 0.6881127064567997}, {0.28522625910354865`, 
      0.9726640230747838, 0.6874377639712352}, {0.2861170137659634, 
      0.9728794458964749, 0.6867624321305115}, {0.28700725153793255`, 
      0.9730939633293079, 0.6860867117913753}, {0.28789697222584526`, 
      0.9733075760356129, 0.6854106038097677}, {0.2887861756361367, 
      0.9735202846769645, 0.6847341090408279}, {0.28967486157529204`, 
      0.9737320899141851, 0.6840572283388932}, {0.29056302984984866`, 
      0.9739429924073502, 0.6833799625575014}, {0.29145068026639803`, 
      0.9741529928157917, 0.6827023125493936}, {0.2923378126315893, 
      0.9743620917981031, 0.6820242791665138}, {0.2932244267521312, 
      0.9745702900121432, 0.681345863260012}, {0.2941105224347943, 
      0.9747775881150406, 0.6806670656802463}, {0.29499609948641453`, 
      0.9749839867631973, 0.6799878872767828}, {0.2958811577138943, 
      0.9751894866122939, 0.6793083288983995}, {0.29676569692420623`, 
      0.9753940883172925, 0.6786283913930863}, {0.2976497169243947, 
      0.9755977925324418, 0.677948075608047}, {0.29853321752157863`, 
      0.9758005999112807, 0.6772673823897019}, {0.29941619852295387`, 
      0.9760025111066419, 0.6765863125836881}, {0.30029865973579556`, 
      0.9762035267706577, 0.6759048670348622}, {0.3011806009674601, 
      0.9764036475547614, 0.6752230465873013}, {0.3020620220253885, 
      0.9766028741096934, 0.6745408520843048}, {0.3029429227171078, 
      0.9768012070855041, 0.6738582843683963}, {0.3038233028502338, 
      0.9769986471315584, 0.6731753442813244}, {0.30470316223247274`, 
      0.9771951948965387, 0.672492032664066}, {0.3055825006716249, 
      0.9773908510284499, 0.6718083503568251}, {0.3064613179755853, 
      0.9775856161746227, 0.6711242981990373}, {0.30733961395234705`, 
      0.977779490981717, 0.6704398770293699}, {0.30821738841000335`, 
      0.9779724760957265, 0.6697550876857232}, {0.30909464115674956`, 
      0.978164572161982, 0.6690699310052325}, {0.3099713720008854, 
      0.9783557798251556, 0.6683844078242702}, {0.3108475807508172, 
      0.9785460997292634, 0.6676985189784462}, {0.3117232672150599, 
      0.9787355325176705, 0.6670122653026106}, {0.3125984312022399, 
      0.9789240788330938, 0.6663256476308541}, {0.3134730725210959, 
      0.9791117393176062, 0.6656386667965103}, {0.3143471909804827, 
      0.9792985146126396, 0.6649513236321569}, {0.3152207863893717, 
      0.9794844053589893, 0.6642636189696175}, {0.316093858556854, 
      0.9796694121968168, 0.6635755536399628}, {0.3169664072921428, 
      0.979853535765654, 0.6628871284735113}, {0.3178384324045737, 
      0.9800367767044067, 0.6621983442998329}, {0.3187099337036091, 
      0.9802191356513574, 0.6615092019477483}, {0.31958091099883795`, 
      0.9804006132441696, 0.6608197022453317}, {0.3204513640999801, 
      0.9805812101198913, 0.6601298460199111}, {0.3213212928168862, 
      0.9807609269149575, 0.6594396340980713}, {0.32219069695954095`, 
      0.9809397642651949, 0.658749067305654}, {0.32305957633806515`, 
      0.9811177228058245, 0.6580581464677594}, {0.32392793076271664`, 
      0.9812948031714652, 0.6573668724087486}, {0.3247957600438935, 
      0.9814710059961372, 0.6566752459522438}, {0.3256630639921345, 
      0.9816463319132653, 0.6559832679211308}, {0.326529842418123, 
      0.9818207815556825, 0.6552909391375594}, {0.3273960951326871, 
      0.9819943555556325, 0.6545982604229454}, {0.3282618219468023, 
      0.9821670545447744, 0.6539052325979721}, {0.3291270226715937, 
      0.9823388791541845, 0.6532118564825907}, {0.32999169711833704`, 
      0.9825098300143603, 0.6525181328960233}, {0.33085584509846117`, 
      0.982679907755224, 0.6518240626567628}, {0.3317194664235498, 
      0.9828491130061249, 0.651129646582575}, {0.33258256090534344`, 
      0.983017446395843, 0.6504348854904995}, {0.3334451283557406, 
      0.9831849085525927, 0.6497397801968521}, {0.33430716858680054`, 
      0.9833515001040247, 0.6490443315172243}, {0.33516868141074435`, 
      0.9835172216772308, 0.6483485402664865}, {0.33602966663995754`, 
      0.9836820738987452, 0.6476524072587877}, {0.3368901240869902, 
      0.9838460573945488, 0.6469559333075587}, {0.33775005356456056`, 
      0.9840091727900723, 0.6462591192255117}, {0.33860945488555616`, 
      0.9841714207101983, 0.6455619658246421}, {0.33946832786303477`, 
      0.9843328017792653, 0.6448644739162305}, {0.34032667231022773`, 
      0.9844933166210704, 0.6441666443108427}, {0.34118448804053914`, 
      0.984652965858872, 0.6434684778183327}, {0.342041774867551, 
      0.9848117501153932, 0.6427699752478423}, {0.3428985326050222, 
      0.9849696700128249, 0.6420711374078026}, {0.3437547610668906, 
      0.9851267261728277, 0.6413719651059371}, {0.3446104600672755, 
      0.9852829192165362, 0.6406724591492606}, {0.3454656294204788, 
      0.9854382497645611, 0.6399726203440823}, {0.34632026894098744`, 
      0.9855927184369921, 0.6392724494960047}, {0.34717437844347376`, 
      0.9857463258534014, 0.6385719474099276}, {0.34802795774279716`, 
      0.9858990726328454, 0.6378711148900483}, {0.34888100665400723`, 
      0.9860509593938688, 0.6371699527398614}, {0.34973352499234406`, 
      0.9862019867545067, 0.6364684617621625}, {0.3505855125732401, 
      0.9863521553322873, 0.635766642759047}, {0.3514369692123217, 
      0.9865014657442354, 0.6350644965319135}, {0.3522878947254112, 
      0.9866499186068742, 0.634362023881463}, {0.35313828892852717`, 
      0.9867975145362292, 0.633659225607702}, {0.3539881516378878, 
      0.9869442541478296, 0.6329561025099417}, {0.3548374826699107, 
      0.9870901380567122, 0.6322526553868015}, {0.3556862818412156, 
      0.9872351668774234, 0.6315488850362079}, {0.3565345489686253, 
      0.9873793412240223, 0.6308447922553969}, {0.35738228386916726`, 
      0.9875226617100826, 0.6301403778409154}, {0.35822948636007546`, 
      0.9876651289486967, 0.6294356425886213}, {0.35907615625879113`, 
      0.987806743552477, 0.6287305872936858}, {0.3599222933829648, 
      0.9879475061335588, 0.628025212750594}, {0.3607678975504575, 
      0.9880874173036033, 0.6273195197531457}, {0.36161296857934266`, 
      0.9882264776738001, 0.6266135090944573}, {0.36245750628790696`, 
      0.9883646878548693, 0.6259071815669625}, {0.3633015104946519, 
      0.988502048457065, 0.625200537962413}, {0.3641449810182959, 
      0.9886385600901766, 0.6244935790718806}, {0.36498791767777383`, 
      0.9887742233635322, 0.6237863056857583}, {0.3658303202922417, 
      0.9889090388860011, 0.6230787185937594}, {0.36667218868107404`, 
      0.989043007265996, 0.6223708185849219}, {0.36751352266386866`, 
      0.9891761291114753, 0.6216626064476067}, {0.3683543220604457, 
      0.9893084050299462, 0.6209540829695005}, {0.3691945866908511, 
      0.9894398356284666, 0.6202452489376155}, {0.37003431637535594`, 
      0.9895704215136477, 0.6195361051382918}, {0.3708735109344583, 
      0.9897001632916566, 0.6188266523571981}, {0.37171217018888614`, 
      0.9898290615682183, 0.618116891379332}, {0.37255029395959677`, 
      0.9899571169486185, 0.6174068229890217}, {0.3733878820677784, 
      0.990084330037706, 0.6166964479699276}, {0.37422493433485243`, 
      0.9902107014398946, 0.6159857671050422}, {0.37506145058247403`, 
      0.9903362317591659, 0.6152747811766918}, {0.375897430632534, 
      0.9904609215990714, 0.6145634909665374}, {0.3767328743071585, 
      0.990584771562735, 0.6138518972555764}, {0.37756778142871245`, 
      0.990707782252855, 0.6131400008241426}, {0.3784021518197994, 
      0.990829954271707, 0.6124278024519075}, {0.3792359853032634, 
      0.9909512882211452, 0.6117153029178818}, {0.3800692817021897, 
      0.9910717847026057, 0.6110025030004161}, {0.380902040839906, 
      0.9911914443171083, 0.6102894034772023}, {0.38173426253998466`, 
      0.9913102676652584, 0.6095760051252737}, {0.3825659466262434, 
      0.99142825534725, 0.6088623087210066}, {0.3833970929227454, 
      0.991545407962867, 0.6081483150401217}, {0.3842277012538017, 
      0.9916617261114865, 0.6074340248576848}, {0.38505777144397246`, 
      0.9917772103920797, 0.6067194389481072}, {0.3858873033180679, 
      0.9918918614032151, 0.6060045580851472}, {0.38671629670114877`, 
      0.9920056797430603, 0.6052893830419115}, {0.3875447514185289, 
      0.9921186660093841, 0.6045739145908551}, {0.38837266729577463`, 
      0.9922308207995586, 0.603858153503784}, {0.3892000441587077, 
      0.9923421447105616, 0.6031421005518539}, {0.39002688183340517`, 
      0.9924526383389782, 0.6024257565055732}, {0.3908531801462015, 
      0.9925623022810037, 0.6017091221348022}, {0.3916789389236889, 
      0.9926711371324447, 0.6009921982087558}, {0.39250415799271804`, 
      0.9927791434887218, 0.6002749854960037}, {0.393328837180401, 
      0.9928863219448716, 0.5995574847644706}, {0.3941529763141106, 
      0.9929926730955487, 0.5988396967814381}, {0.39497657522148166`, 
      0.9930981975350277, 0.598121622313546}, {0.3957996337304134, 
      0.9932028958572051, 0.5974032621267917}, {0.3966221516690698, 
      0.9933067686556017, 0.596684616986532}, {0.39744412886587915`, 
      0.9934098165233639, 0.5959656876574848}, {0.3982655651495374, 
      0.9935120400532667, 0.5952464749037292}, {0.3990864603490088, 
      0.9936134398377144, 0.5945269794887055}, {0.39990681429352565`, 
      0.9937140164687439, 0.5938072021752182}, {0.4007266268125906, 
      0.9938137705380258, 0.5930871437254351}, {0.4015458977359767, 
      0.9939127026368664, 0.5923668049008897}, {0.40236462689372954`, 
      0.9940108133562099, 0.5916461864624802}, {0.4031828141161674, 
      0.9941081032866401, 0.5909252891704726}, {0.4040004592338826, 
      0.9942045730183827, 0.5902041137845001}, {0.4048175620777425, 
      0.9943002231413066, 0.5894826610635642}, {0.4056341224788904, 
      0.9943950542449262, 0.5887609317660358}, {0.406450140268747, 
      0.9944890669184031, 0.5880389266496562}, {0.40726561527901, 
      0.9945822617505481, 0.587316646471538}, {0.4080805473416574, 
      0.9946746393298228, 0.5865940919881654}, {0.40889493628894585`, 
      0.9947662002443417, 0.5858712639553959}, {0.4097087819534141, 
      0.9948569450818741, 0.58514816312846}, {0.4105220841678811, 
      0.9949468744298453, 0.5844247902619641}, {0.41133484276545074`, 
      0.9950359888753394, 0.5837011461098887}, {0.412147057579509, 
      0.9951242890051, 0.582977231425591}, {0.4129587284437271, 
      0.995211775405533, 0.5822530469618059}, {0.413769855192062, 
      0.9952984486627077, 0.5815285934706457}, {0.4145804376587572, 
      0.9953843093623587, 0.5808038717036015}, {0.41539047567834314`, 
      0.9954693580898878, 0.5800788824115446}, {0.41619996908563944`, 
      0.9955535954303657, 0.5793536263447262}, {0.41700891771575443`, 
      0.9956370219685335, 0.5786281042527792}, {0.417817321404087, 
      0.995719638288805, 0.577902316884718}, {0.4186251799863262, 
      0.9958014449752677, 0.5771762649889415}, {0.41943249329845467`, 
      0.9958824426116849, 0.5764499493132302}, {0.4202392611767462, 
      0.9959626317814975, 0.5757233706047512}, {0.4210454834577694, 
      0.9960420130678251, 0.5749965296100558}, {0.4218511599783871, 
      0.9961205870534686, 0.5742694270750814}, {0.4226562905757575, 
      0.996198354320911, 0.5735420637451535}, {0.42346087508733504`, 
      0.9962753154523193, 0.5728144403649842}, {0.4242649133508715, 
      0.9963514710295466, 0.5720865576786751}, {0.4250684052044164, 
      0.9964268216341331, 0.5713584164297166}, {0.42587135048631813`, 
      0.996501367847308, 0.57063001736099}, {0.426673749035225, 
      0.9965751102499912, 0.5699013612147663}, {0.42747560069008556`, 
      0.996648049422795, 0.5691724487327093}, {0.4282769052901499, 
      0.9967201859460247, 0.5684432806558748}, {0.42907766267496933`, 
      0.9967915203996821, 0.5677138577247126}, {0.42987787268439986`, 
      0.9968620533634651, 0.5669841806790652}, {0.4306775351585989, 
      0.9969317854167705, 0.5662542502581716}, {0.4314766499380304, 
      0.9970007171386951, 0.5655240672006646}, {0.4322752168634624, 
      0.9970688491080374, 0.564793632244575}, {0.43307323577596957`, 
      0.997136181903299, 0.5640629461273293}, {0.43387070651693277`, 
      0.9972027161026861, 0.5633320095857532}, {0.4346676289280417, 
      0.9972684522841113, 0.5626008233560696}, {0.43546400285129333`, 
      0.9973333910251949, 0.5618693881739015}, {0.43625982812899416`, 
      0.9973975329032664, 0.5611377047742722}, {0.4370551046037608, 
      0.9974608784953658, 0.560405773891605}, {0.43784983211852024`, 
      0.9975234283782458, 0.5596735962597255}, {0.438644010516511, 
      0.9975851831283724, 0.5589411726118614}, {0.4394376396412843, 
      0.9976461433219269, 0.5582085036806427}, {0.4402307193367028, 
      0.9977063095348071, 0.5574755901981043}, {0.44102324944694404`, 
      0.9977656823426291, 0.556742432895685}, {0.4418152298164999, 
      0.9978242623207282, 0.5560090325042283}, {0.44260666029017653`, 
      0.9978820500441609, 0.5552753897539843}, {0.4433975407130966, 
      0.9979390460877058, 0.5545415053746091}, {0.4441878709306989, 
      0.9979952510258655, 0.5538073800951666}, {0.44497765078873874`, 
      0.9980506654328678, 0.5530730146441291}, {0.44576688013329097`, 
      0.9981052898826669, 0.552338409749376}, {0.4465555588107472, 
      0.9981591249489452, 0.5516035661381979}, {0.4473436866678199, 
      0.9982121712051142, 0.5508684845372943}, {0.44813126355154, 
      0.9982644292243162, 0.5501331656727763}, {0.4489182893092605, 
      0.9983158995794259, 0.5493976102701655}, {0.44970476378865415`, 
      0.9983665828430511, 0.5486618190543969}, {0.4504906868377172, 
      0.9984164795875345, 0.5479257927498175}, {0.4512760583047673, 
      0.9984655903849552, 0.547189532080188}, {0.452060878038446, 
      0.9985139158071294, 0.5464530377686835}, {0.4528451458877186, 
      0.9985614564256123, 0.5457163105378937}, {0.453628861701875, 
      0.9986082128116992, 0.5449793511098242}, {0.4544120253305303, 
      0.998654185536427, 0.5442421602058967}, {0.4551946366236255, 
      0.9986993751705753, 0.5435047385469496}, {0.4559766954314282, 
      0.9987437822846673, 0.542767086853239}, {0.456758201604533, 
      0.9987874074489722, 0.5420292058444393}, {0.4575391549938622, 
      0.9988302512335056, 0.5412910962396432}, {0.45831955545066627`, 
      0.9988723142080305, 0.5405527587573641}, {0.4590994028265249, 
      0.9989135969420597, 0.5398141941155348}, {0.459878696973348, 
      0.9989541000048563, 0.5390754030315084}, {0.46065743774337414`, 
      0.9989938239654347, 0.5383363862220605}, {0.4614356249891742, 
      0.9990327693925624, 0.5375971444033882}, {0.46221325856364964`, 
      0.9990709368547611, 0.5368576782911115}, {0.46299033832003417`, 
      0.9991083269203079, 0.5361179886002737}, {0.46376686411189394`, 
      0.9991449401572364, 0.5353780760453425}, {0.46454283579312805`, 
      0.999180777133338, 0.5346379413402098}, {0.46531825321797016`, 
      0.9992158384161629, 0.5338975851981927}, {0.46609311624098726`, 
      0.9992501245730221, 0.5331570083320347}, {0.4668674247170817, 
      0.9992836361709873, 0.5324162114539055}, {0.4676411785014913, 
      0.9993163737768933, 0.531675195275402}, {0.4684143774497897, 
      0.9993483379573385, 0.5309339605075486}, {0.4691870214178872, 
      0.999379529278686, 0.5301925078607986}, {0.4699591102620314, 
      0.9994099483070653, 0.5294508380450339}, {0.4707306438388072, 
      0.9994395956083733, 0.528708951769566}, {0.4715016220051376, 
      0.9994684717482748, 0.5279668497431371}, {0.4722720446182851, 
      0.9994965772922045, 0.5272245326739194}, {0.47304191153585085`, 
      0.9995239128053678, 0.5264820012695169}, {0.47381122261577585`, 
      0.9995504788527418, 0.5257392562369658}, {0.4745799777163417, 
      0.9995762759990766, 0.524996298282735}, {0.47534817669617063`, 
      0.9996013048088964, 0.5242531281127256}, {0.47611581941422665`, 
      0.9996255658465003, 0.5235097464322738}, {0.47688290572981507`, 
      0.9996490596759642, 0.522766153946149}, {0.47764943550258354`, 
      0.9996717868611409, 0.5220223513585573}, {0.47841540859252396`, 
      0.9996937479656618, 0.5212783393731377}, {0.47918082485997016`, 
      0.999714943552938, 0.5205341186929677}, {0.47994568416560063`, 
      0.999735374186161, 0.5197896900205604}, {0.4807099863704377, 
      0.9997550404283042, 0.5190450540578663}, {0.4814737313358495, 
      0.9997739428421236, 0.5183002115062741}, {0.48223691892354875`, 
      0.9997920819901591, 0.5175551630666103}, {0.4829995489955946, 
      0.9998094584347356, 0.5168099094391408}, {0.48376162141439233`, 
      0.9998260727379635, 0.5160644513235713}, {0.48452313604269404`, 
      0.9998419254617408, 0.5153187894190467}, {0.48528409274359885`, 
      0.9998570171677529, 0.5145729244241539}, {0.4860444913805542, 
      0.9998713484174745, 0.5138268570369202}, {0.48680433181735605`, 
      0.9998849197721703, 0.5130805879548143}, {0.48756361391814823`, 
      0.9998977317928962, 0.5123341178747479}, {0.4883223375474237, 
      0.9999097850405, 0.5115874474930763}, {0.4890805025700261, 
      0.9999210800756225, 0.5108405775055964}, {0.4898381088511482, 
      0.9999316174586987, 0.5100935086075505}, {0.4905951562563334, 
      0.9999413977499588, 0.5093462414936254}, {0.4913516446514766, 
      0.9999504215094287, 0.5085987768579521}, {0.49210757390282356`, 
      0.9999586892969317, 0.5078511153941081}, {0.4928629438769722, 
      0.9999662016720886, 0.5071032577951163}, {0.4936177544408723, 
      0.9999729591943198, 0.5063552047534475}, {0.494372005461827, 
      0.9999789624228453, 0.5056069569610183}, {0.4951256968074918, 
      0.9999842119166859, 0.504858515109194}, {0.4958788283458768, 
      0.9999887082346643, 0.5041098798887875}, {0.49663139994534455`, 
      0.9999924519354062, 0.5033610519900616}, {0.4973834114746135, 
      0.9999954435773407, 0.5026120321027272}, {0.49813486280275604`, 
      0.9999976837187018, 0.5018628209159457}, {0.4988857537992, 
      0.9999991729175289, 0.5011134191183289}, {0.49963608433372864`, 
      0.9999999117316681, 0.5003638273979395}, {0.500385854276482, 
      0.9999999007187729, 0.499614046442291}, {0.5011350634979549, 
      0.9999991404363049, 0.49886407693835005`}, {0.5018837118690008, 
      0.9999976314415352, 0.49811391957253437`}, {0.5026317992608291, 
      0.999995374291545, 0.49736357503071577`}, {0.5033793255450079, 
      0.9999923695432263, 0.49661304399821843`}, {0.5041262905934618, 
      0.9999886177532835, 0.4958623271598216}, {0.5048726942784751, 
      0.9999841194782333, 0.49511142519975815`}, {0.50561853647269, 
      0.9999788752744065, 0.49436033880171654`}, {0.506363817049108, 
      0.9999728856979483, 0.4936090686488402}, {0.5071085358810906, 
      0.9999661513048193, 0.4928576154237287}, {0.5078526928423586, 
      0.9999586726507963, 0.49210597980843773`}, {0.508596287806993, 
      0.9999504502914737, 0.49135416248448066`}, {0.5093393206494355, 
      0.9999414847822633, 0.49060216413282776`}, {0.5100817912444892, 
      0.9999317766783964, 0.4898499854339071}, {0.5108236994673175, 
      0.9999213265349234, 0.4890976270676058}, {0.5115650451934466, 
      0.9999101349067157, 0.48834508971326895`}, {0.5123058282987636, 
      0.9998982023484657, 0.4875923740497019}, {0.5130460486595187, 
      0.9998855294146883, 0.48683948075516953`}, {0.5137857061523249, 
      0.9998721166597214, 0.48608641050739654`}, {0.5145248006541573, 
      0.9998579646377267, 0.4853331639835693}, {0.5152633320423555, 
      0.9998430739026903, 0.48457974186033476`}, {0.5160013001946218, 
      0.9998274450084241, 0.4838261448138023}, {0.5167387049890236, 
      0.9998110785085662, 0.48307237351954246`}, {0.5174755463039918, 
      0.9997939749565816, 0.48231842865258984`}, {0.5182118240183223, 
      0.9997761349057634, 0.481564310887441}, {0.5189475380111759, 
      0.9997575589092332, 0.4808100208980573}, {0.5196826881620793, 
      0.9997382475199419, 0.48005555935786254`}, {0.520417274350924, 
      0.9997182012906709, 0.4793009269397469}, {0.5211512964579683, 
      0.9996974207740325, 0.47854612431606414`}, {0.5218847543638363, 
      0.9996759065224705, 0.4777911521586342}, {0.5226176479495184, 
      0.9996536590882615, 0.47703601113874305`}, {0.5233499770963731, 
      0.9996306790235154, 0.4762807019271423}, {0.5240817416861249, 
      0.9996069668801759, 0.47552522519405105`}, {0.524812941600866, 
      0.9995825232100216, 0.4747695816091556}, {0.5255435767230568, 
      0.9995573485646667, 0.4740137718416098}, {0.5262736469355263, 
      0.9995314434955617, 0.4732577965600354}, {0.5270031521214705, 
      0.9995048085539938, 0.4725016564325233}, {0.5277320921644553, 
      0.9994774442910884, 0.4717453521266332}, {0.5284604669484146, 
      0.9994493512578091, 0.4709888843093945}, {0.5291882763576528, 
      0.9994205300049586, 0.47023225364730586`}, {0.529915520276843, 
      0.9993909810831798, 0.4694754608063369}, {0.5306421985910276, 
      0.9993607050429559, 0.4687185064519284}, {0.5313683111856204, 
      0.9993297024346119, 0.4679613912489914}, {0.5320938579464051, 
      0.9992979738083144, 0.46720411586190924`}, {0.5328188387595356, 
      0.9992655197140728, 0.46644668095453723`}, {0.5335432535115371, 
      0.9992323407017404, 0.4656890871902033}, {0.534267102089306, 
      0.999198437321014, 0.46493133523170793`}, {0.5349903843801097, 
      0.9991638101214356, 0.46417342574132586`}, {0.5357131002715884, 
      0.9991284596523927, 0.4634153593808044}, {0.5364352496517527, 
      0.999092386463119, 0.46265713681136633`}, {0.537156832408987, 
      0.9990555911026949, 0.461898758693708}, {0.5378778484320469, 
      0.9990180741200486, 0.4611402256880017}, {0.5385982976100616, 
      0.9989798360639561, 0.4603815384538945}, {0.5393181798325329, 
      0.9989408774830428, 0.4596226976505098}, {0.540037494989336, 
      0.9989011989257833, 0.4588637039364473}, {0.5407562429707192, 
      0.9988608009405024, 0.4581045579697832}, {0.5414744236673049, 
      0.9988196840753759, 0.457345260408071}, {0.5421920369700896, 
      0.9987778488784309, 0.45658581190834135`}, {0.5429090827704431, 
      0.9987352958975468, 0.4558262131271037}, {0.5436255609601109, 
      0.9986920256804557, 0.4550664647203447}, {0.5443414714312123, 
      0.9986480387747431, 0.4543065673435307}, {0.5450568140762416, 
      0.9986033357278484, 0.4535465216516067}, {0.5457715887880685, 
      0.9985579170870661, 0.4527863282989975}, {0.5464857954599374, 
      0.9985117833995455, 0.45202598793960813`}, {0.5471994339854691, 
      0.9984649352122921, 0.45126550122682285`}, {0.5479125042586598, 
      0.9984173730721677, 0.4505048688135079}, {0.5486250061738814, 
      0.9983690975258916, 0.44974409135201016`}, {0.5493369396258827, 
      0.9983201091200405, 0.44898316949415784`}, {0.5500483045097881, 
      0.9982704084010497, 0.4482221038912614}, {0.5507591007210992, 
      0.9982199959152132, 0.44746089519411386`}, {0.5514693281556947, 
      0.9981688722086847, 0.44669954405298995`}, {0.5521789867098293, 
      0.9981170378274782, 0.44593805111764884`}, {0.5528880762801361, 
      0.9980644933174679, 0.44517641703733185`}, {0.553596596763625, 
      0.9980112392243901, 0.444414642460765}, {0.554304548057684, 
      0.9979572760938423, 0.4436527280361582}, {0.5550119300600783, 
      0.9979026044712848, 0.44289067441120644`}, {0.5557187426689519, 
      0.9978472249020409, 0.44212848223308904`}, {0.5564249857828265, 
      0.9977911379312977, 0.44136615214847114`}, {0.5571306593006029, 
      0.9977343441041061, 0.4406036848035031}, {0.5578357631215594, 
      0.997676843965382, 0.4398410808438227}, {0.5585402971453542, 
      0.9976186380599068, 0.43907834091455256`}, {0.5592442612720241, 
      0.9975597269323274, 0.43831546566030327`}, {0.5599476554019849, 
      0.9975001111271573, 0.4375524557251723}, {0.5606504794360325, 
      0.9974397911887769, 0.4367893117527442}, {0.5613527332753409, 
      0.9973787676614343, 0.43602603438609333`}, {0.5620544168214654, 
      0.9973170410892455, 0.4352626242677801}, {0.5627555299763402, 
      0.9972546120161951, 0.434499082039855}, {0.56345607264228, 
      0.9971914809861371, 0.433735408343857}, {0.5641560447219794, 
      0.9971276485427947, 0.43297160382081523`}, {0.564855446118514, 
      0.9970631152297617, 0.4322076691112475}, {0.565554276735339, 
      0.9969978815905023, 0.4314436048551633}, {0.5662525364762916, 
      0.9969319481683524, 0.43067941169206087`}, {0.5669502252455886, 
      0.9968653155065192, 0.42991509026093055`}, {0.567647342947829, 
      0.9967979841480825, 0.42915064120025354`}, {0.5683438894879921, 
      0.9967299546359948, 0.42838606514800265`}, {0.5690398647714392, 
      0.9966612275130817, 0.42762136274164253`}, {0.5697352687039126, 
      0.9965918033220429, 0.4268565346181304}, {0.5704301011915365, 
      0.9965216826054523, 0.42609158141391573`}, {0.5711243621408179, 
      0.9964508659057585, 0.42532650376494063`}, {0.5718180514586436, 
      0.9963793537652856, 0.42456130230664196`}, {0.5725111690522846, 
      0.9963071467262334, 0.4237959776739488}, {0.5732037148293931, 
      0.996234245330678, 0.4230305305012847}, {0.5738956886980043, 
      0.9961606501205721, 0.42226496142256764`}, {0.5745870905665355, 
      0.9960863616377459, 0.42149927107121044`}, {0.5752779203437862, 
      0.9960113804239074, 0.42073346008012114`}, {0.57596817793894, 
      0.9959357070206425, 0.4199675290817025}, {0.5766578632615628, 
      0.995859341969416, 0.4192014787078532}, {0.5773469762216034, 
      0.9957822858115717, 0.4184353095899684}, {0.578035516729394, 
      0.9957045390883333, 0.41766902235893927`}, {0.5787234846956506, 
      0.9956261023408044, 0.41690261764515385`}, {0.5794108800314716, 
      0.995546976109969, 0.4161360960784975}, {0.5800977026483405, 
      0.9954671609366924, 0.415369458288352}, {0.580783952458123, 
      0.9953866573617213, 0.4146027049035982}, {0.5814696293730701, 
      0.9953054659256839, 0.41383583655261363`}, {0.5821547333058157, 
      0.9952235871690915, 0.4130688538632759}, {0.5828392641693781, 
      0.9951410216323376, 0.4123017574629595}, {0.5835232218771601, 
      0.9950577698556994, 0.4115345479785392}, {0.5842066063429487, 
      0.9949738323793372, 0.4107672260363885}, {0.5848894174809149, 
      0.9948892097432961, 0.4099997922623813}, {0.585571655205615, 
      0.9948039024875054, 0.4092322472818904}, {0.5862533194319897, 
      0.9947179111517793, 0.40846459171978966`}, {0.5869344100753641, 
      0.9946312362758177, 0.40769682620045367`}, {0.5876149270514482, 
      0.9945438783992063, 0.40692895134775803`}, {0.5882948702763381, 
      0.9944558380614168, 0.40616096778507865`}, {0.5889742396665137, 
      0.9943671158018079, 0.4053928761352942}, {0.5896530351388405, 
      0.9942777121596253, 0.4046246770207848}, {0.5903312566105695, 
      0.9941876276740024, 0.4038563710634329}, {0.5910089039993368, 
      0.9940968628839602, 0.40308795888462323`}, {0.5916859772231641, 
      0.994005418328408, 0.4023194411052438}, {0.5923624762004591, 
      0.9939132945461445, 0.4015508183456853}, {0.5930384008500145, 
      0.9938204920758568, 0.40078209122584246`}, {0.5937137510910092, 
      0.9937270114561221, 0.4000132603651128}, {0.5943885268430077, 
      0.9936328532254071, 0.3992443263823993}, {0.5950627280259606, 
      0.9935380179220693, 0.39847528989610864`}, {0.5957363545602049, 
      0.9934425060843564, 0.39770615152415156`}, {0.5964094063664628, 
      0.9933463182504079, 0.3969369118839451}, {0.5970818833658436, 
      0.9932494549582543, 0.3961675715924106}, {0.5977537854798426, 
      0.9931519167458182, 0.39539813126597567`}, {0.5984251126303415, 
      0.9930537041509144, 0.3946285915205729}, {0.599095864739608, 
      0.9929548177112505, 0.3938589529716426}, {0.599766041730297, 
      0.9928552579644271, 0.39308921623412996`}, {0.6004356435254498, 
      0.9927550254479379, 0.3923193819224881}, {0.601104670048494, 
      0.992654120699171, 0.3915494506506769}, {0.6017731212232446, 
      0.9925525442554081, 0.39077942303216345`}, {0.6024409969739029, 
      0.9924502966538256, 0.39000929967992265`}, {0.6031082972250569, 
      0.9923473784314949, 0.389239081206438}, {0.6037750219016826, 
      0.9922437901253826, 0.3884687682236998}, {0.6044411709291423, 
      0.9921395322723505, 0.38769836134320823`}, {0.6051067442331847, 
      0.9920346054091573, 0.3869278611759725}, {0.6057717417399474, 
      0.991929010072457, 0.3861572683325096}, {0.6064361633759534, 
      0.991822746798801, 0.3853865834228476}, {0.6071000090681145, 
      0.9917158161246371, 0.3846158070565226}, {0.6077632787437292, 
      0.991608218586311, 0.3838449398425817}, {0.6084259723304828, 
      0.9914999547200656, 0.3830739823895828}, {0.609088089756449, 
      0.9913910250620424, 0.3823029353055933}, {0.6097496309500885, 
      0.9912814301482809, 0.3815317991981924}, {0.6104105958402498, 
      0.9911711705147194, 0.3807605746744695}, {0.6110709843561689, 
      0.9910602466971952, 0.37998926234102626`}, {0.6117307964274697, 
      0.9909486592314452, 0.3792178628039754}, {0.6123900319841636, 
      0.9908364086531057, 0.37844637666894204`}, {0.6130486909566498, 
      0.9907234954977133, 0.3776748045410634}, {0.613706773275715, 
      0.9906099203007049, 0.37690314702498984`}, {0.6143642788725344, 
      0.9904956835974181, 0.3761314047248837}, {0.6150212076786711, 
      0.9903807859230913, 0.3753595782444202}, {0.6156775596260752, 
      0.9902652278128645, 0.37458766818678935`}, {0.6163333346470856, 
      0.9901490098017793, 0.37381567515469366`}, {0.6169885326744294, 
      0.9900321324247792, 0.37304359975034956`}, {0.6176431536412215, 
      0.9899145962167097, 0.37227144257548833`}, {0.6182971974809645, 
      0.9897964017123195, 0.37149920423135496`}, {0.6189506641275496, 
      0.9896775494462595, 0.3707268853187099}, {0.6196035535152562, 
      0.9895580399530843, 0.3699544864378281}, {0.6202558655787517, 
      0.9894378737672517, 0.36918200818849994`}, {0.620907600253092, 
      0.9893170514231233, 0.3684094511700313}, {0.6215587574737208, 
      0.989195573454965, 0.3676368159812442}, {0.6222093371764708, 
      0.9890734403969469, 0.3668641032204761}, {0.6228593392975627, 
      0.9889506527831436, 0.36609131348558094`}, {0.6235087637736049, 
      0.9888272111475351, 0.36531844737393016`}, {0.6241576105415957, 
      0.9887031160240063, 0.36454550548241066`}, {0.6248058795389202, 
      0.9885783679463477, 0.36377248840742743`}, {0.625453570703353, 
      0.9884529674482557, 0.3629993967449027}, {0.6261006839730568, 
      0.9883269150633328, 0.362226231090276}, {0.6267472192865827, 
      0.988200211325088, 0.3614529920385053}, {0.6273931765828707, 
      0.9880728567669365, 0.3606796801840657}, {0.6280385558012486, 
      0.9879448519222009, 0.35990629612095226`}, {0.6286833568814334, 
      0.9878161973241109, 0.3591328404426775}, {0.6293275797635302, 
      0.9876868935058035, 0.35835931374227326`}, {0.629971224388033, 
      0.9875569410003238, 0.3575857166122907}, {0.6306142906958243, 
      0.9874263403406246, 0.3568120496448001}, {0.6312567786281749, 
      0.9872950920595671, 0.35603831343139214`}, {0.6318986881267449, 
      0.987163196689921, 0.3552645085631762}, {0.6325400191335817, 
      0.987030654764365, 0.3544906356307833}, {0.6331807715911228, 
      0.9868974668154867, 0.35371669522436383`}, {0.6338209454421938, 
      0.986763633375783, 0.3529426879335892}, {0.6344605406300082, 
      0.9866291549776605, 0.35216861434765206`}, {0.6350995570981692, 
      0.9864940321534355, 0.35139447505526616`}, {0.6357379947906682, 
      0.9863582654353343, 0.3506202706446661}, {0.6363758536518849, 
      0.9862218553554941, 0.34984600170360913`}, {0.6370131336265882, 
      0.986084802445962, 0.34907166881937374`}, {0.6376498346599354, 
      0.9859471072386964, 0.34829727257876075`}, {0.6382859566974723, 
      0.9858087702655663, 0.347522813568094}, {0.6389214996851338, 
      0.9856697920583527, 0.3467482923732188}, {0.6395564635692429, 
      0.9855301731487476, 0.3459737095795046}, {0.6401908482965117, 
      0.9853899140683547, 0.3451990657718429}, {0.6408246538140405, 
      0.9852490153486904, 0.34442436153464984`}, {0.6414578800693183, 
      0.9851074775211828, 0.34364959745186446`}, {0.6420905270102232, 
      0.9849653011171725, 0.3428747741069493}, {0.6427225945850213, 
      0.9848224866679132, 0.34209989208289177`}, {0.6433540827423682, 
      0.9846790347045711, 0.34132495196220297`}, {0.643984991431306, 
      0.9845349457582262, 0.3405499543269201}, {0.6446153206012684, 
      0.984390220359871, 0.3397748997586027}, {0.645245070202075, 
      0.9842448590404127, 0.33899978883833753`}, {0.6458742401839358, 
      0.9840988623306713, 0.33822462214673554`}, {0.6465028304974481, 
      0.9839522307613817, 0.3374494002639338}, {0.6471308410935981, 
      0.9838049648631928, 0.33667412376959466`}, {0.6477582719237608, 
      0.9836570651666677, 0.33589879324290695`}, {0.6483851229396993, 
      0.9835085322022848, 0.33512340926258544`}, {0.6490113940935657, 
      0.9833593665004369, 0.3343479724068712}, {0.6496370853378994, 
      0.9832095685914323, 0.3335724832535327}, {0.6502621966256299, 
      0.9830591390054944, 0.3327969423798645}, {0.6508867279100737, 
      0.9829080782727623, 0.33202135036268854`}, {0.6515106791449361, 
      0.9827563869232909, 0.33124570777835477`}, {0.6521340502843107, 
      0.9826040654870509, 0.3304700152027401}, {0.6527568412826801, 
      0.9824511144939294, 0.3296942732112492}, {0.653379052094914, 
      0.9822975344737298, 0.32891848237881566`}, {0.6540006826762714, 
      0.9821433259561717, 0.32814264327990017`}, {0.6546217329823993, 
      0.981988489470892, 0.3273667564884926}, {0.6552422029693321, 
      0.9818330255474444, 0.3265908225781122}, {0.6558620925934935, 
      0.9816769347152995, 0.32581484212180595`}, {0.6564814018116949, 
      0.9815202175038455, 0.32503881569215065`}, {0.6571001305811355, 
      0.9813628744423881, 0.3242627438612525}, {0.6577182788594035, 
      0.9812049060601505, 0.3234866272007471}, {0.6583358466044738, 
      0.9810463128862743, 0.32271046628180056`}, {0.6589528337747104, 
      0.9808870954498188, 0.32193426167510836`}, {0.659569240328865, 
      0.9807272542797614, 0.3211580139508964}, {0.6601850662260771, 
      0.9805667899049986, 0.3203817236789213}, {0.6608003114258744, 
      0.9804057028543448, 0.31960539142847044`}, {0.6614149758881718, 
      0.9802439936565338, 0.3188290177683619}, {0.6620290595732728, 
      0.9800816628402181, 0.3180526032669454}, {0.6626425624418683, 
      0.9799187109339695, 0.3172761484921014}, {0.663255484455037, 
      0.9797551384662794, 0.3164996540112423}, {0.6638678255742453, 
      0.9795909459655577, 0.31572312039131245`}, {0.6644795857613471, 
      0.9794261339601354, 0.31494654819878815`}, {0.6650907649785842, 
      0.9792607029782623, 0.31416993799967785`}, {0.665701363188586, 
      0.9790946535481084, 0.3133932903595224}, {0.6663113803543691, 
      0.9789279861977644, 0.31261660584339535`}, {0.6669208164393372, 
      0.9787607014552412, 0.31183988501590393`}, {0.6675296714072828, 
      0.9785927998484696, 0.3110631284411867}, {0.6681379452223842, 
      0.9784242819053018, 0.3102863366829175}, {0.6687456378492083, 
      0.9782551481535104, 0.3095095103043021}, {0.6693527492527082, 
      0.9780853991207895, 0.3087326498680813}, {0.6699592793982251, 
      0.9779150353347535, 0.30795575593652846`}, {0.6705652282514869, 
      0.9777440573229391, 0.3071788290714523}, {0.671170595778608, 
      0.977572465612804, 0.3064018698341958}, {0.6717753819460919, 
      0.9774002607317271, 0.3056248787856352}, {0.6723795867208266, 
      0.9772274432070099, 0.3048478564861832}, {0.6729832100700889, 
      0.9770540135658753, 0.3040708034957863}, {0.6735862519615413, 
      0.9768799723354683, 0.3032937203739269}, {0.6741887123632341, 
      0.9767053200428562, 0.30251660767962196`}, {0.6747905912436034, 
      0.9765300572150287, 0.30173946597142526`}, {0.6753918885714728, 
      0.976354184378898, 0.30096229580742506`}, {0.6759926043160521, 
      0.9761777020612988, 0.30018509774524665`}, {0.6765927384469382, 
      0.9760006107889888, 0.2994078723420506}, {0.6771922909341139, 
      0.9758229110886486, 0.2986306201545347}, {0.6777912617479488, 
      0.9756446034868814, 0.29785334173893263`}, {0.6783896508591988, 
      0.9754656885102144, 0.29707603765101565`}, {0.6789874582390063, 
      0.9752861666850976, 0.2962987084460912}, {0.6795846838588997, 
      0.9751060385379045, 0.2955213546790047}, {0.680181327690794, 
      0.9749253045949323, 0.2947439769041384}, {0.6807773897069896, 
      0.974743965382402, 0.2939665756754124}, {0.6813728698801741, 
      0.9745620214264588, 0.29318915154628444`}, {0.6819677681834203, 
      0.9743794732531706, 0.29241170506975017`}, {0.6825620845901869, 
      0.9741963213885311, 0.29163423679834405`}, {0.6831558190743187, 
      0.974012566358457, 0.29085674728413824`}, {0.6837489716100466, 
      0.9738282086887902, 0.2900792370787435}, {0.6843415421719864, 
      0.9736432489052965, 0.28930170673331007`}, {0.6849335307351404, 
      0.9734576875336667, 0.2885241567985262}, {0.685524937274896, 
      0.9732715250995162, 0.28774658782462004`}, {0.6861157617670259, 
      0.9730847621283852, 0.28696900036135925`}, {0.6867060041876891, 
      0.9728973991457388, 0.2861913949580497}, {0.6872956645134289, 
      0.9727094366769677, 0.2854137721635387}, {0.6878847427211746, 
      0.9725208752473872, 0.2846361325262125}, {0.6884732387882404, 
      0.9723317153822381, 0.2838584765939976}, {0.6890611526923254, 
      0.9721419576066868, 0.2830808049143613}, {0.6896484844115142, 
      0.9719516024458253, 0.2823031180343109}, {0.6902352339242763, 
      0.9717606504246706, 0.28152541650039437`}, {0.6908214012094656, 
      0.9715691020681668, 0.2807477008587011}, {0.6914069862463216, 
      0.9713769579011824, 0.27996997165486076`}, {0.6919919890144678, 
      0.9711842184485127, 0.27919222943404487`}, {0.6925764094939123, 
      0.9709908842348791, 0.2784144747409667}, {0.6931602476650485, 
      0.9707969557849289, 0.27763670811988034`}, {0.6937435035086535, 
      0.9706024336232357, 0.2768589301145821}, {0.6943261770058892, 
      0.9704073182743, 0.27608114126841077`}, {0.6949082681383015, 
      0.9702116102625481, 0.2753033421242465}, {0.695489776887821, 
      0.9700153101123334, 0.2745255332245123}, {0.696070703236762, 
      0.9698184183479355, 0.27374771511117346`}, {0.6966510471678229, 
      0.9696209354935615, 0.27296988832573865`}, {0.6972308086640863, 
      0.9694228620733449, 0.27219205340925867`}, {0.697809987709018, 
      0.9692241986113465, 0.2714142109023283}, {0.6983885842864684, 
      0.9690249456315534, 0.270636361345085}, {0.698966598380671, 
      0.968825103657881, 0.26985850527720984`}, {0.6995440299762434, 
      0.9686246732141711, 0.2690806432379277}, {0.7001208790581862, 
      0.9684236548241933, 0.26830277576600703`}, {0.7006971456118838, 
      0.9682220490116445, 0.26752490339976076`}, {0.7012728296231034, 
      0.9680198563001491, 0.26674702667704553`}, {0.7018479310779959, 
      0.9678170772132592, 0.2659691461352632}, {0.7024224499630951, 
      0.9676137122744546, 0.26519126231135937`}, {0.7029963862653184, 
      0.9674097620071427, 0.26441337574182416`}, {0.7035697399719648, 
      0.9672052269346588, 0.263635486962694}, {0.7041425110707178, 
      0.9670001075802668, 0.2628575965095489}, {0.7047146995496422, 
      0.9667944044671575, 0.2620797049175153}, {0.705286305397186, 
      0.9665881181184508, 0.26130181272126485`}, {0.7058573286021802, 
      0.9663812490571944, 0.2605239204550142}, {0.7064277691538378, 
      0.9661737978063643, 0.25974602865252633`}, {0.7069976270417542, 
      0.9659657648888643, 0.2589681378471101}, {0.7075669022559069, 
      0.965757150827528, 0.258190248571621}, {0.7081355947866559, 
      0.965547956145116, 0.25741236135846013`}, {0.7087037046247426, 
      0.9653381813643185, 0.2566344767395758}, {0.7092712317612914, 
      0.9651278270077538, 0.25585659524646237`}, {0.7098381761878075, 
      0.9649168935979691, 0.25507871741016147`}, {0.7104045378961783, 
      0.9647053816574405, 0.25430084376126194`}, {0.7109703168786732, 
      0.9644932917085725, 0.2535229748298992}, {0.711535513127942, 
      0.9642806242736993, 0.2527451111457571}, {0.7121001266370176, 
      0.9640673798750833, 0.25196725323806557`}, {0.7126641573993123, 
      0.9638535590349165, 0.2511894016356042}, {0.7132276054086212, 
      0.96363916227532, 0.2504115568666987}, {0.7137904706591197, 
      0.9634241901183436, 0.24963371945922364`}, {0.7143527531453646, 
      0.9632086430859665, 0.24885588994060187`}, {0.714914452862293, 
      0.962992521700098, 0.24807806883780484`}, {0.7154755698052235, 
      0.9627758264825756, 0.24730025667735198`}, {0.7160361039698551, 
      0.9625585579551671, 0.2465224539853119}, {0.7165960553522668, 
      0.9623407166395694, 0.2457446612873025}, {0.7171554239489188, 
      0.962122303057409, 0.24496687910849008`}, {0.7177142097566518, 
      0.9619033177302422, 0.2441891079735903}, {0.7182724127726858, 
      0.9616837611795547, 0.24341134840686862`}, {0.7188300329946214, 
      0.9614636339267619, 0.24263360093214045`}, {0.7193870704204397, 
      0.9612429364932094, 0.2418558660727695}, {0.7199435250485009, 
      0.9610216694001721, 0.24107814435167113`}, {0.7204993968775453, 
      0.9607998331688551, 0.24030043629130976`}, {0.7210546859066929, 
      0.9605774283203934, 0.23952274241370047`}, {0.7216093921354434, 
      0.9603544553758521, 0.2387450632404085}, {0.7221635155636756, 
      0.9601309148562258, 0.23796739929255015`}, {0.7227170561916475, 
      0.9599068072824399, 0.23718975109079218`}, {0.723270014019997, 
      0.9596821331753493, 0.23641211915535223`}, {0.7238223890497406, 
      0.9594568930557396, 0.235634504005999}, {0.7243741812822734, 
      0.9592310874443265, 0.23485690616205288`}, {0.7249253907193702, 
      0.9590047168617554, 0.23407932614238502`}, {0.7254760173631839, 
      0.9587777818286026, 0.2333017644654187}, {0.7260260612162464, 
      0.9585502828653749, 0.2325242216491287}, {0.7265755222814673, 
      0.9583222204925091, 0.23174669821104182`}, {0.7271244005621356, 
      0.9580935952303726, 0.23096919466823704`}, {0.7276726960619178, 
      0.9578644075992632, 0.23019171153734533`}, {0.728220408784859, 
      0.9576346581194092, 0.22941424933455007`}, {0.7287675387353822, 
      0.9574043473109695, 0.22863680857558707`}, {0.7293140859182882, 
      0.9571734756940337, 0.22785938977574546`}, {0.7298600503387552, 
      0.9569420437886218, 0.22708199344986657`}, {0.7304054320023395, 
      0.9567100521146849, 0.2263046201123451}, {0.7309502309149749, 
      0.9564775011921042, 0.22552727027712927`}, {0.7314944470829724, 
      0.9562443915406921, 0.22474994445771962`}, {0.7320380805130202, 
      0.9560107236801917, 0.22397264316717141`}, {0.7325811312121842, 
      0.9557764981302768, 0.2231953669180924}, {0.7331235991879061, 
      0.9555417154105518, 0.2224181162226457}, {0.7336654844480058, 
      0.9553063760405527, 0.2216408915925469}, {0.734206787000679, 
      0.9550704805397457, 0.22086369353906657`}, {0.7347475068544987, 
      0.9548340294275283, 0.22008652257302924`}, {0.7352876440184145, 
      0.9545970232232284, 0.21930937920481386`}, {0.7358271985017512, 
      0.9543594624461056, 0.21853226394435432`}, {0.7363661703142107, 
      0.9541213476153504, 0.21775517730113955`}, {0.7369045594658713, 
      0.9538826792500837, 0.21697811978421247`}, {0.7374423659671864, 
      0.9536434578693586, 0.21620109190217213`}, {0.7379795898289863, 
      0.9534036839921577, 0.2154240941631715}, {0.7385162310624761, 
      0.9531633581373964, 0.21464712707492023`}, {0.7390522896792368, 
      0.9529224808239201, 0.21387019114468317`}, {0.7395877656912249, 
      0.9526810525705056, 0.21309328687928064`}, {0.7401226591107725, 
      0.9524390738958611, 0.2123164147850885}, {0.7406569699505864, 
      0.9521965453186259, 0.2115395753680394}, {0.7411906982237486, 
      0.9519534673573703, 0.2107627691336217}, {0.7417238439437159, 
      0.9517098405305963, 0.20998599658688033`}, {0.7422564071243204, 
      0.9514656653567365, 0.20920925823241612`}, {0.7427883877797679, 
      0.9512209423541557, 0.20843255457438775`}, {0.7433197859246401, 
      0.950975672041149, 0.20765588611650873`}, {0.7438506015738918, 
      0.9507298549359432, 0.20687925336205126`}, {0.7443808347428524, 
      0.9504834915566966, 0.20610265681384407`}, {0.744910485447226, 
      0.9502365824214988, 0.20532609697427257`}, {0.7454395537030896, 
      0.9499891280483705, 0.2045495743452807}, {0.7459680395268953, 
      0.9497411289552636, 0.2037730894283682}, {0.7464959429354676, 
      0.9494925856600622, 0.20299664272459447`}, {0.7470232639460054, 
      0.9492434986805809, 0.20222023473457543`}, {0.747550002576081, 
      0.9489938685345661, 0.2014438659584852}, {0.7480761588436392, 
      0.9487436957396957, 0.20066753689605646`}, {0.7486017327669988, 
      0.9484929808135788, 0.19989124804657987`}, {0.7491267243648516, 
      0.9482417242737554, 0.199114999908904}, {0.7496511336562613, 
      0.9479899266376985, 0.19833879298143703`}, {0.7501749606606654, 
      0.9477375884228109, 0.19756262776214542`}, {0.7506982053978734, 
      0.9474847101464274, 0.19678650474855403`}, {0.7512208678880673, 
      0.9472312923258148, 0.19601042443774738`}, {0.7517429481518014, 
      0.9469773354781704, 0.1952343873263689}, {0.7522644462100023, 
      0.9467228401206238, 0.1944583939106214}, {0.7527853620839683, 
      0.9464678067702356, 0.19368244468626722`}, {0.7533056957953699, 
      0.9462122359439976, 0.19290654014862782`}, {0.7538254473662489, 
      0.945956128158834, 0.19213068079258525`}, {0.754344616819019, 
      0.9456994839315996, 0.19135486711258062`}, {0.7548632041764655, 
      0.9454423037790811, 0.1905790996026155}, {0.7553812094617444, 
      0.9451845882179962, 0.18980337875625192`}, {0.755898632698383, 
      0.9449263377649947, 0.18902770506661168`}, {0.7564154739102801, 
      0.9446675529366577, 0.1882520790263775}, {0.7569317331217048, 
      0.9444082342494973, 0.1874765011277924}, {0.7574474103572967, 
      0.9441483822199576, 0.1867009718626607}, {0.7579625056420671, 
      0.9438879973644135, 0.18592549172234632`}, {0.7584770190013962, 
      0.9436270801991725, 0.18515006119777636`}, {0.7589909504610352, 
      0.9433656312404725, 0.18437468077943725`}, {0.7595043000471057, 
      0.9431036510044831, 0.18359935095737742`}, {0.7600170677860985, 
      0.9428411400073058, 0.18282407222120733`}, {0.7605292537048748, 
      0.9425780987649728, 0.18204884506009802`}, {0.761040857830665, 
      0.9423145277934483, 0.1812736699627832}, {0.7615518801910698, 
      0.9420504276086278, 0.18049854741755791`}, {0.7620623208140581, 
      0.9417857987263378, 0.17972347791227963`}, {0.7625721797279686, 
      0.941520641662337, 0.1789484619343682}, {0.7630814569615099, 
      0.9412549569323145, 0.1781734999708046}, {0.7635901525437576, 
      0.9409887450518917, 0.17739859250813414`}, {0.7640982665041575, 
      0.9407220065366211, 0.17662374003246362`}, {0.7646057988725233, 
      0.9404547419019861, 0.1758489430294626}, {0.7651127496790381, 
      0.9401869516634018, 0.17507420198436374`}, {0.7656191189542522, 
      0.9399186363362148, 0.17429951738196267`}, {0.7661249067290841, 
      0.9396497964357031, 0.17352488970661883`}, {0.7666301130348212, 
      0.9393804324770753, 0.17275031944225386`}, {0.7671347379031178, 
      0.9391105449754715, 0.17197580707235377`}, {0.7676387813659963, 
      0.9388401344459644, 0.17120135307996803`}, {0.7681422434558466, 
      0.938569201403556, 0.17042695794770923`}, {0.7686451242054257, 
      0.9382977463631808, 0.16965262215775476`}, {0.7691474236478584, 
      0.938025769839704, 0.1688783461918454}, {0.769649141816636, 
      0.937753272347922, 0.16810413053128603`}, {0.7701502787456165, 
      0.9374802544025633, 0.16732997565694674`}, {0.7706508344690252, 
      0.9372067165182864, 0.1665558820492612}, {0.7711508090214538, 
      0.9369326592096815, 0.1657818501882276}, {0.7716502024378605, 
      0.93665808299127, 0.16500788055340926`}, {0.7721490147535697, 
      0.936382988377504, 0.16423397362393422`}, {0.7726472460042715, 
      0.9361073758827672, 0.16346012987849554`}, {0.7731448962260227, 
      0.9358312460213739, 0.16268634979535126`}, {0.7736419654552453, 
      0.9355545993075702, 0.16191263385232482`}, {0.774138453728727, 
      0.9352774362555324, 0.1611389825268054}, {0.7746343610836214, 
      0.9349997573793685, 0.16036539629574695`}, {0.7751296875574469, 
      0.9347215631931166, 0.15959187563566973`}, {0.7756244331880873, 
      0.934442854210747, 0.1588184210226596}, {0.7761185980137915, 
      0.93416363094616, 0.1580450329323684}, {0.7766121820731732, 
      0.9338838939131868, 0.15727171184001365`}, {0.77710518540521, 
      0.9336036436255903, 0.1564984582203801}, {0.7775976080492455, 
      0.9333228805970631, 0.1557252725478176}, {0.7780894500449864, 
      0.9330416053412299, 0.15495215529624343`}, {0.7785807114325041, 
      0.9327598183716455, 0.15417910693914114`}, {0.7790713922522341, 
      0.932477520201795, 0.1534061279495608}, {0.779561492544975, 
      0.9321947113450952, 0.15263321880012024`}, {0.7800510123518902, 
      0.9319113923148935, 0.15186037996300322`}, {0.7805399517145062, 
      0.9316275636244675, 0.1510876119099612}, {0.7810283106747127, 
      0.9313432257870257, 0.15031491511231299`}, {0.7815160892747626, 
      0.9310583793157073, 0.14954229004094466`}, {0.7820032875572718, 
      0.9307730247235821, 0.14876973716631026`}, {0.7824899055652195, 
      0.9304871625236504, 0.14799725695843094`}, {0.7829759433419472, 
      0.930200793228843, 0.14722484988689588`}, {0.7834614009311593, 
      0.9299139173520216, 0.1464525164208622}, {0.7839462783769222, 
      0.9296265354059778, 0.14568025702905535`}, {0.7844305757236649, 
      0.9293386479034339, 0.14490807217976887`}, {0.7849142930161779, 
      0.929050255357043, 0.1441359623408649}, {0.7853974302996143, 
      0.9287613582793875, 0.1433639279797732}, {0.7858799876194882, 
      0.9284719571829819, 0.1425919695634935}, {0.7863619650216761, 
      0.9281820525802691, 0.141820087558593}, {0.7868433625524148, 
      0.9278916449836236, 0.14104828243120865`}, {0.7873241802583036, 
      0.9276007349053497, 0.14027655464704586`}, {0.7878044181863018, 
      0.9273093228576816, 0.13950490467137974`}, {0.7882840763837299, 
      0.9270174093527842, 0.13873333296905416`}, {0.7887631548982693, 
      0.9267249949027523, 0.1379618400044829}, {0.789241653777962, 
      0.9264320800196107, 0.1371904262416487}, {0.7897195730712097, 
      0.9261386652153146, 0.1364190921441049}, {0.7901969128267751, 
      0.9258447510017487, 0.1356478381749737}, {0.7906736730937809, 
      0.925550337890728, 0.13487666479694713`}, {0.7911498539217091, 
      0.9252554263939977, 0.13410557247228838`}, {0.7916254553604017, 
      0.9249600170232319, 0.13333456166283017`}, {0.7921004774600607, 
      0.9246641102900359, 0.132563632829975}, {0.7925749202712465, 
      0.9243677067059437, 0.13179278643469716`}, {0.7930487838448794, 
      0.9240708067824199, 0.1310220229375404}, {0.7935220682322388, 
      0.9237734110308582, 0.13025134279861925`}, {0.7939947734849621, 
      0.9234755199625826, 0.12948074647762034`}, {0.7944668996550466, 
      0.9231771340888458, 0.1287102344337992}, {0.7949384467948469, 
      0.9228782539208313, 0.12793980712598427`}, {0.795409414957077, 
      0.9225788799696514, 0.12716946501257417`}, {0.7958798041948081, 
      0.9222790127463479, 0.12639920855153977`}, {0.7963496145614702, 
      0.9219786527618926, 0.12562903820042226`}, {0.7968188461108505, 
      0.9216778005271864, 0.12485895441633582`}, {0.7972874988970945, 
      0.9213764565530596, 0.12408895765596487`}, {0.7977555729747045, 
      0.9210746213502714, 0.12331904837556693`}, {0.7982230683985401, 
      0.9207722954295113, 0.12254922703097122`}, {0.7986899852238187, 
      0.9204694793013971, 0.12177949407757829`}, {0.7991563235061141, 
      0.9201661734764767, 0.12100984997036249`}, {0.7996220833013571, 
      0.9198623784652262, 0.12024029516386903`}, {0.800087264665835, 
      0.9195580947780517, 0.11947083011221647`}, {0.8005518676561914, 
      0.9192533229252875, 0.11870145526909595`}, {0.8010158923294266, 
      0.9189480634171973, 0.1179321710877707}, {0.8014793387428966, 
      0.9186423167639743, 0.11716297802107754`}, {0.8019422069543131, 
      0.9183360834757397, 0.1163938765214266}, {0.8024044970217439, 
      0.9180293640625443, 0.11562486704080033`}, {0.8028662090036125, 
      0.9177221590343673, 0.1148559500307547}, {0.8033273429586972, 
      0.9174144689011168, 0.11408712594241958`}, {0.8037878989461322, 
      0.9171062941726297, 0.11331839522649736`}, {0.8042478770254058, 
      0.9167976353586712, 0.1125497583332654}, {0.8047072772563624, 
      0.916488492968936, 0.11178121571257336`}, {0.8051660996991997, 
      0.9161788675130461, 0.11101276781384625`}, {0.805624344414471, 
      0.915868759500553, 0.11024441508608192`}, {0.8060820114630831, 
      0.9155581694409364, 0.10947615797785316`}, {0.8065391009062974, 
      0.9152470978436043, 0.10870799693730662`}, {0.8069956128057293, 
      0.914935545217893, 0.10793993241216362`}, {0.8074515472233478, 
      0.9146235120730674, 0.10717196484971954`}, {0.8079069042214752, 
      0.9143109989183206, 0.1064040946968452}, {0.808361683862788, 
      0.9139980062627732, 0.10563632239998517`}, {0.8088158862103152, 
      0.9136845346154752, 0.10486864840515997`}, {0.8092695113274392, 
      0.9133705844854038, 0.10410107315796435`}, {0.8097225592778955, 
      0.9130561563814641, 0.10333359710356853`}, {0.8101750301257714, 
      0.9127412508124899, 0.10256622068671847`}, {0.8106269239355083, 
      0.9124258682872424, 0.10179894435173416`}, {0.811078240771898, 
      0.9121100093144111, 0.10103176854251303`}, {0.8115289807000863, 
      0.9117936744026127, 0.10026469370252632`}, {0.8119791437855696, 
      0.9114768640603922, 0.09949772027482257}, {0.8124287300941971, 
      0.9111595787962219, 0.09873084870202468}, {0.8128777396921687, 
      0.9108418191185019, 0.09796407942633312}, {0.8133261726460369, 
      0.9105235855355603, 0.09719741288952337}, {0.8137740290227043, 
      0.9102048785556519, 0.0964308495329474}, {0.8142213088894253, 
      0.9098856986869596, 0.0956643897975343}, {0.8146680123138048, 
      0.9095660464375934, 0.09489803412378861}, {0.8151141393637987, 
      0.9092459223155912, 0.09413178295179243}, {0.8155596901077136, 
      0.9089253268289172, 0.09336563672120365}, {0.8160046646142058, 
      0.9086042604854642, 0.09259959587125823}, {0.8164490629522825, 
      0.9082827237930506, 0.09183366084076787}, {0.8168928851913002, 
      0.9079607172594228, 0.09106783206812251}, {0.8173361314009658, 
      0.9076382413922546, 0.09030210999128853}, {0.8177788016513357, 
      0.9073152966991459, 0.08953649504781026}, {0.8182208960128153, 
      0.9069918836876243, 0.08877098767480894}, {0.8186624145561596, 
      0.9066680028651437, 0.08800558830898389}, {0.8191033573524733, 
      0.9063436547390853, 0.08724029738661196}, {0.8195437244732084, 
      0.9060188398167566, 0.08647511534354814}, {0.8199835159901675, 
      0.9056935586053921, 0.08571004261522462}, {0.8204227319755003, 
      0.9053678116121532, 0.08494507963665283}, {0.8208613725017052, 
      0.9050415993441271, 0.08418022684242178}, {0.8212994376416292, 
      0.9047149223083277, 0.08341548466669844}, {0.8217369274684667, 
      0.9043877810116959, 0.0826508535432292}, {0.8221738420557606, 
      0.9040601759610988, 0.08188633390533817}, {0.8226101814774004, 
      0.9037321076633292, 0.08112192618592846}, {0.823045945807624, 
      0.9034035766251066, 0.08035763081748258}, {0.8234811351210157, 
      0.9030745833530771, 0.07959344823206109}, {0.8239157494925079, 
      0.9027451283538118, 0.07882937886130392}, {0.8243497889973784, 
      0.9024152121338089, 0.07806542313643063}, {0.824783253711253, 
      0.9020848351994927, 0.0773015814882395}, {0.8252161437101034, 
      0.9017539980572122, 0.07653785434710891}, {0.8256484590702475, 
      0.9014227012132436, 0.07577424214299575}, {0.8260801998683498, 
      0.9010909451737876, 0.07501074530543772}, {0.8265113661814203, 
      0.900758730444972, 0.07424736426355148}, {0.8269419580868148, 
      0.9004260575328493, 0.07348409944603443}, {0.827371975662235, 
      0.9000929269433979, 0.07272095128116289}, {0.8278014189857271, 
      0.8997593391825217, 0.07195792019679469}, {0.8282302881356838, 
      0.8994252947560506, 0.07119500662036653}, {0.8286585831908417, 
      0.8990907941697384, 0.07043221097889642}, {0.829086304230283, 
      0.898755837929266, 0.06966953369898304}, {0.8295134513334336, 
      0.8984204265402387, 0.06890697520680503}, {0.8299400245800647, 
      0.8980845605081866, 0.06814453592812213}, {0.830366024050291, 
      0.8977482403385659, 0.06738221628827475}, {0.8307914498245724, 
      0.8974114665367573, 0.06662001671218462}, {0.8312163019837117, 
      0.8970742396080659, 0.06585793762435431}, {0.8316405806088553, 
      0.8967365600577233, 0.06509597944886795}, {0.8320642857814937, 
      0.8963984283908843, 0.06433414260939058}, {0.8324874175834605, 
      0.8960598451126296, 0.0635724275291691}, {0.8329099760969318, 
      0.8957208107279642, 0.06281083463103226}, {0.8333319614044283, 
      0.8953813257418173, 0.06204936433738899}, {0.8337533735888112, 
      0.895041390659044, 0.06128801707023231}, {0.8341742127332863, 
      0.8947010059844216, 0.060526793251135344`}, {0.8345944789214004, 
      0.894360172222655, 0.05976569330125434}, {0.8350141722370429, 
      0.8940188898783702, 0.059004717641327115`}, {0.8354332927644451, 
      0.8936771594561201, 0.05824386669167473}, {0.8358518405881808, 
      0.8933349814603799, 0.057483140872198885`}, {0.8362698157931643, 
      0.8929923563955504, 0.05672254060238613}, {0.8366872184646521, 
      0.8926492847659557, 0.05596206630130359}, {0.8371040486882413, 
      0.8923057670758441, 0.05520171838760274}, {0.8375203065498706, 
      0.8919618038293878, 0.054441497279517005`}, {0.8379359921358196, 
      0.8916173955306828, 0.05368140339486303}, {0.8383511055327082, 
      0.8912725426837487, 0.05292143715104059}, {0.8387656468274965, 
      0.8909272457925297, 0.052161598965033036`}, {0.8391796161074857, 
      0.8905815053608928, 0.05140188925340693}, {0.8395930134603165, 
      0.8902353218926284, 0.05064230843231195}, {0.8400058389739694, 
      0.8898886958914515, 0.04988285691748191}, {0.8404180927367652, 
      0.8895416278609992, 0.04912353512423385}, {0.8408297748373635, 
      0.8891941183048327, 0.04836434346746934}, {0.8412408853647639, 
      0.8888461677264372, 0.04760528236167323}, {0.8416514244083045, 
      0.8884977766292195, 0.046846352220914815`}, {0.842061392057663, 
      0.8881489455165101, 0.04608755345884722}, {0.8424707884028548, 
      0.8877996748915638, 0.045328886488708746`}, {0.8428796135342352, 
      0.8874499652575564, 0.044570351723321036`}, {0.8432878675424968, 
      0.8870998171175879, 0.043811949575090985`}, {0.8436955505186711, 
      0.8867492309746812, 0.04305368045600997}, {0.844102662554127, 
      0.8863982073317811, 0.042295544777654154`}, {0.8445092037405714, 
      0.886046746691756, 0.04153754295118447}, {0.844915174170049, 
      0.885694849557396, 0.040779675387346934`}, {0.8453205739349418, 
      0.8853425164314147, 0.040021942496472895`}, {0.8457254031279685, 
      0.8849897478164473, 0.03926434468847885}, {0.8461296618421859, 
      0.8846365442150524, 0.03850688237286654}, {0.8465333501709864, 
      0.88428290612971, 0.03774955595872359}, {0.8469364682081, 
      0.8839288340628222, 0.03699236585472232}, {0.8473390160475924, 
      0.8835743285167147, 0.03623531246912208}, {0.8477409937838664, 
      0.8832193899936331, 0.035478396209766803`}, {0.8481424015116599, 
      0.8828640189957474, 0.03472161748408736}, {0.8485432393260472, 
      0.8825082160251473, 0.0339649766990999}, {0.8489435073224385, 
      0.8821519815838461, 0.033208474261407606`}, {0.8493432055965787, 
      0.8817953161737782, 0.03245211057719905}, {0.8497423342445489, 
      0.8814382202967986, 0.0316958860522497}, {0.8501408933627645, 
      0.8810806944546866, 0.03093980109192217}, {0.8505388830479764, 
      0.8807227391491406, 0.030183856101164187`}, {0.8509363033972696, 
      0.8803643548817816, 0.029428051484511965`}, {0.8513331545080638, 
      0.8800055421541512, 0.02867238764608733}, {0.8517294364781136, 
      0.8796463014677136, 0.02791686498959985}, {0.8521251494055069, 
      0.8792866333238529, 0.02716148391834623}, {0.8525202933886663, 
      0.8789265382238755, 0.026406244835209133`}, {0.852914868526347, 
      0.878566016669008, 0.025651148142660955`}, {0.853308874917639, 
      0.8782050691603984, 0.024896194242759278`}, {0.8537023126619648, 
      0.8778436961991153, 0.024141383537150448`}, {0.854095181859081, 
      0.8774818982861492, 0.02338671642706818}, {0.8544874826090753, 
      0.8771196759224097, 0.022632193313334385`}, {0.8548792150123702, 
      0.8767570296087286, 0.021877814596358416`}, {0.8552703791697194, 
      0.8763939598458578, 0.02112358067613812}, {0.85566097518221, 
      0.876030467134469, 0.020369491952259053`}, {0.8560510031512604, 
      0.8756665519751559, 0.019615548823895337`}, {0.8564404631786214, 
      0.8753022148684307, 0.01886175168980929}, {0.8568293553663752, 
      0.8749374563147277, 0.0181081009483527}, {0.8572176798169362, 
      0.8745722768144005, 0.01735459699746437}, {0.8576054366330498, 
      0.8742066768677227, 0.01660124023467284}, {0.8579926259177926, 
      0.8738406569748883, 0.015848031057095605`}, {0.8583792477745724, 
      0.873474217636011, 0.015094969861438517`}, {0.8587653023071274, 
      0.8731073593511252, 0.01434205704399768}, {0.8591507896195271, 
      0.872740082620184, 0.01358929300065678}, {0.8595357098161708, 
      0.8723723879430609, 0.012836678126890246`}, {0.8599200630017877, 
      0.8720042758195493, 0.012084212817761389`}, {0.8603038492814385, 
      0.8716357467493612, 0.01133189746792265}, {0.8606870687605122, 
      0.8712668012321291, 0.01057973247161709}, {0.8610697215447279, 
      0.8708974397674046, 0.009827718222676736}, {0.8614518077401347, 
      0.8705276628546587, 0.00907585511452408}, {0.86183332745311, 
      0.8701574709932813, 0.00832414354017105}, {0.8622142807903609, 
      0.8697868646825819, 0.007572583892220934}, {0.8625946678589232, 
      0.8694158444217888, 0.006821176562865454}, {0.8629744887661617, 
      0.8690444107100497, 0.006069921943887947}, {0.8633537436197682, 
      0.8686725640464308, 0.005318820426662546}, {0.8637324325277649, 
      0.8683003049299176, 0.004567872402152729}, {0.8641105555985004, 
      0.8679276338594138, 0.003817078260913448}, {0.864488112940652, 
      0.8675545513337428, 0.0030664383930907274`}, {0.8648651046632243, 
      0.8671810578516456, 0.0023159531884210517`}, {0.8652415308755498, 
      0.866807153911782, 0.0015656230362322296`}, {0.8656173916872877, 
      0.8664328400127302, 0.000815448325442574}, {0.8659926872084242, 
      0.8660581166529879, 0.00006542944456344141}, {0.8663674175492735, 
      0.8656829843309687, 0.0006844332183047444}, {0.8667415828204754, 
      0.8653074435450073, 0.0014341392754682668`}, {0.8671151831329963, 
      0.8649314947933541, 0.0021836883396424136`}, {0.8674882185981293, 
      0.8645551385741788, 0.002933080023950408}, {0.8678606893274932, 
      0.8641783753855689, 0.0036823139419242335`}, {0.8682325954330332, 
      0.8638012057255297, 0.004431389707503567}, {0.8686039370270198, 
      0.8634236300919844, 0.005180306935035554}, {0.8689747142220491, 
      0.8630456489827735, 0.00592906523927563}, {0.8693449271310424, 
      0.8626672628956555, 0.006677664235386886}, {0.8697145758672463, 
      0.8622884723283069, 0.007426103538939624}, {0.8700836605442321, 
      0.8619092777783205, 0.008174382765911975}, {0.8704521812758962, 
      0.8615296797432076, 0.008922501532688846}, {0.8708201381764591, 
      0.8611496787203962, 0.009670459456063157}, {0.8711875313604658, 
      0.8607692752072317, 0.010418256153234155`}, {0.8715543609427855, 
      0.8603884697009767, 0.011165891241808874`}, {0.8719206270386111, 
      0.8600072626988114, 0.011913364339799804`}, {0.8722863297634593, 
      0.8596256546978317, 0.012660675065627628`}, {0.8726514692331707, 
      0.8592436461950518, 0.01340782303811931}, {0.8730160455639088, 
      0.8588612376874012, 0.014154807876507882`}, {0.8733800588721602, 
      0.8584784296717275, 0.014901629200432849`}, {0.8737435092747344, 
      0.8580952226447945, 0.01564828662994018}, {0.8741063968887647, 
      0.857711617103282, 0.01639477978548275}, {0.8744687218317053, 
      0.8573276135437874, 0.017141108287917966`}, {0.8748304842213334, 
      0.8569432124628239, 0.017887271758509713`}, {0.8751916841757494, 
      0.8565584143568206, 0.01863326981892893}, {0.8755523218133737, 
      0.8561732197221236, 0.01937910209125027}, {0.8759123972529501, 
      0.8557876290549943, 0.02012476819795567}, {0.876271910613543, 
      0.8554016428516118, 0.02087026776193137}, {0.8766308620145387, 
      0.8550152616080691, 0.021615600406469856`}, {0.8769892515756444, 
      0.8546284858203763, 0.022360765755268124`}, {0.8773470794168885, 
      0.8542413159844594, 0.023105763432429385`}, {0.8777043456586194, 
      0.8538537525961596, 0.0238505930624597}, {0.8780610504215073, 
      0.8534657961512343, 0.02459525427027302}, {0.8784171938265414, 
      0.8530774471453563, 0.025339746681185497`}, {0.8787727759950323, 
      0.8526887060741132, 0.02608406992091908}, {0.8791277970486097, 
      0.8522995734330093, 0.02682822361560023}, {0.8794822571092239, 
      0.8519100497174633, 0.027572207391760573`}, {0.8798361562991436, 
      0.8515201354228097, 0.028316020876334155`}, {0.880189494740958, 
      0.8511298310442974, 0.029059663696660593`}, {0.8805422725575748, 
      0.850739137077091, 0.02980313548048383}, {0.8808944898722211, 
      0.8503480540162702, 0.03054643585595088}, {0.8812461468084424, 
      0.8499565823568294, 0.03128956445161325}, {0.8815972434901033, 
      0.8495647225936772, 0.032032520896426206`}, {0.8819477800413859, 
      0.8491724752216381, 0.03277530481974781}, {0.8822977565867915, 
      0.8487798407354508, 0.03351791585134092}, {0.8826471732511391, 
      0.848386819629768, 0.034260353621371045`}, {0.8829960301595647, 
      0.8479934123991574, 0.0350026177604072}, {0.8833443274375229, 
      0.8475996195381021, 0.03574470789942084}, {0.8836920652107854, 
      0.8472054415409975, 0.03648662366978782}, {0.8840392436054406, 
      0.8468108789021547, 0.037228364703286}, {0.8843858627478948, 
      0.8464159321157985, 0.037969930632096194`}, {0.88473192276487, 
      0.8460206016760676, 0.038711321088802285`}, {0.8850774237834057, 
      0.8456248880770161, 0.039452535706389846`}, {0.8854223659308578, 
      0.8452287918126093, 0.04019357411824862}, {0.8857667493348976, 
      0.8448323133767287, 0.04093443595816921}, {0.8861105741235135, 
      0.8444354532631688, 0.041675120860344694`}, {0.8864538404250084, 
      0.8440382119656377, 0.042415628459370754`}, {0.8867965483680015, 
      0.8436405899777573, 0.043155958390244505`}, {0.8871386980814282, 
      0.8432425877930623, 0.04389611028836629}, {0.887480289694538, 
      0.8428442059050014, 0.0446360837895367}, {0.8878213233368957, 
      0.8424454448069372, 0.04537587852995869}, {0.8881617991383807, 
      0.8420463049921443, 0.046115494146236335`}, {0.8885017172291877, 
      0.8416467869538115, 0.046854930275376544`}, {0.8888410777398252, 
      0.8412468911850399, 0.04759418655478528}, {0.889179880801116, 
      0.8408466181788443, 0.04833326262227152}, {0.8895181265441975, 
      0.8404459684281526, 0.04907215811604483}, {0.8898558151005199, 
      0.840044942425804, 0.04981087267471597}, {0.890192946601848, 
      0.8396435406645526, 0.050549405937295615`}, {0.8905295211802595, 
      0.8392417636370633, 0.05128775754319633}, {0.8908655389681454, 
      0.8388396118359146, 0.05202592713223086}, {0.8912010000982098, 
      0.8384370857535973, 0.05276391434461255}, {0.8915359047034698, 
      0.8380341858825147, 0.05350171882095523}, {0.8918702529172545, 
      0.8376309127149827, 0.05423934020227212}, {0.8922040448732066, 
      0.8372272667432282, 0.054976778129978324`}, {0.8925372807052796, 
      0.8368232484593919, 0.05571403224588763}, {0.8928699605477399, 
      0.8364188583555261, 0.05645110219221387}, {0.8932020845351659, 
      0.8360140969235943, 0.05718798761157182}, {0.8935336528024472, 
      0.8356089646554733, 0.0579246881469743}, {0.8938646654847849, 
      0.8352034620429496, 0.058661203441835105`}, {0.8941951227176913, 
      0.834797589577725, 0.059397533139966756`}, {0.8945250246369906, 
      0.8343913477514086, 0.06013367688558215}, {0.8948543713788162, 
      0.8339847370555247, 0.06086963432329147}, {0.8951831630796137, 
      0.8335777579815072, 0.06160540509810659}, {0.8955113998761381, 
      0.8331704110207021, 0.06234098885543607}, {0.8958390819054552, 
      0.8327626966643672, 0.06307638524108816}, {0.8961662093049413, 
      0.8323546154036701, 0.06381159390127115}, {0.8964927822122811, 
      0.8319461677296913, 0.06454661448259015}, {0.8968188007654703, 
      0.8315373541334211, 0.06528144663204949}, {0.8971442651028139, 
      0.8311281751057613, 0.0660160899970527}, {0.8974691753629257, 
      0.8307186311375249, 0.06675054422540096}, {0.8977935316847283, 
      0.8303087227194356, 0.0674848089652929}, {0.8981173342074542, 
      0.8298984503421278, 0.0682188838653266}, {0.898440583070644, 
      0.8294878144961463, 0.06895276857449786}, {0.8987632784141464, 
      0.8290768156719468, 0.06968646274219967}, {0.899085420378119, 
      0.8286654543598965, 0.07041996601822302}, {0.8994070091030271, 
      0.8282537310502711, 0.07115327805275629}, {0.8997280447296444, 
      0.8278416462332572, 0.07188639849638699}, {0.9000485273990514, 
      0.827429200398954, 0.07261932700009743}, {0.9003684572526368, 
      0.8270163940373675, 0.07335206321526944}, {0.9006878344320961, 
      0.8266032276384161, 0.07408460679368013}, {0.9010066590794326, 
      0.826189701691927, 0.0748169573875056}, {0.9013249313369555, 
      0.825775816687639, 0.07554911464931684}, {0.9016426513472818, 
      0.8253615731151984, 0.07628107823208372}, {0.9019598192533342, 
      0.8249469714641632, 0.07701284778917125}, {0.902276435198342, 
      0.8245320122240003, 0.07774442297434168}, {0.9025924993258403, 
      0.8241166958840868, 0.07847580344175355}, {0.9029080117796705, 
      0.823701022933709, 0.07920698884596183}, {0.9032229727039796, 
      0.823284993862062, 0.07993797884191767}, {0.9035373822432201, 
      0.8228686091582514, 0.08066877308496852}, {0.9038512405421494, 
      0.8224518693112924, 0.08139937123085739}, {0.9041645477458307, 
      0.8220347748101072, 0.08212977293572349}, {0.9044773039996317, 
      0.8216173261435302, 0.08285997785610165}, {0.9047895094492252, 
      0.8211995238003027, 0.08358998564892274}, {0.905101164240588, 
      0.820781368269075, 0.08431979597151316}, {0.9054122685200012, 
      0.8203628600384077, 0.08504940848159351}, {0.9057228224340507, 
      0.8199439995967699, 0.08577882283728121}, {0.9060328261296259, 
      0.8195247874325378, 0.08650803869708819}, {0.9063422797539199, 
      0.8191052240339984, 0.08723705571992144}, {0.9066511834544292, 
      0.8186853098893461, 0.08796587356508313}, {0.906959537378954, 
      0.8182650454866848, 0.08869449189226943}, {0.9072673416755976, 
      0.8178444313140247, 0.08942291036157293}, {0.9075745964927661, 
      0.8174234678592873, 0.09015112863347902}, {0.9078813019791682, 
      0.8170021556102998, 0.0908791463688687}, {0.9081874582838155, 
      0.8165804950547989, 0.09160696322901653}, {0.9084930655560217, 
      0.8161584866804296, 0.0923345788755921}, {0.908798123945403, 
      0.8157361309747444, 0.09306199297065881}, {0.9091026336018768, 
      0.8153134284252036, 0.09378920517667341}, {0.9094065946756633, 
      0.814890379519176, 0.0945162151564879}, {0.9097100073172839, 
      0.8144669847439368, 0.09524302257334731}, {0.9100128716775608, 
      0.8140432445866712, 0.09596962709088973}, {0.9103151879076178, 
      0.8136191595344704, 0.09669602837314757}, {0.91061695615888, 
      0.8131947300743335, 0.0974222260845469}, {0.9109181765830731, 
      0.8127699566931668, 0.09814821988990624}, {0.9112188493322225, 
      0.8123448398777854, 0.09887400945443758}, {0.9115189745586557, 
      0.811919380114909, 0.09959959444374707}, {0.9118185524149992, 
      0.8114935778911674, 0.10032497452383185`}, {0.9121175830541794, 
      0.8110674336930963, 0.10105014936108318`}, {0.9124160666294232, 
      0.8106409480071383, 0.10177511862228504`}, {0.9127140032942568, 
      0.8102141213196434, 0.10249988197461325`}, {0.9130113932025057, 
      0.8097869541168684, 0.10322443908563728`}, {0.913308236508295, 
      0.8093594468849772, 0.10394878962331787`}, {0.9136045333660482, 
      0.8089316001100394, 0.1046729332560089}, {0.9139002839304878, 
      0.8085034142780334, 0.10539686965245464`}, {0.9141954883566359, 
      0.8080748898748421, 0.10612059848179416`}, {0.9144901467998118, 
      0.8076460273862559, 0.10684411941355595`}, {0.9147842594156333, 
      0.8072168272979717, 0.10756743211766169`}, {0.9150778263600169, 
      0.8067872900955931, 0.10829053626442388`}, {0.9153708477891759, 
      0.8063574162646292, 0.10901343152454701`}, {0.9156633238596225, 
      0.8059272062904955, 0.10973611756912692`}, {0.9159552547281652, 
      0.8054966606585148, 0.11045859406965071`}, {0.9162466405519107, 
      0.8050657798539136, 0.11118086069799721`}, {0.9165374814882623, 
      0.8046345643618273, 0.11190291712643495`}, {0.9168277776949199, 
      0.8042030146672954, 0.11262476302762467`}, {0.9171175293298807, 
      0.8037711312552634, 0.11334639807461734`}, {0.9174067365514381, 
      0.8033389146105832, 0.11406782194085502`}, {0.9176953995181816, 
      0.802906365218012, 0.11478903430016947`}, {0.917983518388997, 
      0.802473483562213, 0.11551003482678425`}, {0.9182710933230662, 
      0.802040270127754, 0.11623082319531255`}, {0.9185581244798671, 
      0.801606725399109, 0.11695139908075813`}, {0.9188446120191716, 
      0.8011728498606581, 0.11767176215851372`}, {0.9191305561010485, 
      0.8007386439966853, 0.11839191210436337`}, {0.9194159568858613, 
      0.8003041082913803, 0.1191118485944808}, {0.9197008145342679, 
      0.7998692432288392, 0.11983157130542865`}, {0.9199851292072219, 
      0.7994340492930617, 0.12055107991416038`}, {0.9202689010659703, 
      0.798998526967953, 0.12127037409801743`}, {0.9205521302720555, 
      0.7985626767373226, 0.12198945353473288`}, {0.9208348169873135, 
      0.7981264990848865, 0.12270831790242698`}, {0.9211169613738746, 
      0.7976899944942647, 0.12342696687961022`}, {0.9213985635941622, 
      0.7972531634489811, 0.12414540014518134`}, {0.9216796238108941, 
      0.7968160064324653, 0.12486361737842917`}, {0.921960142187081, 
      0.7963785239280508, 0.1255816182590305}, {0.9222401188860267, 
      0.7959407164189762, 0.1262994024670506}, {0.9225195540713287, 
      0.7955025843883845, 0.12701696968294426`}, {0.9227984479068763, 
      0.7950641283193228, 0.12773431958755338`}, {0.9230768005568524, 
      0.7946253486947426, 0.1284514518621097}, {0.9233546121857316, 
      0.7941862459974992, 0.12916836618823244`}, {0.9236318829582808, 
      0.7937468207103525, 0.12988506224792826`}, {0.9239086130395593, 
      0.7933070733159666, 0.13060153972359262`}, {0.9241848025949182, 
      0.7928670042969095, 0.13131779829800883`}, {0.9244604517900001, 
      0.7924266141356525, 0.13203383765434776`}, {0.9247355607907389, 
      0.7919859033145713, 0.13274965747616754`}, {0.92501012976336, 
      0.7915448723159464, 0.13346525744741378`}, {0.9252841588743799, 
      0.7911035216219592, 0.13418063725242052`}, {0.9255576482906055, 
      0.790661851714698, 0.13489579657590756`}, {0.9258305981791353, 
      0.7902198630761526, 0.13561073510298297`}, {0.9261030087073574, 
      0.7897775561882168, 0.13632545251914094`}, {0.926374880042951, 
      0.7893349315326877, 0.13703994851026333`}, {0.9266462123538844, 
      0.7888919895912664, 0.13775422276261814`}, {0.9269170058084171, 
      0.7884487308455567, 0.13846827496286054`}, {0.927187260575097, 
      0.7880051557770654, 0.13918210479803197`}, {0.9274569768227628, 
      0.7875612648672028, 0.1398957119555602}, {0.9277261547205413, 
      0.7871170585972829, 0.14060909612325867`}, {0.9279947944378497, 
      0.7866725374485214, 0.1413222569893284}, {0.9282628961443935, 
      0.7862277019020378, 0.14203519424235583`}, {0.9285304600101665, 
      0.7857825524388542, 0.14274790757131242`}, {0.9287974862054522, 
      0.7853370895398957, 0.1434603966655566}, {0.9290639749008217, 
      0.7848913136859894, 0.14417266121483222`}, {0.9293299262671347, 
      0.7844452253578666, 0.1448847009092682}, {0.9295953404755385, 
      0.7839988250361595, 0.1455965154393792}, {0.9298602176974685, 
      0.7835521132014034, 0.1463081044960651}, {0.9301245581046479, 
      0.7831050903340365, 0.1470194677706113}, {0.930388361869087, 
      0.7826577569143993, 0.14773060495468807`}, {0.9306516291630835, 
      0.7822101134227334, 0.14844151574035}, {0.9309143601592224, 
      0.7817621603391851, 0.14915219982003747`}, {0.931176555030375, 
      0.7813138981437999, 0.1498626568865753}, {0.9314382139496998, 
      0.780865327316527, 0.15057288663317267`}, {0.9316993370906416, 
      0.7804164483372187, 0.15128288875342286`}, {0.9319599246269316, 
      0.7799672616856269, 0.15199266294130465`}, {0.9322199767325866, 
      0.7795177678414074, 0.15270220889117944`}, {0.9324794935819105, 
      0.7790679672841165, 0.15341152629779425`}, {0.9327384753494918, 
      0.7786178604932127, 0.15412061485627912`}, {0.9329969222102049, 
      0.7781674479480568, 0.1548294742621482}, {0.93325483433921, 
      0.7777167301279104, 0.15553810421129988`}, {0.9335122119119516, 
      0.7772657075119369, 0.1562465044000145}, {0.9337690551041599, 
      0.7768143805792018, 0.15695467452495812`}, {0.9340253640918497, 
      0.776362749808671, 0.15766261428317854`}, {0.9342811390513204, 
      0.7759108156792129, 0.15837032337210757`}, {0.9345363801591557, 
      0.7754585786695962, 0.1590778014895597}, {0.9347910875922238, 
      0.7750060392584915, 0.1597850483337326}, {0.9350452615276765, 
      0.7745531979244697, 0.16049206360320656`}, {0.9352989021429501, 
      0.7741000551460049, 0.16119884699694545`}, {0.9355520096157639, 
      0.7736466114014695, 0.1619053982142947}, {0.935804584124121, 
      0.7731928671691389, 0.1626117169549823}, {0.9360566258463081, 
      0.7727388229271881, 0.16331780291912015`}, {0.9363081349608942, 
      0.7722844791536942, 0.16402365580719988`}, {0.9365591116467321, 
      0.7718298363266346, 0.1647292753200976}, {0.9368095560829568, 
      0.7713748949238869, 0.16543466115907018`}, {0.9370594684489858, 
      0.7709196554232294, 0.16613981302575642`}, {0.9373088489245194, 
      0.7704641183023424, 0.16684473062217697`}, {0.9375576976895397, 
      0.7700082840388051, 0.16754941365073478`}, {0.9378060149243109, 
      0.7695521531100976, 0.16825386181421356`}, {0.9380538008093791, 
      0.7690957259936008, 0.1689580748157783}, {0.9383010555255716, 
      0.7686390031665962, 0.16966205235897547`}, {0.9385477792539978, 
      0.7681819851062649, 0.17036579414773298`}, {0.9387939721760478, 
      0.7677246722896882, 0.1710692998863594}, {0.9390396344733929, 
      0.7672670651938484, 0.17177256927954487`}, {0.9392847663279854, 
      0.7668091642956265, 0.17247560203235918`}, {0.9395293679220583, 
      0.7663509700718051, 0.1731783978502532}, {0.9397734394381251, 
      0.7658924829990664, 0.1738809564390589}, {0.940016981058979, 
      0.7654337035539915, 0.17458327750498762`}, {0.9402599929676942, 
      0.7649746322130625, 0.17528536075463186`}, {0.9405024753476247, 
      0.7645152694526607, 0.17598720589496408`}, {0.9407444283824036, 
      0.7640556157490674, 0.17668881263333638`}, {0.9409858522559443, 
      0.7635956715784636, 0.17739018067748089`}, {0.9412267471524393, 
      0.7631354374169302, 0.1780913097355094}, {0.9414671132563601, 
      0.7626749137404469, 0.1787921995159137}, {0.9417069507524579, 
      0.762214101024893, 0.17949284972756532`}, {0.9419462598257622, 
      0.7617529997460479, 0.1801932600797145}, {0.9421850406615808, 
      0.7612916103795901, 0.18089343028199056`}, {0.942423293445501, 
      0.7608299334010975, 0.18159336004440355`}, {0.9426610183633877, 
      0.7603679692860474, 0.18229304907734012`}, {0.9428982156013836, 
      0.7599057185098158, 0.182992497091568}, {0.9431348853459103, 
      0.7594431815476778, 0.18369170379823263`}, {0.9433710277836663, 
      0.7589803588748084, 0.18439066890885794`}, {0.9436066431016281, 
      0.7585172509662811, 0.18508939213534695`}, {0.9438417314870494, 
      0.7580538582970685, 0.18578787318998086`}, {0.944076293127461, 
      0.7575901813420427, 0.18648611178541857`}, {0.9443103282106711, 
      0.7571262205759728, 0.1871841076346986}, {0.944543836924764, 
      0.7566619764735291, 0.18788186045123506`}, {0.9447768194581018, 
      0.7561974495092789, 0.18857936994882274`}, {0.9450092759993218, 
      0.7557326401576893, 0.18927663584163246`}, {0.9452412067373382, 
      0.7552675488931261, 0.1899736578442123}, {0.9454726118613418, 
      0.7548021761898522, 0.19067043567148964`}, {0.9457034915607982, 
      0.7543365225220313, 0.19136696903876735`}, {0.9459338460254498, 
      0.7538705883637228, 0.19206325766172708`}, {0.946163675445314, 
      0.7534043741888872, 0.1927593012564269}, {0.9463929800106832, 
      0.7529378804713823, 0.19345509953930068`}, {0.946621759912126, 
      0.7524711076849643, 0.19415065222716182`}, {0.9468500153404853, 
      0.7520040563032869, 0.19484595903719837`}, {0.9470777464868789, 
      0.7515367267999038, 0.19554101968697538`}, {0.9473049535426998, 
      0.7510691196482644, 0.19623583389443547`}, {0.9475316366996146, 
      0.750601235321719, 0.1969304013778956}, {0.9477577961495649, 
      0.7501330742935136, 0.19762472185605118`}, {0.9479834320847662, 
      0.7496646370367939, 0.19831879504797256`}, {0.9482085446977079, 
      0.7491959240246022, 0.19901262067310563`}, {0.948433134181153, 
      0.7487269357298796, 0.19970619845127358`}, {0.9486572007281385, 
      0.7482576726254652, 0.20039952810267328`}, {0.9488807445319746, 
      0.7477881351840956, 0.2010926093478791}, {0.9491037657862446, 
      0.7473183238784039, 0.2017854419078406}, {0.9493262646848047, 
      0.7468482391809235, 0.2024780255038814}, {0.9495482414217846, 
      0.7463778815640831, 0.20317035985770163`}, {0.949769696191586, 
      0.7459072515002105, 0.2038624446913756}, {0.9499906291888837, 
      0.7454363494615305, 0.20455427972735335`}, {0.9502110406086243, 
      0.7449651759201646, 0.2052458646884599}, {0.9504309306460269, 
      0.744493731348134, 0.20593719929789317`}, {0.9506502994965824, 
      0.7440220162173545, 0.20662828327922786`}, {0.9508691473560538, 
      0.7435500309996415, 0.20731911635641243`}, {0.9510874744204751, 
      0.7430777761667067, 0.20800969825376878`}, {0.9513052808861526, 
      0.7426052521901592, 0.20870002869599377`}, {0.9515225669496633, 
      0.7421324595415052, 0.2093901074081584}, {0.9517393328078553, 
      0.741659398692148, 0.21007993411570727`}, {0.9519555786578476, 
      0.7411860701133889, 0.21076950854445856`}, {0.9521713046970306, 
      0.7407124742764256, 0.21145883042060512`}, {0.9523865111230644, 
      0.7402386116523522, 0.2121478994707122}, {0.9526011981338796, 
      0.7397644827121617, 0.21283671542171845`}, {0.9528153659276778, 
      0.7392900879267403, 0.21352527800093743`}, {0.95302901470293, 
      0.7388154277668764, 0.21421358693605363`}, {0.9532421446583768, 
      0.738340502703251, 0.21490164195512587`}, {0.9534547559930292, 
      0.7378653132064433, 0.21558944278658573`}, {0.953666848906167, 
      0.7373898597469302, 0.21627698915923724`}, {0.9538784235973404, 
      0.7369141427950833, 0.21696428080225752`}, {0.9540894802663676, 
      0.7364381628211724, 0.2176513174451953}, {0.9543000191133362, 
      0.7359619202953639, 0.2183380988179724}, {0.9545100403386032, 
      0.7354854156877199, 0.2190246246508835}, {0.9547195441427934, 
      0.7350086494681995, 0.2197108946745938}, {0.9549285307268002, 
      0.7345316221066591, 0.2203969086201414}, {0.955137000291786, 
      0.7340543340728503, 0.22108266621893627`}, {0.9553449530391809, 
      0.7335767858364206, 0.22176816720276013`}, {0.9555523891706824, 
      0.7330989778669168, 0.2224534113037655}, {0.9557593088882568, 
      0.7326209106337792, 0.22313839825447765`}, {0.9559657123941372, 
      0.7321425846063457, 0.22382312778779173`}, {0.9561715998908248, 
      0.7316640002538487, 0.22450759963697609`}, {0.9563769715810873, 
      0.7311851580454196, 0.2251918135356674}, {0.9565818276679601, 
      0.7307060584500846, 0.22587576921787553`}, {0.9567861683547452, 
      0.7302267019367652, 0.22655946641798003`}, {0.9569899938450117, 
      0.7297470889742801, 0.22724290487073157`}, {0.9571933043425951, 
      0.7292672200313441, 0.2279260843112512}, {0.9573961000515971, 
      0.7287870955765667, 0.22860900447503046`}, {0.9575983811763858, 
      0.7283067160784557, 0.22929166509793056`}, {0.9578001479215955, 
      0.727826082005412, 0.2299740659161835}, {0.9580014004921263, 
      0.727345193825735, 0.2306562066663917}, {0.9582021390931439, 
      0.7268640520076174, 0.23133808708552622`}, {0.9584023639300798, 
      0.7263826570191513, 0.23201970691092885`}, {0.9586020752086307, 
      0.7259010093283205, 0.23270106588031042`}, {0.9588012731347585, 
      0.7254191094030072, 0.23338216373175144`}, {0.9589999579146905, 
      0.7249369577109889, 0.234063000203702}, {0.9591981297549185, 
      0.7244545547199377, 0.23474357503498092`}, {0.9593957888621988, 
      0.7239719008974228, 0.235423887964776}, {0.9595929354435531, 
      0.7234889967109084, 0.23610393873264507`}, {0.9597895697062667, 
      0.7230058426277537, 0.23678372707851342`}, {0.9599856918578894, 
      0.7225224391152137, 0.23746325274267582`}, {0.9601813021062351, 
      0.7220387866404399, 0.23814251546579532`}, {0.9603764006593811, 
      0.721554885670478, 0.23882151498890303`}, {0.9605709877256695, 
      0.7210707366722704, 0.2395002510533994}, {0.9607650635137046, 
      0.7205863401126531, 0.24017872340105142`}, {0.960958628232355, 
      0.7201016964583598, 0.2408569317739955}, {0.9611516820907522, 
      0.7196168061760169, 0.24153487591473544`}, {0.9613442252982909, 
      0.7191316697321479, 0.2422125555661431}, {0.9615362580646282, 
      0.718646287593172, 0.24288997047145636`}, {0.9617277805996844, 
      0.7181606602254019, 0.24356712037428258`}, {0.9619187931136423, 
      0.7176747880950467, 0.24424400501859553`}, {0.9621092958169467, 
      0.7171886716682104, 0.2449206241487362}, {0.9622992889203053, 
      0.7167023114108928, 0.24559697750941265`}, {0.962488772634687, 
      0.7162157077889868, 0.2462730648457002}, {0.9626777471713232, 
      0.7157288612682828, 0.24694888590304012`}, {0.962866212741707, 
      0.7152417723144655, 0.24762444042724174`}, {0.9630541695575926, 
      0.7147544413931134, 0.2482997281644791}, {0.9632416178309958, 
      0.7142668689697015, 0.2489747488612942}, {0.9634285577741943, 
      0.7137790555095997, 0.2496495022645945}, {0.9636149895997258, 
      0.7132910014780719, 0.250323988121654}, {0.9638009135203893, 
      0.7128027073402774, 0.2509982061801122}, {0.9639863297492449, 
      0.7123141735612706, 0.25167215618797434`}, {0.9641712384996131, 
      0.7118254006060006, 0.25234583789361253`}, {0.9643556399850741, 
      0.7113363889393115, 0.2530192510457627}, {0.9645395344194695, 
      0.7108471390259425, 0.2536923953935273}, {0.9647229220169005, 
      0.7103576513305262, 0.25436527068637443`}, {0.9649058029917278, 
      0.7098679263175913, 0.25503787667413674`}, {0.9650881775585723, 
      0.7093779644515614, 0.255710213107011}, {0.9652700459323147, 
      0.7088877661967538, 0.256382279735561}, {0.965451408328095, 
      0.7083973320173814, 0.25705407631071375`}, {0.9656322649613119, 
      0.7079066623775508, 0.2577256025837611}, {0.9658126160476241, 
      0.7074157577412651, 0.2583968583063592}, {0.9659924618029487, 
      0.7069246185724193, 0.2590678432305295}, {0.9661718024434619, 
      0.7064332453348052, 0.2597385571086566}, {0.9663506381855983, 
      0.7059416384921088, 0.2604089996934897}, {0.9665289692460511, 
      0.7054497985079098, 0.26107917073814135`}, {0.9667067958417721, 
      0.7049577258456832, 0.26174906999608943`}, {0.9668841181899706, 
      0.7044654209687976, 0.26241869722117284`}, {0.9670609365081145, 
      0.7039728843405182, 0.2630880521675965}, {0.9672372510139295, 
      0.7034801164240021, 0.26375713458992756`}, {0.9674130619253989, 
      0.7029871176823024, 0.26442594424309657`}, {0.9675883694607631, 
      0.7024938885783666, 0.26509448088239657`}, {0.9677631738385206, 
      0.702000429575036, 0.2657627442634848}, {0.9679374752774268, 
      0.7015067411350464, 0.26643073414238033`}, {0.9681112739964941, 
      0.7010128237210288, 0.26709845027546575`}, {0.9682845702149918, 
      0.7005186777955072, 0.2677658924194847}, {0.9684573641524462, 
      0.7000243038209011, 0.2684330603315453}, {0.9686296560286398, 
      0.6995297022595242, 0.2690999537691155}, {0.9688014460636121, 
      0.6990348735735841, 0.2697665724900281}, {0.9689727344776582, 
      0.6985398182251829, 0.27043291625247534`}, {0.9691435214913299, 
      0.6980445366763165, 0.2710989848150133}, {0.9693138073254346, 
      0.6975490293888762, 0.27176477793655823`}, {0.9694835922010359, 
      0.6970532968246469, 0.272430295376389}, {0.9696528763394526, 
      0.6965573394453071, 0.2730955368941456}, {0.9698216599622593, 
      0.6960611577124312, 0.27376050224982834`}, {0.9699899432912861, 
      0.6955647520874852, 0.2744251912038008}, {0.970157726548618, 
      0.6950681230318329, 0.27508960351678535`}, {0.9703250099565951, 
      0.6945712710067289, 0.27575373894986643`}, {0.9704917937378127, 
      0.6940741964733234, 0.2764175972644895}, {0.9706580781151205, 
      0.6935768998926608, 0.2770811782224596}, {0.9708238633116228, 
      0.6930793817256807, 0.27774448158594234`}, {0.9709891495506785, 
      0.6925816424332149, 0.278407507117464}, {0.971153937055901, 
      0.6920836824759896, 0.27907025457991164`}, {0.9713182260511575, 
      0.6915855023146267, 0.2797327237365309}, {0.971482016760569, 
      0.6910871024096407, 0.2803949143509285}, {0.971645309408511, 
      0.6905884832214406, 0.2810568261870707}, {0.9718081042196121, 
      0.6900896452103303, 0.281718459009282}, {0.9719704014187545, 
      0.6895905888365066, 0.28237981258224815`}, {0.9721322012310744, 
      0.6890913145600607, 0.28304088667101357`}, {0.9722935038819602, 
      0.6885918228409789, 0.2837016810409815}, {0.9724543095970545, 
      0.6880921141391398, 0.2843621954579148}, {0.9726146186022518, 
      0.6875921889143177, 0.28502242968793423`}, {0.9727744311237003, 
      0.6870920476261797, 0.2856823834975204}, {0.9729337473878005, 
      0.686591690734288, 0.2863420566535122}, {0.9730925676212049, 
      0.6860911186980991, 0.28700144892310603`}, {0.9732508920508189, 
      0.6855903319769608, 0.28766056007385826`}, {0.9734087209038003, 
      0.6850893310301186, 0.28831938987368194`}, {0.9735660544075583, 
      0.6845881163167098, 0.2889779380908487}, {0.9737228927897544, 
      0.6840866882957666, 0.28963620449398825`}, {0.9738792362783021, 
      0.6835850474262142, 0.29029418885208813`}, {0.9740350851013658, 
      0.6830831941668731, 0.290951890934493}, {0.974190439487362, 
      0.6825811289764573, 0.29160931051090455`}, {0.9743452996649583, 
      0.682078852313575, 0.29226644735138335`}, {0.9744996658630735, 
      0.6815763646367282, 0.2929233012263454}, {0.9746535383108772, 
      0.6810736664043122, 0.29357987190656515`}, {0.9748069172377902, 
      0.680570758074618, 0.29423615916317214`}, {0.9749598028734842, 
      0.68006764010583, 0.29489216276765456`}, {0.9751121954478809, 
      0.6795643129560247, 0.29554788249185643`}, {0.975264095191153, 
      0.6790607770831756, 0.2962033181079776}, {0.9754155023337232, 
      0.678557032945148, 0.296858469388575}, {0.9755664171062646, 
      0.6780530809997031, 0.2975133361065615}, {0.9757168397397001, 
      0.6775489217044943, 0.2981679180352057}, {0.9758667704652028, 
      0.6770445555170704, 0.29882221494813227`}, {0.9760162095141949, 
      0.6765399828948738, 0.29947622661932105`}, {0.9761651571183491, 
      0.6760352042952403, 0.3001299528231087}, {0.9763136135095869, 
      0.6755302201754005, 0.30078339333418647`}, {0.9764615789200795, 
      0.675025030992479, 0.3014365479276009}, {0.9766090535822467, 
      0.674519637203494, 0.30208941637875286`}, {0.976756037728758, 
      0.6740140392653587, 0.3027419984633994}, {0.9769025315925315, 
      0.673508237634879, 0.3033942939576525}, {0.9770485354067342, 
      0.673002232768756, 0.3040463026379782}, {0.9771940494047814, 
      0.6724960251235846, 0.30469802428119697`}, {0.9773390738203371, 
      0.6719896151558535, 0.30534945866448354`}, {0.977483608887314, 
      0.671483003321946, 0.30600060556536784`}, {0.9776276548398722, 
      0.6709761900781395, 0.3066514647617331}, {0.9777712119124207, 
      0.6704691758806041, 0.30730203603181677`}, {0.9779142803396157, 
      0.669961961185406, 0.30795231915420973`}, {0.9780568603563616, 
      0.6694545464485047, 0.308602313907857}, {0.9781989521978105, 
      0.6689469321257541, 0.3092520200720566}, {0.9783405560993618, 
      0.6684391186729015, 0.30990143742646026`}, {0.9784816722966623, 
      0.6679311065455896, 0.31055056575107276`}, {0.9786223010256063, 
      0.6674228961993539, 0.31119940482625247`}, {0.9787624425223352, 
      0.6669144880896255, 0.31184795443271}, {0.9789020970232368, 
      0.6664058826717283, 0.3124962143515086}, {0.9790412647649465, 
      0.6658970804008824, 0.31314418436406427`}, {0.9791799459843458, 
      0.6653880817321998, 0.3137918642521462}, {0.9793181409185632, 
      0.6648788871206881, 0.3144392537978753}, {0.9794558498049736, 
      0.6643694970212489, 0.3150863527837245}, {0.9795930728811977, 
      0.6638599118886794, 0.3157331609925183}, {0.979729810385103, 
      0.6633501321776686, 0.31637967820743446`}, {0.9798660625548028, 
      0.6628401583428017, 0.3170259042120014}, {0.9800018296286563, 
      0.6623299908385575, 0.3176718387900993}, {0.9801371118452686, 
      0.6618196301193089, 0.3183174817259598}, {0.9802719094434901, 
      0.661309076639324, 0.3189628328041659}, {0.980406222662417, 
      0.6607983308527664, 0.319607891809651}, {0.9805400517413909, 
      0.6602873932136906, 0.32025265852770085`}, {0.9806733969199986, 
      0.659776264176048, 0.32089713274395076`}, {0.980806258438072, 
      0.6592649441936846, 0.32154131424438737`}, {0.9809386365356879, 
      0.6587534337203405, 0.32218520281534774`}, {0.9810705314531681, 
      0.6582417332096497, 0.32282879824351846`}, {0.9812019434310794, 
      0.6577298431151416, 0.3234721003159376}, {0.9813328727102324, 
      0.6572177638902401, 0.32411510881999234`}, {0.981463319531683, 
      0.6567054959882624, 0.3247578235434203}, {0.981593284136731, 
      0.6561930398624233, 0.325400244274308}, {0.9817227667669208, 
      0.6556803959658275, 0.32604237080109333`}, {0.9818517676640405, 
      0.6551675647514792, 0.32668420291256156`}, {0.9819802870701222, 
      0.6546545466722741, 0.32732574039784795`}, {0.9821083252274424, 
      0.6541413421810044, 0.3279669830464383}, {0.9822358823785204, 
      0.6536279517303556, 0.3286079306481649}, {0.9823629587661201, 
      0.6531143757729093, 0.32924858299321097`}, {0.982489554633248, 
      0.6526006147611412, 0.3298889398721069}, {0.9826156702231545, 
      0.6520866691474213, 0.3305290010757331}, {0.982741305779333, 
      0.6515725393840166, 0.3311687663953167}, {0.98286646154552, 
      0.6510582259230862, 0.3318082356224341}, {0.982991137765695, 
      0.6505437292166856, 0.3324474085490097}, {0.9831153346840806, 
      0.6500290497167645, 0.333086284967316}, {0.9832390525451415, 
      0.6495141878751703, 0.3337248646699716}, {0.9833622915935857, 
      0.6489991441436411, 0.334363147449945}, {0.9834850520743632, 
      0.6484839189738122, 0.3350011331005507}, {0.9836073342326668, 
      0.6479685128172151, 0.3356388214154516}, {0.9837291383139309, 
      0.6474529261252757, 0.33627621218865567`}, {0.9838504645638328, 
      0.6469371593493127, 0.3369133052145202}, {0.9839713132282912, 
      0.6464212129405434, 0.337550100287748}, {0.9840916845534671, 
      0.6459050873500785, 0.33818659720338856`}, {0.9842115787857628, 
      0.6453887830289241, 0.3388227957568385}, {0.9843309961718227, 
      0.6448723004279823, 0.33945869574384047`}, {0.9844499369585324, 
      0.6443556399980496, 0.34009429696048266`}, {0.9845684013930195, 
      0.6438388021898186, 0.34072959920320117`}, {0.9846863897226517, 
      0.6433217874538774, 0.34136460226877463`}, {0.9848039021950392, 
      0.6428045962407076, 0.3419993059543316}, {0.9849209390580325, 
      0.6422872290006892, 0.3426337100573431}, {0.9850375005597231, 
      0.6417696861840971, 0.3432678143756265}, {0.9851535869484437, 
      0.6412519682410993, 0.34390161870734465`}, {0.9852691984727672, 
      0.6407340756217617, 0.34453512285100557`}, {0.9853843353815074, 
      0.6402160087760466, 0.34516832660546104`}, {0.9854989979237185, 
      0.6396977681538093, 0.3458012297699092}, {0.9856131863486953, 
      0.6391793542048037, 0.346433832143892}, {0.9857269009059726, 
      0.6386607673786768, 0.3470661335272963}, {0.9858401418453252, 
      0.638142008124973, 0.34769813372035246`}, {0.9859529094167683, 
      0.6376230768931329, 0.3483298325236356}, {0.9860652038705566, 
      0.637103974132492, 0.34896122973806465`}, {0.9861770254571851, 
      0.636584700292283, 0.34959232516490246`}, {0.9862883744273881, 
      0.6360652558216331, 0.35022311860575556`}, {0.9863992510321397, 
      0.6355456411695656, 0.3508536098625739}, {0.9865096555226532, 
      0.6350258567850028, 0.35148379873765034`}, {0.9866195881503816, 
      0.6345059031167593, 0.3521136850336224}, {0.9867290491670169, 
      0.6339857806135483, 0.3527432685534685}, {0.9868380388244903, 
      0.633465489723979, 0.35337254910051125`}, {0.986946557374972, 
      0.632945030896556, 0.3540015264784163}, {0.9870546050708715, 
      0.6324244045796809, 0.3546302004911909}, {0.9871621821648365, 
      0.6319036112216514, 0.3552585709431854}, {0.9872692889097539, 
      0.631382651270663, 0.35588663763909123`}, {0.9873759255587488, 
      0.6308615251748056, 0.35651440038394355`}, {0.987482092365185, 
      0.6303402333820668, 0.3571418589831183}, {0.987587789582665, 
      0.6298187763403321, 0.35776901324233296`}, {0.987693017465029, 
      0.6292971544973818, 0.3583958629676477}, {0.9877977762663557, 
      0.6287753683008926, 0.3590224079654631}, {0.9879020662409619, 
      0.6282534181984406, 0.3596486480425213}, {0.9880058876434022, 
      0.627731304637497, 0.3602745830059057}, {0.9881092407284694, 
      0.6272090280654293, 0.3609002126630405}, {0.9882121257511934, 
      0.6266865889295034, 0.36152553682169053`}, {0.9883145429668427, 
      0.6261639876768813, 0.36215055528996154`}, {0.9884164926309223, 
      0.6256412247546238, 0.3627752678762991}, {0.9885179749991758, 
      0.625118300609686, 0.36339967438948995`}, {0.988618990327583, 
      0.6245952156889234, 0.36402377463866}, {0.988719538872362, 
      0.6240719704390862, 0.3646475684332761}, {0.9888196208899671, 
      0.623548565306823, 0.36527105558314404`}, {0.9889192366370905, 
      0.6230250007386811, 0.3658942358984095}, {0.9890183863706606, 
      0.6225012771811035, 0.36651710918955754`}, {0.9891170703478434, 
      0.6219773950804309, 0.3671396752674123}, {0.989215288826041, 
      0.6214533548829025, 0.3677619339431387}, {0.9893130420628927, 
      0.6209291570346545, 0.36838388502823816`}, {0.9894103303162739, 
      0.6204048019817224, 0.36900552833455147`}, {0.9895071538442968, 
      0.619880290170037, 0.36962686367425984`}, {0.9896035129053098, 
      0.6193556220454284, 0.3702478908598812}, {0.9896994077578976, 
      0.6188307980536254, 0.3708686097042722}, {0.989794838660881, 
      0.6183058186402539, 0.37148902002062695`}, {0.9898898058733172, 
      0.6177806842508378, 0.3721091216224795}, {0.9899843096544989, 
      0.6172553953307992, 0.3727289143236996}, {0.9900783502639551, 
      0.6167299523254602, 0.37334839793849545`}, {0.9901719279614505, 
      0.616204355680038, 0.37396757228141286`}, {0.9902650430069854, 
      0.61567860583965, 0.37458643716733536`}, {0.9903576956607958, 
      0.6151527032493137, 0.3752049924114823}, {0.9904498861833532, 
      0.6146266483539427, 0.3758232378294106}, {0.9905416148353645, 
      0.6141004415983504, 0.3764411732370147}, {0.990632881877772, 
      0.6135740834272477, 0.3770587984505245}, {0.9907236875717532, 
      0.6130475742852465, 0.3776761132865067}, {0.9908140321787209, 
      0.6125209146168554, 0.37829311756186546`}, {0.9909039159603228, 
      0.6119941048664841, 0.37890981109383887`}, {0.9909933391784416, 
      0.6114671454784388, 0.37952619370000273`}, {0.991082302095195, 
      0.610940036896927, 0.3801422651982682}, {0.9911708049729354, 
      0.6104127795660542, 0.38075802540688164`}, {0.99125884807425, 
      0.6098853739298252, 0.38137347414442496`}, {0.9913464316619607, 
      0.6093578204321453, 0.3819886112298159}, {0.9914335559991238, 
      0.6088301195168174, 0.38260343648230644`}, {0.99152022134903, 
      0.6083022716275461, 0.3832179497214839}, {0.9916064279752046, 
      0.6077742772079342, 0.38383215076727073`}, {0.9916921761414071, 
      0.6072461367014841, 0.38444603943992334`}, {0.9917774661116312, 
      0.6067178505515985, 0.3850596155600326}, {0.9918622981501048, 
      0.6061894192015806, 0.3856728789485245}, {0.9919466725212895, 
      0.6056608430946325, 0.38628582942665696`}, {0.9920305894898814, 
      0.6051321226738569, 0.38689846681602474`}, {0.9921140493208102, 
      0.6046032583822559, 0.3875107909385539}, {0.9921970522792393, 
      0.6040742506627343, 0.38812280161650536`}, {0.9922795986305658, 
      0.6035450999580929, 0.3887344986724734}, {0.992361688640421, 
      0.6030158067110366, 0.3893458819293845}, {0.9924433225746688, 
      0.6024863713641703, 0.38995695121049895`}, {0.9925245006994075, 
      0.6019567943599977, 0.39056770633940985`}, {0.9926052232809681, 
      0.6014270761409257, 0.39117814714004234`}, {0.9926854905859154, 
      0.6008972171492598, 0.3917882734366555}, {0.9927653028810474, 
      0.6003672178272079, 0.39239808505383983`}, {0.9928446604333949, 
      0.5998370786168781, 0.3930075818165172}, {0.9929235635102222, 
      0.5993067999602795, 0.3936167635499429}, {0.9930020123790262, 
      0.5987763822993234, 0.39422563007970274`}, {0.9930800073075373, 
      0.5982458260758218, 0.39483418123171565`}, {0.9931575485637184, 
      0.5977151317314873, 0.39544241683223097`}, {0.9932346364157651, 
      0.5971842997079357, 0.3960503367078296}, {0.9933112711321062, 
      0.596653330446683, 0.39665794068542304`}, {0.9933874529814025, 
      0.5961222243891476, 0.3972652285922549}, {0.9934631822325478, 
      0.5955909819766498, 0.39787220025589787`}, {0.9935384591546684, 
      0.5950596036504113, 0.3984788555042573}, {0.993613284017123, 
      0.5945280898515557, 0.3990851941655676}, {0.9936876570895025, 
      0.5939964410211095, 0.399691216068393}, {0.9937615786416303, 
      0.5934646576000018, 0.4002969210416289}, {0.9938350489435618, 
      0.592932740029062, 0.4009023089144998}, {0.9939080682655848, 
      0.5924006887490243, 0.40150737951656057`}, {0.993980636878219, 
      0.591868504200524, 0.4021121326776951}, {0.9940527550522165, 
      0.5913361868241004, 0.4027165682281164}, {0.9941244230585606, 
      0.590803737060194, 0.403320685998367}, {0.9941956411684675, 
      0.5902711553491483, 0.40392448581931895`}, {0.9942664096533842, 
      0.5897384421312128, 0.4045279675221716}, {0.9943367287849902, 
      0.5892055978465359, 0.4051311309384545}, {0.9944065988351964, 
      0.588672622935172, 0.4057339759000248}, {0.9944760200761454, 
      0.5881395178370779, 0.4063365022390679}, {0.9945449927802112, 
      0.5876062829921141, 0.4069387097880976}, {0.9946135172199997, 
      0.5870729188400443, 0.40754059837995565`}, {0.9946815936683477, 
      0.5865394258205373, 0.4081421678478107}, {0.994749222398324, 
      0.5860058043731642, 0.4087434180251599}, {0.9948164036832282, 
      0.5854720549374006, 0.4093443487458278}, {0.9948831377965914, 
      0.584938177952626, 0.4099449598439652}, {0.9949494250121759, 
      0.5844041738581254, 0.4105452511540504}, {0.9950152656039751, 
      0.5838700430930863, 0.4111452225108891}, {0.9950806598462136, 
      0.5833357860966017, 0.4117448737496122}, {0.995145608013347, 
      0.5828014033076682, 0.4123442047056786}, {0.9952101103800615, 
      0.5822668951651893, 0.41294321521487226`}, {0.9952741672212748, 
      0.5817322621079711, 0.41354190511330396`}, {0.9953377788121351, 
      0.5811975045747256, 0.41414027423740973`}, {0.9954009454280218, 
      0.5806626230040689, 0.4147383224239528}, {0.9954636673445445, 
      0.5801276178345252, 0.4153360495100193}, {0.9955259448375438, 
      0.5795924895045205, 0.4159334553330232}, {0.995587778183091, 
      0.5790572384523888, 0.4165305397307026}, {0.9956491676574878, 
      0.578521865116368, 0.41712730254112007`}, {0.9957101135372667, 
      0.5779863699346025, 0.4177237436026642}, {0.9957706160991905, 
      0.577450753345144, 0.41831986275404665`}, {0.9958306756202526, 
      0.5769150157859473, 0.41891565983430545`}, {0.9958902923776767, 
      0.5763791576948758, 0.4195111346828007}, {0.9959494666489167, 
      0.5758431795096992, 0.42010628713921766`}, {0.9960081987116571, 
      0.5753070816680914, 0.4207011170435659}, {0.9960664888438127, 
      0.574770864607635, 0.42129562423617795`}, {0.9961243373235279, 
      0.5742345287658184, 0.4218898085577096}, {0.9961817444291781, 
      0.5736980745800371, 0.42248366984914093`}, {0.9962387104393681, 
      0.5731615024875946, 0.42307720795177356`}, {0.9962952356329332, 
      0.5726248129256991, 0.4236704227072343}, {0.9963513202889385, 
      0.5720880063314687, 0.4242633139574701}, {0.9964069646866793, 
      0.5715510831419274, 0.42485588154475207`}, {0.9964621691056806, 
      0.5710140437940076, 0.4254481253116736}, {0.9965169338256977, 
      0.5704768887245483, 0.4260400451011499}, {0.9965712591267153, 
      0.5699396183702972, 0.42663164075641824`}, {0.996625145288948, 
      0.5694022331679113, 0.42722291212103664`}, {0.9966785925928403, 
      0.5688647335539534, 0.4278138590388871}, {0.9967316013190667, 
      0.5683271199648963, 0.42840448135417075`}, {0.9967841717485307, 
      0.5677893928371203, 0.4289947789114105}, {0.9968363041623662, 
      0.5672515526069154, 0.4295847515554513}, {0.9968879988419364, 
      0.5667135997104789, 0.4301743991314576}, {0.996939256068834, 
      0.5661755345839182, 0.43076372148491543`}, {0.9969900761248814, 
      0.5656373576632511, 0.4313527184616309}, {0.9970404592921306, 
      0.5650990693844008, 0.43194138990772996`}, {0.9970904058528628, 
      0.5645606701832039, 0.43252973566965897`}, {0.997139916089589, 
      0.5640221604954042, 0.4331177555941845}, {0.9971889902850493, 
      0.563483540756657, 0.43370544952839246`}, {0.9972376287222133, 
      0.562944811402526, 0.4342928173196876}, {0.9972858316842804, 
      0.5624059728684847, 0.4348798588157958}, {0.9973335994546786, 
      0.561867025589919, 0.4354665738647596}, {0.9973809323170656, 
      0.5613279700021235, 0.4360529623149422}, {0.9974278305553282, 
      0.5607888065403034, 0.43663902401502486`}, {0.9974742944535829, 
      0.560249535639576, 0.43722475881400713`}, {0.9975203242961748, 
      0.559710157734967, 0.43781016656120764`}, {0.9975659203676785, 
      0.5591706732614165, 0.43839524710626226`}, {0.9976110829528979, 
      0.5586310826537728, 0.4389800002991255}, {0.9976558123368657, 
      0.5580913863467976, 0.4395644259900681}, {0.9977001088048439, 
      0.5575515847751634, 0.4401485240296805}, {0.9977439726423237, 
      0.5570116783734546, 0.4407322942688691}, {0.9977874041350252, 
      0.5564716675761681, 0.44131573655885736`}, {0.9978304035688976, 
      0.5559315528177111, 0.44189885075118696`}, {0.9978729712301192, 
      0.5553913345324053, 0.4424816366977141}, {0.9979151074050971, 
      0.5548510131544836, 0.4430640942506141}, {0.9979568123804677, 
      0.5543105891180917, 0.44364622326237585`}, {0.9979980864430962, 
      0.5537700628572897, 0.44422802358580615`}, {0.9980389298800766, 
      0.5532294348060478, 0.44480949507402867`}, {0.9980793429787321, 
      0.5526887053982528, 0.4453906375804796}, {0.9981193260266147, 
      0.5521478750677017, 0.4459714509589133}, {0.9981588793115054, 
      0.5516069442481064, 0.44655193506339896`}, {0.9981980031214138, 
      0.5510659133730939, 0.44713208974832025`}, {0.9982366977445789, 
      0.5505247828762025, 0.44771191486837614`}, {0.998274963469468, 
      0.5499835531908872, 0.4482914102785806}, {0.9983128005847776, 
      0.5494422247505157, 0.44887057583426165`}, {0.9983502093794329, 
      0.5489007979883715, 0.4494494113910617}, {0.998387190142588, 
      0.5483592733376503, 0.4500279168049374}, {0.9984237431636258, 
      0.5478176512314664, 0.45060609193215917`}, {0.998459868732158, 
      0.5472759321028463, 0.45118393662931167`}, {0.998495567138025, 
      0.5467341163847333, 0.45176145075329205`}, {0.9985308386712962, 
      0.5461922045099845, 0.45233863416131204`}, {0.9985656836222698, 
      0.5456501969113752, 0.45291548671089515`}, {0.9986001022814724, 
      0.5451080940215943, 0.4534920082598779}, {0.9986340949396599, 
      0.5445658962732486, 0.45406819866641146`}, {0.9986676618878167, 
      0.5440236040988597, 0.4546440577889568}, {0.998700803417156, 
      0.5434812179308679, 0.45521958548628855`}, {0.9987335198191195, 
      0.5429387382016266, 0.45579478161749304`}, {0.9987658113853782, 
      0.5423961653434094, 0.45636964604196933`}, {0.9987976784078317, 
      0.541853499788405, 0.4569441786194264}, {0.9988291211786081, 
      0.5413107419687211, 0.4575183792098868}, {0.9988601399900645, 
      0.5407678923163827, 0.4580922476736819}, {0.9988907351347868, 
      0.5402249512633306, 0.45866578387145596`}, {0.9989209069055894, 
      0.5396819192414258, 0.4592389876641636}, {0.998950655595516, 
      0.5391387966824461, 0.4598118589130698}, {0.9989799814978385, 
      0.5385955840180893, 0.4603843974797498}, {0.999008884906058, 
      0.5380522816799688, 0.4609566032260891}, {0.9990373661139041, 
      0.5375088900996208, 0.4615284760142837}, {0.9990654254153356, 
      0.536965409708496, 0.46210001570683934`}, {0.9990930631045397, 
      0.5364218409379705, 0.4626712221665697}, {0.9991202794759327, 
      0.535878184219333, 0.46324209525660004`}, {0.9991470748241597, 
      0.5353344399837959, 0.463812634840364}, {0.9991734494440944, 
      0.5347906086624926, 0.46438284078160225`}, {0.9991994036308396, 
      0.5342466906864723, 0.4649527129443673}, {0.999224937679727, 
      0.5337026864867087, 0.46552225119301854`}, {0.999250051886317, 
      0.5331585964940941, 0.4660914553922232}, {0.999274746546399, 
      0.5326144211394424, 0.4666603254069571}, {0.9992990219559914, 
      0.5320701608534881, 0.4672288611025035}, {0.9993228784113414, 
      0.5315258160668872, 0.4677970623444547}, {0.999346316208925, 
      0.5309813872102164, 0.46836492899870863`}, {0.9993693356454477, 
      0.5304368747139758, 0.4689324609314717}, {0.9993919370178435, 
      0.5298922790085868, 0.46949965800925664`}, {0.9994141206232753, 
      0.5293476005243928, 0.47006652009888256`}, {0.9994358867591356, 
      0.528802839691659, 0.4706330470674764}, {0.9994572357230456, 
      0.5282579969405762, 0.47119923878246933`}, {0.9994781678128555, 
      0.5277130727012539, 0.47176509511160164`}, {0.9994986833266448, 
      0.5271680674037282, 0.4723306159229168}, {0.999518782562722, 
      0.5266229814779566, 0.47289580108476503`}, {0.9995384658196247, 
      0.5260778153538225, 0.4734606504658026}, {0.9995577333961199, 
      0.5255325694611296, 0.47402516393499017`}, {0.9995765855912035, 
      0.5249872442296105, 0.474589341361593}, {0.999595022704101, 
      0.5244418400889191, 0.47515318261518225`}, {0.9996130450342668, 
      0.5238963574686347, 0.4757166875656327}, {0.999630652881385, 
      0.5233507967982601, 0.4762798560831248}, {0.9996478465453686, 
      0.5228051585072269, 0.47684268803814195`}, {0.9996646263263602, 
      0.5222594430248895, 0.47740518330147125`}, {0.9996809925247317, 
      0.521713650780527, 0.4779673417442048}, {0.9996969454410848, 
      0.521167782203348, 0.47852916323773687`}, {0.9997124853762499, 
      0.5206218377224844, 0.4790906476537657}, {0.9997276126312876, 
      0.5200758177669952, 0.4796517948642922}, {0.9997423275074878, 
      0.519529722765868, 0.4802126047416202}, {0.9997566303063701, 
      0.5189835531480143, 0.48077307715835627`}, {0.9997705213296834, 
      0.5184373093422739, 0.481333211987409}, {0.9997840008794066, 
      0.517890991777418, 0.4818930091019886}, {0.999797069257748, 
      0.5173446008821387, 0.48245246837560957`}, {0.9998097267671462, 
      0.5167981370850622, 0.48301158968208413`}, {0.9998219737102688, 
      0.5162516008147392, 0.4835703728955295}, {0.9998338103900141, 
      0.5157049924996516, 0.48412881789036255`}, {0.9998452371095095, 
      0.515158312568209, 0.4846869245413008}, {0.9998562541721128, 
      0.5146115614487492, 0.48524469272336335`}, {0.9998668618814117, 
      0.5140647395695426, 0.4858021223118697}, {0.9998770605412239, 
      0.5135178473587854, 0.48635921318243885`}, {0.9998868504555972, 
      0.5129708852446073, 0.48691596521099006`}, {0.9998962319288096, 
      0.5124238536550663, 0.4874723782737436}, {0.999905205265369, 
      0.5118767530181503, 0.48802845224721897`}, {0.9999137707700139, 
      0.5113295837617807, 0.48858418700823336`}, {0.9999219287477129, 
      0.5107823463138087, 0.4891395824339045}, {0.9999296795036651, 
      0.510235041102016, 0.48969463840164956`}, {0.9999370233432997, 
      0.5096876685541168, 0.4902493547891828}, {0.9999439605722767, 
      0.5091402290977586, 0.4908037314745183}, {0.9999504914964866, 
      0.5085927231605187, 0.49135776833596806`}, {0.9999566164220504, 
      0.5080451511699094, 0.4919114652521408}, {0.9999623356553196, 
      0.5074975135533749, 0.4924648221019446}, {0.9999676495028766, 
      0.5069498107382925, 0.4930178387645846}, {0.9999725582715346, 
      0.5064020431519726, 0.4935705151195622}, {0.9999770622683377, 
      0.5058542112216606, 0.4941228510466772}, {0.9999811618005606, 
      0.5053063153745347, 0.4946748464260259}, {0.9999848571757093, 
      0.5047583560377096, 0.495226501138}, {0.9999881487015205, 
      0.5042103336382322, 0.49577781506328855`}, {0.9999910366859626, 
      0.5036622486030862, 0.49632878808287634`}, {0.9999935214372345, 
      0.5031141013591894, 0.496879420078045}, {0.9999956032637669, 
      0.5025658923333972, 0.49742971093037003`}, {0.9999972824742215, 
      0.5020176219524988, 0.49797966052172327`}, {0.9999985593774915, 
      0.5014692906432198, 0.49852926873427167`}, {0.9999994342827015, 
      0.5009208988322253, 0.49907853545047653`}, {0.9999999074992081, 
      0.5003724469461136, 0.49962746055309426`}, {0.9999999793365989, 
      0.49982393541142356`, 0.5001760439251758}, {0.9999996501046935, 
      0.4992753646546278, 0.5007242854500655}, {0.9999989201135435, 
      0.4987267351021409, 0.5012721850114027}, {0.999997789673432, 
      0.4981780471803135, 0.501819742493119}, {0.9999962590948743, 
      0.49762930131543426`, 0.5023669577794405}, {0.9999943286886177, 
      0.49708049793373155`, 0.5029138307548864}, {0.9999919987656416, 
      0.4965316374613739, 0.503460361304268}, {0.9999892696371576, 
      0.49598272032446694`, 0.5040065493126906}, {0.9999861416146096, 
      0.49543374694906017`, 0.5045523946655501}, {0.9999826150096741, 
      0.49488471776113807`, 0.5050978972485364}, {0.9999786901342597, 
      0.49433563318662993`, 0.5056430569476297}, {0.9999743673005078, 
      0.49378649365140415`, 0.5061878736491039}, {0.9999696468207925, 
      0.49323729958126966`, 0.5067323472395227}, {0.9999645290077206, 
      0.4926880514019796, 0.5072764776057409}, {0.9999590141741317, 
      0.4921387495392273, 0.5078202646349046}, {0.9999531026330984, 
      0.4915893944186462, 0.5083637082144522}, {0.9999467946979265, 
      0.49103998646581715`, 0.5089068082321098}, {0.9999400906821546, 
      0.4904905261062601, 0.5094495645758946}, {0.9999329908995549, 
      0.4899410137654399, 0.5099919771341153}, {0.9999254956641327, 
      0.4893914498687646, 0.5105340457953687}, {0.9999176052901269, 
      0.48884183484158583`, 0.511075770448541}, {0.9999093200920098, 
      0.4882921691092018, 0.5116171509828079}, {0.9999006403844876, 
      0.48774245309685366`, 0.5121581872876338}, {0.9998915664825001, 
      0.48719268722972703`, 0.5126988792527732}, {0.9998820987012209, 
      0.486642871932955, 0.5132392267682662}, {0.9998722373560578, 
      0.48609300763161434`, 0.5137792297244437}, {0.9998619827626526, 
      0.4855430947507301, 0.5143188880119227}, {0.9998513352368813, 
      0.4849931337152715, 0.5148582015216095}, {0.9998402950948541, 
      0.48444312495015873`, 0.5153971701446958}, {0.9998288626529158, 
      0.48389306888025474`, 0.5159357937726613}, {0.9998170382276458, 
      0.4833429659303721, 0.5164740722972735}, {0.999804822135858, 
      0.48279281652527267`, 0.5170120056105852}, {0.9997922146946011, 
      0.4822426210896658, 0.5175495936049357}, {0.9997792162211588, 
      0.48169238004820863`, 0.5180868361729505}, {0.99976582703305, 
      0.48114209382550893`, 0.5186237332075415}, {0.9997520474480283, 
      0.4805917628461228, 0.5191602846019058}, {0.9997378777840829, 
      0.4800413875345582, 0.5196964902495248}, {0.9997233183594383, 
      0.4794909683152725, 0.5202323500441661}, {0.9997083694925547, 
      0.47894050561267315`, 0.5207678638798818}, {0.9996930315021276, 
      0.4783899998511198, 0.5213030316510081}, {0.9996773047070887, 
      0.47783945145492257`, 0.5218378532521663}, {0.9996611894266053, 
      0.47728886084834604`, 0.5223723285782598}, {0.9996446859800809, 
      0.4767382284556032, 0.5229064575244781}, {0.9996277946871552, 
      0.47618755470086327`, 0.5234402399862919}, {0.9996105158677042, 
      0.47563684000824785`, 0.5239736758594562}, {0.9995928498418403, 
      0.4750860848018316, 0.5245067650400093}, {0.9995747969299126, 
      0.47453528950564233`, 0.5250395074242706}, {0.9995563574525067, 
      0.47398445454366384`, 0.5255719029088434}, {0.9995375317304453, 
      0.4734335803398333, 0.5261039513906121}, {0.9995183200847884, 
      0.4728826673180453, 0.526635652766743}, {0.9994987228368324, 
      0.47233171590214795`, 0.5271670069346843}, {0.9994787403081116, 
      0.47178072651594705`, 0.527698013792165}, {0.9994583728203977, 
      0.47122969958320204`, 0.5282286732371956}, {0.9994376206956999, 
      0.4706786355276341, 0.5287589851680661}, {0.9994164842562652, 
      0.4701275347729165, 0.5292889494833487}, {0.9993949638245783, 
      0.4695763977426847, 0.5298185660818938}, {0.9993730597233623, 
      0.4690252248605284, 0.5303478348628338}, {0.9993507722755783, 
      0.4684740165500005, 0.5308767557255781}, {0.9993281018044261, 
      0.46792277323460824`, 0.5314053285698183}, {0.9993050486333434, 
      0.46737149533782096`, 0.5319335532955225}, {0.9992816130860072, 
      0.4668201832830687, 0.5324614298029386}, {0.999257795486333, 
      0.46626883749373965`, 0.5329889579925933}, {0.9992335961584755, 
      0.4657174583931844, 0.5335161377652912}, {0.9992090154268286, 
      0.4651660464047153, 0.5340429690221139}, {0.9991840536160254, 
      0.4646146019516032, 0.5345694516644222}, {0.9991587110509386, 
      0.46406312545708517`, 0.5350955855938532}, {0.9991329880566804, 
      0.46351161734435997`, 0.535621370712321}, {0.9991068849586031, 
      0.46296007803658673`, 0.5361468069220168}, {0.9990804020822992, 
      0.4624085079568911, 0.5366718941254085}, {0.9990535397536008, 
      0.4618569075283611, 0.5371966322252396}, {0.9990262982985808, 
      0.4613052771740506, 0.5377210211245299}, {0.9989986780435527, 
      0.4607536173169787, 0.5382450607265741}, {0.9989706793150704, 
      0.4602019283801276, 0.5387687509349433}, {0.9989423024399291, 
      0.4596502107864459, 0.5392920916534835}, {0.9989135477451648, 
      0.45909846495885065`, 0.5398150827863142}, {0.998884415558055, 
      0.4585466913202246, 0.5403377242378304}, {0.9988549062061183, 
      0.45799489029341695`, 0.5408600159127015}, {0.9988250200171154, 
      0.4574430623012462, 0.5413819577158694}, {0.9987947573190485, 
      0.45689120776649716`, 0.5419035495525516}, {0.9987641184401621, 
      0.45633932711192554`, 0.5424247913282367}, {0.9987331037089426, 
      0.4557874207602551, 0.5429456829486876}, {0.9987017134541192, 
      0.45523548913418016`, 0.5434662243199395}, {0.9986699480046632, 
      0.4546835326563627, 0.5439864153483005}, {0.9986378076897893, 
      0.4541315517494396, 0.5445062559403497}, {0.9986052928389547, 
      0.4535795468360151, 0.5450257460029394}, {0.9985724037818602, 
      0.45302751833866844`, 0.5455448854431916}, {0.9985391408484496, 
      0.4524754666799491, 0.5460636741685008}, {0.9985055043689108, 
      0.45192339228237877`, 0.5465821120865318}, {0.9984714946736751, 
      0.45137129556845385`, 0.547100199105221}, {0.998437112093418, 
      0.450819176960645, 0.5476179351327735}, {0.9984023569590593, 
      0.45026703688139463`, 0.5481353200776652}, {0.998367229601763, 
      0.44971487575312097`, 0.5486523538486422}, {0.9983317303529381, 
      0.4491626939982199, 0.5491690363547185}, {0.9982958595442383, 
      0.44861049203905984`, 0.5496853675051785}, {0.9982596175075623, 
      0.4480582702979876, 0.5502013472095748}, {0.9982230045750542, 
      0.44750602919732624`, 0.5507169753777279}, {0.9981860210791038, 
      0.4469537691593762, 0.551232251919728}, {0.9981486673523463, 
      0.44640149060641476`, 0.5517471767459315}, {0.9981109437276632, 
      0.4458491939607, 0.552261749766963}, {0.998072850538182, 
      0.4452968796444674, 0.5527759708937142}, {0.9980343881172766, 
      0.4447445480799329, 0.5532898400373435}, {0.997995556798568, 
      0.4441921996892918, 0.5538033571092765}, {0.9979563569159235, 
      0.4436398348947192, 0.554316522021204}, {0.9979167888034578, 
      0.4430874541183744, 0.5548293346850838}, {0.9978768527955332, 
      0.44253505778239494`, 0.555341795013138}, {0.9978365492267589, 
      0.44198264630890366`, 0.5558539029178555}, {0.9977958784319928, 
      0.4414302201200039, 0.5563656583119891}, {0.9977548407463402, 
      0.4408777796377827, 0.5568770611085574}, {0.9977134365051551, 
      0.44032532528431356`, 0.5573881112208415}, {0.99767166604404, 
      0.4397728574816517, 0.5578988085623883}, {0.9976295296988461, 
      0.43922037665183855`, 0.5584091530470073}, {0.9975870278056737, 
      0.4386678832169017, 0.5589191445887723}, {0.9975441607008726, 
      0.43811537759885344`, 0.5594287831020188}, {0.9975009287210418, 
      0.43756286021969554`, 0.5599380685013464}, {0.9974573322030305, 
      0.4370103315014141, 0.5604470007016166}, {0.9974133714839376, 
      0.43645779186598554`, 0.5609555796179524}, {0.9973690469011129, 
      0.4359052417353744, 0.5614638051657389}, {0.9973243587921562, 
      0.43535268153153334`, 0.5619716772606228}, {0.9972793074949186, 
      0.43480011167640603`, 0.5624791958185124}, {0.9972338933475019, 
      0.43424753259192655`, 0.5629863607555754}, {0.9971881166882598, 
      0.4336949447000191, 0.5634931719882408}, {0.9971419778557972, 
      0.4331423484225993, 0.5639996294331977}, {0.9970954771889713, 
      0.43258974418157664`, 0.5645057330073945}, {0.9970486150268911, 
      0.43203713239885255`, 0.5650114826280392}, {0.9970013917089187, 
      0.4314845134963191, 0.5655168782125995}, {0.9969538075746683, 
      0.4309318878958678, 0.5660219196788007}, {0.9969058629640075, 
      0.43037925601938115`, 0.5665266069446269}, {0.9968575582170573, 
      0.42982661828873625`, 0.5670309399283209}, {0.996808893674192, 
      0.42927397512580934`, 0.5675349185483826}, {0.9967598696760401, 
      0.4287213269524717, 0.5680385427235689}, {0.996710486563484, 
      0.4281686741905898, 0.5685418123728947}, {0.9966607446776609, 
      0.4276160172620301, 0.5690447274156313}, {0.9966106443599624, 
      0.42706335658865713`, 0.5695472877713056}, {0.9965601859520354, 
      0.42651069259233476`, 0.5700494933597007}, {0.9965093697957822, 
      0.4259580256949249, 0.5705513441008571}, {0.9964581962333605, 
      0.4254053563182934, 0.5710528399150674}, {0.9964066656071843, 
      0.42485268488430233`, 0.5715539807228823}, {0.9963547782599235, 
      0.42430001181481863`, 0.5720547664451051}, {0.9963025345345048, 
      0.4237473375317111, 0.5725551970027938}, {0.9962499347741117, 
      0.4231946624568508, 0.573055272317261}, {0.9961969793221852, 
      0.4226419870121138, 0.5735549923100713}, {0.9961436685224231, 
      0.4220893116193791, 0.5740543569030444}, {0.9960900027187817, 
      0.42153663670053076`, 0.5745533660182514}, {0.996035982255475, 
      0.4209839626774589, 0.5750520195780165}, {0.9959816074769756, 
      0.4204312899720602, 0.5755503175049157}, {0.9959268787280151, 
      0.4198786190062382, 0.576048259721777}, {0.9958717963535838, 
      0.419325950201904, 0.5765458461516796}, {0.9958163606989318, 
      0.4187732839809784, 0.5770430767179535}, {0.9957605721095686, 
      0.4182206207653885, 0.5775399513441802}, {0.9957044309312639, 
      0.4176679609770732, 0.5780364699541907}, {0.9956479375100481, 
      0.4171153050379823, 0.5785326324720661}, {0.995591092192212, 
      0.41656265337007486`, 0.5790284388221373}, {0.9955338953243076, 
      0.41601000639532404`, 0.5795238889289839}, {0.9954763472531485, 
      0.4154573645357135, 0.5800189827174349}, {0.99541844832581, 
      0.4149047282132431, 0.5805137201125672}, {0.9953601988896292, 
      0.41435209784992266`, 0.5810081010397065}, {0.9953015992922063, 
      0.4137994738677805, 0.5815021254244254}, {0.9952426498814038, 
      0.41324685668885924`, 0.5819957931925445}, {0.9951833510053476, 
      0.41269424673521693`, 0.5824891042701305}, {0.995123703012427, 
      0.4121416444289294, 0.5829820585834979}, {0.9950637062512956, 
      0.4115890501920893, 0.5834746560592063}, {0.9950033610708707, 
      0.4110364644468093, 0.5839668966240614}, {0.9949426678203347, 
      0.4104838876152201, 0.5844587802051147}, {0.9948816268491345, 
      0.40993132011947164`, 0.584950306729663}, {0.9948202385069829, 
      0.4093787623817366, 0.5854414761252462}, {0.994758503143858, 
      0.40882621482420783`, 0.5859322883196506}, {0.9946964211100041, 
      0.40827367786909946`, 0.5864227432409049}, {0.9946339927559323, 
      0.40772115193865155`, 0.5869128408172813}, {0.9945712184324201, 
      0.4071686374551234, 0.5874025809772966}, {0.9945080984905126, 
      0.40661613484080417`, 0.5878919636497082}, {0.9944446332815221, 
      0.4060636445180047, 0.5883809887635177}, {0.9943808231570295, 
      0.40551116690906247`, 0.5888696562479677}, {0.9943166684688834, 
      0.4049587024363406, 0.589357966032543}, {0.994252169569202, 
      0.4044062515222339, 0.5898459180469678}, {0.994187326810372, 
      0.4038538145891623, 0.5903335122212097}, {0.9941221405450501, 
      0.40330139205957577`, 0.5908207484854745}, {0.9940566111261627, 
      0.40274898435595347`, 0.5913076267702092}, {0.9939907389069068, 
      0.4021965919008076, 0.5917941470060991}, {0.9939245242407503, 
      0.40164421511667964`, 0.5922803091240705}, {0.993857967481432, 
      0.40109185442614514`, 0.5927661130552865}, {0.9937910689829624, 
      0.4005395102518126, 0.5932515587311501}, {0.9937238290996243, 
      0.39998718301632336`, 0.5937366460833008}, {0.9936562481859728, 
      0.39943487314235615`, 0.5942213750436168}, {0.9935883265968355, 
      0.39888258105262203`, 0.5947057455442132}, {0.993520064687314, 
      0.3983303071698735, 0.595189757517441}, {0.9934514628127831, 
      0.39777805191689464`, 0.5956734108958883}, {0.9933825213288919, 
      0.3972258157165133, 0.5961567056123789}, {0.9933132405915642, 
      0.3966735989915933, 0.5966396415999714}, {0.9932436209569987, 
      0.39612140216503827`, 0.5971222187919604}, {0.9931736627816695, 
      0.395569225659795, 0.5976044371218752}, {0.9931033664223269, 
      0.3950170698988492, 0.5980862965234778}, {0.9930327322359971, 
      0.39446493530523163`, 0.5985677969307651}, {0.9929617605799834, 
      0.39391282230201563`, 0.5990489382779678}, {0.9928904518118662, 
      0.39336073131231764`, 0.5995297204995487}, {0.9928188062895038, 
      0.39280866275930093`, 0.6000101435302027}, {0.9927468243710323, 
      0.3922566170661749, 0.6004902073048578}, {0.9926745064148669, 
      0.391704594656194, 0.600969911758673}, {0.9926018527797014, 
      0.39115259595266283`, 0.6014492568270388}, {0.9925288638245092, 
      0.39060062137893364`, 0.6019282424455761}, {0.9924555399085441, 
      0.3900486713584079, 0.6024068685501361}, {0.9923818813913399, 
      0.3894967463145393, 0.6028851350768005}, {0.9923078886327116, 
      0.38894484667083157`, 0.6033630419618802}, {0.9922335619927556, 
      0.38839297285084107`, 0.6038405891419144}, {0.9921589018318501, 
      0.3878411252781788, 0.6043177765536717}, {0.992083908510656, 
      0.38728930437650755`, 0.604794604134149}, {0.9920085823901166, 
      0.3867375105695477, 0.6052710718205688}, {0.9919329238314589, 
      0.3861857442810747, 0.6057471795503843}, {0.9918569331961938, 
      0.38563400593492086`, 0.6062229272612727}, {0.9917806108461165, 
      0.38508229595497834`, 0.6066983148911381}, {0.9917039571433068, 
      0.38453061476519534`, 0.6071733423781112}, {0.9916269724501302, 
      0.3839789627895824, 0.6076480096605481}, {0.991549657129238, 
      0.38342734045221044`, 0.6081223166770281}, {0.9914720115435678, 
      0.3828757481772104, 0.6085962633663574}, {0.9913940360563441, 
      0.38232418638877874`, 0.6090698496675652}, {0.991315731031079, 
      0.38177265551117573`, 0.6095430755199038}, {0.9912370968315721, 
      0.3812211559687234, 0.6100159408628488}, {0.9911581338219121, 
      0.3806696881858128, 0.6104884456360994}, {0.991078842366476, 
      0.3801182525869003, 0.6109605897795759}, {0.9909992228299309, 
      0.3795668495965104, 0.6114323732334207}, {0.9909192755772336, 
      0.37901547963923604`, 0.6119037959379974}, {0.9908390009736315, 
      0.37846414313974125`, 0.6123748578338901}, {0.9907583993846634, 
      0.3779128405227599, 0.6128455588619038}, {0.9906774711761593, 
      0.37736157221309613`, 0.6133158989630632}, {0.990596216714242, 
      0.3768103386356305, 0.6137858780786113}, {0.9905146363653267, 
      0.376259140215316, 0.6142554961500112}, {0.9904327304961218, 
      0.3757079773771781, 0.6147247531189438}, {0.9903504994736301, 
      0.37515685054632125`, 0.6151936489273085}, {0.9902679436651484, 
      0.3746057601479284, 0.6156621835172206}, {0.9901850634382686, 
      0.3740547066072547, 0.616130356831014}, {0.9901018591608783, 
      0.37350369034964065`, 0.6165981688112383}, {0.9900183312011615, 
      0.3729527118005031, 0.6170656194006586}, {0.9899344799275982, 
      0.37240177138534236`, 0.6175327085422562}, {0.9898503057089665, 
      0.37185086952973945`, 0.6179994361792266}, {0.989765808914342, 
      0.3713000066593612, 0.6184658022549805}, {0.9896809899130987, 
      0.37074918319995687`, 0.6189318067131417}, {0.98959584907491, 
      0.37019839957736206`, 0.6193974494975483}, {0.9895103867697489, 
      0.3696476562174987, 0.6198627305522506}, {0.9894246033678886, 
      0.3690969535463771, 0.6203276498215116}, {0.9893384992399031, 
      0.36854629199009736`, 0.6207922072498064}, {0.9892520747566682, 
      0.3679956719748478, 0.6212564027818209}, {0.9891653302893614, 
      0.36744509392690927`, 0.6217202363624524}, {0.9890782662094632, 
      0.3668945582726544, 0.6221837079368087}, {0.9889908828887574, 
      0.36634406543855075`, 0.6226468174502069}, {0.9889031806993318, 
      0.3657936158511586, 0.6231095648481734}, {0.9888151600135786, 
      0.36524320993713427`, 0.6235719500764442}, {0.9887268212041954, 
      0.3646928481232329, 0.6240339730809628}, {0.9886381646441857, 
      0.3641425308363055, 0.6244956338078805}, {0.9885491907068594, 
      0.36359225850330296`, 0.6249569322035566}, {0.9884598997658334, 
      0.36304203155127723`, 0.6254178682145564}, {0.9883702921950329, 
      0.36249185040738297`, 0.6258784417876504}, {0.9882803683686908, 
      0.361941715498874, 0.626338652869817}, {0.9881901286613498, 
      0.3613916272531115, 0.626798501408238}, {0.9880995734478618, 
      0.36084158609756145`, 0.6272579873503005}, {0.9880087031033898, 
      0.3602915924597959, 0.6277171106435944}, {0.9879175180034071, 
      0.3597416467674928, 0.6281758712359146}, {0.9878260185236994, 
      0.3591917494484411, 0.6286342690752582}, {0.9877342050403644, 
      0.3586419009305395, 0.6290923041098251}, {0.9876420779298134, 
      0.35809210164179844`, 0.6295499762880155}, {0.9875496375687709, 
      0.3575423520103384, 0.6300072855584327}, {0.9874568843342767, 
      0.3569926524643972, 0.6304642318698793}, {0.9873638186036849, 
      0.35644300343232543`, 0.6309208151713595}, {0.9872704407546664, 
      0.3558934053425914, 0.631377035412075}, {0.987176751165208, 
      0.3553438586237796, 0.6318328925414286}, {0.9870827502136141, 
      0.35479436370459416`, 0.6322883865090203}, {0.9869884382785072, 
      0.3542449210138591, 0.6327435172646483}, {0.9868938157388284, 
      0.3536955309805209, 0.6331982847583078}, {0.9867988829738383, 
      0.35314619403364755`, 0.6336526889401912}, {0.9867036403631178, 
      0.35259691060243126`, 0.6341067297606866}, {0.9866080882865684, 
      0.35204768111619084`, 0.6345604071703779}, {0.9865122271244139, 
      0.35149850600437044`, 0.6350137211200436}, {0.9864160572571997, 
      0.350949385696543, 0.6354666715606573}, {0.986319579065795, 
      0.35040032062240917`, 0.6359192584433859}, {0.9862227929313926, 
      0.34985131121180413`, 0.636371481719589}, {0.98612569923551, 
      0.34930235789469, 0.6368233413408199}, {0.98602829835999, 
      0.3487534611011673, 0.6372748372588232}, {0.9859305906870018, 
      0.348204621261467, 0.6377259694255346}, {0.9858325765990413, 
      0.34765583880595935`, 0.6381767377930823}, {0.9857342564789324, 
      0.34710711416515044`, 0.6386271423137818}, {0.9856356307098273, 
      0.3465584477696862, 0.6390771829401412}, {0.9855366996752075, 
      0.3460098400503519, 0.6395268596248558}, {0.9854374637588845, 
      0.3454612914380747, 0.6399761723208097}, {0.9853379233450009, 
      0.344912802363926, 0.6404251209810748}, {0.9852380788180308, 
      0.3443643732591209, 0.6408737055589101}, {0.9851379305627809, 
      0.34381600455501954`, 0.6413219260077612}, {0.9850374789643909, 
      0.34326769668313156`, 0.6417697822812594}, {0.9849367244083348, 
      0.34271945007511395`, 0.642217274333221}, {0.9848356672804215, 
      0.3421712651627739, 0.6426644021176479}, {0.9847343079667957, 
      0.34162314237807073`, 0.6431111655887248}, {0.9846326468539385, 
      0.34107508215311794`, 0.6435575647008209}, {0.9845306843286685, 
      0.3405270849201812, 0.6440035994084874}, {0.9844284207781425, 
      0.3399791511116847, 0.6444492696664575}, {0.9843258565898565, 
      0.3394312811602103, 0.6448945754296463}, {0.9842229921516462, 
      0.33888347549849696`, 0.6453395166531491}, {0.9841198278516884, 
      0.33833573455944677`, 0.6457840932922421}, {0.9840163640785012, 
      0.3377880587761207, 0.6462283053023803}, {0.9839126012209458, 
      0.3372404485817488, 0.6466721526391972}, {0.9838085396682261, 
      0.3366929044097202, 0.6471156352585058}, {0.9837041798098906, 
      0.33614542669359543`, 0.6475587531162955}, {0.9835995220358331, 
      0.33559801586710025`, 0.6480015061687326}, {0.9834945667362933, 
      0.3350506723641339, 0.6484438943721598}, {0.9833893143018578, 
      0.3345033966187628, 0.6488859176830953}, {0.9832837651234612, 
      0.3339561890652296, 0.6493275760582319}, {0.9831779195923867, 
      0.3334090501379499, 0.6497688694544365}, {0.983071778100267, 
      0.3328619802715178, 0.6502097978287497}, {0.9829653410390858, 
      0.332314979900701, 0.6506503611383846}, {0.9828586088011783, 
      0.33176804946045246`, 0.6510905593407261}, {0.9827515817792315, 
      0.3312211893859006, 0.6515303923933312}, {0.9826442603662865, 
      0.33067440011235955`, 0.6519698602539269}, {0.9825366449557383, 
      0.3301276820753283, 0.6524089628804103}, {0.9824287359413375, 
      0.32958103571049036`, 0.6528477002308475}, {0.9823205337171904, 
      0.3290344614537166, 0.653286072263474}, {0.982212038677761, 
      0.3284879597410693, 0.653724078936692}, {0.982103251217871, 
      0.3279415310087992, 0.6541617202090722}, {0.9819941717327016, 
      0.32739517569335214`, 0.6545989960393499}, {0.9818848006177938, 
      0.3268488942313668, 0.6550359063864274}, {0.9817751382690497, 
      0.3263026870596778, 0.6554724512093718}, {0.9816651850827338, 
      0.3257565546153206, 0.6559086304674133}, {0.9815549414554732, 
      0.3252104973355267, 0.6563444441199472}, {0.9814444077842593, 
      0.32466451565772914`, 0.6567798921265301}, {0.9813335844664486, 
      0.32411861001956654`, 0.6572149744468818}, {0.9812224718997635, 
      0.32357278085888064`, 0.6576496910408829}, {0.9811110704822937, 
      0.32302702861371985`, 0.6580840418685736}, {0.980999380612497, 
      0.3224813537223422, 0.6585180268901549}, {0.9808874026892003, 
      0.3219357566232131, 0.6589516460659871}, {0.9807751371116007, 
      0.32139023775501346`, 0.6593848993565876}, {0.9806625842792667, 
      0.3208447975566351, 0.6598177867226316}, {0.980549744592139, 
      0.3202994364671876, 0.6602503081249514}, {0.9804366184505316, 
      0.3197541549259974, 0.6606824635245346}, {0.9803232062551333, 
      0.31920895337260813`, 0.6611142528825252}, {0.980209508407008, 
      0.31866383224678835`, 0.6615456761602201}, {0.9800955253075965, 
      0.3181187919885262, 0.6619767333190701}, {0.979981257358717, 
      0.31757383303803755`, 0.6624074243206794}, {0.9798667049625669, 
      0.31702895583576307`, 0.6628377491268037}, {0.9797518685217231, 
      0.3164841608223736, 0.66326770769935}, {0.9796367484391438, 
      0.31593944843876853`, 0.6636973000003756}, {0.9795213451181691, 
      0.31539481912608175`, 0.6641265259920875}, {0.9794056589625223, 
      0.31485027332568, 0.6645553856368422}, {0.9792896903763115, 
      0.3143058114791694, 0.6649838788971421}, {0.9791734397640298, 
      0.31376143402839174`, 0.6654120057356384}, {0.9790569075305573, 
      0.3132171414154285, 0.6658397661151287}, {0.9789400940811616, 
      0.3126729340826063, 0.6662671599985557}, {0.9788229998214996, 
      0.3121288124724935, 0.6666941873490063}, {0.9787056251576182, 
      0.3115847770279068, 0.6671208481297115}, {0.9785879704959556, 
      0.31104082819191, 0.6675471423040457}, {0.9784700362433424, 
      0.3104969664078178, 0.667973069835525}, {0.9783518228070031, 
      0.30995319211919614`, 0.6683986306878069}, {0.9782333305945569, 
      0.3094095057698678, 0.6688238248246893}, {0.9781145600140193, 
      0.3088659078039102, 0.6692486522101097}, {0.9779955114738029, 
      0.30832239866565914`, 0.6696731128081438}, {0.9778761853827188, 
      0.3077789787997124, 0.6700972065830066}, {0.9777565821499783, 
      0.3072356486509305, 0.6705209334990481}, {0.9776367021851929, 
      0.3066924086644375, 0.6709442935207559}, {0.9775165458983772, 
      0.30614925928562536`, 0.6713672866127518}, {0.9773961136999485, 
      0.305606200960156, 0.6717899127397926}, {0.9772754060007295, 
      0.30506323413396164`, 0.672212171866768}, {0.9771544232119483, 
      0.30452035925324744`, 0.6726340639587008}, {0.977033165745241, 
      0.3039775767644961, 0.6730555889807448}, {0.9769116340126516, 
      0.30343488711446653`, 0.673476746898185}, {0.9767898284266345, 
      0.3028922907501992, 0.6738975376764353}, {0.976667749400055, 
      0.30234978811901525`, 0.6743179612810397}, {0.976545397346191, 
      0.30180737966852117`, 0.6747380176776696}, {0.976422772678734, 
      0.30126506584661206`, 0.6751577068321224}, {0.9762998758117908, 
      0.3007228471014671, 0.6755770287103238}, {0.9761767071598846, 
      0.3001807238815623, 0.6759959832783228}, {0.9760532671379567, 
      0.2996386966356638, 0.6764145705022928}, {0.9759295561613671, 
      0.2990967658128361, 0.6768327903485309}, {0.9758055746458965, 
      0.29855493186243903`, 0.6772506427834573}, {0.9756813230077477, 
      0.29801319523413616`, 0.6776681277736116}, {0.9755568016635464, 
      0.2974715563778916, 0.678085245285655}, {0.9754320110303434, 
      0.2969300157439752, 0.678501995286368}, {0.9753069515256151, 
      0.29638857378296557`, 0.6789183777426496}, {0.9751816235672658, 
      0.29584723094575044`, 0.6793343926215156}, {0.9750560275736283, 
      0.295305987683529, 0.679750039890099}, {0.9749301639634659, 
      0.29476484444781836`, 0.6801653195156477}, {0.9748040331559739, 
      0.29422380169045037`, 0.6805802314655237}, {0.97467763557078, 
      0.2936828598635764, 0.6809947757072037}, {0.9745509716279475, 
      0.29314201941967166`, 0.681408952208276}, {0.974424041747975, 
      0.2926012808115347, 0.6818227609364401}, {0.9742968463517994, 
      0.29206064449229363`, 0.6822362018595061}, {0.9741693858607958, 
      0.2915201109154026, 0.6826492749453937}, {0.9740416606967806, 
      0.29097968053465006`, 0.6830619801621307}, {0.9739136712820117, 
      0.2904393538041598, 0.6834743174778523}, {0.973785418039191, 
      0.289899131178392, 0.6838862868607994}, {0.9736569013914653, 
      0.28935901311214596`, 0.684297888279319}, {0.9735281217624276, 
      0.28881900006056643`, 0.6847091217018613}, {0.9733990795761198, 
      0.2882790924791393, 0.6851199870969803}, {0.973269775257033, 
      0.2877392908237016, 0.6855304844333313}, {0.9731402092301095, 
      0.28719959555043895`, 0.6859406136796709}, {0.9730103819207445, 
      0.2866600071158899, 0.6863503748048551}, {0.972880293754788, 
      0.2861205259769485, 0.6867597677778394}, {0.9727499451585453, 
      0.2855811525908688, 0.6871687925676763}, {0.9726193365587799, 
      0.28504188741526554`, 0.6875774491435146}, {0.9724884683827141, 
      0.28450273090811523`, 0.6879857374745987}, {0.9723573410580313, 
      0.2839636835277635, 0.6883936575302677}, {0.9722259550128773, 
      0.2834247457329238, 0.6888012092799534}, {0.9720943106758619, 
      0.28288591798268287`, 0.6892083926931795}, {0.9719624084760609, 
      0.2823472007365004, 0.6896152077395611}, {0.9718302488430169, 
      0.2818085944542141, 0.6900216543888027}, {0.9716978322067424, 
      0.28127009959604565`, 0.6904277326106971}, {0.9715651589977204, 
      0.2807317166225958, 0.6908334423751248}, {0.9714322296469063, 
      0.28019344599485413`, 0.6912387836520527}, {0.9712990445857298, 
      0.27965528817419755`, 0.6916437564115323}, {0.9711656042460963, 
      0.279117243622397, 0.6920483606236997}, {0.9710319090603893, 
      0.2785793128016169, 0.6924525962587728}, {0.9708979594614713, 
      0.2780414961744197, 0.6928564632870516}, {0.9707637558826862, 
      0.2775037942037703, 0.6932599616789162}, {0.9706292987578605, 
      0.2769662073530342, 0.6936630914048261}, {0.9704945885213059, 
      0.27642873608598834`, 0.6940658524353178}, {0.9703596256078203, 
      0.2758913808668148, 0.6944682447410054}, {0.9702244104526899, 
      0.2753541421601116, 0.6948702682925781}, {0.9700889434916911, 
      0.27481702043089207`, 0.6952719230607989}, {0.9699532251610922, 
      0.27428001614458875`, 0.6956732090165036}, {0.9698172558976554, 
      0.2737431297670556, 0.6960741261306002}, {0.9696810361386383, 
      0.27320636176457114`, 0.6964746743740674}, {0.9695445663217965, 
      0.2726697126038452, 0.6968748537179515}, {0.9694078468853841, 
      0.27213318275201576`, 0.6972746641333687}, {0.9692708782681574, 
      0.2715967726766582, 0.6976741055914993}, {0.9691336609093752, 
      0.27106048284578393`, 0.6980731780635914}, {0.9689961952488021, 
      0.27052431372784713`, 0.6984718815209549}, {0.968858481726709, 
      0.2699882657917457, 0.6988702159349631}, {0.9687205207838762, 
      0.2694523395068257, 0.6992681812770507}, {0.9685823128615946, 
      0.2689165353428817, 0.6996657775187127}, {0.9684438584016681, 
      0.2683808537701664, 0.7000630046315022}, {0.9683051578464158, 
      0.267845295259387, 0.7004598625870292}, {0.9681662116386732, 
      0.2673098602817133, 0.7008563513569601}, {0.9680270202217951, 
      0.26677454930877875`, 0.701252470913016}, {0.9678875840396564, 
      0.2662393628126855, 0.7016482212269711}, {0.9677479035366559, 
      0.2657043012660053, 0.7020436022706507}, {0.9676079791577166, 
      0.2651693651417854, 0.7024386140159312}, {0.9674678113482892, 
      0.264634554913552, 0.7028332564347378}, {0.9673274005543531, 
      0.26409987105531085`, 0.7032275294990424}, {0.9671867472224187, 
      0.26356531404155387`, 0.7036214331808649}, {0.9670458517995302, 
      0.26303088434726196`, 0.7040149674522685}, {0.966904714733267, 
      0.2624965824479077, 0.7044081322853597}, {0.9667633364717461, 
      0.2619624088194588, 0.7048009276522869}, {0.966621717463624, 
      0.2614283639383845, 0.7051933535252395}, {0.9664798581580994, 
      0.2608944482816546, 0.7055854098764454}, {0.9663377590049149, 
      0.2603606623267452, 0.7059770966781695}, {0.9661954204543595, 
      0.25982700655164687`, 0.7063684139027128}, {0.9660528429572702, 
      0.25929348143485936`, 0.7067593615224111}, {0.9659100269650353, 
      0.2587600874554029, 0.7071499395096329}, {0.9657669729295956, 
      0.2582268250928186, 0.7075401478367774}, {0.9656236813034471, 
      0.2576936948271721, 0.7079299864762754}, {0.9654801525396434, 
      0.2571606971390596, 0.7083194554005842}, {0.9653363870917978, 
      0.25662783250960997`, 0.7087085545821883}, {0.9651923854140856, 
      0.2560951014204873, 0.7090972839935983}, {0.9650481479612463, 
      0.25556250435389877`, 0.7094856436073476}, {0.9649036751885863, 
      0.25503004179259486`, 0.7098736333959914}, {0.9647589675519811, 
      0.25449771421987516`, 0.7102612533321063}, {0.9646140255078772, 
      0.25396552211959034`, 0.7106485033882873}, {0.9644688495132955, 
      0.25343346597614924`, 0.711035383537146}, {0.9643234400258323, 
      0.25290154627452155`, 0.7114218937513109}, {0.9641777975036632, 
      0.2523697635002401, 0.711808034003423}, {0.9640319224055444, 
      0.2518381181394078, 0.7121938042661371}, {0.9638858151908157, 
      0.25130661067869814`, 0.7125792045121174}, {0.963739476319403, 
      0.25077524160536546`, 0.7129642347140377}, {0.9635929062518205, 
      0.25024401140724145`, 0.7133488948445795}, {0.9634461054491733, 
      0.24971292057274402`, 0.7137331848764291}, {0.96329907437316, 
      0.24918196959088293`, 0.7141171047822771}, {0.9631518134860749, 
      0.2486511589512589, 0.7145006545348165}, {0.9630043232508118, 
      0.2481204891440714, 0.7148838341067401}, {0.9628566041308642, 
      0.24758996066012431`, 0.7152666434707401}, {0.9627086565903304, 
      0.24705957399082543`, 0.7156490825995049}, {0.962560481093915, 
      0.24652932962819626`, 0.7160311514657189}, {0.9624120781069306, 
      0.24599922806487098`, 0.7164128500420599}, {0.9622634480953025, 
      0.2454692697941058, 0.7167941783011966}, {0.9621145915255696, 
      0.2449394553097814, 0.7171751362157882}, {0.9619655088648877, 
      0.24440978510640712`, 0.7175557237584812}, {0.961816200581033, 
      0.24388025967912416`, 0.7179359409019089}, {0.9616666671424032, 
      0.24335087952371434`, 0.7183157876186888}, {0.9615169090180214, 
      0.2428216451366013, 0.7186952638814205}, {0.961366926677539, 
      0.24229255701485444`, 0.7190743696626845}, {0.9612167205912373, 
      0.2417636156561972, 0.7194531049350402}, {0.9610662912300317, 
      0.2412348215590086, 0.7198314696710232}, {0.9609156390654738, 
      0.2407061752223299, 0.7202094638431443}, {0.9607647645697538, 
      0.24017767714586577`, 0.720587087423888}, {0.9606136682157045, 
      0.23964932782999684`, 0.7209643403857083}, {0.9604623504768034, 
      0.2391211277757746, 0.7213412227010293}, {0.9603108118271756, 
      0.23859307748493339`, 0.7217177343422426}, {0.9601590527415969, 
      0.23806517745989303`, 0.722093875281704}, {0.960007073695497, 
      0.23753742820376444`, 0.7224696454917329}, {0.9598548751649623, 
      0.23700983022035313`, 0.7228450449446093}, {0.9597024576267382, 
      0.23648238401416474`, 0.7232200736125731}, {0.9595498215582334, 
      0.23595509009041296`, 0.7235947314678209}, {0.9593969674375216, 
      0.23542794895501715`, 0.7239690184825046}, {0.959243895743346, 
      0.23490096111461853`, 0.7243429346287278}, {0.9590906069551207, 
      0.23437412707657448`, 0.7247164798785469}, {0.9589371015529355, 
      0.23384744734897073`, 0.7250896542039651}, {0.9587833800175578, 
      0.23332092244062508`, 0.7254624575769332}, {0.9586294428304357, 
      0.23279455286108885`, 0.7258348899693472}, {0.9584752904737027, 
      0.2322683391206594, 0.7262069513530436}, {0.9583209234301788, 
      0.2317422817303783, 0.7265786416998007}, {0.9581663421833754, 
      0.2312163812020415, 0.7269499609813341}, {0.9580115472174972, 
      0.23069063804820125`, 0.7273209091692958}, {0.957856539017447, 
      0.23016505278217747`, 0.7276914862352696}, {0.9577013180688274, 
      0.22963962591805473`, 0.7280616921507729}, {0.9575458848579449, 
      0.2291143579706944, 0.728431526887251}, {0.9573902398718138, 
      0.22858924945573755`, 0.728800990416076}, {0.957234383598158, 
      0.2280643008896129, 0.7291700827085452}, {0.957078316525416, 
      0.22753951278953843`, 0.7295388037358774}, {0.9569220391427433, 
      0.22701488567353145`, 0.7299071534692119}, {0.9567655519400163, 
      0.22649042006041112`, 0.730275131879605}, {0.9566088554078355, 
      0.22596611646980627`, 0.7306427389380291}, {0.9564519500375291, 
      0.2254419754221606, 0.7310099746153687}, {0.9562948363211569, 
      0.22491799743873794`, 0.731376838882419}, {0.9561375147515129, 
      0.2243941830416295, 0.7317433317098833}, {0.9559799858221296, 
      0.22387053275375876`, 0.7321094530683709}, {0.9558222500272818, 
      0.22334704709888786`, 0.7324752029283937}, {0.9556643078619893, 
      0.22282372660162467`, 0.7328405812603649}, {0.9555061598220217, 
      0.22230057178742654`, 0.7332055880345951}, {0.9553478064039008, 
      0.22177758318260912`, 0.7335702232212916}, {0.9551892481049056, 
      0.221254761314351, 0.7339344867905547}, {0.9550304854230748, 
      0.2207321067106999, 0.7342983787123749}, {0.9548715188572119, 
      0.22020961990058088`, 0.7346618989566309}, {0.9547123489068875, 
      0.21968730141380013`, 0.7350250474930876}, {0.9545529760724445, 
      0.2191651517810521, 0.7353878242913925}, {0.954393400855001, 
      0.21864317153392848`, 0.7357502293210725}, {0.9542336237564544, 
      0.2181213612049209, 0.7361122625515337}, {0.9540736452794857, 
      0.2175997213274295, 0.7364739239520564}, {0.9539134659275631, 
      0.21707825243576995`, 0.7368352134917929}, {0.9537530862049459, 
      0.2165569550651804, 0.7371961311397658}, {0.9535925066166888, 
      0.2160358297518254, 0.7375566768648636}, {0.9534317276686453, 
      0.21551487703280492`, 0.7379168506358404}, {0.9532707498674728, 
      0.2149940974461627, 0.7382766524213101}, {0.9531095737206358, 
      0.21447349153088938`, 0.7386360821897463}, {0.9529481997364101, 
      0.21395305982693305`, 0.7389951399094775}, {0.9527866284238875, 
      0.21343280287520222`, 0.7393538255486857}, {0.9526248602929798, 
      0.21291272121757773`, 0.7397121390754021}, {0.9524628958544223, 
      0.21239281539691593`, 0.7400700804575061}, {0.9523007356197792, 
      0.21187308595705862`, 0.7404276496627206}, {0.952138380101447, 
      0.21135353344283694`, 0.7407848466586098}, {0.9519758298126593, 
      0.21083415840008277`, 0.7411416714125767}, {0.9518130852674909, 
      0.21031496137563208`, 0.7414981238918589}, {0.9516501469808624, 
      0.20979594291733547`, 0.7418542040635272}, {0.9514870154685443, 
      0.20927710357406337`, 0.7422099118944808}, {0.9513236912471619, 
      0.2087584438957164, 0.742565247351446}, {0.9511601748341993, 
      0.20823996443322762`, 0.7429202104009713}, {0.9509964667480045, 
      0.2077216657385791, 0.7432748010094258}, {0.9508325675077937, 
      0.20720354836479826`, 0.7436290191429958}, {0.9506684776336551, 
      0.20668561286597423`, 0.7439828647676807}, {0.9505041976465552, 
      0.20616785979726454`, 0.7443363378492909}, {0.9503397280683423, 
      0.20565028971489846`, 0.7446894383534437}, {0.9501750694217511, 
      0.20513290317619015`, 0.7450421662455611}, {0.9500102222304083, 
      0.20461570073954288`, 0.7453945214908655}, {0.9498451870188367, 
      0.20409868296446063`, 0.7457465040543761}, {0.9496799643124603, 
      0.2035818504115525, 0.7460981139009082}, {0.9495145546376089, 
      0.20306520364254263`, 0.7464493509950665}, {0.9493489585215236, 
      0.20254874322028038`, 0.7468002153012435}, {0.9491831764923608, 
      0.2020324697087454, 0.7471507067836157}, {0.9490172090791987, 
      0.20151638367305813`, 0.7475008254061406}, {0.9488510568120404, 
      0.20100048567948864`, 0.7478505711325517}, {0.9486847202218202, 
      0.20048477629546246`, 0.748199943926358}, {0.9485181998404085, 
      0.19996925608957133`, 0.7485489437508375}, {0.9483514962006172, 
      0.19945392563158298`, 0.7488975705690344}, {0.9481846098362042, 
      0.19893878549244828`, 0.7492458243437564}, {0.948017541281879, 
      0.19842383624430812`, 0.749593705037571}, {0.9478502910733082, 
      0.19790907846050776`, 0.7499412126128004}, {0.9476828597471204, 
      0.1973945127156009, 0.7502883470315198}, {0.9475152478409119, 
      0.19688013958535996`, 0.7506351082555521}, {0.9473474558932522, 
      0.1963659596467876, 0.7509814962464646}, {0.9471794844436888, 
      0.19585197347812258`, 0.7513275109655659}, {0.9470113340327533, 
      0.19533818165885228`, 0.7516731523739015}, {0.9468430052019667, 
      0.19482458476971765`, 0.7520184204322495}, {0.9466744984938457, 
      0.19431118339272824`, 0.7523633151011175}, {0.9465058144519064, 
      0.1937979781111673, 0.7527078363407393}, {0.9463369536206723, 
      0.19328496950960364`, 0.7530519841110688}, {0.9461679165456791, 
      0.19277215817390203`, 0.7533957583717769}, {0.9459987037734797, 
      0.19225954469122986`, 0.7537391590822498}, {0.9458293158516511, 
      0.19174712965006963`, 0.7540821862015816}, {0.9456597533288001, 
      0.19123491364022788`, 0.7544248396885721}, {0.9454900167545687, 
      0.19072289725284805`, 0.7547671195017212}, {0.9453201066796402, 
      0.1902110810804133, 0.7551090255992271}, {0.945150023655746, 
      0.1896994657167665, 0.75545055793898}, {0.9449797682356708, 
      0.18918805175711192`, 0.755791716478559}, {0.9448093409732589, 
      0.18867683979803243`, 0.7561325011752267}, {0.9446387424234208, 
      0.188165830437495, 0.7564729119859257}, {0.9444679731421389, 
      0.18765502427486427`, 0.7568129488672748}, {0.9442970336864743, 
      0.18714442191091096`, 0.7571526117755633}, {0.9441259246145726, 
      0.18663402394782533`, 0.7574919006667471}, {0.9439546464856708, 
      0.18612383098922672`, 0.7578308154964444}, {0.9437831998601034, 
      0.18561384364017108`, 0.7581693562199321}, {0.943611585299309, 
      0.18510406250717107`, 0.7585075227921383}, {0.9434398033658372, 
      0.1845944881981964, 0.758845315167641}, {0.9432678546233545, 
      0.18408512132269272`, 0.7591827333006619}, {0.9430957396366515, 
      0.18357596249159072`, 0.7595197771450614}, {0.9429234589716499, 
      0.18306701231731584`, 0.7598564466543345}, {0.9427510131954083, 
      0.1825582714138021, 0.7601927417816062}, {0.9425784028761305, 
      0.18204974039650496`, 0.7605286624796257}, {0.9424056285831706, 
      0.1815414198824073, 0.7608642087007633}, {0.9422326908870418, 
      0.18103331049003824`, 0.7611993803970033}, {0.9420595903594223, 
      0.18052541283948242`, 0.7615341775199403}, {0.9418863275731627, 
      0.18001772755238865`, 0.7618686000207746}, {0.941712903102293, 
      0.17951025525198738`, 0.7622026478503061}, {0.9415393175220306, 
      0.1790029965631013, 0.7625363209589293}, {0.9413655714087861, 
      0.1784959521121562, 0.7628696192966296}, {0.9411916653401724, 
      0.1779891225271971, 0.7632025428129756}, {0.9410175998950104, 
      0.17748250843789412`, 0.7635350914571164}, {0.9408433756533381, 
      0.17697611047556325`, 0.7638672651777749}, {0.9406689931964171, 
      0.17646992927317487`, 0.7641990639232423}, {0.9404944531067403, 
      0.17596396546536672`, 0.7645304876413738}, {0.94031975596804, 
      0.1754582196884575, 0.7648615362795824}, {0.9401449023652955, 
      0.17495269258046278`, 0.7651922097848326}, {0.9399698928847408, 
      0.1744473847811039, 0.7655225081036368}, {0.9397947281138724, 
      0.17394229693182436`, 0.7658524311820479}, {0.9396194086414582, 
      0.17343742967580392`, 0.7661819789656549}, {0.9394439350575438, 
      0.17293278365796794`, 0.7665111513995764}, {0.9392683079534622, 
      0.17242835952500732`, 0.7668399484284547}, {0.9390925279218413, 
      0.17192415792539023`, 0.767168369996451}, {0.938916595556612, 
      0.17142017950937394`, 0.7674964160472385}, {0.9387405114530172, 
      0.17091642492902015`, 0.7678240865239969}, {0.93856427620762, 
      0.17041289483821423`, 0.7681513813694058}, {0.9383878904183112, 
      0.16990958989267146`, 0.76847830052564}, {0.9382113546843194, 
      0.1694065107499579, 0.7688048439343621}, {0.9380346696062188, 
      0.16890365806950275`, 0.7691310115367163}, {0.9378578357859382, 
      0.16840103251261454`, 0.7694568032733233}, {0.937680853826769, 
      0.16789863474249606`, 0.7697822190842728}, {0.9375037243333758, 
      0.1673964654242578, 0.7701072589091178}, {0.9373264479118035, 
      0.16689452522493523`, 0.7704319226868681}, {0.9371490251694881, 
      0.16639281481350493`, 0.7707562103559834}, {0.9369714567152644, 
      0.16589133486089724`, 0.7710801218543668}, {0.9367937431593756, 
      0.16539008604001698`, 0.7714036571193592}, {0.9366158851134837, 
      0.16488906902575295`, 0.7717268160877306}, {0.9364378831906772, 
      0.1643882844950017, 0.772049598695676}, {0.936259738005482, 
      0.16388773312667676`, 0.7723720048788053}, {0.9360814501738703, 
      0.16338741560173048`, 0.7726940345721399}, {0.9359030203132708, 
      0.16288733260316893`, 0.7730156877101022}, {0.9357244490425768, 
      0.16238748481606424`, 0.7733369642265128}, {0.9355457369821594, 
      0.16188787292758133`, 0.7736578640545779}, {0.9353668847538735, 
      0.16138849762698626`, 0.7739783871268877}, {0.9351878929810714, 
      0.16088935960566633`, 0.7742985333754049}, {0.93500876228861, 
      0.1603904595571499, 0.7746183027314603}, {0.9348294933028635, 
      0.1598917981771208, 0.7749376951257427}, {0.934650086651732, 
      0.15939337616343763`, 0.7752567104882944}, {0.9344705429646527, 
      0.15889519421615234`, 0.7755753487485009}, {0.934290862872611, 
      0.15839725303752708`, 0.7758936098350843}, {0.9341110470081495, 
      0.15789955333205286`, 0.7762114936760967}, {0.9339310960053808, 
      0.1574020958064704, 0.7765290001989101}, {0.9337510104999965, 
      0.1569048811697862, 0.7768461293302109}, {0.93357079112928, 
      0.15640791013329067`, 0.7771628809959897}, {0.933390438532116, 
      0.15591118341058158`, 0.7774792551215346}, {0.933209953349002, 
      0.1554147017175781, 0.7777952516314236}, {0.933029336222061, 
      0.15491846577254706`, 0.7781108704495143}, {0.932848587795051, 
      0.1544224762961148, 0.7784261114989367}, {0.9326677087133776, 
      0.15392673401129142`, 0.7787409747020865}, {0.9324866996241055, 
      0.1534312396434922, 0.7790554599806132}, {0.9323055611759703, 
      0.1529359939205565, 0.7793695672554137}, {0.93212429401939, 
      0.1524409975727662, 0.7796832964466237}, {0.9319428988064774, 
      0.15194625133286943`, 0.7799966474736084}, {0.9317613761910525, 
      0.15145175593610027`, 0.7803096202549524}, {0.9315797268286536, 
      0.15095751212020045`, 0.7806222147084533}, {0.9313979513765512, 
      0.15046352062544058`, 0.7809344307511106}, {0.9312160504937594, 
      0.14996978219464238`, 0.7812462682991169}, {0.9310340248410484, 
      0.1494762975731983, 0.7815577272678499}, {0.9308518750809586, 
      0.14898306750909796`, 0.7818688075718605}, {0.9306696018778118, 
      0.1484900927529456, 0.7821795091248667}, {0.9304872058977252, 
      0.14799737405798488`, 0.7824898318397404}, {0.9303046878086249, 
      0.14750491218012415`, 0.7827997756285006}, {0.9301220482802581, 
      0.1470127078779568, 0.7831093404023016}, {0.929939287984207, 
      0.1465207619127819, 0.7834185260714249}, {0.9297564075939029, 
      0.14602907504863538`, 0.7837273325452677}, {0.9295734077846388, 
      0.1455376480523058, 0.7840357597323331}, {0.9293902892335847, 
      0.14504648169336434`, 0.7843438075402205}, {0.9292070526198001, 
      0.1445555767441854, 0.7846514758756145}, {0.929023698624249, 
      0.1440649339799743, 0.784958764644275}, {0.9288402279298144, 
      0.14357455417878842`, 0.7852656737510259}, {0.928656641221312, 
      0.143084438121567, 0.785572203099745}, {0.928472939185505, 
      0.14259458659215232`, 0.7858783525933533}, {0.9282891225111195, 
      0.14210500037731702`, 0.7861841221338032}, {0.9281051918888588, 
      0.14161568026679078`, 0.7864895116220678}, {0.9279211480114182, 
      0.14112662705328813`, 0.7867945209581306}, {0.927736991573501, 
      0.14063784153252862`, 0.7870991500409725}, {0.9275527232718334, 
      0.14014932450327205`, 0.7874033987685616}, {0.9273683438051804, 
      0.13966107676734002`, 0.7877072670378407}, {0.9271838538743609, 
      0.13917309912964404`, 0.7880107547447168}, {0.9269992541822643, 
      0.13868539239821726`, 0.7883138617840476}, {0.9268145454338663, 
      0.1381979573842355, 0.7886165880496306}, {0.9266297283362448, 
      0.13771079490205387`, 0.7889189334341912}, {0.926444803598597, 
      0.13722390576922874`, 0.789220897829369}, {0.9262597719322556, 
      0.13673729080654934`, 0.7895224811257062}, {0.9260746340507057, 
      0.13625095083806996`, 0.7898236832126355}, {0.9258893906696014, 
      0.1357648866911355, 0.7901245039784662}, {0.9257040425067834, 
      0.13527909919640999`, 0.7904249433103735}, {0.9255185902822967, 
      0.13479358918791493`, 0.7907250010943816}, {0.9253330347184071, 
      0.13430835750305303`, 0.7910246772153542}, {0.92514737653962, 
      0.1338234049826413, 0.7913239715569792}, {0.924961616472697, 
      0.13333873247094044`, 0.7916228840017564}, {0.9247757552466762, 
      0.13285434081569494`, 0.7919214144309817}, {0.9245897935928885, 
      0.13237023086815294`, 0.792219562724736}, {0.9244037322449765, 
      0.13188640348310793`, 0.7925173287618691}, {0.924217571938915, 
      0.13140285951892883`, 0.7928147124199861}, {0.9240313134130269, 
      0.1309195998375934, 0.7931117135754339}, {0.9238449574080059, 
      0.13043662530472167`, 0.7934083321032844}, {0.9236585046669328, 
      0.12995393678961034`, 0.7937045678773227}, {0.9234719559352974, 
      0.12947153516526713`, 0.7940004207700302}, {0.923285311961017, 
      0.12898942130844682`, 0.7942958906525701}, {0.9230985734944572, 
      0.12850759609968523`, 0.7945909773947717}, {0.9229117412884519, 
      0.12802606042333672`, 0.7948856808651154}, {0.9227248160983238, 
      0.12754481516760663`, 0.7951800009307175}, {0.9225377986819056, 
      0.12706386122459282`, 0.7954739374573132}, {0.9223506897995608, 
      0.12658319949031957`, 0.7957674903092413}, {0.9221634902142045, 
      0.12610283086477628`, 0.796060659349428}, {0.9219762006913265, 
      0.1256227562519563, 0.7963534444393698}, {0.9217888219990111, 
      0.12514297655989393`, 0.796645845439117}, {0.9216013549079598, 
      0.12466349270070147`, 0.7969378622072583}, {0.9214138001915153, 
      0.12418430559061457`, 0.7972294946009006}, {0.9212261586256816, 
      0.12370541615002745`, 0.7975207424756546}, {0.9210384309891477, 
      0.12322682530353087`, 0.7978116056856167}, {0.9208506180633125, 
      0.12274853397996323`, 0.7981020840833493}, {0.9206627206323049, 
      0.12227054311244011`, 0.7983921775198648}, {0.9204747394830105, 
      0.12179285363840317`, 0.7986818858446075}, {0.9202866754050935, 
      0.12131546649966027`, 0.7989712089054336}, {0.9200985291910226, 
      0.12083838264242959`, 0.7992601465485933}, {0.9199103016360943, 
      0.12036160301738237`, 0.7995486986187123}, {0.9197219935384584, 
      0.11988512857968697`, 0.7998368649587714}, {0.9195336056991428, 
      0.11940896028905389`, 0.800124645410089}, {0.9193451389220798, 
      0.11893309910978117`, 0.8004120398122987}, {0.9191565940141303, 
      0.11845754601079847`, 0.8006990480033324}, {0.9189679717851122, 
      0.11798230196571513`, 0.8009856698193971}, {0.918779273047824, 
      0.11750736795286741`, 0.8012719050949567}, {0.9185904986180746, 
      0.11703274495536474`, 0.80155775366271}, {0.9184016493147082, 
      0.11655843396113913`, 0.8018432153535693}, {0.9182127259596323, 
      0.11608443596299194`, 0.802128289996641}, {0.918023729377846, 
      0.11561075195864459`, 0.8024129774192017}, {0.917834660397468, 
      0.11513738295079064`, 0.8026972774466772}, {0.9176455198497642, 
      0.11466432994714339`, 0.8029811899026208}, {0.9174563085691776, 
      0.11419159396048706`, 0.8032647146086906}, {0.9172670273933576, 
      0.11371917600873199`, 0.8035478513846257}, {0.9170776771631889, 
      0.1132470771149653, 0.8038306000482236}, {0.9168882587228218, 
      0.1127752983075048, 0.8041129604153171}, {0.916698772919702, 
      0.11230384061995095`, 0.8043949322997511}, {0.9165092206046033, 
      0.11183270509124701`, 0.8046765155133564}, {0.9163196026316559, 
      0.11136189276572837`, 0.8049577098659275}, {0.9161299198583808, 
      0.11089140469318476`, 0.8052385151651958}, {0.9159401731457194, 
      0.11042124192891285`, 0.8055189312168064}, {0.9157503633580675, 
      0.1099514055337762, 0.8057989578242916}, {0.9155604913633081, 
      0.10948189657426402`, 0.8060785947890441}, {0.9153705580328432, 
      0.10901271612254983`, 0.8063578419102936}, {0.915180564241629, 
      0.10854386525655282`, 0.8066366989850765}, {0.9149905108682103, 
      0.10807534505999793`, 0.8069151658082119}, {0.9148003987947527, 
      0.10760715662247937`, 0.8071932421722735}, {0.9146102289070812, 
      0.10713930103952025`, 0.8074709278675608}, {0.9144200020947132, 
      0.10667177941264144`, 0.8077482226820717}, {0.9142297192508945, 
      0.10620459284941985`, 0.8080251264014751}, {0.9140393812726382, 
      0.1057377424635591, 0.8083016388090789}, {0.9138489890607593, 
      0.10527122937495571`, 0.8085777596858043}, {0.9136585435199126, 
      0.10480505470976009`, 0.808853488810153}, {0.9134680455586328, 
      0.10433921960045464`, 0.8091288259581783}, {0.9132774960893697, 
      0.10387372518591523`, 0.8094037709034548}, {0.9130868960285305, 
      0.10340857261148396`, 0.8096783234170464}, {0.9128962462965176, 
      0.10294376302904346`, 0.8099524832674743}, {0.9127055478177694, 
      0.10247929759708303`, 0.8102262502206863}, {0.9125148015208006, 
      0.102015177480777, 0.8104996240400235}, {0.9123240083382447, 
      0.10155140385205827`, 0.8107726044861868}, {0.9121331692068945, 
      0.10108797788969005`, 0.8110451913172042}, {0.9119422850677452, 
      0.10062490077934885`, 0.8113173842883965}, {0.9117513568660384, 
      0.10016217371369648`, 0.8115891831523417}, {0.9115603855513039, 
      0.09969979789246178, 0.8118605876588421}, {0.9113693720774064, 
      0.0992377745225202, 0.8121315975548862}, {0.9111783174025885, 
      0.09877610481797412, 0.8124022125846142}, {0.9109872224895171, 
      0.09831479000023648, 0.8126724324892808}, {0.9107960883053303, 
      0.09785383129811287, 0.812942257007218}, {0.9106049158216836, 
      0.09739322994788731, 0.8132116858737968}, {0.910413706014798, 
      0.09693298719340927, 0.813480718821389}, {0.9102224598655073, 
      0.09647310428617903, 0.8137493555793288}, {0.91003117835931, 
      0.0960135824854382, 0.8140175958738716}, {0.9098398624864152, 
      0.09555442305825995, 0.8142854394281556}, {0.9096485132417965, 
      0.0950956272796378, 0.8145528859621587}, {0.9094571316252418, 
      0.09463719643258332, 0.8148199351926588}, {0.9092657186414046, 
      0.09417913180821325, 0.8150865868331915}, {0.9090742752998586, 
      0.09372143470585328, 0.8153528405940051}, {0.908882802615151, 
      0.09326410643313147, 0.81561869618202}, {0.9086913016068556, 
      0.09280714830607405, 0.8158841533007816}, {0.9084997732996294, 
      0.09235056164921249, 0.8161492116504171}, {0.9083082187232686, 
      0.09189434779567981, 0.8164138709275888}, {0.9081166389127648, 
      0.09143850808731635, 0.8166781308254489}, {0.9079250349083643, 
      0.09098304387477449, 0.8169419910335901}, {0.9077334077556253, 
      0.09052795651762564, 0.8172054512379996}, {0.9075417585054788, 
      0.09007324738446953, 0.8174685111210094}, {0.9073500882142878, 
      0.0896189178530416, 0.8177311703612467}, {0.9071583979439114, 
      0.08916496931032893, 0.8179934286335829}, {0.9069666887617639, 
      0.08871140315267982, 0.8182552856090846}, {0.9067749617408819, 
      0.08825822078592419, 0.8185167409549579}, {0.9065832179599858, 
      0.08780542362548806, 0.8187777943344982}, {0.9063914585035477, 
      0.08735301309651301, 0.8190384454070347}, {0.9061996844618561, 
      0.08690099063397866, 0.8192986938278775}, {0.9060078969310849, 
      0.0864493576828261, 0.8195585392482587}, {0.9058160970133616, 
      0.08599811569808179, 0.8198179813152796}, {0.9056242858168378, 
      0.08554726614498928, 0.8200770196718483}, {0.905432464455759, 
      0.08509681049913319, 0.8203356539566261}, {0.9052406340505385, 
      0.08464675024657449, 0.820593883803964}, {0.9050487957278288, 
      0.08419708688398593, 0.8208517088438434}, {0.9048569506205979, 
      0.0837478219187839, 0.8211091287018144}, {0.9046650998682052, 
      0.08329895686927391, 0.8213661429989317}, {0.9044732446164763, 
      0.08285049326478257, 0.8216227513516934}, {0.9042813860177834, 
      0.08240243264581054, 0.8218789533719729}, {0.9040895252311257, 
      0.0819547765641725, 0.8221347486669536}, {0.9038976634222081, 
      0.08150752658314658, 0.8223901368390615}, {0.9037058017635258, 
      0.08106068427762896, 0.8226451174858973}, {0.9035139414344462, 
      0.08061425123428018, 0.8228996902001657}, {0.9033220836212958, 
      0.0801682290516921, 0.8231538545696037}, {0.903130229517446, 
      0.07972261934053661, 0.8234076101769094}, {0.9029383803234021, 
      0.07927742372373503, 0.8236609565996672}, {0.9027465372468924, 
      0.07883264383661977, 0.8239138934102728}, {0.9025547015029586, 
      0.0783882813271007, 0.8241664201758578}, {0.9023628743140523, 
      0.07794433785584313, 0.8244185364582096}, {0.9021710569101248, 
      0.07750081509643021, 0.8246702418136946}, {0.9019792505287273, 
      0.07705771473555288, 0.8249215357931745}, {0.9017874564151062, 
      0.07661503847317937, 0.8251724179419272}, {0.9015956758223047, 
      0.07617278802274516, 0.8254228877995592}, {0.901403910011263, 
      0.07573096511133932, 0.8256729448999235}, {0.9012121602509224, 
      0.07528957147989226, 0.82592258877103}, {0.9010204278183307, 
      0.07484860888337319, 0.8261718189349575}, {0.9008287139987482, 
      0.07440807909098444, 0.8264206349077639}, {0.9006370200857575, 
      0.07396798388636432, 0.8266690361993931}, {0.9004453473813753, 
      0.07352832506779426, 0.826917022313581}, {0.9002536971961647, 
      0.07308910444840566, 0.8271645927477594}, {0.9000620708493503, 
      0.07265032385639113, 0.827411746992959}, {0.8998704696689365, 
      0.07221198513522621, 0.8276584845337102}, {0.8996788949918263, 
      0.07177409014388789, 0.8279048048479388}, {0.8994873481639439, 
      0.07133664075707849, 0.8281507074068652}, {0.8992958305403587, 
      0.07089963886546101, 0.8283961916748975}, {0.8991043434854115, 
      0.07046308637588793, 0.8286412571095234}, {0.8989128883728436, 
      0.07002698521164229, 0.8288859031612013}, {0.8987214665859289, 
      0.06959133731268337, 0.8291301292732459}, {0.8985300795176081, 
      0.06915614463589217, 0.829373934881716}, {0.8983387285706235, 
      0.06872140915532654, 0.8296173194152966}, {0.8981474151576606, 
      0.0682871328624811, 0.8298602822951794}, {0.89795614070149, 
      0.0678533177665491, 0.830102822934941}, {0.8977649066351101, 
      0.06741996589469085, 0.8303449407404198}, {0.8975737144018974, 
      0.06698707929230972, 0.8305866351095875}, {0.8973825654557563, 
      0.06655466002333607, 0.8308279054324207}, {0.8971914612612732, 
      0.06612271017050592, 0.8310687510907679}, {0.8970004032938727, 
      0.06569123183565821, 0.831309171458215}, {0.8968093930399779, 
      0.06526022714003035, 0.8315491658999475}, {0.8966184319971744, 
      0.06482969822456565, 0.831788733772609}, {0.8964275216743771, 
      0.06439964725021995, 0.8320278744241575}, {0.8962366635919999, 
      0.06397007639828192, 0.8322665871937178}, {0.8960458592821291, 
      0.06354098787069615, 0.8325048714114333}, {0.895855110288702, 
      0.06311238389039275, 0.8327427263983093}, {0.8956644181676872, 
      0.0626842667016286, 0.8329801514660586}, {0.8954737844872689, 
      0.06225663857032853, 0.8332171459169404}, {0.8952832108280376, 
      0.06182950178444202, 0.8334537090435962}, {0.8950926987831823, 
      0.06140285865430178, 0.8336898401288811}, {0.8949022499586871, 
      0.06097671151299284, 0.8339255384456943}, {0.8947118659735321, 
      0.06055106271672885, 0.8341608032568033}, {0.8945215484599015, 
      0.06012591464523808, 0.8343956338146633}, {0.8943312990633918, 
      0.05970126970215653, 0.8346300293612353}, {0.8941411194432278, 
      0.05927713031543082, 0.8348639891277975}, {0.8939510112724814, 
      0.05885349893772728, 0.8350975123347543}, {0.8937609762382973, 
      0.05843037804685881, 0.835330598191439}, {0.8935710160421222, 
      0.058007770146208996`, 0.8355632458959132}, {0.893381132399939, 
      0.05758567776517768, 0.8357954546347617}, {0.8931913270425096, 
      0.05716410345962991, 0.8360272235828794}, {0.8930016017156167, 
      0.056743049812357886`, 0.8362585519032588}, {0.892811958180319, 
      0.056322519433552154`, 0.8364894387467674}, {0.8926223982132059, 
      0.05590251496128525, 0.8367198832519209}, {0.8924329236066619, 
      0.05548303906200735, 0.8369498845446541}, {0.8922435361691361, 
      0.055064094431055595`, 0.8371794417380801}, {0.8920542377254166, 
      0.054645683793166214`, 0.837408553932251}, {0.8918650301169151, 
      0.05422780990301091, 0.8376372202139044}, {0.891675915201955, 
      0.053810475545743544`, 0.837865439656212}, {0.891486894856066, 
      0.0533936835375508, 0.8380932113185152}, {0.8912979709722901, 
      0.05297743672623122, 0.8383205342460586}, {0.8911091454614904, 
      0.052561737991777824`, 0.8385474074697125}, {0.8909204202526699, 
      0.05214659024697626, 0.8387738300056936}, {0.890731797293298, 
      0.05173199643802556, 0.8389998008552728}, {0.8905432785496447, 
      0.051317959545165145`, 0.8392253190044798}, {0.890354866007123, 
      0.050904482583324875`, 0.8394503834237986}, {0.8901665616706402, 
      0.050491568602785794`, 0.8396749930678541}, {0.8899783675649594, 
      0.050079220689868344`, 0.839899146875091}, {0.8897902857350678, 
      0.04966744196762238, 0.8401228437674454}, {0.8896023182465562, 
      0.04925623559655048, 0.8403460826500058}, {0.8894144671860078, 
      0.04884560477534191, 0.8405688624106659}, {0.8892267346613981, 
      0.04843555274163049, 0.8407911819197681}, {0.8890391228025029, 
      0.04802608277276547, 0.841013040029737}, {0.8888516337613203, 
      0.047617198186618186`, 0.8412344355747027}, {0.8886642697125017, 
      0.047208902342387525`, 0.8414553673701138}, {0.8884770328537958, 
      0.04680119864145638, 0.8416758342123398}, {0.8882899254065029, 
      0.04639409052824055, 0.8418958348782629}, {0.8881029496159434, 
      0.04598758149108734, 0.8421153681248561}, {0.887916107751939, 
      0.0455816750631871, 0.8423344326887519}, {0.8877294021093052, 
      0.045176374823507795`, 0.8425530272857975}, {0.8875428350083612, 
      0.04477168439776506, 0.8427711506105962}, {0.8873564087954496, 
      0.04436760745941142, 0.8429888013360384}, {0.8871701258434762, 
      0.04396414773066182, 0.8432059781128142}, {0.8869839885524586, 
      0.04356130898354143, 0.8434226795689173}, {0.8867979993500985, 
      0.043159095040970236`, 0.8436389043091287}, {0.8866121606923635, 
      0.04275750977787474, 0.8438546509144887}, {0.8864264750640897, 
      0.04235655712233872, 0.8440699179417515}, {0.8862409449796012, 
      0.04195624105677748, 0.8442847039228233}, {0.8860555729833488, 
      0.041556565619166756`, 0.8444990073641826}, {0.8858703616505663, 
      0.04115753490428226, 0.8447128267462841}, {0.8856853135879474, 
      0.040759153065004, 0.8449261605229434}, {0.8855004314343441, 
      0.04036142431364328, 0.8451390071207011}, {0.8853157178614852, 
      0.03996435292331717, 0.8453513649381682}, {0.8851311755747172, 
      0.03956794322936697, 0.8455632323453505}, {0.8849468073137694, 
      0.039172199630818354`, 0.8457746076829512}, {0.8847626158535419, 
      0.038777126591891246`, 0.8459854892616507}, {0.8845786040049206, 
      0.03838272864355945, 0.8461958753613615}, {0.8843947746156151, 
      0.037989010385153274`, 0.8464057642304618}, {0.8842111305710263, 
      0.03759597648602529, 0.8466151540850009}, {0.8840276747951415, 
      0.037203631687263504`, 0.8468240431078783}, {0.8838444102514599, 
      0.03681198080346361, 0.8470324294479961}, {0.8836613399439454, 
      0.036421028724562966`, 0.8472403112193824}, {0.8834784669180166, 
      0.03603078041773492, 0.8474476865002821}, {0.8832957942615656, 
      0.03564124092934487, 0.8476545533322205}, {0.8831133251060153, 
      0.035252415386985314`, 0.84786090971903}, {0.8829310626274086, 
      0.03486430900156468, 0.8480667536258445}, {0.8827490100475403, 
      0.03447692706948266, 0.8482720829780581}, {0.882567170635126, 
      0.03409027497488149, 0.8484768956602445}, {0.8823855477070129, 
      0.03370435819197406, 0.8486811895150392}, {0.8822041446294335, 
      0.033319182287453245`, 0.8488849623419804}, {0.8820229648193045, 
      0.03293475292299935, 0.8490882118963053}, {0.881842011745576, 
      0.032551075857873236`, 0.8492909358877032}, {0.8816612889306243, 
      0.03216815695160276, 0.8494931319790217}, {0.881480799951704, 
      0.031786002166783164`, 0.8496947977849206}, {0.8813005484424479, 
      0.03140461757196821, 0.8498959308704797}, {0.8811205380944275, 
      0.031024009344681497`, 0.8500965287497461}, {0.8809407726587735, 
      0.030644183774544642`, 0.8502965888842289}, {0.8807612559478561, 
      0.030265147266523042`, 0.8504961086813336}, {0.8805819918370358, 
      0.029886906344304912`, 0.8506950854927313}, {0.8804029842664782, 
      0.029509467653812998`, 0.8508935166126653}, {0.8802242372430457, 
      0.029132837966860663`, 0.8510913992761855}, {0.8800457548422624, 
      0.028757024184949544`, 0.8512887306573129}, {0.8798675412103631, 
      0.028382033343239542`, 0.8514855078671236}, {0.8796896005664219, 
      0.028007872614665717`, 0.8516817279517566}, {0.8795119372045744, 
      0.027634549314242172`, 0.8518773878903322}, {0.8793345554963314, 
      0.02726207090354836, 0.8520724845927836}, {0.8791574598929919, 
      0.026890444995400175`, 0.8522670148975918}, {0.8789806549281602, 
      0.026519679358737627`, 0.852460975569423}, {0.8788041452203751, 
      0.026149781923717752`, 0.8526543632966576}, {0.8786279354758509, 
      0.025780760787040998`, 0.85284717468881}, {0.8784520304913469, 
      0.025412624217516534`, 0.8530394062738306}, {0.8782764351571627, 
      0.02504538066188241, 0.8532310544952801}, {0.878101154460273, 
      0.02467903875089702, 0.8534221157093761}, {0.8779261934876073, 
      0.024313607305712078`, 0.8536125861818955}, {0.8777515574294847, 
      0.023949095344552866`, 0.8538024620849318}, {0.8775772515832109, 
      0.023585512089716827`, 0.853991739493494}, {0.8774032813568502, 
      0.023222866974913204`, 0.8541804143819369}, {0.8772296522731825, 
      0.022861169652966765`, 0.8543684826202158}, {0.877056369973853, 
      0.02250043000390162, 0.8545559399699517}, {0.8768834402237354, 
      0.022140658143441117`, 0.8547427820802946}, {0.876710868915513, 
      0.02178186443193888, 0.8549290044835741}, {0.8765386620744972, 
      0.021424059483776965`, 0.8551146025907208}, {0.8763668258637, 
      0.02106725417725562, 0.855299571686444}, {0.8761953665891725, 
      0.02071145966502072, 0.8554839069241514}, {0.8760242907056339, 
      0.020356687385046274`, 0.8556676033205879}, {0.8758536048224054, 
      0.020002949072226186`, 0.8558506557501793}, {0.8756833157096748, 
      0.01965025677061785, 0.856033058939057}, {0.8755134303051121, 
      0.019298622846370468`, 0.8562148074587412}, {0.8753439557208644, 
      0.018948060001406936`, 0.856395895719458}, {0.8751748992509545, 
      0.018598581287891235`, 0.8565763179630637}, {0.8750062683791174, 
      0.0182502001235715, 0.8567560682555457}, {0.8748380707871041, 
      0.017902930308034304`, 0.85693514047907}, {0.8746703143634917, 
      0.01755678603995803, 0.8571135283235342}, {0.8745030072130376, 
      0.01721178193544222, 0.8572912252775955}, {0.8743361576666208, 
      0.016867933047495447`, 0.8574682246191259}, {0.8741697742918206, 
      0.016525254886772787`, 0.8576445194050475}, {0.874003865904182, 
      0.016183763443681876`, 0.8578201024605006}, {0.8738384415792264, 
      0.015843475211941915`, 0.8579949663672846}, {0.8736735106652733, 
      0.015504407213763971`, 0.8581691034515091}, {0.8735090827971379, 
      0.015166577026746236`, 0.8583425057703917}, {0.8733451679107905, 
      0.014830002812672098`, 0.8585151650981182}, {0.8731817762590574, 
      0.014494703348372683`, 0.8586870729106851}, {0.8730189184284586, 
      0.014160698058827024`, 0.8588582203696318}, {0.8728566053572985, 
      0.013828007052746814`, 0.8590285983045516}, {0.8726948483551134, 
      0.01349665116084108, 0.8591981971942728}, {0.8725336591236258, 
      0.013166651977057037`, 0.8593670071465692}, {0.8723730497793409, 
      0.012838031903078615`, 0.8595350178762627}, {0.8722130328779611, 
      0.012510814196415313`, 0.8597022186815455}, {0.8720536214408032, 
      0.012185023022462382`, 0.8598685984183413}, {0.8718948289834331, 
      0.011860683510938686`, 0.8600341454724945}, {0.8717366695467578, 
      0.011537821817210234`, 0.8601988477295477}, {0.8715791577308476, 
      0.011216465189004364`, 0.860362692541843}, {0.8714223087318035, 
      0.01089664203916865, 0.860525666692635}, {0.8712661383820128, 
      0.010578382025141584`, 0.8606877563568714}, {0.8711106631942175, 
      0.010261716135980545`, 0.860848947058237}, {0.8709559004098408, 
      0.009946676787839238, 0.8610092236220016}, {0.870801868052126, 
      0.009633297928982583, 0.8611685701231435}, {0.8706485849846972, 
      0.009321615155564298, 0.8613269698291329}, {0.8704960709762679, 
      0.009011665839602013, 0.8614844051366661}, {0.8703443467723374, 
      0.008703489270821875, 0.8616408575015151}, {0.8701934341748507, 
      0.008397126814321315, 0.8617963073605295}, {0.870043356130988, 
      0.008092622086347194, 0.8619507340446406}, {0.8698941368324359, 
      0.007790021150912939, 0.8621041156815226}, {0.8697458018267622, 
      0.007489372740450283, 0.8622564290863116}, {0.8695983781428259, 
      0.0071907285043596135`, 0.8624076496384662}, {0.8694518944325305, 
      0.00689414329004588, 0.8625577511424846}, {0.8693063811317154, 
      0.006599675462009809, 0.8627067056697061}, {0.8691618706435771, 
      0.006307387265738311, 0.8628544833778392}, {0.8690183975487538, 
      0.00601734524464255, 0.8630010523041111}, {0.8688759988471857, 
      0.005729620720215039, 0.863146378126971}, {0.8687347142380748, 
      0.005444290348004528, 0.8632904238900703}, {0.8685945864458662, 
      0.005161436765213282, 0.8634331496806534}, {0.8684556616022533, 
      0.004881149349826549, 0.8635745122524271}, {0.868317989696969, 
      0.004603525116739077, 0.8637144645802303}, {0.8681816251138063, 
      0.004328669783644371, 0.863852955330162}, {0.8680466272733193, 
      0.004056699049478559, 0.8639899282238408}, {0.8679130614105532, 
      0.0037877401419432926`, 0.86412532126861}, {0.8677809995257941, 
      0.0035219337099028796`, 0.8642590658158911}, {0.8676505215600527, 
      0.0032594361638284696`, 0.8643910853962243}, {0.8675217168669641, 
      0.0030004226073186407`, 0.8645212942596455}, {0.8673946860823909, 
      0.0027450905618481587`, 0.8646495955205428}, {0.8672695435381301, 
      0.002493664776965896, 0.8647758787611641}, {0.8671464204367443, 
      0.0022464035591922096`, 0.8649000168775525}, {0.8670254691188409, 
      0.0020036072811668868`, 0.8650218618376745}, {0.8669068689461715, 
      0.0017656301162112748`, 0.8651412388299603}, {0.86679083466135, 
      0.0015328967175634043`, 0.8652579379437866}, {0.8666776287102181, 
      0.0013059268107403752`, 0.8653717018994778}, {0.8665675802491154, 
      0.0010853731377590099`, 0.8654822071113565}, {0.866461116210531, 
      0.0008720834902763397, 0.8655890327202551}, {0.866358816117157, 
      0.0006672101935256958, 0.8656916059236313}, {0.8662615196974638, 
      0.00047242511036060065`, 0.8657890945871032}, {0.8661705752345571, 
      0.0002904159420505451, 0.865880159292507}, {0.86608860191034, 
      0.00012641009046551434`, 0.8659621918198749}, {0.8660254037844387, 
      1.2246467991473532`*^-16, 0.8660254037844388}, {
      0.8664715833333334, Rational[1, 300], 0.8664715833333334}, {
      0.8669181666666667, Rational[1, 150], 0.8669181666666667}, {
      0.86736475, Rational[1, 100], 0.86736475}, {
      0.8678113333333334, Rational[1, 75], 0.8678113333333334}, {
      0.8682579166666667, Rational[1, 60], 0.8682579166666667}, {
      0.8687045, Rational[1, 50], 0.8687045}, {
      0.8691510833333334, Rational[7, 300], 0.8691510833333334}, {
      0.8695976666666667, Rational[2, 75], 0.8695976666666667}, {
      0.8700442500000001, Rational[3, 100], 0.8700442500000001}, {
      0.8704908333333333, Rational[1, 30], 0.8704908333333333}, {
      0.8709374166666667, Rational[11, 300], 0.8709374166666667}, {
      0.871384, Rational[1, 25], 0.871384}, {
      0.8718305833333334, Rational[13, 300], 0.8718305833333334}, {
      0.8722771666666667, Rational[7, 150], 0.8722771666666667}, {
      0.87272375, Rational[1, 20], 0.87272375}, {
      0.8731703333333334, Rational[4, 75], 0.8731703333333334}, {
      0.8736169166666667, Rational[17, 300], 0.8736169166666667}, {
      0.8740635, Rational[3, 50], 0.8740635}, {
      0.8745100833333334, Rational[19, 300], 0.8745100833333334}, {
      0.8749566666666667, Rational[1, 15], 0.8749566666666667}, {
      0.8754032500000001, Rational[7, 100], 0.8754032500000001}, {
      0.8758498333333333, Rational[11, 150], 0.8758498333333333}, {
      0.8762964166666667, Rational[23, 300], 0.8762964166666667}, {
      0.876743, Rational[2, 25], 0.876743}, {
      0.8771895833333334, Rational[1, 12], 0.8771895833333334}, {
      0.8776361666666667, Rational[13, 150], 0.8776361666666667}, {
      0.87808275, Rational[9, 100], 0.87808275}, {
      0.8785293333333334, Rational[7, 75], 0.8785293333333334}, {
      0.8789759166666667, Rational[29, 300], 0.8789759166666667}, {
      0.8794225, Rational[1, 10], 0.8794225}, {
      0.8798690833333334, Rational[31, 300], 0.8798690833333334}, {
      0.8803156666666667, Rational[8, 75], 0.8803156666666667}, {
      0.8807622500000001, Rational[11, 100], 0.8807622500000001}, {
      0.8812088333333333, Rational[17, 150], 0.8812088333333333}, {
      0.8816554166666667, Rational[7, 60], 0.8816554166666667}, {
      0.882102, Rational[3, 25], 0.882102}, {
      0.8825485833333334, Rational[37, 300], 0.8825485833333334}, {
      0.8829951666666667, Rational[19, 150], 0.8829951666666667}, {
      0.88344175, Rational[13, 100], 0.88344175}, {
      0.8838883333333334, Rational[2, 15], 0.8838883333333334}, {
      0.8843349166666667, Rational[41, 300], 0.8843349166666667}, {
      0.8847815, Rational[7, 50], 0.8847815}, {
      0.8852280833333334, Rational[43, 300], 0.8852280833333334}, {
      0.8856746666666667, Rational[11, 75], 0.8856746666666667}, {
      0.8861212500000001, Rational[3, 20], 0.8861212500000001}, {
      0.8865678333333333, Rational[23, 150], 0.8865678333333333}, {
      0.8870144166666667, Rational[47, 300], 0.8870144166666667}, {
      0.887461, Rational[4, 25], 0.887461}, {
      0.8879075833333334, Rational[49, 300], 0.8879075833333334}, {
      0.8883541666666667, Rational[1, 6], 0.8883541666666667}, {
      0.88880075, Rational[17, 100], 0.88880075}, {
      0.8892473333333334, Rational[13, 75], 0.8892473333333334}, {
      0.8896939166666668, Rational[53, 300], 0.8896939166666668}, {
      0.8901405, Rational[9, 50], 0.8901405}, {
      0.8905870833333334, Rational[11, 60], 0.8905870833333334}, {
      0.8910336666666667, Rational[14, 75], 0.8910336666666667}, {
      0.8914802500000001, Rational[19, 100], 0.8914802500000001}, {
      0.8919268333333333, Rational[29, 150], 0.8919268333333333}, {
      0.8923734166666667, Rational[59, 300], 0.8923734166666667}, {
      0.8928200000000001, Rational[1, 5], 0.8928200000000001}, {
      0.8932665833333334, Rational[61, 300], 0.8932665833333334}, {
      0.8937131666666667, Rational[31, 150], 0.8937131666666667}, {
      0.89415975, Rational[21, 100], 0.89415975}, {
      0.8946063333333334, Rational[16, 75], 0.8946063333333334}, {
      0.8950529166666668, Rational[13, 60], 0.8950529166666668}, {
      0.8954995, Rational[11, 50], 0.8954995}, {
      0.8959460833333334, Rational[67, 300], 0.8959460833333334}, {
      0.8963926666666667, Rational[17, 75], 0.8963926666666667}, {
      0.8968392500000001, Rational[23, 100], 0.8968392500000001}, {
      0.8972858333333333, Rational[7, 30], 0.8972858333333333}, {
      0.8977324166666667, Rational[71, 300], 0.8977324166666667}, {
      0.8981790000000001, Rational[6, 25], 0.8981790000000001}, {
      0.8986255833333334, Rational[73, 300], 0.8986255833333334}, {
      0.8990721666666667, Rational[37, 150], 0.8990721666666667}, {
      0.89951875, Rational[1, 4], 0.89951875}, {
      0.8999653333333334, Rational[19, 75], 0.8999653333333334}, {
      0.9004119166666666, Rational[77, 300], 0.9004119166666666}, {
      0.9008585, Rational[13, 50], 0.9008585}, {
      0.9013050833333334, Rational[79, 300], 0.9013050833333334}, {
      0.9017516666666667, Rational[4, 15], 0.9017516666666667}, {
      0.9021982500000001, Rational[27, 100], 0.9021982500000001}, {
      0.9026448333333333, Rational[41, 150], 0.9026448333333333}, {
      0.9030914166666667, Rational[83, 300], 0.9030914166666667}, {
      0.9035380000000001, Rational[7, 25], 0.9035380000000001}, {
      0.9039845833333333, Rational[17, 60], 0.9039845833333333}, {
      0.9044311666666667, Rational[43, 150], 0.9044311666666667}, {
      0.90487775, Rational[29, 100], 0.90487775}, {
      0.9053243333333334, Rational[22, 75], 0.9053243333333334}, {
      0.9057709166666668, Rational[89, 300], 0.9057709166666668}, {
      0.9062175, Rational[3, 10], 0.9062175}, {
      0.9066640833333334, Rational[91, 300], 0.9066640833333334}, {
      0.9071106666666667, Rational[23, 75], 0.9071106666666667}, {
      0.90755725, Rational[31, 100], 0.90755725}, {
      0.9080038333333333, Rational[47, 150], 0.9080038333333333}, {
      0.9084504166666667, Rational[19, 60], 0.9084504166666667}, {
      0.9088970000000001, Rational[8, 25], 0.9088970000000001}, {
      0.9093435833333333, Rational[97, 300], 0.9093435833333333}, {
      0.9097901666666667, Rational[49, 150], 0.9097901666666667}, {
      0.91023675, Rational[33, 100], 0.91023675}, {
      0.9106833333333334, Rational[1, 3], 0.9106833333333334}, {
      0.9111299166666667, Rational[101, 300], 0.9111299166666667}, {
      0.9115765, Rational[17, 50], 0.9115765}, {
      0.9120230833333334, Rational[103, 300], 0.9120230833333334}, {
      0.9124696666666667, Rational[26, 75], 0.9124696666666667}, {
      0.91291625, Rational[7, 20], 0.91291625}, {
      0.9133628333333333, Rational[53, 150], 0.9133628333333333}, {
      0.9138094166666667, Rational[107, 300], 0.9138094166666667}, {
      0.9142560000000001, Rational[9, 25], 0.9142560000000001}, {
      0.9147025833333333, Rational[109, 300], 0.9147025833333333}, {
      0.9151491666666667, Rational[11, 30], 0.9151491666666667}, {
      0.91559575, Rational[37, 100], 0.91559575}, {
      0.9160423333333334, Rational[28, 75], 0.9160423333333334}, {
      0.9164889166666667, Rational[113, 300], 0.9164889166666667}, {
      0.9169355, Rational[19, 50], 0.9169355}, {
      0.9173820833333334, Rational[23, 60], 0.9173820833333334}, {
      0.9178286666666667, Rational[29, 75], 0.9178286666666667}, {
      0.91827525, Rational[39, 100], 0.91827525}, {
      0.9187218333333333, Rational[59, 150], 0.9187218333333333}, {
      0.9191684166666667, Rational[119, 300], 0.9191684166666667}, {
      0.9196150000000001, Rational[2, 5], 0.9196150000000001}, {
      0.9200615833333333, Rational[121, 300], 0.9200615833333333}, {
      0.9205081666666667, Rational[61, 150], 0.9205081666666667}, {
      0.92095475, Rational[41, 100], 0.92095475}, {
      0.9214013333333334, Rational[31, 75], 0.9214013333333334}, {
      0.9218479166666667, Rational[5, 12], 0.9218479166666667}, {
      0.9222945, Rational[21, 50], 0.9222945}, {
      0.9227410833333334, Rational[127, 300], 0.9227410833333334}, {
      0.9231876666666667, Rational[32, 75], 0.9231876666666667}, {
      0.92363425, Rational[43, 100], 0.92363425}, {
      0.9240808333333334, Rational[13, 30], 0.9240808333333334}, {
      0.9245274166666667, Rational[131, 300], 0.9245274166666667}, {
      0.9249740000000001, Rational[11, 25], 0.9249740000000001}, {
      0.9254205833333333, Rational[133, 300], 0.9254205833333333}, {
      0.9258671666666667, Rational[67, 150], 0.9258671666666667}, {
      0.92631375, Rational[9, 20], 0.92631375}, {
      0.9267603333333334, Rational[34, 75], 0.9267603333333334}, {
      0.9272069166666667, Rational[137, 300], 0.9272069166666667}, {
      0.9276535, Rational[23, 50], 0.9276535}, {
      0.9281000833333334, Rational[139, 300], 0.9281000833333334}, {
      0.9285466666666667, Rational[7, 15], 0.9285466666666667}, {
      0.92899325, Rational[47, 100], 0.92899325}, {
      0.9294398333333334, Rational[71, 150], 0.9294398333333334}, {
      0.9298864166666667, Rational[143, 300], 0.9298864166666667}, {
      0.9303330000000001, Rational[12, 25], 0.9303330000000001}, {
      0.9307795833333333, Rational[29, 60], 0.9307795833333333}, {
      0.9312261666666667, Rational[73, 150], 0.9312261666666667}, {
      0.93167275, Rational[49, 100], 0.93167275}, {
      0.9321193333333334, Rational[37, 75], 0.9321193333333334}, {
      0.9325659166666667, Rational[149, 300], 0.9325659166666667}, {
      0.9330125, Rational[1, 2], 0.9330125}, {
      0.9334590833333334, Rational[151, 300], 0.9334590833333334}, {
      0.9339056666666667, Rational[38, 75], 0.9339056666666667}, {
      0.93435225, Rational[51, 100], 0.93435225}, {
      0.9347988333333334, Rational[77, 150], 0.9347988333333334}, {
      0.9352454166666667, Rational[31, 60], 0.9352454166666667}, {
      0.935692, Rational[13, 25], 0.935692}, {
      0.9361385833333333, Rational[157, 300], 0.9361385833333333}, {
      0.9365851666666667, Rational[79, 150], 0.9365851666666667}, {
      0.93703175, Rational[53, 100], 0.93703175}, {
      0.9374783333333334, Rational[8, 15], 0.9374783333333334}, {
      0.9379249166666667, Rational[161, 300], 0.9379249166666667}, {
      0.9383715, Rational[27, 50], 0.9383715}, {
      0.9388180833333334, Rational[163, 300], 0.9388180833333334}, {
      0.9392646666666666, Rational[41, 75], 0.9392646666666666}, {
      0.93971125, Rational[11, 20], 0.93971125}, {
      0.9401578333333334, Rational[83, 150], 0.9401578333333334}, {
      0.9406044166666667, Rational[167, 300], 0.9406044166666667}, {
      0.9410510000000001, Rational[14, 25], 0.9410510000000001}, {
      0.9414975833333333, Rational[169, 300], 0.9414975833333333}, {
      0.9419441666666667, Rational[17, 30], 0.9419441666666667}, {
      0.94239075, Rational[57, 100], 0.94239075}, {
      0.9428373333333333, Rational[43, 75], 0.9428373333333333}, {
      0.9432839166666667, Rational[173, 300], 0.9432839166666667}, {
      0.9437305, Rational[29, 50], 0.9437305}, {
      0.9441770833333334, Rational[7, 12], 0.9441770833333334}, {
      0.9446236666666668, Rational[44, 75], 0.9446236666666668}, {
      0.94507025, Rational[59, 100], 0.94507025}, {
      0.9455168333333334, Rational[89, 150], 0.9455168333333334}, {
      0.9459634166666667, Rational[179, 300], 0.9459634166666667}, {
      0.94641, Rational[3, 5], 0.94641}, {
      0.9468565833333333, Rational[181, 300], 0.9468565833333333}, {
      0.9473031666666667, Rational[91, 150], 0.9473031666666667}, {
      0.9477497500000001, Rational[61, 100], 0.9477497500000001}, {
      0.9481963333333334, Rational[46, 75], 0.9481963333333334}, {
      0.9486429166666667, Rational[37, 60], 0.9486429166666667}, {
      0.9490895, Rational[31, 50], 0.9490895}, {
      0.9495360833333334, Rational[187, 300], 0.9495360833333334}, {
      0.9499826666666666, Rational[47, 75], 0.9499826666666666}, {
      0.95042925, Rational[63, 100], 0.95042925}, {
      0.9508758333333334, Rational[19, 30], 0.9508758333333334}, {
      0.9513224166666667, Rational[191, 300], 0.9513224166666667}, {
      0.9517690000000001, Rational[16, 25], 0.9517690000000001}, {
      0.9522155833333333, Rational[193, 300], 0.9522155833333333}, {
      0.9526621666666667, Rational[97, 150], 0.9526621666666667}, {
      0.9531087500000001, Rational[13, 20], 0.9531087500000001}, {
      0.9535553333333333, Rational[49, 75], 0.9535553333333333}, {
      0.9540019166666667, Rational[197, 300], 0.9540019166666667}, {
      0.9544485, Rational[33, 50], 0.9544485}, {
      0.9548950833333334, Rational[199, 300], 0.9548950833333334}, {
      0.9553416666666666, Rational[2, 3], 0.9553416666666666}, {
      0.95578825, Rational[67, 100], 0.95578825}, {
      0.9562348333333334, Rational[101, 150], 0.9562348333333334}, {
      0.9566814166666667, Rational[203, 300], 0.9566814166666667}, {
      0.957128, Rational[17, 25], 0.957128}, {
      0.9575745833333333, Rational[41, 60], 0.9575745833333333}, {
      0.9580211666666667, Rational[103, 150], 0.9580211666666667}, {
      0.9584677500000001, Rational[69, 100], 0.9584677500000001}, {
      0.9589143333333333, Rational[52, 75], 0.9589143333333333}, {
      0.9593609166666667, Rational[209, 300], 0.9593609166666667}, {
      0.9598075, Rational[7, 10], 0.9598075}, {
      0.9602540833333334, Rational[211, 300], 0.9602540833333334}, {
      0.9607006666666666, Rational[53, 75], 0.9607006666666666}, {
      0.96114725, Rational[71, 100], 0.96114725}, {
      0.9615938333333334, Rational[107, 150], 0.9615938333333334}, {
      0.9620404166666667, Rational[43, 60], 0.9620404166666667}, {
      0.962487, Rational[18, 25], 0.962487}, {
      0.9629335833333333, Rational[217, 300], 0.9629335833333333}, {
      0.9633801666666667, Rational[109, 150], 0.9633801666666667}, {
      0.9638267500000001, Rational[73, 100], 0.9638267500000001}, {
      0.9642733333333333, Rational[11, 15], 0.9642733333333333}, {
      0.9647199166666667, Rational[221, 300], 0.9647199166666667}, {
      0.9651665, Rational[37, 50], 0.9651665}, {
      0.9656130833333334, Rational[223, 300], 0.9656130833333334}, {
      0.9660596666666666, Rational[56, 75], 0.9660596666666666}, {
      0.96650625, Rational[3, 4], 0.96650625}, {
      0.9669528333333334, Rational[113, 150], 0.9669528333333334}, {
      0.9673994166666667, Rational[227, 300], 0.9673994166666667}, {
      0.967846, Rational[19, 25], 0.967846}, {
      0.9682925833333333, Rational[229, 300], 0.9682925833333333}, {
      0.9687391666666667, Rational[23, 30], 0.9687391666666667}, {
      0.9691857500000001, Rational[77, 100], 0.9691857500000001}, {
      0.9696323333333333, Rational[58, 75], 0.9696323333333333}, {
      0.9700789166666667, Rational[233, 300], 0.9700789166666667}, {
      0.9705255, Rational[39, 50], 0.9705255}, {
      0.9709720833333333, Rational[47, 60], 0.9709720833333333}, {
      0.9714186666666667, Rational[59, 75], 0.9714186666666667}, {
      0.97186525, Rational[79, 100], 0.97186525}, {
      0.9723118333333334, Rational[119, 150], 0.9723118333333334}, {
      0.9727584166666667, Rational[239, 300], 0.9727584166666667}, {
      0.973205, Rational[4, 5], 0.973205}, {
      0.9736515833333333, Rational[241, 300], 0.9736515833333333}, {
      0.9740981666666667, Rational[121, 150], 0.9740981666666667}, {
      0.97454475, Rational[81, 100], 0.97454475}, {
      0.9749913333333333, Rational[61, 75], 0.9749913333333333}, {
      0.9754379166666667, Rational[49, 60], 0.9754379166666667}, {
      0.9758845, Rational[41, 50], 0.9758845}, {
      0.9763310833333334, Rational[247, 300], 0.9763310833333334}, {
      0.9767776666666667, Rational[62, 75], 0.9767776666666667}, {
      0.97722425, Rational[83, 100], 0.97722425}, {
      0.9776708333333334, Rational[5, 6], 0.9776708333333334}, {
      0.9781174166666666, Rational[251, 300], 0.9781174166666666}, {
      0.978564, Rational[21, 25], 0.978564}, {
      0.9790105833333334, Rational[253, 300], 0.9790105833333334}, {
      0.9794571666666667, Rational[127, 150], 0.9794571666666667}, {
      0.9799037500000001, Rational[17, 20], 0.9799037500000001}, {
      0.9803503333333333, Rational[64, 75], 0.9803503333333333}, {
      0.9807969166666667, Rational[257, 300], 0.9807969166666667}, {
      0.9812435, Rational[43, 50], 0.9812435}, {
      0.9816900833333333, Rational[259, 300], 0.9816900833333333}, {
      0.9821366666666667, Rational[13, 15], 0.9821366666666667}, {
      0.98258325, Rational[87, 100], 0.98258325}, {
      0.9830298333333334, Rational[131, 150], 0.9830298333333334}, {
      0.9834764166666667, Rational[263, 300], 0.9834764166666667}, {
      0.983923, Rational[22, 25], 0.983923}, {
      0.9843695833333334, Rational[53, 60], 0.9843695833333334}, {
      0.9848161666666667, Rational[133, 150], 0.9848161666666667}, {
      0.98526275, Rational[89, 100], 0.98526275}, {
      0.9857093333333333, Rational[67, 75], 0.9857093333333333}, {
      0.9861559166666667, Rational[269, 300], 0.9861559166666667}, {
      0.9866025, Rational[9, 10], 0.9866025}, {
      0.9870490833333334, Rational[271, 300], 0.9870490833333334}, {
      0.9874956666666667, Rational[68, 75], 0.9874956666666667}, {
      0.98794225, Rational[91, 100], 0.98794225}, {
      0.9883888333333334, Rational[137, 150], 0.9883888333333334}, {
      0.9888354166666666, Rational[11, 12], 0.9888354166666666}, {
      0.989282, Rational[23, 25], 0.989282}, {
      0.9897285833333334, Rational[277, 300], 0.9897285833333334}, {
      0.9901751666666667, Rational[139, 150], 0.9901751666666667}, {
      0.99062175, Rational[93, 100], 0.99062175}, {
      0.9910683333333333, Rational[14, 15], 0.9910683333333333}, {
      0.9915149166666667, Rational[281, 300], 0.9915149166666667}, {
      0.9919615, Rational[47, 50], 0.9919615}, {
      0.9924080833333333, Rational[283, 300], 0.9924080833333333}, {
      0.9928546666666667, Rational[71, 75], 0.9928546666666667}, {
      0.99330125, Rational[19, 20], 0.99330125}, {
      0.9937478333333334, Rational[143, 150], 0.9937478333333334}, {
      0.9941944166666667, Rational[287, 300], 0.9941944166666667}, {
      0.994641, Rational[24, 25], 0.994641}, {
      0.9950875833333334, Rational[289, 300], 0.9950875833333334}, {
      0.9955341666666667, Rational[29, 30], 0.9955341666666667}, {
      0.99598075, Rational[97, 100], 0.99598075}, {
      0.9964273333333333, Rational[73, 75], 0.9964273333333333}, {
      0.9968739166666667, Rational[293, 300], 0.9968739166666667}, {
      0.9973205, Rational[49, 50], 0.9973205}, {
      0.9977670833333334, Rational[59, 60], 0.9977670833333334}, {
      0.9982136666666667, Rational[74, 75], 0.9982136666666667}, {
      0.99866025, Rational[99, 100], 0.99866025}, {
      0.9991068333333334, Rational[149, 150], 0.9991068333333334}, {
      0.9995534166666666, Rational[299, 300], 0.9995534166666666}, {
      1., 1, 1.}}}, {{{0, 0, 0}, {0, 0.00125, 0.07066647012551285}, {
      0, 0.0025, 0.09987492177719089}, {0, 0.00375, 0.1222446317839765}, {
      0, 0.005, 0.14106735979665885`}, {0, 0.00625, 0.15761900266148116`}, {
      0, 0.0075, 0.17255433926737396`}, {0, 0.00875, 0.18626258346753383`}, {
      0, 0.01, 0.19899748742132398`}, {0, 0.01125, 0.2109354166563785}, {
      0, 0.0125, 0.22220486043288973`}, {0, 0.01375, 0.23290287675337976`}, {
      0, 0.015, 0.24310491562286438`}, {0, 0.01625, 0.2528710145508971}, {
      0, 0.0175, 0.26224988083886713`}, {0, 0.01875, 0.2712816801776338}, {
      0, 0.02, 0.28}, {0, 0.02125, 0.28843326784544115`}, {
      0, 0.0225, 0.2966057989992778}, {0, 0.02375, 0.3045385854042144}, {
      0, 0.025, 0.3122498999199199}, {0, 0.02625, 0.31975576617162044`}, {
      0, 0.0275, 0.3270703288285258}, {0, 0.02875, 0.3342061489559999}, {
      0, 0.03, 0.3411744421846396}, {0, 0.03125, 0.34798527267687634`}, {
      0, 0.0325, 0.35464771252610666`}, {0, 0.03375, 0.3611699738350352}, {
      0, 0.035, 0.3675595189897821}, {0, 0.03625, 0.37382315337603156`}, {
      0, 0.0375, 0.37996710383926663`}, {0, 0.03875, 0.38599708548122486`}, {
      0, 0.04, 0.39191835884530846`}, {0, 0.04125, 0.3977357791298137}, {
      0, 0.0425, 0.40345383874738383`}, {0, 0.04375, 0.40907670429883924`}, {
      0, 0.045, 0.4146082488325576}, {0, 0.04625, 0.42005208010436046`}, {
      0, 0.0475, 0.4254115654281157}, {0, 0.04875, 0.4306898536069778}, {
      0, 0.05, 0.43588989435406744`}, {0, 0.05125, 0.4410144555453937}, {
      0, 0.0525, 0.4460661385938189}, {0, 0.05375, 0.4510473921884484}, {
      0, 0.055, 0.4559605246071199}, {0, 0.05625, 0.46080771477916904`}, {
      0, 0.0575, 0.46559102225021476`}, {0, 0.05875, 0.4703123961793905}, {
      0, 0.06, 0.4749736834815167}, {0, 0.06125, 0.47957663621156527`}, {
      0, 0.0625, 0.4841229182759271}, {0, 0.06375, 0.4886141115440691}, {
      0, 0.065, 0.49305172142484205`}, {0, 0.06625, 0.4974371819637129}, {
      0, 0.0675, 0.5017718605103318}, {0, 0.06875, 0.5060570619999291}, {
      0, 0.07, 0.510294032886923}, {0, 0.07125, 0.514483964764695}, {
      0, 0.0725, 0.5186279977016282}, {0, 0.07375, 0.5227272233201558}, {
      0, 0.075, 0.5267826876426369}, {0, 0.07625, 0.5307953937253036}, {
      0, 0.0775, 0.5347663040992766}, {0, 0.07875, 0.538696343035666}, {
      0, 0.08, 0.5425863986500215}, {0, 0.08125, 0.5464373248598599}, {
      0, 0.0825, 0.55024994320763}, {0, 0.08375, 0.5540250445602617}, {
      0, 0.085, 0.5577633906953736}, {0, 0.08625, 0.5614657157832524}, {
      0, 0.0875, 0.5651327277728657}, {0, 0.08875, 0.5687651096894043}, {
      0, 0.09, 0.5723635208501674}, {0, 0.09125, 0.5759285980049957}, {
      0, 0.0925, 0.5794609564069007}, {0, 0.09375, 0.582961190818051}, {
      0, 0.095, 0.58642987645583}, {0, 0.09625, 0.5898675698832747}, {
      0, 0.0975, 0.5932748098478479}, {0, 0.09875, 0.5966521180721643}, {
      0, 0.1, 0.6}, {0, 0.10125, 0.6033189455006365}, {
      0, 0.1025, 0.6066094295343587}, {0, 0.10375, 0.6098719127816922}, {
      0, 0.105, 0.6131068422387732}, {0, 0.10625, 0.6163146517810526}, {
      0, 0.1075, 0.619495762697373}, {0, 0.10875, 0.622650584196305}, {
      0, 0.11, 0.6257795138864806}, {0, 0.11125, 0.6288829382325458}, {
      0, 0.1125, 0.6319612329882269}, {0, 0.11375, 0.6350147636079023}, {
      0, 0.115, 0.6380438856379709}, {0, 0.11625, 0.6410489450892186}, {
      0, 0.1175, 0.6440302787913004}, {0, 0.11875, 0.6469882147303767}, {
      0, 0.12, 0.6499230723708769}, {0, 0.12125, 0.6528351629622903}, {
      0, 0.1225, 0.6557247898318318}, {0, 0.12375, 0.6585922486637692}, {
      0, 0.125, 0.6614378277661477}, {0, 0.12625, 0.6642618083256029}, {
      0, 0.1275, 0.6670644646509061}, {0, 0.12875, 0.6698460644058455}, {
      0, 0.13, 0.6726068688320095}, {0, 0.13125, 0.675347132962005}, {
      0, 0.1325, 0.6780671058236051}, {0, 0.13375, 0.6807670306352974}, {
      0, 0.135, 0.683447144993671}, {0, 0.13625, 0.6861076810530545}, {
      0, 0.1375, 0.6887488656977956}, {0, 0.13875, 0.691370920707546}, {
      0, 0.14, 0.6939740629158989}, {0, 0.14125, 0.6965585043626988}, {
      0, 0.1425, 0.6991244524403363}, {0, 0.14375, 0.7016721100343095}, {
      0, 0.145, 0.7042016756583301}, {0, 0.14625, 0.7067133435842287}, {
      0, 0.1475, 0.7092073039669008}, {0, 0.14875, 0.7116837429645277}, {
      0, 0.15, 0.7141428428542851}, {0, 0.15125, 0.716584782143746}, {
      0, 0.1525, 0.7190097356781756}, {0, 0.15375, 0.7214178747438963}, {
      0, 0.155, 0.7238093671679028}, {0, 0.15625, 0.7261843774138907}, {
      0, 0.1575, 0.7285430666748535}, {0, 0.15875, 0.7308855929624006}, {
      0, 0.16, 0.7332121111929344}, {0, 0.16125, 0.7355227732708213}, {
      0, 0.1625, 0.7378177281686854}, {0, 0.16375, 0.7400971220049434}, {
      0, 0.165, 0.7423610981186985}, {0, 0.16625, 0.7446097971421004}, {
      0, 0.1675, 0.7468433570702762}, {0, 0.16875, 0.7490619133289317}, {
      0, 0.17, 0.751265598839718}, {0, 0.17125, 0.7534545440834504}, {
      0, 0.1725, 0.7556288771612689}, {0, 0.17375, 0.7577887238538193}, {
      0, 0.175, 0.7599342076785333}, {0, 0.17625, 0.7620654499450819}, {
      0, 0.1775, 0.7641825698090738}, {0, 0.17875, 0.7662856843240646}, {
      0, 0.18, 0.7683749084919418}, {0, 0.18125, 0.7704503553117489}, {
      0, 0.1825, 0.7725121358270043}, {0, 0.18375, 0.7745603591715756}, {
      0, 0.185, 0.776595132614157}, {0, 0.18625, 0.7786165616014086}, {
      0, 0.1875, 0.7806247497997998}, {0, 0.18875, 0.7826197991362089}, {
      0, 0.19, 0.7846018098373213}, {0, 0.19125, 0.7865708804678698}, {
      0, 0.1925, 0.7885271079677604}, {0, 0.19375, 0.790470587688119}, {
      0, 0.195, 0.7924014134263012}, {0, 0.19625, 0.7943196774599003}, {
      0, 0.1975, 0.796225470579785}, {0, 0.19875, 0.798118882122206}, {
      0, 0.2, 0.8}, {0, 0.20125, 0.8018689107329202}, {
      0, 0.2025, 0.8037256994771287}, {0, 0.20375, 0.8055704500538734}, {
      0, 0.205, 0.807403244977378}, {0, 0.20625, 0.8092241654819757}, {
      0, 0.2075, 0.8110332915485036}, {0, 0.20875, 0.81283070192999}, {
      0, 0.21, 0.8146164741766521}, {0, 0.21125, 0.8163906846602306}, {
      0, 0.2125, 0.8181534085976785}, {0, 0.21375, 0.8199047200742291}, {
      0, 0.215, 0.8216446920658588}, {0, 0.21625, 0.8233733964611681}, {
      0, 0.2175, 0.8250909040826956}, {0, 0.21875, 0.8267972847076845}, {
      0, 0.22, 0.8284926070883192}, {0, 0.22125, 0.830176938971446}, {
      0, 0.2225, 0.8318503471177974}, {0, 0.22375, 0.8335128973207313}, {
      0, 0.225, 0.8351646544245032}, {0, 0.22625, 0.8368056823420835}, {
      0, 0.2275, 0.8384360440725339}, {0, 0.22875, 0.8400558017179574}, {
      0, 0.23, 0.8416650165000326}, {0, 0.23125, 0.8432637487761465}, {
      0, 0.2325, 0.8448520580551367}, {0, 0.23375, 0.8464300030126531}, {
      0, 0.235, 0.8479976415061542}, {0, 0.23625, 0.8495550305895434}, {
      0, 0.2375, 0.8511022265274601}, {0, 0.23875, 0.8526392848092329}, {
      0, 0.24, 0.854166260162505}, {0, 0.24125, 0.8556832065665424}, {
      0, 0.2425, 0.8571901772652321}, {0, 0.24375, 0.8586872247797799}, {
      0, 0.245, 0.8601744009211156}, {0, 0.24625, 0.8616517568020157}, {
      0, 0.2475, 0.8631193428489481}, {0, 0.24875, 0.864577208813649}, {
      0, 0.25, 0.8660254037844386}, {0, 0.25125, 0.8674639761972829}, {
      0, 0.2525, 0.8688929738466068}, {0, 0.25375, 0.8703124438958689}, {
      0, 0.255, 0.8717224328879004}, {0, 0.25625, 0.8731229867550161}, {
      0, 0.2575, 0.8745141508289045}, {0, 0.25875, 0.8758959698503013}, {
      0, 0.26, 0.8772684879784524}, {0, 0.26125, 0.8786317488003721}, {
      0, 0.2625, 0.8799857953399022}, {0, 0.26375, 0.8813306700665762}, {
      0, 0.265, 0.8826664149042945}, {0, 0.26625, 0.8839930712398146}, {
      0, 0.2675, 0.8853106799310624}, {0, 0.26875, 0.8866192813152667}, {
      0, 0.27, 0.8879189152169245}, {0, 0.27125, 0.8892096209555991}, {
      0, 0.2725, 0.8904914373535548}, {0, 0.27375, 0.8917644027432359}, {
      0, 0.275, 0.8930285549745876}, {0, 0.27625, 0.8942839314222302}, {
      0, 0.2775, 0.8955305689924828}, {0, 0.27875, 0.8967685041302466}, {
      0, 0.28, 0.8979977728257459}, {0, 0.28125, 0.8992184106211348}, {
      0, 0.2825, 0.9004304526169692}, {0, 0.28375, 0.9016339334785487}, {
      0, 0.285, 0.9028288874421333}, {0, 0.28625, 0.9040153483210338}, {
      0, 0.2875, 0.9051933495115837}, {0, 0.28875, 0.9063629239989907}, {
      0, 0.29, 0.9075241043630742}, {0, 0.29125, 0.9086769227838901}, {
      0, 0.2925, 0.9098214110472449}, {0, 0.29375, 0.9109576005501024}, {
      0, 0.295, 0.9120855223058856}, {0, 0.29625, 0.9132052069496757}, {
      0, 0.2975, 0.9143166847433115}, {0, 0.29875, 0.9154199855803893}, {
      0, 0.3, 0.916515138991168}, {0, 0.30125, 0.9176021741473807}, {
      0, 0.3025, 0.9186811198669536}, {0, 0.30375, 0.9197520046186363}, {
      0, 0.305, 0.920814856526544}, {0, 0.30625, 0.9218697033746145}, {
      0, 0.3075, 0.9229165726109809}, {0, 0.30875, 0.9239554913522621}, {
      0, 0.31, 0.9249864863877743}, {0, 0.31125, 0.9260095841836627}, {
      0, 0.3125, 0.9270248108869579}, {0, 0.31375, 0.9280321923295549}, {
      0, 0.315, 0.9290317540321213}, {0, 0.31625, 0.9300235212079316}, {
      0, 0.3175, 0.9310075187666317}, {0, 0.31875, 0.9319837713179345}, {
      0, 0.32, 0.9329523031752481}, {0, 0.32125, 0.9339131383592374}, {
      0, 0.3225, 0.9348663006013213}, {0, 0.32375, 0.9358118133471066}, {
      0, 0.325, 0.9367496997597597}, {0, 0.32625, 0.9376799827233169}, {
      0, 0.3275, 0.9386026848459363}, {0, 0.32875, 0.9395178284630898}, {
      0, 0.33, 0.9404254356406998}, {0, 0.33125, 0.9413255281782175}, {
      0, 0.3325, 0.9422181276116481}, {0, 0.33375, 0.9431032552165219}, {
      0, 0.335, 0.9439809320108115}, {0, 0.33625, 0.9448511787577978}, {
      0, 0.3375, 0.9457140159688868}, {0, 0.33875, 0.946569463906374}, {
      0, 0.34, 0.9474175425861608}, {0, 0.34125, 0.9482582717804259}, {
      0, 0.3425, 0.9490916710202446}, {0, 0.34375, 0.9499177595981665}, {
      0, 0.345, 0.9507365565707464}, {0, 0.34625, 0.9515480807610303}, {
      0, 0.3475, 0.9523523507609986}, {0, 0.34875, 0.9531493849339672}, {
      0, 0.35, 0.9539392014169457}, {0, 0.35125, 0.9547218181229546}, {
      0, 0.3525, 0.9554972527433033}, {0, 0.35375, 0.956265522749827}, {
      0, 0.355, 0.957026645397086}, {0, 0.35625, 0.9577806377245262}, {
      0, 0.3575, 0.9585275165586015}, {0, 0.35875, 0.9592672985148613}, {
      0, 0.36, 0.96}, {0, 0.36125, 0.9607256372138718}, {
      0, 0.3625, 0.9614442261514706}, {0, 0.36375, 0.9621557826048753}, {
      0, 0.365, 0.9628603221651623}, {0, 0.36625, 0.9635578602242836}, {
      0, 0.3675, 0.9642484119769138}, {0, 0.36875, 0.964931992422264}, {
      0, 0.37, 0.9656086163658648}, {0, 0.37125, 0.9662782984213192}, {
      0, 0.3725, 0.9669410530120232}, {0, 0.37375, 0.9675968943728581}, {
      0, 0.375, 0.9682458365518543}, {0, 0.37625, 0.9688878934118229}, {
      0, 0.3775, 0.9695230786319633}, {0, 0.37875, 0.9701514057094387}, {
      0, 0.38, 0.9707728879609278}, {0, 0.38125, 0.9713875385241464}, {
      0, 0.3825, 0.9719953703593449}, {0, 0.38375, 0.9725963962507779}, {
      0, 0.385, 0.9731906288081489}, {0, 0.38625, 0.9737780804680294}, {
      0, 0.3875, 0.9743587634952537}, {0, 0.38875, 0.9749326899842881}, {
      0, 0.39, 0.975499871860576}, {0, 0.39125, 0.9760603208818602}, {
      0, 0.3925, 0.9766140486394818}, {0, 0.39375, 0.9771610665596536}, {
      0, 0.395, 0.9777013859047148}, {0, 0.39625, 0.9782350177743588}, {
      0, 0.3975, 0.9787619731068428}, {0, 0.39875, 0.9792822626801733}, {
      0, 0.4, 0.9797958971132712}, {0, 0.40125, 0.9803028868671152}, {
      0, 0.4025, 0.9808032422458645}, {0, 0.40375, 0.9812969733979617}, {
      0, 0.405, 0.9817840903172143}, {0, 0.40625, 0.982264602843857}, {
      0, 0.4075, 0.982738520665594}, {0, 0.40875, 0.9832058533186222}, {
      0, 0.41, 0.983666610188635}, {0, 0.41125, 0.9841208005118071}, {
      0, 0.4125, 0.9845684333757609}, {0, 0.41375, 0.9850095177205143}, {
      0, 0.415, 0.9854440623394105}, {0, 0.41625, 0.9858720758800301}, {
      0, 0.4175, 0.986293566845085}, {0, 0.41875, 0.9867085435932943}, {
      0, 0.42, 0.9871170143402453}, {0, 0.42125, 0.9875189871592344}, {
      0, 0.4225, 0.9879144699820932}, {0, 0.42375, 0.9883034705999975}, {
      0, 0.425, 0.9886859966642595}, {0, 0.42625, 0.9890620556871039}, {
      0, 0.4275, 0.9894316550424289}, {0, 0.42875, 0.9897948019665491}, {
      0, 0.43, 0.990151503558925}, {0, 0.43125, 0.9905017667828766}, {
      0, 0.4325, 0.9908455984662797}, {0, 0.43375, 0.9911830053022499}, {
      0, 0.435, 0.9915139938498095}, {0, 0.43625, 0.9918385705345402}, {
      0, 0.4375, 0.9921567416492215}, {0, 0.43875, 0.9924685133544541}, {
      0, 0.44, 0.9927738916792685}, {0, 0.44125, 0.993072882521721}, {
      0, 0.4425, 0.9933654916494734}, {0, 0.44375, 0.99365172470036}, {
      0, 0.445, 0.993931587182941}, {0, 0.44625, 0.9942050844770409}, {
      0, 0.4475, 0.9944722218342753}, {0, 0.44875, 0.9947330043785618}, {
      0, 0.45, 0.9949874371066199}, {0, 0.45125, 0.9952355248884558}, {
      0, 0.4525, 0.995477272467835}, {0, 0.45375, 0.995712684462742}, {
      0, 0.455, 0.995941765365827}, {0, 0.45625, 0.9961645195448391}, {
      0, 0.4575, 0.9963809512430474}, {0, 0.45875, 0.99659106457965}, {
      0, 0.46, 0.996794863550169}, {0, 0.46125, 0.9969923520268347}, {
      0, 0.4625, 0.9971835337589566}, {0, 0.46375, 0.9973684123732816}, {
      0, 0.465, 0.9975469913743412}, {0, 0.46625, 0.9977192741447867}, {
      0, 0.4675, 0.9978852639457104}, {0, 0.46875, 0.998044963916957}, {
      0, 0.47, 0.9981983770774224}, {0, 0.47125, 0.9983455063253401}, {
      0, 0.4725, 0.998486354438557}, {0, 0.47375, 0.9986209240747962}, {
      0, 0.475, 0.998749217771909}, {0, 0.47625, 0.9988712379481152}, {
      0, 0.4775, 0.9989869869022319}, {0, 0.47875, 0.9990964668138907}, {
      0, 0.48, 0.9991996797437438}, {0, 0.48125, 0.9992966276336571}, {
      0, 0.4825, 0.9993873123068954}, {0, 0.48375, 0.9994717354682923}, {
      0, 0.485, 0.9995498987044118}, {0, 0.48625, 0.9996218034836976}, {
      0, 0.4875, 0.9996874511566104}, {0, 0.48875, 0.9997468429557554}, {
      0, 0.49, 0.9997999799959991}, {0, 0.49125, 0.9998468632745717}, {
      0, 0.4925, 0.999887493671163}, {0, 0.49375, 0.9999218719480037}, {
      0, 0.495, 0.9999499987499374}, {0, 0.49625, 0.999971874604481}, {
      0, 0.4975, 0.999987499921874}, {0, 0.49875, 0.9999968749951172}, {
      0, 0.5, 1}, {0, 0.5030107112554686, 0.9999939449006108}, {
      0, 0.5053601052859211, 0.9999807772438751}, {
      0, 0.5075091287703752, 0.9999622185680237}, {
      0, 0.5095366331194746, 0.9999389779735858}, {
      0, 0.5114776969638323, 0.9999114925178486}, {
      0, 0.5133520853953788, 0.9998800707513334}, {
      0, 0.5151724228995019, 0.9998449473450536}, {
      0, 0.5169474383326078, 0.9998063095068447}, {
      0, 0.5186835084938362, 0.9997643116507248}, {
      0, 0.5203854847967883, 0.9997190843292335}, {
      0, 0.5220571751337896, 0.9996707400456819}, {
      0, 0.5237016432811604, 0.9996193772313285}, {
      0, 0.5253214044819132, 0.9995650830766676}, {
      0, 0.5269185584678272, 0.9995079356124442}, {
      0, 0.5284948829913498, 0.9994480052801225}, {
      0, 0.5300519014518561, 0.999385356143639}, {
      0, 0.5315909329672844, 0.999320046842221}, {
      0, 0.5331131302155144, 0.9992521313519253}, {
      0, 0.534619508547993, 0.9991816596030143}, {
      0, 0.5361109687429949, 0.9991086779867676}, {
      0, 0.5375883150372486, 0.9990332297761686}, {
      0, 0.5390522695943267, 0.9989553554785835}, {
      0, 0.540503484244191, 0.9988750931340687}, {
      0, 0.5419425501050132, 0.9987924785697279}, {
      0, 0.5433700055417787, 0.9987075456181834}, {
      0, 0.5447863428042896, 0.99862032630648}, {
      0, 0.546192013606148, 0.9985308510204207}, {
      0, 0.547587433846693, 0.9984391486483352}, {
      0, 0.5489729876335138, 0.9983452467075059}, {
      0, 0.5503490307297004, 0.9982491714558789}, {
      0, 0.5517158935245917, 0.9981509479912092}, {
      0, 0.5530738836071235, 0.998050600339421}, {
      0, 0.5544232880057427, 0.9979481515336582}, {
      0, 0.5557643751468796, 0.997843623685263}, {
      0, 0.5570973965746097, 0.9977370380477212}, {
      0, 0.5584225884666104, 0.9976284150744555}, {
      0, 0.5597401729755543, 0.997517774471214}, {
      0, 0.5610503594202167, 0.997405135243693}, {
      0, 0.5623533453466495, 0.9972905157409434}, {
      0, 0.5636493174765815, 0.9971739336950337}, {
      0, 0.5649384525575399, 0.9970554062573778}, {
      0, 0.5662209181270422, 0.9969349500320833}, {
      0, 0.5674968732013819, 0.9968125811066331}, {
      0, 0.568766468898031, 0.9966883150801653}, {
      0, 0.5700298489994294, 0.9965621670895977}, {
      0, 0.5712871504648581, 0.9964341518337982}, {
      0, 0.572538503896203, 0.9963042835959935}, {
      0, 0.5737840339626679, 0.9961725762645741}, {
      0, 0.5750238597888176, 0.9960390433524455}, {
      0, 0.576258095309825, 0.9959036980150533}, {
      0, 0.5774868495972767, 0.9957665530671973}, {
      0, 0.5787102271585189, 0.9956276209987409}, {
      0, 0.5799283282121569, 0.9954869139893048}, {
      0, 0.581141248942029, 0.995344443922031}, {
      0, 0.5823490817316908, 0.9952002223964926}, {
      0, 0.5835519153812517, 0.9950542607408154}, {
      0, 0.5847498353081731, 0.9949065700230729}, {
      0, 0.5859429237334736, 0.9947571610620122}, {
      0, 0.5871312598546455, 0.9946060444371586}, {
      0, 0.5883149200064349, 0.9944532304983466}, {
      0, 0.5894939778105217, 0.9942987293747175}, {
      0, 0.5906685043150443, 0.994142550983224}, {
      0, 0.5918385681248077, 0.9939847050366726}, {
      0, 0.5930042355229321, 0.9938252010513405}, {
      0, 0.5941655705846323, 0.9936640483541923}, {
      0, 0.595322635283757, 0.9935012560897245}, {
      0, 0.5964754895926375, 0.993336833226463}, {
      0, 0.5976241915757732, 0.9931707885631357}, {
      0, 0.5987687974778148, 0.9930031307345396}, {
      0, 0.599909361806267, 0.9928338682171256}, {
      0, 0.6010459374093023, 0.9926630093343128}, {
      0, 0.6021785755490422, 0.9924905622615551}, {
      0, 0.6033073259706228, 0.9923165350311689}, {
      0, 0.6044322369673453, 0.9921409355369427}, {
      0, 0.605553355442186, 0.9919637715385354}, {
      0, 0.6066707269659115, 0.9917850506656789}, {
      0, 0.6077843958320296, 0.991604780422196}, {
      0, 0.6088944051087886, 0.9914229681898429}, {
      0, 0.6100007966884143, 0.9912396212319876}, {
      0, 0.6111036113337772, 0.9910547466971309}, {
      0, 0.6122028887226381, 0.990868351622281}, {
      0, 0.6132986674896362, 0.9906804429361892}, {
      0, 0.614390985266163, 0.9904910274624518}, {
      0, 0.6154798787182444, 0.9903001119224878}, {
      0, 0.6165653835825587, 0.9901077029383986}, {
      0, 0.617647534700705, 0.9899138070357131}, {
      0, 0.6187263660518166, 0.9897184306460285}, {
      0, 0.6198019107836347, 0.9895215801095465}, {
      0, 0.6208742012421081, 0.9893232616775162}, {
      0, 0.6219432689996323, 0.9891234815145818}, {
      0, 0.6230091448819781, 0.9889222457010464}, {
      0, 0.624071858994007, 0.9887195602350487}, {
      0, 0.6251314407442218, 0.9885154310346647}, {
      0, 0.626187918868233, 0.9883098639399297}, {
      0, 0.6272413214511889, 0.9881028647147914}, {
      0, 0.6282916759492315, 0.9878944390489923}, {
      0, 0.6293390092100261, 0.9876845925598873}, {
      0, 0.6303833474924172, 0.9874733307941983}, {
      0, 0.6314247164852583, 0.9872606592297088}, {
      0, 0.6324631413254498, 0.9870465832769016}, {
      0, 0.6334986466152337, 0.9868311082805412}, {
      0, 0.6345312564387838, 0.9866142395212035}, {
      0, 0.6355609943781174, 0.9863959822167568}, {
      0, 0.636587883528373, 0.9861763415237923}, {
      0, 0.6376119465124815, 0.9859553225390106}, {
      0, 0.6386332054952527, 0.9857329303005635}, {
      0, 0.6396516821969236, 0.9855091697893524}, {
      0, 0.6406673979061734, 0.9852840459302874}, {
      0, 0.6416803734926485, 0.9850575635935063}, {
      0, 0.6426906294190053, 0.9848297275955569}, {
      0, 0.6436981857525059, 0.9846005427005436}, {
      0, 0.6447030621761795, 0.9843700136212384}, {
      0, 0.6457052779995751, 0.9841381450201588}, {
      0, 0.646704852169116, 0.983904941510615}, {
      0, 0.6477018032780834, 0.983670407657725}, {
      0, 0.648696149576239, 0.9834345479794007}, {
      0, 0.6496879089791071, 0.9831973669473053}, {
      0, 0.6506770990769258, 0.9829588689877842}, {
      0, 0.6516637371432863, 0.9827190584827682}, {
      0, 0.6526478401434738, 0.9824779397706518}, {
      0, 0.6536294247425196, 0.9822355171471474}, {
      0, 0.654608507312978, 0.9819917948661153}, {
      0, 0.6555851039424394, 0.9817467771403714}, {
      0, 0.6565592304407954, 0.9815004681424725}, {
      0, 0.6575309023472551, 0.9812528720054803}, {
      0, 0.6585001349371362, 0.9810039928237054}, {
      0, 0.6594669432284272, 0.980753834653432}, {
      0, 0.6604313419881415, 0.9805024015136216}, {
      0, 0.6613933457384648, 0.9802496973865998}, {
      0, 0.662352968762703, 0.979995726218726}, {
      0, 0.6633102251110441, 0.9797404919210436}, {
      0, 0.6642651286061404, 0.9794839983699152}, {
      0, 0.6652176928485083, 0.9792262494076418}, {
      0, 0.6661679312217701, 0.978967248843065}, {
      0, 0.6671158568977272, 0.9787070004521552}, {
      0, 0.6680614828412808, 0.9784455079785862}, {
      0, 0.669004821815204, 0.9781827751342929}, {
      0, 0.6699458863847677, 0.9779188056000175}, {
      0, 0.6708846889222305, 0.9776536030258429}, {
      0, 0.6718212416111929, 0.9773871710317106}, {
      0, 0.6727555564508254, 0.977119513207929}, {
      0, 0.6736876452599717, 0.976850633115668}, {
      0, 0.674617519681131, 0.9765805342874427}, {
      0, 0.6755451911843294, 0.9763092202275852}, {
      0, 0.6764706710708753, 0.9760366944127057}, {
      0, 0.6773939704770116, 0.9757629602921435}, {
      0, 0.6783151003774636, 0.9754880212884062}, {
      0, 0.6792340715888872, 0.9752118807976004}, {
      0, 0.6801508947732188, 0.9749345421898519}, {
      0, 0.681065580440937, 0.9746560088097165}, {
      0, 0.6819781389542305, 0.9743762839765817}, {
      0, 0.6828885805300802, 0.9740953709850599}, {
      0, 0.6837969152432595, 0.9738132731053719}, {
      0, 0.684703153029252, 0.9735299935837226}, {
      0, 0.6856073036870899, 0.9732455356426695}, {
      0, 0.6865093768821199, 0.9729599024814811}, {
      0, 0.687409382148694, 0.9726730972764893}, {
      0, 0.6883073288927882, 0.9723851231814341}, {
      0, 0.6892032263945567, 0.9720959833278}, {
      0, 0.6900970838108155, 0.9718056808251461}, {
      0, 0.6909889101774646, 0.9715142187614296}, {
      0, 0.6918787144118481, 0.9712216002033214}, {
      0, 0.6927665053150518, 0.9709278281965164}, {
      0, 0.693652291574146, 0.9706329057660364}, {
      0, 0.6945360817643688, 0.9703368359165278}, {
      0, 0.6954178843512564, 0.9700396216325524}, {
      0, 0.696297707692721, 0.9697412658788728}, {
      0, 0.6971755600410757, 0.9694417716007316}, {
      0, 0.6980514495450105, 0.9691411417241258}, {
      0, 0.6989253842515195, 0.9688393791560752}, {
      0, 0.6997973721077829, 0.9685364867848854}, {
      0, 0.7006674209630018, 0.9682324674804057}, {
      0, 0.70153553857019, 0.967927324094283}, {
      0, 0.7024017325879219, 0.9676210594602086}, {
      0, 0.7032660105820403, 0.9673136763941629}, {
      0, 0.7041283800273239, 0.9670051776946526}, {
      0, 0.7049888483091143, 0.9666955661429464}, {
      0, 0.7058474227249062, 0.9663848445033031}, {
      0, 0.7067041104859002, 0.9660730155231981}, {
      0, 0.7075589187185208, 0.9657600819335443}, {
      0, 0.7084118544658985, 0.9654460464489083}, {
      0, 0.7092629246893183, 0.9651309117677244}, {
      0, 0.7101121362696349, 0.9648146805725031}, {
      0, 0.7109594960086582, 0.9644973555300361}, {
      0, 0.7118050106305044, 0.9641789392915987}, {
      0, 0.7126486867829205, 0.9638594344931465}, {
      0, 0.7134905310385757, 0.9635388437555101}, {
      0, 0.7143305498963282, 0.9632171696845861}, {
      0, 0.7151687497824595, 0.9628944148715239}, {
      0, 0.7160051370518876, 0.9625705818929103}, {
      0, 0.7168397179893483, 0.96224567331095}, {
      0, 0.7176724988105551, 0.9619196916736424}, {
      0, 0.7185034856633304, 0.961592639514958}, {
      0, 0.7193326846287167, 0.9612645193550077}, {
      0, 0.7201601017220606, 0.9609353337002123}, {
      0, 0.7209857428940761, 0.9606050850434686}, {
      0, 0.721809614031884, 0.9602737758643108}, {
      0, 0.722631720960031, 0.9599414086290716}, {
      0, 0.7234520694414859, 0.9596079857910388}, {
      0, 0.7242706651786166, 0.95927350979061}, {
      0, 0.7250875138141463, 0.9589379830554449}, {
      0, 0.7259026209320899, 0.9586014080006142}, {
      0, 0.7267159920586722, 0.958263787028747}, {
      0, 0.7275276326632255, 0.9579251225301754}, {
      0, 0.7283375481590711, 0.957585416883076}, {
      0, 0.7291457439043826, 0.9572446724536099}, {
      0, 0.7299522252030304, 0.9569028915960613}, {
      0, 0.7307569973054117, 0.9565600766529713}, {
      0, 0.7315600654092618, 0.9562162299552716}, {
      0, 0.732361434660451, 0.9558713538224157}, {
      0, 0.7331611101537656, 0.9555254505625076}, {
      0, 0.733959096933672, 0.9551785224724283}, {
      0, 0.7347553999950683, 0.9548305718379613}, {
      0, 0.7355500242840206, 0.9544816009339145}, {
      0, 0.7363429746984834, 0.9541316120242417}, {
      0, 0.7371342560890082, 0.9537806073621615}, {
      0, 0.7379238732594382, 0.9534285891902748}, {
      0, 0.738711830967589, 0.9530755597406794}, {
      0, 0.7394981339259165, 0.9527215212350837}, {
      0, 0.7402827868021737, 0.9523664758849194}, {
      0, 0.7410657942200536, 0.95201042589145}, {
      0, 0.7418471607598198, 0.951653373445881}, {
      0, 0.7426268909589273, 0.951295320729465}, {
      0, 0.7434049893126293, 0.9509362699136084}, {
      0, 0.7441814602745757, 0.9505762231599738}, {
      0, 0.7449563082573979, 0.9502151826205826}, {
      0, 0.7457295376332846, 0.9498531504379152}, {
      0, 0.746501152734547, 0.9494901287450103}, {
      0, 0.7472711578541718, 0.9491261196655624}, {
      0, 0.7480395572463682, 0.9487611253140178}, {
      0, 0.7488063551271007, 0.9483951477956694}, {
      0, 0.7495715556746158, 0.9480281892067497}, {
      0, 0.7503351630299563, 0.9476602516345236}, {
      0, 0.7510971812974705, 0.9472913371573779}, {
      0, 0.7518576145453075, 0.9469214478449117}, {
      0, 0.7526164668059078, 0.946550585758024}, {
      0, 0.7533737420764837, 0.946178752949}, {
      0, 0.7541294443194914, 0.9458059514615973}, {
      0, 0.7548835774630939, 0.9454321833311308}, {
      0, 0.7556361454016189, 0.9450574505845539}, {
      0, 0.7563871519960066, 0.9446817552405427}, {
      0, 0.7571366010742472, 0.9443050993095758}, {
      0, 0.7578844964318188, 0.9439274847940136}, {
      0, 0.7586308418321087, 0.9435489136881775}, {
      0, 0.7593756410068335, 0.943169387978428}, {
      0, 0.7601188976564512, 0.9427889096432392}, {
      0, 0.7608606154505642, 0.942407480653277}, {
      0, 0.7616007980283181, 0.9420251029714704}, {
      0, 0.7623394489987909, 0.9416417785530876}, {
      0, 0.7630765719413801, 0.9412575093458067}, {
      0, 0.7638121704061797, 0.9408722972897873}, {
      0, 0.7645462479143511, 0.9404861443177416}, {
      0, 0.7652788079584907, 0.9400990523550032}, {
      0, 0.7660098540029893, 0.9397110233195961}, {
      0, 0.7667393894843857, 0.9393220591223018}, {
      0, 0.7674674178117153, 0.9389321616667272}, {
      0, 0.7681939423668531, 0.9385413328493686}, {
      0, 0.7689189665048505, 0.9381495745596784}, {
      0, 0.7696424935542673, 0.9377568886801289}, {
      0, 0.770364526817498, 0.9373632770862742}, {
      0, 0.7710850695710935, 0.9369687416468152}, {
      0, 0.771804125066077, 0.936573284223659}, {
      0, 0.7725216965282554, 0.9361769066719811}, {
      0, 0.7732377871585256, 0.9357796108402847}, {
      0, 0.7739524001331765, 0.9353813985704605}, {
      0, 0.7746655386041851, 0.9349822716978455}, {
      0, 0.7753772056995091, 0.9345822320512802}, {
      0, 0.7760874045233748, 0.9341812814531663}, {
      0, 0.7767961381565605, 0.9337794217195218}, {
      0, 0.7775034096566747, 0.9333766546600392}, {
      0, 0.778209222058432, 0.9329729820781377}, {
      0, 0.7789135783739224, 0.932568405771019}, {
      0, 0.7796164815928784, 0.9321629275297205}, {
      0, 0.7803179346829373, 0.9317565491391687}, {
      0, 0.7810179405898986, 0.9313492723782307}, {
      0, 0.781716502237981, 0.9309410990197663}, {
      0, 0.7824136225300693, 0.9305320308306791}, {
      0, 0.7831093043479656, 0.9301220695719665}, {
      0, 0.7838035505526287, 0.9297112169987701}, {
      0, 0.784496363984417, 0.9292994748604241}, {
      0, 0.7851877474633225, 0.9288868449005041}, {
      0, 0.7858777037892044, 0.9284733288568754}, {
      0, 0.786566235742018, 0.9280589284617408}, {
      0, 0.7872533460820409, 0.9276436454416855}, {
      0, 0.7879390375500952, 0.9272274815177264}, {
      0, 0.7886233128677679, 0.9268104384053546}, {
      0, 0.7893061747376258, 0.9263925178145833}, {
      0, 0.7899876258434294, 0.9259737214499907}, {
      0, 0.7906676688503427, 0.9255540510107648}, {
      0, 0.7913463064051407, 0.9251335081907469}, {
      0, 0.7920235411364122, 0.9247120946784751}, {
      0, 0.7926993756547631, 0.924289812157226}, {
      0, 0.7933738125530123, 0.9238666623050578}, {
      0, 0.7940468544063899, 0.923442646794851}, {
      0, 0.7947185037727269, 0.9230177672943503}, {
      0, 0.7953887631926486, 0.9225920254662044}, {
      0, 0.7960576351897592, 0.9221654229680077}, {
      0, 0.7967251222708284, 0.9217379614523379}, {
      0, 0.7973912269259728, 0.9213096425667973}, {
      0, 0.798055951628836, 0.92088046795405}, {
      0, 0.7987192988367662, 0.9204504392518617}, {
      0, 0.7993812709909894, 0.9200195580931365}, {
      0, 0.8000418705167847, 0.9195878261059552}, {
      0, 0.8007010998236509, 0.9191552449136121}, {
      0, 0.8013589613054771, 0.9187218161346518}, {
      0, 0.8020154573407071, 0.9182875413829049}, {
      0, 0.8026705902925023, 0.9178524222675253}, {
      0, 0.8033243625089032, 0.9174164603930238}, {
      0, 0.803976776322988, 0.9169796573593049}, {
      0, 0.80462783405303, 0.9165420147617002}, {
      0, 0.8052775380026509, 0.9161035341910041}, {
      0, 0.8059258904609755, 0.9156642172335059}, {
      0, 0.8065728937027798, 0.9152240654710251}, {
      0, 0.8072185499886416, 0.914783080480944}, {
      0, 0.8078628615650861, 0.91434126383624}, {
      0, 0.8085058306647308, 0.913898617105519}, {
      0, 0.8091474595064284, 0.9134551418530469}, {
      0, 0.8097877502954075, 0.9130108396387813}, {
      0, 0.8104267052234119, 0.9125657120184043}, {
      0, 0.8110643264688382, 0.9121197605433519}, {
      0, 0.8117006161968705, 0.9116729867608451}, {
      0, 0.812335576559615, 0.9112253922139216}, {
      0, 0.8129692096962313, 0.9107769784414647}, {
      0, 0.8136015177330636, 0.9103277469782333}, {
      0, 0.8142325027837681, 0.9098776993548924}, {
      0, 0.814862166949442, 0.9094268370980406}, {
      0, 0.8154905123187471, 0.9089751617302408}, {
      0, 0.8161175409680343, 0.9085226747700471}, {
      0, 0.8167432549614663, 0.9080693777320344}, {
      0, 0.8173676563511373, 0.9076152721268261}, {
      0, 0.8179907471771936, 0.9071603594611213}, {
      0, 0.8186125294679496, 0.9067046412377225}, {
      0, 0.8192330052400065, 0.9062481189555629}, {
      0, 0.8198521764983644, 0.9057907941097334}, {
      0, 0.8204700452365375, 0.9053326681915086}, {
      0, 0.8210866134366656, 0.9048737426883736}, {
      0, 0.8217018830696242, 0.9044140190840502}, {
      0, 0.8223158560951344, 0.9039534988585219}, {
      0, 0.8229285344618709, 0.9034921834880599}, {
      0, 0.8235399201075675, 0.9030300744452495}, {
      0, 0.8241500149591234, 0.9025671731990127}, {
      0, 0.8247588209327076, 0.9021034812146348}, {
      0, 0.8253663399338601, 0.9016389999537886}, {
      0, 0.8259725738575949, 0.9011737308745579}, {
      0, 0.8265775245884988, 0.9007076754314627}, {
      0, 0.8271811940008319, 0.900240835075482}, {
      0, 0.8277835839586254, 0.8997732112540777}, {
      0, 0.8283846963157762, 0.8993048054112187}, {
      0, 0.8289845329161455, 0.8988356189874019}, {
      0, 0.829583095593651, 0.8983656534196779}, {
      0, 0.8301803861723615, 0.8978949101416707}, {
      0, 0.8307764064665876, 0.8974233905836027}, {
      0, 0.8313711582809746, 0.8969510961723156}, {
      0, 0.8319646434105915, 0.896478028331292}, {
      0, 0.8325568636410201, 0.8960041884806782}, {
      0, 0.8331478207484427, 0.8955295780373053}, {
      0, 0.8337375164997299, 0.8950541984147103}, {
      0, 0.8343259526525254, 0.8945780510231578}, {
      0, 0.8349131309553315, 0.8941011372696606}, {
      0, 0.8354990531475933, 0.8936234585580001}, {
      0, 0.8360837209597807, 0.893145016288748}, {
      0, 0.8366671361134714, 0.8926658118592852}, {
      0, 0.8372493003214321, 0.8921858466638231}, {
      0, 0.8378302152876969, 0.8917051220934227}, {
      0, 0.8384098827076482, 0.8912236395360154}, {
      0, 0.8389883042680952, 0.8907414003764215}, {
      0, 0.8395654816473493, 0.8902584059963707}, {
      0, 0.8401414165153034, 0.8897746577745197}, {
      0, 0.8407161105335054, 0.8892901570864736}, {
      0, 0.8412895653552332, 0.8888049053048028}, {
      0, 0.8418617826255712, 0.888318903799062}, {
      0, 0.8424327639814796, 0.8878321539358097}, {
      0, 0.8430025110518695, 0.887344657078626}, {
      0, 0.8435710254576745, 0.8868564145881297}, {
      0, 0.8441383088119183, 0.8863674278219991}, {
      0, 0.8447043627197894, 0.8858776981349863}, {
      0, 0.8452691887787067, 0.8853872268789376}, {
      0, 0.8458327885783886, 0.8848960154028103}, {
      0, 0.8463951637009218, 0.8844040650526891}, {
      0, 0.8469563157208277, 0.8839113771718046}, {
      0, 0.8475162462051274, 0.8834179531005497}, {
      0, 0.8480749567134094, 0.8829237941764964}, {
      0, 0.8486324487978921, 0.8824289017344131}, {
      0, 0.8491887240034895, 0.8819332771062807}, {
      0, 0.8497437838678742, 0.8814369216213088}, {
      0, 0.8502976299215388, 0.8809398366059532}, {
      0, 0.8508502636878594, 0.8804420233839306}, {
      0, 0.8514016866831573, 0.8799434832762352}, {
      0, 0.8519519004167573, 0.8794442176011553}, {
      0, 0.85250090639105, 0.8789442276742873}, {
      0, 0.853048706101551, 0.8784435148085529}, {
      0, 0.8535953010369574, 0.8779420803142145}, {
      0, 0.8541406926792092, 0.8774399254988885}, {
      0, 0.8546848825035442, 0.8769370516675633}, {
      0, 0.8552278719785561, 0.8764334601226125}, {
      0, 0.8557696625662506, 0.8759291521638101}, {
      0, 0.8563102557221014, 0.8754241290883457}, {
      0, 0.8568496528951044, 0.8749183921908384}, {
      0, 0.8573878555278326, 0.8744119427633532}, {
      0, 0.8579248650564913, 0.8739047820954124}, {
      0, 0.8584606829109696, 0.8733969114740127}, {
      0, 0.8589953105148945, 0.8728883321836372}, {
      0, 0.8595287492856828, 0.8723790455062713}, {
      0, 0.8600610006345929, 0.8718690527214151}, {
      0, 0.860592065966776, 0.8713583551060978}, {
      0, 0.8611219466813268, 0.8708469539348922}, {
      0, 0.8616506441713337, 0.8703348504799261}, {
      0, 0.862178159823929, 0.8698220460108977}, {
      0, 0.8627044950203361, 0.8693085417950888}, {
      0, 0.8632296511359214, 0.8687943390973764}, {
      0, 0.8637536295402396, 0.8682794391802472}, {
      0, 0.8642764315970825, 0.8677638433038112}, {
      0, 0.8647980586645261, 0.8672475527258122}, {
      0, 0.8653185120949772, 0.8667305687016433}, {
      0, 0.8658377932352206, 0.8662128924843572}, {0.0006613781017822207, 
      0.8663559034264627, 0.8656945253246806}, {0.001697375533353692, 
      0.866872844004379, 0.8651754684710254}, {0.0027328931296558704`, 
      0.8673886162991578, 0.8646557231695019}, {0.0037679309716143064`, 
      0.8679032216355447, 0.8641352906639306}, {0.00480248913703323, 
      0.8684166613328873, 0.8636141721958539}, {0.005836567700627997, 
      0.8689289367051775, 0.8630923690045496}, {0.006870166734054723, 
      0.8694400490610957, 0.862569882327041}, {0.007903286305942768, 
      0.8699499997040532, 0.8620467133981105}, {0.008935926481924305, 
      0.8704587899322339, 0.8615228634503096}, {0.009968087324664306, 
      0.8709664210386363, 0.8609983337139722}, {0.010999768893890888`, 
      0.8714728943111159, 0.8604731254172251}, {0.012030971246425532`, 
      0.871978211032425, 0.8599472397859994}, {0.013061694436210507`, 
      0.8724823724802535, 0.8594206780440431}, {0.014091938514339328`, 
      0.8729853799272701, 0.8588934414129309}, {0.015121703529084618`, 
      0.8734872346411605, 0.858365531112076}, {0.01615098952592712, 
      0.8739879378846684, 0.8578369483587414}, {0.017179796547583028`, 
      0.8744874909156337, 0.8573076943680507}, {0.018208124634032614`, 
      0.8749858949870312, 0.8567777703529986}, {0.019235973822545892`, 
      0.8754831513470086, 0.8562471775244628}, {0.020263344147712466`, 
      0.875979261238926, 0.8557159170912136}, {0.02129023564146631, 
      0.8764742259013915, 0.855183990259925}, {0.0223166483331132, 
      0.876968046568299, 0.8546513982351858}, {0.023342582249357435`, 
      0.8774607244688659, 0.8541181422195087}, {0.024368037414326586`, 
      0.877952260827669, 0.8535842234133423}, {0.02539301384959916, 
      0.8784426568646797, 0.8530496430150807}, {0.026417511574228794`, 
      0.878931913795302, 0.852514402221073}, {0.02744153060476972, 
      0.879420032830405, 0.8519785022256353}, {0.02846507095530239, 
      0.8799070151763612, 0.8514419442210588}, {0.029488132637458673`, 
      0.8803928620350792, 0.8509047293976205}, {0.030510715660443957`, 
      0.880877574604038, 0.8503668589435942}, {0.03153282003106483, 
      0.8813611540763233, 0.8498283340452587}, {0.032554445753750806`, 
      0.881843601640659, 0.8492891558869081}, {0.03357559283057836, 
      0.8823249184814408, 0.8487493256508626}, {0.034596261261296536`, 
      0.8828051057787721, 0.8482088445174756}, {0.03561645104334613, 
      0.8832841647084927, 0.8476677136651467}, {0.03663616217188825, 
      0.8837620964422156, 0.8471259342703275}, {0.0376553946398219, 
      0.8842389021473556, 0.8465835075075339}, {0.03867414843781088, 
      0.8847145829871641, 0.8460404345493532}, {0.039692423554302914`, 
      0.8851891401207588, 0.8454967165664556}, {0.04071021997555425, 
      0.8856625747031559, 0.8449523547276017}, {0.04172753768565037, 
      0.8861348878853016, 0.8444073501996513}, {0.042744376666528125`, 
      0.8866060808141022, 0.843861704147574}, {0.04376073689799726, 
      0.8870761546324544, 0.8433154177344572}, {0.04477661835776158, 
      0.8875451104792766, 0.842768492121515}, {0.04579202102144067, 
      0.8880129494895377, 0.8422209284680972}, {0.04680694486259015, 
      0.8884796727942879, 0.8416727279316978}, {0.0478213898527224, 
      0.8889452815206865, 0.8411238916679642}, {0.04883535596132806, 
      0.8894097767920334, 0.8405744208307053}, {0.04984884315589501, 
      0.8898731597277953, 0.8400243165719005}, {0.05086185140192914, 
      0.8903354314436368, 0.8394735800417076}, {0.051874380662974215`, 
      0.8907965930514463, 0.8389222123884721}, {0.052886430900632, 
      0.8912566456593666, 0.8383702147587345}, {0.053898002074581536`, 
      0.8917155903718211, 0.8378175882972395}, {0.0549090941425979, 
      0.8921734282895418, 0.8372643341469438}, {0.05591970706057207, 
      0.8926301605095963, 0.8367104534490244}, {0.056929840782529696`, 
      0.8930857881254163, 0.8361559473428863}, {0.057939495260650425`, 
      0.8935403122268224, 0.8356008169661719}, {0.05894867044528562, 
      0.8939937339000523, 0.8350450634547667}, {0.059957366284976985`, 
      0.8944460542277868, 0.8344886879428098}, {0.0609655827264753, 
      0.8948972742891752, 0.8339316915626999}, {0.061973319714758966`, 
      0.8953473951598625, 0.8333740754451036}, {0.06298057719305036, 
      0.895796417912014, 0.8328158407189638}, {0.06398735510283494, 
      0.8962443436143415, 0.8322569885115065}, {0.06499365338387848, 
      0.8966911733321277, 0.8316975199482491}, {0.06599947197424366, 
      0.8971369081272519, 0.8311374361530082}, {0.06700481081030937, 
      0.897581549058215, 0.8305767382479056}, {0.06800966982678576, 
      0.8980250971801633, 0.8300154273533775}, {0.0690140489567315, 
      0.8984675535449131, 0.8294535045881816}, {0.07001794813157212, 
      0.8989089192009755, 0.8288909710694035}, {0.07102136728111474, 
      0.8993491951935794, 0.8283278279124648}, {0.0720243063335653, 
      0.899788382564696, 0.8277640762311306}, {0.07302676521554517, 
      0.9002264823530614, 0.8271997171375163}, {0.07402874385210696, 
      0.9006634955942011, 0.8266347517420942}, {0.07503024216675029, 
      0.9010994233204521, 0.8260691811537019}, {0.07603126008143851, 
      0.9015342665609867, 0.825503006479548}, {0.07703179751661335, 
      0.9019680263418337, 0.8249362288252204}, {0.07803185439121131, 
      0.9024007036859034, 0.8243688492946922}, {0.07903143062267869, 
      0.9028322996130077, 0.8238008689903289}, {0.08003052612698645, 
      0.9032628151398824, 0.823232289012896}, {0.08102914081864718, 
      0.9036922512802111, 0.822663110461564}, {0.08202727461072729, 
      0.9041206090446449, 0.8220933344339174}, {0.08302492741486411, 
      0.9045478894408241, 0.8215229620259601}, {0.08402209914128017, 
      0.9049740934734015, 0.8209519943321215}, {0.08501878969879681, 
      0.9053992221440617, 0.8203804324452648}, {0.08601499899484992, 
      0.9058232764515421, 0.8198082774566923}, {0.08701072693550323, 
      0.9062462573916552, 0.8192355304561522}, {0.08800597342546351, 
      0.9066681659573083, 0.8186621925318448}, {0.0890007383680937, 
      0.9070890031385237, 0.8180882647704301}, {0.0899950216654277, 
      0.90750876992246, 0.8175137482570325}, {0.09098882321818282, 
      0.9079274672934312, 0.8169386440752485}, {0.09198214292577571, 
      0.9083450962329278, 0.816362953307152}, {0.0929749806863337, 
      0.9087616577196352, 0.8157866770333017}, {0.09396733639670989, 
      0.9091771527294552, 0.8152098163327454}, {0.0949592099524949, 
      0.9095915822355235, 0.8146323722830286}, {0.09595060124803151, 
      0.9100049472082303, 0.8140543459601988}, {0.09694151017642787, 
      0.9104172486152398, 0.8134757384388119}, {0.09793193662956824, 
      0.9108284874215072, 0.8128965507919389}, {0.09892188049812833, 
      0.9112386645892999, 0.8123167840911717}, {0.09991134167158769, 
      0.9116477810782154, 0.8117364394066277}, {0.10090032003824077`, 
      0.9120558378451984, 0.8111555178069577}, {0.10188881548521057`, 
      0.9124628358445614, 0.8105740203593509}, {0.10287682789846159`, 
      0.9128687760280019, 0.8099919481295403}, {0.10386435716281119`, 
      0.9132736593446201, 0.8094093021818088}, {0.10485140316194126`, 
      0.9136774867409372, 0.8088260835789958}, {0.10583796577841251`, 
      0.9140802591609135, 0.808242293382501}, {0.10682404489367359`, 
      0.9144819775459657, 0.807657932652292}, {0.10780964038807557`, 
      0.9148826428349844, 0.8070730024469088}, {0.10879475214088219`, 
      0.9152822559643518, 0.8064875038234696}, {0.10977938003028125`, 
      0.915680817867958, 0.8059014378376766}, {0.11076352393339735`, 
      0.916078329477219, 0.8053148055438217}, {0.11174718372630305`, 
      0.9164747917210937, 0.8047276079947907}, {0.11273035928402925`, 
      0.9168702055260998, 0.8041398462420706}, {0.11371305048057799`, 
      0.9172645718163314, 0.8035515213357534}, {0.11469525718893193`, 
      0.9176578915134744, 0.8029626343245425}, {0.11567697928106699`, 
      0.9180501655368245, 0.8023731862557575}, {0.116658216627962, 
      0.9184413948033019, 0.8017831781753398}, {0.11763896909961055`, 
      0.9188315802274682, 0.8011926111278577}, {0.11861923656503173`, 
      0.9192207227215426, 0.8006014861565108}, {0.11959901889227961`, 
      0.919608823195417, 0.8000098043031375}, {0.12057831594845587`, 
      0.919995882556673, 0.799417566608217}, {0.12155712759971762`, 
      0.9203819017105951, 0.7988247741108774}, {0.12253545371129078`, 
      0.9207668815601896, 0.7982314278488988}, {0.12351329414747807`, 
      0.9211508230061972, 0.7976375288587192}, {0.124490648771671, 
      0.9215337269471097, 0.7970430781754386}, {0.1254675174463576, 
      0.9219155942791838, 0.7964480768328261}, {0.12644390003313621`, 
      0.922296425896458, 0.7958525258633219}, {0.12741979639272158`, 
      0.9226762226907662, 0.7952564262980445}, {0.12839520638495705`, 
      0.923054985551752, 0.7946597791667948}, {0.12937012986882368`, 
      0.9234327153668849, 0.7940625854980611}, {0.13034456670245054`, 
      0.9238094130214736, 0.793464846319023}, {0.13131851674312311`, 
      0.924185079398681, 0.7928665626555579}, {0.13229197984729396`, 
      0.9245597153795383, 0.7922677355322443}, {0.13326495587059203`, 
      0.9249333218429593, 0.7916683659723672}, {0.1342374446678319, 
      0.9253058996657543, 0.7910684549979223}, {0.1352094460930228, 
      0.9256774497226442, 0.7904680036296216}, {0.13618095999937851`, 
      0.9260479728862748, 0.7898670128868964}, {0.1371519862393256, 
      0.9264174700272299, 0.7892654837879042}, {0.1381225246645133, 
      0.9267859420140445, 0.7886634173495312}, {0.13909257512582285`, 
      0.9271533897132203, 0.7880608145873975}, {0.14006213747337493`, 
      0.9275198139892371, 0.7874576765158623}, {0.1410312115565402, 
      0.9278852157045672, 0.786854004148027}, {0.14199979722394662`, 
      0.9282495957196879, 0.7862497984957414}, {0.14296789432348947`, 
      0.9286129548930959, 0.7856450605696064}, {0.1439355027023396, 
      0.928975294081319, 0.7850397913789794}, {0.14490262220695133`, 
      0.9293366141389299, 0.7844339919319785}, {0.14586925268307094`, 
      0.929696915918558, 0.7838276632354871}, {0.14683539397574666`, 
      0.9300562002709036, 0.7832208062951571}, {0.14780104592933513`, 
      0.9304144680447497, 0.7826134221154146}, {0.148766208387511, 
      0.9307717200869742, 0.7820055116994631}, {0.14973088119327438`, 
      0.9311279572425629, 0.7813970760492884}, {0.15069506418895917`, 
      0.9314831803546219, 0.7807881161656627}, {0.15165875721624147`, 
      0.9318373902643895, 0.780178633048148}, {0.1526219601161471, 
      0.9321905878112486, 0.7795686276951016}, {0.1535846727290603, 
      0.9325427738327388, 0.7789581011036786}, {0.1545468948947304, 
      0.932893949164568, 0.7783470542698376}, {0.15550862645228108`, 
      0.9332441146406247, 0.7777354881883437}, {0.15646986724021672`, 
      0.9335932710929897, 0.777123403852773}, {0.15743061709643186`, 
      0.933941419351948, 0.7765108022555162}, {0.15839087585821604`, 
      0.9342885602459995, 0.7758976843877835}, {0.15935064336226495`, 
      0.9346346946018719, 0.775284051239607}, {0.16030991944468514`, 
      0.9349798232445315, 0.7746699037998462}, {0.16126870394100248`, 
      0.935323946997194, 0.7740552430561914}, {0.16222699668616927`, 
      0.9356670666813365, 0.7734400699951671}, {0.16318479751457232`, 
      0.9360091831167087, 0.7728243856021364}, {0.16414210626003925`, 
      0.9363502971213439, 0.7722081908613045}, {0.1650989227558463, 
      0.9366904095115695, 0.7715914867557231}, {0.16605524683472556`, 
      0.9370295211020189, 0.7709742742672933}, {0.16701107832887105`, 
      0.9373676327056413, 0.7703565543767702}, {0.16796641706994703`, 
      0.9377047451337134, 0.7697383280637663}, {0.16892126288909462`, 
      0.9380408591958496, 0.7691195963067549}, {0.16987561561693823`, 
      0.9383759757000127, 0.7685003600830745}, {0.1708294750835927, 
      0.9387100954525248, 0.767880620368932}, {0.1717828411186706, 
      0.9390432192580769, 0.7672603781394063}, {0.1727357135512884, 
      0.9393753479197404, 0.7666396343684521}, {0.17368809221007278`, 
      0.9397064822389765, 0.7660183900289036}, {0.17463997692316885`, 
      0.9400366230156468, 0.7653966460924779}, {0.17559136751824464`, 
      0.9403657710480235, 0.7647744035297788}, {0.17654226382249963`, 
      0.9406939271327995, 0.7641516633102999}, {0.17749266566266964`, 
      0.9410210920650985, 0.7635284264024289}, {0.17844257286503468`, 
      0.9413472666384843, 0.7629046937734496}, {0.17939198525542424`, 
      0.9416724516449717, 0.7622804663895475}, {0.18034090265922384`, 
      0.9419966478750352, 0.7616557452158115}, {0.18128932490138236`, 
      0.94231985611762, 0.7610305312162376}, {0.18223725180641595`, 
      0.94264207716015, 0.7604048253537341}, {0.18318468319841724`, 
      0.942963311788539, 0.7597786285901217}, {0.18413161890105895`, 
      0.9432835607871991, 0.7591519418861402}, {0.18507805873760125`, 
      0.9436028249390508, 0.7585247662014497}, {0.18602400253089812`, 
      0.9439211050255324, 0.7578971024946343}, {0.18696945010340152`, 
      0.9442384018266082, 0.7572689517232066}, {0.18791440127716974`, 
      0.9445547161207795, 0.7566403148436096}, {0.1888588558738715, 
      0.9448700486850918, 0.7560111928112204}, {0.18980281371479255`, 
      0.9451844002951463, 0.7553815865803537}, {0.1907462746208416, 
      0.9454977717251064, 0.7547514971042648}, {0.1916892384125557, 
      0.9458101637477084, 0.7541209253351527}, {0.19263170491010617`, 
      0.9461215771342703, 0.753489872224164}, {0.19357367393330405`, 
      0.9464320126546989, 0.752858338721395}, {0.19451514530160618`, 
      0.9467414710775015, 0.7522263257758954}, {0.19545611883412067`, 
      0.9470499531697921, 0.7515938343356714}, {0.1963965943496118, 
      0.9473574596973011, 0.7509608653476892}, {0.1973365716665061, 
      0.9476639914243841, 0.750327419757878}, {0.19827605060289816`, 
      0.9479695491140296, 0.7496934985111315}, {0.1992150309765557, 
      0.9482741335278692, 0.7490591025513134}, {0.20015351260492373`, 
      0.9485777454261828, 0.7484242328212592}, {0.2010914953051327, 
      0.9488803855679112, 0.7477888902627786}, {0.20202897889400076`, 
      0.9491820547106606, 0.7471530758166599}, {0.20296596318804075`, 
      0.9494827536107133, 0.7465167904226725}, {0.20390244800346538`, 
      0.9497824830230344, 0.745880035019569}, {0.20483843315619205`, 
      0.950081243701281, 0.745242810545089}, {0.20577391846184676`, 
      0.9503790363978093, 0.7446051179359625}, {0.20670890373577244`, 
      0.9506758618636837, 0.7439669581279112}, {0.2076433887930301, 
      0.9509717208486836, 0.7433283320556535}, {0.20857737344840718`, 
      0.9512666141013122, 0.7426892406529051}, {0.20951085751641987`, 
      0.9515605423688038, 0.742049684852384}, {0.2104438408113201, 
      0.9518535063971318, 0.7414096655858117}, {0.21137632314709942`, 
      0.9521455069310164, 0.7407691837839171}, {0.21230830433749337`, 
      0.9524365447139324, 0.7401282403764389}, {0.21323978419598827`, 
      0.9527266204881164, 0.7394868362921282}, {0.2141707625358233, 
      0.9530157349945751, 0.7388449724587518}, {0.215101239169998, 
      0.953303888973092, 0.7382026498030941}, {0.21603121391127417`, 
      0.9535910831622357, 0.7375598692509615}, {0.21696068657218318`, 
      0.9538773182993662, 0.7369166317271829}, {0.21788965696502888`, 
      0.9541625951206434, 0.7362729381556143}, {0.21881812490189337`, 
      0.954446914361034, 0.7356287894591406}, {0.2197460901946405, 
      0.9547302767543184, 0.7349841865596779}, {0.22067355265492075`, 
      0.9550126830330985, 0.7343391303781778}, {0.22160051209417655`, 
      0.9552941339288045, 0.7336936218346279}, {0.2225269683236455, 
      0.9555746301717019, 0.7330476618480565}, {0.2234529211543656, 
      0.9558541724908988, 0.7324012513365333}, {0.22437837039717953`, 
      0.9561327616143532, 0.7317543912171737}, {0.22530331586273886`, 
      0.9564103982688791, 0.7311070824061402}, {0.22622775736150882`, 
      0.9566870831801545, 0.7304593258186457}, {0.2271516947037713, 
      0.956962817072727, 0.7298111223689558}, {0.22807512769963115`, 
      0.9572376006700221, 0.7291624729703909}, {0.228998056159019, 
      0.9575114346943487, 0.7285133785353298}, {0.22992047989169578`, 
      0.9577843198669066, 0.7278638399752109}, {0.23084239870725692`, 
      0.9580562569077928, 0.727213858200536}, {0.23176381241513633`, 
      0.9583272465360082, 0.7265634341208719}, {0.232684720824611, 
      0.9585972894694643, 0.7259125686448532}, {0.2336051237448049, 
      0.9588663864249899, 0.725261262680185}, {0.23452502098469274`, 
      0.9591345381183372, 0.7246095171336444}, {0.23544441235310432`, 
      0.9594017452641886, 0.7239573329110842}, {0.236363297658728, 
      0.9596680085761626, 0.7233047109174346}, {0.23728167671011535`, 
      0.9599333287668211, 0.7226516520567058}, {0.23819954931568518`, 
      0.9601977065476751, 0.7219981572319899}, {0.23911691528372617`, 
      0.9604611426291906, 0.7213442273454643}, {0.24003377442240262`, 
      0.9607236377207957, 0.720689863298393}, {0.24095012653975642`, 
      0.9609851925308863, 0.7200350659911299}, {0.2418659714437125, 
      0.9612458077668324, 0.71937983632312}, {0.2427813089420813, 
      0.9615054841349844, 0.7187241751929031}, {0.24369613884256355`, 
      0.9617642223406786, 0.718068083498115}, {0.24461046095275363`, 
      0.9620220230882437, 0.7174115621354901}, {0.2455242750801427, 
      0.9622788870810068, 0.7167546120008641}, {0.24643758103212327`, 
      0.9625348150212992, 0.716097233989176}, {0.24735037861599263`, 
      0.9627898076104626, 0.71543942899447}, {0.24826266763895607`, 
      0.9630438655488543, 0.7147811979098982}, {0.24917444790813068`, 
      0.9632969895358539, 0.7141225416277233}, {0.2500857192305498, 
      0.9635491802698684, 0.7134634610393186}, {0.2509964814131644, 
      0.9638004384483382, 0.712803957035174}, {0.2519067342628493, 
      0.9640507647677433, 0.7121440305048939}, {0.25281647758640435`, 
      0.964300159923608, 0.7114836823372036}, {0.25372571119055964`, 
      0.9645486246105075, 0.710822913419948}, {0.2546344348819776, 
      0.9647961595220729, 0.7101617246400954}, {0.25554264846725744`, 
      0.965042765350997, 0.7095001168837396}, {0.25645035175293746`, 
      0.9652884427890397, 0.7088380910361022}, {0.25735754454549997`, 
      0.9655331925270337, 0.7081756479815338}, {0.25826422665137316`, 
      0.9657770152548898, 0.7075127886035166}, {0.25917039787693547`, 
      0.9660199116616026, 0.7068495137846672}, {0.2600760580285175, 
      0.9662618824352553, 0.7061858244067378}, {0.26098120691240734`, 
      0.9665029282630259, 0.7055217213506184}, {0.26188584433485224`, 
      0.9667430498311913, 0.704857205496339}, {0.2627899701020616, 
      0.966982247825134, 0.7041922777230724}, {0.26369358402021176`, 
      0.9672205229293463, 0.7035269389091346}, {0.26459668589544794`, 
      0.9674578758274363, 0.7028611899319882}, {0.2654992755338879, 
      0.967694307202132, 0.7021950316682442}, {0.2664013527416248, 
      0.9679298177352877, 0.701528464993663}, {0.2673029173247297, 
      0.9681644081078882, 0.7008614907831584}, {0.2682039690892569, 
      0.9683980790000541, 0.7001941099107972}, {0.2691045078412439, 
      0.9686308310910474, 0.6995263232498036}, {0.27000453338671715`, 
      0.9688626650592757, 0.6988581316725584}, {0.270904045531693, 
      0.9690935815822971, 0.6981895360506042}, {0.2718030440821824, 
      0.9693235813368267, 0.6975205372546442}, {0.2727015288441928, 
      0.9695526649987393, 0.6968511361545464}, {0.2735994996237312, 
      0.969780833243076, 0.6961813336193448}, {0.27449695622680786`, 
      0.9700080867440479, 0.6955111305172401}, {0.27539389845943796`, 
      0.9702344261750421, 0.6948405277156042}, {0.27629032612764576`, 
      0.9704598522086254, 0.6941695260809797}, {0.2771862390374666, 
      0.9706843655165496, 0.6934981264790829}, {0.27808163699494987`, 
      0.9709079667697557, 0.6928263297748058}, {0.2789765198061626, 
      0.9711306566383796, 0.692154136832217}, {0.27987088727719134`, 
      0.971352435791756, 0.6914815485145647}, {0.28076473921414496`, 
      0.9715733048984229, 0.690808565684278}, {0.28165807542315874`, 
      0.9717932646261269, 0.6901351892029682}, {0.28255089571039477`, 
      0.972012315641827, 0.6894614199314322}, {0.2834431998820478, 
      0.9722304586117, 0.6887872587296522}, {0.2843349877443444, 
      0.972447694201144, 0.6881127064567997}, {0.28522625910354865`, 
      0.9726640230747838, 0.6874377639712352}, {0.2861170137659634, 
      0.9728794458964749, 0.6867624321305115}, {0.28700725153793255`, 
      0.9730939633293079, 0.6860867117913753}, {0.28789697222584526`, 
      0.9733075760356129, 0.6854106038097677}, {0.2887861756361367, 
      0.9735202846769645, 0.6847341090408279}, {0.28967486157529204`, 
      0.9737320899141851, 0.6840572283388932}, {0.29056302984984866`, 
      0.9739429924073502, 0.6833799625575014}, {0.29145068026639803`, 
      0.9741529928157917, 0.6827023125493936}, {0.2923378126315893, 
      0.9743620917981031, 0.6820242791665138}, {0.2932244267521312, 
      0.9745702900121432, 0.681345863260012}, {0.2941105224347943, 
      0.9747775881150406, 0.6806670656802463}, {0.29499609948641453`, 
      0.9749839867631973, 0.6799878872767828}, {0.2958811577138943, 
      0.9751894866122939, 0.6793083288983995}, {0.29676569692420623`, 
      0.9753940883172925, 0.6786283913930863}, {0.2976497169243947, 
      0.9755977925324418, 0.677948075608047}, {0.29853321752157863`, 
      0.9758005999112807, 0.6772673823897019}, {0.29941619852295387`, 
      0.9760025111066419, 0.6765863125836881}, {0.30029865973579556`, 
      0.9762035267706577, 0.6759048670348622}, {0.3011806009674601, 
      0.9764036475547614, 0.6752230465873013}, {0.3020620220253885, 
      0.9766028741096934, 0.6745408520843048}, {0.3029429227171078, 
      0.9768012070855041, 0.6738582843683963}, {0.3038233028502338, 
      0.9769986471315584, 0.6731753442813244}, {0.30470316223247274`, 
      0.9771951948965387, 0.672492032664066}, {0.3055825006716249, 
      0.9773908510284499, 0.6718083503568251}, {0.3064613179755853, 
      0.9775856161746227, 0.6711242981990373}, {0.30733961395234705`, 
      0.977779490981717, 0.6704398770293699}, {0.30821738841000335`, 
      0.9779724760957265, 0.6697550876857232}, {0.30909464115674956`, 
      0.978164572161982, 0.6690699310052325}, {0.3099713720008854, 
      0.9783557798251556, 0.6683844078242702}, {0.3108475807508172, 
      0.9785460997292634, 0.6676985189784462}, {0.3117232672150599, 
      0.9787355325176705, 0.6670122653026106}, {0.3125984312022399, 
      0.9789240788330938, 0.6663256476308541}, {0.3134730725210959, 
      0.9791117393176062, 0.6656386667965103}, {0.3143471909804827, 
      0.9792985146126396, 0.6649513236321569}, {0.3152207863893717, 
      0.9794844053589893, 0.6642636189696175}, {0.316093858556854, 
      0.9796694121968168, 0.6635755536399628}, {0.3169664072921428, 
      0.979853535765654, 0.6628871284735113}, {0.3178384324045737, 
      0.9800367767044067, 0.6621983442998329}, {0.3187099337036091, 
      0.9802191356513574, 0.6615092019477483}, {0.31958091099883795`, 
      0.9804006132441696, 0.6608197022453317}, {0.3204513640999801, 
      0.9805812101198913, 0.6601298460199111}, {0.3213212928168862, 
      0.9807609269149575, 0.6594396340980713}, {0.32219069695954095`, 
      0.9809397642651949, 0.658749067305654}, {0.32305957633806515`, 
      0.9811177228058245, 0.6580581464677594}, {0.32392793076271664`, 
      0.9812948031714652, 0.6573668724087486}, {0.3247957600438935, 
      0.9814710059961372, 0.6566752459522438}, {0.3256630639921345, 
      0.9816463319132653, 0.6559832679211308}, {0.326529842418123, 
      0.9818207815556825, 0.6552909391375594}, {0.3273960951326871, 
      0.9819943555556325, 0.6545982604229454}, {0.3282618219468023, 
      0.9821670545447744, 0.6539052325979721}, {0.3291270226715937, 
      0.9823388791541845, 0.6532118564825907}, {0.32999169711833704`, 
      0.9825098300143603, 0.6525181328960233}, {0.33085584509846117`, 
      0.982679907755224, 0.6518240626567628}, {0.3317194664235498, 
      0.9828491130061249, 0.651129646582575}, {0.33258256090534344`, 
      0.983017446395843, 0.6504348854904995}, {0.3334451283557406, 
      0.9831849085525927, 0.6497397801968521}, {0.33430716858680054`, 
      0.9833515001040247, 0.6490443315172243}, {0.33516868141074435`, 
      0.9835172216772308, 0.6483485402664865}, {0.33602966663995754`, 
      0.9836820738987452, 0.6476524072587877}, {0.3368901240869902, 
      0.9838460573945488, 0.6469559333075587}, {0.33775005356456056`, 
      0.9840091727900723, 0.6462591192255117}, {0.33860945488555616`, 
      0.9841714207101983, 0.6455619658246421}, {0.33946832786303477`, 
      0.9843328017792653, 0.6448644739162305}, {0.34032667231022773`, 
      0.9844933166210704, 0.6441666443108427}, {0.34118448804053914`, 
      0.984652965858872, 0.6434684778183327}, {0.342041774867551, 
      0.9848117501153932, 0.6427699752478423}, {0.3428985326050222, 
      0.9849696700128249, 0.6420711374078026}, {0.3437547610668906, 
      0.9851267261728277, 0.6413719651059371}, {0.3446104600672755, 
      0.9852829192165362, 0.6406724591492606}, {0.3454656294204788, 
      0.9854382497645611, 0.6399726203440823}, {0.34632026894098744`, 
      0.9855927184369921, 0.6392724494960047}, {0.34717437844347376`, 
      0.9857463258534014, 0.6385719474099276}, {0.34802795774279716`, 
      0.9858990726328454, 0.6378711148900483}, {0.34888100665400723`, 
      0.9860509593938688, 0.6371699527398614}, {0.34973352499234406`, 
      0.9862019867545067, 0.6364684617621625}, {0.3505855125732401, 
      0.9863521553322873, 0.635766642759047}, {0.3514369692123217, 
      0.9865014657442354, 0.6350644965319135}, {0.3522878947254112, 
      0.9866499186068742, 0.634362023881463}, {0.35313828892852717`, 
      0.9867975145362292, 0.633659225607702}, {0.3539881516378878, 
      0.9869442541478296, 0.6329561025099417}, {0.3548374826699107, 
      0.9870901380567122, 0.6322526553868015}, {0.3556862818412156, 
      0.9872351668774234, 0.6315488850362079}, {0.3565345489686253, 
      0.9873793412240223, 0.6308447922553969}, {0.35738228386916726`, 
      0.9875226617100826, 0.6301403778409154}, {0.35822948636007546`, 
      0.9876651289486967, 0.6294356425886213}, {0.35907615625879113`, 
      0.987806743552477, 0.6287305872936858}, {0.3599222933829648, 
      0.9879475061335588, 0.628025212750594}, {0.3607678975504575, 
      0.9880874173036033, 0.6273195197531457}, {0.36161296857934266`, 
      0.9882264776738001, 0.6266135090944573}, {0.36245750628790696`, 
      0.9883646878548693, 0.6259071815669625}, {0.3633015104946519, 
      0.988502048457065, 0.625200537962413}, {0.3641449810182959, 
      0.9886385600901766, 0.6244935790718806}, {0.36498791767777383`, 
      0.9887742233635322, 0.6237863056857583}, {0.3658303202922417, 
      0.9889090388860011, 0.6230787185937594}, {0.36667218868107404`, 
      0.989043007265996, 0.6223708185849219}, {0.36751352266386866`, 
      0.9891761291114753, 0.6216626064476067}, {0.3683543220604457, 
      0.9893084050299462, 0.6209540829695005}, {0.3691945866908511, 
      0.9894398356284666, 0.6202452489376155}, {0.37003431637535594`, 
      0.9895704215136477, 0.6195361051382918}, {0.3708735109344583, 
      0.9897001632916566, 0.6188266523571981}, {0.37171217018888614`, 
      0.9898290615682183, 0.618116891379332}, {0.37255029395959677`, 
      0.9899571169486185, 0.6174068229890217}, {0.3733878820677784, 
      0.990084330037706, 0.6166964479699276}, {0.37422493433485243`, 
      0.9902107014398946, 0.6159857671050422}, {0.37506145058247403`, 
      0.9903362317591659, 0.6152747811766918}, {0.375897430632534, 
      0.9904609215990714, 0.6145634909665374}, {0.3767328743071585, 
      0.990584771562735, 0.6138518972555764}, {0.37756778142871245`, 
      0.990707782252855, 0.6131400008241426}, {0.3784021518197994, 
      0.990829954271707, 0.6124278024519075}, {0.3792359853032634, 
      0.9909512882211452, 0.6117153029178818}, {0.3800692817021897, 
      0.9910717847026057, 0.6110025030004161}, {0.380902040839906, 
      0.9911914443171083, 0.6102894034772023}, {0.38173426253998466`, 
      0.9913102676652584, 0.6095760051252737}, {0.3825659466262434, 
      0.99142825534725, 0.6088623087210066}, {0.3833970929227454, 
      0.991545407962867, 0.6081483150401217}, {0.3842277012538017, 
      0.9916617261114865, 0.6074340248576848}, {0.38505777144397246`, 
      0.9917772103920797, 0.6067194389481072}, {0.3858873033180679, 
      0.9918918614032151, 0.6060045580851472}, {0.38671629670114877`, 
      0.9920056797430603, 0.6052893830419115}, {0.3875447514185289, 
      0.9921186660093841, 0.6045739145908551}, {0.38837266729577463`, 
      0.9922308207995586, 0.603858153503784}, {0.3892000441587077, 
      0.9923421447105616, 0.6031421005518539}, {0.39002688183340517`, 
      0.9924526383389782, 0.6024257565055732}, {0.3908531801462015, 
      0.9925623022810037, 0.6017091221348022}, {0.3916789389236889, 
      0.9926711371324447, 0.6009921982087558}, {0.39250415799271804`, 
      0.9927791434887218, 0.6002749854960037}, {0.393328837180401, 
      0.9928863219448716, 0.5995574847644706}, {0.3941529763141106, 
      0.9929926730955487, 0.5988396967814381}, {0.39497657522148166`, 
      0.9930981975350277, 0.598121622313546}, {0.3957996337304134, 
      0.9932028958572051, 0.5974032621267917}, {0.3966221516690698, 
      0.9933067686556017, 0.596684616986532}, {0.39744412886587915`, 
      0.9934098165233639, 0.5959656876574848}, {0.3982655651495374, 
      0.9935120400532667, 0.5952464749037292}, {0.3990864603490088, 
      0.9936134398377144, 0.5945269794887055}, {0.39990681429352565`, 
      0.9937140164687439, 0.5938072021752182}, {0.4007266268125906, 
      0.9938137705380258, 0.5930871437254351}, {0.4015458977359767, 
      0.9939127026368664, 0.5923668049008897}, {0.40236462689372954`, 
      0.9940108133562099, 0.5916461864624802}, {0.4031828141161674, 
      0.9941081032866401, 0.5909252891704726}, {0.4040004592338826, 
      0.9942045730183827, 0.5902041137845001}, {0.4048175620777425, 
      0.9943002231413066, 0.5894826610635642}, {0.4056341224788904, 
      0.9943950542449262, 0.5887609317660358}, {0.406450140268747, 
      0.9944890669184031, 0.5880389266496562}, {0.40726561527901, 
      0.9945822617505481, 0.587316646471538}, {0.4080805473416574, 
      0.9946746393298228, 0.5865940919881654}, {0.40889493628894585`, 
      0.9947662002443417, 0.5858712639553959}, {0.4097087819534141, 
      0.9948569450818741, 0.58514816312846}, {0.4105220841678811, 
      0.9949468744298453, 0.5844247902619641}, {0.41133484276545074`, 
      0.9950359888753394, 0.5837011461098887}, {0.412147057579509, 
      0.9951242890051, 0.582977231425591}, {0.4129587284437271, 
      0.995211775405533, 0.5822530469618059}, {0.413769855192062, 
      0.9952984486627077, 0.5815285934706457}, {0.4145804376587572, 
      0.9953843093623587, 0.5808038717036015}, {0.41539047567834314`, 
      0.9954693580898878, 0.5800788824115446}, {0.41619996908563944`, 
      0.9955535954303657, 0.5793536263447262}, {0.41700891771575443`, 
      0.9956370219685335, 0.5786281042527792}, {0.417817321404087, 
      0.995719638288805, 0.577902316884718}, {0.4186251799863262, 
      0.9958014449752677, 0.5771762649889415}, {0.41943249329845467`, 
      0.9958824426116849, 0.5764499493132302}, {0.4202392611767462, 
      0.9959626317814975, 0.5757233706047512}, {0.4210454834577694, 
      0.9960420130678251, 0.5749965296100558}, {0.4218511599783871, 
      0.9961205870534686, 0.5742694270750814}, {0.4226562905757575, 
      0.996198354320911, 0.5735420637451535}, {0.42346087508733504`, 
      0.9962753154523193, 0.5728144403649842}, {0.4242649133508715, 
      0.9963514710295466, 0.5720865576786751}, {0.4250684052044164, 
      0.9964268216341331, 0.5713584164297166}, {0.42587135048631813`, 
      0.996501367847308, 0.57063001736099}, {0.426673749035225, 
      0.9965751102499912, 0.5699013612147663}, {0.42747560069008556`, 
      0.996648049422795, 0.5691724487327093}, {0.4282769052901499, 
      0.9967201859460247, 0.5684432806558748}, {0.42907766267496933`, 
      0.9967915203996821, 0.5677138577247126}, {0.42987787268439986`, 
      0.9968620533634651, 0.5669841806790652}, {0.4306775351585989, 
      0.9969317854167705, 0.5662542502581716}, {0.4314766499380304, 
      0.9970007171386951, 0.5655240672006646}, {0.4322752168634624, 
      0.9970688491080374, 0.564793632244575}, {0.43307323577596957`, 
      0.997136181903299, 0.5640629461273293}, {0.43387070651693277`, 
      0.9972027161026861, 0.5633320095857532}, {0.4346676289280417, 
      0.9972684522841113, 0.5626008233560696}, {0.43546400285129333`, 
      0.9973333910251949, 0.5618693881739015}, {0.43625982812899416`, 
      0.9973975329032664, 0.5611377047742722}, {0.4370551046037608, 
      0.9974608784953658, 0.560405773891605}, {0.43784983211852024`, 
      0.9975234283782458, 0.5596735962597255}, {0.438644010516511, 
      0.9975851831283724, 0.5589411726118614}, {0.4394376396412843, 
      0.9976461433219269, 0.5582085036806427}, {0.4402307193367028, 
      0.9977063095348071, 0.5574755901981043}, {0.44102324944694404`, 
      0.9977656823426291, 0.556742432895685}, {0.4418152298164999, 
      0.9978242623207282, 0.5560090325042283}, {0.44260666029017653`, 
      0.9978820500441609, 0.5552753897539843}, {0.4433975407130966, 
      0.9979390460877058, 0.5545415053746091}, {0.4441878709306989, 
      0.9979952510258655, 0.5538073800951666}, {0.44497765078873874`, 
      0.9980506654328678, 0.5530730146441291}, {0.44576688013329097`, 
      0.9981052898826669, 0.552338409749376}, {0.4465555588107472, 
      0.9981591249489452, 0.5516035661381979}, {0.4473436866678199, 
      0.9982121712051142, 0.5508684845372943}, {0.44813126355154, 
      0.9982644292243162, 0.5501331656727763}, {0.4489182893092605, 
      0.9983158995794259, 0.5493976102701655}, {0.44970476378865415`, 
      0.9983665828430511, 0.5486618190543969}, {0.4504906868377172, 
      0.9984164795875345, 0.5479257927498175}, {0.4512760583047673, 
      0.9984655903849552, 0.547189532080188}, {0.452060878038446, 
      0.9985139158071294, 0.5464530377686835}, {0.4528451458877186, 
      0.9985614564256123, 0.5457163105378937}, {0.453628861701875, 
      0.9986082128116992, 0.5449793511098242}, {0.4544120253305303, 
      0.998654185536427, 0.5442421602058967}, {0.4551946366236255, 
      0.9986993751705753, 0.5435047385469496}, {0.4559766954314282, 
      0.9987437822846673, 0.542767086853239}, {0.456758201604533, 
      0.9987874074489722, 0.5420292058444393}, {0.4575391549938622, 
      0.9988302512335056, 0.5412910962396432}, {0.45831955545066627`, 
      0.9988723142080305, 0.5405527587573641}, {0.4590994028265249, 
      0.9989135969420597, 0.5398141941155348}, {0.459878696973348, 
      0.9989541000048563, 0.5390754030315084}, {0.46065743774337414`, 
      0.9989938239654347, 0.5383363862220605}, {0.4614356249891742, 
      0.9990327693925624, 0.5375971444033882}, {0.46221325856364964`, 
      0.9990709368547611, 0.5368576782911115}, {0.46299033832003417`, 
      0.9991083269203079, 0.5361179886002737}, {0.46376686411189394`, 
      0.9991449401572364, 0.5353780760453425}, {0.46454283579312805`, 
      0.999180777133338, 0.5346379413402098}, {0.46531825321797016`, 
      0.9992158384161629, 0.5338975851981927}, {0.46609311624098726`, 
      0.9992501245730221, 0.5331570083320347}, {0.4668674247170817, 
      0.9992836361709873, 0.5324162114539055}, {0.4676411785014913, 
      0.9993163737768933, 0.531675195275402}, {0.4684143774497897, 
      0.9993483379573385, 0.5309339605075486}, {0.4691870214178872, 
      0.999379529278686, 0.5301925078607986}, {0.4699591102620314, 
      0.9994099483070653, 0.5294508380450339}, {0.4707306438388072, 
      0.9994395956083733, 0.528708951769566}, {0.4715016220051376, 
      0.9994684717482748, 0.5279668497431371}, {0.4722720446182851, 
      0.9994965772922045, 0.5272245326739194}, {0.47304191153585085`, 
      0.9995239128053678, 0.5264820012695169}, {0.47381122261577585`, 
      0.9995504788527418, 0.5257392562369658}, {0.4745799777163417, 
      0.9995762759990766, 0.524996298282735}, {0.47534817669617063`, 
      0.9996013048088964, 0.5242531281127256}, {0.47611581941422665`, 
      0.9996255658465003, 0.5235097464322738}, {0.47688290572981507`, 
      0.9996490596759642, 0.522766153946149}, {0.47764943550258354`, 
      0.9996717868611409, 0.5220223513585573}, {0.47841540859252396`, 
      0.9996937479656618, 0.5212783393731377}, {0.47918082485997016`, 
      0.999714943552938, 0.5205341186929677}, {0.47994568416560063`, 
      0.999735374186161, 0.5197896900205604}, {0.4807099863704377, 
      0.9997550404283042, 0.5190450540578663}, {0.4814737313358495, 
      0.9997739428421236, 0.5183002115062741}, {0.48223691892354875`, 
      0.9997920819901591, 0.5175551630666103}, {0.4829995489955946, 
      0.9998094584347356, 0.5168099094391408}, {0.48376162141439233`, 
      0.9998260727379635, 0.5160644513235713}, {0.48452313604269404`, 
      0.9998419254617408, 0.5153187894190467}, {0.48528409274359885`, 
      0.9998570171677529, 0.5145729244241539}, {0.4860444913805542, 
      0.9998713484174745, 0.5138268570369202}, {0.48680433181735605`, 
      0.9998849197721703, 0.5130805879548143}, {0.48756361391814823`, 
      0.9998977317928962, 0.5123341178747479}, {0.4883223375474237, 
      0.9999097850405, 0.5115874474930763}, {0.4890805025700261, 
      0.9999210800756225, 0.5108405775055964}, {0.4898381088511482, 
      0.9999316174586987, 0.5100935086075505}, {0.4905951562563334, 
      0.9999413977499588, 0.5093462414936254}, {0.4913516446514766, 
      0.9999504215094287, 0.5085987768579521}, {0.49210757390282356`, 
      0.9999586892969317, 0.5078511153941081}, {0.4928629438769722, 
      0.9999662016720886, 0.5071032577951163}, {0.4936177544408723, 
      0.9999729591943198, 0.5063552047534475}, {0.494372005461827, 
      0.9999789624228453, 0.5056069569610183}, {0.4951256968074918, 
      0.9999842119166859, 0.504858515109194}, {0.4958788283458768, 
      0.9999887082346643, 0.5041098798887875}, {0.49663139994534455`, 
      0.9999924519354062, 0.5033610519900616}, {0.4973834114746135, 
      0.9999954435773407, 0.5026120321027272}, {0.49813486280275604`, 
      0.9999976837187018, 0.5018628209159457}, {0.4988857537992, 
      0.9999991729175289, 0.5011134191183289}, {0.49963608433372864`, 
      0.9999999117316681, 0.5003638273979395}, {0.500385854276482, 
      0.9999999007187729, 0.499614046442291}, {0.5011350634979549, 
      0.9999991404363049, 0.49886407693835005`}, {0.5018837118690008, 
      0.9999976314415352, 0.49811391957253437`}, {0.5026317992608291, 
      0.999995374291545, 0.49736357503071577`}, {0.5033793255450079, 
      0.9999923695432263, 0.49661304399821843`}, {0.5041262905934618, 
      0.9999886177532835, 0.4958623271598216}, {0.5048726942784751, 
      0.9999841194782333, 0.49511142519975815`}, {0.50561853647269, 
      0.9999788752744065, 0.49436033880171654`}, {0.506363817049108, 
      0.9999728856979483, 0.4936090686488402}, {0.5071085358810906, 
      0.9999661513048193, 0.4928576154237287}, {0.5078526928423586, 
      0.9999586726507963, 0.49210597980843773`}, {0.508596287806993, 
      0.9999504502914737, 0.49135416248448066`}, {0.5093393206494355, 
      0.9999414847822633, 0.49060216413282776`}, {0.5100817912444892, 
      0.9999317766783964, 0.4898499854339071}, {0.5108236994673175, 
      0.9999213265349234, 0.4890976270676058}, {0.5115650451934466, 
      0.9999101349067157, 0.48834508971326895`}, {0.5123058282987636, 
      0.9998982023484657, 0.4875923740497019}, {0.5130460486595187, 
      0.9998855294146883, 0.48683948075516953`}, {0.5137857061523249, 
      0.9998721166597214, 0.48608641050739654`}, {0.5145248006541573, 
      0.9998579646377267, 0.4853331639835693}, {0.5152633320423555, 
      0.9998430739026903, 0.48457974186033476`}, {0.5160013001946218, 
      0.9998274450084241, 0.4838261448138023}, {0.5167387049890236, 
      0.9998110785085662, 0.48307237351954246`}, {0.5174755463039918, 
      0.9997939749565816, 0.48231842865258984`}, {0.5182118240183223, 
      0.9997761349057634, 0.481564310887441}, {0.5189475380111759, 
      0.9997575589092332, 0.4808100208980573}, {0.5196826881620793, 
      0.9997382475199419, 0.48005555935786254`}, {0.520417274350924, 
      0.9997182012906709, 0.4793009269397469}, {0.5211512964579683, 
      0.9996974207740325, 0.47854612431606414`}, {0.5218847543638363, 
      0.9996759065224705, 0.4777911521586342}, {0.5226176479495184, 
      0.9996536590882615, 0.47703601113874305`}, {0.5233499770963731, 
      0.9996306790235154, 0.4762807019271423}, {0.5240817416861249, 
      0.9996069668801759, 0.47552522519405105`}, {0.524812941600866, 
      0.9995825232100216, 0.4747695816091556}, {0.5255435767230568, 
      0.9995573485646667, 0.4740137718416098}, {0.5262736469355263, 
      0.9995314434955617, 0.4732577965600354}, {0.5270031521214705, 
      0.9995048085539938, 0.4725016564325233}, {0.5277320921644553, 
      0.9994774442910884, 0.4717453521266332}, {0.5284604669484146, 
      0.9994493512578091, 0.4709888843093945}, {0.5291882763576528, 
      0.9994205300049586, 0.47023225364730586`}, {0.529915520276843, 
      0.9993909810831798, 0.4694754608063369}, {0.5306421985910276, 
      0.9993607050429559, 0.4687185064519284}, {0.5313683111856204, 
      0.9993297024346119, 0.4679613912489914}, {0.5320938579464051, 
      0.9992979738083144, 0.46720411586190924`}, {0.5328188387595356, 
      0.9992655197140728, 0.46644668095453723`}, {0.5335432535115371, 
      0.9992323407017404, 0.4656890871902033}, {0.534267102089306, 
      0.999198437321014, 0.46493133523170793`}, {0.5349903843801097, 
      0.9991638101214356, 0.46417342574132586`}, {0.5357131002715884, 
      0.9991284596523927, 0.4634153593808044}, {0.5364352496517527, 
      0.999092386463119, 0.46265713681136633`}, {0.537156832408987, 
      0.9990555911026949, 0.461898758693708}, {0.5378778484320469, 
      0.9990180741200486, 0.4611402256880017}, {0.5385982976100616, 
      0.9989798360639561, 0.4603815384538945}, {0.5393181798325329, 
      0.9989408774830428, 0.4596226976505098}, {0.540037494989336, 
      0.9989011989257833, 0.4588637039364473}, {0.5407562429707192, 
      0.9988608009405024, 0.4581045579697832}, {0.5414744236673049, 
      0.9988196840753759, 0.457345260408071}, {0.5421920369700896, 
      0.9987778488784309, 0.45658581190834135`}, {0.5429090827704431, 
      0.9987352958975468, 0.4558262131271037}, {0.5436255609601109, 
      0.9986920256804557, 0.4550664647203447}, {0.5443414714312123, 
      0.9986480387747431, 0.4543065673435307}, {0.5450568140762416, 
      0.9986033357278484, 0.4535465216516067}, {0.5457715887880685, 
      0.9985579170870661, 0.4527863282989975}, {0.5464857954599374, 
      0.9985117833995455, 0.45202598793960813`}, {0.5471994339854691, 
      0.9984649352122921, 0.45126550122682285`}, {0.5479125042586598, 
      0.9984173730721677, 0.4505048688135079}, {0.5486250061738814, 
      0.9983690975258916, 0.44974409135201016`}, {0.5493369396258827, 
      0.9983201091200405, 0.44898316949415784`}, {0.5500483045097881, 
      0.9982704084010497, 0.4482221038912614}, {0.5507591007210992, 
      0.9982199959152132, 0.44746089519411386`}, {0.5514693281556947, 
      0.9981688722086847, 0.44669954405298995`}, {0.5521789867098293, 
      0.9981170378274782, 0.44593805111764884`}, {0.5528880762801361, 
      0.9980644933174679, 0.44517641703733185`}, {0.553596596763625, 
      0.9980112392243901, 0.444414642460765}, {0.554304548057684, 
      0.9979572760938423, 0.4436527280361582}, {0.5550119300600783, 
      0.9979026044712848, 0.44289067441120644`}, {0.5557187426689519, 
      0.9978472249020409, 0.44212848223308904`}, {0.5564249857828265, 
      0.9977911379312977, 0.44136615214847114`}, {0.5571306593006029, 
      0.9977343441041061, 0.4406036848035031}, {0.5578357631215594, 
      0.997676843965382, 0.4398410808438227}, {0.5585402971453542, 
      0.9976186380599068, 0.43907834091455256`}, {0.5592442612720241, 
      0.9975597269323274, 0.43831546566030327`}, {0.5599476554019849, 
      0.9975001111271573, 0.4375524557251723}, {0.5606504794360325, 
      0.9974397911887769, 0.4367893117527442}, {0.5613527332753409, 
      0.9973787676614343, 0.43602603438609333`}, {0.5620544168214654, 
      0.9973170410892455, 0.4352626242677801}, {0.5627555299763402, 
      0.9972546120161951, 0.434499082039855}, {0.56345607264228, 
      0.9971914809861371, 0.433735408343857}, {0.5641560447219794, 
      0.9971276485427947, 0.43297160382081523`}, {0.564855446118514, 
      0.9970631152297617, 0.4322076691112475}, {0.565554276735339, 
      0.9969978815905023, 0.4314436048551633}, {0.5662525364762916, 
      0.9969319481683524, 0.43067941169206087`}, {0.5669502252455886, 
      0.9968653155065192, 0.42991509026093055`}, {0.567647342947829, 
      0.9967979841480825, 0.42915064120025354`}, {0.5683438894879921, 
      0.9967299546359948, 0.42838606514800265`}, {0.5690398647714392, 
      0.9966612275130817, 0.42762136274164253`}, {0.5697352687039126, 
      0.9965918033220429, 0.4268565346181304}, {0.5704301011915365, 
      0.9965216826054523, 0.42609158141391573`}, {0.5711243621408179, 
      0.9964508659057585, 0.42532650376494063`}, {0.5718180514586436, 
      0.9963793537652856, 0.42456130230664196`}, {0.5725111690522846, 
      0.9963071467262334, 0.4237959776739488}, {0.5732037148293931, 
      0.996234245330678, 0.4230305305012847}, {0.5738956886980043, 
      0.9961606501205721, 0.42226496142256764`}, {0.5745870905665355, 
      0.9960863616377459, 0.42149927107121044`}, {0.5752779203437862, 
      0.9960113804239074, 0.42073346008012114`}, {0.57596817793894, 
      0.9959357070206425, 0.4199675290817025}, {0.5766578632615628, 
      0.995859341969416, 0.4192014787078532}, {0.5773469762216034, 
      0.9957822858115717, 0.4184353095899684}, {0.578035516729394, 
      0.9957045390883333, 0.41766902235893927`}, {0.5787234846956506, 
      0.9956261023408044, 0.41690261764515385`}, {0.5794108800314716, 
      0.995546976109969, 0.4161360960784975}, {0.5800977026483405, 
      0.9954671609366924, 0.415369458288352}, {0.580783952458123, 
      0.9953866573617213, 0.4146027049035982}, {0.5814696293730701, 
      0.9953054659256839, 0.41383583655261363`}, {0.5821547333058157, 
      0.9952235871690915, 0.4130688538632759}, {0.5828392641693781, 
      0.9951410216323376, 0.4123017574629595}, {0.5835232218771601, 
      0.9950577698556994, 0.4115345479785392}, {0.5842066063429487, 
      0.9949738323793372, 0.4107672260363885}, {0.5848894174809149, 
      0.9948892097432961, 0.4099997922623813}, {0.585571655205615, 
      0.9948039024875054, 0.4092322472818904}, {0.5862533194319897, 
      0.9947179111517793, 0.40846459171978966`}, {0.5869344100753641, 
      0.9946312362758177, 0.40769682620045367`}, {0.5876149270514482, 
      0.9945438783992063, 0.40692895134775803`}, {0.5882948702763381, 
      0.9944558380614168, 0.40616096778507865`}, {0.5889742396665137, 
      0.9943671158018079, 0.4053928761352942}, {0.5896530351388405, 
      0.9942777121596253, 0.4046246770207848}, {0.5903312566105695, 
      0.9941876276740024, 0.4038563710634329}, {0.5910089039993368, 
      0.9940968628839602, 0.40308795888462323`}, {0.5916859772231641, 
      0.994005418328408, 0.4023194411052438}, {0.5923624762004591, 
      0.9939132945461445, 0.4015508183456853}, {0.5930384008500145, 
      0.9938204920758568, 0.40078209122584246`}, {0.5937137510910092, 
      0.9937270114561221, 0.4000132603651128}, {0.5943885268430077, 
      0.9936328532254071, 0.3992443263823993}, {0.5950627280259606, 
      0.9935380179220693, 0.39847528989610864`}, {0.5957363545602049, 
      0.9934425060843564, 0.39770615152415156`}, {0.5964094063664628, 
      0.9933463182504079, 0.3969369118839451}, {0.5970818833658436, 
      0.9932494549582543, 0.3961675715924106}, {0.5977537854798426, 
      0.9931519167458182, 0.39539813126597567`}, {0.5984251126303415, 
      0.9930537041509144, 0.3946285915205729}, {0.599095864739608, 
      0.9929548177112505, 0.3938589529716426}, {0.599766041730297, 
      0.9928552579644271, 0.39308921623412996`}, {0.6004356435254498, 
      0.9927550254479379, 0.3923193819224881}, {0.601104670048494, 
      0.992654120699171, 0.3915494506506769}, {0.6017731212232446, 
      0.9925525442554081, 0.39077942303216345`}, {0.6024409969739029, 
      0.9924502966538256, 0.39000929967992265`}, {0.6031082972250569, 
      0.9923473784314949, 0.389239081206438}, {0.6037750219016826, 
      0.9922437901253826, 0.3884687682236998}, {0.6044411709291423, 
      0.9921395322723505, 0.38769836134320823`}, {0.6051067442331847, 
      0.9920346054091573, 0.3869278611759725}, {0.6057717417399474, 
      0.991929010072457, 0.3861572683325096}, {0.6064361633759534, 
      0.991822746798801, 0.3853865834228476}, {0.6071000090681145, 
      0.9917158161246371, 0.3846158070565226}, {0.6077632787437292, 
      0.991608218586311, 0.3838449398425817}, {0.6084259723304828, 
      0.9914999547200656, 0.3830739823895828}, {0.609088089756449, 
      0.9913910250620424, 0.3823029353055933}, {0.6097496309500885, 
      0.9912814301482809, 0.3815317991981924}, {0.6104105958402498, 
      0.9911711705147194, 0.3807605746744695}, {0.6110709843561689, 
      0.9910602466971952, 0.37998926234102626`}, {0.6117307964274697, 
      0.9909486592314452, 0.3792178628039754}, {0.6123900319841636, 
      0.9908364086531057, 0.37844637666894204`}, {0.6130486909566498, 
      0.9907234954977133, 0.3776748045410634}, {0.613706773275715, 
      0.9906099203007049, 0.37690314702498984`}, {0.6143642788725344, 
      0.9904956835974181, 0.3761314047248837}, {0.6150212076786711, 
      0.9903807859230913, 0.3753595782444202}, {0.6156775596260752, 
      0.9902652278128645, 0.37458766818678935`}, {0.6163333346470856, 
      0.9901490098017793, 0.37381567515469366`}, {0.6169885326744294, 
      0.9900321324247792, 0.37304359975034956`}, {0.6176431536412215, 
      0.9899145962167097, 0.37227144257548833`}, {0.6182971974809645, 
      0.9897964017123195, 0.37149920423135496`}, {0.6189506641275496, 
      0.9896775494462595, 0.3707268853187099}, {0.6196035535152562, 
      0.9895580399530843, 0.3699544864378281}, {0.6202558655787517, 
      0.9894378737672517, 0.36918200818849994`}, {0.620907600253092, 
      0.9893170514231233, 0.3684094511700313}, {0.6215587574737208, 
      0.989195573454965, 0.3676368159812442}, {0.6222093371764708, 
      0.9890734403969469, 0.3668641032204761}, {0.6228593392975627, 
      0.9889506527831436, 0.36609131348558094`}, {0.6235087637736049, 
      0.9888272111475351, 0.36531844737393016`}, {0.6241576105415957, 
      0.9887031160240063, 0.36454550548241066`}, {0.6248058795389202, 
      0.9885783679463477, 0.36377248840742743`}, {0.625453570703353, 
      0.9884529674482557, 0.3629993967449027}, {0.6261006839730568, 
      0.9883269150633328, 0.362226231090276}, {0.6267472192865827, 
      0.988200211325088, 0.3614529920385053}, {0.6273931765828707, 
      0.9880728567669365, 0.3606796801840657}, {0.6280385558012486, 
      0.9879448519222009, 0.35990629612095226`}, {0.6286833568814334, 
      0.9878161973241109, 0.3591328404426775}, {0.6293275797635302, 
      0.9876868935058035, 0.35835931374227326`}, {0.629971224388033, 
      0.9875569410003238, 0.3575857166122907}, {0.6306142906958243, 
      0.9874263403406246, 0.3568120496448001}, {0.6312567786281749, 
      0.9872950920595671, 0.35603831343139214`}, {0.6318986881267449, 
      0.987163196689921, 0.3552645085631762}, {0.6325400191335817, 
      0.987030654764365, 0.3544906356307833}, {0.6331807715911228, 
      0.9868974668154867, 0.35371669522436383`}, {0.6338209454421938, 
      0.986763633375783, 0.3529426879335892}, {0.6344605406300082, 
      0.9866291549776605, 0.35216861434765206`}, {0.6350995570981692, 
      0.9864940321534355, 0.35139447505526616`}, {0.6357379947906682, 
      0.9863582654353343, 0.3506202706446661}, {0.6363758536518849, 
      0.9862218553554941, 0.34984600170360913`}, {0.6370131336265882, 
      0.986084802445962, 0.34907166881937374`}, {0.6376498346599354, 
      0.9859471072386964, 0.34829727257876075`}, {0.6382859566974723, 
      0.9858087702655663, 0.347522813568094}, {0.6389214996851338, 
      0.9856697920583527, 0.3467482923732188}, {0.6395564635692429, 
      0.9855301731487476, 0.3459737095795046}, {0.6401908482965117, 
      0.9853899140683547, 0.3451990657718429}, {0.6408246538140405, 
      0.9852490153486904, 0.34442436153464984`}, {0.6414578800693183, 
      0.9851074775211828, 0.34364959745186446`}, {0.6420905270102232, 
      0.9849653011171725, 0.3428747741069493}, {0.6427225945850213, 
      0.9848224866679132, 0.34209989208289177`}, {0.6433540827423682, 
      0.9846790347045711, 0.34132495196220297`}, {0.643984991431306, 
      0.9845349457582262, 0.3405499543269201}, {0.6446153206012684, 
      0.984390220359871, 0.3397748997586027}, {0.645245070202075, 
      0.9842448590404127, 0.33899978883833753`}, {0.6458742401839358, 
      0.9840988623306713, 0.33822462214673554`}, {0.6465028304974481, 
      0.9839522307613817, 0.3374494002639338}, {0.6471308410935981, 
      0.9838049648631928, 0.33667412376959466`}, {0.6477582719237608, 
      0.9836570651666677, 0.33589879324290695`}, {0.6483851229396993, 
      0.9835085322022848, 0.33512340926258544`}, {0.6490113940935657, 
      0.9833593665004369, 0.3343479724068712}, {0.6496370853378994, 
      0.9832095685914323, 0.3335724832535327}, {0.6502621966256299, 
      0.9830591390054944, 0.3327969423798645}, {0.6508867279100737, 
      0.9829080782727623, 0.33202135036268854`}, {0.6515106791449361, 
      0.9827563869232909, 0.33124570777835477`}, {0.6521340502843107, 
      0.9826040654870509, 0.3304700152027401}, {0.6527568412826801, 
      0.9824511144939294, 0.3296942732112492}, {0.653379052094914, 
      0.9822975344737298, 0.32891848237881566`}, {0.6540006826762714, 
      0.9821433259561717, 0.32814264327990017`}, {0.6546217329823993, 
      0.981988489470892, 0.3273667564884926}, {0.6552422029693321, 
      0.9818330255474444, 0.3265908225781122}, {0.6558620925934935, 
      0.9816769347152995, 0.32581484212180595`}, {0.6564814018116949, 
      0.9815202175038455, 0.32503881569215065`}, {0.6571001305811355, 
      0.9813628744423881, 0.3242627438612525}, {0.6577182788594035, 
      0.9812049060601505, 0.3234866272007471}, {0.6583358466044738, 
      0.9810463128862743, 0.32271046628180056`}, {0.6589528337747104, 
      0.9808870954498188, 0.32193426167510836`}, {0.659569240328865, 
      0.9807272542797614, 0.3211580139508964}, {0.6601850662260771, 
      0.9805667899049986, 0.3203817236789213}, {0.6608003114258744, 
      0.9804057028543448, 0.31960539142847044`}, {0.6614149758881718, 
      0.9802439936565338, 0.3188290177683619}, {0.6620290595732728, 
      0.9800816628402181, 0.3180526032669454}, {0.6626425624418683, 
      0.9799187109339695, 0.3172761484921014}, {0.663255484455037, 
      0.9797551384662794, 0.3164996540112423}, {0.6638678255742453, 
      0.9795909459655577, 0.31572312039131245`}, {0.6644795857613471, 
      0.9794261339601354, 0.31494654819878815`}, {0.6650907649785842, 
      0.9792607029782623, 0.31416993799967785`}, {0.665701363188586, 
      0.9790946535481084, 0.3133932903595224}, {0.6663113803543691, 
      0.9789279861977644, 0.31261660584339535`}, {0.6669208164393372, 
      0.9787607014552412, 0.31183988501590393`}, {0.6675296714072828, 
      0.9785927998484696, 0.3110631284411867}, {0.6681379452223842, 
      0.9784242819053018, 0.3102863366829175}, {0.6687456378492083, 
      0.9782551481535104, 0.3095095103043021}, {0.6693527492527082, 
      0.9780853991207895, 0.3087326498680813}, {0.6699592793982251, 
      0.9779150353347535, 0.30795575593652846`}, {0.6705652282514869, 
      0.9777440573229391, 0.3071788290714523}, {0.671170595778608, 
      0.977572465612804, 0.3064018698341958}, {0.6717753819460919, 
      0.9774002607317271, 0.3056248787856352}, {0.6723795867208266, 
      0.9772274432070099, 0.3048478564861832}, {0.6729832100700889, 
      0.9770540135658753, 0.3040708034957863}, {0.6735862519615413, 
      0.9768799723354683, 0.3032937203739269}, {0.6741887123632341, 
      0.9767053200428562, 0.30251660767962196`}, {0.6747905912436034, 
      0.9765300572150287, 0.30173946597142526`}, {0.6753918885714728, 
      0.976354184378898, 0.30096229580742506`}, {0.6759926043160521, 
      0.9761777020612988, 0.30018509774524665`}, {0.6765927384469382, 
      0.9760006107889888, 0.2994078723420506}, {0.6771922909341139, 
      0.9758229110886486, 0.2986306201545347}, {0.6777912617479488, 
      0.9756446034868814, 0.29785334173893263`}, {0.6783896508591988, 
      0.9754656885102144, 0.29707603765101565`}, {0.6789874582390063, 
      0.9752861666850976, 0.2962987084460912}, {0.6795846838588997, 
      0.9751060385379045, 0.2955213546790047}, {0.680181327690794, 
      0.9749253045949323, 0.2947439769041384}, {0.6807773897069896, 
      0.974743965382402, 0.2939665756754124}, {0.6813728698801741, 
      0.9745620214264588, 0.29318915154628444`}, {0.6819677681834203, 
      0.9743794732531706, 0.29241170506975017`}, {0.6825620845901869, 
      0.9741963213885311, 0.29163423679834405`}, {0.6831558190743187, 
      0.974012566358457, 0.29085674728413824`}, {0.6837489716100466, 
      0.9738282086887902, 0.2900792370787435}, {0.6843415421719864, 
      0.9736432489052965, 0.28930170673331007`}, {0.6849335307351404, 
      0.9734576875336667, 0.2885241567985262}, {0.685524937274896, 
      0.9732715250995162, 0.28774658782462004`}, {0.6861157617670259, 
      0.9730847621283852, 0.28696900036135925`}, {0.6867060041876891, 
      0.9728973991457388, 0.2861913949580497}, {0.6872956645134289, 
      0.9727094366769677, 0.2854137721635387}, {0.6878847427211746, 
      0.9725208752473872, 0.2846361325262125}, {0.6884732387882404, 
      0.9723317153822381, 0.2838584765939976}, {0.6890611526923254, 
      0.9721419576066868, 0.2830808049143613}, {0.6896484844115142, 
      0.9719516024458253, 0.2823031180343109}, {0.6902352339242763, 
      0.9717606504246706, 0.28152541650039437`}, {0.6908214012094656, 
      0.9715691020681668, 0.2807477008587011}, {0.6914069862463216, 
      0.9713769579011824, 0.27996997165486076`}, {0.6919919890144678, 
      0.9711842184485127, 0.27919222943404487`}, {0.6925764094939123, 
      0.9709908842348791, 0.2784144747409667}, {0.6931602476650485, 
      0.9707969557849289, 0.27763670811988034`}, {0.6937435035086535, 
      0.9706024336232357, 0.2768589301145821}, {0.6943261770058892, 
      0.9704073182743, 0.27608114126841077`}, {0.6949082681383015, 
      0.9702116102625481, 0.2753033421242465}, {0.695489776887821, 
      0.9700153101123334, 0.2745255332245123}, {0.696070703236762, 
      0.9698184183479355, 0.27374771511117346`}, {0.6966510471678229, 
      0.9696209354935615, 0.27296988832573865`}, {0.6972308086640863, 
      0.9694228620733449, 0.27219205340925867`}, {0.697809987709018, 
      0.9692241986113465, 0.2714142109023283}, {0.6983885842864684, 
      0.9690249456315534, 0.270636361345085}, {0.698966598380671, 
      0.968825103657881, 0.26985850527720984`}, {0.6995440299762434, 
      0.9686246732141711, 0.2690806432379277}, {0.7001208790581862, 
      0.9684236548241933, 0.26830277576600703`}, {0.7006971456118838, 
      0.9682220490116445, 0.26752490339976076`}, {0.7012728296231034, 
      0.9680198563001491, 0.26674702667704553`}, {0.7018479310779959, 
      0.9678170772132592, 0.2659691461352632}, {0.7024224499630951, 
      0.9676137122744546, 0.26519126231135937`}, {0.7029963862653184, 
      0.9674097620071427, 0.26441337574182416`}, {0.7035697399719648, 
      0.9672052269346588, 0.263635486962694}, {0.7041425110707178, 
      0.9670001075802668, 0.2628575965095489}, {0.7047146995496422, 
      0.9667944044671575, 0.2620797049175153}, {0.705286305397186, 
      0.9665881181184508, 0.26130181272126485`}, {0.7058573286021802, 
      0.9663812490571944, 0.2605239204550142}, {0.7064277691538378, 
      0.9661737978063643, 0.25974602865252633`}, {0.7069976270417542, 
      0.9659657648888643, 0.2589681378471101}, {0.7075669022559069, 
      0.965757150827528, 0.258190248571621}, {0.7081355947866559, 
      0.965547956145116, 0.25741236135846013`}, {0.7087037046247426, 
      0.9653381813643185, 0.2566344767395758}, {0.7092712317612914, 
      0.9651278270077538, 0.25585659524646237`}, {0.7098381761878075, 
      0.9649168935979691, 0.25507871741016147`}, {0.7104045378961783, 
      0.9647053816574405, 0.25430084376126194`}, {0.7109703168786732, 
      0.9644932917085725, 0.2535229748298992}, {0.711535513127942, 
      0.9642806242736993, 0.2527451111457571}, {0.7121001266370176, 
      0.9640673798750833, 0.25196725323806557`}, {0.7126641573993123, 
      0.9638535590349165, 0.2511894016356042}, {0.7132276054086212, 
      0.96363916227532, 0.2504115568666987}, {0.7137904706591197, 
      0.9634241901183436, 0.24963371945922364`}, {0.7143527531453646, 
      0.9632086430859665, 0.24885588994060187`}, {0.714914452862293, 
      0.962992521700098, 0.24807806883780484`}, {0.7154755698052235, 
      0.9627758264825756, 0.24730025667735198`}, {0.7160361039698551, 
      0.9625585579551671, 0.2465224539853119}, {0.7165960553522668, 
      0.9623407166395694, 0.2457446612873025}, {0.7171554239489188, 
      0.962122303057409, 0.24496687910849008`}, {0.7177142097566518, 
      0.9619033177302422, 0.2441891079735903}, {0.7182724127726858, 
      0.9616837611795547, 0.24341134840686862`}, {0.7188300329946214, 
      0.9614636339267619, 0.24263360093214045`}, {0.7193870704204397, 
      0.9612429364932094, 0.2418558660727695}, {0.7199435250485009, 
      0.9610216694001721, 0.24107814435167113`}, {0.7204993968775453, 
      0.9607998331688551, 0.24030043629130976`}, {0.7210546859066929, 
      0.9605774283203934, 0.23952274241370047`}, {0.7216093921354434, 
      0.9603544553758521, 0.2387450632404085}, {0.7221635155636756, 
      0.9601309148562258, 0.23796739929255015`}, {0.7227170561916475, 
      0.9599068072824399, 0.23718975109079218`}, {0.723270014019997, 
      0.9596821331753493, 0.23641211915535223`}, {0.7238223890497406, 
      0.9594568930557396, 0.235634504005999}, {0.7243741812822734, 
      0.9592310874443265, 0.23485690616205288`}, {0.7249253907193702, 
      0.9590047168617554, 0.23407932614238502`}, {0.7254760173631839, 
      0.9587777818286026, 0.2333017644654187}, {0.7260260612162464, 
      0.9585502828653749, 0.2325242216491287}, {0.7265755222814673, 
      0.9583222204925091, 0.23174669821104182`}, {0.7271244005621356, 
      0.9580935952303726, 0.23096919466823704`}, {0.7276726960619178, 
      0.9578644075992632, 0.23019171153734533`}, {0.728220408784859, 
      0.9576346581194092, 0.22941424933455007`}, {0.7287675387353822, 
      0.9574043473109695, 0.22863680857558707`}, {0.7293140859182882, 
      0.9571734756940337, 0.22785938977574546`}, {0.7298600503387552, 
      0.9569420437886218, 0.22708199344986657`}, {0.7304054320023395, 
      0.9567100521146849, 0.2263046201123451}, {0.7309502309149749, 
      0.9564775011921042, 0.22552727027712927`}, {0.7314944470829724, 
      0.9562443915406921, 0.22474994445771962`}, {0.7320380805130202, 
      0.9560107236801917, 0.22397264316717141`}, {0.7325811312121842, 
      0.9557764981302768, 0.2231953669180924}, {0.7331235991879061, 
      0.9555417154105518, 0.2224181162226457}, {0.7336654844480058, 
      0.9553063760405527, 0.2216408915925469}, {0.734206787000679, 
      0.9550704805397457, 0.22086369353906657`}, {0.7347475068544987, 
      0.9548340294275283, 0.22008652257302924`}, {0.7352876440184145, 
      0.9545970232232284, 0.21930937920481386`}, {0.7358271985017512, 
      0.9543594624461056, 0.21853226394435432`}, {0.7363661703142107, 
      0.9541213476153504, 0.21775517730113955`}, {0.7369045594658713, 
      0.9538826792500837, 0.21697811978421247`}, {0.7374423659671864, 
      0.9536434578693586, 0.21620109190217213`}, {0.7379795898289863, 
      0.9534036839921577, 0.2154240941631715}, {0.7385162310624761, 
      0.9531633581373964, 0.21464712707492023`}, {0.7390522896792368, 
      0.9529224808239201, 0.21387019114468317`}, {0.7395877656912249, 
      0.9526810525705056, 0.21309328687928064`}, {0.7401226591107725, 
      0.9524390738958611, 0.2123164147850885}, {0.7406569699505864, 
      0.9521965453186259, 0.2115395753680394}, {0.7411906982237486, 
      0.9519534673573703, 0.2107627691336217}, {0.7417238439437159, 
      0.9517098405305963, 0.20998599658688033`}, {0.7422564071243204, 
      0.9514656653567365, 0.20920925823241612`}, {0.7427883877797679, 
      0.9512209423541557, 0.20843255457438775`}, {0.7433197859246401, 
      0.950975672041149, 0.20765588611650873`}, {0.7438506015738918, 
      0.9507298549359432, 0.20687925336205126`}, {0.7443808347428524, 
      0.9504834915566966, 0.20610265681384407`}, {0.744910485447226, 
      0.9502365824214988, 0.20532609697427257`}, {0.7454395537030896, 
      0.9499891280483705, 0.2045495743452807}, {0.7459680395268953, 
      0.9497411289552636, 0.2037730894283682}, {0.7464959429354676, 
      0.9494925856600622, 0.20299664272459447`}, {0.7470232639460054, 
      0.9492434986805809, 0.20222023473457543`}, {0.747550002576081, 
      0.9489938685345661, 0.2014438659584852}, {0.7480761588436392, 
      0.9487436957396957, 0.20066753689605646`}, {0.7486017327669988, 
      0.9484929808135788, 0.19989124804657987`}, {0.7491267243648516, 
      0.9482417242737554, 0.199114999908904}, {0.7496511336562613, 
      0.9479899266376985, 0.19833879298143703`}, {0.7501749606606654, 
      0.9477375884228109, 0.19756262776214542`}, {0.7506982053978734, 
      0.9474847101464274, 0.19678650474855403`}, {0.7512208678880673, 
      0.9472312923258148, 0.19601042443774738`}, {0.7517429481518014, 
      0.9469773354781704, 0.1952343873263689}, {0.7522644462100023, 
      0.9467228401206238, 0.1944583939106214}, {0.7527853620839683, 
      0.9464678067702356, 0.19368244468626722`}, {0.7533056957953699, 
      0.9462122359439976, 0.19290654014862782`}, {0.7538254473662489, 
      0.945956128158834, 0.19213068079258525`}, {0.754344616819019, 
      0.9456994839315996, 0.19135486711258062`}, {0.7548632041764655, 
      0.9454423037790811, 0.1905790996026155}, {0.7553812094617444, 
      0.9451845882179962, 0.18980337875625192`}, {0.755898632698383, 
      0.9449263377649947, 0.18902770506661168`}, {0.7564154739102801, 
      0.9446675529366577, 0.1882520790263775}, {0.7569317331217048, 
      0.9444082342494973, 0.1874765011277924}, {0.7574474103572967, 
      0.9441483822199576, 0.1867009718626607}, {0.7579625056420671, 
      0.9438879973644135, 0.18592549172234632`}, {0.7584770190013962, 
      0.9436270801991725, 0.18515006119777636`}, {0.7589909504610352, 
      0.9433656312404725, 0.18437468077943725`}, {0.7595043000471057, 
      0.9431036510044831, 0.18359935095737742`}, {0.7600170677860985, 
      0.9428411400073058, 0.18282407222120733`}, {0.7605292537048748, 
      0.9425780987649728, 0.18204884506009802`}, {0.761040857830665, 
      0.9423145277934483, 0.1812736699627832}, {0.7615518801910698, 
      0.9420504276086278, 0.18049854741755791`}, {0.7620623208140581, 
      0.9417857987263378, 0.17972347791227963`}, {0.7625721797279686, 
      0.941520641662337, 0.1789484619343682}, {0.7630814569615099, 
      0.9412549569323145, 0.1781734999708046}, {0.7635901525437576, 
      0.9409887450518917, 0.17739859250813414`}, {0.7640982665041575, 
      0.9407220065366211, 0.17662374003246362`}, {0.7646057988725233, 
      0.9404547419019861, 0.1758489430294626}, {0.7651127496790381, 
      0.9401869516634018, 0.17507420198436374`}, {0.7656191189542522, 
      0.9399186363362148, 0.17429951738196267`}, {0.7661249067290841, 
      0.9396497964357031, 0.17352488970661883`}, {0.7666301130348212, 
      0.9393804324770753, 0.17275031944225386`}, {0.7671347379031178, 
      0.9391105449754715, 0.17197580707235377`}, {0.7676387813659963, 
      0.9388401344459644, 0.17120135307996803`}, {0.7681422434558466, 
      0.938569201403556, 0.17042695794770923`}, {0.7686451242054257, 
      0.9382977463631808, 0.16965262215775476`}, {0.7691474236478584, 
      0.938025769839704, 0.1688783461918454}, {0.769649141816636, 
      0.937753272347922, 0.16810413053128603`}, {0.7701502787456165, 
      0.9374802544025633, 0.16732997565694674`}, {0.7706508344690252, 
      0.9372067165182864, 0.1665558820492612}, {0.7711508090214538, 
      0.9369326592096815, 0.1657818501882276}, {0.7716502024378605, 
      0.93665808299127, 0.16500788055340926`}, {0.7721490147535697, 
      0.936382988377504, 0.16423397362393422`}, {0.7726472460042715, 
      0.9361073758827672, 0.16346012987849554`}, {0.7731448962260227, 
      0.9358312460213739, 0.16268634979535126`}, {0.7736419654552453, 
      0.9355545993075702, 0.16191263385232482`}, {0.774138453728727, 
      0.9352774362555324, 0.1611389825268054}, {0.7746343610836214, 
      0.9349997573793685, 0.16036539629574695`}, {0.7751296875574469, 
      0.9347215631931166, 0.15959187563566973`}, {0.7756244331880873, 
      0.934442854210747, 0.1588184210226596}, {0.7761185980137915, 
      0.93416363094616, 0.1580450329323684}, {0.7766121820731732, 
      0.9338838939131868, 0.15727171184001365`}, {0.77710518540521, 
      0.9336036436255903, 0.1564984582203801}, {0.7775976080492455, 
      0.9333228805970631, 0.1557252725478176}, {0.7780894500449864, 
      0.9330416053412299, 0.15495215529624343`}, {0.7785807114325041, 
      0.9327598183716455, 0.15417910693914114`}, {0.7790713922522341, 
      0.932477520201795, 0.1534061279495608}, {0.779561492544975, 
      0.9321947113450952, 0.15263321880012024`}, {0.7800510123518902, 
      0.9319113923148935, 0.15186037996300322`}, {0.7805399517145062, 
      0.9316275636244675, 0.1510876119099612}, {0.7810283106747127, 
      0.9313432257870257, 0.15031491511231299`}, {0.7815160892747626, 
      0.9310583793157073, 0.14954229004094466`}, {0.7820032875572718, 
      0.9307730247235821, 0.14876973716631026`}, {0.7824899055652195, 
      0.9304871625236504, 0.14799725695843094`}, {0.7829759433419472, 
      0.930200793228843, 0.14722484988689588`}, {0.7834614009311593, 
      0.9299139173520216, 0.1464525164208622}, {0.7839462783769222, 
      0.9296265354059778, 0.14568025702905535`}, {0.7844305757236649, 
      0.9293386479034339, 0.14490807217976887`}, {0.7849142930161779, 
      0.929050255357043, 0.1441359623408649}, {0.7853974302996143, 
      0.9287613582793875, 0.1433639279797732}, {0.7858799876194882, 
      0.9284719571829819, 0.1425919695634935}, {0.7863619650216761, 
      0.9281820525802691, 0.141820087558593}, {0.7868433625524148, 
      0.9278916449836236, 0.14104828243120865`}, {0.7873241802583036, 
      0.9276007349053497, 0.14027655464704586`}, {0.7878044181863018, 
      0.9273093228576816, 0.13950490467137974`}, {0.7882840763837299, 
      0.9270174093527842, 0.13873333296905416`}, {0.7887631548982693, 
      0.9267249949027523, 0.1379618400044829}, {0.789241653777962, 
      0.9264320800196107, 0.1371904262416487}, {0.7897195730712097, 
      0.9261386652153146, 0.1364190921441049}, {0.7901969128267751, 
      0.9258447510017487, 0.1356478381749737}, {0.7906736730937809, 
      0.925550337890728, 0.13487666479694713`}, {0.7911498539217091, 
      0.9252554263939977, 0.13410557247228838`}, {0.7916254553604017, 
      0.9249600170232319, 0.13333456166283017`}, {0.7921004774600607, 
      0.9246641102900359, 0.132563632829975}, {0.7925749202712465, 
      0.9243677067059437, 0.13179278643469716`}, {0.7930487838448794, 
      0.9240708067824199, 0.1310220229375404}, {0.7935220682322388, 
      0.9237734110308582, 0.13025134279861925`}, {0.7939947734849621, 
      0.9234755199625826, 0.12948074647762034`}, {0.7944668996550466, 
      0.9231771340888458, 0.1287102344337992}, {0.7949384467948469, 
      0.9228782539208313, 0.12793980712598427`}, {0.795409414957077, 
      0.9225788799696514, 0.12716946501257417`}, {0.7958798041948081, 
      0.9222790127463479, 0.12639920855153977`}, {0.7963496145614702, 
      0.9219786527618926, 0.12562903820042226`}, {0.7968188461108505, 
      0.9216778005271864, 0.12485895441633582`}, {0.7972874988970945, 
      0.9213764565530596, 0.12408895765596487`}, {0.7977555729747045, 
      0.9210746213502714, 0.12331904837556693`}, {0.7982230683985401, 
      0.9207722954295113, 0.12254922703097122`}, {0.7986899852238187, 
      0.9204694793013971, 0.12177949407757829`}, {0.7991563235061141, 
      0.9201661734764767, 0.12100984997036249`}, {0.7996220833013571, 
      0.9198623784652262, 0.12024029516386903`}, {0.800087264665835, 
      0.9195580947780517, 0.11947083011221647`}, {0.8005518676561914, 
      0.9192533229252875, 0.11870145526909595`}, {0.8010158923294266, 
      0.9189480634171973, 0.1179321710877707}, {0.8014793387428966, 
      0.9186423167639743, 0.11716297802107754`}, {0.8019422069543131, 
      0.9183360834757397, 0.1163938765214266}, {0.8024044970217439, 
      0.9180293640625443, 0.11562486704080033`}, {0.8028662090036125, 
      0.9177221590343673, 0.1148559500307547}, {0.8033273429586972, 
      0.9174144689011168, 0.11408712594241958`}, {0.8037878989461322, 
      0.9171062941726297, 0.11331839522649736`}, {0.8042478770254058, 
      0.9167976353586712, 0.1125497583332654}, {0.8047072772563624, 
      0.916488492968936, 0.11178121571257336`}, {0.8051660996991997, 
      0.9161788675130461, 0.11101276781384625`}, {0.805624344414471, 
      0.915868759500553, 0.11024441508608192`}, {0.8060820114630831, 
      0.9155581694409364, 0.10947615797785316`}, {0.8065391009062974, 
      0.9152470978436043, 0.10870799693730662`}, {0.8069956128057293, 
      0.914935545217893, 0.10793993241216362`}, {0.8074515472233478, 
      0.9146235120730674, 0.10717196484971954`}, {0.8079069042214752, 
      0.9143109989183206, 0.1064040946968452}, {0.808361683862788, 
      0.9139980062627732, 0.10563632239998517`}, {0.8088158862103152, 
      0.9136845346154752, 0.10486864840515997`}, {0.8092695113274392, 
      0.9133705844854038, 0.10410107315796435`}, {0.8097225592778955, 
      0.9130561563814641, 0.10333359710356853`}, {0.8101750301257714, 
      0.9127412508124899, 0.10256622068671847`}, {0.8106269239355083, 
      0.9124258682872424, 0.10179894435173416`}, {0.811078240771898, 
      0.9121100093144111, 0.10103176854251303`}, {0.8115289807000863, 
      0.9117936744026127, 0.10026469370252632`}, {0.8119791437855696, 
      0.9114768640603922, 0.09949772027482257}, {0.8124287300941971, 
      0.9111595787962219, 0.09873084870202468}, {0.8128777396921687, 
      0.9108418191185019, 0.09796407942633312}, {0.8133261726460369, 
      0.9105235855355603, 0.09719741288952337}, {0.8137740290227043, 
      0.9102048785556519, 0.0964308495329474}, {0.8142213088894253, 
      0.9098856986869596, 0.0956643897975343}, {0.8146680123138048, 
      0.9095660464375934, 0.09489803412378861}, {0.8151141393637987, 
      0.9092459223155912, 0.09413178295179243}, {0.8155596901077136, 
      0.9089253268289172, 0.09336563672120365}, {0.8160046646142058, 
      0.9086042604854642, 0.09259959587125823}, {0.8164490629522825, 
      0.9082827237930506, 0.09183366084076787}, {0.8168928851913002, 
      0.9079607172594228, 0.09106783206812251}, {0.8173361314009658, 
      0.9076382413922546, 0.09030210999128853}, {0.8177788016513357, 
      0.9073152966991459, 0.08953649504781026}, {0.8182208960128153, 
      0.9069918836876243, 0.08877098767480894}, {0.8186624145561596, 
      0.9066680028651437, 0.08800558830898389}, {0.8191033573524733, 
      0.9063436547390853, 0.08724029738661196}, {0.8195437244732084, 
      0.9060188398167566, 0.08647511534354814}, {0.8199835159901675, 
      0.9056935586053921, 0.08571004261522462}, {0.8204227319755003, 
      0.9053678116121532, 0.08494507963665283}, {0.8208613725017052, 
      0.9050415993441271, 0.08418022684242178}, {0.8212994376416292, 
      0.9047149223083277, 0.08341548466669844}, {0.8217369274684667, 
      0.9043877810116959, 0.0826508535432292}, {0.8221738420557606, 
      0.9040601759610988, 0.08188633390533817}, {0.8226101814774004, 
      0.9037321076633292, 0.08112192618592846}, {0.823045945807624, 
      0.9034035766251066, 0.08035763081748258}, {0.8234811351210157, 
      0.9030745833530771, 0.07959344823206109}, {0.8239157494925079, 
      0.9027451283538118, 0.07882937886130392}, {0.8243497889973784, 
      0.9024152121338089, 0.07806542313643063}, {0.824783253711253, 
      0.9020848351994927, 0.0773015814882395}, {0.8252161437101034, 
      0.9017539980572122, 0.07653785434710891}, {0.8256484590702475, 
      0.9014227012132436, 0.07577424214299575}, {0.8260801998683498, 
      0.9010909451737876, 0.07501074530543772}, {0.8265113661814203, 
      0.900758730444972, 0.07424736426355148}, {0.8269419580868148, 
      0.9004260575328493, 0.07348409944603443}, {0.827371975662235, 
      0.9000929269433979, 0.07272095128116289}, {0.8278014189857271, 
      0.8997593391825217, 0.07195792019679469}, {0.8282302881356838, 
      0.8994252947560506, 0.07119500662036653}, {0.8286585831908417, 
      0.8990907941697384, 0.07043221097889642}, {0.829086304230283, 
      0.898755837929266, 0.06966953369898304}, {0.8295134513334336, 
      0.8984204265402387, 0.06890697520680503}, {0.8299400245800647, 
      0.8980845605081866, 0.06814453592812213}, {0.830366024050291, 
      0.8977482403385659, 0.06738221628827475}, {0.8307914498245724, 
      0.8974114665367573, 0.06662001671218462}, {0.8312163019837117, 
      0.8970742396080659, 0.06585793762435431}, {0.8316405806088553, 
      0.8967365600577233, 0.06509597944886795}, {0.8320642857814937, 
      0.8963984283908843, 0.06433414260939058}, {0.8324874175834605, 
      0.8960598451126296, 0.0635724275291691}, {0.8329099760969318, 
      0.8957208107279642, 0.06281083463103226}, {0.8333319614044283, 
      0.8953813257418173, 0.06204936433738899}, {0.8337533735888112, 
      0.895041390659044, 0.06128801707023231}, {0.8341742127332863, 
      0.8947010059844216, 0.060526793251135344`}, {0.8345944789214004, 
      0.894360172222655, 0.05976569330125434}, {0.8350141722370429, 
      0.8940188898783702, 0.059004717641327115`}, {0.8354332927644451, 
      0.8936771594561201, 0.05824386669167473}, {0.8358518405881808, 
      0.8933349814603799, 0.057483140872198885`}, {0.8362698157931643, 
      0.8929923563955504, 0.05672254060238613}, {0.8366872184646521, 
      0.8926492847659557, 0.05596206630130359}, {0.8371040486882413, 
      0.8923057670758441, 0.05520171838760274}, {0.8375203065498706, 
      0.8919618038293878, 0.054441497279517005`}, {0.8379359921358196, 
      0.8916173955306828, 0.05368140339486303}, {0.8383511055327082, 
      0.8912725426837487, 0.05292143715104059}, {0.8387656468274965, 
      0.8909272457925297, 0.052161598965033036`}, {0.8391796161074857, 
      0.8905815053608928, 0.05140188925340693}, {0.8395930134603165, 
      0.8902353218926284, 0.05064230843231195}, {0.8400058389739694, 
      0.8898886958914515, 0.04988285691748191}, {0.8404180927367652, 
      0.8895416278609992, 0.04912353512423385}, {0.8408297748373635, 
      0.8891941183048327, 0.04836434346746934}, {0.8412408853647639, 
      0.8888461677264372, 0.04760528236167323}, {0.8416514244083045, 
      0.8884977766292195, 0.046846352220914815`}, {0.842061392057663, 
      0.8881489455165101, 0.04608755345884722}, {0.8424707884028548, 
      0.8877996748915638, 0.045328886488708746`}, {0.8428796135342352, 
      0.8874499652575564, 0.044570351723321036`}, {0.8432878675424968, 
      0.8870998171175879, 0.043811949575090985`}, {0.8436955505186711, 
      0.8867492309746812, 0.04305368045600997}, {0.844102662554127, 
      0.8863982073317811, 0.042295544777654154`}, {0.8445092037405714, 
      0.886046746691756, 0.04153754295118447}, {0.844915174170049, 
      0.885694849557396, 0.040779675387346934`}, {0.8453205739349418, 
      0.8853425164314147, 0.040021942496472895`}, {0.8457254031279685, 
      0.8849897478164473, 0.03926434468847885}, {0.8461296618421859, 
      0.8846365442150524, 0.03850688237286654}, {0.8465333501709864, 
      0.88428290612971, 0.03774955595872359}, {0.8469364682081, 
      0.8839288340628222, 0.03699236585472232}, {0.8473390160475924, 
      0.8835743285167147, 0.03623531246912208}, {0.8477409937838664, 
      0.8832193899936331, 0.035478396209766803`}, {0.8481424015116599, 
      0.8828640189957474, 0.03472161748408736}, {0.8485432393260472, 
      0.8825082160251473, 0.0339649766990999}, {0.8489435073224385, 
      0.8821519815838461, 0.033208474261407606`}, {0.8493432055965787, 
      0.8817953161737782, 0.03245211057719905}, {0.8497423342445489, 
      0.8814382202967986, 0.0316958860522497}, {0.8501408933627645, 
      0.8810806944546866, 0.03093980109192217}, {0.8505388830479764, 
      0.8807227391491406, 0.030183856101164187`}, {0.8509363033972696, 
      0.8803643548817816, 0.029428051484511965`}, {0.8513331545080638, 
      0.8800055421541512, 0.02867238764608733}, {0.8517294364781136, 
      0.8796463014677136, 0.02791686498959985}, {0.8521251494055069, 
      0.8792866333238529, 0.02716148391834623}, {0.8525202933886663, 
      0.8789265382238755, 0.026406244835209133`}, {0.852914868526347, 
      0.878566016669008, 0.025651148142660955`}, {0.853308874917639, 
      0.8782050691603984, 0.024896194242759278`}, {0.8537023126619648, 
      0.8778436961991153, 0.024141383537150448`}, {0.854095181859081, 
      0.8774818982861492, 0.02338671642706818}, {0.8544874826090753, 
      0.8771196759224097, 0.022632193313334385`}, {0.8548792150123702, 
      0.8767570296087286, 0.021877814596358416`}, {0.8552703791697194, 
      0.8763939598458578, 0.02112358067613812}, {0.85566097518221, 
      0.876030467134469, 0.020369491952259053`}, {0.8560510031512604, 
      0.8756665519751559, 0.019615548823895337`}, {0.8564404631786214, 
      0.8753022148684307, 0.01886175168980929}, {0.8568293553663752, 
      0.8749374563147277, 0.0181081009483527}, {0.8572176798169362, 
      0.8745722768144005, 0.01735459699746437}, {0.8576054366330498, 
      0.8742066768677227, 0.01660124023467284}, {0.8579926259177926, 
      0.8738406569748883, 0.015848031057095605`}, {0.8583792477745724, 
      0.873474217636011, 0.015094969861438517`}, {0.8587653023071274, 
      0.8731073593511252, 0.01434205704399768}, {0.8591507896195271, 
      0.872740082620184, 0.01358929300065678}, {0.8595357098161708, 
      0.8723723879430609, 0.012836678126890246`}, {0.8599200630017877, 
      0.8720042758195493, 0.012084212817761389`}, {0.8603038492814385, 
      0.8716357467493612, 0.01133189746792265}, {0.8606870687605122, 
      0.8712668012321291, 0.01057973247161709}, {0.8610697215447279, 
      0.8708974397674046, 0.009827718222676736}, {0.8614518077401347, 
      0.8705276628546587, 0.00907585511452408}, {0.86183332745311, 
      0.8701574709932813, 0.00832414354017105}, {0.8622142807903609, 
      0.8697868646825819, 0.007572583892220934}, {0.8625946678589232, 
      0.8694158444217888, 0.006821176562865454}, {0.8629744887661617, 
      0.8690444107100497, 0.006069921943887947}, {0.8633537436197682, 
      0.8686725640464308, 0.005318820426662546}, {0.8637324325277649, 
      0.8683003049299176, 0.004567872402152729}, {0.8641105555985004, 
      0.8679276338594138, 0.003817078260913448}, {0.864488112940652, 
      0.8675545513337428, 0.0030664383930907274`}, {0.8648651046632243, 
      0.8671810578516456, 0.0023159531884210517`}, {0.8652415308755498, 
      0.866807153911782, 0.0015656230362322296`}, {0.8656173916872877, 
      0.8664328400127302, 0.000815448325442574}, {0.8659926872084242, 
      0.8660581166529879, 0.00006542944456344141}, {0.8663674175492735, 
      0.8656829843309687, 0.0006844332183047444}, {0.8667415828204754, 
      0.8653074435450073, 0.0014341392754682668`}, {0.8671151831329963, 
      0.8649314947933541, 0.0021836883396424136`}, {0.8674882185981293, 
      0.8645551385741788, 0.002933080023950408}, {0.8678606893274932, 
      0.8641783753855689, 0.0036823139419242335`}, {0.8682325954330332, 
      0.8638012057255297, 0.004431389707503567}, {0.8686039370270198, 
      0.8634236300919844, 0.005180306935035554}, {0.8689747142220491, 
      0.8630456489827735, 0.00592906523927563}, {0.8693449271310424, 
      0.8626672628956555, 0.006677664235386886}, {0.8697145758672463, 
      0.8622884723283069, 0.007426103538939624}, {0.8700836605442321, 
      0.8619092777783205, 0.008174382765911975}, {0.8704521812758962, 
      0.8615296797432076, 0.008922501532688846}, {0.8708201381764591, 
      0.8611496787203962, 0.009670459456063157}, {0.8711875313604658, 
      0.8607692752072317, 0.010418256153234155`}, {0.8715543609427855, 
      0.8603884697009767, 0.011165891241808874`}, {0.8719206270386111, 
      0.8600072626988114, 0.011913364339799804`}, {0.8722863297634593, 
      0.8596256546978317, 0.012660675065627628`}, {0.8726514692331707, 
      0.8592436461950518, 0.01340782303811931}, {0.8730160455639088, 
      0.8588612376874012, 0.014154807876507882`}, {0.8733800588721602, 
      0.8584784296717275, 0.014901629200432849`}, {0.8737435092747344, 
      0.8580952226447945, 0.01564828662994018}, {0.8741063968887647, 
      0.857711617103282, 0.01639477978548275}, {0.8744687218317053, 
      0.8573276135437874, 0.017141108287917966`}, {0.8748304842213334, 
      0.8569432124628239, 0.017887271758509713`}, {0.8751916841757494, 
      0.8565584143568206, 0.01863326981892893}, {0.8755523218133737, 
      0.8561732197221236, 0.01937910209125027}, {0.8759123972529501, 
      0.8557876290549943, 0.02012476819795567}, {0.876271910613543, 
      0.8554016428516118, 0.02087026776193137}, {0.8766308620145387, 
      0.8550152616080691, 0.021615600406469856`}, {0.8769892515756444, 
      0.8546284858203763, 0.022360765755268124`}, {0.8773470794168885, 
      0.8542413159844594, 0.023105763432429385`}, {0.8777043456586194, 
      0.8538537525961596, 0.0238505930624597}, {0.8780610504215073, 
      0.8534657961512343, 0.02459525427027302}, {0.8784171938265414, 
      0.8530774471453563, 0.025339746681185497`}, {0.8787727759950323, 
      0.8526887060741132, 0.02608406992091908}, {0.8791277970486097, 
      0.8522995734330093, 0.02682822361560023}, {0.8794822571092239, 
      0.8519100497174633, 0.027572207391760573`}, {0.8798361562991436, 
      0.8515201354228097, 0.028316020876334155`}, {0.880189494740958, 
      0.8511298310442974, 0.029059663696660593`}, {0.8805422725575748, 
      0.850739137077091, 0.02980313548048383}, {0.8808944898722211, 
      0.8503480540162702, 0.03054643585595088}, {0.8812461468084424, 
      0.8499565823568294, 0.03128956445161325}, {0.8815972434901033, 
      0.8495647225936772, 0.032032520896426206`}, {0.8819477800413859, 
      0.8491724752216381, 0.03277530481974781}, {0.8822977565867915, 
      0.8487798407354508, 0.03351791585134092}, {0.8826471732511391, 
      0.848386819629768, 0.034260353621371045`}, {0.8829960301595647, 
      0.8479934123991574, 0.0350026177604072}, {0.8833443274375229, 
      0.8475996195381021, 0.03574470789942084}, {0.8836920652107854, 
      0.8472054415409975, 0.03648662366978782}, {0.8840392436054406, 
      0.8468108789021547, 0.037228364703286}, {0.8843858627478948, 
      0.8464159321157985, 0.037969930632096194`}, {0.88473192276487, 
      0.8460206016760676, 0.038711321088802285`}, {0.8850774237834057, 
      0.8456248880770161, 0.039452535706389846`}, {0.8854223659308578, 
      0.8452287918126093, 0.04019357411824862}, {0.8857667493348976, 
      0.8448323133767287, 0.04093443595816921}, {0.8861105741235135, 
      0.8444354532631688, 0.041675120860344694`}, {0.8864538404250084, 
      0.8440382119656377, 0.042415628459370754`}, {0.8867965483680015, 
      0.8436405899777573, 0.043155958390244505`}, {0.8871386980814282, 
      0.8432425877930623, 0.04389611028836629}, {0.887480289694538, 
      0.8428442059050014, 0.0446360837895367}, {0.8878213233368957, 
      0.8424454448069372, 0.04537587852995869}, {0.8881617991383807, 
      0.8420463049921443, 0.046115494146236335`}, {0.8885017172291877, 
      0.8416467869538115, 0.046854930275376544`}, {0.8888410777398252, 
      0.8412468911850399, 0.04759418655478528}, {0.889179880801116, 
      0.8408466181788443, 0.04833326262227152}, {0.8895181265441975, 
      0.8404459684281526, 0.04907215811604483}, {0.8898558151005199, 
      0.840044942425804, 0.04981087267471597}, {0.890192946601848, 
      0.8396435406645526, 0.050549405937295615`}, {0.8905295211802595, 
      0.8392417636370633, 0.05128775754319633}, {0.8908655389681454, 
      0.8388396118359146, 0.05202592713223086}, {0.8912010000982098, 
      0.8384370857535973, 0.05276391434461255}, {0.8915359047034698, 
      0.8380341858825147, 0.05350171882095523}, {0.8918702529172545, 
      0.8376309127149827, 0.05423934020227212}, {0.8922040448732066, 
      0.8372272667432282, 0.054976778129978324`}, {0.8925372807052796, 
      0.8368232484593919, 0.05571403224588763}, {0.8928699605477399, 
      0.8364188583555261, 0.05645110219221387}, {0.8932020845351659, 
      0.8360140969235943, 0.05718798761157182}, {0.8935336528024472, 
      0.8356089646554733, 0.0579246881469743}, {0.8938646654847849, 
      0.8352034620429496, 0.058661203441835105`}, {0.8941951227176913, 
      0.834797589577725, 0.059397533139966756`}, {0.8945250246369906, 
      0.8343913477514086, 0.06013367688558215}, {0.8948543713788162, 
      0.8339847370555247, 0.06086963432329147}, {0.8951831630796137, 
      0.8335777579815072, 0.06160540509810659}, {0.8955113998761381, 
      0.8331704110207021, 0.06234098885543607}, {0.8958390819054552, 
      0.8327626966643672, 0.06307638524108816}, {0.8961662093049413, 
      0.8323546154036701, 0.06381159390127115}, {0.8964927822122811, 
      0.8319461677296913, 0.06454661448259015}, {0.8968188007654703, 
      0.8315373541334211, 0.06528144663204949}, {0.8971442651028139, 
      0.8311281751057613, 0.0660160899970527}, {0.8974691753629257, 
      0.8307186311375249, 0.06675054422540096}, {0.8977935316847283, 
      0.8303087227194356, 0.0674848089652929}, {0.8981173342074542, 
      0.8298984503421278, 0.0682188838653266}, {0.898440583070644, 
      0.8294878144961463, 0.06895276857449786}, {0.8987632784141464, 
      0.8290768156719468, 0.06968646274219967}, {0.899085420378119, 
      0.8286654543598965, 0.07041996601822302}, {0.8994070091030271, 
      0.8282537310502711, 0.07115327805275629}, {0.8997280447296444, 
      0.8278416462332572, 0.07188639849638699}, {0.9000485273990514, 
      0.827429200398954, 0.07261932700009743}, {0.9003684572526368, 
      0.8270163940373675, 0.07335206321526944}, {0.9006878344320961, 
      0.8266032276384161, 0.07408460679368013}, {0.9010066590794326, 
      0.826189701691927, 0.0748169573875056}, {0.9013249313369555, 
      0.825775816687639, 0.07554911464931684}, {0.9016426513472818, 
      0.8253615731151984, 0.07628107823208372}, {0.9019598192533342, 
      0.8249469714641632, 0.07701284778917125}, {0.902276435198342, 
      0.8245320122240003, 0.07774442297434168}, {0.9025924993258403, 
      0.8241166958840868, 0.07847580344175355}, {0.9029080117796705, 
      0.823701022933709, 0.07920698884596183}, {0.9032229727039796, 
      0.823284993862062, 0.07993797884191767}, {0.9035373822432201, 
      0.8228686091582514, 0.08066877308496852}, {0.9038512405421494, 
      0.8224518693112924, 0.08139937123085739}, {0.9041645477458307, 
      0.8220347748101072, 0.08212977293572349}, {0.9044773039996317, 
      0.8216173261435302, 0.08285997785610165}, {0.9047895094492252, 
      0.8211995238003027, 0.08358998564892274}, {0.905101164240588, 
      0.820781368269075, 0.08431979597151316}, {0.9054122685200012, 
      0.8203628600384077, 0.08504940848159351}, {0.9057228224340507, 
      0.8199439995967699, 0.08577882283728121}, {0.9060328261296259, 
      0.8195247874325378, 0.08650803869708819}, {0.9063422797539199, 
      0.8191052240339984, 0.08723705571992144}, {0.9066511834544292, 
      0.8186853098893461, 0.08796587356508313}, {0.906959537378954, 
      0.8182650454866848, 0.08869449189226943}, {0.9072673416755976, 
      0.8178444313140247, 0.08942291036157293}, {0.9075745964927661, 
      0.8174234678592873, 0.09015112863347902}, {0.9078813019791682, 
      0.8170021556102998, 0.0908791463688687}, {0.9081874582838155, 
      0.8165804950547989, 0.09160696322901653}, {0.9084930655560217, 
      0.8161584866804296, 0.0923345788755921}, {0.908798123945403, 
      0.8157361309747444, 0.09306199297065881}, {0.9091026336018768, 
      0.8153134284252036, 0.09378920517667341}, {0.9094065946756633, 
      0.814890379519176, 0.0945162151564879}, {0.9097100073172839, 
      0.8144669847439368, 0.09524302257334731}, {0.9100128716775608, 
      0.8140432445866712, 0.09596962709088973}, {0.9103151879076178, 
      0.8136191595344704, 0.09669602837314757}, {0.91061695615888, 
      0.8131947300743335, 0.0974222260845469}, {0.9109181765830731, 
      0.8127699566931668, 0.09814821988990624}, {0.9112188493322225, 
      0.8123448398777854, 0.09887400945443758}, {0.9115189745586557, 
      0.811919380114909, 0.09959959444374707}, {0.9118185524149992, 
      0.8114935778911674, 0.10032497452383185`}, {0.9121175830541794, 
      0.8110674336930963, 0.10105014936108318`}, {0.9124160666294232, 
      0.8106409480071383, 0.10177511862228504`}, {0.9127140032942568, 
      0.8102141213196434, 0.10249988197461325`}, {0.9130113932025057, 
      0.8097869541168684, 0.10322443908563728`}, {0.913308236508295, 
      0.8093594468849772, 0.10394878962331787`}, {0.9136045333660482, 
      0.8089316001100394, 0.1046729332560089}, {0.9139002839304878, 
      0.8085034142780334, 0.10539686965245464`}, {0.9141954883566359, 
      0.8080748898748421, 0.10612059848179416`}, {0.9144901467998118, 
      0.8076460273862559, 0.10684411941355595`}, {0.9147842594156333, 
      0.8072168272979717, 0.10756743211766169`}, {0.9150778263600169, 
      0.8067872900955931, 0.10829053626442388`}, {0.9153708477891759, 
      0.8063574162646292, 0.10901343152454701`}, {0.9156633238596225, 
      0.8059272062904955, 0.10973611756912692`}, {0.9159552547281652, 
      0.8054966606585148, 0.11045859406965071`}, {0.9162466405519107, 
      0.8050657798539136, 0.11118086069799721`}, {0.9165374814882623, 
      0.8046345643618273, 0.11190291712643495`}, {0.9168277776949199, 
      0.8042030146672954, 0.11262476302762467`}, {0.9171175293298807, 
      0.8037711312552634, 0.11334639807461734`}, {0.9174067365514381, 
      0.8033389146105832, 0.11406782194085502`}, {0.9176953995181816, 
      0.802906365218012, 0.11478903430016947`}, {0.917983518388997, 
      0.802473483562213, 0.11551003482678425`}, {0.9182710933230662, 
      0.802040270127754, 0.11623082319531255`}, {0.9185581244798671, 
      0.801606725399109, 0.11695139908075813`}, {0.9188446120191716, 
      0.8011728498606581, 0.11767176215851372`}, {0.9191305561010485, 
      0.8007386439966853, 0.11839191210436337`}, {0.9194159568858613, 
      0.8003041082913803, 0.1191118485944808}, {0.9197008145342679, 
      0.7998692432288392, 0.11983157130542865`}, {0.9199851292072219, 
      0.7994340492930617, 0.12055107991416038`}, {0.9202689010659703, 
      0.798998526967953, 0.12127037409801743`}, {0.9205521302720555, 
      0.7985626767373226, 0.12198945353473288`}, {0.9208348169873135, 
      0.7981264990848865, 0.12270831790242698`}, {0.9211169613738746, 
      0.7976899944942647, 0.12342696687961022`}, {0.9213985635941622, 
      0.7972531634489811, 0.12414540014518134`}, {0.9216796238108941, 
      0.7968160064324653, 0.12486361737842917`}, {0.921960142187081, 
      0.7963785239280508, 0.1255816182590305}, {0.9222401188860267, 
      0.7959407164189762, 0.1262994024670506}, {0.9225195540713287, 
      0.7955025843883845, 0.12701696968294426`}, {0.9227984479068763, 
      0.7950641283193228, 0.12773431958755338`}, {0.9230768005568524, 
      0.7946253486947426, 0.1284514518621097}, {0.9233546121857316, 
      0.7941862459974992, 0.12916836618823244`}, {0.9236318829582808, 
      0.7937468207103525, 0.12988506224792826`}, {0.9239086130395593, 
      0.7933070733159666, 0.13060153972359262`}, {0.9241848025949182, 
      0.7928670042969095, 0.13131779829800883`}, {0.9244604517900001, 
      0.7924266141356525, 0.13203383765434776`}, {0.9247355607907389, 
      0.7919859033145713, 0.13274965747616754`}, {0.92501012976336, 
      0.7915448723159464, 0.13346525744741378`}, {0.9252841588743799, 
      0.7911035216219592, 0.13418063725242052`}, {0.9255576482906055, 
      0.790661851714698, 0.13489579657590756`}, {0.9258305981791353, 
      0.7902198630761526, 0.13561073510298297`}, {0.9261030087073574, 
      0.7897775561882168, 0.13632545251914094`}, {0.926374880042951, 
      0.7893349315326877, 0.13703994851026333`}, {0.9266462123538844, 
      0.7888919895912664, 0.13775422276261814`}, {0.9269170058084171, 
      0.7884487308455567, 0.13846827496286054`}, {0.927187260575097, 
      0.7880051557770654, 0.13918210479803197`}, {0.9274569768227628, 
      0.7875612648672028, 0.1398957119555602}, {0.9277261547205413, 
      0.7871170585972829, 0.14060909612325867`}, {0.9279947944378497, 
      0.7866725374485214, 0.1413222569893284}, {0.9282628961443935, 
      0.7862277019020378, 0.14203519424235583`}, {0.9285304600101665, 
      0.7857825524388542, 0.14274790757131242`}, {0.9287974862054522, 
      0.7853370895398957, 0.1434603966655566}, {0.9290639749008217, 
      0.7848913136859894, 0.14417266121483222`}, {0.9293299262671347, 
      0.7844452253578666, 0.1448847009092682}, {0.9295953404755385, 
      0.7839988250361595, 0.1455965154393792}, {0.9298602176974685, 
      0.7835521132014034, 0.1463081044960651}, {0.9301245581046479, 
      0.7831050903340365, 0.1470194677706113}, {0.930388361869087, 
      0.7826577569143993, 0.14773060495468807`}, {0.9306516291630835, 
      0.7822101134227334, 0.14844151574035}, {0.9309143601592224, 
      0.7817621603391851, 0.14915219982003747`}, {0.931176555030375, 
      0.7813138981437999, 0.1498626568865753}, {0.9314382139496998, 
      0.780865327316527, 0.15057288663317267`}, {0.9316993370906416, 
      0.7804164483372187, 0.15128288875342286`}, {0.9319599246269316, 
      0.7799672616856269, 0.15199266294130465`}, {0.9322199767325866, 
      0.7795177678414074, 0.15270220889117944`}, {0.9324794935819105, 
      0.7790679672841165, 0.15341152629779425`}, {0.9327384753494918, 
      0.7786178604932127, 0.15412061485627912`}, {0.9329969222102049, 
      0.7781674479480568, 0.1548294742621482}, {0.93325483433921, 
      0.7777167301279104, 0.15553810421129988`}, {0.9335122119119516, 
      0.7772657075119369, 0.1562465044000145}, {0.9337690551041599, 
      0.7768143805792018, 0.15695467452495812`}, {0.9340253640918497, 
      0.776362749808671, 0.15766261428317854`}, {0.9342811390513204, 
      0.7759108156792129, 0.15837032337210757`}, {0.9345363801591557, 
      0.7754585786695962, 0.1590778014895597}, {0.9347910875922238, 
      0.7750060392584915, 0.1597850483337326}, {0.9350452615276765, 
      0.7745531979244697, 0.16049206360320656`}, {0.9352989021429501, 
      0.7741000551460049, 0.16119884699694545`}, {0.9355520096157639, 
      0.7736466114014695, 0.1619053982142947}, {0.935804584124121, 
      0.7731928671691389, 0.1626117169549823}, {0.9360566258463081, 
      0.7727388229271881, 0.16331780291912015`}, {0.9363081349608942, 
      0.7722844791536942, 0.16402365580719988`}, {0.9365591116467321, 
      0.7718298363266346, 0.1647292753200976}, {0.9368095560829568, 
      0.7713748949238869, 0.16543466115907018`}, {0.9370594684489858, 
      0.7709196554232294, 0.16613981302575642`}, {0.9373088489245194, 
      0.7704641183023424, 0.16684473062217697`}, {0.9375576976895397, 
      0.7700082840388051, 0.16754941365073478`}, {0.9378060149243109, 
      0.7695521531100976, 0.16825386181421356`}, {0.9380538008093791, 
      0.7690957259936008, 0.1689580748157783}, {0.9383010555255716, 
      0.7686390031665962, 0.16966205235897547`}, {0.9385477792539978, 
      0.7681819851062649, 0.17036579414773298`}, {0.9387939721760478, 
      0.7677246722896882, 0.1710692998863594}, {0.9390396344733929, 
      0.7672670651938484, 0.17177256927954487`}, {0.9392847663279854, 
      0.7668091642956265, 0.17247560203235918`}, {0.9395293679220583, 
      0.7663509700718051, 0.1731783978502532}, {0.9397734394381251, 
      0.7658924829990664, 0.1738809564390589}, {0.940016981058979, 
      0.7654337035539915, 0.17458327750498762`}, {0.9402599929676942, 
      0.7649746322130625, 0.17528536075463186`}, {0.9405024753476247, 
      0.7645152694526607, 0.17598720589496408`}, {0.9407444283824036, 
      0.7640556157490674, 0.17668881263333638`}, {0.9409858522559443, 
      0.7635956715784636, 0.17739018067748089`}, {0.9412267471524393, 
      0.7631354374169302, 0.1780913097355094}, {0.9414671132563601, 
      0.7626749137404469, 0.1787921995159137}, {0.9417069507524579, 
      0.762214101024893, 0.17949284972756532`}, {0.9419462598257622, 
      0.7617529997460479, 0.1801932600797145}, {0.9421850406615808, 
      0.7612916103795901, 0.18089343028199056`}, {0.942423293445501, 
      0.7608299334010975, 0.18159336004440355`}, {0.9426610183633877, 
      0.7603679692860474, 0.18229304907734012`}, {0.9428982156013836, 
      0.7599057185098158, 0.182992497091568}, {0.9431348853459103, 
      0.7594431815476778, 0.18369170379823263`}, {0.9433710277836663, 
      0.7589803588748084, 0.18439066890885794`}, {0.9436066431016281, 
      0.7585172509662811, 0.18508939213534695`}, {0.9438417314870494, 
      0.7580538582970685, 0.18578787318998086`}, {0.944076293127461, 
      0.7575901813420427, 0.18648611178541857`}, {0.9443103282106711, 
      0.7571262205759728, 0.1871841076346986}, {0.944543836924764, 
      0.7566619764735291, 0.18788186045123506`}, {0.9447768194581018, 
      0.7561974495092789, 0.18857936994882274`}, {0.9450092759993218, 
      0.7557326401576893, 0.18927663584163246`}, {0.9452412067373382, 
      0.7552675488931261, 0.1899736578442123}, {0.9454726118613418, 
      0.7548021761898522, 0.19067043567148964`}, {0.9457034915607982, 
      0.7543365225220313, 0.19136696903876735`}, {0.9459338460254498, 
      0.7538705883637228, 0.19206325766172708`}, {0.946163675445314, 
      0.7534043741888872, 0.1927593012564269}, {0.9463929800106832, 
      0.7529378804713823, 0.19345509953930068`}, {0.946621759912126, 
      0.7524711076849643, 0.19415065222716182`}, {0.9468500153404853, 
      0.7520040563032869, 0.19484595903719837`}, {0.9470777464868789, 
      0.7515367267999038, 0.19554101968697538`}, {0.9473049535426998, 
      0.7510691196482644, 0.19623583389443547`}, {0.9475316366996146, 
      0.750601235321719, 0.1969304013778956}, {0.9477577961495649, 
      0.7501330742935136, 0.19762472185605118`}, {0.9479834320847662, 
      0.7496646370367939, 0.19831879504797256`}, {0.9482085446977079, 
      0.7491959240246022, 0.19901262067310563`}, {0.948433134181153, 
      0.7487269357298796, 0.19970619845127358`}, {0.9486572007281385, 
      0.7482576726254652, 0.20039952810267328`}, {0.9488807445319746, 
      0.7477881351840956, 0.2010926093478791}, {0.9491037657862446, 
      0.7473183238784039, 0.2017854419078406}, {0.9493262646848047, 
      0.7468482391809235, 0.2024780255038814}, {0.9495482414217846, 
      0.7463778815640831, 0.20317035985770163`}, {0.949769696191586, 
      0.7459072515002105, 0.2038624446913756}, {0.9499906291888837, 
      0.7454363494615305, 0.20455427972735335`}, {0.9502110406086243, 
      0.7449651759201646, 0.2052458646884599}, {0.9504309306460269, 
      0.744493731348134, 0.20593719929789317`}, {0.9506502994965824, 
      0.7440220162173545, 0.20662828327922786`}, {0.9508691473560538, 
      0.7435500309996415, 0.20731911635641243`}, {0.9510874744204751, 
      0.7430777761667067, 0.20800969825376878`}, {0.9513052808861526, 
      0.7426052521901592, 0.20870002869599377`}, {0.9515225669496633, 
      0.7421324595415052, 0.2093901074081584}, {0.9517393328078553, 
      0.741659398692148, 0.21007993411570727`}, {0.9519555786578476, 
      0.7411860701133889, 0.21076950854445856`}, {0.9521713046970306, 
      0.7407124742764256, 0.21145883042060512`}, {0.9523865111230644, 
      0.7402386116523522, 0.2121478994707122}, {0.9526011981338796, 
      0.7397644827121617, 0.21283671542171845`}, {0.9528153659276778, 
      0.7392900879267403, 0.21352527800093743`}, {0.95302901470293, 
      0.7388154277668764, 0.21421358693605363`}, {0.9532421446583768, 
      0.738340502703251, 0.21490164195512587`}, {0.9534547559930292, 
      0.7378653132064433, 0.21558944278658573`}, {0.953666848906167, 
      0.7373898597469302, 0.21627698915923724`}, {0.9538784235973404, 
      0.7369141427950833, 0.21696428080225752`}, {0.9540894802663676, 
      0.7364381628211724, 0.2176513174451953}, {0.9543000191133362, 
      0.7359619202953639, 0.2183380988179724}, {0.9545100403386032, 
      0.7354854156877199, 0.2190246246508835}, {0.9547195441427934, 
      0.7350086494681995, 0.2197108946745938}, {0.9549285307268002, 
      0.7345316221066591, 0.2203969086201414}, {0.955137000291786, 
      0.7340543340728503, 0.22108266621893627`}, {0.9553449530391809, 
      0.7335767858364206, 0.22176816720276013`}, {0.9555523891706824, 
      0.7330989778669168, 0.2224534113037655}, {0.9557593088882568, 
      0.7326209106337792, 0.22313839825447765`}, {0.9559657123941372, 
      0.7321425846063457, 0.22382312778779173`}, {0.9561715998908248, 
      0.7316640002538487, 0.22450759963697609`}, {0.9563769715810873, 
      0.7311851580454196, 0.2251918135356674}, {0.9565818276679601, 
      0.7307060584500846, 0.22587576921787553`}, {0.9567861683547452, 
      0.7302267019367652, 0.22655946641798003`}, {0.9569899938450117, 
      0.7297470889742801, 0.22724290487073157`}, {0.9571933043425951, 
      0.7292672200313441, 0.2279260843112512}, {0.9573961000515971, 
      0.7287870955765667, 0.22860900447503046`}, {0.9575983811763858, 
      0.7283067160784557, 0.22929166509793056`}, {0.9578001479215955, 
      0.727826082005412, 0.2299740659161835}, {0.9580014004921263, 
      0.727345193825735, 0.2306562066663917}, {0.9582021390931439, 
      0.7268640520076174, 0.23133808708552622`}, {0.9584023639300798, 
      0.7263826570191513, 0.23201970691092885`}, {0.9586020752086307, 
      0.7259010093283205, 0.23270106588031042`}, {0.9588012731347585, 
      0.7254191094030072, 0.23338216373175144`}, {0.9589999579146905, 
      0.7249369577109889, 0.234063000203702}, {0.9591981297549185, 
      0.7244545547199377, 0.23474357503498092`}, {0.9593957888621988, 
      0.7239719008974228, 0.235423887964776}, {0.9595929354435531, 
      0.7234889967109084, 0.23610393873264507`}, {0.9597895697062667, 
      0.7230058426277537, 0.23678372707851342`}, {0.9599856918578894, 
      0.7225224391152137, 0.23746325274267582`}, {0.9601813021062351, 
      0.7220387866404399, 0.23814251546579532`}, {0.9603764006593811, 
      0.721554885670478, 0.23882151498890303`}, {0.9605709877256695, 
      0.7210707366722704, 0.2395002510533994}, {0.9607650635137046, 
      0.7205863401126531, 0.24017872340105142`}, {0.960958628232355, 
      0.7201016964583598, 0.2408569317739955}, {0.9611516820907522, 
      0.7196168061760169, 0.24153487591473544`}, {0.9613442252982909, 
      0.7191316697321479, 0.2422125555661431}, {0.9615362580646282, 
      0.718646287593172, 0.24288997047145636`}, {0.9617277805996844, 
      0.7181606602254019, 0.24356712037428258`}, {0.9619187931136423, 
      0.7176747880950467, 0.24424400501859553`}, {0.9621092958169467, 
      0.7171886716682104, 0.2449206241487362}, {0.9622992889203053, 
      0.7167023114108928, 0.24559697750941265`}, {0.962488772634687, 
      0.7162157077889868, 0.2462730648457002}, {0.9626777471713232, 
      0.7157288612682828, 0.24694888590304012`}, {0.962866212741707, 
      0.7152417723144655, 0.24762444042724174`}, {0.9630541695575926, 
      0.7147544413931134, 0.2482997281644791}, {0.9632416178309958, 
      0.7142668689697015, 0.2489747488612942}, {0.9634285577741943, 
      0.7137790555095997, 0.2496495022645945}, {0.9636149895997258, 
      0.7132910014780719, 0.250323988121654}, {0.9638009135203893, 
      0.7128027073402774, 0.2509982061801122}, {0.9639863297492449, 
      0.7123141735612706, 0.25167215618797434`}, {0.9641712384996131, 
      0.7118254006060006, 0.25234583789361253`}, {0.9643556399850741, 
      0.7113363889393115, 0.2530192510457627}, {0.9645395344194695, 
      0.7108471390259425, 0.2536923953935273}, {0.9647229220169005, 
      0.7103576513305262, 0.25436527068637443`}, {0.9649058029917278, 
      0.7098679263175913, 0.25503787667413674`}, {0.9650881775585723, 
      0.7093779644515614, 0.255710213107011}, {0.9652700459323147, 
      0.7088877661967538, 0.256382279735561}, {0.965451408328095, 
      0.7083973320173814, 0.25705407631071375`}, {0.9656322649613119, 
      0.7079066623775508, 0.2577256025837611}, {0.9658126160476241, 
      0.7074157577412651, 0.2583968583063592}, {0.9659924618029487, 
      0.7069246185724193, 0.2590678432305295}, {0.9661718024434619, 
      0.7064332453348052, 0.2597385571086566}, {0.9663506381855983, 
      0.7059416384921088, 0.2604089996934897}, {0.9665289692460511, 
      0.7054497985079098, 0.26107917073814135`}, {0.9667067958417721, 
      0.7049577258456832, 0.26174906999608943`}, {0.9668841181899706, 
      0.7044654209687976, 0.26241869722117284`}, {0.9670609365081145, 
      0.7039728843405182, 0.2630880521675965}, {0.9672372510139295, 
      0.7034801164240021, 0.26375713458992756`}, {0.9674130619253989, 
      0.7029871176823024, 0.26442594424309657`}, {0.9675883694607631, 
      0.7024938885783666, 0.26509448088239657`}, {0.9677631738385206, 
      0.702000429575036, 0.2657627442634848}, {0.9679374752774268, 
      0.7015067411350464, 0.26643073414238033`}, {0.9681112739964941, 
      0.7010128237210288, 0.26709845027546575`}, {0.9682845702149918, 
      0.7005186777955072, 0.2677658924194847}, {0.9684573641524462, 
      0.7000243038209011, 0.2684330603315453}, {0.9686296560286398, 
      0.6995297022595242, 0.2690999537691155}, {0.9688014460636121, 
      0.6990348735735841, 0.2697665724900281}, {0.9689727344776582, 
      0.6985398182251829, 0.27043291625247534`}, {0.9691435214913299, 
      0.6980445366763165, 0.2710989848150133}, {0.9693138073254346, 
      0.6975490293888762, 0.27176477793655823`}, {0.9694835922010359, 
      0.6970532968246469, 0.272430295376389}, {0.9696528763394526, 
      0.6965573394453071, 0.2730955368941456}, {0.9698216599622593, 
      0.6960611577124312, 0.27376050224982834`}, {0.9699899432912861, 
      0.6955647520874852, 0.2744251912038008}, {0.970157726548618, 
      0.6950681230318329, 0.27508960351678535`}, {0.9703250099565951, 
      0.6945712710067289, 0.27575373894986643`}, {0.9704917937378127, 
      0.6940741964733234, 0.2764175972644895}, {0.9706580781151205, 
      0.6935768998926608, 0.2770811782224596}, {0.9708238633116228, 
      0.6930793817256807, 0.27774448158594234`}, {0.9709891495506785, 
      0.6925816424332149, 0.278407507117464}, {0.971153937055901, 
      0.6920836824759896, 0.27907025457991164`}, {0.9713182260511575, 
      0.6915855023146267, 0.2797327237365309}, {0.971482016760569, 
      0.6910871024096407, 0.2803949143509285}, {0.971645309408511, 
      0.6905884832214406, 0.2810568261870707}, {0.9718081042196121, 
      0.6900896452103303, 0.281718459009282}, {0.9719704014187545, 
      0.6895905888365066, 0.28237981258224815`}, {0.9721322012310744, 
      0.6890913145600607, 0.28304088667101357`}, {0.9722935038819602, 
      0.6885918228409789, 0.2837016810409815}, {0.9724543095970545, 
      0.6880921141391398, 0.2843621954579148}, {0.9726146186022518, 
      0.6875921889143177, 0.28502242968793423`}, {0.9727744311237003, 
      0.6870920476261797, 0.2856823834975204}, {0.9729337473878005, 
      0.686591690734288, 0.2863420566535122}, {0.9730925676212049, 
      0.6860911186980991, 0.28700144892310603`}, {0.9732508920508189, 
      0.6855903319769608, 0.28766056007385826`}, {0.9734087209038003, 
      0.6850893310301186, 0.28831938987368194`}, {0.9735660544075583, 
      0.6845881163167098, 0.2889779380908487}, {0.9737228927897544, 
      0.6840866882957666, 0.28963620449398825`}, {0.9738792362783021, 
      0.6835850474262142, 0.29029418885208813`}, {0.9740350851013658, 
      0.6830831941668731, 0.290951890934493}, {0.974190439487362, 
      0.6825811289764573, 0.29160931051090455`}, {0.9743452996649583, 
      0.682078852313575, 0.29226644735138335`}, {0.9744996658630735, 
      0.6815763646367282, 0.2929233012263454}, {0.9746535383108772, 
      0.6810736664043122, 0.29357987190656515`}, {0.9748069172377902, 
      0.680570758074618, 0.29423615916317214`}, {0.9749598028734842, 
      0.68006764010583, 0.29489216276765456`}, {0.9751121954478809, 
      0.6795643129560247, 0.29554788249185643`}, {0.975264095191153, 
      0.6790607770831756, 0.2962033181079776}, {0.9754155023337232, 
      0.678557032945148, 0.296858469388575}, {0.9755664171062646, 
      0.6780530809997031, 0.2975133361065615}, {0.9757168397397001, 
      0.6775489217044943, 0.2981679180352057}, {0.9758667704652028, 
      0.6770445555170704, 0.29882221494813227`}, {0.9760162095141949, 
      0.6765399828948738, 0.29947622661932105`}, {0.9761651571183491, 
      0.6760352042952403, 0.3001299528231087}, {0.9763136135095869, 
      0.6755302201754005, 0.30078339333418647`}, {0.9764615789200795, 
      0.675025030992479, 0.3014365479276009}, {0.9766090535822467, 
      0.674519637203494, 0.30208941637875286`}, {0.976756037728758, 
      0.6740140392653587, 0.3027419984633994}, {0.9769025315925315, 
      0.673508237634879, 0.3033942939576525}, {0.9770485354067342, 
      0.673002232768756, 0.3040463026379782}, {0.9771940494047814, 
      0.6724960251235846, 0.30469802428119697`}, {0.9773390738203371, 
      0.6719896151558535, 0.30534945866448354`}, {0.977483608887314, 
      0.671483003321946, 0.30600060556536784`}, {0.9776276548398722, 
      0.6709761900781395, 0.3066514647617331}, {0.9777712119124207, 
      0.6704691758806041, 0.30730203603181677`}, {0.9779142803396157, 
      0.669961961185406, 0.30795231915420973`}, {0.9780568603563616, 
      0.6694545464485047, 0.308602313907857}, {0.9781989521978105, 
      0.6689469321257541, 0.3092520200720566}, {0.9783405560993618, 
      0.6684391186729015, 0.30990143742646026`}, {0.9784816722966623, 
      0.6679311065455896, 0.31055056575107276`}, {0.9786223010256063, 
      0.6674228961993539, 0.31119940482625247`}, {0.9787624425223352, 
      0.6669144880896255, 0.31184795443271}, {0.9789020970232368, 
      0.6664058826717283, 0.3124962143515086}, {0.9790412647649465, 
      0.6658970804008824, 0.31314418436406427`}, {0.9791799459843458, 
      0.6653880817321998, 0.3137918642521462}, {0.9793181409185632, 
      0.6648788871206881, 0.3144392537978753}, {0.9794558498049736, 
      0.6643694970212489, 0.3150863527837245}, {0.9795930728811977, 
      0.6638599118886794, 0.3157331609925183}, {0.979729810385103, 
      0.6633501321776686, 0.31637967820743446`}, {0.9798660625548028, 
      0.6628401583428017, 0.3170259042120014}, {0.9800018296286563, 
      0.6623299908385575, 0.3176718387900993}, {0.9801371118452686, 
      0.6618196301193089, 0.3183174817259598}, {0.9802719094434901, 
      0.661309076639324, 0.3189628328041659}, {0.980406222662417, 
      0.6607983308527664, 0.319607891809651}, {0.9805400517413909, 
      0.6602873932136906, 0.32025265852770085`}, {0.9806733969199986, 
      0.659776264176048, 0.32089713274395076`}, {0.980806258438072, 
      0.6592649441936846, 0.32154131424438737`}, {0.9809386365356879, 
      0.6587534337203405, 0.32218520281534774`}, {0.9810705314531681, 
      0.6582417332096497, 0.32282879824351846`}, {0.9812019434310794, 
      0.6577298431151416, 0.3234721003159376}, {0.9813328727102324, 
      0.6572177638902401, 0.32411510881999234`}, {0.981463319531683, 
      0.6567054959882624, 0.3247578235434203}, {0.981593284136731, 
      0.6561930398624233, 0.325400244274308}, {0.9817227667669208, 
      0.6556803959658275, 0.32604237080109333`}, {0.9818517676640405, 
      0.6551675647514792, 0.32668420291256156`}, {0.9819802870701222, 
      0.6546545466722741, 0.32732574039784795`}, {0.9821083252274424, 
      0.6541413421810044, 0.3279669830464383}, {0.9822358823785204, 
      0.6536279517303556, 0.3286079306481649}, {0.9823629587661201, 
      0.6531143757729093, 0.32924858299321097`}, {0.982489554633248, 
      0.6526006147611412, 0.3298889398721069}, {0.9826156702231545, 
      0.6520866691474213, 0.3305290010757331}, {0.982741305779333, 
      0.6515725393840166, 0.3311687663953167}, {0.98286646154552, 
      0.6510582259230862, 0.3318082356224341}, {0.982991137765695, 
      0.6505437292166856, 0.3324474085490097}, {0.9831153346840806, 
      0.6500290497167645, 0.333086284967316}, {0.9832390525451415, 
      0.6495141878751703, 0.3337248646699716}, {0.9833622915935857, 
      0.6489991441436411, 0.334363147449945}, {0.9834850520743632, 
      0.6484839189738122, 0.3350011331005507}, {0.9836073342326668, 
      0.6479685128172151, 0.3356388214154516}, {0.9837291383139309, 
      0.6474529261252757, 0.33627621218865567`}, {0.9838504645638328, 
      0.6469371593493127, 0.3369133052145202}, {0.9839713132282912, 
      0.6464212129405434, 0.337550100287748}, {0.9840916845534671, 
      0.6459050873500785, 0.33818659720338856`}, {0.9842115787857628, 
      0.6453887830289241, 0.3388227957568385}, {0.9843309961718227, 
      0.6448723004279823, 0.33945869574384047`}, {0.9844499369585324, 
      0.6443556399980496, 0.34009429696048266`}, {0.9845684013930195, 
      0.6438388021898186, 0.34072959920320117`}, {0.9846863897226517, 
      0.6433217874538774, 0.34136460226877463`}, {0.9848039021950392, 
      0.6428045962407076, 0.3419993059543316}, {0.9849209390580325, 
      0.6422872290006892, 0.3426337100573431}, {0.9850375005597231, 
      0.6417696861840971, 0.3432678143756265}, {0.9851535869484437, 
      0.6412519682410993, 0.34390161870734465`}, {0.9852691984727672, 
      0.6407340756217617, 0.34453512285100557`}, {0.9853843353815074, 
      0.6402160087760466, 0.34516832660546104`}, {0.9854989979237185, 
      0.6396977681538093, 0.3458012297699092}, {0.9856131863486953, 
      0.6391793542048037, 0.346433832143892}, {0.9857269009059726, 
      0.6386607673786768, 0.3470661335272963}, {0.9858401418453252, 
      0.638142008124973, 0.34769813372035246`}, {0.9859529094167683, 
      0.6376230768931329, 0.3483298325236356}, {0.9860652038705566, 
      0.637103974132492, 0.34896122973806465`}, {0.9861770254571851, 
      0.636584700292283, 0.34959232516490246`}, {0.9862883744273881, 
      0.6360652558216331, 0.35022311860575556`}, {0.9863992510321397, 
      0.6355456411695656, 0.3508536098625739}, {0.9865096555226532, 
      0.6350258567850028, 0.35148379873765034`}, {0.9866195881503816, 
      0.6345059031167593, 0.3521136850336224}, {0.9867290491670169, 
      0.6339857806135483, 0.3527432685534685}, {0.9868380388244903, 
      0.633465489723979, 0.35337254910051125`}, {0.986946557374972, 
      0.632945030896556, 0.3540015264784163}, {0.9870546050708715, 
      0.6324244045796809, 0.3546302004911909}, {0.9871621821648365, 
      0.6319036112216514, 0.3552585709431854}, {0.9872692889097539, 
      0.631382651270663, 0.35588663763909123`}, {0.9873759255587488, 
      0.6308615251748056, 0.35651440038394355`}, {0.987482092365185, 
      0.6303402333820668, 0.3571418589831183}, {0.987587789582665, 
      0.6298187763403321, 0.35776901324233296`}, {0.987693017465029, 
      0.6292971544973818, 0.3583958629676477}, {0.9877977762663557, 
      0.6287753683008926, 0.3590224079654631}, {0.9879020662409619, 
      0.6282534181984406, 0.3596486480425213}, {0.9880058876434022, 
      0.627731304637497, 0.3602745830059057}, {0.9881092407284694, 
      0.6272090280654293, 0.3609002126630405}, {0.9882121257511934, 
      0.6266865889295034, 0.36152553682169053`}, {0.9883145429668427, 
      0.6261639876768813, 0.36215055528996154`}, {0.9884164926309223, 
      0.6256412247546238, 0.3627752678762991}, {0.9885179749991758, 
      0.625118300609686, 0.36339967438948995`}, {0.988618990327583, 
      0.6245952156889234, 0.36402377463866}, {0.988719538872362, 
      0.6240719704390862, 0.3646475684332761}, {0.9888196208899671, 
      0.623548565306823, 0.36527105558314404`}, {0.9889192366370905, 
      0.6230250007386811, 0.3658942358984095}, {0.9890183863706606, 
      0.6225012771811035, 0.36651710918955754`}, {0.9891170703478434, 
      0.6219773950804309, 0.3671396752674123}, {0.989215288826041, 
      0.6214533548829025, 0.3677619339431387}, {0.9893130420628927, 
      0.6209291570346545, 0.36838388502823816`}, {0.9894103303162739, 
      0.6204048019817224, 0.36900552833455147`}, {0.9895071538442968, 
      0.619880290170037, 0.36962686367425984`}, {0.9896035129053098, 
      0.6193556220454284, 0.3702478908598812}, {0.9896994077578976, 
      0.6188307980536254, 0.3708686097042722}, {0.989794838660881, 
      0.6183058186402539, 0.37148902002062695`}, {0.9898898058733172, 
      0.6177806842508378, 0.3721091216224795}, {0.9899843096544989, 
      0.6172553953307992, 0.3727289143236996}, {0.9900783502639551, 
      0.6167299523254602, 0.37334839793849545`}, {0.9901719279614505, 
      0.616204355680038, 0.37396757228141286`}, {0.9902650430069854, 
      0.61567860583965, 0.37458643716733536`}, {0.9903576956607958, 
      0.6151527032493137, 0.3752049924114823}, {0.9904498861833532, 
      0.6146266483539427, 0.3758232378294106}, {0.9905416148353645, 
      0.6141004415983504, 0.3764411732370147}, {0.990632881877772, 
      0.6135740834272477, 0.3770587984505245}, {0.9907236875717532, 
      0.6130475742852465, 0.3776761132865067}, {0.9908140321787209, 
      0.6125209146168554, 0.37829311756186546`}, {0.9909039159603228, 
      0.6119941048664841, 0.37890981109383887`}, {0.9909933391784416, 
      0.6114671454784388, 0.37952619370000273`}, {0.991082302095195, 
      0.610940036896927, 0.3801422651982682}, {0.9911708049729354, 
      0.6104127795660542, 0.38075802540688164`}, {0.99125884807425, 
      0.6098853739298252, 0.38137347414442496`}, {0.9913464316619607, 
      0.6093578204321453, 0.3819886112298159}, {0.9914335559991238, 
      0.6088301195168174, 0.38260343648230644`}, {0.99152022134903, 
      0.6083022716275461, 0.3832179497214839}, {0.9916064279752046, 
      0.6077742772079342, 0.38383215076727073`}, {0.9916921761414071, 
      0.6072461367014841, 0.38444603943992334`}, {0.9917774661116312, 
      0.6067178505515985, 0.3850596155600326}, {0.9918622981501048, 
      0.6061894192015806, 0.3856728789485245}, {0.9919466725212895, 
      0.6056608430946325, 0.38628582942665696`}, {0.9920305894898814, 
      0.6051321226738569, 0.38689846681602474`}, {0.9921140493208102, 
      0.6046032583822559, 0.3875107909385539}, {0.9921970522792393, 
      0.6040742506627343, 0.38812280161650536`}, {0.9922795986305658, 
      0.6035450999580929, 0.3887344986724734}, {0.992361688640421, 
      0.6030158067110366, 0.3893458819293845}, {0.9924433225746688, 
      0.6024863713641703, 0.38995695121049895`}, {0.9925245006994075, 
      0.6019567943599977, 0.39056770633940985`}, {0.9926052232809681, 
      0.6014270761409257, 0.39117814714004234`}, {0.9926854905859154, 
      0.6008972171492598, 0.3917882734366555}, {0.9927653028810474, 
      0.6003672178272079, 0.39239808505383983`}, {0.9928446604333949, 
      0.5998370786168781, 0.3930075818165172}, {0.9929235635102222, 
      0.5993067999602795, 0.3936167635499429}, {0.9930020123790262, 
      0.5987763822993234, 0.39422563007970274`}, {0.9930800073075373, 
      0.5982458260758218, 0.39483418123171565`}, {0.9931575485637184, 
      0.5977151317314873, 0.39544241683223097`}, {0.9932346364157651, 
      0.5971842997079357, 0.3960503367078296}, {0.9933112711321062, 
      0.596653330446683, 0.39665794068542304`}, {0.9933874529814025, 
      0.5961222243891476, 0.3972652285922549}, {0.9934631822325478, 
      0.5955909819766498, 0.39787220025589787`}, {0.9935384591546684, 
      0.5950596036504113, 0.3984788555042573}, {0.993613284017123, 
      0.5945280898515557, 0.3990851941655676}, {0.9936876570895025, 
      0.5939964410211095, 0.399691216068393}, {0.9937615786416303, 
      0.5934646576000018, 0.4002969210416289}, {0.9938350489435618, 
      0.592932740029062, 0.4009023089144998}, {0.9939080682655848, 
      0.5924006887490243, 0.40150737951656057`}, {0.993980636878219, 
      0.591868504200524, 0.4021121326776951}, {0.9940527550522165, 
      0.5913361868241004, 0.4027165682281164}, {0.9941244230585606, 
      0.590803737060194, 0.403320685998367}, {0.9941956411684675, 
      0.5902711553491483, 0.40392448581931895`}, {0.9942664096533842, 
      0.5897384421312128, 0.4045279675221716}, {0.9943367287849902, 
      0.5892055978465359, 0.4051311309384545}, {0.9944065988351964, 
      0.588672622935172, 0.4057339759000248}, {0.9944760200761454, 
      0.5881395178370779, 0.4063365022390679}, {0.9945449927802112, 
      0.5876062829921141, 0.4069387097880976}, {0.9946135172199997, 
      0.5870729188400443, 0.40754059837995565`}, {0.9946815936683477, 
      0.5865394258205373, 0.4081421678478107}, {0.994749222398324, 
      0.5860058043731642, 0.4087434180251599}, {0.9948164036832282, 
      0.5854720549374006, 0.4093443487458278}, {0.9948831377965914, 
      0.584938177952626, 0.4099449598439652}, {0.9949494250121759, 
      0.5844041738581254, 0.4105452511540504}, {0.9950152656039751, 
      0.5838700430930863, 0.4111452225108891}, {0.9950806598462136, 
      0.5833357860966017, 0.4117448737496122}, {0.995145608013347, 
      0.5828014033076682, 0.4123442047056786}, {0.9952101103800615, 
      0.5822668951651893, 0.41294321521487226`}, {0.9952741672212748, 
      0.5817322621079711, 0.41354190511330396`}, {0.9953377788121351, 
      0.5811975045747256, 0.41414027423740973`}, {0.9954009454280218, 
      0.5806626230040689, 0.4147383224239528}, {0.9954636673445445, 
      0.5801276178345252, 0.4153360495100193}, {0.9955259448375438, 
      0.5795924895045205, 0.4159334553330232}, {0.995587778183091, 
      0.5790572384523888, 0.4165305397307026}, {0.9956491676574878, 
      0.578521865116368, 0.41712730254112007`}, {0.9957101135372667, 
      0.5779863699346025, 0.4177237436026642}, {0.9957706160991905, 
      0.577450753345144, 0.41831986275404665`}, {0.9958306756202526, 
      0.5769150157859473, 0.41891565983430545`}, {0.9958902923776767, 
      0.5763791576948758, 0.4195111346828007}, {0.9959494666489167, 
      0.5758431795096992, 0.42010628713921766`}, {0.9960081987116571, 
      0.5753070816680914, 0.4207011170435659}, {0.9960664888438127, 
      0.574770864607635, 0.42129562423617795`}, {0.9961243373235279, 
      0.5742345287658184, 0.4218898085577096}, {0.9961817444291781, 
      0.5736980745800371, 0.42248366984914093`}, {0.9962387104393681, 
      0.5731615024875946, 0.42307720795177356`}, {0.9962952356329332, 
      0.5726248129256991, 0.4236704227072343}, {0.9963513202889385, 
      0.5720880063314687, 0.4242633139574701}, {0.9964069646866793, 
      0.5715510831419274, 0.42485588154475207`}, {0.9964621691056806, 
      0.5710140437940076, 0.4254481253116736}, {0.9965169338256977, 
      0.5704768887245483, 0.4260400451011499}, {0.9965712591267153, 
      0.5699396183702972, 0.42663164075641824`}, {0.996625145288948, 
      0.5694022331679113, 0.42722291212103664`}, {0.9966785925928403, 
      0.5688647335539534, 0.4278138590388871}, {0.9967316013190667, 
      0.5683271199648963, 0.42840448135417075`}, {0.9967841717485307, 
      0.5677893928371203, 0.4289947789114105}, {0.9968363041623662, 
      0.5672515526069154, 0.4295847515554513}, {0.9968879988419364, 
      0.5667135997104789, 0.4301743991314576}, {0.996939256068834, 
      0.5661755345839182, 0.43076372148491543`}, {0.9969900761248814, 
      0.5656373576632511, 0.4313527184616309}, {0.9970404592921306, 
      0.5650990693844008, 0.43194138990772996`}, {0.9970904058528628, 
      0.5645606701832039, 0.43252973566965897`}, {0.997139916089589, 
      0.5640221604954042, 0.4331177555941845}, {0.9971889902850493, 
      0.563483540756657, 0.43370544952839246`}, {0.9972376287222133, 
      0.562944811402526, 0.4342928173196876}, {0.9972858316842804, 
      0.5624059728684847, 0.4348798588157958}, {0.9973335994546786, 
      0.561867025589919, 0.4354665738647596}, {0.9973809323170656, 
      0.5613279700021235, 0.4360529623149422}, {0.9974278305553282, 
      0.5607888065403034, 0.43663902401502486`}, {0.9974742944535829, 
      0.560249535639576, 0.43722475881400713`}, {0.9975203242961748, 
      0.559710157734967, 0.43781016656120764`}, {0.9975659203676785, 
      0.5591706732614165, 0.43839524710626226`}, {0.9976110829528979, 
      0.5586310826537728, 0.4389800002991255}, {0.9976558123368657, 
      0.5580913863467976, 0.4395644259900681}, {0.9977001088048439, 
      0.5575515847751634, 0.4401485240296805}, {0.9977439726423237, 
      0.5570116783734546, 0.4407322942688691}, {0.9977874041350252, 
      0.5564716675761681, 0.44131573655885736`}, {0.9978304035688976, 
      0.5559315528177111, 0.44189885075118696`}, {0.9978729712301192, 
      0.5553913345324053, 0.4424816366977141}, {0.9979151074050971, 
      0.5548510131544836, 0.4430640942506141}, {0.9979568123804677, 
      0.5543105891180917, 0.44364622326237585`}, {0.9979980864430962, 
      0.5537700628572897, 0.44422802358580615`}, {0.9980389298800766, 
      0.5532294348060478, 0.44480949507402867`}, {0.9980793429787321, 
      0.5526887053982528, 0.4453906375804796}, {0.9981193260266147, 
      0.5521478750677017, 0.4459714509589133}, {0.9981588793115054, 
      0.5516069442481064, 0.44655193506339896`}, {0.9981980031214138, 
      0.5510659133730939, 0.44713208974832025`}, {0.9982366977445789, 
      0.5505247828762025, 0.44771191486837614`}, {0.998274963469468, 
      0.5499835531908872, 0.4482914102785806}, {0.9983128005847776, 
      0.5494422247505157, 0.44887057583426165`}, {0.9983502093794329, 
      0.5489007979883715, 0.4494494113910617}, {0.998387190142588, 
      0.5483592733376503, 0.4500279168049374}, {0.9984237431636258, 
      0.5478176512314664, 0.45060609193215917`}, {0.998459868732158, 
      0.5472759321028463, 0.45118393662931167`}, {0.998495567138025, 
      0.5467341163847333, 0.45176145075329205`}, {0.9985308386712962, 
      0.5461922045099845, 0.45233863416131204`}, {0.9985656836222698, 
      0.5456501969113752, 0.45291548671089515`}, {0.9986001022814724, 
      0.5451080940215943, 0.4534920082598779}, {0.9986340949396599, 
      0.5445658962732486, 0.45406819866641146`}, {0.9986676618878167, 
      0.5440236040988597, 0.4546440577889568}, {0.998700803417156, 
      0.5434812179308679, 0.45521958548628855`}, {0.9987335198191195, 
      0.5429387382016266, 0.45579478161749304`}, {0.9987658113853782, 
      0.5423961653434094, 0.45636964604196933`}, {0.9987976784078317, 
      0.541853499788405, 0.4569441786194264}, {0.9988291211786081, 
      0.5413107419687211, 0.4575183792098868}, {0.9988601399900645, 
      0.5407678923163827, 0.4580922476736819}, {0.9988907351347868, 
      0.5402249512633306, 0.45866578387145596`}, {0.9989209069055894, 
      0.5396819192414258, 0.4592389876641636}, {0.998950655595516, 
      0.5391387966824461, 0.4598118589130698}, {0.9989799814978385, 
      0.5385955840180893, 0.4603843974797498}, {0.999008884906058, 
      0.5380522816799688, 0.4609566032260891}, {0.9990373661139041, 
      0.5375088900996208, 0.4615284760142837}, {0.9990654254153356, 
      0.536965409708496, 0.46210001570683934`}, {0.9990930631045397, 
      0.5364218409379705, 0.4626712221665697}, {0.9991202794759327, 
      0.535878184219333, 0.46324209525660004`}, {0.9991470748241597, 
      0.5353344399837959, 0.463812634840364}, {0.9991734494440944, 
      0.5347906086624926, 0.46438284078160225`}, {0.9991994036308396, 
      0.5342466906864723, 0.4649527129443673}, {0.999224937679727, 
      0.5337026864867087, 0.46552225119301854`}, {0.999250051886317, 
      0.5331585964940941, 0.4660914553922232}, {0.999274746546399, 
      0.5326144211394424, 0.4666603254069571}, {0.9992990219559914, 
      0.5320701608534881, 0.4672288611025035}, {0.9993228784113414, 
      0.5315258160668872, 0.4677970623444547}, {0.999346316208925, 
      0.5309813872102164, 0.46836492899870863`}, {0.9993693356454477, 
      0.5304368747139758, 0.4689324609314717}, {0.9993919370178435, 
      0.5298922790085868, 0.46949965800925664`}, {0.9994141206232753, 
      0.5293476005243928, 0.47006652009888256`}, {0.9994358867591356, 
      0.528802839691659, 0.4706330470674764}, {0.9994572357230456, 
      0.5282579969405762, 0.47119923878246933`}, {0.9994781678128555, 
      0.5277130727012539, 0.47176509511160164`}, {0.9994986833266448, 
      0.5271680674037282, 0.4723306159229168}, {0.999518782562722, 
      0.5266229814779566, 0.47289580108476503`}, {0.9995384658196247, 
      0.5260778153538225, 0.4734606504658026}, {0.9995577333961199, 
      0.5255325694611296, 0.47402516393499017`}, {0.9995765855912035, 
      0.5249872442296105, 0.474589341361593}, {0.999595022704101, 
      0.5244418400889191, 0.47515318261518225`}, {0.9996130450342668, 
      0.5238963574686347, 0.4757166875656327}, {0.999630652881385, 
      0.5233507967982601, 0.4762798560831248}, {0.9996478465453686, 
      0.5228051585072269, 0.47684268803814195`}, {0.9996646263263602, 
      0.5222594430248895, 0.47740518330147125`}, {0.9996809925247317, 
      0.521713650780527, 0.4779673417442048}, {0.9996969454410848, 
      0.521167782203348, 0.47852916323773687`}, {0.9997124853762499, 
      0.5206218377224844, 0.4790906476537657}, {0.9997276126312876, 
      0.5200758177669952, 0.4796517948642922}, {0.9997423275074878, 
      0.519529722765868, 0.4802126047416202}, {0.9997566303063701, 
      0.5189835531480143, 0.48077307715835627`}, {0.9997705213296834, 
      0.5184373093422739, 0.481333211987409}, {0.9997840008794066, 
      0.517890991777418, 0.4818930091019886}, {0.999797069257748, 
      0.5173446008821387, 0.48245246837560957`}, {0.9998097267671462, 
      0.5167981370850622, 0.48301158968208413`}, {0.9998219737102688, 
      0.5162516008147392, 0.4835703728955295}, {0.9998338103900141, 
      0.5157049924996516, 0.48412881789036255`}, {0.9998452371095095, 
      0.515158312568209, 0.4846869245413008}, {0.9998562541721128, 
      0.5146115614487492, 0.48524469272336335`}, {0.9998668618814117, 
      0.5140647395695426, 0.4858021223118697}, {0.9998770605412239, 
      0.5135178473587854, 0.48635921318243885`}, {0.9998868504555972, 
      0.5129708852446073, 0.48691596521099006`}, {0.9998962319288096, 
      0.5124238536550663, 0.4874723782737436}, {0.999905205265369, 
      0.5118767530181503, 0.48802845224721897`}, {0.9999137707700139, 
      0.5113295837617807, 0.48858418700823336`}, {0.9999219287477129, 
      0.5107823463138087, 0.4891395824339045}, {0.9999296795036651, 
      0.510235041102016, 0.48969463840164956`}, {0.9999370233432997, 
      0.5096876685541168, 0.4902493547891828}, {0.9999439605722767, 
      0.5091402290977586, 0.4908037314745183}, {0.9999504914964866, 
      0.5085927231605187, 0.49135776833596806`}, {0.9999566164220504, 
      0.5080451511699094, 0.4919114652521408}, {0.9999623356553196, 
      0.5074975135533749, 0.4924648221019446}, {0.9999676495028766, 
      0.5069498107382925, 0.4930178387645846}, {0.9999725582715346, 
      0.5064020431519726, 0.4935705151195622}, {0.9999770622683377, 
      0.5058542112216606, 0.4941228510466772}, {0.9999811618005606, 
      0.5053063153745347, 0.4946748464260259}, {0.9999848571757093, 
      0.5047583560377096, 0.495226501138}, {0.9999881487015205, 
      0.5042103336382322, 0.49577781506328855`}, {0.9999910366859626, 
      0.5036622486030862, 0.49632878808287634`}, {0.9999935214372345, 
      0.5031141013591894, 0.496879420078045}, {0.9999956032637669, 
      0.5025658923333972, 0.49742971093037003`}, {0.9999972824742215, 
      0.5020176219524988, 0.49797966052172327`}, {0.9999985593774915, 
      0.5014692906432198, 0.49852926873427167`}, {0.9999994342827015, 
      0.5009208988322253, 0.49907853545047653`}, {0.9999999074992081, 
      0.5003724469461136, 0.49962746055309426`}, {0.9999999793365989, 
      0.49982393541142356`, 0.5001760439251758}, {0.9999996501046935, 
      0.4992753646546278, 0.5007242854500655}, {0.9999989201135435, 
      0.4987267351021409, 0.5012721850114027}, {0.999997789673432, 
      0.4981780471803135, 0.501819742493119}, {0.9999962590948743, 
      0.49762930131543426`, 0.5023669577794405}, {0.9999943286886177, 
      0.49708049793373155`, 0.5029138307548864}, {0.9999919987656416, 
      0.4965316374613739, 0.503460361304268}, {0.9999892696371576, 
      0.49598272032446694`, 0.5040065493126906}, {0.9999861416146096, 
      0.49543374694906017`, 0.5045523946655501}, {0.9999826150096741, 
      0.49488471776113807`, 0.5050978972485364}, {0.9999786901342597, 
      0.49433563318662993`, 0.5056430569476297}, {0.9999743673005078, 
      0.49378649365140415`, 0.5061878736491039}, {0.9999696468207925, 
      0.49323729958126966`, 0.5067323472395227}, {0.9999645290077206, 
      0.4926880514019796, 0.5072764776057409}, {0.9999590141741317, 
      0.4921387495392273, 0.5078202646349046}, {0.9999531026330984, 
      0.4915893944186462, 0.5083637082144522}, {0.9999467946979265, 
      0.49103998646581715`, 0.5089068082321098}, {0.9999400906821546, 
      0.4904905261062601, 0.5094495645758946}, {0.9999329908995549, 
      0.4899410137654399, 0.5099919771341153}, {0.9999254956641327, 
      0.4893914498687646, 0.5105340457953687}, {0.9999176052901269, 
      0.48884183484158583`, 0.511075770448541}, {0.9999093200920098, 
      0.4882921691092018, 0.5116171509828079}, {0.9999006403844876, 
      0.48774245309685366`, 0.5121581872876338}, {0.9998915664825001, 
      0.48719268722972703`, 0.5126988792527732}, {0.9998820987012209, 
      0.486642871932955, 0.5132392267682662}, {0.9998722373560578, 
      0.48609300763161434`, 0.5137792297244437}, {0.9998619827626526, 
      0.4855430947507301, 0.5143188880119227}, {0.9998513352368813, 
      0.4849931337152715, 0.5148582015216095}, {0.9998402950948541, 
      0.48444312495015873`, 0.5153971701446958}, {0.9998288626529158, 
      0.48389306888025474`, 0.5159357937726613}, {0.9998170382276458, 
      0.4833429659303721, 0.5164740722972735}, {0.999804822135858, 
      0.48279281652527267`, 0.5170120056105852}, {0.9997922146946011, 
      0.4822426210896658, 0.5175495936049357}, {0.9997792162211588, 
      0.48169238004820863`, 0.5180868361729505}, {0.99976582703305, 
      0.48114209382550893`, 0.5186237332075415}, {0.9997520474480283, 
      0.4805917628461228, 0.5191602846019058}, {0.9997378777840829, 
      0.4800413875345582, 0.5196964902495248}, {0.9997233183594383, 
      0.4794909683152725, 0.5202323500441661}, {0.9997083694925547, 
      0.47894050561267315`, 0.5207678638798818}, {0.9996930315021276, 
      0.4783899998511198, 0.5213030316510081}, {0.9996773047070887, 
      0.47783945145492257`, 0.5218378532521663}, {0.9996611894266053, 
      0.47728886084834604`, 0.5223723285782598}, {0.9996446859800809, 
      0.4767382284556032, 0.5229064575244781}, {0.9996277946871552, 
      0.47618755470086327`, 0.5234402399862919}, {0.9996105158677042, 
      0.47563684000824785`, 0.5239736758594562}, {0.9995928498418403, 
      0.4750860848018316, 0.5245067650400093}, {0.9995747969299126, 
      0.47453528950564233`, 0.5250395074242706}, {0.9995563574525067, 
      0.47398445454366384`, 0.5255719029088434}, {0.9995375317304453, 
      0.4734335803398333, 0.5261039513906121}, {0.9995183200847884, 
      0.4728826673180453, 0.526635652766743}, {0.9994987228368324, 
      0.47233171590214795`, 0.5271670069346843}, {0.9994787403081116, 
      0.47178072651594705`, 0.527698013792165}, {0.9994583728203977, 
      0.47122969958320204`, 0.5282286732371956}, {0.9994376206956999, 
      0.4706786355276341, 0.5287589851680661}, {0.9994164842562652, 
      0.4701275347729165, 0.5292889494833487}, {0.9993949638245783, 
      0.4695763977426847, 0.5298185660818938}, {0.9993730597233623, 
      0.4690252248605284, 0.5303478348628338}, {0.9993507722755783, 
      0.4684740165500005, 0.5308767557255781}, {0.9993281018044261, 
      0.46792277323460824`, 0.5314053285698183}, {0.9993050486333434, 
      0.46737149533782096`, 0.5319335532955225}, {0.9992816130860072, 
      0.4668201832830687, 0.5324614298029386}, {0.999257795486333, 
      0.46626883749373965`, 0.5329889579925933}, {0.9992335961584755, 
      0.4657174583931844, 0.5335161377652912}, {0.9992090154268286, 
      0.4651660464047153, 0.5340429690221139}, {0.9991840536160254, 
      0.4646146019516032, 0.5345694516644222}, {0.9991587110509386, 
      0.46406312545708517`, 0.5350955855938532}, {0.9991329880566804, 
      0.46351161734435997`, 0.535621370712321}, {0.9991068849586031, 
      0.46296007803658673`, 0.5361468069220168}, {0.9990804020822992, 
      0.4624085079568911, 0.5366718941254085}, {0.9990535397536008, 
      0.4618569075283611, 0.5371966322252396}, {0.9990262982985808, 
      0.4613052771740506, 0.5377210211245299}, {0.9989986780435527, 
      0.4607536173169787, 0.5382450607265741}, {0.9989706793150704, 
      0.4602019283801276, 0.5387687509349433}, {0.9989423024399291, 
      0.4596502107864459, 0.5392920916534835}, {0.9989135477451648, 
      0.45909846495885065`, 0.5398150827863142}, {0.998884415558055, 
      0.4585466913202246, 0.5403377242378304}, {0.9988549062061183, 
      0.45799489029341695`, 0.5408600159127015}, {0.9988250200171154, 
      0.4574430623012462, 0.5413819577158694}, {0.9987947573190485, 
      0.45689120776649716`, 0.5419035495525516}, {0.9987641184401621, 
      0.45633932711192554`, 0.5424247913282367}, {0.9987331037089426, 
      0.4557874207602551, 0.5429456829486876}, {0.9987017134541192, 
      0.45523548913418016`, 0.5434662243199395}, {0.9986699480046632, 
      0.4546835326563627, 0.5439864153483005}, {0.9986378076897893, 
      0.4541315517494396, 0.5445062559403497}, {0.9986052928389547, 
      0.4535795468360151, 0.5450257460029394}, {0.9985724037818602, 
      0.45302751833866844`, 0.5455448854431916}, {0.9985391408484496, 
      0.4524754666799491, 0.5460636741685008}, {0.9985055043689108, 
      0.45192339228237877`, 0.5465821120865318}, {0.9984714946736751, 
      0.45137129556845385`, 0.547100199105221}, {0.998437112093418, 
      0.450819176960645, 0.5476179351327735}, {0.9984023569590593, 
      0.45026703688139463`, 0.5481353200776652}, {0.998367229601763, 
      0.44971487575312097`, 0.5486523538486422}, {0.9983317303529381, 
      0.4491626939982199, 0.5491690363547185}, {0.9982958595442383, 
      0.44861049203905984`, 0.5496853675051785}, {0.9982596175075623, 
      0.4480582702979876, 0.5502013472095748}, {0.9982230045750542, 
      0.44750602919732624`, 0.5507169753777279}, {0.9981860210791038, 
      0.4469537691593762, 0.551232251919728}, {0.9981486673523463, 
      0.44640149060641476`, 0.5517471767459315}, {0.9981109437276632, 
      0.4458491939607, 0.552261749766963}, {0.998072850538182, 
      0.4452968796444674, 0.5527759708937142}, {0.9980343881172766, 
      0.4447445480799329, 0.5532898400373435}, {0.997995556798568, 
      0.4441921996892918, 0.5538033571092765}, {0.9979563569159235, 
      0.4436398348947192, 0.554316522021204}, {0.9979167888034578, 
      0.4430874541183744, 0.5548293346850838}, {0.9978768527955332, 
      0.44253505778239494`, 0.555341795013138}, {0.9978365492267589, 
      0.44198264630890366`, 0.5558539029178555}, {0.9977958784319928, 
      0.4414302201200039, 0.5563656583119891}, {0.9977548407463402, 
      0.4408777796377827, 0.5568770611085574}, {0.9977134365051551, 
      0.44032532528431356`, 0.5573881112208415}, {0.99767166604404, 
      0.4397728574816517, 0.5578988085623883}, {0.9976295296988461, 
      0.43922037665183855`, 0.5584091530470073}, {0.9975870278056737, 
      0.4386678832169017, 0.5589191445887723}, {0.9975441607008726, 
      0.43811537759885344`, 0.5594287831020188}, {0.9975009287210418, 
      0.43756286021969554`, 0.5599380685013464}, {0.9974573322030305, 
      0.4370103315014141, 0.5604470007016166}, {0.9974133714839376, 
      0.43645779186598554`, 0.5609555796179524}, {0.9973690469011129, 
      0.4359052417353744, 0.5614638051657389}, {0.9973243587921562, 
      0.43535268153153334`, 0.5619716772606228}, {0.9972793074949186, 
      0.43480011167640603`, 0.5624791958185124}, {0.9972338933475019, 
      0.43424753259192655`, 0.5629863607555754}, {0.9971881166882598, 
      0.4336949447000191, 0.5634931719882408}, {0.9971419778557972, 
      0.4331423484225993, 0.5639996294331977}, {0.9970954771889713, 
      0.43258974418157664`, 0.5645057330073945}, {0.9970486150268911, 
      0.43203713239885255`, 0.5650114826280392}, {0.9970013917089187, 
      0.4314845134963191, 0.5655168782125995}, {0.9969538075746683, 
      0.4309318878958678, 0.5660219196788007}, {0.9969058629640075, 
      0.43037925601938115`, 0.5665266069446269}, {0.9968575582170573, 
      0.42982661828873625`, 0.5670309399283209}, {0.996808893674192, 
      0.42927397512580934`, 0.5675349185483826}, {0.9967598696760401, 
      0.4287213269524717, 0.5680385427235689}, {0.996710486563484, 
      0.4281686741905898, 0.5685418123728947}, {0.9966607446776609, 
      0.4276160172620301, 0.5690447274156313}, {0.9966106443599624, 
      0.42706335658865713`, 0.5695472877713056}, {0.9965601859520354, 
      0.42651069259233476`, 0.5700494933597007}, {0.9965093697957822, 
      0.4259580256949249, 0.5705513441008571}, {0.9964581962333605, 
      0.4254053563182934, 0.5710528399150674}, {0.9964066656071843, 
      0.42485268488430233`, 0.5715539807228823}, {0.9963547782599235, 
      0.42430001181481863`, 0.5720547664451051}, {0.9963025345345048, 
      0.4237473375317111, 0.5725551970027938}, {0.9962499347741117, 
      0.4231946624568508, 0.573055272317261}, {0.9961969793221852, 
      0.4226419870121138, 0.5735549923100713}, {0.9961436685224231, 
      0.4220893116193791, 0.5740543569030444}, {0.9960900027187817, 
      0.42153663670053076`, 0.5745533660182514}, {0.996035982255475, 
      0.4209839626774589, 0.5750520195780165}, {0.9959816074769756, 
      0.4204312899720602, 0.5755503175049157}, {0.9959268787280151, 
      0.4198786190062382, 0.576048259721777}, {0.9958717963535838, 
      0.419325950201904, 0.5765458461516796}, {0.9958163606989318, 
      0.4187732839809784, 0.5770430767179535}, {0.9957605721095686, 
      0.4182206207653885, 0.5775399513441802}, {0.9957044309312639, 
      0.4176679609770732, 0.5780364699541907}, {0.9956479375100481, 
      0.4171153050379823, 0.5785326324720661}, {0.995591092192212, 
      0.41656265337007486`, 0.5790284388221373}, {0.9955338953243076, 
      0.41601000639532404`, 0.5795238889289839}, {0.9954763472531485, 
      0.4154573645357135, 0.5800189827174349}, {0.99541844832581, 
      0.4149047282132431, 0.5805137201125672}, {0.9953601988896292, 
      0.41435209784992266`, 0.5810081010397065}, {0.9953015992922063, 
      0.4137994738677805, 0.5815021254244254}, {0.9952426498814038, 
      0.41324685668885924`, 0.5819957931925445}, {0.9951833510053476, 
      0.41269424673521693`, 0.5824891042701305}, {0.995123703012427, 
      0.4121416444289294, 0.5829820585834979}, {0.9950637062512956, 
      0.4115890501920893, 0.5834746560592063}, {0.9950033610708707, 
      0.4110364644468093, 0.5839668966240614}, {0.9949426678203347, 
      0.4104838876152201, 0.5844587802051147}, {0.9948816268491345, 
      0.40993132011947164`, 0.584950306729663}, {0.9948202385069829, 
      0.4093787623817366, 0.5854414761252462}, {0.994758503143858, 
      0.40882621482420783`, 0.5859322883196506}, {0.9946964211100041, 
      0.40827367786909946`, 0.5864227432409049}, {0.9946339927559323, 
      0.40772115193865155`, 0.5869128408172813}, {0.9945712184324201, 
      0.4071686374551234, 0.5874025809772966}, {0.9945080984905126, 
      0.40661613484080417`, 0.5878919636497082}, {0.9944446332815221, 
      0.4060636445180047, 0.5883809887635177}, {0.9943808231570295, 
      0.40551116690906247`, 0.5888696562479677}, {0.9943166684688834, 
      0.4049587024363406, 0.589357966032543}, {0.994252169569202, 
      0.4044062515222339, 0.5898459180469678}, {0.994187326810372, 
      0.4038538145891623, 0.5903335122212097}, {0.9941221405450501, 
      0.40330139205957577`, 0.5908207484854745}, {0.9940566111261627, 
      0.40274898435595347`, 0.5913076267702092}, {0.9939907389069068, 
      0.4021965919008076, 0.5917941470060991}, {0.9939245242407503, 
      0.40164421511667964`, 0.5922803091240705}, {0.993857967481432, 
      0.40109185442614514`, 0.5927661130552865}, {0.9937910689829624, 
      0.4005395102518126, 0.5932515587311501}, {0.9937238290996243, 
      0.39998718301632336`, 0.5937366460833008}, {0.9936562481859728, 
      0.39943487314235615`, 0.5942213750436168}, {0.9935883265968355, 
      0.39888258105262203`, 0.5947057455442132}, {0.993520064687314, 
      0.3983303071698735, 0.595189757517441}, {0.9934514628127831, 
      0.39777805191689464`, 0.5956734108958883}, {0.9933825213288919, 
      0.3972258157165133, 0.5961567056123789}, {0.9933132405915642, 
      0.3966735989915933, 0.5966396415999714}, {0.9932436209569987, 
      0.39612140216503827`, 0.5971222187919604}, {0.9931736627816695, 
      0.395569225659795, 0.5976044371218752}, {0.9931033664223269, 
      0.3950170698988492, 0.5980862965234778}, {0.9930327322359971, 
      0.39446493530523163`, 0.5985677969307651}, {0.9929617605799834, 
      0.39391282230201563`, 0.5990489382779678}, {0.9928904518118662, 
      0.39336073131231764`, 0.5995297204995487}, {0.9928188062895038, 
      0.39280866275930093`, 0.6000101435302027}, {0.9927468243710323, 
      0.3922566170661749, 0.6004902073048578}, {0.9926745064148669, 
      0.391704594656194, 0.600969911758673}, {0.9926018527797014, 
      0.39115259595266283`, 0.6014492568270388}, {0.9925288638245092, 
      0.39060062137893364`, 0.6019282424455761}, {0.9924555399085441, 
      0.3900486713584079, 0.6024068685501361}, {0.9923818813913399, 
      0.3894967463145393, 0.6028851350768005}, {0.9923078886327116, 
      0.38894484667083157`, 0.6033630419618802}, {0.9922335619927556, 
      0.38839297285084107`, 0.6038405891419144}, {0.9921589018318501, 
      0.3878411252781788, 0.6043177765536717}, {0.992083908510656, 
      0.38728930437650755`, 0.604794604134149}, {0.9920085823901166, 
      0.3867375105695477, 0.6052710718205688}, {0.9919329238314589, 
      0.3861857442810747, 0.6057471795503843}, {0.9918569331961938, 
      0.38563400593492086`, 0.6062229272612727}, {0.9917806108461165, 
      0.38508229595497834`, 0.6066983148911381}, {0.9917039571433068, 
      0.38453061476519534`, 0.6071733423781112}, {0.9916269724501302, 
      0.3839789627895824, 0.6076480096605481}, {0.991549657129238, 
      0.38342734045221044`, 0.6081223166770281}, {0.9914720115435678, 
      0.3828757481772104, 0.6085962633663574}, {0.9913940360563441, 
      0.38232418638877874`, 0.6090698496675652}, {0.991315731031079, 
      0.38177265551117573`, 0.6095430755199038}, {0.9912370968315721, 
      0.3812211559687234, 0.6100159408628488}, {0.9911581338219121, 
      0.3806696881858128, 0.6104884456360994}, {0.991078842366476, 
      0.3801182525869003, 0.6109605897795759}, {0.9909992228299309, 
      0.3795668495965104, 0.6114323732334207}, {0.9909192755772336, 
      0.37901547963923604`, 0.6119037959379974}, {0.9908390009736315, 
      0.37846414313974125`, 0.6123748578338901}, {0.9907583993846634, 
      0.3779128405227599, 0.6128455588619038}, {0.9906774711761593, 
      0.37736157221309613`, 0.6133158989630632}, {0.990596216714242, 
      0.3768103386356305, 0.6137858780786113}, {0.9905146363653267, 
      0.376259140215316, 0.6142554961500112}, {0.9904327304961218, 
      0.3757079773771781, 0.6147247531189438}, {0.9903504994736301, 
      0.37515685054632125`, 0.6151936489273085}, {0.9902679436651484, 
      0.3746057601479284, 0.6156621835172206}, {0.9901850634382686, 
      0.3740547066072547, 0.616130356831014}, {0.9901018591608783, 
      0.37350369034964065`, 0.6165981688112383}, {0.9900183312011615, 
      0.3729527118005031, 0.6170656194006586}, {0.9899344799275982, 
      0.37240177138534236`, 0.6175327085422562}, {0.9898503057089665, 
      0.37185086952973945`, 0.6179994361792266}, {0.989765808914342, 
      0.3713000066593612, 0.6184658022549805}, {0.9896809899130987, 
      0.37074918319995687`, 0.6189318067131417}, {0.98959584907491, 
      0.37019839957736206`, 0.6193974494975483}, {0.9895103867697489, 
      0.3696476562174987, 0.6198627305522506}, {0.9894246033678886, 
      0.3690969535463771, 0.6203276498215116}, {0.9893384992399031, 
      0.36854629199009736`, 0.6207922072498064}, {0.9892520747566682, 
      0.3679956719748478, 0.6212564027818209}, {0.9891653302893614, 
      0.36744509392690927`, 0.6217202363624524}, {0.9890782662094632, 
      0.3668945582726544, 0.6221837079368087}, {0.9889908828887574, 
      0.36634406543855075`, 0.6226468174502069}, {0.9889031806993318, 
      0.3657936158511586, 0.6231095648481734}, {0.9888151600135786, 
      0.36524320993713427`, 0.6235719500764442}, {0.9887268212041954, 
      0.3646928481232329, 0.6240339730809628}, {0.9886381646441857, 
      0.3641425308363055, 0.6244956338078805}, {0.9885491907068594, 
      0.36359225850330296`, 0.6249569322035566}, {0.9884598997658334, 
      0.36304203155127723`, 0.6254178682145564}, {0.9883702921950329, 
      0.36249185040738297`, 0.6258784417876504}, {0.9882803683686908, 
      0.361941715498874, 0.626338652869817}, {0.9881901286613498, 
      0.3613916272531115, 0.626798501408238}, {0.9880995734478618, 
      0.36084158609756145`, 0.6272579873503005}, {0.9880087031033898, 
      0.3602915924597959, 0.6277171106435944}, {0.9879175180034071, 
      0.3597416467674928, 0.6281758712359146}, {0.9878260185236994, 
      0.3591917494484411, 0.6286342690752582}, {0.9877342050403644, 
      0.3586419009305395, 0.6290923041098251}, {0.9876420779298134, 
      0.35809210164179844`, 0.6295499762880155}, {0.9875496375687709, 
      0.3575423520103384, 0.6300072855584327}, {0.9874568843342767, 
      0.3569926524643972, 0.6304642318698793}, {0.9873638186036849, 
      0.35644300343232543`, 0.6309208151713595}, {0.9872704407546664, 
      0.3558934053425914, 0.631377035412075}, {0.987176751165208, 
      0.3553438586237796, 0.6318328925414286}, {0.9870827502136141, 
      0.35479436370459416`, 0.6322883865090203}, {0.9869884382785072, 
      0.3542449210138591, 0.6327435172646483}, {0.9868938157388284, 
      0.3536955309805209, 0.6331982847583078}, {0.9867988829738383, 
      0.35314619403364755`, 0.6336526889401912}, {0.9867036403631178, 
      0.35259691060243126`, 0.6341067297606866}, {0.9866080882865684, 
      0.35204768111619084`, 0.6345604071703779}, {0.9865122271244139, 
      0.35149850600437044`, 0.6350137211200436}, {0.9864160572571997, 
      0.350949385696543, 0.6354666715606573}, {0.986319579065795, 
      0.35040032062240917`, 0.6359192584433859}, {0.9862227929313926, 
      0.34985131121180413`, 0.636371481719589}, {0.98612569923551, 
      0.34930235789469, 0.6368233413408199}, {0.98602829835999, 
      0.3487534611011673, 0.6372748372588232}, {0.9859305906870018, 
      0.348204621261467, 0.6377259694255346}, {0.9858325765990413, 
      0.34765583880595935`, 0.6381767377930823}, {0.9857342564789324, 
      0.34710711416515044`, 0.6386271423137818}, {0.9856356307098273, 
      0.3465584477696862, 0.6390771829401412}, {0.9855366996752075, 
      0.3460098400503519, 0.6395268596248558}, {0.9854374637588845, 
      0.3454612914380747, 0.6399761723208097}, {0.9853379233450009, 
      0.344912802363926, 0.6404251209810748}, {0.9852380788180308, 
      0.3443643732591209, 0.6408737055589101}, {0.9851379305627809, 
      0.34381600455501954`, 0.6413219260077612}, {0.9850374789643909, 
      0.34326769668313156`, 0.6417697822812594}, {0.9849367244083348, 
      0.34271945007511395`, 0.642217274333221}, {0.9848356672804215, 
      0.3421712651627739, 0.6426644021176479}, {0.9847343079667957, 
      0.34162314237807073`, 0.6431111655887248}, {0.9846326468539385, 
      0.34107508215311794`, 0.6435575647008209}, {0.9845306843286685, 
      0.3405270849201812, 0.6440035994084874}, {0.9844284207781425, 
      0.3399791511116847, 0.6444492696664575}, {0.9843258565898565, 
      0.3394312811602103, 0.6448945754296463}, {0.9842229921516462, 
      0.33888347549849696`, 0.6453395166531491}, {0.9841198278516884, 
      0.33833573455944677`, 0.6457840932922421}, {0.9840163640785012, 
      0.3377880587761207, 0.6462283053023803}, {0.9839126012209458, 
      0.3372404485817488, 0.6466721526391972}, {0.9838085396682261, 
      0.3366929044097202, 0.6471156352585058}, {0.9837041798098906, 
      0.33614542669359543`, 0.6475587531162955}, {0.9835995220358331, 
      0.33559801586710025`, 0.6480015061687326}, {0.9834945667362933, 
      0.3350506723641339, 0.6484438943721598}, {0.9833893143018578, 
      0.3345033966187628, 0.6488859176830953}, {0.9832837651234612, 
      0.3339561890652296, 0.6493275760582319}, {0.9831779195923867, 
      0.3334090501379499, 0.6497688694544365}, {0.983071778100267, 
      0.3328619802715178, 0.6502097978287497}, {0.9829653410390858, 
      0.332314979900701, 0.6506503611383846}, {0.9828586088011783, 
      0.33176804946045246`, 0.6510905593407261}, {0.9827515817792315, 
      0.3312211893859006, 0.6515303923933312}, {0.9826442603662865, 
      0.33067440011235955`, 0.6519698602539269}, {0.9825366449557383, 
      0.3301276820753283, 0.6524089628804103}, {0.9824287359413375, 
      0.32958103571049036`, 0.6528477002308475}, {0.9823205337171904, 
      0.3290344614537166, 0.653286072263474}, {0.982212038677761, 
      0.3284879597410693, 0.653724078936692}, {0.982103251217871, 
      0.3279415310087992, 0.6541617202090722}, {0.9819941717327016, 
      0.32739517569335214`, 0.6545989960393499}, {0.9818848006177938, 
      0.3268488942313668, 0.6550359063864274}, {0.9817751382690497, 
      0.3263026870596778, 0.6554724512093718}, {0.9816651850827338, 
      0.3257565546153206, 0.6559086304674133}, {0.9815549414554732, 
      0.3252104973355267, 0.6563444441199472}, {0.9814444077842593, 
      0.32466451565772914`, 0.6567798921265301}, {0.9813335844664486, 
      0.32411861001956654`, 0.6572149744468818}, {0.9812224718997635, 
      0.32357278085888064`, 0.6576496910408829}, {0.9811110704822937, 
      0.32302702861371985`, 0.6580840418685736}, {0.980999380612497, 
      0.3224813537223422, 0.6585180268901549}, {0.9808874026892003, 
      0.3219357566232131, 0.6589516460659871}, {0.9807751371116007, 
      0.32139023775501346`, 0.6593848993565876}, {0.9806625842792667, 
      0.3208447975566351, 0.6598177867226316}, {0.980549744592139, 
      0.3202994364671876, 0.6602503081249514}, {0.9804366184505316, 
      0.3197541549259974, 0.6606824635245346}, {0.9803232062551333, 
      0.31920895337260813`, 0.6611142528825252}, {0.980209508407008, 
      0.31866383224678835`, 0.6615456761602201}, {0.9800955253075965, 
      0.3181187919885262, 0.6619767333190701}, {0.979981257358717, 
      0.31757383303803755`, 0.6624074243206794}, {0.9798667049625669, 
      0.31702895583576307`, 0.6628377491268037}, {0.9797518685217231, 
      0.3164841608223736, 0.66326770769935}, {0.9796367484391438, 
      0.31593944843876853`, 0.6636973000003756}, {0.9795213451181691, 
      0.31539481912608175`, 0.6641265259920875}, {0.9794056589625223, 
      0.31485027332568, 0.6645553856368422}, {0.9792896903763115, 
      0.3143058114791694, 0.6649838788971421}, {0.9791734397640298, 
      0.31376143402839174`, 0.6654120057356384}, {0.9790569075305573, 
      0.3132171414154285, 0.6658397661151287}, {0.9789400940811616, 
      0.3126729340826063, 0.6662671599985557}, {0.9788229998214996, 
      0.3121288124724935, 0.6666941873490063}, {0.9787056251576182, 
      0.3115847770279068, 0.6671208481297115}, {0.9785879704959556, 
      0.31104082819191, 0.6675471423040457}, {0.9784700362433424, 
      0.3104969664078178, 0.667973069835525}, {0.9783518228070031, 
      0.30995319211919614`, 0.6683986306878069}, {0.9782333305945569, 
      0.3094095057698678, 0.6688238248246893}, {0.9781145600140193, 
      0.3088659078039102, 0.6692486522101097}, {0.9779955114738029, 
      0.30832239866565914`, 0.6696731128081438}, {0.9778761853827188, 
      0.3077789787997124, 0.6700972065830066}, {0.9777565821499783, 
      0.3072356486509305, 0.6705209334990481}, {0.9776367021851929, 
      0.3066924086644375, 0.6709442935207559}, {0.9775165458983772, 
      0.30614925928562536`, 0.6713672866127518}, {0.9773961136999485, 
      0.305606200960156, 0.6717899127397926}, {0.9772754060007295, 
      0.30506323413396164`, 0.672212171866768}, {0.9771544232119483, 
      0.30452035925324744`, 0.6726340639587008}, {0.977033165745241, 
      0.3039775767644961, 0.6730555889807448}, {0.9769116340126516, 
      0.30343488711446653`, 0.673476746898185}, {0.9767898284266345, 
      0.3028922907501992, 0.6738975376764353}, {0.976667749400055, 
      0.30234978811901525`, 0.6743179612810397}, {0.976545397346191, 
      0.30180737966852117`, 0.6747380176776696}, {0.976422772678734, 
      0.30126506584661206`, 0.6751577068321224}, {0.9762998758117908, 
      0.3007228471014671, 0.6755770287103238}, {0.9761767071598846, 
      0.3001807238815623, 0.6759959832783228}, {0.9760532671379567, 
      0.2996386966356638, 0.6764145705022928}, {0.9759295561613671, 
      0.2990967658128361, 0.6768327903485309}, {0.9758055746458965, 
      0.29855493186243903`, 0.6772506427834573}, {0.9756813230077477, 
      0.29801319523413616`, 0.6776681277736116}, {0.9755568016635464, 
      0.2974715563778916, 0.678085245285655}, {0.9754320110303434, 
      0.2969300157439752, 0.678501995286368}, {0.9753069515256151, 
      0.29638857378296557`, 0.6789183777426496}, {0.9751816235672658, 
      0.29584723094575044`, 0.6793343926215156}, {0.9750560275736283, 
      0.295305987683529, 0.679750039890099}, {0.9749301639634659, 
      0.29476484444781836`, 0.6801653195156477}, {0.9748040331559739, 
      0.29422380169045037`, 0.6805802314655237}, {0.97467763557078, 
      0.2936828598635764, 0.6809947757072037}, {0.9745509716279475, 
      0.29314201941967166`, 0.681408952208276}, {0.974424041747975, 
      0.2926012808115347, 0.6818227609364401}, {0.9742968463517994, 
      0.29206064449229363`, 0.6822362018595061}, {0.9741693858607958, 
      0.2915201109154026, 0.6826492749453937}, {0.9740416606967806, 
      0.29097968053465006`, 0.6830619801621307}, {0.9739136712820117, 
      0.2904393538041598, 0.6834743174778523}, {0.973785418039191, 
      0.289899131178392, 0.6838862868607994}, {0.9736569013914653, 
      0.28935901311214596`, 0.684297888279319}, {0.9735281217624276, 
      0.28881900006056643`, 0.6847091217018613}, {0.9733990795761198, 
      0.2882790924791393, 0.6851199870969803}, {0.973269775257033, 
      0.2877392908237016, 0.6855304844333313}, {0.9731402092301095, 
      0.28719959555043895`, 0.6859406136796709}, {0.9730103819207445, 
      0.2866600071158899, 0.6863503748048551}, {0.972880293754788, 
      0.2861205259769485, 0.6867597677778394}, {0.9727499451585453, 
      0.2855811525908688, 0.6871687925676763}, {0.9726193365587799, 
      0.28504188741526554`, 0.6875774491435146}, {0.9724884683827141, 
      0.28450273090811523`, 0.6879857374745987}, {0.9723573410580313, 
      0.2839636835277635, 0.6883936575302677}, {0.9722259550128773, 
      0.2834247457329238, 0.6888012092799534}, {0.9720943106758619, 
      0.28288591798268287`, 0.6892083926931795}, {0.9719624084760609, 
      0.2823472007365004, 0.6896152077395611}, {0.9718302488430169, 
      0.2818085944542141, 0.6900216543888027}, {0.9716978322067424, 
      0.28127009959604565`, 0.6904277326106971}, {0.9715651589977204, 
      0.2807317166225958, 0.6908334423751248}, {0.9714322296469063, 
      0.28019344599485413`, 0.6912387836520527}, {0.9712990445857298, 
      0.27965528817419755`, 0.6916437564115323}, {0.9711656042460963, 
      0.279117243622397, 0.6920483606236997}, {0.9710319090603893, 
      0.2785793128016169, 0.6924525962587728}, {0.9708979594614713, 
      0.2780414961744197, 0.6928564632870516}, {0.9707637558826862, 
      0.2775037942037703, 0.6932599616789162}, {0.9706292987578605, 
      0.2769662073530342, 0.6936630914048261}, {0.9704945885213059, 
      0.27642873608598834`, 0.6940658524353178}, {0.9703596256078203, 
      0.2758913808668148, 0.6944682447410054}, {0.9702244104526899, 
      0.2753541421601116, 0.6948702682925781}, {0.9700889434916911, 
      0.27481702043089207`, 0.6952719230607989}, {0.9699532251610922, 
      0.27428001614458875`, 0.6956732090165036}, {0.9698172558976554, 
      0.2737431297670556, 0.6960741261306002}, {0.9696810361386383, 
      0.27320636176457114`, 0.6964746743740674}, {0.9695445663217965, 
      0.2726697126038452, 0.6968748537179515}, {0.9694078468853841, 
      0.27213318275201576`, 0.6972746641333687}, {0.9692708782681574, 
      0.2715967726766582, 0.6976741055914993}, {0.9691336609093752, 
      0.27106048284578393`, 0.6980731780635914}, {0.9689961952488021, 
      0.27052431372784713`, 0.6984718815209549}, {0.968858481726709, 
      0.2699882657917457, 0.6988702159349631}, {0.9687205207838762, 
      0.2694523395068257, 0.6992681812770507}, {0.9685823128615946, 
      0.2689165353428817, 0.6996657775187127}, {0.9684438584016681, 
      0.2683808537701664, 0.7000630046315022}, {0.9683051578464158, 
      0.267845295259387, 0.7004598625870292}, {0.9681662116386732, 
      0.2673098602817133, 0.7008563513569601}, {0.9680270202217951, 
      0.26677454930877875`, 0.701252470913016}, {0.9678875840396564, 
      0.2662393628126855, 0.7016482212269711}, {0.9677479035366559, 
      0.2657043012660053, 0.7020436022706507}, {0.9676079791577166, 
      0.2651693651417854, 0.7024386140159312}, {0.9674678113482892, 
      0.264634554913552, 0.7028332564347378}, {0.9673274005543531, 
      0.26409987105531085`, 0.7032275294990424}, {0.9671867472224187, 
      0.26356531404155387`, 0.7036214331808649}, {0.9670458517995302, 
      0.26303088434726196`, 0.7040149674522685}, {0.966904714733267, 
      0.2624965824479077, 0.7044081322853597}, {0.9667633364717461, 
      0.2619624088194588, 0.7048009276522869}, {0.966621717463624, 
      0.2614283639383845, 0.7051933535252395}, {0.9664798581580994, 
      0.2608944482816546, 0.7055854098764454}, {0.9663377590049149, 
      0.2603606623267452, 0.7059770966781695}, {0.9661954204543595, 
      0.25982700655164687`, 0.7063684139027128}, {0.9660528429572702, 
      0.25929348143485936`, 0.7067593615224111}, {0.9659100269650353, 
      0.2587600874554029, 0.7071499395096329}, {0.9657669729295956, 
      0.2582268250928186, 0.7075401478367774}, {0.9656236813034471, 
      0.2576936948271721, 0.7079299864762754}, {0.9654801525396434, 
      0.2571606971390596, 0.7083194554005842}, {0.9653363870917978, 
      0.25662783250960997`, 0.7087085545821883}, {0.9651923854140856, 
      0.2560951014204873, 0.7090972839935983}, {0.9650481479612463, 
      0.25556250435389877`, 0.7094856436073476}, {0.9649036751885863, 
      0.25503004179259486`, 0.7098736333959914}, {0.9647589675519811, 
      0.25449771421987516`, 0.7102612533321063}, {0.9646140255078772, 
      0.25396552211959034`, 0.7106485033882873}, {0.9644688495132955, 
      0.25343346597614924`, 0.711035383537146}, {0.9643234400258323, 
      0.25290154627452155`, 0.7114218937513109}, {0.9641777975036632, 
      0.2523697635002401, 0.711808034003423}, {0.9640319224055444, 
      0.2518381181394078, 0.7121938042661371}, {0.9638858151908157, 
      0.25130661067869814`, 0.7125792045121174}, {0.963739476319403, 
      0.25077524160536546`, 0.7129642347140377}, {0.9635929062518205, 
      0.25024401140724145`, 0.7133488948445795}, {0.9634461054491733, 
      0.24971292057274402`, 0.7137331848764291}, {0.96329907437316, 
      0.24918196959088293`, 0.7141171047822771}, {0.9631518134860749, 
      0.2486511589512589, 0.7145006545348165}, {0.9630043232508118, 
      0.2481204891440714, 0.7148838341067401}, {0.9628566041308642, 
      0.24758996066012431`, 0.7152666434707401}, {0.9627086565903304, 
      0.24705957399082543`, 0.7156490825995049}, {0.962560481093915, 
      0.24652932962819626`, 0.7160311514657189}, {0.9624120781069306, 
      0.24599922806487098`, 0.7164128500420599}, {0.9622634480953025, 
      0.2454692697941058, 0.7167941783011966}, {0.9621145915255696, 
      0.2449394553097814, 0.7171751362157882}, {0.9619655088648877, 
      0.24440978510640712`, 0.7175557237584812}, {0.961816200581033, 
      0.24388025967912416`, 0.7179359409019089}, {0.9616666671424032, 
      0.24335087952371434`, 0.7183157876186888}, {0.9615169090180214, 
      0.2428216451366013, 0.7186952638814205}, {0.961366926677539, 
      0.24229255701485444`, 0.7190743696626845}, {0.9612167205912373, 
      0.2417636156561972, 0.7194531049350402}, {0.9610662912300317, 
      0.2412348215590086, 0.7198314696710232}, {0.9609156390654738, 
      0.2407061752223299, 0.7202094638431443}, {0.9607647645697538, 
      0.24017767714586577`, 0.720587087423888}, {0.9606136682157045, 
      0.23964932782999684`, 0.7209643403857083}, {0.9604623504768034, 
      0.2391211277757746, 0.7213412227010293}, {0.9603108118271756, 
      0.23859307748493339`, 0.7217177343422426}, {0.9601590527415969, 
      0.23806517745989303`, 0.722093875281704}, {0.960007073695497, 
      0.23753742820376444`, 0.7224696454917329}, {0.9598548751649623, 
      0.23700983022035313`, 0.7228450449446093}, {0.9597024576267382, 
      0.23648238401416474`, 0.7232200736125731}, {0.9595498215582334, 
      0.23595509009041296`, 0.7235947314678209}, {0.9593969674375216, 
      0.23542794895501715`, 0.7239690184825046}, {0.959243895743346, 
      0.23490096111461853`, 0.7243429346287278}, {0.9590906069551207, 
      0.23437412707657448`, 0.7247164798785469}, {0.9589371015529355, 
      0.23384744734897073`, 0.7250896542039651}, {0.9587833800175578, 
      0.23332092244062508`, 0.7254624575769332}, {0.9586294428304357, 
      0.23279455286108885`, 0.7258348899693472}, {0.9584752904737027, 
      0.2322683391206594, 0.7262069513530436}, {0.9583209234301788, 
      0.2317422817303783, 0.7265786416998007}, {0.9581663421833754, 
      0.2312163812020415, 0.7269499609813341}, {0.9580115472174972, 
      0.23069063804820125`, 0.7273209091692958}, {0.957856539017447, 
      0.23016505278217747`, 0.7276914862352696}, {0.9577013180688274, 
      0.22963962591805473`, 0.7280616921507729}, {0.9575458848579449, 
      0.2291143579706944, 0.728431526887251}, {0.9573902398718138, 
      0.22858924945573755`, 0.728800990416076}, {0.957234383598158, 
      0.2280643008896129, 0.7291700827085452}, {0.957078316525416, 
      0.22753951278953843`, 0.7295388037358774}, {0.9569220391427433, 
      0.22701488567353145`, 0.7299071534692119}, {0.9567655519400163, 
      0.22649042006041112`, 0.730275131879605}, {0.9566088554078355, 
      0.22596611646980627`, 0.7306427389380291}, {0.9564519500375291, 
      0.2254419754221606, 0.7310099746153687}, {0.9562948363211569, 
      0.22491799743873794`, 0.731376838882419}, {0.9561375147515129, 
      0.2243941830416295, 0.7317433317098833}, {0.9559799858221296, 
      0.22387053275375876`, 0.7321094530683709}, {0.9558222500272818, 
      0.22334704709888786`, 0.7324752029283937}, {0.9556643078619893, 
      0.22282372660162467`, 0.7328405812603649}, {0.9555061598220217, 
      0.22230057178742654`, 0.7332055880345951}, {0.9553478064039008, 
      0.22177758318260912`, 0.7335702232212916}, {0.9551892481049056, 
      0.221254761314351, 0.7339344867905547}, {0.9550304854230748, 
      0.2207321067106999, 0.7342983787123749}, {0.9548715188572119, 
      0.22020961990058088`, 0.7346618989566309}, {0.9547123489068875, 
      0.21968730141380013`, 0.7350250474930876}, {0.9545529760724445, 
      0.2191651517810521, 0.7353878242913925}, {0.954393400855001, 
      0.21864317153392848`, 0.7357502293210725}, {0.9542336237564544, 
      0.2181213612049209, 0.7361122625515337}, {0.9540736452794857, 
      0.2175997213274295, 0.7364739239520564}, {0.9539134659275631, 
      0.21707825243576995`, 0.7368352134917929}, {0.9537530862049459, 
      0.2165569550651804, 0.7371961311397658}, {0.9535925066166888, 
      0.2160358297518254, 0.7375566768648636}, {0.9534317276686453, 
      0.21551487703280492`, 0.7379168506358404}, {0.9532707498674728, 
      0.2149940974461627, 0.7382766524213101}, {0.9531095737206358, 
      0.21447349153088938`, 0.7386360821897463}, {0.9529481997364101, 
      0.21395305982693305`, 0.7389951399094775}, {0.9527866284238875, 
      0.21343280287520222`, 0.7393538255486857}, {0.9526248602929798, 
      0.21291272121757773`, 0.7397121390754021}, {0.9524628958544223, 
      0.21239281539691593`, 0.7400700804575061}, {0.9523007356197792, 
      0.21187308595705862`, 0.7404276496627206}, {0.952138380101447, 
      0.21135353344283694`, 0.7407848466586098}, {0.9519758298126593, 
      0.21083415840008277`, 0.7411416714125767}, {0.9518130852674909, 
      0.21031496137563208`, 0.7414981238918589}, {0.9516501469808624, 
      0.20979594291733547`, 0.7418542040635272}, {0.9514870154685443, 
      0.20927710357406337`, 0.7422099118944808}, {0.9513236912471619, 
      0.2087584438957164, 0.742565247351446}, {0.9511601748341993, 
      0.20823996443322762`, 0.7429202104009713}, {0.9509964667480045, 
      0.2077216657385791, 0.7432748010094258}, {0.9508325675077937, 
      0.20720354836479826`, 0.7436290191429958}, {0.9506684776336551, 
      0.20668561286597423`, 0.7439828647676807}, {0.9505041976465552, 
      0.20616785979726454`, 0.7443363378492909}, {0.9503397280683423, 
      0.20565028971489846`, 0.7446894383534437}, {0.9501750694217511, 
      0.20513290317619015`, 0.7450421662455611}, {0.9500102222304083, 
      0.20461570073954288`, 0.7453945214908655}, {0.9498451870188367, 
      0.20409868296446063`, 0.7457465040543761}, {0.9496799643124603, 
      0.2035818504115525, 0.7460981139009082}, {0.9495145546376089, 
      0.20306520364254263`, 0.7464493509950665}, {0.9493489585215236, 
      0.20254874322028038`, 0.7468002153012435}, {0.9491831764923608, 
      0.2020324697087454, 0.7471507067836157}, {0.9490172090791987, 
      0.20151638367305813`, 0.7475008254061406}, {0.9488510568120404, 
      0.20100048567948864`, 0.7478505711325517}, {0.9486847202218202, 
      0.20048477629546246`, 0.748199943926358}, {0.9485181998404085, 
      0.19996925608957133`, 0.7485489437508375}, {0.9483514962006172, 
      0.19945392563158298`, 0.7488975705690344}, {0.9481846098362042, 
      0.19893878549244828`, 0.7492458243437564}, {0.948017541281879, 
      0.19842383624430812`, 0.749593705037571}, {0.9478502910733082, 
      0.19790907846050776`, 0.7499412126128004}, {0.9476828597471204, 
      0.1973945127156009, 0.7502883470315198}, {0.9475152478409119, 
      0.19688013958535996`, 0.7506351082555521}, {0.9473474558932522, 
      0.1963659596467876, 0.7509814962464646}, {0.9471794844436888, 
      0.19585197347812258`, 0.7513275109655659}, {0.9470113340327533, 
      0.19533818165885228`, 0.7516731523739015}, {0.9468430052019667, 
      0.19482458476971765`, 0.7520184204322495}, {0.9466744984938457, 
      0.19431118339272824`, 0.7523633151011175}, {0.9465058144519064, 
      0.1937979781111673, 0.7527078363407393}, {0.9463369536206723, 
      0.19328496950960364`, 0.7530519841110688}, {0.9461679165456791, 
      0.19277215817390203`, 0.7533957583717769}, {0.9459987037734797, 
      0.19225954469122986`, 0.7537391590822498}, {0.9458293158516511, 
      0.19174712965006963`, 0.7540821862015816}, {0.9456597533288001, 
      0.19123491364022788`, 0.7544248396885721}, {0.9454900167545687, 
      0.19072289725284805`, 0.7547671195017212}, {0.9453201066796402, 
      0.1902110810804133, 0.7551090255992271}, {0.945150023655746, 
      0.1896994657167665, 0.75545055793898}, {0.9449797682356708, 
      0.18918805175711192`, 0.755791716478559}, {0.9448093409732589, 
      0.18867683979803243`, 0.7561325011752267}, {0.9446387424234208, 
      0.188165830437495, 0.7564729119859257}, {0.9444679731421389, 
      0.18765502427486427`, 0.7568129488672748}, {0.9442970336864743, 
      0.18714442191091096`, 0.7571526117755633}, {0.9441259246145726, 
      0.18663402394782533`, 0.7574919006667471}, {0.9439546464856708, 
      0.18612383098922672`, 0.7578308154964444}, {0.9437831998601034, 
      0.18561384364017108`, 0.7581693562199321}, {0.943611585299309, 
      0.18510406250717107`, 0.7585075227921383}, {0.9434398033658372, 
      0.1845944881981964, 0.758845315167641}, {0.9432678546233545, 
      0.18408512132269272`, 0.7591827333006619}, {0.9430957396366515, 
      0.18357596249159072`, 0.7595197771450614}, {0.9429234589716499, 
      0.18306701231731584`, 0.7598564466543345}, {0.9427510131954083, 
      0.1825582714138021, 0.7601927417816062}, {0.9425784028761305, 
      0.18204974039650496`, 0.7605286624796257}, {0.9424056285831706, 
      0.1815414198824073, 0.7608642087007633}, {0.9422326908870418, 
      0.18103331049003824`, 0.7611993803970033}, {0.9420595903594223, 
      0.18052541283948242`, 0.7615341775199403}, {0.9418863275731627, 
      0.18001772755238865`, 0.7618686000207746}, {0.941712903102293, 
      0.17951025525198738`, 0.7622026478503061}, {0.9415393175220306, 
      0.1790029965631013, 0.7625363209589293}, {0.9413655714087861, 
      0.1784959521121562, 0.7628696192966296}, {0.9411916653401724, 
      0.1779891225271971, 0.7632025428129756}, {0.9410175998950104, 
      0.17748250843789412`, 0.7635350914571164}, {0.9408433756533381, 
      0.17697611047556325`, 0.7638672651777749}, {0.9406689931964171, 
      0.17646992927317487`, 0.7641990639232423}, {0.9404944531067403, 
      0.17596396546536672`, 0.7645304876413738}, {0.94031975596804, 
      0.1754582196884575, 0.7648615362795824}, {0.9401449023652955, 
      0.17495269258046278`, 0.7651922097848326}, {0.9399698928847408, 
      0.1744473847811039, 0.7655225081036368}, {0.9397947281138724, 
      0.17394229693182436`, 0.7658524311820479}, {0.9396194086414582, 
      0.17343742967580392`, 0.7661819789656549}, {0.9394439350575438, 
      0.17293278365796794`, 0.7665111513995764}, {0.9392683079534622, 
      0.17242835952500732`, 0.7668399484284547}, {0.9390925279218413, 
      0.17192415792539023`, 0.767168369996451}, {0.938916595556612, 
      0.17142017950937394`, 0.7674964160472385}, {0.9387405114530172, 
      0.17091642492902015`, 0.7678240865239969}, {0.93856427620762, 
      0.17041289483821423`, 0.7681513813694058}, {0.9383878904183112, 
      0.16990958989267146`, 0.76847830052564}, {0.9382113546843194, 
      0.1694065107499579, 0.7688048439343621}, {0.9380346696062188, 
      0.16890365806950275`, 0.7691310115367163}, {0.9378578357859382, 
      0.16840103251261454`, 0.7694568032733233}, {0.937680853826769, 
      0.16789863474249606`, 0.7697822190842728}, {0.9375037243333758, 
      0.1673964654242578, 0.7701072589091178}, {0.9373264479118035, 
      0.16689452522493523`, 0.7704319226868681}, {0.9371490251694881, 
      0.16639281481350493`, 0.7707562103559834}, {0.9369714567152644, 
      0.16589133486089724`, 0.7710801218543668}, {0.9367937431593756, 
      0.16539008604001698`, 0.7714036571193592}, {0.9366158851134837, 
      0.16488906902575295`, 0.7717268160877306}, {0.9364378831906772, 
      0.1643882844950017, 0.772049598695676}, {0.936259738005482, 
      0.16388773312667676`, 0.7723720048788053}, {0.9360814501738703, 
      0.16338741560173048`, 0.7726940345721399}, {0.9359030203132708, 
      0.16288733260316893`, 0.7730156877101022}, {0.9357244490425768, 
      0.16238748481606424`, 0.7733369642265128}, {0.9355457369821594, 
      0.16188787292758133`, 0.7736578640545779}, {0.9353668847538735, 
      0.16138849762698626`, 0.7739783871268877}, {0.9351878929810714, 
      0.16088935960566633`, 0.7742985333754049}, {0.93500876228861, 
      0.1603904595571499, 0.7746183027314603}, {0.9348294933028635, 
      0.1598917981771208, 0.7749376951257427}, {0.934650086651732, 
      0.15939337616343763`, 0.7752567104882944}, {0.9344705429646527, 
      0.15889519421615234`, 0.7755753487485009}, {0.934290862872611, 
      0.15839725303752708`, 0.7758936098350843}, {0.9341110470081495, 
      0.15789955333205286`, 0.7762114936760967}, {0.9339310960053808, 
      0.1574020958064704, 0.7765290001989101}, {0.9337510104999965, 
      0.1569048811697862, 0.7768461293302109}, {0.93357079112928, 
      0.15640791013329067`, 0.7771628809959897}, {0.933390438532116, 
      0.15591118341058158`, 0.7774792551215346}, {0.933209953349002, 
      0.1554147017175781, 0.7777952516314236}, {0.933029336222061, 
      0.15491846577254706`, 0.7781108704495143}, {0.932848587795051, 
      0.1544224762961148, 0.7784261114989367}, {0.9326677087133776, 
      0.15392673401129142`, 0.7787409747020865}, {0.9324866996241055, 
      0.1534312396434922, 0.7790554599806132}, {0.9323055611759703, 
      0.1529359939205565, 0.7793695672554137}, {0.93212429401939, 
      0.1524409975727662, 0.7796832964466237}, {0.9319428988064774, 
      0.15194625133286943`, 0.7799966474736084}, {0.9317613761910525, 
      0.15145175593610027`, 0.7803096202549524}, {0.9315797268286536, 
      0.15095751212020045`, 0.7806222147084533}, {0.9313979513765512, 
      0.15046352062544058`, 0.7809344307511106}, {0.9312160504937594, 
      0.14996978219464238`, 0.7812462682991169}, {0.9310340248410484, 
      0.1494762975731983, 0.7815577272678499}, {0.9308518750809586, 
      0.14898306750909796`, 0.7818688075718605}, {0.9306696018778118, 
      0.1484900927529456, 0.7821795091248667}, {0.9304872058977252, 
      0.14799737405798488`, 0.7824898318397404}, {0.9303046878086249, 
      0.14750491218012415`, 0.7827997756285006}, {0.9301220482802581, 
      0.1470127078779568, 0.7831093404023016}, {0.929939287984207, 
      0.1465207619127819, 0.7834185260714249}, {0.9297564075939029, 
      0.14602907504863538`, 0.7837273325452677}, {0.9295734077846388, 
      0.1455376480523058, 0.7840357597323331}, {0.9293902892335847, 
      0.14504648169336434`, 0.7843438075402205}, {0.9292070526198001, 
      0.1445555767441854, 0.7846514758756145}, {0.929023698624249, 
      0.1440649339799743, 0.784958764644275}, {0.9288402279298144, 
      0.14357455417878842`, 0.7852656737510259}, {0.928656641221312, 
      0.143084438121567, 0.785572203099745}, {0.928472939185505, 
      0.14259458659215232`, 0.7858783525933533}, {0.9282891225111195, 
      0.14210500037731702`, 0.7861841221338032}, {0.9281051918888588, 
      0.14161568026679078`, 0.7864895116220678}, {0.9279211480114182, 
      0.14112662705328813`, 0.7867945209581306}, {0.927736991573501, 
      0.14063784153252862`, 0.7870991500409725}, {0.9275527232718334, 
      0.14014932450327205`, 0.7874033987685616}, {0.9273683438051804, 
      0.13966107676734002`, 0.7877072670378407}, {0.9271838538743609, 
      0.13917309912964404`, 0.7880107547447168}, {0.9269992541822643, 
      0.13868539239821726`, 0.7883138617840476}, {0.9268145454338663, 
      0.1381979573842355, 0.7886165880496306}, {0.9266297283362448, 
      0.13771079490205387`, 0.7889189334341912}, {0.926444803598597, 
      0.13722390576922874`, 0.789220897829369}, {0.9262597719322556, 
      0.13673729080654934`, 0.7895224811257062}, {0.9260746340507057, 
      0.13625095083806996`, 0.7898236832126355}, {0.9258893906696014, 
      0.1357648866911355, 0.7901245039784662}, {0.9257040425067834, 
      0.13527909919640999`, 0.7904249433103735}, {0.9255185902822967, 
      0.13479358918791493`, 0.7907250010943816}, {0.9253330347184071, 
      0.13430835750305303`, 0.7910246772153542}, {0.92514737653962, 
      0.1338234049826413, 0.7913239715569792}, {0.924961616472697, 
      0.13333873247094044`, 0.7916228840017564}, {0.9247757552466762, 
      0.13285434081569494`, 0.7919214144309817}, {0.9245897935928885, 
      0.13237023086815294`, 0.792219562724736}, {0.9244037322449765, 
      0.13188640348310793`, 0.7925173287618691}, {0.924217571938915, 
      0.13140285951892883`, 0.7928147124199861}, {0.9240313134130269, 
      0.1309195998375934, 0.7931117135754339}, {0.9238449574080059, 
      0.13043662530472167`, 0.7934083321032844}, {0.9236585046669328, 
      0.12995393678961034`, 0.7937045678773227}, {0.9234719559352974, 
      0.12947153516526713`, 0.7940004207700302}, {0.923285311961017, 
      0.12898942130844682`, 0.7942958906525701}, {0.9230985734944572, 
      0.12850759609968523`, 0.7945909773947717}, {0.9229117412884519, 
      0.12802606042333672`, 0.7948856808651154}, {0.9227248160983238, 
      0.12754481516760663`, 0.7951800009307175}, {0.9225377986819056, 
      0.12706386122459282`, 0.7954739374573132}, {0.9223506897995608, 
      0.12658319949031957`, 0.7957674903092413}, {0.9221634902142045, 
      0.12610283086477628`, 0.796060659349428}, {0.9219762006913265, 
      0.1256227562519563, 0.7963534444393698}, {0.9217888219990111, 
      0.12514297655989393`, 0.796645845439117}, {0.9216013549079598, 
      0.12466349270070147`, 0.7969378622072583}, {0.9214138001915153, 
      0.12418430559061457`, 0.7972294946009006}, {0.9212261586256816, 
      0.12370541615002745`, 0.7975207424756546}, {0.9210384309891477, 
      0.12322682530353087`, 0.7978116056856167}, {0.9208506180633125, 
      0.12274853397996323`, 0.7981020840833493}, {0.9206627206323049, 
      0.12227054311244011`, 0.7983921775198648}, {0.9204747394830105, 
      0.12179285363840317`, 0.7986818858446075}, {0.9202866754050935, 
      0.12131546649966027`, 0.7989712089054336}, {0.9200985291910226, 
      0.12083838264242959`, 0.7992601465485933}, {0.9199103016360943, 
      0.12036160301738237`, 0.7995486986187123}, {0.9197219935384584, 
      0.11988512857968697`, 0.7998368649587714}, {0.9195336056991428, 
      0.11940896028905389`, 0.800124645410089}, {0.9193451389220798, 
      0.11893309910978117`, 0.8004120398122987}, {0.9191565940141303, 
      0.11845754601079847`, 0.8006990480033324}, {0.9189679717851122, 
      0.11798230196571513`, 0.8009856698193971}, {0.918779273047824, 
      0.11750736795286741`, 0.8012719050949567}, {0.9185904986180746, 
      0.11703274495536474`, 0.80155775366271}, {0.9184016493147082, 
      0.11655843396113913`, 0.8018432153535693}, {0.9182127259596323, 
      0.11608443596299194`, 0.802128289996641}, {0.918023729377846, 
      0.11561075195864459`, 0.8024129774192017}, {0.917834660397468, 
      0.11513738295079064`, 0.8026972774466772}, {0.9176455198497642, 
      0.11466432994714339`, 0.8029811899026208}, {0.9174563085691776, 
      0.11419159396048706`, 0.8032647146086906}, {0.9172670273933576, 
      0.11371917600873199`, 0.8035478513846257}, {0.9170776771631889, 
      0.1132470771149653, 0.8038306000482236}, {0.9168882587228218, 
      0.1127752983075048, 0.8041129604153171}, {0.916698772919702, 
      0.11230384061995095`, 0.8043949322997511}, {0.9165092206046033, 
      0.11183270509124701`, 0.8046765155133564}, {0.9163196026316559, 
      0.11136189276572837`, 0.8049577098659275}, {0.9161299198583808, 
      0.11089140469318476`, 0.8052385151651958}, {0.9159401731457194, 
      0.11042124192891285`, 0.8055189312168064}, {0.9157503633580675, 
      0.1099514055337762, 0.8057989578242916}, {0.9155604913633081, 
      0.10948189657426402`, 0.8060785947890441}, {0.9153705580328432, 
      0.10901271612254983`, 0.8063578419102936}, {0.915180564241629, 
      0.10854386525655282`, 0.8066366989850765}, {0.9149905108682103, 
      0.10807534505999793`, 0.8069151658082119}, {0.9148003987947527, 
      0.10760715662247937`, 0.8071932421722735}, {0.9146102289070812, 
      0.10713930103952025`, 0.8074709278675608}, {0.9144200020947132, 
      0.10667177941264144`, 0.8077482226820717}, {0.9142297192508945, 
      0.10620459284941985`, 0.8080251264014751}, {0.9140393812726382, 
      0.1057377424635591, 0.8083016388090789}, {0.9138489890607593, 
      0.10527122937495571`, 0.8085777596858043}, {0.9136585435199126, 
      0.10480505470976009`, 0.808853488810153}, {0.9134680455586328, 
      0.10433921960045464`, 0.8091288259581783}, {0.9132774960893697, 
      0.10387372518591523`, 0.8094037709034548}, {0.9130868960285305, 
      0.10340857261148396`, 0.8096783234170464}, {0.9128962462965176, 
      0.10294376302904346`, 0.8099524832674743}, {0.9127055478177694, 
      0.10247929759708303`, 0.8102262502206863}, {0.9125148015208006, 
      0.102015177480777, 0.8104996240400235}, {0.9123240083382447, 
      0.10155140385205827`, 0.8107726044861868}, {0.9121331692068945, 
      0.10108797788969005`, 0.8110451913172042}, {0.9119422850677452, 
      0.10062490077934885`, 0.8113173842883965}, {0.9117513568660384, 
      0.10016217371369648`, 0.8115891831523417}, {0.9115603855513039, 
      0.09969979789246178, 0.8118605876588421}, {0.9113693720774064, 
      0.0992377745225202, 0.8121315975548862}, {0.9111783174025885, 
      0.09877610481797412, 0.8124022125846142}, {0.9109872224895171, 
      0.09831479000023648, 0.8126724324892808}, {0.9107960883053303, 
      0.09785383129811287, 0.812942257007218}, {0.9106049158216836, 
      0.09739322994788731, 0.8132116858737968}, {0.910413706014798, 
      0.09693298719340927, 0.813480718821389}, {0.9102224598655073, 
      0.09647310428617903, 0.8137493555793288}, {0.91003117835931, 
      0.0960135824854382, 0.8140175958738716}, {0.9098398624864152, 
      0.09555442305825995, 0.8142854394281556}, {0.9096485132417965, 
      0.0950956272796378, 0.8145528859621587}, {0.9094571316252418, 
      0.09463719643258332, 0.8148199351926588}, {0.9092657186414046, 
      0.09417913180821325, 0.8150865868331915}, {0.9090742752998586, 
      0.09372143470585328, 0.8153528405940051}, {0.908882802615151, 
      0.09326410643313147, 0.81561869618202}, {0.9086913016068556, 
      0.09280714830607405, 0.8158841533007816}, {0.9084997732996294, 
      0.09235056164921249, 0.8161492116504171}, {0.9083082187232686, 
      0.09189434779567981, 0.8164138709275888}, {0.9081166389127648, 
      0.09143850808731635, 0.8166781308254489}, {0.9079250349083643, 
      0.09098304387477449, 0.8169419910335901}, {0.9077334077556253, 
      0.09052795651762564, 0.8172054512379996}, {0.9075417585054788, 
      0.09007324738446953, 0.8174685111210094}, {0.9073500882142878, 
      0.0896189178530416, 0.8177311703612467}, {0.9071583979439114, 
      0.08916496931032893, 0.8179934286335829}, {0.9069666887617639, 
      0.08871140315267982, 0.8182552856090846}, {0.9067749617408819, 
      0.08825822078592419, 0.8185167409549579}, {0.9065832179599858, 
      0.08780542362548806, 0.8187777943344982}, {0.9063914585035477, 
      0.08735301309651301, 0.8190384454070347}, {0.9061996844618561, 
      0.08690099063397866, 0.8192986938278775}, {0.9060078969310849, 
      0.0864493576828261, 0.8195585392482587}, {0.9058160970133616, 
      0.08599811569808179, 0.8198179813152796}, {0.9056242858168378, 
      0.08554726614498928, 0.8200770196718483}, {0.905432464455759, 
      0.08509681049913319, 0.8203356539566261}, {0.9052406340505385, 
      0.08464675024657449, 0.820593883803964}, {0.9050487957278288, 
      0.08419708688398593, 0.8208517088438434}, {0.9048569506205979, 
      0.0837478219187839, 0.8211091287018144}, {0.9046650998682052, 
      0.08329895686927391, 0.8213661429989317}, {0.9044732446164763, 
      0.08285049326478257, 0.8216227513516934}, {0.9042813860177834, 
      0.08240243264581054, 0.8218789533719729}, {0.9040895252311257, 
      0.0819547765641725, 0.8221347486669536}, {0.9038976634222081, 
      0.08150752658314658, 0.8223901368390615}, {0.9037058017635258, 
      0.08106068427762896, 0.8226451174858973}, {0.9035139414344462, 
      0.08061425123428018, 0.8228996902001657}, {0.9033220836212958, 
      0.0801682290516921, 0.8231538545696037}, {0.903130229517446, 
      0.07972261934053661, 0.8234076101769094}, {0.9029383803234021, 
      0.07927742372373503, 0.8236609565996672}, {0.9027465372468924, 
      0.07883264383661977, 0.8239138934102728}, {0.9025547015029586, 
      0.0783882813271007, 0.8241664201758578}, {0.9023628743140523, 
      0.07794433785584313, 0.8244185364582096}, {0.9021710569101248, 
      0.07750081509643021, 0.8246702418136946}, {0.9019792505287273, 
      0.07705771473555288, 0.8249215357931745}, {0.9017874564151062, 
      0.07661503847317937, 0.8251724179419272}, {0.9015956758223047, 
      0.07617278802274516, 0.8254228877995592}, {0.901403910011263, 
      0.07573096511133932, 0.8256729448999235}, {0.9012121602509224, 
      0.07528957147989226, 0.82592258877103}, {0.9010204278183307, 
      0.07484860888337319, 0.8261718189349575}, {0.9008287139987482, 
      0.07440807909098444, 0.8264206349077639}, {0.9006370200857575, 
      0.07396798388636432, 0.8266690361993931}, {0.9004453473813753, 
      0.07352832506779426, 0.826917022313581}, {0.9002536971961647, 
      0.07308910444840566, 0.8271645927477594}, {0.9000620708493503, 
      0.07265032385639113, 0.827411746992959}, {0.8998704696689365, 
      0.07221198513522621, 0.8276584845337102}, {0.8996788949918263, 
      0.07177409014388789, 0.8279048048479388}, {0.8994873481639439, 
      0.07133664075707849, 0.8281507074068652}, {0.8992958305403587, 
      0.07089963886546101, 0.8283961916748975}, {0.8991043434854115, 
      0.07046308637588793, 0.8286412571095234}, {0.8989128883728436, 
      0.07002698521164229, 0.8288859031612013}, {0.8987214665859289, 
      0.06959133731268337, 0.8291301292732459}, {0.8985300795176081, 
      0.06915614463589217, 0.829373934881716}, {0.8983387285706235, 
      0.06872140915532654, 0.8296173194152966}, {0.8981474151576606, 
      0.0682871328624811, 0.8298602822951794}, {0.89795614070149, 
      0.0678533177665491, 0.830102822934941}, {0.8977649066351101, 
      0.06741996589469085, 0.8303449407404198}, {0.8975737144018974, 
      0.06698707929230972, 0.8305866351095875}, {0.8973825654557563, 
      0.06655466002333607, 0.8308279054324207}, {0.8971914612612732, 
      0.06612271017050592, 0.8310687510907679}, {0.8970004032938727, 
      0.06569123183565821, 0.831309171458215}, {0.8968093930399779, 
      0.06526022714003035, 0.8315491658999475}, {0.8966184319971744, 
      0.06482969822456565, 0.831788733772609}, {0.8964275216743771, 
      0.06439964725021995, 0.8320278744241575}, {0.8962366635919999, 
      0.06397007639828192, 0.8322665871937178}, {0.8960458592821291, 
      0.06354098787069615, 0.8325048714114333}, {0.895855110288702, 
      0.06311238389039275, 0.8327427263983093}, {0.8956644181676872, 
      0.0626842667016286, 0.8329801514660586}, {0.8954737844872689, 
      0.06225663857032853, 0.8332171459169404}, {0.8952832108280376, 
      0.06182950178444202, 0.8334537090435962}, {0.8950926987831823, 
      0.06140285865430178, 0.8336898401288811}, {0.8949022499586871, 
      0.06097671151299284, 0.8339255384456943}, {0.8947118659735321, 
      0.06055106271672885, 0.8341608032568033}, {0.8945215484599015, 
      0.06012591464523808, 0.8343956338146633}, {0.8943312990633918, 
      0.05970126970215653, 0.8346300293612353}, {0.8941411194432278, 
      0.05927713031543082, 0.8348639891277975}, {0.8939510112724814, 
      0.05885349893772728, 0.8350975123347543}, {0.8937609762382973, 
      0.05843037804685881, 0.835330598191439}, {0.8935710160421222, 
      0.058007770146208996`, 0.8355632458959132}, {0.893381132399939, 
      0.05758567776517768, 0.8357954546347617}, {0.8931913270425096, 
      0.05716410345962991, 0.8360272235828794}, {0.8930016017156167, 
      0.056743049812357886`, 0.8362585519032588}, {0.892811958180319, 
      0.056322519433552154`, 0.8364894387467674}, {0.8926223982132059, 
      0.05590251496128525, 0.8367198832519209}, {0.8924329236066619, 
      0.05548303906200735, 0.8369498845446541}, {0.8922435361691361, 
      0.055064094431055595`, 0.8371794417380801}, {0.8920542377254166, 
      0.054645683793166214`, 0.837408553932251}, {0.8918650301169151, 
      0.05422780990301091, 0.8376372202139044}, {0.891675915201955, 
      0.053810475545743544`, 0.837865439656212}, {0.891486894856066, 
      0.0533936835375508, 0.8380932113185152}, {0.8912979709722901, 
      0.05297743672623122, 0.8383205342460586}, {0.8911091454614904, 
      0.052561737991777824`, 0.8385474074697125}, {0.8909204202526699, 
      0.05214659024697626, 0.8387738300056936}, {0.890731797293298, 
      0.05173199643802556, 0.8389998008552728}, {0.8905432785496447, 
      0.051317959545165145`, 0.8392253190044798}, {0.890354866007123, 
      0.050904482583324875`, 0.8394503834237986}, {0.8901665616706402, 
      0.050491568602785794`, 0.8396749930678541}, {0.8899783675649594, 
      0.050079220689868344`, 0.839899146875091}, {0.8897902857350678, 
      0.04966744196762238, 0.8401228437674454}, {0.8896023182465562, 
      0.04925623559655048, 0.8403460826500058}, {0.8894144671860078, 
      0.04884560477534191, 0.8405688624106659}, {0.8892267346613981, 
      0.04843555274163049, 0.8407911819197681}, {0.8890391228025029, 
      0.04802608277276547, 0.841013040029737}, {0.8888516337613203, 
      0.047617198186618186`, 0.8412344355747027}, {0.8886642697125017, 
      0.047208902342387525`, 0.8414553673701138}, {0.8884770328537958, 
      0.04680119864145638, 0.8416758342123398}, {0.8882899254065029, 
      0.04639409052824055, 0.8418958348782629}, {0.8881029496159434, 
      0.04598758149108734, 0.8421153681248561}, {0.887916107751939, 
      0.0455816750631871, 0.8423344326887519}, {0.8877294021093052, 
      0.045176374823507795`, 0.8425530272857975}, {0.8875428350083612, 
      0.04477168439776506, 0.8427711506105962}, {0.8873564087954496, 
      0.04436760745941142, 0.8429888013360384}, {0.8871701258434762, 
      0.04396414773066182, 0.8432059781128142}, {0.8869839885524586, 
      0.04356130898354143, 0.8434226795689173}, {0.8867979993500985, 
      0.043159095040970236`, 0.8436389043091287}, {0.8866121606923635, 
      0.04275750977787474, 0.8438546509144887}, {0.8864264750640897, 
      0.04235655712233872, 0.8440699179417515}, {0.8862409449796012, 
      0.04195624105677748, 0.8442847039228233}, {0.8860555729833488, 
      0.041556565619166756`, 0.8444990073641826}, {0.8858703616505663, 
      0.04115753490428226, 0.8447128267462841}, {0.8856853135879474, 
      0.040759153065004, 0.8449261605229434}, {0.8855004314343441, 
      0.04036142431364328, 0.8451390071207011}, {0.8853157178614852, 
      0.03996435292331717, 0.8453513649381682}, {0.8851311755747172, 
      0.03956794322936697, 0.8455632323453505}, {0.8849468073137694, 
      0.039172199630818354`, 0.8457746076829512}, {0.8847626158535419, 
      0.038777126591891246`, 0.8459854892616507}, {0.8845786040049206, 
      0.03838272864355945, 0.8461958753613615}, {0.8843947746156151, 
      0.037989010385153274`, 0.8464057642304618}, {0.8842111305710263, 
      0.03759597648602529, 0.8466151540850009}, {0.8840276747951415, 
      0.037203631687263504`, 0.8468240431078783}, {0.8838444102514599, 
      0.03681198080346361, 0.8470324294479961}, {0.8836613399439454, 
      0.036421028724562966`, 0.8472403112193824}, {0.8834784669180166, 
      0.03603078041773492, 0.8474476865002821}, {0.8832957942615656, 
      0.03564124092934487, 0.8476545533322205}, {0.8831133251060153, 
      0.035252415386985314`, 0.84786090971903}, {0.8829310626274086, 
      0.03486430900156468, 0.8480667536258445}, {0.8827490100475403, 
      0.03447692706948266, 0.8482720829780581}, {0.882567170635126, 
      0.03409027497488149, 0.8484768956602445}, {0.8823855477070129, 
      0.03370435819197406, 0.8486811895150392}, {0.8822041446294335, 
      0.033319182287453245`, 0.8488849623419804}, {0.8820229648193045, 
      0.03293475292299935, 0.8490882118963053}, {0.881842011745576, 
      0.032551075857873236`, 0.8492909358877032}, {0.8816612889306243, 
      0.03216815695160276, 0.8494931319790217}, {0.881480799951704, 
      0.031786002166783164`, 0.8496947977849206}, {0.8813005484424479, 
      0.03140461757196821, 0.8498959308704797}, {0.8811205380944275, 
      0.031024009344681497`, 0.8500965287497461}, {0.8809407726587735, 
      0.030644183774544642`, 0.8502965888842289}, {0.8807612559478561, 
      0.030265147266523042`, 0.8504961086813336}, {0.8805819918370358, 
      0.029886906344304912`, 0.8506950854927313}, {0.8804029842664782, 
      0.029509467653812998`, 0.8508935166126653}, {0.8802242372430457, 
      0.029132837966860663`, 0.8510913992761855}, {0.8800457548422624, 
      0.028757024184949544`, 0.8512887306573129}, {0.8798675412103631, 
      0.028382033343239542`, 0.8514855078671236}, {0.8796896005664219, 
      0.028007872614665717`, 0.8516817279517566}, {0.8795119372045744, 
      0.027634549314242172`, 0.8518773878903322}, {0.8793345554963314, 
      0.02726207090354836, 0.8520724845927836}, {0.8791574598929919, 
      0.026890444995400175`, 0.8522670148975918}, {0.8789806549281602, 
      0.026519679358737627`, 0.852460975569423}, {0.8788041452203751, 
      0.026149781923717752`, 0.8526543632966576}, {0.8786279354758509, 
      0.025780760787040998`, 0.85284717468881}, {0.8784520304913469, 
      0.025412624217516534`, 0.8530394062738306}, {0.8782764351571627, 
      0.02504538066188241, 0.8532310544952801}, {0.878101154460273, 
      0.02467903875089702, 0.8534221157093761}, {0.8779261934876073, 
      0.024313607305712078`, 0.8536125861818955}, {0.8777515574294847, 
      0.023949095344552866`, 0.8538024620849318}, {0.8775772515832109, 
      0.023585512089716827`, 0.853991739493494}, {0.8774032813568502, 
      0.023222866974913204`, 0.8541804143819369}, {0.8772296522731825, 
      0.022861169652966765`, 0.8543684826202158}, {0.877056369973853, 
      0.02250043000390162, 0.8545559399699517}, {0.8768834402237354, 
      0.022140658143441117`, 0.8547427820802946}, {0.876710868915513, 
      0.02178186443193888, 0.8549290044835741}, {0.8765386620744972, 
      0.021424059483776965`, 0.8551146025907208}, {0.8763668258637, 
      0.02106725417725562, 0.855299571686444}, {0.8761953665891725, 
      0.02071145966502072, 0.8554839069241514}, {0.8760242907056339, 
      0.020356687385046274`, 0.8556676033205879}, {0.8758536048224054, 
      0.020002949072226186`, 0.8558506557501793}, {0.8756833157096748, 
      0.01965025677061785, 0.856033058939057}, {0.8755134303051121, 
      0.019298622846370468`, 0.8562148074587412}, {0.8753439557208644, 
      0.018948060001406936`, 0.856395895719458}, {0.8751748992509545, 
      0.018598581287891235`, 0.8565763179630637}, {0.8750062683791174, 
      0.0182502001235715, 0.8567560682555457}, {0.8748380707871041, 
      0.017902930308034304`, 0.85693514047907}, {0.8746703143634917, 
      0.01755678603995803, 0.8571135283235342}, {0.8745030072130376, 
      0.01721178193544222, 0.8572912252775955}, {0.8743361576666208, 
      0.016867933047495447`, 0.8574682246191259}, {0.8741697742918206, 
      0.016525254886772787`, 0.8576445194050475}, {0.874003865904182, 
      0.016183763443681876`, 0.8578201024605006}, {0.8738384415792264, 
      0.015843475211941915`, 0.8579949663672846}, {0.8736735106652733, 
      0.015504407213763971`, 0.8581691034515091}, {0.8735090827971379, 
      0.015166577026746236`, 0.8583425057703917}, {0.8733451679107905, 
      0.014830002812672098`, 0.8585151650981182}, {0.8731817762590574, 
      0.014494703348372683`, 0.8586870729106851}, {0.8730189184284586, 
      0.014160698058827024`, 0.8588582203696318}, {0.8728566053572985, 
      0.013828007052746814`, 0.8590285983045516}, {0.8726948483551134, 
      0.01349665116084108, 0.8591981971942728}, {0.8725336591236258, 
      0.013166651977057037`, 0.8593670071465692}, {0.8723730497793409, 
      0.012838031903078615`, 0.8595350178762627}, {0.8722130328779611, 
      0.012510814196415313`, 0.8597022186815455}, {0.8720536214408032, 
      0.012185023022462382`, 0.8598685984183413}, {0.8718948289834331, 
      0.011860683510938686`, 0.8600341454724945}, {0.8717366695467578, 
      0.011537821817210234`, 0.8601988477295477}, {0.8715791577308476, 
      0.011216465189004364`, 0.860362692541843}, {0.8714223087318035, 
      0.01089664203916865, 0.860525666692635}, {0.8712661383820128, 
      0.010578382025141584`, 0.8606877563568714}, {0.8711106631942175, 
      0.010261716135980545`, 0.860848947058237}, {0.8709559004098408, 
      0.009946676787839238, 0.8610092236220016}, {0.870801868052126, 
      0.009633297928982583, 0.8611685701231435}, {0.8706485849846972, 
      0.009321615155564298, 0.8613269698291329}, {0.8704960709762679, 
      0.009011665839602013, 0.8614844051366661}, {0.8703443467723374, 
      0.008703489270821875, 0.8616408575015151}, {0.8701934341748507, 
      0.008397126814321315, 0.8617963073605295}, {0.870043356130988, 
      0.008092622086347194, 0.8619507340446406}, {0.8698941368324359, 
      0.007790021150912939, 0.8621041156815226}, {0.8697458018267622, 
      0.007489372740450283, 0.8622564290863116}, {0.8695983781428259, 
      0.0071907285043596135`, 0.8624076496384662}, {0.8694518944325305, 
      0.00689414329004588, 0.8625577511424846}, {0.8693063811317154, 
      0.006599675462009809, 0.8627067056697061}, {0.8691618706435771, 
      0.006307387265738311, 0.8628544833778392}, {0.8690183975487538, 
      0.00601734524464255, 0.8630010523041111}, {0.8688759988471857, 
      0.005729620720215039, 0.863146378126971}, {0.8687347142380748, 
      0.005444290348004528, 0.8632904238900703}, {0.8685945864458662, 
      0.005161436765213282, 0.8634331496806534}, {0.8684556616022533, 
      0.004881149349826549, 0.8635745122524271}, {0.868317989696969, 
      0.004603525116739077, 0.8637144645802303}, {0.8681816251138063, 
      0.004328669783644371, 0.863852955330162}, {0.8680466272733193, 
      0.004056699049478559, 0.8639899282238408}, {0.8679130614105532, 
      0.0037877401419432926`, 0.86412532126861}, {0.8677809995257941, 
      0.0035219337099028796`, 0.8642590658158911}, {0.8676505215600527, 
      0.0032594361638284696`, 0.8643910853962243}, {0.8675217168669641, 
      0.0030004226073186407`, 0.8645212942596455}, {0.8673946860823909, 
      0.0027450905618481587`, 0.8646495955205428}, {0.8672695435381301, 
      0.002493664776965896, 0.8647758787611641}, {0.8671464204367443, 
      0.0022464035591922096`, 0.8649000168775525}, {0.8670254691188409, 
      0.0020036072811668868`, 0.8650218618376745}, {0.8669068689461715, 
      0.0017656301162112748`, 0.8651412388299603}, {0.86679083466135, 
      0.0015328967175634043`, 0.8652579379437866}, {0.8666776287102181, 
      0.0013059268107403752`, 0.8653717018994778}, {0.8665675802491154, 
      0.0010853731377590099`, 0.8654822071113565}, {0.866461116210531, 
      0.0008720834902763397, 0.8655890327202551}, {0.866358816117157, 
      0.0006672101935256958, 0.8656916059236313}, {0.8662615196974638, 
      0.00047242511036060065`, 0.8657890945871032}, {0.8661705752345571, 
      0.0002904159420505451, 0.865880159292507}, {0.86608860191034, 
      0.00012641009046551434`, 0.8659621918198749}, {0.8660254037844387, 
      1.2246467991473532`*^-16, 0.8660254037844388}, {0.8664715833333334, 
      0.0033333333333333335`, 0.8664715833333334}, {0.8669181666666667, 
      0.006666666666666667, 0.8669181666666667}, {0.86736475, 0.01, 
      0.86736475}, {0.8678113333333334, 0.013333333333333334`, 
      0.8678113333333334}, {0.8682579166666667, 0.016666666666666666`, 
      0.8682579166666667}, {0.8687045, 0.02, 0.8687045}, {0.8691510833333334, 
      0.023333333333333334`, 0.8691510833333334}, {0.8695976666666667, 
      0.02666666666666667, 0.8695976666666667}, {0.8700442500000001, 0.03, 
      0.8700442500000001}, {0.8704908333333333, 0.03333333333333333, 
      0.8704908333333333}, {0.8709374166666667, 0.03666666666666667, 
      0.8709374166666667}, {0.871384, 0.04, 0.871384}, {0.8718305833333334, 
      0.043333333333333335`, 0.8718305833333334}, {0.8722771666666667, 
      0.04666666666666667, 0.8722771666666667}, {0.87272375, 0.05, 
      0.87272375}, {0.8731703333333334, 0.05333333333333334, 
      0.8731703333333334}, {0.8736169166666667, 0.056666666666666664`, 
      0.8736169166666667}, {0.8740635, 0.06, 0.8740635}, {0.8745100833333334, 
      0.06333333333333334, 0.8745100833333334}, {0.8749566666666667, 
      0.06666666666666667, 0.8749566666666667}, {0.8754032500000001, 0.07, 
      0.8754032500000001}, {0.8758498333333333, 0.07333333333333333, 
      0.8758498333333333}, {0.8762964166666667, 0.07666666666666666, 
      0.8762964166666667}, {0.876743, 0.08, 0.876743}, {0.8771895833333334, 
      0.08333333333333333, 0.8771895833333334}, {0.8776361666666667, 
      0.08666666666666667, 0.8776361666666667}, {0.87808275, 0.09, 
      0.87808275}, {0.8785293333333334, 0.09333333333333334, 
      0.8785293333333334}, {0.8789759166666667, 0.09666666666666666, 
      0.8789759166666667}, {0.8794225, 0.1, 0.8794225}, {0.8798690833333334, 
      0.10333333333333333`, 0.8798690833333334}, {0.8803156666666667, 
      0.10666666666666667`, 0.8803156666666667}, {0.8807622500000001, 0.11, 
      0.8807622500000001}, {0.8812088333333333, 0.11333333333333333`, 
      0.8812088333333333}, {0.8816554166666667, 0.11666666666666667`, 
      0.8816554166666667}, {0.882102, 0.12, 0.882102}, {0.8825485833333334, 
      0.12333333333333334`, 0.8825485833333334}, {0.8829951666666667, 
      0.12666666666666668`, 0.8829951666666667}, {0.88344175, 0.13, 
      0.88344175}, {0.8838883333333334, 0.13333333333333333`, 
      0.8838883333333334}, {0.8843349166666667, 0.13666666666666666`, 
      0.8843349166666667}, {0.8847815, 0.14, 0.8847815}, {0.8852280833333334, 
      0.14333333333333334`, 0.8852280833333334}, {0.8856746666666667, 
      0.14666666666666667`, 0.8856746666666667}, {0.8861212500000001, 0.15, 
      0.8861212500000001}, {0.8865678333333333, 0.15333333333333332`, 
      0.8865678333333333}, {0.8870144166666667, 0.15666666666666668`, 
      0.8870144166666667}, {0.887461, 0.16, 0.887461}, {0.8879075833333334, 
      0.16333333333333333`, 0.8879075833333334}, {0.8883541666666667, 
      0.16666666666666666`, 0.8883541666666667}, {0.88880075, 0.17, 
      0.88880075}, {0.8892473333333334, 0.17333333333333334`, 
      0.8892473333333334}, {0.8896939166666668, 0.17666666666666667`, 
      0.8896939166666668}, {0.8901405, 0.18, 0.8901405}, {0.8905870833333334, 
      0.18333333333333332`, 0.8905870833333334}, {0.8910336666666667, 
      0.18666666666666668`, 0.8910336666666667}, {0.8914802500000001, 0.19, 
      0.8914802500000001}, {0.8919268333333333, 0.19333333333333333`, 
      0.8919268333333333}, {0.8923734166666667, 0.19666666666666666`, 
      0.8923734166666667}, {0.8928200000000001, 0.2, 0.8928200000000001}, {
      0.8932665833333334, 0.20333333333333334`, 0.8932665833333334}, {
      0.8937131666666667, 0.20666666666666667`, 0.8937131666666667}, {
      0.89415975, 0.21, 0.89415975}, {0.8946063333333334, 
      0.21333333333333335`, 0.8946063333333334}, {0.8950529166666668, 
      0.21666666666666667`, 0.8950529166666668}, {0.8954995, 0.22, 
      0.8954995}, {0.8959460833333334, 0.22333333333333333`, 
      0.8959460833333334}, {0.8963926666666667, 0.22666666666666666`, 
      0.8963926666666667}, {0.8968392500000001, 0.23, 0.8968392500000001}, {
      0.8972858333333333, 0.23333333333333334`, 0.8972858333333333}, {
      0.8977324166666667, 0.23666666666666666`, 0.8977324166666667}, {
      0.8981790000000001, 0.24, 0.8981790000000001}, {0.8986255833333334, 
      0.24333333333333335`, 0.8986255833333334}, {0.8990721666666667, 
      0.24666666666666667`, 0.8990721666666667}, {0.89951875, 0.25, 
      0.89951875}, {0.8999653333333334, 0.25333333333333335`, 
      0.8999653333333334}, {0.9004119166666666, 0.25666666666666665`, 
      0.9004119166666666}, {0.9008585, 0.26, 0.9008585}, {0.9013050833333334, 
      0.2633333333333333, 0.9013050833333334}, {0.9017516666666667, 
      0.26666666666666666`, 0.9017516666666667}, {0.9021982500000001, 0.27, 
      0.9021982500000001}, {0.9026448333333333, 0.2733333333333333, 
      0.9026448333333333}, {0.9030914166666667, 0.27666666666666667`, 
      0.9030914166666667}, {0.9035380000000001, 0.28, 0.9035380000000001}, {
      0.9039845833333333, 0.2833333333333333, 0.9039845833333333}, {
      0.9044311666666667, 0.2866666666666667, 0.9044311666666667}, {
      0.90487775, 0.29, 0.90487775}, {0.9053243333333334, 
      0.29333333333333333`, 0.9053243333333334}, {0.9057709166666668, 
      0.2966666666666667, 0.9057709166666668}, {0.9062175, 0.3, 0.9062175}, {
      0.9066640833333334, 0.30333333333333334`, 0.9066640833333334}, {
      0.9071106666666667, 0.30666666666666664`, 0.9071106666666667}, {
      0.90755725, 0.31, 0.90755725}, {0.9080038333333333, 
      0.31333333333333335`, 0.9080038333333333}, {0.9084504166666667, 
      0.31666666666666665`, 0.9084504166666667}, {0.9088970000000001, 0.32, 
      0.9088970000000001}, {0.9093435833333333, 0.3233333333333333, 
      0.9093435833333333}, {0.9097901666666667, 0.32666666666666666`, 
      0.9097901666666667}, {0.91023675, 0.33, 0.91023675}, {
      0.9106833333333334, 0.3333333333333333, 0.9106833333333334}, {
      0.9111299166666667, 0.33666666666666667`, 0.9111299166666667}, {
      0.9115765, 0.34, 0.9115765}, {0.9120230833333334, 0.3433333333333333, 
      0.9120230833333334}, {0.9124696666666667, 0.3466666666666667, 
      0.9124696666666667}, {0.91291625, 0.35, 0.91291625}, {
      0.9133628333333333, 0.35333333333333333`, 0.9133628333333333}, {
      0.9138094166666667, 0.3566666666666667, 0.9138094166666667}, {
      0.9142560000000001, 0.36, 0.9142560000000001}, {0.9147025833333333, 
      0.36333333333333334`, 0.9147025833333333}, {0.9151491666666667, 
      0.36666666666666664`, 0.9151491666666667}, {0.91559575, 0.37, 
      0.91559575}, {0.9160423333333334, 0.37333333333333335`, 
      0.9160423333333334}, {0.9164889166666667, 0.37666666666666665`, 
      0.9164889166666667}, {0.9169355, 0.38, 0.9169355}, {0.9173820833333334, 
      0.38333333333333336`, 0.9173820833333334}, {0.9178286666666667, 
      0.38666666666666666`, 0.9178286666666667}, {0.91827525, 0.39, 
      0.91827525}, {0.9187218333333333, 0.3933333333333333, 
      0.9187218333333333}, {0.9191684166666667, 0.39666666666666667`, 
      0.9191684166666667}, {0.9196150000000001, 0.4, 0.9196150000000001}, {
      0.9200615833333333, 0.4033333333333333, 0.9200615833333333}, {
      0.9205081666666667, 0.4066666666666667, 0.9205081666666667}, {
      0.92095475, 0.41, 0.92095475}, {0.9214013333333334, 
      0.41333333333333333`, 0.9214013333333334}, {0.9218479166666667, 
      0.4166666666666667, 0.9218479166666667}, {0.9222945, 0.42, 0.9222945}, {
      0.9227410833333334, 0.42333333333333334`, 0.9227410833333334}, {
      0.9231876666666667, 0.4266666666666667, 0.9231876666666667}, {
      0.92363425, 0.43, 0.92363425}, {0.9240808333333334, 
      0.43333333333333335`, 0.9240808333333334}, {0.9245274166666667, 
      0.43666666666666665`, 0.9245274166666667}, {0.9249740000000001, 0.44, 
      0.9249740000000001}, {0.9254205833333333, 0.44333333333333336`, 
      0.9254205833333333}, {0.9258671666666667, 0.44666666666666666`, 
      0.9258671666666667}, {0.92631375, 0.45, 0.92631375}, {
      0.9267603333333334, 0.4533333333333333, 0.9267603333333334}, {
      0.9272069166666667, 0.45666666666666667`, 0.9272069166666667}, {
      0.9276535, 0.46, 0.9276535}, {0.9281000833333334, 0.4633333333333333, 
      0.9281000833333334}, {0.9285466666666667, 0.4666666666666667, 
      0.9285466666666667}, {0.92899325, 0.47, 0.92899325}, {
      0.9294398333333334, 0.47333333333333333`, 0.9294398333333334}, {
      0.9298864166666667, 0.4766666666666667, 0.9298864166666667}, {
      0.9303330000000001, 0.48, 0.9303330000000001}, {0.9307795833333333, 
      0.48333333333333334`, 0.9307795833333333}, {0.9312261666666667, 
      0.4866666666666667, 0.9312261666666667}, {0.93167275, 0.49, 
      0.93167275}, {0.9321193333333334, 0.49333333333333335`, 
      0.9321193333333334}, {0.9325659166666667, 0.49666666666666665`, 
      0.9325659166666667}, {0.9330125, 0.5, 0.9330125}, {0.9334590833333334, 
      0.5033333333333333, 0.9334590833333334}, {0.9339056666666667, 
      0.5066666666666667, 0.9339056666666667}, {0.93435225, 0.51, 
      0.93435225}, {0.9347988333333334, 0.5133333333333333, 
      0.9347988333333334}, {0.9352454166666667, 0.5166666666666667, 
      0.9352454166666667}, {0.935692, 0.52, 0.935692}, {0.9361385833333333, 
      0.5233333333333333, 0.9361385833333333}, {0.9365851666666667, 
      0.5266666666666666, 0.9365851666666667}, {0.93703175, 0.53, 
      0.93703175}, {0.9374783333333334, 0.5333333333333333, 
      0.9374783333333334}, {0.9379249166666667, 0.5366666666666666, 
      0.9379249166666667}, {0.9383715, 0.54, 0.9383715}, {0.9388180833333334, 
      0.5433333333333333, 0.9388180833333334}, {0.9392646666666666, 
      0.5466666666666666, 0.9392646666666666}, {0.93971125, 0.55, 
      0.93971125}, {0.9401578333333334, 0.5533333333333333, 
      0.9401578333333334}, {0.9406044166666667, 0.5566666666666666, 
      0.9406044166666667}, {0.9410510000000001, 0.56, 0.9410510000000001}, {
      0.9414975833333333, 0.5633333333333334, 0.9414975833333333}, {
      0.9419441666666667, 0.5666666666666667, 0.9419441666666667}, {
      0.94239075, 0.57, 0.94239075}, {0.9428373333333333, 0.5733333333333334, 
      0.9428373333333333}, {0.9432839166666667, 0.5766666666666667, 
      0.9432839166666667}, {0.9437305, 0.58, 0.9437305}, {0.9441770833333334, 
      0.5833333333333334, 0.9441770833333334}, {0.9446236666666668, 
      0.5866666666666667, 0.9446236666666668}, {0.94507025, 0.59, 
      0.94507025}, {0.9455168333333334, 0.5933333333333334, 
      0.9455168333333334}, {0.9459634166666667, 0.5966666666666667, 
      0.9459634166666667}, {0.94641, 0.6, 0.94641}, {0.9468565833333333, 
      0.6033333333333334, 0.9468565833333333}, {0.9473031666666667, 
      0.6066666666666667, 0.9473031666666667}, {0.9477497500000001, 0.61, 
      0.9477497500000001}, {0.9481963333333334, 0.6133333333333333, 
      0.9481963333333334}, {0.9486429166666667, 0.6166666666666667, 
      0.9486429166666667}, {0.9490895, 0.62, 0.9490895}, {0.9495360833333334, 
      0.6233333333333333, 0.9495360833333334}, {0.9499826666666666, 
      0.6266666666666667, 0.9499826666666666}, {0.95042925, 0.63, 
      0.95042925}, {0.9508758333333334, 0.6333333333333333, 
      0.9508758333333334}, {0.9513224166666667, 0.6366666666666667, 
      0.9513224166666667}, {0.9517690000000001, 0.64, 0.9517690000000001}, {
      0.9522155833333333, 0.6433333333333333, 0.9522155833333333}, {
      0.9526621666666667, 0.6466666666666666, 0.9526621666666667}, {
      0.9531087500000001, 0.65, 0.9531087500000001}, {0.9535553333333333, 
      0.6533333333333333, 0.9535553333333333}, {0.9540019166666667, 
      0.6566666666666666, 0.9540019166666667}, {0.9544485, 0.66, 0.9544485}, {
      0.9548950833333334, 0.6633333333333333, 0.9548950833333334}, {
      0.9553416666666666, 0.6666666666666666, 0.9553416666666666}, {
      0.95578825, 0.67, 0.95578825}, {0.9562348333333334, 0.6733333333333333, 
      0.9562348333333334}, {0.9566814166666667, 0.6766666666666666, 
      0.9566814166666667}, {0.957128, 0.68, 0.957128}, {0.9575745833333333, 
      0.6833333333333333, 0.9575745833333333}, {0.9580211666666667, 
      0.6866666666666666, 0.9580211666666667}, {0.9584677500000001, 0.69, 
      0.9584677500000001}, {0.9589143333333333, 0.6933333333333334, 
      0.9589143333333333}, {0.9593609166666667, 0.6966666666666667, 
      0.9593609166666667}, {0.9598075, 0.7, 0.9598075}, {0.9602540833333334, 
      0.7033333333333334, 0.9602540833333334}, {0.9607006666666666, 
      0.7066666666666667, 0.9607006666666666}, {0.96114725, 0.71, 
      0.96114725}, {0.9615938333333334, 0.7133333333333334, 
      0.9615938333333334}, {0.9620404166666667, 0.7166666666666667, 
      0.9620404166666667}, {0.962487, 0.72, 0.962487}, {0.9629335833333333, 
      0.7233333333333334, 0.9629335833333333}, {0.9633801666666667, 
      0.7266666666666667, 0.9633801666666667}, {0.9638267500000001, 0.73, 
      0.9638267500000001}, {0.9642733333333333, 0.7333333333333333, 
      0.9642733333333333}, {0.9647199166666667, 0.7366666666666667, 
      0.9647199166666667}, {0.9651665, 0.74, 0.9651665}, {0.9656130833333334, 
      0.7433333333333333, 0.9656130833333334}, {0.9660596666666666, 
      0.7466666666666667, 0.9660596666666666}, {0.96650625, 0.75, 
      0.96650625}, {0.9669528333333334, 0.7533333333333333, 
      0.9669528333333334}, {0.9673994166666667, 0.7566666666666667, 
      0.9673994166666667}, {0.967846, 0.76, 0.967846}, {0.9682925833333333, 
      0.7633333333333333, 0.9682925833333333}, {0.9687391666666667, 
      0.7666666666666667, 0.9687391666666667}, {0.9691857500000001, 0.77, 
      0.9691857500000001}, {0.9696323333333333, 0.7733333333333333, 
      0.9696323333333333}, {0.9700789166666667, 0.7766666666666666, 
      0.9700789166666667}, {0.9705255, 0.78, 0.9705255}, {0.9709720833333333, 
      0.7833333333333333, 0.9709720833333333}, {0.9714186666666667, 
      0.7866666666666666, 0.9714186666666667}, {0.97186525, 0.79, 
      0.97186525}, {0.9723118333333334, 0.7933333333333333, 
      0.9723118333333334}, {0.9727584166666667, 0.7966666666666666, 
      0.9727584166666667}, {0.973205, 0.8, 0.973205}, {0.9736515833333333, 
      0.8033333333333333, 0.9736515833333333}, {0.9740981666666667, 
      0.8066666666666666, 0.9740981666666667}, {0.97454475, 0.81, 
      0.97454475}, {0.9749913333333333, 0.8133333333333334, 
      0.9749913333333333}, {0.9754379166666667, 0.8166666666666667, 
      0.9754379166666667}, {0.9758845, 0.82, 0.9758845}, {0.9763310833333334, 
      0.8233333333333334, 0.9763310833333334}, {0.9767776666666667, 
      0.8266666666666667, 0.9767776666666667}, {0.97722425, 0.83, 
      0.97722425}, {0.9776708333333334, 0.8333333333333334, 
      0.9776708333333334}, {0.9781174166666666, 0.8366666666666667, 
      0.9781174166666666}, {0.978564, 0.84, 0.978564}, {0.9790105833333334, 
      0.8433333333333334, 0.9790105833333334}, {0.9794571666666667, 
      0.8466666666666667, 0.9794571666666667}, {0.9799037500000001, 0.85, 
      0.9799037500000001}, {0.9803503333333333, 0.8533333333333334, 
      0.9803503333333333}, {0.9807969166666667, 0.8566666666666667, 
      0.9807969166666667}, {0.9812435, 0.86, 0.9812435}, {0.9816900833333333, 
      0.8633333333333333, 0.9816900833333333}, {0.9821366666666667, 
      0.8666666666666667, 0.9821366666666667}, {0.98258325, 0.87, 
      0.98258325}, {0.9830298333333334, 0.8733333333333333, 
      0.9830298333333334}, {0.9834764166666667, 0.8766666666666667, 
      0.9834764166666667}, {0.983923, 0.88, 0.983923}, {0.9843695833333334, 
      0.8833333333333333, 0.9843695833333334}, {0.9848161666666667, 
      0.8866666666666667, 0.9848161666666667}, {0.98526275, 0.89, 
      0.98526275}, {0.9857093333333333, 0.8933333333333333, 
      0.9857093333333333}, {0.9861559166666667, 0.8966666666666666, 
      0.9861559166666667}, {0.9866025, 0.9, 0.9866025}, {0.9870490833333334, 
      0.9033333333333333, 0.9870490833333334}, {0.9874956666666667, 
      0.9066666666666666, 0.9874956666666667}, {0.98794225, 0.91, 
      0.98794225}, {0.9883888333333334, 0.9133333333333333, 
      0.9883888333333334}, {0.9888354166666666, 0.9166666666666666, 
      0.9888354166666666}, {0.989282, 0.92, 0.989282}, {0.9897285833333334, 
      0.9233333333333333, 0.9897285833333334}, {0.9901751666666667, 
      0.9266666666666666, 0.9901751666666667}, {0.99062175, 0.93, 
      0.99062175}, {0.9910683333333333, 0.9333333333333333, 
      0.9910683333333333}, {0.9915149166666667, 0.9366666666666666, 
      0.9915149166666667}, {0.9919615, 0.94, 0.9919615}, {0.9924080833333333, 
      0.9433333333333334, 0.9924080833333333}, {0.9928546666666667, 
      0.9466666666666667, 0.9928546666666667}, {0.99330125, 0.95, 
      0.99330125}, {0.9937478333333334, 0.9533333333333334, 
      0.9937478333333334}, {0.9941944166666667, 0.9566666666666667, 
      0.9941944166666667}, {0.994641, 0.96, 0.994641}, {0.9950875833333334, 
      0.9633333333333334, 0.9950875833333334}, {0.9955341666666667, 
      0.9666666666666667, 0.9955341666666667}, {0.99598075, 0.97, 
      0.99598075}, {0.9964273333333333, 0.9733333333333334, 
      0.9964273333333333}, {0.9968739166666667, 0.9766666666666667, 
      0.9968739166666667}, {0.9973205, 0.98, 0.9973205}, {0.9977670833333334, 
      0.9833333333333333, 0.9977670833333334}, {0.9982136666666667, 
      0.9866666666666667, 0.9982136666666667}, {0.99866025, 0.99, 
      0.99866025}, {0.9991068333333334, 0.9933333333333333, 
      0.9991068333333334}, {0.9995534166666666, 0.9966666666666667, 
      0.9995534166666666}, {1., 1, 1.}}}]],
  AspectRatio->0.2,
  ImageSize->{713., Automatic}]], "Output",
 CellChangeTimes->{{3.49032582561425*^9, 3.490325849161125*^9}, 
   3.4904778751184998`*^9, 3.4904783194153748`*^9, 3.4904784623372498`*^9, 
   3.4904786219778748`*^9, 3.4904788405091248`*^9, 3.4904789386497498`*^9, 
   3.4904801656653748`*^9, 3.4904852934778748`*^9, 3.4904860021809998`*^9, 
   3.4904863461653748`*^9, 3.4904863973059998`*^9, 3.4905709021497498`*^9, 
   3.4905711766341248`*^9, 3.4905712969778748`*^9, 3.4905715435872498`*^9, 
   3.4905721474309998`*^9, 3.576522506888875*^9, 3.735065621019402*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Colors", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ColorDefs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"fnred", "[", "i", "]"}], "*", "1."}], ",", 
       RowBox[{
        RowBox[{"fngrn", "[", "i", "]"}], "*", "1."}], ",", 
       RowBox[{
        RowBox[{"fnblu", "[", "i", "]"}], "*", "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "lo", ",", "hi"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<N:\\\\Documents\\\\0 RA\\\\Software\\\\Radio-Sky Spectrograph\\\\Color \
File Maker\\\\AJ4CO_Rainbow - for Autoplot.csv\>\"", ",", "ColorDefs"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.7350657250207777`*^9, 3.7350658173188725`*^9}, {
   3.735065884476021*^9, 3.7350659001793594`*^9}, 3.7350675354507003`*^9}],

Cell[BoxData["\<\"N:\\\\Documents\\\\0 RA\\\\Software\\\\Radio-Sky \
Spectrograph\\\\Color File Maker\\\\AJ4CO-Rainbow-Autoplot.csv\"\>"], "Output",
 CellChangeTimes->{3.7350658317253137`*^9, 3.7350659093357334`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 907},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->14.4},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (32-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1175, 26, 140, "Section"],
Cell[CellGroupData[{
Cell[1745, 50, 280, 6, 44, "Section"],
Cell[CellGroupData[{
Cell[2050, 60, 6906, 189, 597, "Input"],
Cell[8959, 251, 10175, 176, 244, "Output"],
Cell[19137, 429, 42847, 614, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62021, 1048, 12536, 302, 787, "Input"],
Cell[74560, 1352, 7333, 121, 367, "Output"],
Cell[81896, 1475, 33233, 547, 250, "Output"],
Cell[115132, 2024, 229567, 3439, 88, "Output"],
Cell[CellGroupData[{
Cell[344724, 5467, 1567, 26, 23, "Print"],
Cell[346294, 5495, 1620, 27, 23, "Print"],
Cell[347917, 5524, 1570, 26, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[349536, 5556, 5504, 145, 452, "Input"],
Cell[355043, 5703, 7987, 140, 243, "Output"],
Cell[363033, 5845, 37512, 568, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[400582, 6418, 6418, 175, 632, "Input"],
Cell[407003, 6595, 36444, 608, 461, "Output"],
Cell[443450, 7205, 539051, 7953, 158, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[982538, 15163, 896, 23, 72, "Input"],
Cell[983437, 15188, 216, 2, 31, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
